/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.layer;

import geotrellis.layer.LayoutDefinition;
import geotrellis.layer.LayoutLevel;
import geotrellis.layer.LayoutScheme;
import geotrellis.layer.ZoomedLayoutScheme$;
import geotrellis.layer.package$;
import geotrellis.layer.package$CRSWorldExtent$;
import geotrellis.proj4.CRS;
import geotrellis.proj4.LatLng$;
import geotrellis.proj4.util.UTM$;
import geotrellis.raster.CellSize;
import geotrellis.raster.TileLayout;
import geotrellis.util.Haversine$;
import geotrellis.vector.Extent;
import geotrellis.vector.Point$;
import org.locationtech.jts.geom.Point;
import scala.MatchError;
import scala.Tuple2;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005}t!\u0002\u0011\"\u0011\u00031c!\u0002\u0015\"\u0011\u0003I\u0003\"B\u001a\u0002\t\u0003!\u0004bB\u001b\u0002\u0005\u0004%\tA\u000e\u0005\u0007u\u0005\u0001\u000b\u0011B\u001c\t\u000fm\n!\u0019!C\u0001y!1\u0001)\u0001Q\u0001\nuBq!Q\u0001C\u0002\u0013\u0005a\u0007\u0003\u0004C\u0003\u0001\u0006Ia\u000e\u0005\u0006\u0007\u0006!\t\u0001\u0012\u0005\u0006\u000f\u0006!\t\u0001\u0013\u0005\u0006\u0015\u0006!\ta\u0013\u0005\n\u0003s\t\u0011\u0013!C\u0001\u0003wA\u0011\"!\u0015\u0002#\u0003%\t!a\u0015\t\u000f\u0005]\u0013\u0001\"\u0001\u0002Z!I\u0011\u0011N\u0001\u0012\u0002\u0013\u0005\u00111\b\u0005\n\u0003W\n\u0011\u0011!C\u0005\u0003[2A\u0001K\u0011\u0001\u001b\"A\u0011+\u0005BC\u0002\u0013\u0005!\u000b\u0003\u0005Z#\t\u0005\t\u0015!\u0003T\u0011!Q\u0016C!b\u0001\n\u0003a\u0004\u0002C.\u0012\u0005\u0003\u0005\u000b\u0011B\u001f\t\u0011q\u000b\"Q1A\u0005\u0002YB\u0001\"X\t\u0003\u0002\u0003\u0006Ia\u000e\u0005\u0006gE!\tA\u0018\u0005\u0006EF!\ta\u0019\u0005\u0006aF!\t!\u001d\u0005\u0006}F!\ta \u0005\u0007}F!\t!!\u0002\t\u000f\u00055\u0011\u0003\"\u0001\u0002\u0010!9\u00111C\t\u0005\u0002\u0005U\u0001bBA\r#\u0011\u0005\u00131D\u0001\u00135>|W.\u001a3MCf|W\u000f^*dQ\u0016lWM\u0003\u0002#G\u0005)A.Y=fe*\tA%\u0001\u0006hK>$(/\u001a7mSN\u001c\u0001\u0001\u0005\u0002(\u00035\t\u0011E\u0001\n[_>lW\r\u001a'bs>,HoU2iK6,7cA\u0001+aA\u00111FL\u0007\u0002Y)\tQ&A\u0003tG\u0006d\u0017-\u0003\u00020Y\t1\u0011I\\=SK\u001a\u0004\"aK\u0019\n\u0005Ib#\u0001D*fe&\fG.\u001b>bE2,\u0017A\u0002\u001fj]&$h\bF\u0001'\u0003M)\u0015I\u0015+I?\u000eK%kQ+N\r\u0016\u0013VIT\"F+\u00059\u0004CA\u00169\u0013\tIDF\u0001\u0004E_V\u0014G.Z\u0001\u0015\u000b\u0006\u0013F\u000bS0D\u0013J\u001bU+\u0014$F%\u0016s5)\u0012\u0011\u0002#\u0011+e)Q+M)~#\u0016\nT#`'&SV)F\u0001>!\tYc(\u0003\u0002@Y\t\u0019\u0011J\u001c;\u0002%\u0011+e)Q+M)~#\u0016\nT#`'&SV\tI\u0001\u001d\t\u00163\u0015)\u0016'U?J+5k\u0014'V)&{ej\u0018+I%\u0016\u001b\u0006j\u0014'E\u0003u!UIR!V\u0019R{&+R*P\u0019V#\u0016j\u0014(`)\"\u0013Vi\u0015%P\u0019\u0012\u0003\u0013!\u00057bs>,HoQ8mg\u001a{'OW8p[R\u0011Q(\u0012\u0005\u0006\r&\u0001\r!P\u0001\u0006Y\u00164X\r\\\u0001\u0012Y\u0006Lx.\u001e;S_^\u001chi\u001c:[_>lGCA\u001fJ\u0011\u00151%\u00021\u0001>\u0003\u0015\t\u0007\u000f\u001d7z)\u001da\u00151GA\u001b\u0003o\u0001\"aJ\t\u0014\u0007EQc\n\u0005\u0002(\u001f&\u0011\u0001+\t\u0002\r\u0019\u0006Lx.\u001e;TG\",W.Z\u0001\u0004GJ\u001cX#A*\u0011\u0005Q;V\"A+\u000b\u0005Y\u001b\u0013!\u00029s_*$\u0014B\u0001-V\u0005\r\u0019%kU\u0001\u0005GJ\u001c\b%\u0001\u0005uS2,7+\u001b>f\u0003%!\u0018\u000e\\3TSj,\u0007%A\nsKN|G.\u001e;j_:$\u0006N]3tQ>dG-\u0001\u000bsKN|G.\u001e;j_:$\u0006N]3tQ>dG\r\t\u000b\u0005\u0019~\u0003\u0017\rC\u0003R1\u0001\u00071\u000bC\u0003[1\u0001\u0007Q\bC\u0003]1\u0001\u0007q'\u0001\u0003{_>lG\u0003B\u001feM\"DQ!Z\rA\u0002]\n\u0011\u0001\u001f\u0005\u0006Of\u0001\raN\u0001\u0002s\")\u0011.\u0007a\u0001U\u0006A1-\u001a7m'&TX\r\u0005\u0002l]6\tAN\u0003\u0002nG\u00051!/Y:uKJL!a\u001c7\u0003\u0011\r+G\u000e\\*ju\u0016\f\u0001\u0002\\3wK24uN\u001d\u000b\u0004eVl\bCA\u0014t\u0013\t!\u0018EA\u0006MCf|W\u000f\u001e'fm\u0016d\u0007\"\u0002<\u001b\u0001\u00049\u0018AB3yi\u0016tG\u000f\u0005\u0002yw6\t\u0011P\u0003\u0002{G\u00051a/Z2u_JL!\u0001`=\u0003\r\u0015CH/\u001a8u\u0011\u0015I'\u00041\u0001k\u00031aWM^3m\r>\u0014(l\\8n)\r\u0011\u0018\u0011\u0001\u0005\u0007\u0003\u0007Y\u0002\u0019A\u001f\u0002\u0005%$G#\u0002:\u0002\b\u0005-\u0001BBA\u00059\u0001\u0007q/A\u0006x_JdG-\u0012=uK:$\bBBA\u00029\u0001\u0007Q(A\u0004{_>lw*\u001e;\u0015\u0007I\f\t\u0002C\u0003G;\u0001\u0007!/\u0001\u0004{_>l\u0017J\u001c\u000b\u0004e\u0006]\u0001\"\u0002$\u001f\u0001\u0004\u0011\u0018\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005u\u0001\u0003BA\u0010\u0003[qA!!\t\u0002*A\u0019\u00111\u0005\u0017\u000e\u0005\u0005\u0015\"bAA\u0014K\u00051AH]8pizJ1!a\u000b-\u0003\u0019\u0001&/\u001a3fM&!\u0011qFA\u0019\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0006\u0017\t\u000bE[\u0001\u0019A*\t\u000fi[\u0001\u0013!a\u0001{!9Al\u0003I\u0001\u0002\u00049\u0014aD1qa2LH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005u\"fA\u001f\u0002@-\u0012\u0011\u0011\t\t\u0005\u0003\u0007\ni%\u0004\u0002\u0002F)!\u0011qIA%\u0003%)hn\u00195fG.,GMC\u0002\u0002L1\n!\"\u00198o_R\fG/[8o\u0013\u0011\ty%!\u0012\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t)FK\u00028\u0003\u007f\tQ\u0002\\1z_V$hi\u001c:[_>lG\u0003CA.\u0003C\n\u0019'a\u001a\u0011\u0007\u001d\ni&C\u0002\u0002`\u0005\u0012\u0001\u0003T1z_V$H)\u001a4j]&$\u0018n\u001c8\t\u000b\tt\u0001\u0019A\u001f\t\r\u0005\u0015d\u00021\u0001x\u00031a\u0017-_8vi\u0016CH/\u001a8u\u0011\u001dQf\u0002%AA\u0002u\nq\u0003\\1z_V$hi\u001c:[_>lG\u0005Z3gCVdG\u000fJ\u001a\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003_\u0002B!!\u001d\u0002|5\u0011\u00111\u000f\u0006\u0005\u0003k\n9(\u0001\u0003mC:<'BAA=\u0003\u0011Q\u0017M^1\n\t\u0005u\u00141\u000f\u0002\u0007\u001f\nTWm\u0019;")
public class ZoomedLayoutScheme
implements LayoutScheme {
    private final CRS crs;
    private final int tileSize;
    private final double resolutionThreshold;

    public static int layoutForZoom$default$3() {
        return ZoomedLayoutScheme$.MODULE$.layoutForZoom$default$3();
    }

    public static LayoutDefinition layoutForZoom(int n, Extent extent, int n2) {
        return ZoomedLayoutScheme$.MODULE$.layoutForZoom(n, extent, n2);
    }

    public static double apply$default$3() {
        return ZoomedLayoutScheme$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return ZoomedLayoutScheme$.MODULE$.apply$default$2();
    }

    public static ZoomedLayoutScheme apply(CRS cRS, int n, double d) {
        return ZoomedLayoutScheme$.MODULE$.apply(cRS, n, d);
    }

    public static int layoutRowsForZoom(int n) {
        return ZoomedLayoutScheme$.MODULE$.layoutRowsForZoom(n);
    }

    public static int layoutColsForZoom(int n) {
        return ZoomedLayoutScheme$.MODULE$.layoutColsForZoom(n);
    }

    public static double DEFAULT_RESOLUTION_THRESHOLD() {
        return ZoomedLayoutScheme$.MODULE$.DEFAULT_RESOLUTION_THRESHOLD();
    }

    public static int DEFAULT_TILE_SIZE() {
        return ZoomedLayoutScheme$.MODULE$.DEFAULT_TILE_SIZE();
    }

    public static double EARTH_CIRCUMFERENCE() {
        return ZoomedLayoutScheme$.MODULE$.EARTH_CIRCUMFERENCE();
    }

    public CRS crs() {
        return this.crs;
    }

    public int tileSize() {
        return this.tileSize;
    }

    public double resolutionThreshold() {
        return this.resolutionThreshold;
    }

    public int zoom(double x, double y, CellSize cellSize) {
        double d;
        Point ll1 = geotrellis.vector.package$.MODULE$.ReprojectPoint(Point$.MODULE$.apply(x + cellSize.width(), y + cellSize.height())).reproject(this.crs(), (CRS)LatLng$.MODULE$);
        Point ll2 = geotrellis.vector.package$.MODULE$.ReprojectPoint(Point$.MODULE$.apply(x, y)).reproject(this.crs(), (CRS)LatLng$.MODULE$);
        if (UTM$.MODULE$.inValidZone(geotrellis.vector.package$.MODULE$.withExtraPointMethods(ll1).y())) {
            CRS utmCrs = UTM$.MODULE$.getZoneCrs(geotrellis.vector.package$.MODULE$.withExtraPointMethods(ll1).x(), geotrellis.vector.package$.MODULE$.withExtraPointMethods(ll1).y());
            Tuple2 tuple2 = new Tuple2((Object)geotrellis.vector.package$.MODULE$.ReprojectPoint(ll1).reproject((CRS)LatLng$.MODULE$, utmCrs), (Object)geotrellis.vector.package$.MODULE$.ReprojectPoint(ll2).reproject((CRS)LatLng$.MODULE$, utmCrs));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Point p1 = (Point)tuple2._1();
            Point p2 = (Point)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)p1, (Object)p2);
            Tuple2 tuple23 = tuple22;
            Point p12 = (Point)tuple23._1();
            Point p22 = (Point)tuple23._2();
            d = scala.math.package$.MODULE$.max(scala.math.package$.MODULE$.abs(geotrellis.vector.package$.MODULE$.withExtraPointMethods(p12).x() - geotrellis.vector.package$.MODULE$.withExtraPointMethods(p22).x()), scala.math.package$.MODULE$.abs(geotrellis.vector.package$.MODULE$.withExtraPointMethods(p12).y() - geotrellis.vector.package$.MODULE$.withExtraPointMethods(p22).y()));
        } else {
            d = Haversine$.MODULE$.apply(geotrellis.vector.package$.MODULE$.withExtraPointMethods(ll1).x(), geotrellis.vector.package$.MODULE$.withExtraPointMethods(ll1).y(), geotrellis.vector.package$.MODULE$.withExtraPointMethods(ll2).x(), geotrellis.vector.package$.MODULE$.withExtraPointMethods(ll2).y());
        }
        double dist = d;
        int z = (int)(scala.math.package$.MODULE$.log(ZoomedLayoutScheme$.MODULE$.EARTH_CIRCUMFERENCE() / (dist * (double)this.tileSize())) / scala.math.package$.MODULE$.log(2.0));
        double zRes = ZoomedLayoutScheme$.MODULE$.EARTH_CIRCUMFERENCE() / (scala.math.package$.MODULE$.pow(2.0, (double)z) * (double)this.tileSize());
        double nextZRes = ZoomedLayoutScheme$.MODULE$.EARTH_CIRCUMFERENCE() / (scala.math.package$.MODULE$.pow(2.0, (double)(z + 1)) * (double)this.tileSize());
        double delta = zRes - nextZRes;
        double diff = zRes - dist;
        int zoom = diff / delta > this.resolutionThreshold() ? z + 1 : z;
        return zoom;
    }

    @Override
    public LayoutLevel levelFor(Extent extent, CellSize cellSize) {
        Extent worldExtent = package$CRSWorldExtent$.MODULE$.worldExtent$extension(package$.MODULE$.CRSWorldExtent(this.crs()));
        int l = this.zoom(extent.xmin(), extent.ymin(), cellSize);
        return this.levelForZoom(worldExtent, l);
    }

    public LayoutLevel levelForZoom(int id) {
        return this.levelForZoom(package$CRSWorldExtent$.MODULE$.worldExtent$extension(package$.MODULE$.CRSWorldExtent(this.crs())), id);
    }

    public LayoutLevel levelForZoom(Extent worldExtent, int id) {
        if (id < 0) {
            throw scala.sys.package$.MODULE$.error("TMS Tiling scheme does not have levels below 0");
        }
        return new LayoutLevel(id, new LayoutDefinition(worldExtent, new TileLayout(ZoomedLayoutScheme$.MODULE$.layoutColsForZoom(id), ZoomedLayoutScheme$.MODULE$.layoutRowsForZoom(id), this.tileSize(), this.tileSize())));
    }

    @Override
    public LayoutLevel zoomOut(LayoutLevel level) {
        LayoutDefinition layout = level.layout();
        int newZoom = level.zoom() - 1;
        int newSize = (int)scala.math.package$.MODULE$.pow(2.0, (double)newZoom);
        return new LayoutLevel(newZoom, new LayoutDefinition(layout.extent(), new TileLayout(newSize, newSize, layout.tileCols(), layout.tileRows())));
    }

    @Override
    public LayoutLevel zoomIn(LayoutLevel level) {
        LayoutDefinition layout = level.layout();
        int newZoom = level.zoom() + 1;
        int newSize = (int)scala.math.package$.MODULE$.pow(2.0, (double)newZoom);
        return new LayoutLevel(newZoom, new LayoutDefinition(layout.extent(), new TileLayout(newSize, newSize, layout.tileCols(), layout.tileRows())));
    }

    public String toString() {
        return new StringBuilder(22).append("ZoomedLayoutScheme(").append(this.crs()).append(",").append(this.tileSize()).append(",").append(this.resolutionThreshold()).append(")").toString();
    }

    public ZoomedLayoutScheme(CRS crs, int tileSize, double resolutionThreshold) {
        this.crs = crs;
        this.tileSize = tileSize;
        this.resolutionThreshold = resolutionThreshold;
    }
}

