/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.layer;

import cats.Apply;
import cats.data.NonEmptyList;
import cats.data.Validated;
import geotrellis.layer.LayoutDefinition;
import geotrellis.raster.CellSize;
import geotrellis.raster.GridExtent;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.TileLayout;
import geotrellis.raster.TileLayout$;
import geotrellis.vector.Extent;
import geotrellis.vector.Extent$;
import io.circe.Codec;
import io.circe.Decoder$;
import io.circe.DecodingFailure;
import io.circe.HCursor;
import io.circe.JsonObject;
import io.circe.JsonObject$;
import io.circe.generic.codec.DerivedAsObjectCodec;
import io.circe.generic.codec.DerivedAsObjectCodec$;
import io.circe.generic.codec.ReprAsObjectCodec;
import io.circe.generic.decoding.ReprDecoder$;
import io.circe.generic.semiauto$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.immutable.Vector$;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichDouble$;
import scala.runtime.SymbolLiteral;
import scala.util.Either;
import shapeless.;
import shapeless.DefaultSymbolicLabelling$;
import shapeless.Generic$;
import shapeless.HList;
import shapeless.HNil;
import shapeless.HNil$;
import shapeless.LabelledGeneric$;
import shapeless.Lazy$;
import shapeless.Witness$;
import shapeless.ops.hlist;
import spire.math.Integral;
import spire.math.Integral$;

public final class LayoutDefinition$
implements scala.Serializable {
    public static LayoutDefinition$ MODULE$;
    private final Codec.AsObject<LayoutDefinition> codecForLayoutDefinition;

    static {
        new LayoutDefinition$();
    }

    public <N> LayoutDefinition apply(GridExtent<N> grid, int tileSize, Integral<N> evidence$1) {
        return this.apply(grid, tileSize, tileSize, evidence$1);
    }

    public <N> LayoutDefinition apply(GridExtent<N> grid, int tileCols, int tileRows, Integral<N> evidence$2) {
        Extent extent = grid.extent();
        CellSize cellSize = grid.cellSize();
        double totalPixelWidth = extent.width() / cellSize.width();
        double totalPixelHeight = extent.height() / cellSize.height();
        int tileLayoutCols = (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(totalPixelWidth / (double)tileCols));
        int tileLayoutRows = (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(totalPixelHeight / (double)tileRows));
        TileLayout layout = new TileLayout(tileLayoutCols, tileLayoutRows, tileCols, tileRows);
        Extent layoutExtent = new Extent(extent.xmin(), extent.ymax() - (double)layout.totalRows() * cellSize.height(), extent.xmin() + (double)layout.totalCols() * cellSize.width(), extent.ymax());
        return new LayoutDefinition(layoutExtent, layout);
    }

    public LayoutDefinition apply(RasterExtent grid, int tileCols, int tileRows) {
        return this.apply((GridExtent)grid.toGridType((Integral)Integral$.MODULE$.LongIsIntegral()), tileCols, tileRows, (Integral)Integral$.MODULE$.LongIsIntegral());
    }

    public LayoutDefinition apply(RasterExtent grid, int tileSize) {
        return this.apply((GridExtent)grid.toGridType((Integral)Integral$.MODULE$.LongIsIntegral()), tileSize, tileSize, (Integral)Integral$.MODULE$.LongIsIntegral());
    }

    public Codec.AsObject<LayoutDefinition> codecForLayoutDefinition() {
        return this.codecForLayoutDefinition;
    }

    public LayoutDefinition apply(Extent extent, TileLayout tileLayout) {
        return new LayoutDefinition(extent, tileLayout);
    }

    public Option<Tuple2<Extent, TileLayout>> unapply(LayoutDefinition x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)x$0.extent(), (Object)x$0.tileLayout()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private LayoutDefinition$() {
        MODULE$ = this;
        public final class Geotrellis_layer_LayoutDefinition$anon$lazy$macro$11$1
        implements scala.Serializable {
            private ReprAsObjectCodec<.colon.colon<Extent, .colon.colon<TileLayout, HNil>>> inst$macro$10;
            private DerivedAsObjectCodec<LayoutDefinition> inst$macro$1;
            private volatile byte bitmap$0;

            private ReprAsObjectCodec<.colon.colon<Extent, .colon.colon<TileLayout, HNil>>> inst$macro$10$lzycompute() {
                Geotrellis_layer_LayoutDefinition$anon$lazy$macro$11$1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 1) == 0) {
                        this.inst$macro$10 = new ReprAsObjectCodec<.colon.colon<Extent, .colon.colon<TileLayout, HNil>>>(null){
                            private final Codec.AsObject<Extent> circeGenericDecoderForextent;
                            private final Codec.AsObject<TileLayout> circeGenericDecoderFortileLayout;
                            private final Codec.AsObject<Extent> circeGenericEncoderForextent;
                            private final Codec.AsObject<TileLayout> circeGenericEncoderFortileLayout;

                            public final JsonObject encodeObject(.colon.colon<Extent, .colon.colon<TileLayout, HNil>> a) {
                                .colon.colon<Extent, .colon.colon<TileLayout, HNil>> colon2 = a;
                                if (colon2 != null) {
                                    Extent circeGenericHListBindingForextent = (Extent)colon2.head();
                                    .colon.colon colon3 = (.colon.colon)colon2.tail();
                                    if (colon3 != null) {
                                        TileLayout circeGenericHListBindingFortileLayout = (TileLayout)colon3.head();
                                        HNil hNil = (HNil)colon3.tail();
                                        if (HNil$.MODULE$.equals(hNil)) {
                                            return JsonObject$.MODULE$.fromIterable((Iterable)Vector$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)"extent", (Object)this.circeGenericEncoderForextent.apply((Object)circeGenericHListBindingForextent)), new Tuple2((Object)"tileLayout", (Object)this.circeGenericEncoderFortileLayout.apply((Object)circeGenericHListBindingFortileLayout))})));
                                        }
                                    }
                                }
                                throw new MatchError(colon2);
                            }

                            public final Either<DecodingFailure, .colon.colon<Extent, .colon.colon<TileLayout, HNil>>> apply(HCursor c) {
                                return (Either)ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForextent.tryDecode(c.downField("extent")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderFortileLayout.tryDecode(c.downField("tileLayout")), (Object)ReprDecoder$.MODULE$.hnilResult(), (Apply)Decoder$.MODULE$.resultInstance()), (Apply)Decoder$.MODULE$.resultInstance());
                            }

                            public final Validated<NonEmptyList<DecodingFailure>, .colon.colon<Extent, .colon.colon<TileLayout, HNil>>> decodeAccumulating(HCursor c) {
                                return (Validated)ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderForextent.tryDecodeAccumulating(c.downField("extent")), ReprDecoder$.MODULE$.consResults((Object)this.circeGenericDecoderFortileLayout.tryDecodeAccumulating(c.downField("tileLayout")), (Object)ReprDecoder$.MODULE$.hnilResultAccumulating(), (Apply)Decoder$.MODULE$.accumulatingResultInstance()), (Apply)Decoder$.MODULE$.accumulatingResultInstance());
                            }
                            {
                                this.circeGenericDecoderForextent = Extent$.MODULE$.codecForExtent();
                                this.circeGenericDecoderFortileLayout = TileLayout$.MODULE$.codecForTileLayout();
                                this.circeGenericEncoderForextent = Extent$.MODULE$.codecForExtent();
                                this.circeGenericEncoderFortileLayout = TileLayout$.MODULE$.codecForTileLayout();
                            }
                        };
                        this.bitmap$0 = (byte)(this.bitmap$0 | 1);
                    }
                }
                return this.inst$macro$10;
            }

            public ReprAsObjectCodec<.colon.colon<Extent, .colon.colon<TileLayout, HNil>>> inst$macro$10() {
                if ((byte)(this.bitmap$0 & 1) == 0) {
                    return this.inst$macro$10$lzycompute();
                }
                return this.inst$macro$10;
            }

            private DerivedAsObjectCodec<LayoutDefinition> inst$macro$1$lzycompute() {
                Geotrellis_layer_LayoutDefinition$anon$lazy$macro$11$1 var1_1 = this;
                synchronized (var1_1) {
                    if ((byte)(this.bitmap$0 & 2) == 0) {
                        this.inst$macro$1 = DerivedAsObjectCodec$.MODULE$.deriveCodec(LabelledGeneric$.MODULE$.materializeProduct(DefaultSymbolicLabelling$.MODULE$.instance((HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "extent"), (HList)new .colon.colon((Object)SymbolLiteral.bootstrap("apply", "tileLayout"), (HList)HNil$.MODULE$))), Generic$.MODULE$.instance((Function1 & Serializable & scala.Serializable)x0$3 -> {
                            LayoutDefinition layoutDefinition = x0$3;
                            if (layoutDefinition != null) {
                                Extent extent$macro$8 = layoutDefinition.extent();
                                TileLayout tileLayout$macro$9 = layoutDefinition.tileLayout();
                                return new .colon.colon((Object)extent$macro$8, (HList)new .colon.colon((Object)tileLayout$macro$9, (HList)HNil$.MODULE$));
                            }
                            throw new MatchError((Object)((Object)layoutDefinition));
                        }, (Function1 & Serializable & scala.Serializable)x0$4 -> {
                            .colon.colon colon2 = x0$4;
                            if (colon2 != null) {
                                Extent extent$macro$6 = (Extent)colon2.head();
                                .colon.colon colon3 = (.colon.colon)colon2.tail();
                                if (colon3 != null) {
                                    TileLayout tileLayout$macro$7 = (TileLayout)colon3.head();
                                    HNil hNil = (HNil)colon3.tail();
                                    if (HNil$.MODULE$.equals(hNil)) {
                                        return new LayoutDefinition(extent$macro$6, tileLayout$macro$7);
                                    }
                                }
                            }
                            throw new MatchError((Object)colon2);
                        }), hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hconsZipWithKeys(hlist.ZipWithKeys$.MODULE$.hnilZipWithKeys(), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "tileLayout"))), Witness$.MODULE$.mkWitness((Object)SymbolLiteral.bootstrap("apply", "extent"))), Predef$.MODULE$.$conforms()), Lazy$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> this.inst$macro$10()));
                        this.bitmap$0 = (byte)(this.bitmap$0 | 2);
                    }
                }
                return this.inst$macro$1;
            }

            public DerivedAsObjectCodec<LayoutDefinition> inst$macro$1() {
                if ((byte)(this.bitmap$0 & 2) == 0) {
                    return this.inst$macro$1$lzycompute();
                }
                return this.inst$macro$1;
            }

            public Geotrellis_layer_LayoutDefinition$anon$lazy$macro$11$1() {
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$inst$macro$1$1(geotrellis.layer.LayoutDefinition ), $anonfun$inst$macro$1$2(shapeless.$colon$colon ), $anonfun$inst$macro$1$3(geotrellis.layer.LayoutDefinition$anon$lazy$macro$11$1 )}, serializedLambda);
            }
        }
        DerivedAsObjectCodec<LayoutDefinition> inst$macro$12 = new Geotrellis_layer_LayoutDefinition$anon$lazy$macro$11$1().inst$macro$1();
        this.codecForLayoutDefinition = semiauto$.MODULE$.deriveCodec(Lazy$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> inst$macro$12));
    }
}

