/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.layer.mapalgebra.local.temporal;

import geotrellis.layer.SpatialKey;
import geotrellis.layer.TemporalKey;
import geotrellis.layer.mapalgebra.local.temporal.TemporalWindowHelper$;
import geotrellis.raster.Tile;
import geotrellis.util.Component;
import geotrellis.util.GetComponent;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import jp.ne.opt.chronoscala.Imports$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.immutable.Map$;
import scala.package$;
import scala.runtime.BoxesRunTime;

public final class LocalTemporalStatistics$ {
    public static LocalTemporalStatistics$ MODULE$;

    static {
        new LocalTemporalStatistics$();
    }

    public <K> Seq<Tuple2<K, Tile>> temporalMin(Seq<Tuple2<K, Tile>> seq, int windowSize, int unit, ZonedDateTime start, ZonedDateTime end, Component<K, SpatialKey> evidence$1, Component<K, TemporalKey> evidence$2) {
        return this.aggregateWithTemporalWindow(seq, windowSize, unit, start, end, (Function1<Traversable<Tile>, Tile>)(Function1 & Serializable & scala.Serializable)tiles -> MODULE$.minReduceOp((Traversable<Tile>)tiles), evidence$1, evidence$2);
    }

    public <K> Seq<Tuple2<K, Tile>> temporalMax(Seq<Tuple2<K, Tile>> seq, int windowSize, int unit, ZonedDateTime start, ZonedDateTime end, Component<K, SpatialKey> evidence$3, Component<K, TemporalKey> evidence$4) {
        return this.aggregateWithTemporalWindow(seq, windowSize, unit, start, end, (Function1<Traversable<Tile>, Tile>)(Function1 & Serializable & scala.Serializable)tiles -> MODULE$.maxReduceOp((Traversable<Tile>)tiles), evidence$3, evidence$4);
    }

    public <K> Seq<Tuple2<K, Tile>> temporalMean(Seq<Tuple2<K, Tile>> seq, int windowSize, int unit, ZonedDateTime start, ZonedDateTime end, Component<K, SpatialKey> evidence$5, Component<K, TemporalKey> evidence$6) {
        return this.aggregateWithTemporalWindow(seq, windowSize, unit, start, end, (Function1<Traversable<Tile>, Tile>)(Function1 & Serializable & scala.Serializable)tiles -> MODULE$.meanReduceOp((Traversable<Tile>)tiles), evidence$5, evidence$6);
    }

    public <K> Seq<Tuple2<K, Tile>> temporalVariance(Seq<Tuple2<K, Tile>> seq, int windowSize, int unit, ZonedDateTime start, ZonedDateTime end, Component<K, SpatialKey> evidence$7, Component<K, TemporalKey> evidence$8) {
        return this.aggregateWithTemporalWindow(seq, windowSize, unit, start, end, (Function1<Traversable<Tile>, Tile>)(Function1 & Serializable & scala.Serializable)tiles -> MODULE$.varianceReduceOp((Traversable<Tile>)tiles), evidence$7, evidence$8);
    }

    public <K> Seq<Tuple2<K, Tile>> aggregateWithTemporalWindow(Seq<Tuple2<K, Tile>> sourceSeq, int windowSize, int unit, ZonedDateTime start, ZonedDateTime end, Function1<Traversable<Tile>, Tile> reduceOp, Component<K, SpatialKey> evidence$9, Component<K, TemporalKey> evidence$10) {
        Seq seq = (Seq)((TraversableLike)sourceSeq.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                Tuple3 tuple3;
                Object key = tuple2._1();
                Tile tile = (Tile)tuple2._2();
                SpatialKey spatialKey = (SpatialKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(key).getComponent((GetComponent)evidence$9);
                if (spatialKey == null) {
                    throw new MatchError((Object)spatialKey);
                }
                int col = spatialKey.col();
                int row = spatialKey.row();
                Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(col, row);
                int col2 = sp2._1$mcI$sp();
                int row2 = sp2._2$mcI$sp();
                ZonedDateTime time = ((TemporalKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(key).getComponent((GetComponent)evidence$10)).time();
                int startDiff = MODULE$.getDifferenceByUnit(unit, start, time);
                int endDiff = MODULE$.getDifferenceByUnit(unit, time, end);
                if (startDiff < 0 && endDiff < 0) {
                    tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)-1), (Object)BoxesRunTime.boxToInteger((int)col2), (Object)BoxesRunTime.boxToInteger((int)row2));
                } else {
                    int timeDelimiter = startDiff / windowSize;
                    tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)timeDelimiter), (Object)BoxesRunTime.boxToInteger((int)col2), (Object)BoxesRunTime.boxToInteger((int)row2));
                }
                Tuple3 newKey = tuple3;
                return new Tuple2((Object)newKey, (Object)new Tuple2(key, (Object)tile));
            }
            throw new MatchError((Object)tuple2);
        }, Seq$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)LocalTemporalStatistics$.$anonfun$aggregateWithTemporalWindow$2(x0$2)));
        return ((MapLike)((TraversableLike)seq.groupBy((Function1 & Serializable & scala.Serializable)x$2 -> (Tuple3)x$2._1()).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 != null) {
                Tuple3 k = (Tuple3)tuple2._1();
                Seq v = (Seq)tuple2._2();
                return new Tuple2((Object)k, v.map((Function1 & Serializable & scala.Serializable)x$3 -> (Tuple2)x$3._2(), Seq$.MODULE$.canBuildFrom()));
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$4 -> {
            Tuple2 tuple2 = x0$4;
            if (tuple2 != null) {
                Seq iter = (Seq)tuple2._2();
                Tuple2 tuple22 = iter.unzip((Function1)Predef$.MODULE$.$conforms());
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                Seq keys = (Seq)tuple22._1();
                Seq tiles = (Seq)tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)keys, (Object)tiles);
                Seq keys2 = (Seq)tuple23._1();
                Seq tiles2 = (Seq)tuple23._2();
                Object key2 = keys2.min(package$.MODULE$.Ordering().by((Function1 & Serializable & scala.Serializable)key -> ((TemporalKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(key).getComponent((GetComponent)evidence$10)).time(), Imports$.MODULE$.zonedDateTimeOrdering()));
                Tile tile = (Tile)reduceOp.apply((Object)tiles2);
                return new Tuple2(key2, (Object)tile);
            }
            throw new MatchError((Object)tuple2);
        }, Map$.MODULE$.canBuildFrom())).toSeq();
    }

    public int getDifferenceByUnit(int unit, ZonedDateTime base, ZonedDateTime time) {
        long l;
        int n = unit;
        if (TemporalWindowHelper$.MODULE$.UnitSeconds() == n) {
            l = ChronoUnit.SECONDS.between(base, time);
        } else if (TemporalWindowHelper$.MODULE$.UnitMinutes() == n) {
            l = ChronoUnit.MINUTES.between(base, time);
        } else if (TemporalWindowHelper$.MODULE$.UnitHours() == n) {
            l = ChronoUnit.HOURS.between(base, time);
        } else if (TemporalWindowHelper$.MODULE$.UnitDays() == n) {
            l = ChronoUnit.DAYS.between(base, time);
        } else if (TemporalWindowHelper$.MODULE$.UnitWeeks() == n) {
            l = ChronoUnit.WEEKS.between(base, time);
        } else if (TemporalWindowHelper$.MODULE$.UnitMonths() == n) {
            l = ChronoUnit.MONTHS.between(base, time);
        } else if (TemporalWindowHelper$.MODULE$.UnitYears() == n) {
            l = ChronoUnit.YEARS.between(base, time);
        } else {
            throw new IllegalStateException(new StringBuilder(10).append("Bad unit ").append(unit).append(".").toString());
        }
        return Math.toIntExact(l);
    }

    public Tile minReduceOp(Traversable<Tile> tiles) {
        return geotrellis.raster.package$.MODULE$.withTileSeqLocalMethods(tiles).localMin();
    }

    public Tile maxReduceOp(Traversable<Tile> tiles) {
        return geotrellis.raster.package$.MODULE$.withTileSeqLocalMethods(tiles).localMax();
    }

    public Tile meanReduceOp(Traversable<Tile> tiles) {
        return geotrellis.raster.package$.MODULE$.withTileSeqLocalMethods(tiles).localMean();
    }

    public Tile varianceReduceOp(Traversable<Tile> tiles) {
        return geotrellis.raster.package$.MODULE$.withTileSeqLocalMethods(tiles).localVariance();
    }

    public static final /* synthetic */ boolean $anonfun$aggregateWithTemporalWindow$2(Tuple2 x0$2) {
        Tuple3 tuple3;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null && (tuple3 = (Tuple3)tuple2._1()) != null) {
            int i = BoxesRunTime.unboxToInt((Object)tuple3._1());
            return i >= 0;
        }
        throw new MatchError((Object)tuple2);
    }

    private LocalTemporalStatistics$() {
        MODULE$ = this;
    }
}

