/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.layer;

import geotrellis.layer.SpatialKey;
import geotrellis.layer.SpatialKey$;
import geotrellis.raster.GridBounds;
import geotrellis.raster.GridBounds$;
import geotrellis.raster.PixelIsArea$;
import geotrellis.raster.PixelSampleType;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.package$;
import geotrellis.raster.rasterize.Rasterizer;
import geotrellis.raster.rasterize.Rasterizer$;
import geotrellis.util.Component;
import geotrellis.vector.Extent;
import geotrellis.vector.MultiLineString$;
import geotrellis.vector.MultiPolygon$;
import java.io.Serializable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\teq!\u0002\u0013&\u0011\u0003Qc!\u0002\u0017&\u0011\u0003i\u0003\"\u0002\u001f\u0002\t\u0003i\u0004\"\u0002 \u0002\t\u0003y\u0004B\u0002 \u0002\t\u0003\ty\u000e\u0003\u0004?\u0003\u0011\u0005\u00111\u001f\u0005\u0007}\u0005!\t!a?\t\ry\nA\u0011\u0001B\u0001\u0011%\u0011I!AA\u0001\n\u0013\u0011YA\u0002\u0003-K\u0001\t\u0005\u0002C'\n\u0005\u000b\u0007I\u0011\u0001(\t\u0011UK!\u0011!Q\u0001\n=C\u0001BV\u0005\u0003\u0006\u0004%\ta\u0016\u0005\t7&\u0011\t\u0011)A\u00051\"AA,\u0003BC\u0002\u0013\u0005q\u000b\u0003\u0005^\u0013\t\u0005\t\u0015!\u0003Y\u0011\u0015a\u0014\u0002\"\u0001_\u0011!\u0011\u0017\u0002#b\u0001\n\u0003\u0019\u0007\u0002C4\n\u0011\u000b\u0007I\u0011A2\t\u000b!LA\u0011A5\t\u000byJA\u0011\u0001:\t\u000bQLA\u0011A;\t\u000byJA\u0011\u0001=\t\u000biLA\u0011A>\t\ryJA\u0011AA\f\u0011\u0019Q\u0018\u0002\"\u0001\u0002\u001c!1a(\u0003C\u0001\u0003KAaAP\u0005\u0005\u0002\u0005-\u0002bBA+\u0013\u0011\u0005\u0011q\u000b\u0005\b\u0003+JA\u0011AA.\u0011\u0019q\u0014\u0002\"\u0001\u0002n!9\u0011QK\u0005\u0005\u0002\u0005E\u0004B\u0002 \n\t\u0003\tY\bC\u0004\u0002\u0002&!\t!a!\t\u000f\u0005}\u0015\u0002\"\u0001\u0002\"\"9\u0011QV\u0005\u0005\u0002\u0005=\u0016aD'ba.+\u0017\u0010\u0016:b]N4wN]7\u000b\u0005\u0019:\u0013!\u00027bs\u0016\u0014(\"\u0001\u0015\u0002\u0015\u001d,w\u000e\u001e:fY2L7o\u0001\u0001\u0011\u0005-\nQ\"A\u0013\u0003\u001f5\u000b\u0007oS3z)J\fgn\u001d4pe6\u001c2!\u0001\u00185!\ty#'D\u00011\u0015\u0005\t\u0014!B:dC2\f\u0017BA\u001a1\u0005\u0019\te.\u001f*fMB\u0011QGO\u0007\u0002m)\u0011q\u0007O\u0001\u0003S>T\u0011!O\u0001\u0005U\u00064\u0018-\u0003\u0002<m\ta1+\u001a:jC2L'0\u00192mK\u00061A(\u001b8jiz\"\u0012AK\u0001\u0006CB\u0004H.\u001f\u000b\u0006\u0001\u0006\u0015\u0017Q\u001b\t\u0003W%\u00192!\u0003\u0018C!\t\u00195J\u0004\u0002E\u0013:\u0011Q\tS\u0007\u0002\r*\u0011q)K\u0001\u0007yI|w\u000e\u001e \n\u0003EJ!A\u0013\u0019\u0002\u000fA\f7m[1hK&\u00111\b\u0014\u0006\u0003\u0015B\na!\u001a=uK:$X#A(\u0011\u0005A\u001bV\"A)\u000b\u0005I;\u0013A\u0002<fGR|'/\u0003\u0002U#\n1Q\t\u001f;f]R\fq!\u001a=uK:$\b%\u0001\u0006mCf|W\u000f^\"pYN,\u0012\u0001\u0017\t\u0003_eK!A\u0017\u0019\u0003\u0007%sG/A\u0006mCf|W\u000f^\"pYN\u0004\u0013A\u00037bs>,HOU8xg\u0006YA.Y=pkR\u0014vn^:!)\u0011\u0001u\fY1\t\u000b5\u0003\u0002\u0019A(\t\u000bY\u0003\u0002\u0019\u0001-\t\u000bq\u0003\u0002\u0019\u0001-\u0002\u0013QLG.Z,jIRDW#\u00013\u0011\u0005=*\u0017B\u000141\u0005\u0019!u.\u001e2mK\u0006QA/\u001b7f\u0011\u0016Lw\r\u001b;\u0002\u001d\u0015DH/\u001a8u)>\u0014u.\u001e8egR\u0011!\u000e\u001d\t\u0003W6t!a\u000b7\n\u0005)+\u0013B\u00018p\u0005)!\u0016\u000e\\3C_VtGm\u001d\u0006\u0003\u0015\u0016BQ!]\nA\u0002=\u000b1b\u001c;iKJ,\u0005\u0010^3oiR\u0011!n\u001d\u0005\u0006cR\u0001\raT\u0001\u000fE>,h\u000eZ:U_\u0016CH/\u001a8u)\tye\u000fC\u0003x+\u0001\u0007!.\u0001\u0006he&$'i\\;oIN$\"aT=\t\u000b]4\u0002\u0019\u00016\u0002\u0015A|\u0017N\u001c;U_.+\u0017\u0010\u0006\u0002}\u007fB\u00111&`\u0005\u0003}\u0016\u0012!b\u00159bi&\fGnS3z\u0011\u001d\t\ta\u0006a\u0001\u0003\u0007\t\u0011\u0001\u001d\t\u0005\u0003\u000b\t\tB\u0004\u0003\u0002\b\u0005=a\u0002BA\u0005\u0003\u001bq1!RA\u0006\u0013\u0005A\u0013B\u0001*(\u0013\tQ\u0015+\u0003\u0003\u0002\u0014\u0005U!!\u0002)pS:$(B\u0001&R)\ra\u0018\u0011\u0004\u0005\b\u0003\u0003A\u0002\u0019AA\u0002)\u0015a\u0018QDA\u0011\u0011\u0019\ty\"\u0007a\u0001I\u0006\t\u0001\u0010\u0003\u0004\u0002$e\u0001\r\u0001Z\u0001\u0002sR)A0a\n\u0002*!1\u0011q\u0004\u000eA\u0002\u0011Da!a\t\u001b\u0001\u0004!W\u0003BA\u0017\u0003\u007f!B!a\f\u0002RQ\u0019q*!\r\t\u0013\u0005M2$!AA\u0004\u0005U\u0012AC3wS\u0012,gnY3%cA)1.a\u000e\u0002<%\u0019\u0011\u0011H8\u0003!M\u0003\u0018\r^5bY\u000e{W\u000e]8oK:$\b\u0003BA\u001f\u0003\u007fa\u0001\u0001B\u0004\u0002Bm\u0011\r!a\u0011\u0003\u0003-\u000bB!!\u0012\u0002LA\u0019q&a\u0012\n\u0007\u0005%\u0003GA\u0004O_RD\u0017N\\4\u0011\u0007=\ni%C\u0002\u0002PA\u00121!\u00118z\u0011\u001d\t\u0019f\u0007a\u0001\u0003w\t1a[3z\u0003-YW-\u001f+p\u000bb$XM\u001c;\u0015\u0007=\u000bI\u0006\u0003\u0004\u0002Tq\u0001\r\u0001`\u000b\u0005\u0003;\nI\u0007\u0006\u0003\u0002`\u0005-DcA(\u0002b!I\u00111M\u000f\u0002\u0002\u0003\u000f\u0011QM\u0001\u000bKZLG-\u001a8dK\u0012\u0012\u0004#B6\u00028\u0005\u001d\u0004\u0003BA\u001f\u0003S\"q!!\u0011\u001e\u0005\u0004\t\u0019\u0005C\u0004\u0002Tu\u0001\r!a\u001a\u0015\u0007=\u000by\u0007\u0003\u0004\u0002Ty\u0001\r\u0001 \u000b\u0006\u001f\u0006M\u0014q\u000f\u0005\u0007\u0003kz\u0002\u0019\u0001-\u0002\u0007\r|G\u000e\u0003\u0004\u0002z}\u0001\r\u0001W\u0001\u0004e><H#B(\u0002~\u0005}\u0004BBA;A\u0001\u0007\u0001\f\u0003\u0004\u0002z\u0001\u0002\r\u0001W\u0001\u0010[VdG/\u001b'j]\u0016$vnS3zgR!\u0011QQAK!\u0015\t9)a$}\u001d\u0011\tI)a#\u0011\u0005\u0015\u0003\u0014bAAGa\u00051\u0001K]3eK\u001aLA!!%\u0002\u0014\n\u00191+\u001a;\u000b\u0007\u00055\u0005\u0007C\u0004\u0002\u0018\u0006\u0002\r!!'\u0002\u00135,H\u000e^5MS:,\u0007\u0003BA\u0003\u00037KA!!(\u0002\u0016\tyQ*\u001e7uS2Kg.Z*ue&tw-\u0001\nnk2$\u0018\u000eU8ms\u001e|g\u000eV8LKf\u001cH\u0003BAC\u0003GCq!!*#\u0001\u0004\t9+\u0001\u0007nk2$\u0018\u000eU8ms\u001e|g\u000e\u0005\u0003\u0002\u0006\u0005%\u0016\u0002BAV\u0003+\u0011A\"T;mi&\u0004v\u000e\\=h_:\fqb[3zg\u001a{'oR3p[\u0016$(/_\u000b\u0005\u0003c\u000bI\f\u0006\u0003\u0002\u0006\u0006M\u0006bBA[G\u0001\u0007\u0011qW\u0001\u0002OB!\u0011QHA]\t\u001d\tYl\tb\u0001\u0003{\u0013\u0011aR\t\u0005\u0003\u000b\ny\f\u0005\u0003\u0002\u0006\u0005\u0005\u0017\u0002BAb\u0003+\u0011\u0001bR3p[\u0016$(/\u001f\u0005\b\u0003\u000f\u001c\u0001\u0019AAe\u0003\r\u0019'o\u001d\t\u0005\u0003\u0017\f\t.\u0004\u0002\u0002N*\u0019\u0011qZ\u0014\u0002\u000bA\u0014xN\u001b\u001b\n\t\u0005M\u0017Q\u001a\u0002\u0004\u0007J\u001b\u0006bBAl\u0007\u0001\u0007\u0011\u0011\\\u0001\u0006Y\u00164X\r\u001c\t\u0004W\u0005m\u0017bAAoK\tYA*Y=pkRdUM^3m)\u0015\u0001\u0015\u0011]Ar\u0011\u001d\t9\r\u0002a\u0001\u0003\u0013Dq!!:\u0005\u0001\u0004\t9/\u0001\tmCf|W\u000f\u001e#j[\u0016t7/[8ogB)\u0011\u0011^Ax16\u0011\u00111\u001e\u0006\u0004\u0003[<\u0013A\u0002:bgR,'/\u0003\u0003\u0002r\u0006-(A\u0003#j[\u0016t7/[8ogR9\u0001)!>\u0002x\u0006e\bbBAd\u000b\u0001\u0007\u0011\u0011\u001a\u0005\u0006-\u0016\u0001\r\u0001\u0017\u0005\u00069\u0016\u0001\r\u0001\u0017\u000b\u0006\u0001\u0006u\u0018q \u0005\u0006\u001b\u001a\u0001\ra\u0014\u0005\b\u0003K4\u0001\u0019AAt)\u001d\u0001%1\u0001B\u0003\u0005\u000fAQ!T\u0004A\u0002=CQAV\u0004A\u0002aCQ\u0001X\u0004A\u0002a\u000bAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"A!\u0004\u0011\t\t=!QC\u0007\u0003\u0005#Q1Aa\u00059\u0003\u0011a\u0017M\\4\n\t\t]!\u0011\u0003\u0002\u0007\u001f\nTWm\u0019;")
public class MapKeyTransform
implements Serializable {
    private double tileWidth;
    private double tileHeight;
    private final Extent extent;
    private final int layoutCols;
    private final int layoutRows;
    private volatile byte bitmap$0;

    public Extent extent() {
        return this.extent;
    }

    public int layoutCols() {
        return this.layoutCols;
    }

    public int layoutRows() {
        return this.layoutRows;
    }

    private double tileWidth$lzycompute() {
        MapKeyTransform mapKeyTransform = this;
        synchronized (mapKeyTransform) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.tileWidth = this.extent().width() / (double)this.layoutCols();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.tileWidth;
    }

    public double tileWidth() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.tileWidth$lzycompute();
        }
        return this.tileWidth;
    }

    private double tileHeight$lzycompute() {
        MapKeyTransform mapKeyTransform = this;
        synchronized (mapKeyTransform) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.tileHeight = this.extent().height() / (double)this.layoutRows();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.tileHeight;
    }

    public double tileHeight() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.tileHeight$lzycompute();
        }
        return this.tileHeight;
    }

    public GridBounds<Object> extentToBounds(Extent otherExtent) {
        return this.apply(otherExtent);
    }

    public GridBounds<Object> apply(Extent otherExtent) {
        SpatialKey spatialKey = this.apply(otherExtent.xmin(), otherExtent.ymax());
        if (spatialKey == null) {
            throw new MatchError((Object)spatialKey);
        }
        int colMin = spatialKey.col();
        int rowMin = spatialKey.row();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(colMin, rowMin);
        int colMin2 = sp2._1$mcI$sp();
        int rowMin2 = sp2._2$mcI$sp();
        double d = (otherExtent.xmax() - this.extent().xmin()) / (this.extent().width() / (double)this.layoutCols());
        int colMax = d == scala.math.package$.MODULE$.floor(d) && d != (double)colMin2 ? (int)d - 1 : (int)d;
        double d2 = (this.extent().ymax() - otherExtent.ymin()) / (this.extent().height() / (double)this.layoutRows());
        int rowMax = d2 == scala.math.package$.MODULE$.floor(d2) && d2 != (double)rowMin2 ? (int)d2 - 1 : (int)d2;
        return GridBounds$.MODULE$.apply(colMin2, rowMin2, colMax, rowMax);
    }

    public Extent boundsToExtent(GridBounds<Object> gridBounds) {
        return this.apply(gridBounds);
    }

    public Extent apply(GridBounds<Object> gridBounds) {
        Extent e1 = this.apply(gridBounds.colMin$mcI$sp(), gridBounds.rowMin$mcI$sp());
        Extent e2 = this.apply(gridBounds.colMax$mcI$sp(), gridBounds.rowMax$mcI$sp());
        return e1.expandToInclude(e2);
    }

    public SpatialKey pointToKey(Point p) {
        return this.apply(p);
    }

    public SpatialKey apply(Point p) {
        return this.apply(geotrellis.vector.package$.MODULE$.withExtraPointMethods(p).x(), geotrellis.vector.package$.MODULE$.withExtraPointMethods(p).y());
    }

    public SpatialKey pointToKey(double x, double y) {
        return this.apply(x, y);
    }

    public SpatialKey apply(double x, double y) {
        double tcol = (x - this.extent().xmin()) / this.extent().width() * (double)this.layoutCols();
        double trow = (this.extent().ymax() - y) / this.extent().height() * (double)this.layoutRows();
        return SpatialKey$.MODULE$.tupToKey((Tuple2<Object, Object>)new Tuple2.mcII.sp((int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(tcol)), (int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper(trow))));
    }

    public <K> Extent apply(K key, Component<K, SpatialKey> evidence$1) {
        return this.apply((SpatialKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(key).getComponent(evidence$1));
    }

    public Extent keyToExtent(SpatialKey key) {
        return this.apply(key.col(), key.row());
    }

    public <K> Extent keyToExtent(K key, Component<K, SpatialKey> evidence$2) {
        return this.keyToExtent((SpatialKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(key).getComponent(evidence$2));
    }

    public Extent apply(SpatialKey key) {
        return this.apply(key.col(), key.row());
    }

    public Extent keyToExtent(int col, int row) {
        return this.apply(col, row);
    }

    public Extent apply(int col, int row) {
        return new Extent(this.extent().xmin() + (double)col * this.tileWidth(), this.extent().ymax() - (double)(row + 1) * this.tileHeight(), this.extent().xmin() + (double)(col + 1) * this.tileWidth(), this.extent().ymax() - (double)row * this.tileHeight());
    }

    public scala.collection.immutable.Set<SpatialKey> multiLineToKeys(MultiLineString multiLine) {
        GridBounds<Object> bounds = this.extentToBounds(geotrellis.vector.package$.MODULE$.withExtraGeometryMethods((Geometry)multiLine).extent());
        Extent boundsExtent = this.boundsToExtent(bounds);
        RasterExtent rasterExtent = RasterExtent$.MODULE$.apply(boundsExtent, bounds.width$mcI$sp(), bounds.height$mcI$sp());
        Set tiles = (Set)Set$.MODULE$.empty();
        Function2.mcVII.sp fn = new Function2.mcVII.sp(null, tiles, bounds){
            private final Set tiles$1;
            private final GridBounds bounds$1;

            public boolean apply$mcZDD$sp(double v1, double v2) {
                return Function2.apply$mcZDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public double apply$mcDDD$sp(double v1, double v2) {
                return Function2.apply$mcDDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public float apply$mcFDD$sp(double v1, double v2) {
                return Function2.apply$mcFDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public int apply$mcIDD$sp(double v1, double v2) {
                return Function2.apply$mcIDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public long apply$mcJDD$sp(double v1, double v2) {
                return Function2.apply$mcJDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public void apply$mcVDD$sp(double v1, double v2) {
                Function2.apply$mcVDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public boolean apply$mcZDI$sp(double v1, int v2) {
                return Function2.apply$mcZDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public double apply$mcDDI$sp(double v1, int v2) {
                return Function2.apply$mcDDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public float apply$mcFDI$sp(double v1, int v2) {
                return Function2.apply$mcFDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public int apply$mcIDI$sp(double v1, int v2) {
                return Function2.apply$mcIDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public long apply$mcJDI$sp(double v1, int v2) {
                return Function2.apply$mcJDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public void apply$mcVDI$sp(double v1, int v2) {
                Function2.apply$mcVDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public boolean apply$mcZDJ$sp(double v1, long v2) {
                return Function2.apply$mcZDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public double apply$mcDDJ$sp(double v1, long v2) {
                return Function2.apply$mcDDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public float apply$mcFDJ$sp(double v1, long v2) {
                return Function2.apply$mcFDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public int apply$mcIDJ$sp(double v1, long v2) {
                return Function2.apply$mcIDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public long apply$mcJDJ$sp(double v1, long v2) {
                return Function2.apply$mcJDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public void apply$mcVDJ$sp(double v1, long v2) {
                Function2.apply$mcVDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public boolean apply$mcZID$sp(int v1, double v2) {
                return Function2.apply$mcZID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public double apply$mcDID$sp(int v1, double v2) {
                return Function2.apply$mcDID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public float apply$mcFID$sp(int v1, double v2) {
                return Function2.apply$mcFID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public int apply$mcIID$sp(int v1, double v2) {
                return Function2.apply$mcIID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public long apply$mcJID$sp(int v1, double v2) {
                return Function2.apply$mcJID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public void apply$mcVID$sp(int v1, double v2) {
                Function2.apply$mcVID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public boolean apply$mcZII$sp(int v1, int v2) {
                return Function2.apply$mcZII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public double apply$mcDII$sp(int v1, int v2) {
                return Function2.apply$mcDII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public float apply$mcFII$sp(int v1, int v2) {
                return Function2.apply$mcFII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public int apply$mcIII$sp(int v1, int v2) {
                return Function2.apply$mcIII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public long apply$mcJII$sp(int v1, int v2) {
                return Function2.apply$mcJII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public boolean apply$mcZIJ$sp(int v1, long v2) {
                return Function2.apply$mcZIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public double apply$mcDIJ$sp(int v1, long v2) {
                return Function2.apply$mcDIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public float apply$mcFIJ$sp(int v1, long v2) {
                return Function2.apply$mcFIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public int apply$mcIIJ$sp(int v1, long v2) {
                return Function2.apply$mcIIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public long apply$mcJIJ$sp(int v1, long v2) {
                return Function2.apply$mcJIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public void apply$mcVIJ$sp(int v1, long v2) {
                Function2.apply$mcVIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public boolean apply$mcZJD$sp(long v1, double v2) {
                return Function2.apply$mcZJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public double apply$mcDJD$sp(long v1, double v2) {
                return Function2.apply$mcDJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public float apply$mcFJD$sp(long v1, double v2) {
                return Function2.apply$mcFJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public int apply$mcIJD$sp(long v1, double v2) {
                return Function2.apply$mcIJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public long apply$mcJJD$sp(long v1, double v2) {
                return Function2.apply$mcJJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public void apply$mcVJD$sp(long v1, double v2) {
                Function2.apply$mcVJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public boolean apply$mcZJI$sp(long v1, int v2) {
                return Function2.apply$mcZJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public double apply$mcDJI$sp(long v1, int v2) {
                return Function2.apply$mcDJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public float apply$mcFJI$sp(long v1, int v2) {
                return Function2.apply$mcFJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public int apply$mcIJI$sp(long v1, int v2) {
                return Function2.apply$mcIJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public long apply$mcJJI$sp(long v1, int v2) {
                return Function2.apply$mcJJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public void apply$mcVJI$sp(long v1, int v2) {
                Function2.apply$mcVJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public boolean apply$mcZJJ$sp(long v1, long v2) {
                return Function2.apply$mcZJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public double apply$mcDJJ$sp(long v1, long v2) {
                return Function2.apply$mcDJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public float apply$mcFJJ$sp(long v1, long v2) {
                return Function2.apply$mcFJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public int apply$mcIJJ$sp(long v1, long v2) {
                return Function2.apply$mcIJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public long apply$mcJJJ$sp(long v1, long v2) {
                return Function2.apply$mcJJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public void apply$mcVJJ$sp(long v1, long v2) {
                Function2.apply$mcVJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public Function1<Object, Function1<Object, BoxedUnit>> curried() {
                return Function2.curried$((Function2)this);
            }

            public Function1<Tuple2<Object, Object>, BoxedUnit> tupled() {
                return Function2.tupled$((Function2)this);
            }

            public String toString() {
                return Function2.toString$((Function2)this);
            }

            public void apply(int col, int row) {
                this.apply$mcVII$sp(col, row);
            }

            public void apply$mcVII$sp(int col, int row) {
                this.tiles$1.$plus$eq((Object)new SpatialKey(this.bounds$1.colMin$mcI$sp() + col, this.bounds$1.rowMin$mcI$sp() + row));
            }
            {
                this.tiles$1 = tiles$1;
                this.bounds$1 = bounds$1;
                Function2.$init$((Function2)this);
            }
        };
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])geotrellis.vector.package$.MODULE$.withExtraMultiLineStringMethods(multiLine).lines()), arg_0 -> MapKeyTransform.$anonfun$multiLineToKeys$1$adapted(rasterExtent, (Function2)fn, arg_0));
        return tiles.toSet();
    }

    public scala.collection.immutable.Set<SpatialKey> multiPolygonToKeys(MultiPolygon multiPolygon) {
        Extent extent = geotrellis.vector.package$.MODULE$.withExtraGeometryMethods((Geometry)multiPolygon).extent();
        GridBounds<Object> bounds = this.extentToBounds(extent);
        Rasterizer.Options options = new Rasterizer.Options(true, (PixelSampleType)PixelIsArea$.MODULE$);
        Extent boundsExtent = this.boundsToExtent(bounds);
        RasterExtent rasterExtent = RasterExtent$.MODULE$.apply(boundsExtent, bounds.width$mcI$sp(), bounds.height$mcI$sp());
        Set tiles = (Set)Set$.MODULE$.empty();
        Function2.mcVII.sp fn = new Function2.mcVII.sp(null, tiles, bounds){
            private final Set tiles$2;
            private final GridBounds bounds$2;

            public boolean apply$mcZDD$sp(double v1, double v2) {
                return Function2.apply$mcZDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public double apply$mcDDD$sp(double v1, double v2) {
                return Function2.apply$mcDDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public float apply$mcFDD$sp(double v1, double v2) {
                return Function2.apply$mcFDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public int apply$mcIDD$sp(double v1, double v2) {
                return Function2.apply$mcIDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public long apply$mcJDD$sp(double v1, double v2) {
                return Function2.apply$mcJDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public void apply$mcVDD$sp(double v1, double v2) {
                Function2.apply$mcVDD$sp$((Function2)this, (double)v1, (double)v2);
            }

            public boolean apply$mcZDI$sp(double v1, int v2) {
                return Function2.apply$mcZDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public double apply$mcDDI$sp(double v1, int v2) {
                return Function2.apply$mcDDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public float apply$mcFDI$sp(double v1, int v2) {
                return Function2.apply$mcFDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public int apply$mcIDI$sp(double v1, int v2) {
                return Function2.apply$mcIDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public long apply$mcJDI$sp(double v1, int v2) {
                return Function2.apply$mcJDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public void apply$mcVDI$sp(double v1, int v2) {
                Function2.apply$mcVDI$sp$((Function2)this, (double)v1, (int)v2);
            }

            public boolean apply$mcZDJ$sp(double v1, long v2) {
                return Function2.apply$mcZDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public double apply$mcDDJ$sp(double v1, long v2) {
                return Function2.apply$mcDDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public float apply$mcFDJ$sp(double v1, long v2) {
                return Function2.apply$mcFDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public int apply$mcIDJ$sp(double v1, long v2) {
                return Function2.apply$mcIDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public long apply$mcJDJ$sp(double v1, long v2) {
                return Function2.apply$mcJDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public void apply$mcVDJ$sp(double v1, long v2) {
                Function2.apply$mcVDJ$sp$((Function2)this, (double)v1, (long)v2);
            }

            public boolean apply$mcZID$sp(int v1, double v2) {
                return Function2.apply$mcZID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public double apply$mcDID$sp(int v1, double v2) {
                return Function2.apply$mcDID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public float apply$mcFID$sp(int v1, double v2) {
                return Function2.apply$mcFID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public int apply$mcIID$sp(int v1, double v2) {
                return Function2.apply$mcIID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public long apply$mcJID$sp(int v1, double v2) {
                return Function2.apply$mcJID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public void apply$mcVID$sp(int v1, double v2) {
                Function2.apply$mcVID$sp$((Function2)this, (int)v1, (double)v2);
            }

            public boolean apply$mcZII$sp(int v1, int v2) {
                return Function2.apply$mcZII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public double apply$mcDII$sp(int v1, int v2) {
                return Function2.apply$mcDII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public float apply$mcFII$sp(int v1, int v2) {
                return Function2.apply$mcFII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public int apply$mcIII$sp(int v1, int v2) {
                return Function2.apply$mcIII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public long apply$mcJII$sp(int v1, int v2) {
                return Function2.apply$mcJII$sp$((Function2)this, (int)v1, (int)v2);
            }

            public boolean apply$mcZIJ$sp(int v1, long v2) {
                return Function2.apply$mcZIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public double apply$mcDIJ$sp(int v1, long v2) {
                return Function2.apply$mcDIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public float apply$mcFIJ$sp(int v1, long v2) {
                return Function2.apply$mcFIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public int apply$mcIIJ$sp(int v1, long v2) {
                return Function2.apply$mcIIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public long apply$mcJIJ$sp(int v1, long v2) {
                return Function2.apply$mcJIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public void apply$mcVIJ$sp(int v1, long v2) {
                Function2.apply$mcVIJ$sp$((Function2)this, (int)v1, (long)v2);
            }

            public boolean apply$mcZJD$sp(long v1, double v2) {
                return Function2.apply$mcZJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public double apply$mcDJD$sp(long v1, double v2) {
                return Function2.apply$mcDJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public float apply$mcFJD$sp(long v1, double v2) {
                return Function2.apply$mcFJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public int apply$mcIJD$sp(long v1, double v2) {
                return Function2.apply$mcIJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public long apply$mcJJD$sp(long v1, double v2) {
                return Function2.apply$mcJJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public void apply$mcVJD$sp(long v1, double v2) {
                Function2.apply$mcVJD$sp$((Function2)this, (long)v1, (double)v2);
            }

            public boolean apply$mcZJI$sp(long v1, int v2) {
                return Function2.apply$mcZJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public double apply$mcDJI$sp(long v1, int v2) {
                return Function2.apply$mcDJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public float apply$mcFJI$sp(long v1, int v2) {
                return Function2.apply$mcFJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public int apply$mcIJI$sp(long v1, int v2) {
                return Function2.apply$mcIJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public long apply$mcJJI$sp(long v1, int v2) {
                return Function2.apply$mcJJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public void apply$mcVJI$sp(long v1, int v2) {
                Function2.apply$mcVJI$sp$((Function2)this, (long)v1, (int)v2);
            }

            public boolean apply$mcZJJ$sp(long v1, long v2) {
                return Function2.apply$mcZJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public double apply$mcDJJ$sp(long v1, long v2) {
                return Function2.apply$mcDJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public float apply$mcFJJ$sp(long v1, long v2) {
                return Function2.apply$mcFJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public int apply$mcIJJ$sp(long v1, long v2) {
                return Function2.apply$mcIJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public long apply$mcJJJ$sp(long v1, long v2) {
                return Function2.apply$mcJJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public void apply$mcVJJ$sp(long v1, long v2) {
                Function2.apply$mcVJJ$sp$((Function2)this, (long)v1, (long)v2);
            }

            public Function1<Object, Function1<Object, BoxedUnit>> curried() {
                return Function2.curried$((Function2)this);
            }

            public Function1<Tuple2<Object, Object>, BoxedUnit> tupled() {
                return Function2.tupled$((Function2)this);
            }

            public String toString() {
                return Function2.toString$((Function2)this);
            }

            public void apply(int col, int row) {
                this.apply$mcVII$sp(col, row);
            }

            public void apply$mcVII$sp(int col, int row) {
                this.tiles$2.$plus$eq((Object)new SpatialKey(this.bounds$2.colMin$mcI$sp() + col, this.bounds$2.rowMin$mcI$sp() + row));
            }
            {
                this.tiles$2 = tiles$2;
                this.bounds$2 = bounds$2;
                Function2.$init$((Function2)this);
            }
        };
        package$.MODULE$.withGeometryRasterizeMethods((Geometry)multiPolygon).foreach(rasterExtent, options, (Function2)fn);
        return tiles.toSet();
    }

    public <G extends Geometry> scala.collection.immutable.Set<SpatialKey> keysForGeometry(G g2) {
        G g3 = g2;
        if (g3 instanceof Point) {
            Point point = (Point)g3;
            return (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new SpatialKey[]{this.pointToKey(point)}));
        }
        if (g3 instanceof MultiPoint) {
            MultiPoint multiPoint = (MultiPoint)g3;
            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])geotrellis.vector.package$.MODULE$.withExtraMultiPointMethods(multiPoint).points()), (Function1 & Serializable)x$2 -> this.pointToKey((Point)x$2), ClassTag$.MODULE$.apply(SpatialKey.class))).toSet();
        }
        if (g3 instanceof LineString) {
            LineString lineString = (LineString)g3;
            return this.multiLineToKeys(MultiLineString$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LineString[]{lineString})));
        }
        if (g3 instanceof MultiLineString) {
            MultiLineString multiLineString = (MultiLineString)g3;
            return this.multiLineToKeys(multiLineString);
        }
        if (g3 instanceof Polygon) {
            Polygon polygon = (Polygon)g3;
            return this.multiPolygonToKeys(MultiPolygon$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Polygon[]{polygon})));
        }
        if (g3 instanceof MultiPolygon) {
            MultiPolygon multiPolygon = (MultiPolygon)g3;
            return this.multiPolygonToKeys(multiPolygon);
        }
        if (g3 instanceof GeometryCollection) {
            GeometryCollection geometryCollection = (GeometryCollection)g3;
            return ((IterableOnceOps)new .colon.colon((Object)((Seq)geotrellis.vector.package$.MODULE$.withExtraGeometryCollectionMethods(geometryCollection).getAll(ClassTag$.MODULE$.apply(Point.class)).map((Function1 & Serializable)p -> this.pointToKey((Point)p))), (List)new .colon.colon((Object)((Seq)geotrellis.vector.package$.MODULE$.withExtraGeometryCollectionMethods(geometryCollection).getAll(ClassTag$.MODULE$.apply(MultiPoint.class)).flatMap((Function1 & Serializable)x$3 -> Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])geotrellis.vector.package$.MODULE$.withExtraMultiPointMethods(x$3).points()), (Function1 & Serializable)p -> this.pointToKey((Point)p), ClassTag$.MODULE$.apply(SpatialKey.class))))), (List)new .colon.colon((Object)((Seq)geotrellis.vector.package$.MODULE$.withExtraGeometryCollectionMethods(geometryCollection).getAll(ClassTag$.MODULE$.apply(LineString.class)).flatMap((Function1 & Serializable)l -> this.multiLineToKeys(MultiLineString$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new LineString[]{l}))))), (List)new .colon.colon((Object)((Seq)geotrellis.vector.package$.MODULE$.withExtraGeometryCollectionMethods(geometryCollection).getAll(ClassTag$.MODULE$.apply(MultiLineString.class)).flatMap((Function1 & Serializable)ml -> this.multiLineToKeys((MultiLineString)ml))), (List)new .colon.colon((Object)((Seq)geotrellis.vector.package$.MODULE$.withExtraGeometryCollectionMethods(geometryCollection).getAll(ClassTag$.MODULE$.apply(Polygon.class)).flatMap((Function1 & Serializable)p -> this.multiPolygonToKeys(MultiPolygon$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Polygon[]{p}))))), (List)new .colon.colon((Object)((Seq)geotrellis.vector.package$.MODULE$.withExtraGeometryCollectionMethods(geometryCollection).getAll(ClassTag$.MODULE$.apply(MultiPolygon.class)).flatMap((Function1 & Serializable)mp -> this.multiPolygonToKeys((MultiPolygon)mp))), (List)new .colon.colon((Object)((Seq)geotrellis.vector.package$.MODULE$.withExtraGeometryCollectionMethods(geometryCollection).getAll(ClassTag$.MODULE$.apply(GeometryCollection.class)).flatMap((Function1 & Serializable)g -> this.keysForGeometry(g))), (List)Nil$.MODULE$))))))).flatten(Predef$.MODULE$.$conforms())).toSet();
        }
        throw new MatchError(g3);
    }

    public MapKeyTransform(Extent extent, int layoutCols, int layoutRows) {
        this.extent = extent;
        this.layoutCols = layoutCols;
        this.layoutRows = layoutRows;
    }

    public static final /* synthetic */ Object $anonfun$multiLineToKeys$1$adapted(RasterExtent rasterExtent$1, Function2 fn$1, LineString line) {
        Rasterizer$.MODULE$.foreachCellByLineStringDouble(line, rasterExtent$1, fn$1);
        return BoxedUnit.UNIT;
    }
}

