/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.layer;

import geotrellis.layer.LayoutDefinition;
import geotrellis.layer.ZoomedLayoutScheme;
import geotrellis.proj4.CRS;
import geotrellis.raster.TileLayout;
import geotrellis.util.Haversine$;
import geotrellis.vector.Extent;
import java.io.Serializable;
import scala.math.package$;
import scala.runtime.ModuleSerializationProxy;

public final class ZoomedLayoutScheme$
implements Serializable {
    public static final ZoomedLayoutScheme$ MODULE$ = new ZoomedLayoutScheme$();
    private static final double EARTH_CIRCUMFERENCE = Math.PI * 2 * Haversine$.MODULE$.EARTH_RADIUS();
    private static final int DEFAULT_TILE_SIZE = 256;
    private static final double DEFAULT_RESOLUTION_THRESHOLD = 0.1;

    public double EARTH_CIRCUMFERENCE() {
        return EARTH_CIRCUMFERENCE;
    }

    public int DEFAULT_TILE_SIZE() {
        return DEFAULT_TILE_SIZE;
    }

    public double DEFAULT_RESOLUTION_THRESHOLD() {
        return DEFAULT_RESOLUTION_THRESHOLD;
    }

    public int layoutColsForZoom(int level) {
        return (int)package$.MODULE$.pow(2.0, (double)level);
    }

    public int layoutRowsForZoom(int level) {
        return (int)package$.MODULE$.pow(2.0, (double)level);
    }

    public ZoomedLayoutScheme apply(CRS crs, int tileSize, double resolutionThreshold) {
        return new ZoomedLayoutScheme(crs, tileSize, resolutionThreshold);
    }

    public int apply$default$2() {
        return this.DEFAULT_TILE_SIZE();
    }

    public double apply$default$3() {
        return this.DEFAULT_RESOLUTION_THRESHOLD();
    }

    public LayoutDefinition layoutForZoom(int zoom, Extent layoutExtent, int tileSize) {
        if (zoom < 0) {
            throw scala.sys.package$.MODULE$.error("TMS Tiling scheme does not have levels below 0");
        }
        return new LayoutDefinition(layoutExtent, new TileLayout(this.layoutColsForZoom(zoom), this.layoutRowsForZoom(zoom), tileSize, tileSize));
    }

    public int layoutForZoom$default$3() {
        return this.DEFAULT_TILE_SIZE();
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(ZoomedLayoutScheme$.class);
    }

    private ZoomedLayoutScheme$() {
    }
}

