/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.layer;

import geotrellis.layer.LayoutDefinition;
import geotrellis.layer.LayoutLevel;
import geotrellis.layer.LayoutScheme;
import geotrellis.layer.ZoomedLayoutScheme$;
import geotrellis.layer.package$;
import geotrellis.layer.package$CRSWorldExtent$;
import geotrellis.proj4.CRS;
import geotrellis.proj4.LatLng$;
import geotrellis.proj4.util.UTM$;
import geotrellis.raster.CellSize;
import geotrellis.raster.TileLayout;
import geotrellis.util.Haversine$;
import geotrellis.vector.Extent;
import geotrellis.vector.Point$;
import org.locationtech.jts.geom.Point;
import scala.MatchError;
import scala.Tuple2;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015u!\u0002\u0011\"\u0011\u00031c!\u0002\u0015\"\u0011\u0003I\u0003\"\u0002\u001d\u0002\t\u0003I\u0004b\u0002\u001e\u0002\u0005\u0004%\ta\u000f\u0005\u0007\u007f\u0005\u0001\u000b\u0011\u0002\u001f\t\u000f\u0001\u000b!\u0019!C\u0001\u0003\"1Q)\u0001Q\u0001\n\tCqAR\u0001C\u0002\u0013\u00051\b\u0003\u0004H\u0003\u0001\u0006I\u0001\u0010\u0005\u0006\u0011\u0006!\t!\u0013\u0005\u0006\u0019\u0006!\t!\u0014\u0005\u0006\u001f\u0006!\t\u0001\u0015\u0005\n\u0003\u0007\n\u0011\u0013!C\u0001\u0003\u000bB\u0011\"a\u0017\u0002#\u0003%\t!!\u0018\t\u000f\u0005\u0005\u0014\u0001\"\u0001\u0002d!I\u00111O\u0001\u0012\u0002\u0013\u0005\u0011Q\t\u0005\n\u0003k\n\u0011\u0011!C\u0005\u0003o2A\u0001K\u0011\u0001%\"Aa+\u0005BC\u0002\u0013\u0005q\u000b\u0003\u0005_#\t\u0005\t\u0015!\u0003Y\u0011!y\u0016C!b\u0001\n\u0003\t\u0005\u0002\u00031\u0012\u0005\u0003\u0005\u000b\u0011\u0002\"\t\u0011\u0005\f\"Q1A\u0005\u0002mB\u0001BY\t\u0003\u0002\u0003\u0006I\u0001\u0010\u0005\u0006qE!\ta\u0019\u0005\u0006OF!\t\u0001\u001b\u0005\u0006kF!\tA\u001e\u0005\b\u0003\u000f\tB\u0011AA\u0005\u0011\u001d\t9!\u0005C\u0001\u0003\u001fAq!a\u0006\u0012\t\u0003\tI\u0002C\u0004\u0002\u001eE!\t!a\b\t\u000f\u0005\r\u0012\u0003\"\u0011\u0002&\u0005\u0011\"l\\8nK\u0012d\u0015-_8viN\u001b\u0007.Z7f\u0015\t\u00113%A\u0003mCf,'OC\u0001%\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001!\t9\u0013!D\u0001\"\u0005IQvn\\7fI2\u000b\u0017p\\;u'\u000eDW-\\3\u0014\u0007\u0005Q\u0003\u0007\u0005\u0002,]5\tAFC\u0001.\u0003\u0015\u00198-\u00197b\u0013\tyCF\u0001\u0004B]f\u0014VM\u001a\t\u0003cYj\u0011A\r\u0006\u0003gQ\n!![8\u000b\u0003U\nAA[1wC&\u0011qG\r\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003\u0019\n1#R!S)\"{6)\u0013*D+63UIU#O\u0007\u0016+\u0012\u0001\u0010\t\u0003WuJ!A\u0010\u0017\u0003\r\u0011{WO\u00197f\u0003Q)\u0015I\u0015+I?\u000eK%kQ+N\r\u0016\u0013VIT\"FA\u0005\tB)\u0012$B+2#v\fV%M\u000b~\u001b\u0016JW#\u0016\u0003\t\u0003\"aK\"\n\u0005\u0011c#aA%oi\u0006\u0011B)\u0012$B+2#v\fV%M\u000b~\u001b\u0016JW#!\u0003q!UIR!V\u0019R{&+R*P\u0019V#\u0016j\u0014(`)\"\u0013Vi\u0015%P\u0019\u0012\u000bQ\u0004R#G\u0003VcEk\u0018*F'>cU\u000bV%P\u001d~#\u0006JU#T\u0011>cE\tI\u0001\u0012Y\u0006Lx.\u001e;D_2\u001chi\u001c:[_>lGC\u0001\"K\u0011\u0015Y\u0015\u00021\u0001C\u0003\u0015aWM^3m\u0003Ea\u0017-_8viJ{wo\u001d$pej{w.\u001c\u000b\u0003\u0005:CQa\u0013\u0006A\u0002\t\u000bQ!\u00199qYf$r!UA\u001f\u0003\u007f\t\t\u0005\u0005\u0002(#M\u0019\u0011CK*\u0011\u0005\u001d\"\u0016BA+\"\u00051a\u0015-_8viN\u001b\u0007.Z7f\u0003\r\u0019'o]\u000b\u00021B\u0011\u0011\fX\u0007\u00025*\u00111lI\u0001\u0006aJ|'\u000eN\u0005\u0003;j\u00131a\u0011*T\u0003\u0011\u0019'o\u001d\u0011\u0002\u0011QLG.Z*ju\u0016\f\u0011\u0002^5mKNK'0\u001a\u0011\u0002'I,7o\u001c7vi&|g\u000e\u00165sKNDw\u000e\u001c3\u0002)I,7o\u001c7vi&|g\u000e\u00165sKNDw\u000e\u001c3!)\u0011\tF-\u001a4\t\u000bYC\u0002\u0019\u0001-\t\u000b}C\u0002\u0019\u0001\"\t\u000b\u0005D\u0002\u0019\u0001\u001f\u0002\ti|w.\u001c\u000b\u0005\u0005&\\W\u000eC\u0003k3\u0001\u0007A(A\u0001y\u0011\u0015a\u0017\u00041\u0001=\u0003\u0005I\b\"\u00028\u001a\u0001\u0004y\u0017\u0001C2fY2\u001c\u0016N_3\u0011\u0005A\u001cX\"A9\u000b\u0005I\u001c\u0013A\u0002:bgR,'/\u0003\u0002uc\nA1)\u001a7m'&TX-\u0001\u0005mKZ,GNR8s)\u00119(0!\u0002\u0011\u0005\u001dB\u0018BA=\"\u0005-a\u0015-_8vi2+g/\u001a7\t\u000bmT\u0002\u0019\u0001?\u0002\r\u0015DH/\u001a8u!\ri\u0018\u0011A\u0007\u0002}*\u0011qpI\u0001\u0007m\u0016\u001cGo\u001c:\n\u0007\u0005\raP\u0001\u0004FqR,g\u000e\u001e\u0005\u0006]j\u0001\ra\\\u0001\rY\u00164X\r\u001c$pej{w.\u001c\u000b\u0004o\u0006-\u0001BBA\u00077\u0001\u0007!)\u0001\u0002jIR)q/!\u0005\u0002\u0016!1\u00111\u0003\u000fA\u0002q\f1b^8sY\u0012,\u0005\u0010^3oi\"1\u0011Q\u0002\u000fA\u0002\t\u000bqA_8p[>+H\u000fF\u0002x\u00037AQaS\u000fA\u0002]\faA_8p[&sGcA<\u0002\"!)1J\ba\u0001o\u0006AAo\\*ue&tw\r\u0006\u0002\u0002(A!\u0011\u0011FA\u001c\u001d\u0011\tY#a\r\u0011\u0007\u00055B&\u0004\u0002\u00020)\u0019\u0011\u0011G\u0013\u0002\rq\u0012xn\u001c;?\u0013\r\t)\u0004L\u0001\u0007!J,G-\u001a4\n\t\u0005e\u00121\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005UB\u0006C\u0003W\u0017\u0001\u0007\u0001\fC\u0004`\u0017A\u0005\t\u0019\u0001\"\t\u000f\u0005\\\u0001\u0013!a\u0001y\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$#'\u0006\u0002\u0002H)\u001a!)!\u0013,\u0005\u0005-\u0003\u0003BA'\u0003/j!!a\u0014\u000b\t\u0005E\u00131K\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u0016-\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u00033\nyEA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fq\"\u00199qYf$C-\u001a4bk2$HeM\u000b\u0003\u0003?R3\u0001PA%\u00035a\u0017-_8vi\u001a{'OW8p[RA\u0011QMA6\u0003[\n\t\bE\u0002(\u0003OJ1!!\u001b\"\u0005Aa\u0015-_8vi\u0012+g-\u001b8ji&|g\u000eC\u0003h\u001d\u0001\u0007!\t\u0003\u0004\u0002p9\u0001\r\u0001`\u0001\rY\u0006Lx.\u001e;FqR,g\u000e\u001e\u0005\b?:\u0001\n\u00111\u0001C\u0003]a\u0017-_8vi\u001a{'OW8p[\u0012\"WMZ1vYR$3'\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u0002zA!\u00111PAA\u001b\t\tiHC\u0002\u0002\u0000Q\nA\u0001\\1oO&!\u00111QA?\u0005\u0019y%M[3di\u0002")
public class ZoomedLayoutScheme
implements LayoutScheme {
    private final CRS crs;
    private final int tileSize;
    private final double resolutionThreshold;

    public static int layoutForZoom$default$3() {
        return ZoomedLayoutScheme$.MODULE$.layoutForZoom$default$3();
    }

    public static LayoutDefinition layoutForZoom(int zoom, Extent layoutExtent, int tileSize) {
        return ZoomedLayoutScheme$.MODULE$.layoutForZoom(zoom, layoutExtent, tileSize);
    }

    public static double apply$default$3() {
        return ZoomedLayoutScheme$.MODULE$.apply$default$3();
    }

    public static int apply$default$2() {
        return ZoomedLayoutScheme$.MODULE$.apply$default$2();
    }

    public static ZoomedLayoutScheme apply(CRS crs, int tileSize, double resolutionThreshold) {
        return ZoomedLayoutScheme$.MODULE$.apply(crs, tileSize, resolutionThreshold);
    }

    public static int layoutRowsForZoom(int level) {
        return ZoomedLayoutScheme$.MODULE$.layoutRowsForZoom(level);
    }

    public static int layoutColsForZoom(int level) {
        return ZoomedLayoutScheme$.MODULE$.layoutColsForZoom(level);
    }

    public static double DEFAULT_RESOLUTION_THRESHOLD() {
        return ZoomedLayoutScheme$.MODULE$.DEFAULT_RESOLUTION_THRESHOLD();
    }

    public static int DEFAULT_TILE_SIZE() {
        return ZoomedLayoutScheme$.MODULE$.DEFAULT_TILE_SIZE();
    }

    public static double EARTH_CIRCUMFERENCE() {
        return ZoomedLayoutScheme$.MODULE$.EARTH_CIRCUMFERENCE();
    }

    public CRS crs() {
        return this.crs;
    }

    public int tileSize() {
        return this.tileSize;
    }

    public double resolutionThreshold() {
        return this.resolutionThreshold;
    }

    public int zoom(double x, double y, CellSize cellSize) {
        double d;
        Point ll1 = geotrellis.vector.package$.MODULE$.ReprojectPoint(Point$.MODULE$.apply(x + cellSize.width(), y + cellSize.height())).reproject(this.crs(), (CRS)LatLng$.MODULE$);
        Point ll2 = geotrellis.vector.package$.MODULE$.ReprojectPoint(Point$.MODULE$.apply(x, y)).reproject(this.crs(), (CRS)LatLng$.MODULE$);
        if (UTM$.MODULE$.inValidZone(geotrellis.vector.package$.MODULE$.withExtraPointMethods(ll1).y())) {
            CRS utmCrs = UTM$.MODULE$.getZoneCrs(geotrellis.vector.package$.MODULE$.withExtraPointMethods(ll1).x(), geotrellis.vector.package$.MODULE$.withExtraPointMethods(ll1).y());
            Tuple2 tuple2 = new Tuple2((Object)geotrellis.vector.package$.MODULE$.ReprojectPoint(ll1).reproject((CRS)LatLng$.MODULE$, utmCrs), (Object)geotrellis.vector.package$.MODULE$.ReprojectPoint(ll2).reproject((CRS)LatLng$.MODULE$, utmCrs));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Point p1 = (Point)tuple2._1();
            Point p2 = (Point)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)p1, (Object)p2);
            Point p12 = (Point)tuple22._1();
            Point p22 = (Point)tuple22._2();
            d = scala.math.package$.MODULE$.max(scala.math.package$.MODULE$.abs(geotrellis.vector.package$.MODULE$.withExtraPointMethods(p12).x() - geotrellis.vector.package$.MODULE$.withExtraPointMethods(p22).x()), scala.math.package$.MODULE$.abs(geotrellis.vector.package$.MODULE$.withExtraPointMethods(p12).y() - geotrellis.vector.package$.MODULE$.withExtraPointMethods(p22).y()));
        } else {
            d = Haversine$.MODULE$.apply(geotrellis.vector.package$.MODULE$.withExtraPointMethods(ll1).x(), geotrellis.vector.package$.MODULE$.withExtraPointMethods(ll1).y(), geotrellis.vector.package$.MODULE$.withExtraPointMethods(ll2).x(), geotrellis.vector.package$.MODULE$.withExtraPointMethods(ll2).y());
        }
        double dist = d;
        int z = (int)(scala.math.package$.MODULE$.log(ZoomedLayoutScheme$.MODULE$.EARTH_CIRCUMFERENCE() / (dist * (double)this.tileSize())) / scala.math.package$.MODULE$.log(2.0));
        double zRes = ZoomedLayoutScheme$.MODULE$.EARTH_CIRCUMFERENCE() / (scala.math.package$.MODULE$.pow(2.0, (double)z) * (double)this.tileSize());
        double nextZRes = ZoomedLayoutScheme$.MODULE$.EARTH_CIRCUMFERENCE() / (scala.math.package$.MODULE$.pow(2.0, (double)(z + 1)) * (double)this.tileSize());
        double delta = zRes - nextZRes;
        double diff = zRes - dist;
        int zoom = diff / delta > this.resolutionThreshold() ? z + 1 : z;
        return zoom;
    }

    @Override
    public LayoutLevel levelFor(Extent extent, CellSize cellSize) {
        Extent worldExtent = package$CRSWorldExtent$.MODULE$.worldExtent$extension(package$.MODULE$.CRSWorldExtent(this.crs()));
        int l = this.zoom(extent.xmin(), extent.ymin(), cellSize);
        return this.levelForZoom(worldExtent, l);
    }

    public LayoutLevel levelForZoom(int id) {
        return this.levelForZoom(package$CRSWorldExtent$.MODULE$.worldExtent$extension(package$.MODULE$.CRSWorldExtent(this.crs())), id);
    }

    public LayoutLevel levelForZoom(Extent worldExtent, int id) {
        if (id < 0) {
            throw scala.sys.package$.MODULE$.error("TMS Tiling scheme does not have levels below 0");
        }
        return new LayoutLevel(id, new LayoutDefinition(worldExtent, new TileLayout(ZoomedLayoutScheme$.MODULE$.layoutColsForZoom(id), ZoomedLayoutScheme$.MODULE$.layoutRowsForZoom(id), this.tileSize(), this.tileSize())));
    }

    @Override
    public LayoutLevel zoomOut(LayoutLevel level) {
        LayoutDefinition layout = level.layout();
        int newZoom = level.zoom() - 1;
        int newSize = (int)scala.math.package$.MODULE$.pow(2.0, (double)newZoom);
        return new LayoutLevel(newZoom, new LayoutDefinition(layout.extent(), new TileLayout(newSize, newSize, layout.tileCols(), layout.tileRows())));
    }

    @Override
    public LayoutLevel zoomIn(LayoutLevel level) {
        LayoutDefinition layout = level.layout();
        int newZoom = level.zoom() + 1;
        int newSize = (int)scala.math.package$.MODULE$.pow(2.0, (double)newZoom);
        return new LayoutLevel(newZoom, new LayoutDefinition(layout.extent(), new TileLayout(newSize, newSize, layout.tileCols(), layout.tileRows())));
    }

    public String toString() {
        return new StringBuilder(22).append("ZoomedLayoutScheme(").append(this.crs()).append(",").append(this.tileSize()).append(",").append(this.resolutionThreshold()).append(")").toString();
    }

    public ZoomedLayoutScheme(CRS crs, int tileSize, double resolutionThreshold) {
        this.crs = crs;
        this.tileSize = tileSize;
        this.resolutionThreshold = resolutionThreshold;
    }
}

