/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import geotrellis.macros.DoubleTileCombiner10;
import geotrellis.macros.DoubleTileCombiner3;
import geotrellis.macros.DoubleTileCombiner4;
import geotrellis.macros.DoubleTileCombiner5;
import geotrellis.macros.DoubleTileCombiner6;
import geotrellis.macros.DoubleTileCombiner7;
import geotrellis.macros.DoubleTileCombiner8;
import geotrellis.macros.DoubleTileCombiner9;
import geotrellis.macros.IntTileCombiner10;
import geotrellis.macros.IntTileCombiner3;
import geotrellis.macros.IntTileCombiner4;
import geotrellis.macros.IntTileCombiner5;
import geotrellis.macros.IntTileCombiner6;
import geotrellis.macros.IntTileCombiner7;
import geotrellis.macros.IntTileCombiner8;
import geotrellis.macros.IntTileCombiner9;
import geotrellis.macros.MacroCombineFunctions;
import geotrellis.raster.ArrayMultibandTile$;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.DataType;
import geotrellis.raster.Grid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.MacroMultibandCombiners;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t=s!B\u0001\u0003\u0011\u00039\u0011AE!se\u0006LX*\u001e7uS\n\fg\u000e\u001a+jY\u0016T!a\u0001\u0003\u0002\rI\f7\u000f^3s\u0015\u0005)\u0011AC4f_R\u0014X\r\u001c7jg\u000e\u0001\u0001C\u0001\u0005\n\u001b\u0005\u0011a!\u0002\u0006\u0003\u0011\u0003Y!AE!se\u0006LX*\u001e7uS\n\fg\u000e\u001a+jY\u0016\u001c2!\u0003\u0007\u0013!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u0011QbE\u0005\u0003)9\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQAF\u0005\u0005\u0002]\ta\u0001P5oSRtD#A\u0004\t\u000beIA\u0011\u0001\u000e\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0007m\u0011\t\u0001\u0005\u0002\t9\u0019!!B\u0001\u0001\u001e'\u0011aBBH\u0011\u0011\u0005!y\u0012B\u0001\u0011\u0003\u00055iU\u000f\u001c;jE\u0006tG\rV5mKB\u0011\u0001BI\u0005\u0003G\t\u0011q#T1de>lU\u000f\u001c;jE\u0006tGmQ8nE&tWM]:\t\u0011\u0015b\"\u0011!Q\u0001\n\u0019\naa\u00182b]\u0012\u001c\bcA\u0007(S%\u0011\u0001F\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\u0011)J!a\u000b\u0002\u0003\tQKG.\u001a\u0005\u0006-q!\t!\f\u000b\u000379BQ!\n\u0017A\u0002\u0019Bq\u0001\r\u000fC\u0002\u0013\u0005\u0011'A\u0005cC:$7i\\;oiV\t!\u0007\u0005\u0002\u000eg%\u0011AG\u0004\u0002\u0004\u0013:$\bB\u0002\u001c\u001dA\u0003%!'\u0001\u0006cC:$7i\\;oi\u0002BQ\u0001\u000f\u000f\u0005\ne\nAB^1mS\u0012\fG/\u001a\"b]\u0012$\"AO\u001f\u0011\u00055Y\u0014B\u0001\u001f\u000f\u0005\u0011)f.\u001b;\t\u000by:\u0004\u0019\u0001\u001a\u0002\u0003%Dq\u0001\u0011\u000fC\u0002\u0013\u0005\u0011)\u0001\u0005dK2dG+\u001f9f+\u0005\u0011\u0005CA\"G\u001d\tAA)\u0003\u0002F\u0005\u00059\u0001/Y2lC\u001e,\u0017BA$I\u0005!\u0019U\r\u001c7UsB,'BA#\u0003\u0011\u0019QE\u0004)A\u0005\u0005\u0006I1-\u001a7m)f\u0004X\r\t\u0005\b\u0019r\u0011\r\u0011\"\u00012\u0003\u0011\u0019w\u000e\\:\t\r9c\u0002\u0015!\u00033\u0003\u0015\u0019w\u000e\\:!\u0011\u001d\u0001FD1A\u0005\u0002E\nAA]8xg\"1!\u000b\bQ\u0001\nI\nQA]8xg\u0002BQ\u0001\u0016\u000f\u0005\u0002U\u000b1\u0002^8BeJ\f\u0017\u0010V5mKR\t1\u0004C\u0003X9\u0011\u0005\u0001,\u0001\u0003cC:$GCA\u0015Z\u0011\u0015Qf\u000b1\u00013\u0003%\u0011\u0017M\u001c3J]\u0012,\u0007\u0010C\u0003]9\u0011\u0005Q,A\u0003cC:$7/F\u0001_!\ry\u0016-\u000b\b\u0003\u001b\u0001L!!\u0012\b\n\u0005\t\u001c'A\u0002,fGR|'O\u0003\u0002F\u001d!)Q\r\bC\u0001M\u000691m\u001c8wKJ$HC\u0001\u0010h\u0011\u0015AG\r1\u0001C\u0003-qWm^\"fY2$\u0016\u0010]3\t\u000b)dB\u0011A6\u0002\u0015]LG\u000f\u001b(p\t\u0006$\u0018\r\u0006\u0002\u001fY\")Q.\u001ba\u0001]\u0006Yan\u001c#bi\u00064\u0016\r\\;f!\riq.]\u0005\u0003a:\u0011aa\u00149uS>t\u0007CA\u0007s\u0013\t\u0019hB\u0001\u0004E_V\u0014G.\u001a\u0005\u0006kr!\tA^\u0001\fS:$XM\u001d9sKR\f5\u000f\u0006\u0002\u001fo\")\u0001\u000e\u001ea\u0001\u0005\")\u0011\u0010\bC\u0001u\u0006\u0019Q.\u00199\u0015\u0007m\f\u0019\u0001\u0006\u0002\u001fy\")Q\u0010\u001fa\u0001}\u0006\ta\rE\u0003\u000e\u007fJ\u0012$'C\u0002\u0002\u00029\u0011\u0011BR;oGRLwN\u001c\u001a\t\u000f\u0005\u0015\u0001\u00101\u0001\u0002\b\u000511/\u001e2tKR\u0004R!!\u0003\u0002\u0016Ir1!a\u0003a\u001d\u0011\ti!a\u0005\u000e\u0005\u0005=!bAA\t\r\u00051AH]8pizJ\u0011aD\u0005\u0004\u0003/\u0019'aA*fc\"9\u00111\u0004\u000f\u0005\u0002\u0005u\u0011!C7ba\u0012{WO\u00197f)\u0011\ty\"!\n\u0015\u0007y\t\t\u0003C\u0004~\u00033\u0001\r!a\t\u0011\u000b5y(']9\t\u0011\u0005\u0015\u0011\u0011\u0004a\u0001\u0003\u000fAa!\u001f\u000f\u0005\u0002\u0005%Bc\u0001\u0010\u0002,!1Q0a\nA\u0002yDq!a\u0007\u001d\t\u0003\ty\u0003F\u0002\u001f\u0003cAq!`A\u0017\u0001\u0004\t\u0019\u0003\u0003\u0004z9\u0011\u0005\u0011Q\u0007\u000b\u0005\u0003o\t\t\u0005F\u0002\u001f\u0003sAq!`A\u001a\u0001\u0004\tY\u0004E\u0003\u000e\u0003{\u0011$'C\u0002\u0002@9\u0011\u0011BR;oGRLwN\\\u0019\t\u000f\u0005\r\u00131\u0007a\u0001e\u0005\u0011!\r\r\u0005\b\u00037aB\u0011AA$)\u0011\tI%a\u0014\u0015\u0007y\tY\u0005C\u0004~\u0003\u000b\u0002\r!!\u0014\u0011\u000b5\ti$]9\t\u000f\u0005\r\u0013Q\ta\u0001e!9\u00111\u000b\u000f\u0005\u0002\u0005U\u0013a\u00024pe\u0016\f7\r\u001b\u000b\u0004u\u0005]\u0003bB?\u0002R\u0001\u0007\u0011\u0011\f\t\u0006\u001b}\u0014$G\u000f\u0005\b\u0003;bB\u0011AA0\u000351wN]3bG\"$u.\u001e2mKR\u0019!(!\u0019\t\u000fu\fY\u00061\u0001\u0002dA)Qb \u001aru!9\u00111\u000b\u000f\u0005\u0002\u0005\u001dD\u0003BA5\u0003_\"2AOA6\u0011\u001di\u0018Q\ra\u0001\u0003[\u0002R!DA\u001feiBq!a\u0011\u0002f\u0001\u0007!\u0007C\u0004\u0002^q!\t!a\u001d\u0015\t\u0005U\u00141\u0010\u000b\u0004u\u0005]\u0004bB?\u0002r\u0001\u0007\u0011\u0011\u0010\t\u0006\u001b\u0005u\u0012O\u000f\u0005\b\u0003\u0007\n\t\b1\u00013\u0011\u001d\t\u0019\u0006\bC\u0001\u0003\u007f\"2AOAA\u0011\u001di\u0018Q\u0010a\u0001\u0003\u0007\u0003b!DA\u001f\u0003\u000bS\u0004cA\u0007(e!9\u0011Q\f\u000f\u0005\u0002\u0005%Ec\u0001\u001e\u0002\f\"9Q0a\"A\u0002\u00055\u0005CB\u0007\u0002>\u0005=%\bE\u0002\u000eOEDq!a%\u001d\t\u0003\t)*A\u0004d_6\u0014\u0017N\\3\u0015\t\u0005]\u0015Q\u0014\u000b\u0004S\u0005e\u0005bB?\u0002\u0012\u0002\u0007\u00111\u0014\t\u0007\u001b\u0005u\u0012q\u0001\u001a\t\u0011\u0005\u0015\u0011\u0011\u0013a\u0001\u0003\u000fAq!!)\u001d\t\u0003\t\u0019+A\u0007d_6\u0014\u0017N\\3E_V\u0014G.\u001a\u000b\u0005\u0003K\u000bi\u000bF\u0002*\u0003OCq!`AP\u0001\u0004\tI\u000b\u0005\u0004\u000e\u0003{\tY+\u001d\t\u0006\u0003\u0013\t)\"\u001d\u0005\t\u0003\u000b\ty\n1\u0001\u0002\b!9\u00111\u0013\u000f\u0005\u0002\u0005EFcA\u0015\u00024\"9Q0a,A\u0002\u0005U\u0006CB\u0007\u0002>\u0005\u0015%\u0007C\u0004\u0002\u0014r!\t!!/\u0015\r\u0005m\u0016qXAa)\rI\u0013Q\u0018\u0005\u0007{\u0006]\u0006\u0019\u0001@\t\u000f\u0005\r\u0013q\u0017a\u0001e!9\u00111YA\\\u0001\u0004\u0011\u0014A\u000122\u0011\u001d\t\t\u000b\bC\u0001\u0003\u000f$B!!3\u0002PB\u0019\u0001\"a3\n\u0007\u00055'A\u0001\tNkR\f'\r\\3BeJ\f\u0017\u0010V5mK\"9Q0!2A\u0002\u0005E\u0007CB\u0007\u0002>\u0005=\u0015\u000fC\u0004\u0002\"r!\t!!6\u0015\r\u0005]\u0017Q\\Ap)\rI\u0013\u0011\u001c\u0005\b{\u0006M\u0007\u0019AAn!\u0015iq0]9r\u0011\u001d\t\u0019%a5A\u0002IBq!a1\u0002T\u0002\u0007!\u0007C\u0004\u0002dr!\t!!:\u0002\u0017M,(m]3u\u0005\u0006tGm\u001d\u000b\u00047\u0005\u001d\b\u0002CAu\u0003C\u0004\r!a\u0002\u0002\u0019\t\fg\u000eZ*fcV,gnY3\t\u000f\u00055H\u0004\"\u0011\u0002p\u00061Q-];bYN$B!!=\u0002xB\u0019Q\"a=\n\u0007\u0005UhBA\u0004C_>dW-\u00198\t\u0011\u0005e\u00181\u001ea\u0001\u0003w\fQa\u001c;iKJ\u00042!DA\u007f\u0013\r\tyP\u0004\u0002\u0004\u0003:L\bB\u0002/\u0019\u0001\u0004\u0011\u0019\u0001\u0005\u0003\u000e\u0005\u000bI\u0013b\u0001B\u0004\u001d\tQAH]3qK\u0006$X\r\u001a \t\reIA\u0011\u0001B\u0006)\rY\"Q\u0002\u0005\b9\n%\u0001\u0019\u0001B\b!\u0015\tIA!\u0005*\u0013\r\u0011\u0019b\u0019\u0002\f)J\fg/\u001a:tC\ndW\r\u0003\u0004\u001a\u0013\u0011\u0005!q\u0003\u000b\u00047\te\u0001B\u0002/\u0003\u0016\u0001\u0007a\u0005C\u0004\u0003\u001e%!\tAa\b\u0002\u000b\u0005dGn\\2\u0015\u0013m\u0011\tC!\n\u0003(\t%\u0002b\u0002B\u0012\u00057\u0001\rAQ\u0001\u0002i\"1ALa\u0007A\u0002IBa\u0001\u0014B\u000e\u0001\u0004\u0011\u0004B\u0002)\u0003\u001c\u0001\u0007!\u0007C\u0004\u0003.%!\tAa\f\u0002\u000b\u0015l\u0007\u000f^=\u0015\u0013m\u0011\tDa\r\u00036\t]\u0002b\u0002B\u0012\u0005W\u0001\rA\u0011\u0005\u00079\n-\u0002\u0019\u0001\u001a\t\r1\u0013Y\u00031\u00013\u0011\u0019\u0001&1\u0006a\u0001e!I!1H\u0005\u0002\u0002\u0013%!QH\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003@A!!\u0011\tB&\u001b\t\u0011\u0019E\u0003\u0003\u0003F\t\u001d\u0013\u0001\u00027b]\u001eT!A!\u0013\u0002\t)\fg/Y\u0005\u0005\u0005\u001b\u0012\u0019E\u0001\u0004PE*,7\r\u001e")
public class ArrayMultibandTile
implements MultibandTile,
MacroMultibandCombiners {
    private final Tile[] _bands;
    private final int bandCount;
    private final DataType cellType;
    private final int cols;
    private final int rows;

    public static ArrayMultibandTile empty(DataType dataType, int n, int n2, int n3) {
        return ArrayMultibandTile$.MODULE$.empty(dataType, n, n2, n3);
    }

    public static ArrayMultibandTile alloc(DataType dataType, int n, int n2, int n3) {
        return ArrayMultibandTile$.MODULE$.alloc(dataType, n, n2, n3);
    }

    public static ArrayMultibandTile apply(Tile[] tileArray) {
        return ArrayMultibandTile$.MODULE$.apply(tileArray);
    }

    public static ArrayMultibandTile apply(Traversable<Tile> traversable) {
        return ArrayMultibandTile$.MODULE$.apply(traversable);
    }

    public static ArrayMultibandTile apply(Seq<Tile> seq) {
        return ArrayMultibandTile$.MODULE$.apply(seq);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner3 combiner) {
        return MacroMultibandCombiners.combineIntTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner3 combiner) {
        return MacroMultibandCombiners.combineDoubleTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner4 combiner) {
        return MacroMultibandCombiners.combineIntTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner4 combiner) {
        return MacroMultibandCombiners.combineDoubleTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner5 combiner) {
        return MacroMultibandCombiners.combineIntTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner5 combiner) {
        return MacroMultibandCombiners.combineDoubleTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner6 combiner) {
        return MacroMultibandCombiners.combineIntTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner6 combiner) {
        return MacroMultibandCombiners.combineDoubleTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner7 combiner) {
        return MacroMultibandCombiners.combineIntTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner7 combiner) {
        return MacroMultibandCombiners.combineDoubleTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner8 combiner) {
        return MacroMultibandCombiners.combineIntTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner8 combiner) {
        return MacroMultibandCombiners.combineDoubleTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner9 combiner) {
        return MacroMultibandCombiners.combineIntTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner9 combiner) {
        return MacroMultibandCombiners.combineDoubleTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineIntTileCombiner(IntTileCombiner10 combiner) {
        return MacroMultibandCombiners.combineIntTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Tile combineDoubleTileCombiner(DoubleTileCombiner10 combiner) {
        return MacroMultibandCombiners.combineDoubleTileCombiner$((MacroMultibandCombiners)this, combiner);
    }

    @Override
    public Option<Tile> bandSafe(int bandIndex) {
        return MultibandTile.bandSafe$(this, bandIndex);
    }

    @Override
    public DataType targetCellType() {
        return MultibandTile.targetCellType$(this);
    }

    @Override
    public MultibandTile subsetBands(Seq<Object> bandSequence, Predef.DummyImplicit d) {
        return MultibandTile.subsetBands$(this, bandSequence, d);
    }

    @Override
    public MultibandTile mapBands(Function2<Object, Tile, Tile> f) {
        return MultibandTile.mapBands$(this, f);
    }

    @Override
    public int size() {
        return Grid.size$(this);
    }

    @Override
    public Tuple2<Object, Object> dimensions() {
        return Grid.dimensions$(this);
    }

    @Override
    public GridBounds gridBounds() {
        return Grid.gridBounds$(this);
    }

    @Override
    public int bandCount() {
        return this.bandCount;
    }

    private void validateBand(int i) {
        Predef$.MODULE$.assert(i < this.bandCount(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(61).append("Band index out of bounds. Band Count: ").append(this.bandCount()).append(" Requested Band Index: ").append(i).toString());
    }

    @Override
    public DataType cellType() {
        return this.cellType;
    }

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public ArrayMultibandTile toArrayTile() {
        return this;
    }

    @Override
    public Tile band(int bandIndex) {
        if (bandIndex >= this.bandCount()) {
            throw new IllegalArgumentException(new StringBuilder(20).append("Band ").append(bandIndex).append(" does not exist").toString());
        }
        return this._bands[bandIndex];
    }

    @Override
    public Vector<Tile> bands() {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this._bands)).toVector();
    }

    @Override
    public MultibandTile convert(DataType newCellType) {
        Tile[] newBands = (Tile[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.apply(Tile.class));
        for (int index$macro$2 = 0; index$macro$2 < this.bandCount(); ++index$macro$2) {
            newBands[index$macro$2] = this.band(index$macro$2).convert(newCellType);
        }
        return ArrayMultibandTile$.MODULE$.apply(newBands);
    }

    @Override
    public MultibandTile withNoData(Option<Object> noDataValue) {
        return new ArrayMultibandTile((Tile[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this._bands)).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.withNoData(noDataValue), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tile.class))));
    }

    @Override
    public MultibandTile interpretAs(DataType newCellType) {
        return new ArrayMultibandTile((Tile[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this._bands)).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.interpretAs(newCellType), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tile.class))));
    }

    @Override
    public MultibandTile map(Seq<Object> subset, Function2<Object, Object, Object> f) {
        Tile[] newBands = (Tile[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.apply(Tile.class));
        Set set = subset.toSet();
        subset.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)b -> Predef$.MODULE$.require(0 <= b && b < this.bandCount(), (Function0 & Serializable & scala.Serializable)() -> "All elements of subset must be present"));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.bandCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)b -> {
            newBands$1[b] = set.contains((Object)BoxesRunTime.boxToInteger((int)b)) ? this.band(b).map((Function1<Object, Object>)(JFunction1.mcII.sp & Serializable & scala.Serializable)z -> f.apply$mcIII$sp(b, z)) : this.band(b);
        });
        return ArrayMultibandTile$.MODULE$.apply(newBands);
    }

    @Override
    public MultibandTile mapDouble(Seq<Object> subset, Function2<Object, Object, Object> f) {
        Tile[] newBands = (Tile[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.apply(Tile.class));
        Set set = subset.toSet();
        subset.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)b -> Predef$.MODULE$.require(0 <= b && b < this.bandCount(), (Function0 & Serializable & scala.Serializable)() -> "All elements of subset must be present"));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.bandCount()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)b -> {
            newBands$2[b] = set.contains((Object)BoxesRunTime.boxToInteger((int)b)) ? this.band(b).mapDouble((Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable & scala.Serializable)z -> f.apply$mcDID$sp(b, z)) : this.band(b);
        });
        return ArrayMultibandTile$.MODULE$.apply(newBands);
    }

    @Override
    public MultibandTile map(Function2<Object, Object, Object> f) {
        Tile[] newBands = (Tile[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.apply(Tile.class));
        IntRef index$macro$3 = IntRef.create((int)0);
        while (index$macro$3.elem < this.bandCount()) {
            newBands[index$macro$3.elem] = this.band(index$macro$3.elem).map((Function1<Object, Object>)(JFunction1.mcII.sp & Serializable & scala.Serializable)z -> f.apply$mcIII$sp(index$macro$3$1.elem, z));
            ++index$macro$3.elem;
        }
        return ArrayMultibandTile$.MODULE$.apply(newBands);
    }

    @Override
    public MultibandTile mapDouble(Function2<Object, Object, Object> f) {
        Tile[] newBands = (Tile[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.apply(Tile.class));
        IntRef index$macro$4 = IntRef.create((int)0);
        while (index$macro$4.elem < this.bandCount()) {
            newBands[index$macro$4.elem] = this.band(index$macro$4.elem).mapDouble((Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable & scala.Serializable)z -> f.apply$mcDID$sp(index$macro$4$1.elem, z));
            ++index$macro$4.elem;
        }
        return ArrayMultibandTile$.MODULE$.apply(newBands);
    }

    @Override
    public MultibandTile map(int b0, Function1<Object, Object> f) {
        this.validateBand(b0);
        Tile[] newBands = (Tile[])this._bands.clone();
        newBands[b0] = this.band(b0).map(f);
        return ArrayMultibandTile$.MODULE$.apply(newBands);
    }

    @Override
    public MultibandTile mapDouble(int b0, Function1<Object, Object> f) {
        this.validateBand(b0);
        Tile[] newBands = (Tile[])this._bands.clone();
        newBands[b0] = this.band(b0).mapDouble(f);
        return ArrayMultibandTile$.MODULE$.apply(newBands);
    }

    @Override
    public void foreach(Function2<Object, Object, BoxedUnit> f) {
        IntRef index$macro$5 = IntRef.create((int)0);
        while (index$macro$5.elem < this.bandCount()) {
            this.band(index$macro$5.elem).foreach((Function1<Object, BoxedUnit>)(JFunction1.mcVI.sp & Serializable & scala.Serializable)z -> f.apply$mcVII$sp(index$macro$5$1.elem, z));
            ++index$macro$5.elem;
        }
    }

    @Override
    public void foreachDouble(Function2<Object, Object, BoxedUnit> f) {
        IntRef index$macro$6 = IntRef.create((int)0);
        while (index$macro$6.elem < this.bandCount()) {
            this.band(index$macro$6.elem).foreachDouble((Function1<Object, BoxedUnit>)(JFunction1.mcVD.sp & Serializable & scala.Serializable)z -> f.apply$mcVID$sp(index$macro$6$1.elem, z));
            ++index$macro$6.elem;
        }
    }

    @Override
    public void foreach(int b0, Function1<Object, BoxedUnit> f) {
        this.validateBand(b0);
        this.band(b0).foreach(f);
    }

    @Override
    public void foreachDouble(int b0, Function1<Object, BoxedUnit> f) {
        this.validateBand(b0);
        this.band(b0).foreachDouble(f);
    }

    @Override
    public void foreach(Function1<int[], BoxedUnit> f) {
        int i = 0;
        for (int index$macro$9 = 0; index$macro$9 < this.cols(); ++index$macro$9) {
            for (int index$macro$8 = 0; index$macro$8 < this.rows(); ++index$macro$8) {
                int[] bandValues = (int[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.Int());
                for (int index$macro$7 = 0; index$macro$7 < this.bandCount(); ++index$macro$7) {
                    bandValues[index$macro$7] = ((Tile)this.bands().apply(index$macro$7)).get(index$macro$9, index$macro$8);
                }
                f.apply((Object)bandValues);
                ++i;
            }
        }
    }

    @Override
    public void foreachDouble(Function1<double[], BoxedUnit> f) {
        int i = 0;
        for (int index$macro$12 = 0; index$macro$12 < this.cols(); ++index$macro$12) {
            for (int index$macro$11 = 0; index$macro$11 < this.rows(); ++index$macro$11) {
                double[] bandValues = (double[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.Double());
                for (int index$macro$10 = 0; index$macro$10 < this.bandCount(); ++index$macro$10) {
                    bandValues[index$macro$10] = ((Tile)this.bands().apply(index$macro$10)).getDouble(index$macro$12, index$macro$11);
                }
                f.apply((Object)bandValues);
                ++i;
            }
        }
    }

    @Override
    public Tile combine(Seq<Object> subset, Function1<Seq<Object>, Object> f) {
        subset.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)b -> Predef$.MODULE$.require(0 <= b && b < this.bandCount(), (Function0 & Serializable & scala.Serializable)() -> "All elements of subset must be present"));
        int subsetSize = subset.size();
        int[] subsetArray = (int[])subset.toArray(ClassTag$.MODULE$.Int());
        MutableArrayTile result = ArrayTile$.MODULE$.empty(this.cellType(), this.cols(), this.rows());
        int[] values = (int[])Array$.MODULE$.ofDim(subsetSize, ClassTag$.MODULE$.Int());
        for (int index$macro$15 = 0; index$macro$15 < this.rows(); ++index$macro$15) {
            for (int index$macro$14 = 0; index$macro$14 < this.cols(); ++index$macro$14) {
                for (int index$macro$13 = 0; index$macro$13 < subsetSize; ++index$macro$13) {
                    values[index$macro$13] = this._bands[subsetArray[index$macro$13]].get(index$macro$14, index$macro$15);
                }
                result.set(index$macro$14, index$macro$15, BoxesRunTime.unboxToInt((Object)f.apply((Object)Predef$.MODULE$.wrapIntArray(values))));
            }
        }
        return result;
    }

    @Override
    public Tile combineDouble(Seq<Object> subset, Function1<Seq<Object>, Object> f) {
        subset.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)b -> Predef$.MODULE$.require(0 <= b && b < this.bandCount(), (Function0 & Serializable & scala.Serializable)() -> "All elements of subset must be present"));
        int subsetSize = subset.size();
        int[] subsetArray = (int[])subset.toArray(ClassTag$.MODULE$.Int());
        MutableArrayTile result = ArrayTile$.MODULE$.empty(this.cellType(), this.cols(), this.rows());
        double[] values = (double[])Array$.MODULE$.ofDim(subsetSize, ClassTag$.MODULE$.Double());
        for (int index$macro$18 = 0; index$macro$18 < this.rows(); ++index$macro$18) {
            for (int index$macro$17 = 0; index$macro$17 < this.cols(); ++index$macro$17) {
                for (int index$macro$16 = 0; index$macro$16 < subsetSize; ++index$macro$16) {
                    values[index$macro$16] = this._bands[subsetArray[index$macro$16]].getDouble(index$macro$17, index$macro$18);
                }
                result.setDouble(index$macro$17, index$macro$18, BoxesRunTime.unboxToDouble((Object)f.apply((Object)Predef$.MODULE$.wrapDoubleArray(values))));
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile combine(Function1<int[], Object> f) {
        void var2_2;
        MutableArrayTile result = ArrayTile$.MODULE$.empty(this.cellType(), this.cols(), this.rows());
        int[] arr = (int[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.Int());
        for (int index$macro$21 = 0; index$macro$21 < this.rows(); ++index$macro$21) {
            for (int index$macro$20 = 0; index$macro$20 < this.cols(); ++index$macro$20) {
                for (int index$macro$19 = 0; index$macro$19 < this.bandCount(); ++index$macro$19) {
                    arr[index$macro$19] = this.band(index$macro$19).get(index$macro$20, index$macro$21);
                }
                result.set(index$macro$20, index$macro$21, BoxesRunTime.unboxToInt((Object)f.apply((Object)arr)));
            }
        }
        return var2_2;
    }

    @Override
    public Tile combine(int b0, int b1, Function2<Object, Object, Object> f) {
        Tile band1 = this.band(b0);
        Tile band2 = this.band(b1);
        MutableArrayTile result = ArrayTile$.MODULE$.empty(this.cellType(), this.cols(), this.rows());
        for (int index$macro$23 = 0; index$macro$23 < this.rows(); ++index$macro$23) {
            for (int index$macro$22 = 0; index$macro$22 < this.cols(); ++index$macro$22) {
                result.set(index$macro$22, index$macro$23, f.apply$mcIII$sp(band1.get(index$macro$22, index$macro$23), band2.get(index$macro$22, index$macro$23)));
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MutableArrayTile combineDouble(Function1<double[], Object> f) {
        void var2_2;
        MutableArrayTile result = ArrayTile$.MODULE$.empty(this.cellType(), this.cols(), this.rows());
        double[] arr = (double[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.Double());
        for (int index$macro$26 = 0; index$macro$26 < this.rows(); ++index$macro$26) {
            for (int index$macro$25 = 0; index$macro$25 < this.cols(); ++index$macro$25) {
                for (int index$macro$24 = 0; index$macro$24 < this.bandCount(); ++index$macro$24) {
                    arr[index$macro$24] = this.band(index$macro$24).getDouble(index$macro$25, index$macro$26);
                }
                result.setDouble(index$macro$25, index$macro$26, BoxesRunTime.unboxToDouble((Object)f.apply((Object)arr)));
            }
        }
        return var2_2;
    }

    @Override
    public Tile combineDouble(int b0, int b1, Function2<Object, Object, Object> f) {
        Tile band1 = this.band(b0);
        Tile band2 = this.band(b1);
        MutableArrayTile result = ArrayTile$.MODULE$.empty(this.cellType(), this.cols(), this.rows());
        int[] arr = (int[])Array$.MODULE$.ofDim(this.bandCount(), ClassTag$.MODULE$.Int());
        for (int index$macro$28 = 0; index$macro$28 < this.rows(); ++index$macro$28) {
            for (int index$macro$27 = 0; index$macro$27 < this.cols(); ++index$macro$27) {
                result.setDouble(index$macro$27, index$macro$28, f.apply$mcDDD$sp(band1.getDouble(index$macro$27, index$macro$28), band2.getDouble(index$macro$27, index$macro$28)));
            }
        }
        return result;
    }

    @Override
    public ArrayMultibandTile subsetBands(Seq<Object> bandSequence) {
        Tile[] newBands = (Tile[])Array$.MODULE$.ofDim(bandSequence.size(), ClassTag$.MODULE$.apply(Tile.class));
        IntRef i = IntRef.create((int)0);
        Predef$.MODULE$.require(bandSequence.size() <= this.bandCount());
        bandSequence.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)j -> {
            newBands$3[i$2.elem] = this.band(j);
            ++i$2.elem;
        });
        return new ArrayMultibandTile(newBands);
    }

    public boolean equals(Object other) {
        boolean bl;
        Object object = other;
        if (object instanceof ArrayMultibandTile) {
            ArrayMultibandTile arrayMultibandTile = (ArrayMultibandTile)object;
            boolean result = this.bandCount() == arrayMultibandTile.bandCount();
            for (int index$macro$29 = 0; result && index$macro$29 < this.bandCount(); ++index$macro$29) {
                Tile tile = this.band(index$macro$29);
                Tile tile2 = arrayMultibandTile.band(index$macro$29);
                if (!(tile == null ? tile2 != null : !tile.equals(tile2))) continue;
                result = false;
            }
            bl = result;
        } else {
            bl = false;
        }
        return bl;
    }

    public ArrayMultibandTile(Tile[] _bands) {
        this._bands = _bands;
        Grid.$init$(this);
        MacroCombineFunctions.$init$((MacroCombineFunctions)this);
        MultibandTile.$init$(this);
        MacroMultibandCombiners.$init$(this);
        this.bandCount = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])_bands)).size();
        Predef$.MODULE$.assert(this.bandCount() > 0, (Function0 & Serializable & scala.Serializable)() -> "Band count must be greater than 0");
        this.cellType = _bands[0].cellType();
        this.cols = _bands[0].cols();
        this.rows = _bands[0].rows();
        IntRef index$macro$1 = IntRef.create((int)0);
        while (index$macro$1.elem < this.bandCount()) {
            DataType dataType = _bands[index$macro$1.elem].cellType();
            DataType dataType2 = this.cellType();
            Predef$.MODULE$.assert(!(dataType != null ? !dataType.equals(dataType2) : dataType2 != null), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Band ").append(index$macro$1$1.elem).append(" cell type does not match, ").append($this._bands[index$macro$1$1.elem].cellType()).append(" != ").append(this.cellType()).toString());
            Predef$.MODULE$.assert(_bands[index$macro$1.elem].cols() == this.cols(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Band ").append(index$macro$1$1.elem).append(" cols does not match, ").append($this._bands[index$macro$1$1.elem].cols()).append(" != ").append(this.cols()).toString());
            Predef$.MODULE$.assert(_bands[index$macro$1.elem].rows() == this.rows(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Band ").append(index$macro$1$1.elem).append(" rows does not match, ").append($this._bands[index$macro$1$1.elem].rows()).append(" != ").append(this.rows()).toString());
            ++index$macro$1.elem;
        }
    }
}

