/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.BitArrayTile$;
import geotrellis.raster.BitCellType$;
import geotrellis.raster.BitConstantTile;
import geotrellis.raster.ByteArrayTile$;
import geotrellis.raster.ByteCells;
import geotrellis.raster.CellSet;
import geotrellis.raster.DataType;
import geotrellis.raster.Grid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.IterableTile;
import geotrellis.raster.MappableTile;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005h\u0001B\u0001\u0003\u0005\u001e\u0011ABQ5u\u0003J\u0014\u0018-\u001f+jY\u0016T!a\u0001\u0003\u0002\rI\f7\u000f^3s\u0015\u0005)\u0011AC4f_R\u0014X\r\u001c7jg\u000e\u00011#\u0002\u0001\t\u001dI)\u0002CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\r\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\t\u0001R*\u001e;bE2,\u0017I\u001d:bsRKG.\u001a\t\u0003\u0013MI!\u0001\u0006\u0006\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0011BF\u0005\u0003/)\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\"\u0007\u0001\u0003\u0016\u0004%\tAG\u0001\u0006CJ\u0014\u0018-_\u000b\u00027A\u0019\u0011\u0002\b\u0010\n\u0005uQ!!B!se\u0006L\bCA\u0005 \u0013\t\u0001#B\u0001\u0003CsR,\u0007\u0002\u0003\u0012\u0001\u0005#\u0005\u000b\u0011B\u000e\u0002\r\u0005\u0014(/Y=!\u0011!!\u0003A!f\u0001\n\u0003)\u0013\u0001B2pYN,\u0012A\n\t\u0003\u0013\u001dJ!\u0001\u000b\u0006\u0003\u0007%sG\u000f\u0003\u0005+\u0001\tE\t\u0015!\u0003'\u0003\u0015\u0019w\u000e\\:!\u0011!a\u0003A!f\u0001\n\u0003)\u0013\u0001\u0002:poND\u0001B\f\u0001\u0003\u0012\u0003\u0006IAJ\u0001\u0006e><8\u000f\t\u0005\u0006a\u0001!\t!M\u0001\u0007y%t\u0017\u000e\u001e \u0015\tI\u001aD'\u000e\t\u0003\u001f\u0001AQ!G\u0018A\u0002mAQ\u0001J\u0018A\u0002\u0019BQ\u0001L\u0018A\u0002\u0019Bqa\u000e\u0001C\u0002\u0013\u0005\u0001(\u0001\u0005dK2dG+\u001f9f+\u0005IdBA\b;\u0013\tY$!A\u0006CSR\u001cU\r\u001c7UsB,\u0007BB\u001f\u0001A\u0003%\u0011(A\u0005dK2dG+\u001f9fA!)q\b\u0001C\u0001\u0001\u0006)\u0011\r\u001d9msR\u0011a%\u0011\u0005\u0006\u0005z\u0002\rAJ\u0001\u0002S\")A\t\u0001C\u0001\u000b\u00061Q\u000f\u001d3bi\u0016$2AR%K!\tIq)\u0003\u0002I\u0015\t!QK\\5u\u0011\u0015\u00115\t1\u0001'\u0011\u0015Y5\t1\u0001'\u0003\u0005Q\b\"B'\u0001\t\u0003q\u0015aC1qa2LHi\\;cY\u0016$\"a\u0014*\u0011\u0005%\u0001\u0016BA)\u000b\u0005\u0019!u.\u001e2mK\")!\t\u0014a\u0001M!)A\u000b\u0001C\u0001+\u0006aQ\u000f\u001d3bi\u0016$u.\u001e2mKR\u0019aIV,\t\u000b\t\u001b\u0006\u0019\u0001\u0014\t\u000b-\u001b\u0006\u0019A(\t\u000be\u0003A\u0011\t.\u0002\u00075\f\u0007\u000f\u0006\u0002\\=B\u0011q\u0002X\u0005\u0003;\n\u0011A\u0001V5mK\")q\f\u0017a\u0001A\u0006\ta\r\u0005\u0003\nC\u001a2\u0013B\u00012\u000b\u0005%1UO\\2uS>t\u0017\u0007C\u0003e\u0001\u0011\u0005S-A\u0005nCB$u.\u001e2mKR\u00111L\u001a\u0005\u0006?\u000e\u0004\ra\u001a\t\u0005\u0013\u0005|u\nC\u0003j\u0001\u0011\u0005!.\u0001\u0003d_BLX#\u0001\u001a\t\u000b1\u0004A\u0011A7\u0002\u000fQ|')\u001f;fgR\t1\u0004C\u0003p\u0001\u0011\u0005\u0001/\u0001\u0006xSRDgj\u001c#bi\u0006$\"aW9\t\u000bIt\u0007\u0019A:\u0002\u00179|G)\u0019;b-\u0006dW/\u001a\t\u0004\u0013Q|\u0015BA;\u000b\u0005\u0019y\u0005\u000f^5p]\")q\u000f\u0001C\u0001q\u0006Y\u0011N\u001c;feB\u0014X\r^!t)\tY\u0016\u0010C\u0003{m\u0002\u000710A\u0006oK^\u001cU\r\u001c7UsB,\u0007C\u0001?\u0000\u001d\tyQ0\u0003\u0002\u007f\u0005\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0001\u0003\u0007\u0011\u0001bQ3mYRK\b/\u001a\u0006\u0003}\nA\u0011\"a\u0002\u0001\u0003\u0003%\t%!\u0003\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tY\u0001\u0005\u0003\u0002\u000e\u0005]QBAA\b\u0015\u0011\t\t\"a\u0005\u0002\t1\fgn\u001a\u0006\u0003\u0003+\tAA[1wC&!\u0011\u0011DA\b\u0005\u0019\u0019FO]5oO\"A\u0011Q\u0004\u0001\u0002\u0002\u0013\u0005Q%\u0001\u0007qe>$Wo\u0019;Be&$\u0018\u0010C\u0005\u0002\"\u0001\t\t\u0011\"\u0001\u0002$\u0005q\u0001O]8ek\u000e$X\t\\3nK:$H\u0003BA\u0013\u0003W\u00012!CA\u0014\u0013\r\tIC\u0003\u0002\u0004\u0003:L\b\"CA\u0017\u0003?\t\t\u00111\u0001'\u0003\rAH%\r\u0005\n\u0003c\u0001\u0011\u0011!C!\u0003g\tq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003k\u0001b!a\u000e\u0002>\u0005\u0015RBAA\u001d\u0015\r\tYDC\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA \u0003s\u0011\u0001\"\u0013;fe\u0006$xN\u001d\u0005\n\u0003\u0007\u0002\u0011\u0011!C\u0001\u0003\u000b\n\u0001bY1o\u000bF,\u0018\r\u001c\u000b\u0005\u0003\u000f\ni\u0005E\u0002\n\u0003\u0013J1!a\u0013\u000b\u0005\u001d\u0011un\u001c7fC:D!\"!\f\u0002B\u0005\u0005\t\u0019AA\u0013\u0011%\t\t\u0006AA\u0001\n\u0003\n\u0019&\u0001\u0005iCND7i\u001c3f)\u00051\u0003\"CA,\u0001\u0005\u0005I\u0011IA-\u0003!!xn\u0015;sS:<GCAA\u0006\u000f\u001d\tiF\u0001E\u0001\u0003?\nABQ5u\u0003J\u0014\u0018-\u001f+jY\u0016\u00042aDA1\r\u0019\t!\u0001#\u0001\u0002dM!\u0011\u0011\r\u0005\u0016\u0011\u001d\u0001\u0014\u0011\rC\u0001\u0003O\"\"!a\u0018\t\u000f\u0011\u000b\t\u0007\"\u0001\u0002lQ9a)!\u001c\u0002r\u0005M\u0004bBA8\u0003S\u0002\raG\u0001\u0004CJ\u0014\bB\u0002\"\u0002j\u0001\u0007a\u0005\u0003\u0004L\u0003S\u0002\rA\n\u0005\b)\u0006\u0005D\u0011AA<)\u001d1\u0015\u0011PA>\u0003{Bq!a\u001c\u0002v\u0001\u00071\u0004\u0003\u0004C\u0003k\u0002\rA\n\u0005\u0007\u0017\u0006U\u0004\u0019A(\t\u0011\u0005\u0005\u0015\u0011\rC\u0001\u0003\u0007\u000bQa\u001c4ES6$RAMAC\u0003\u000fCa\u0001JA@\u0001\u00041\u0003B\u0002\u0017\u0002\u0000\u0001\u0007a\u0005\u0003\u0005\u0002\f\u0006\u0005D\u0011AAG\u0003\u0015)W\u000e\u001d;z)\u0015\u0011\u0014qRAI\u0011\u0019!\u0013\u0011\u0012a\u0001M!1A&!#A\u0002\u0019B\u0001\"!&\u0002b\u0011\u0005\u0011qS\u0001\u0005M&dG\u000eF\u00043\u00033\u000bi*a(\t\u000f\u0005m\u00151\u0013a\u0001M\u0005\ta\u000f\u0003\u0004%\u0003'\u0003\rA\n\u0005\u0007Y\u0005M\u0005\u0019\u0001\u0014\t\u0011\u0005U\u0015\u0011\rC\u0001\u0003G#rAMAS\u0003O\u000bI\u000b\u0003\u0005\u0002\u001c\u0006\u0005\u0006\u0019AA$\u0011\u0019!\u0013\u0011\u0015a\u0001M!1A&!)A\u0002\u0019B\u0001\"!,\u0002b\u0011\u0005\u0011qV\u0001\nMJ|WNQ=uKN$rAMAY\u0003k\u000b9\fC\u0004\u00024\u0006-\u0006\u0019A\u000e\u0002\u000b\tLH/Z:\t\r\u0011\nY\u000b1\u0001'\u0011\u0019a\u00131\u0016a\u0001M!Iq(!\u0019\u0002\u0002\u0013\u0005\u00151\u0018\u000b\be\u0005u\u0016qXAa\u0011\u0019I\u0012\u0011\u0018a\u00017!1A%!/A\u0002\u0019Ba\u0001LA]\u0001\u00041\u0003BCAc\u0003C\n\t\u0011\"!\u0002H\u00069QO\\1qa2LH\u0003BAe\u0003#\u0004B!\u0003;\u0002LB1\u0011\"!4\u001cM\u0019J1!a4\u000b\u0005\u0019!V\u000f\u001d7fg!I\u00111[Ab\u0003\u0003\u0005\rAM\u0001\u0004q\u0012\u0002\u0004BCAl\u0003C\n\t\u0011\"\u0003\u0002Z\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tY\u000e\u0005\u0003\u0002\u000e\u0005u\u0017\u0002BAp\u0003\u001f\u0011aa\u00142kK\u000e$\b")
public final class BitArrayTile
implements MutableArrayTile,
Product {
    private final byte[] array;
    private final int cols;
    private final int rows;
    private final BitCellType$ cellType;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple3<byte[], Object, Object>> unapply(BitArrayTile bitArrayTile) {
        return BitArrayTile$.MODULE$.unapply(bitArrayTile);
    }

    public static BitArrayTile fromBytes(byte[] byArray, int n, int n2) {
        return BitArrayTile$.MODULE$.fromBytes(byArray, n, n2);
    }

    public static BitArrayTile fill(boolean bl, int n, int n2) {
        return BitArrayTile$.MODULE$.fill(bl, n, n2);
    }

    public static BitArrayTile fill(int n, int n2, int n3) {
        return BitArrayTile$.MODULE$.fill(n, n2, n3);
    }

    public static BitArrayTile empty(int n, int n2) {
        return BitArrayTile$.MODULE$.empty(n, n2);
    }

    public static BitArrayTile ofDim(int n, int n2) {
        return BitArrayTile$.MODULE$.ofDim(n, n2);
    }

    @Override
    public MutableArrayTile mutable() {
        return MutableArrayTile.mutable$(this);
    }

    @Override
    public void set(int col, int row, int value) {
        MutableArrayTile.set$(this, col, row, value);
    }

    @Override
    public void setDouble(int col, int row, double value) {
        MutableArrayTile.setDouble$(this, col, row, value);
    }

    @Override
    public void update(int colOffset, int rowOffset, Tile update) {
        MutableArrayTile.update$(this, colOffset, rowOffset, update);
    }

    @Override
    public ArrayTile toArrayTile() {
        return ArrayTile.toArrayTile$(this);
    }

    @Override
    public ArrayTile convert(DataType targetCellType) {
        return ArrayTile.convert$(this, targetCellType);
    }

    @Override
    public void foreach(Function1<Object, BoxedUnit> f) {
        ArrayTile.foreach$(this, f);
    }

    @Override
    public void foreachDouble(Function1<Object, BoxedUnit> f) {
        ArrayTile.foreachDouble$(this, f);
    }

    @Override
    public void foreachIntVisitor(IntTileVisitor visitor) {
        ArrayTile.foreachIntVisitor$(this, visitor);
    }

    @Override
    public void foreachDoubleVisitor(DoubleTileVisitor visitor) {
        ArrayTile.foreachDoubleVisitor$(this, visitor);
    }

    @Override
    public Tile mapIntMapper(IntTileMapper mapper) {
        return ArrayTile.mapIntMapper$(this, mapper);
    }

    @Override
    public Tile mapDoubleMapper(DoubleTileMapper mapper) {
        return ArrayTile.mapDoubleMapper$(this, mapper);
    }

    @Override
    public ArrayTile combine(ArrayTile other, Function2<Object, Object, Object> f) {
        return ArrayTile.combine$((ArrayTile)this, other, f);
    }

    @Override
    public Tile combine(Tile other, Function2<Object, Object, Object> f) {
        return ArrayTile.combine$((ArrayTile)this, other, f);
    }

    @Override
    public ArrayTile combineDouble(ArrayTile other, Function2<Object, Object, Object> f) {
        return ArrayTile.combineDouble$((ArrayTile)this, other, f);
    }

    @Override
    public Tile combineDouble(Tile other, Function2<Object, Object, Object> f) {
        return ArrayTile.combineDouble$((ArrayTile)this, other, f);
    }

    @Override
    public boolean equals(Object other) {
        return ArrayTile.equals$(this, other);
    }

    @Override
    public int get(int col, int row) {
        return ArrayTile.get$(this, col, row);
    }

    @Override
    public double getDouble(int col, int row) {
        return ArrayTile.getDouble$(this, col, row);
    }

    @Override
    public List<Object> toList() {
        return ArrayTile.toList$(this);
    }

    @Override
    public List<Object> toListDouble() {
        return ArrayTile.toListDouble$(this);
    }

    @Override
    public int[] toArray() {
        return ArrayTile.toArray$(this);
    }

    @Override
    public double[] toArrayDouble() {
        return ArrayTile.toArrayDouble$(this);
    }

    @Override
    public void dualForeach(Function1<Object, BoxedUnit> f, Function1<Object, BoxedUnit> g) {
        Tile.dualForeach$(this, f, g);
    }

    @Override
    public Tile mapIfSet(Function1<Object, Object> f) {
        return Tile.mapIfSet$(this, f);
    }

    @Override
    public Tile mapIfSetDouble(Function1<Object, Object> f) {
        return Tile.mapIfSetDouble$(this, f);
    }

    @Override
    public Tile dualMap(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile.dualMap$(this, f, g);
    }

    @Override
    public Tile dualMapIfSet(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile.dualMapIfSet$(this, f, g);
    }

    @Override
    public Tile dualCombine(Tile r2, Function2<Object, Object, Object> f, Function2<Object, Object, Object> g) {
        return Tile.dualCombine$(this, r2, f, g);
    }

    @Override
    public boolean isNoDataTile() {
        return Tile.isNoDataTile$(this);
    }

    @Override
    public Tile normalize(int oldMin, int oldMax, int newMin, int newMax) {
        return Tile.normalize$((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile normalize(double oldMin, double oldMax, double newMin, double newMax) {
        return Tile.normalize$((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile rescale(int newMin, int newMax) {
        return Tile.rescale$((Tile)this, newMin, newMax);
    }

    @Override
    public Tile rescale(double newMin, double newMax) {
        return Tile.rescale$((Tile)this, newMin, newMax);
    }

    @Override
    public Tile downsample(int newCols, int newRows, Function1<CellSet, Object> f) {
        return Tile.downsample$(this, newCols, newRows, f);
    }

    @Override
    public Tuple2<Object, Object> findMinMax() {
        return Tile.findMinMax$(this);
    }

    @Override
    public Tuple2<Object, Object> findMinMaxDouble() {
        return Tile.findMinMaxDouble$(this);
    }

    @Override
    public int size() {
        return Grid.size$(this);
    }

    @Override
    public Tuple2<Object, Object> dimensions() {
        return Grid.dimensions$(this);
    }

    @Override
    public GridBounds gridBounds() {
        return Grid.gridBounds$(this);
    }

    private Logger logger$lzycompute() {
        BitArrayTile bitArrayTile = this;
        synchronized (bitArrayTile) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public byte[] array() {
        return this.array;
    }

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public BitCellType$ cellType() {
        return this.cellType;
    }

    @Override
    public int apply(int i) {
        return this.array()[i >> 3] >> (i & 7) & 1;
    }

    @Override
    public void update(int i, int z) {
        BitArrayTile$.MODULE$.update(this.array(), i, z);
    }

    @Override
    public double applyDouble(int i) {
        int n = this.apply(i);
        return n == Integer.MIN_VALUE ? Double.NaN : (double)n;
    }

    @Override
    public void updateDouble(int i, double z) {
        BitArrayTile$.MODULE$.updateDouble(this.array(), i, z);
    }

    @Override
    public Tile map(Function1<Object, Object> f) {
        Tile tile;
        int f0 = f.apply$mcII$sp(0) & 1;
        int f1 = f.apply$mcII$sp(1) & 1;
        if (f0 == 0 && f1 == 0) {
            tile = new BitConstantTile(false, this.cols(), this.rows());
        } else if (f0 == 1 && f1 == 1) {
            tile = new BitConstantTile(true, this.cols(), this.rows());
        } else if (f0 == 0 && f1 == 1) {
            tile = this;
        } else {
            byte[] clone = (byte[])this.array().clone();
            int len = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(this.array())).size();
            for (int i = 0; i < len; ++i) {
                clone[i] = ~this.array()[i];
            }
            tile = new BitArrayTile(clone, this.cols(), this.rows());
        }
        return tile;
    }

    @Override
    public Tile mapDouble(Function1<Object, Object> f) {
        return this.map((Function1<Object, Object>)(JFunction1.mcII.sp & Serializable & scala.Serializable)z -> {
            int n = z;
            double n2 = f.apply$mcDD$sp(n == Integer.MIN_VALUE ? Double.NaN : (double)n);
            return Double.isNaN(n2) ? Integer.MIN_VALUE : (int)n2;
        });
    }

    @Override
    public BitArrayTile copy() {
        return new BitArrayTile((byte[])this.array().clone(), this.cols(), this.rows());
    }

    @Override
    public byte[] toBytes() {
        return (byte[])this.array().clone();
    }

    @Override
    public Tile withNoData(Option<Object> noDataValue) {
        return new BitArrayTile(this.array(), this.cols(), this.rows());
    }

    @Override
    public Tile interpretAs(DataType newCellType) {
        Tile tile;
        DataType dataType = newCellType;
        if (dataType instanceof ByteCells) {
            ByteCells byteCells = (ByteCells)((Object)dataType);
            tile = ByteArrayTile$.MODULE$.apply(this.array(), this.cols(), this.rows(), byteCells);
        } else {
            tile = this.withNoData((Option<Object>)None$.MODULE$).convert(newCellType);
        }
        return tile;
    }

    public String productPrefix() {
        return "BitArrayTile";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.array();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this.cols());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this.rows());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitArrayTile;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.array()));
        n = Statics.mix((int)n, (int)this.cols());
        n = Statics.mix((int)n, (int)this.rows());
        return Statics.finalizeHash((int)n, (int)3);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    public BitArrayTile(byte[] array, int cols, int rows) {
        this.array = array;
        this.cols = cols;
        this.rows = rows;
        Grid.$init$(this);
        IterableTile.$init$(this);
        MappableTile.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        Tile.$init$(this);
        ArrayTile.$init$(this);
        MutableArrayTile.$init$(this);
        Product.$init$((Product)this);
        if (new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(array)).size() != (this.size() + 7) / 8) {
            throw package$.MODULE$.error(new StringBuilder(40).append("BitArrayTile array length must be ").append((this.size() + 7) / 8).append(", was ").append(new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(array)).size()).toString());
        }
        this.cellType = BitCellType$.MODULE$;
    }
}

