/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.BitArrayTile$;
import geotrellis.raster.BitCellType$;
import geotrellis.raster.BitConstantTile$;
import geotrellis.raster.CellSet;
import geotrellis.raster.ConstantTile;
import geotrellis.raster.DataType;
import geotrellis.raster.Grid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.IterableTile;
import geotrellis.raster.MappableTile;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015w!B\u0001\u0003\u0011\u00039\u0011a\u0004\"ji\u000e{gn\u001d;b]R$\u0016\u000e\\3\u000b\u0005\r!\u0011A\u0002:bgR,'OC\u0001\u0006\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001!\tA\u0011\"D\u0001\u0003\r\u0015Q!\u0001#\u0001\f\u0005=\u0011\u0015\u000e^\"p]N$\u0018M\u001c;US2,7cA\u0005\r%A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u0004\"!D\n\n\u0005Qq!\u0001D*fe&\fG.\u001b>bE2,\u0007\"\u0002\f\n\t\u00039\u0012A\u0002\u001fj]&$h\bF\u0001\b\u0011\u0015I\u0012\u0002\"\u0001\u001b\u0003\u0015\t\u0007\u000f\u001d7z)\u001dY\u0012qQAF\u0003\u001b\u0003\"\u0001\u0003\u000f\u0007\t)\u0011\u0001)H\n\u000691q\u0012E\u0005\t\u0003\u0011}I!\u0001\t\u0002\u0003\u0019\r{gn\u001d;b]R$\u0016\u000e\\3\u0011\u00055\u0011\u0013BA\u0012\u000f\u0005\u001d\u0001&o\u001c3vGRD\u0001\"\n\u000f\u0003\u0016\u0004%\tAJ\u0001\u0002mV\tq\u0005\u0005\u0002\u000eQ%\u0011\u0011F\u0004\u0002\b\u0005>|G.Z1o\u0011!YCD!E!\u0002\u00139\u0013A\u0001<!\u0011!iCD!f\u0001\n\u0003q\u0013\u0001B2pYN,\u0012a\f\t\u0003\u001bAJ!!\r\b\u0003\u0007%sG\u000f\u0003\u000549\tE\t\u0015!\u00030\u0003\u0015\u0019w\u000e\\:!\u0011!)DD!f\u0001\n\u0003q\u0013\u0001\u0002:poND\u0001b\u000e\u000f\u0003\u0012\u0003\u0006IaL\u0001\u0006e><8\u000f\t\u0005\u0006-q!\t!\u000f\u000b\u00057iZD\bC\u0003&q\u0001\u0007q\u0005C\u0003.q\u0001\u0007q\u0006C\u00036q\u0001\u0007q\u0006C\u0004?9\t\u0007I\u0011\u0003\u0018\u0002\t%4\u0016\r\u001c\u0005\u0007\u0001r\u0001\u000b\u0011B\u0018\u0002\u000b%4\u0016\r\u001c\u0011\t\u000f\tc\"\u0019!C\t\u0007\u0006!AMV1m+\u0005!\u0005CA\u0007F\u0013\t1eB\u0001\u0004E_V\u0014G.\u001a\u0005\u0007\u0011r\u0001\u000b\u0011\u0002#\u0002\u000b\u00114\u0016\r\u001c\u0011\t\u000f)c\"\u0019!C\u0001\u0017\u0006A1-\u001a7m)f\u0004X-F\u0001M\u001d\tAQ*\u0003\u0002O\u0005\u0005Y!)\u001b;DK2dG+\u001f9f\u0011\u0019\u0001F\u0004)A\u0005\u0019\u0006I1-\u001a7m)f\u0004X\r\t\u0005\u0006%r!\taU\u0001\fi>\f%O]1z)&dW\rF\u0001U!\tAQ+\u0003\u0002W\u0005\tI\u0011I\u001d:bsRKG.\u001a\u0005\u00061r!\t!W\u0001\b[V$\u0018M\u00197f+\u0005Q\u0006C\u0001\u0005\\\u0013\ta&A\u0001\tNkR\f'\r\\3BeJ\f\u0017\u0010V5mK\")a\f\bC\u0001?\u00069Ao\u001c\"zi\u0016\u001cH#\u00011\u0011\u00075\t7-\u0003\u0002c\u001d\t)\u0011I\u001d:bsB\u0011Q\u0002Z\u0005\u0003K:\u0011AAQ=uK\")q\r\bC\u0001Q\u0006Qq/\u001b;i\u001d>$\u0015\r^1\u0015\u0005yI\u0007\"\u00026g\u0001\u0004Y\u0017a\u00038p\t\u0006$\u0018MV1mk\u0016\u00042!\u00047E\u0013\tigB\u0001\u0004PaRLwN\u001c\u0005\u0006_r!\t\u0001]\u0001\u0004[\u0006\u0004HCA9u!\tA!/\u0003\u0002t\u0005\t!A+\u001b7f\u0011\u0015)h\u000e1\u0001w\u0003\u00051\u0007\u0003B\u0007x_=J!\u0001\u001f\b\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\"\u0002>\u001d\t\u0003Y\u0018!C7ba\u0012{WO\u00197f)\t\tH\u0010C\u0003vs\u0002\u0007Q\u0010\u0005\u0003\u000eo\u0012#\u0005\u0002C@\u001d\u0003\u0003%\t!!\u0001\u0002\t\r|\u0007/\u001f\u000b\b7\u0005\r\u0011QAA\u0004\u0011\u001d)c\u0010%AA\u0002\u001dBq!\f@\u0011\u0002\u0003\u0007q\u0006C\u00046}B\u0005\t\u0019A\u0018\t\u0013\u0005-A$%A\u0005\u0002\u00055\u0011AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u001fQ3aJA\tW\t\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005}QBAA\f\u0015\u0011\tI\"a\u0007\u0002\u0013Ut7\r[3dW\u0016$'bAA\u000f\u001d\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0005\u0012q\u0003\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA\u00139E\u0005I\u0011AA\u0014\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!!\u000b+\u0007=\n\t\u0002C\u0005\u0002.q\t\n\u0011\"\u0001\u0002(\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u001a\u0004\"CA\u00199\u0005\u0005I\u0011IA\u001a\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jqV\u0011\u0011Q\u0007\t\u0005\u0003o\t\t%\u0004\u0002\u0002:)!\u00111HA\u001f\u0003\u0011a\u0017M\\4\u000b\u0005\u0005}\u0012\u0001\u00026bm\u0006LA!a\u0011\u0002:\t11\u000b\u001e:j]\u001eD\u0001\"a\u0012\u001d\u0003\u0003%\tAL\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\n\u0003\u0017b\u0012\u0011!C\u0001\u0003\u001b\na\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002P\u0005U\u0003cA\u0007\u0002R%\u0019\u00111\u000b\b\u0003\u0007\u0005s\u0017\u0010C\u0005\u0002X\u0005%\u0013\u0011!a\u0001_\u0005\u0019\u0001\u0010J\u0019\t\u0013\u0005mC$!A\u0005B\u0005u\u0013a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\u0005}\u0003CBA1\u0003O\ny%\u0004\u0002\u0002d)\u0019\u0011Q\r\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002j\u0005\r$\u0001C%uKJ\fGo\u001c:\t\u0013\u00055D$!A\u0005\u0002\u0005=\u0014\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007\u001d\n\t\b\u0003\u0006\u0002X\u0005-\u0014\u0011!a\u0001\u0003\u001fB\u0011\"!\u001e\u001d\u0003\u0003%\t%a\u001e\u0002\u0011!\f7\u000f[\"pI\u0016$\u0012a\f\u0005\n\u0003wb\u0012\u0011!C!\u0003{\n\u0001\u0002^8TiJLgn\u001a\u000b\u0003\u0003kA\u0011\"!!\u001d\u0003\u0003%\t%a!\u0002\r\u0015\fX/\u00197t)\r9\u0013Q\u0011\u0005\u000b\u0003/\ny(!AA\u0002\u0005=\u0003BBAE1\u0001\u0007q&A\u0001j\u0011\u0015i\u0003\u00041\u00010\u0011\u0015)\u0004\u00041\u00010\u0011\u001d\t\t*\u0003C\u0001\u0003'\u000b\u0011B\u001a:p[\nKH/Z:\u0015\u000fm\t)*!'\u0002\u001c\"9\u0011qSAH\u0001\u0004\u0001\u0017!\u00022zi\u0016\u001c\bBB\u0017\u0002\u0010\u0002\u0007q\u0006\u0003\u00046\u0003\u001f\u0003\ra\f\u0005\t3%\t\t\u0011\"!\u0002 R91$!)\u0002$\u0006\u0015\u0006BB\u0013\u0002\u001e\u0002\u0007q\u0005\u0003\u0004.\u0003;\u0003\ra\f\u0005\u0007k\u0005u\u0005\u0019A\u0018\t\u0013\u0005%\u0016\"!A\u0005\u0002\u0006-\u0016aB;oCB\u0004H.\u001f\u000b\u0005\u0003[\u000b)\f\u0005\u0003\u000eY\u0006=\u0006CB\u0007\u00022\u001ezs&C\u0002\u00024:\u0011a\u0001V;qY\u0016\u001c\u0004\"CA\\\u0003O\u000b\t\u00111\u0001\u001c\u0003\rAH\u0005\r\u0005\n\u0003wK\u0011\u0011!C\u0005\u0003{\u000b1B]3bIJ+7o\u001c7wKR\u0011\u0011q\u0018\t\u0005\u0003o\t\t-\u0003\u0003\u0002D\u0006e\"AB(cU\u0016\u001cG\u000f")
public class BitConstantTile
implements ConstantTile,
Product {
    private final boolean v;
    private final int cols;
    private final int rows;
    private final int iVal;
    private final double dVal;
    private final BitCellType$ cellType;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple3<Object, Object, Object>> unapply(BitConstantTile bitConstantTile) {
        return BitConstantTile$.MODULE$.unapply(bitConstantTile);
    }

    public static BitConstantTile apply(boolean bl, int n, int n2) {
        return BitConstantTile$.MODULE$.apply(bl, n, n2);
    }

    public static BitConstantTile fromBytes(byte[] byArray, int n, int n2) {
        return BitConstantTile$.MODULE$.fromBytes(byArray, n, n2);
    }

    public static BitConstantTile apply(int n, int n2, int n3) {
        return BitConstantTile$.MODULE$.apply(n, n2, n3);
    }

    @Override
    public int get(int col, int row) {
        return ConstantTile.get$(this, col, row);
    }

    @Override
    public double getDouble(int col, int row) {
        return ConstantTile.getDouble$(this, col, row);
    }

    @Override
    public int[] toArray() {
        return ConstantTile.toArray$(this);
    }

    @Override
    public double[] toArrayDouble() {
        return ConstantTile.toArrayDouble$(this);
    }

    @Override
    public Tile convert(DataType newType) {
        return ConstantTile.convert$(this, newType);
    }

    @Override
    public Tile interpretAs(DataType newCellType) {
        return ConstantTile.interpretAs$(this, newCellType);
    }

    @Override
    public void foreach(Function1<Object, BoxedUnit> f) {
        ConstantTile.foreach$(this, f);
    }

    @Override
    public void foreachDouble(Function1<Object, BoxedUnit> f) {
        ConstantTile.foreachDouble$(this, f);
    }

    @Override
    public void foreachIntVisitor(IntTileVisitor visitor) {
        ConstantTile.foreachIntVisitor$(this, visitor);
    }

    @Override
    public void foreachDoubleVisitor(DoubleTileVisitor visitor) {
        ConstantTile.foreachDoubleVisitor$(this, visitor);
    }

    @Override
    public Tile combine(Tile other, Function2<Object, Object, Object> f) {
        return ConstantTile.combine$(this, other, f);
    }

    @Override
    public Tile combineDouble(Tile other, Function2<Object, Object, Object> f) {
        return ConstantTile.combineDouble$(this, other, f);
    }

    @Override
    public Tile mapIntMapper(IntTileMapper mapper) {
        return ConstantTile.mapIntMapper$(this, mapper);
    }

    @Override
    public Tile mapDoubleMapper(DoubleTileMapper mapper) {
        return ConstantTile.mapDoubleMapper$(this, mapper);
    }

    @Override
    public void dualForeach(Function1<Object, BoxedUnit> f, Function1<Object, BoxedUnit> g) {
        Tile.dualForeach$(this, f, g);
    }

    @Override
    public Tile mapIfSet(Function1<Object, Object> f) {
        return Tile.mapIfSet$(this, f);
    }

    @Override
    public Tile mapIfSetDouble(Function1<Object, Object> f) {
        return Tile.mapIfSetDouble$(this, f);
    }

    @Override
    public Tile dualMap(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile.dualMap$(this, f, g);
    }

    @Override
    public Tile dualMapIfSet(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile.dualMapIfSet$(this, f, g);
    }

    @Override
    public Tile dualCombine(Tile r2, Function2<Object, Object, Object> f, Function2<Object, Object, Object> g) {
        return Tile.dualCombine$(this, r2, f, g);
    }

    @Override
    public boolean isNoDataTile() {
        return Tile.isNoDataTile$(this);
    }

    @Override
    public Tile normalize(int oldMin, int oldMax, int newMin, int newMax) {
        return Tile.normalize$((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile normalize(double oldMin, double oldMax, double newMin, double newMax) {
        return Tile.normalize$((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile rescale(int newMin, int newMax) {
        return Tile.rescale$((Tile)this, newMin, newMax);
    }

    @Override
    public Tile rescale(double newMin, double newMax) {
        return Tile.rescale$((Tile)this, newMin, newMax);
    }

    @Override
    public Tile downsample(int newCols, int newRows, Function1<CellSet, Object> f) {
        return Tile.downsample$(this, newCols, newRows, f);
    }

    @Override
    public Tuple2<Object, Object> findMinMax() {
        return Tile.findMinMax$(this);
    }

    @Override
    public Tuple2<Object, Object> findMinMaxDouble() {
        return Tile.findMinMaxDouble$(this);
    }

    @Override
    public int size() {
        return Grid.size$(this);
    }

    @Override
    public Tuple2<Object, Object> dimensions() {
        return Grid.dimensions$(this);
    }

    @Override
    public GridBounds gridBounds() {
        return Grid.gridBounds$(this);
    }

    private Logger logger$lzycompute() {
        BitConstantTile bitConstantTile = this;
        synchronized (bitConstantTile) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public boolean v() {
        return this.v;
    }

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public int iVal() {
        return this.iVal;
    }

    @Override
    public double dVal() {
        return this.dVal;
    }

    @Override
    public BitCellType$ cellType() {
        return this.cellType;
    }

    @Override
    public ArrayTile toArrayTile() {
        return this.mutable();
    }

    @Override
    public MutableArrayTile mutable() {
        return BitArrayTile$.MODULE$.fill(this.v(), this.cols(), this.rows());
    }

    @Override
    public byte[] toBytes() {
        return new byte[]{(byte)this.iVal()};
    }

    @Override
    public ConstantTile withNoData(Option<Object> noDataValue) {
        return this;
    }

    @Override
    public Tile map(Function1<Object, Object> f) {
        return BitConstantTile$.MODULE$.apply(f.apply$mcII$sp(this.iVal()), this.cols(), this.rows());
    }

    @Override
    public Tile mapDouble(Function1<Object, Object> f) {
        double n = f.apply$mcDD$sp(this.dVal());
        return BitConstantTile$.MODULE$.apply(Double.isNaN(n) ? Integer.MIN_VALUE : (int)n, this.cols(), this.rows());
    }

    public BitConstantTile copy(boolean v, int cols, int rows) {
        return new BitConstantTile(v, cols, rows);
    }

    public boolean copy$default$1() {
        return this.v();
    }

    public int copy$default$2() {
        return this.cols();
    }

    public int copy$default$3() {
        return this.rows();
    }

    public String productPrefix() {
        return "BitConstantTile";
    }

    public int productArity() {
        return 3;
    }

    public Object productElement(int x$1) {
        Comparable<Boolean> comparable;
        int n = x$1;
        switch (n) {
            case 0: {
                comparable = BoxesRunTime.boxToBoolean((boolean)this.v());
                break;
            }
            case 1: {
                comparable = BoxesRunTime.boxToInteger((int)this.cols());
                break;
            }
            case 2: {
                comparable = BoxesRunTime.boxToInteger((int)this.rows());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return comparable;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof BitConstantTile;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)(this.v() ? 1231 : 1237));
        n = Statics.mix((int)n, (int)this.cols());
        n = Statics.mix((int)n, (int)this.rows());
        return Statics.finalizeHash((int)n, (int)3);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof BitConstantTile)) return false;
        boolean bl = true;
        if (!bl) return false;
        BitConstantTile bitConstantTile = (BitConstantTile)x$1;
        if (this.v() != bitConstantTile.v()) return false;
        if (this.cols() != bitConstantTile.cols()) return false;
        if (this.rows() != bitConstantTile.rows()) return false;
        if (!bitConstantTile.canEqual(this)) return false;
        return true;
    }

    public BitConstantTile(boolean v, int cols, int rows) {
        this.v = v;
        this.cols = cols;
        this.rows = rows;
        Grid.$init$(this);
        IterableTile.$init$(this);
        MappableTile.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        Tile.$init$(this);
        ConstantTile.$init$(this);
        Product.$init$((Product)this);
        this.iVal = v ? 1 : 0;
        this.dVal = v ? 1.0 : 0.0;
        this.cellType = BitCellType$.MODULE$;
    }
}

