/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.ByteArrayTile$;
import geotrellis.raster.ByteCells;
import geotrellis.raster.ByteConstantTile$;
import geotrellis.raster.ByteUserDefinedNoDataCellType;
import geotrellis.raster.CellSet;
import geotrellis.raster.ConstantNoData;
import geotrellis.raster.ConstantTile;
import geotrellis.raster.DataType;
import geotrellis.raster.Grid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.IterableTile;
import geotrellis.raster.MappableTile;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.NoNoData;
import geotrellis.raster.Tile;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\t\u001da\u0001B\u0001\u0003\u0001\u001e\u0011\u0001CQ=uK\u000e{gn\u001d;b]R$\u0016\u000e\\3\u000b\u0005\r!\u0011A\u0002:bgR,'OC\u0001\u0006\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001'\u0015\u0001\u0001B\u0004\n\u0016!\tIA\"D\u0001\u000b\u0015\u0005Y\u0011!B:dC2\f\u0017BA\u0007\u000b\u0005\u0019\te.\u001f*fMB\u0011q\u0002E\u0007\u0002\u0005%\u0011\u0011C\u0001\u0002\r\u0007>t7\u000f^1oiRKG.\u001a\t\u0003\u0013MI!\u0001\u0006\u0006\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0011BF\u0005\u0003/)\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\"\u0007\u0001\u0003\u0016\u0004%\tAG\u0001\u0002mV\t1\u0004\u0005\u0002\n9%\u0011QD\u0003\u0002\u0005\u0005f$X\r\u0003\u0005 \u0001\tE\t\u0015!\u0003\u001c\u0003\t1\b\u0005\u0003\u0005\"\u0001\tU\r\u0011\"\u0001#\u0003\u0011\u0019w\u000e\\:\u0016\u0003\r\u0002\"!\u0003\u0013\n\u0005\u0015R!aA%oi\"Aq\u0005\u0001B\tB\u0003%1%A\u0003d_2\u001c\b\u0005\u0003\u0005*\u0001\tU\r\u0011\"\u0001#\u0003\u0011\u0011xn^:\t\u0011-\u0002!\u0011#Q\u0001\n\r\nQA]8xg\u0002B\u0001\"\f\u0001\u0003\u0016\u0004%\tAL\u0001\tG\u0016dG\u000eV=qKV\tqFE\u00021eU2A!\r\u0001\u0001_\taAH]3gS:,W.\u001a8u}A\u0011qbM\u0005\u0003i\t\u0011\u0011BQ=uK\u000e+G\u000e\\:\u0011\u0005=1\u0014BA\u001c\u0003\u00059qu\u000eR1uC\"\u000bg\u000e\u001a7j]\u001eD\u0001\"\u000f\u0001\u0003\u0012\u0003\u0006IaL\u0001\nG\u0016dG\u000eV=qK\u0002BQa\u000f\u0001\u0005\u0002q\na\u0001P5oSRtD#B\u001f?\u007f\u0001\u000b\u0005CA\b\u0001\u0011\u0015I\"\b1\u0001\u001c\u0011\u0015\t#\b1\u0001$\u0011\u0015I#\b1\u0001$\u0011\u001di#\b%AA\u0002\t\u00132a\u0011\u001a6\r\u0011\t\u0004\u0001\u0001\"\t\u0015\u0015\u0003\u0001\u0013!A\u0002B\u0003%a)\u0001\u0003yIE:\u0004\u0003B\u0005HG%K!\u0001\u0013\u0006\u0003\rQ+\b\u000f\\33!\tI!*\u0003\u0002L\u0015\t1Ai\\;cY\u0016Dq!\u0014\u0001C\u0002\u0013E!%\u0001\u0003j-\u0006d\u0007BB(\u0001A\u0003%1%A\u0003j-\u0006d\u0007\u0005C\u0004R\u0001\t\u0007I\u0011\u0003*\u0002\t\u00114\u0016\r\\\u000b\u0002\u0013\"1A\u000b\u0001Q\u0001\n%\u000bQ\u0001\u001a,bY\u0002BQA\u0016\u0001\u0005\u0002]\u000b1\u0002^8BeJ\f\u0017\u0010V5mKR\t\u0001\f\u0005\u0002\u00103&\u0011!L\u0001\u0002\n\u0003J\u0014\u0018-\u001f+jY\u0016DQ\u0001\u0018\u0001\u0005\u0002u\u000bq!\\;uC\ndW-F\u0001_!\tyq,\u0003\u0002a\u0005\t\u0001R*\u001e;bE2,\u0017I\u001d:bsRKG.\u001a\u0005\u0006E\u0002!\taY\u0001\bi>\u0014\u0015\u0010^3t)\u0005!\u0007cA\u0005f7%\u0011aM\u0003\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\u0006Q\u0002!\t![\u0001\u000bo&$\bNT8ECR\fGCA\u001fk\u0011\u0015Yw\r1\u0001m\u0003-qw\u000eR1uCZ\u000bG.^3\u0011\u0007%i\u0017*\u0003\u0002o\u0015\t1q\n\u001d;j_:DQ\u0001\u001d\u0001\u0005\u0002E\f1!\\1q)\t\u0011X\u000f\u0005\u0002\u0010g&\u0011AO\u0001\u0002\u0005)&dW\rC\u0003w_\u0002\u0007q/A\u0001g!\u0011I\u0001pI\u0012\n\u0005eT!!\u0003$v]\u000e$\u0018n\u001c82\u0011\u0015Y\b\u0001\"\u0001}\u0003%i\u0017\r\u001d#pk\ndW\r\u0006\u0002s{\")aO\u001fa\u0001}B!\u0011\u0002_%J\u0011%\t\t\u0001AA\u0001\n\u0003\t\u0019!\u0001\u0003d_BLH#C\u001f\u0002\u0006\u0005\u001d\u0011\u0011BA\u0006\u0011\u001dIr\u0010%AA\u0002mAq!I@\u0011\u0002\u0003\u00071\u0005C\u0004*\u007fB\u0005\t\u0019A\u0012\t\u000f5z\b\u0013!a\u0001\u0005\"I\u0011q\u0002\u0001\u0012\u0002\u0013\u0005\u0011\u0011C\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\u0019BK\u0002\u001c\u0003+Y#!a\u0006\u0011\t\u0005e\u00111E\u0007\u0003\u00037QA!!\b\u0002 \u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003CQ\u0011AC1o]>$\u0018\r^5p]&!\u0011QEA\u000e\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003S\u0001\u0011\u0013!C\u0001\u0003W\tabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002.)\u001a1%!\u0006\t\u0013\u0005E\u0002!%A\u0005\u0002\u0005-\u0012AD2paf$C-\u001a4bk2$He\r\u0005\n\u0003k\u0001\u0011\u0013!C\u0001\u0003o\tabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u0002:)\u001aq&!\u0006\t\u0013\u0005u\u0002!!A\u0005B\u0005}\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002BA!\u00111IA'\u001b\t\t)E\u0003\u0003\u0002H\u0005%\u0013\u0001\u00027b]\u001eT!!a\u0013\u0002\t)\fg/Y\u0005\u0005\u0003\u001f\n)E\u0001\u0004TiJLgn\u001a\u0005\t\u0003'\u0002\u0011\u0011!C\u0001E\u0005a\u0001O]8ek\u000e$\u0018I]5us\"I\u0011q\u000b\u0001\u0002\u0002\u0013\u0005\u0011\u0011L\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tY&!\u0019\u0011\u0007%\ti&C\u0002\u0002`)\u00111!\u00118z\u0011%\t\u0019'!\u0016\u0002\u0002\u0003\u00071%A\u0002yIEB\u0011\"a\u001a\u0001\u0003\u0003%\t%!\u001b\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u001b\u0011\r\u00055\u00141OA.\u001b\t\tyGC\u0002\u0002r)\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t)(a\u001c\u0003\u0011%#XM]1u_JD\u0011\"!\u001f\u0001\u0003\u0003%\t!a\u001f\u0002\u0011\r\fg.R9vC2$B!! \u0002\u0004B\u0019\u0011\"a \n\u0007\u0005\u0005%BA\u0004C_>dW-\u00198\t\u0015\u0005\r\u0014qOA\u0001\u0002\u0004\tY\u0006C\u0005\u0002\b\u0002\t\t\u0011\"\u0011\u0002\n\u0006A\u0001.Y:i\u0007>$W\rF\u0001$\u0011%\ti\tAA\u0001\n\u0003\ny)\u0001\u0005u_N#(/\u001b8h)\t\t\t\u0005C\u0005\u0002\u0014\u0002\t\t\u0011\"\u0011\u0002\u0016\u00061Q-];bYN$B!! \u0002\u0018\"Q\u00111MAI\u0003\u0003\u0005\r!a\u0017\b\u000f\u0005m%\u0001#\u0001\u0002\u001e\u0006\u0001\")\u001f;f\u0007>t7\u000f^1oiRKG.\u001a\t\u0004\u001f\u0005}eAB\u0001\u0003\u0011\u0003\t\tk\u0005\u0003\u0002 \")\u0002bB\u001e\u0002 \u0012\u0005\u0011Q\u0015\u000b\u0003\u0003;C\u0001\"!+\u0002 \u0012\u0005\u00111V\u0001\nMJ|WNQ=uKN$\u0012\"PAW\u0003c\u000b\u0019,!.\t\u000f\u0005=\u0016q\u0015a\u0001I\u0006)!-\u001f;fg\"1\u0011%a*A\u0002\rBa!KAT\u0001\u0004\u0019\u0003bB\u0017\u0002(\u0002\u0007\u0011q\u0017\n\u0005\u0003s\u0013TG\u0002\u00042\u0003?\u0003\u0011q\u0017\u0005\u000b\u0003{\u000by*!A\u0005\u0002\u0006}\u0016!B1qa2LH#C\u001f\u0002B\u0006\r\u0017QYAd\u0011\u0019I\u00121\u0018a\u00017!1\u0011%a/A\u0002\rBa!KA^\u0001\u0004\u0019\u0003\"C\u0017\u0002<B\u0005\t\u0019AAe%\u0011\tYMM\u001b\u0007\rE\ny\nAAe\u0011)\ty-a(\u0002\u0002\u0013\u0005\u0015\u0011[\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t\u0019.a8\u0011\t%i\u0017Q\u001b\t\t\u0013\u0005]7dI\u0012\u0002\\&\u0019\u0011\u0011\u001c\u0006\u0003\rQ+\b\u000f\\35%\u0011\tiNM\u001b\u0007\rE\ny\nAAn\u0011%\t\t/!4\u0002\u0002\u0003\u0007Q(A\u0002yIAB!\"!:\u0002 F\u0005I\u0011AAt\u0003=\t\u0007\u000f\u001d7zI\u0011,g-Y;mi\u0012\"TCAAuU\u0011\tY/!\u0006\u0013\t\u00055('\u000e\u0004\u0007c\u0005}\u0005!a;\t\u0015\u0005E\u0018qTI\u0001\n\u0003\t\u00190A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003kTC!a>\u0002\u0016I!\u0011\u0011 \u001a6\r\u0019\t\u0014q\u0014\u0001\u0002x\"Q\u0011Q`AP\u0003\u0003%I!a@\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u0003\u0001B!a\u0011\u0003\u0004%!!QAA#\u0005\u0019y%M[3di\u0002")
public class ByteConstantTile
implements ConstantTile,
Product {
    private final byte v;
    private final int cols;
    private final int rows;
    private final ByteCells cellType;
    private final /* synthetic */ Tuple2 x$17;
    private final int iVal;
    private final double dVal;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static ByteCells $lessinit$greater$default$4() {
        return ByteConstantTile$.MODULE$.$lessinit$greater$default$4();
    }

    public static ByteCells apply$default$4() {
        return ByteConstantTile$.MODULE$.apply$default$4();
    }

    public static Option<Tuple4<Object, Object, Object, ByteCells>> unapply(ByteConstantTile byteConstantTile) {
        return ByteConstantTile$.MODULE$.unapply(byteConstantTile);
    }

    public static ByteConstantTile apply(byte by, int n, int n2, ByteCells byteCells) {
        return ByteConstantTile$.MODULE$.apply(by, n, n2, byteCells);
    }

    public static ByteConstantTile fromBytes(byte[] byArray, int n, int n2, ByteCells byteCells) {
        return ByteConstantTile$.MODULE$.fromBytes(byArray, n, n2, byteCells);
    }

    @Override
    public int get(int col, int row) {
        return ConstantTile.get$(this, col, row);
    }

    @Override
    public double getDouble(int col, int row) {
        return ConstantTile.getDouble$(this, col, row);
    }

    @Override
    public int[] toArray() {
        return ConstantTile.toArray$(this);
    }

    @Override
    public double[] toArrayDouble() {
        return ConstantTile.toArrayDouble$(this);
    }

    @Override
    public Tile convert(DataType newType) {
        return ConstantTile.convert$(this, newType);
    }

    @Override
    public Tile interpretAs(DataType newCellType) {
        return ConstantTile.interpretAs$(this, newCellType);
    }

    @Override
    public void foreach(Function1<Object, BoxedUnit> f) {
        ConstantTile.foreach$(this, f);
    }

    @Override
    public void foreachDouble(Function1<Object, BoxedUnit> f) {
        ConstantTile.foreachDouble$(this, f);
    }

    @Override
    public void foreachIntVisitor(IntTileVisitor visitor) {
        ConstantTile.foreachIntVisitor$(this, visitor);
    }

    @Override
    public void foreachDoubleVisitor(DoubleTileVisitor visitor) {
        ConstantTile.foreachDoubleVisitor$(this, visitor);
    }

    @Override
    public Tile combine(Tile other, Function2<Object, Object, Object> f) {
        return ConstantTile.combine$(this, other, f);
    }

    @Override
    public Tile combineDouble(Tile other, Function2<Object, Object, Object> f) {
        return ConstantTile.combineDouble$(this, other, f);
    }

    @Override
    public Tile mapIntMapper(IntTileMapper mapper) {
        return ConstantTile.mapIntMapper$(this, mapper);
    }

    @Override
    public Tile mapDoubleMapper(DoubleTileMapper mapper) {
        return ConstantTile.mapDoubleMapper$(this, mapper);
    }

    @Override
    public void dualForeach(Function1<Object, BoxedUnit> f, Function1<Object, BoxedUnit> g) {
        Tile.dualForeach$(this, f, g);
    }

    @Override
    public Tile mapIfSet(Function1<Object, Object> f) {
        return Tile.mapIfSet$(this, f);
    }

    @Override
    public Tile mapIfSetDouble(Function1<Object, Object> f) {
        return Tile.mapIfSetDouble$(this, f);
    }

    @Override
    public Tile dualMap(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile.dualMap$(this, f, g);
    }

    @Override
    public Tile dualMapIfSet(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile.dualMapIfSet$(this, f, g);
    }

    @Override
    public Tile dualCombine(Tile r2, Function2<Object, Object, Object> f, Function2<Object, Object, Object> g) {
        return Tile.dualCombine$(this, r2, f, g);
    }

    @Override
    public boolean isNoDataTile() {
        return Tile.isNoDataTile$(this);
    }

    @Override
    public Tile normalize(int oldMin, int oldMax, int newMin, int newMax) {
        return Tile.normalize$((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile normalize(double oldMin, double oldMax, double newMin, double newMax) {
        return Tile.normalize$((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile rescale(int newMin, int newMax) {
        return Tile.rescale$((Tile)this, newMin, newMax);
    }

    @Override
    public Tile rescale(double newMin, double newMax) {
        return Tile.rescale$((Tile)this, newMin, newMax);
    }

    @Override
    public Tile downsample(int newCols, int newRows, Function1<CellSet, Object> f) {
        return Tile.downsample$(this, newCols, newRows, f);
    }

    @Override
    public Tuple2<Object, Object> findMinMax() {
        return Tile.findMinMax$(this);
    }

    @Override
    public Tuple2<Object, Object> findMinMaxDouble() {
        return Tile.findMinMaxDouble$(this);
    }

    @Override
    public int size() {
        return Grid.size$(this);
    }

    @Override
    public Tuple2<Object, Object> dimensions() {
        return Grid.dimensions$(this);
    }

    @Override
    public GridBounds gridBounds() {
        return Grid.gridBounds$(this);
    }

    private Logger logger$lzycompute() {
        ByteConstantTile byteConstantTile = this;
        synchronized (byteConstantTile) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public byte v() {
        return this.v;
    }

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    public ByteCells cellType() {
        return this.cellType;
    }

    @Override
    public int iVal() {
        return this.iVal;
    }

    @Override
    public double dVal() {
        return this.dVal;
    }

    @Override
    public ArrayTile toArrayTile() {
        return this.mutable();
    }

    @Override
    public MutableArrayTile mutable() {
        return ByteArrayTile$.MODULE$.fill(this.v(), this.cols(), this.rows(), this.cellType());
    }

    @Override
    public byte[] toBytes() {
        return new byte[]{this.v()};
    }

    @Override
    public ByteConstantTile withNoData(Option<Object> noDataValue) {
        return new ByteConstantTile(this.v(), this.cols(), this.rows(), this.cellType().withNoData(noDataValue));
    }

    @Override
    public Tile map(Function1<Object, Object> f) {
        int n = f.apply$mcII$sp(this.iVal());
        return new ByteConstantTile((byte)(n == Integer.MIN_VALUE ? -128 : (byte)n), this.cols(), this.rows(), this.cellType());
    }

    @Override
    public Tile mapDouble(Function1<Object, Object> f) {
        double n = f.apply$mcDD$sp(this.dVal());
        return new ByteConstantTile((byte)(Double.isNaN(n) ? -128 : (byte)n), this.cols(), this.rows(), ByteConstantTile$.MODULE$.apply$default$4());
    }

    public ByteConstantTile copy(byte v, int cols, int rows, ByteCells cellType) {
        return new ByteConstantTile(v, cols, rows, cellType);
    }

    public byte copy$default$1() {
        return this.v();
    }

    public int copy$default$2() {
        return this.cols();
    }

    public int copy$default$3() {
        return this.rows();
    }

    public ByteCells copy$default$4() {
        return this.cellType();
    }

    public String productPrefix() {
        return "ByteConstantTile";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = BoxesRunTime.boxToByte((byte)this.v());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this.cols());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this.rows());
                break;
            }
            case 3: {
                object = this.cellType();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ByteConstantTile;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.v());
        n = Statics.mix((int)n, (int)this.cols());
        n = Statics.mix((int)n, (int)this.rows());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.cellType()));
        return Statics.finalizeHash((int)n, (int)4);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ByteConstantTile)) return false;
        boolean bl = true;
        if (!bl) return false;
        ByteConstantTile byteConstantTile = (ByteConstantTile)x$1;
        if (this.v() != byteConstantTile.v()) return false;
        if (this.cols() != byteConstantTile.cols()) return false;
        if (this.rows() != byteConstantTile.rows()) return false;
        ByteCells byteCells = this.cellType();
        ByteCells byteCells2 = byteConstantTile.cellType();
        if (byteCells == null) {
            if (byteCells2 != null) {
                return false;
            }
        } else if (!byteCells.equals(byteCells2)) return false;
        if (!byteConstantTile.canEqual(this)) return false;
        return true;
    }

    public ByteConstantTile(byte v, int cols, int rows, ByteCells cellType) {
        Tuple2.mcID.sp sp2;
        this.v = v;
        this.cols = cols;
        this.rows = rows;
        this.cellType = cellType;
        Grid.$init$(this);
        IterableTile.$init$(this);
        MappableTile.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        Tile.$init$(this);
        ConstantTile.$init$(this);
        Product.$init$((Product)this);
        ByteCells byteCells = cellType;
        if (byteCells instanceof ConstantNoData) {
            byte n = v;
            int n2 = n == -128 ? Integer.MIN_VALUE : (int)n;
            byte n3 = v;
            sp2 = new Tuple2.mcID.sp(n2, n3 == -128 ? Double.NaN : (double)n3);
        } else if (byteCells instanceof NoNoData) {
            sp2 = new Tuple2.mcID.sp((int)v, (double)v);
        } else if (byteCells instanceof ByteUserDefinedNoDataCellType) {
            ByteUserDefinedNoDataCellType byteUserDefinedNoDataCellType = (ByteUserDefinedNoDataCellType)byteCells;
            sp2 = byteUserDefinedNoDataCellType.noDataValue() == v ? new Tuple2.mcID.sp(Integer.MIN_VALUE, Double.NaN) : new Tuple2.mcID.sp((int)v, (double)v);
        } else {
            throw new MatchError((Object)byteCells);
        }
        Tuple2.mcID.sp sp3 = sp2;
        if (sp3 == null) {
            throw new MatchError((Object)sp3);
        }
        int iVal = sp3._1$mcI$sp();
        double dVal = sp3._2$mcD$sp();
        int n = iVal;
        double d = dVal;
        Tuple2.mcID.sp sp4 = new Tuple2.mcID.sp(n, d);
        this.x$17 = sp4;
        this.iVal = this.x$17._1$mcI$sp();
        this.dVal = this.x$17._2$mcD$sp();
    }
}

