/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.CellGrid;
import geotrellis.raster.CellSet;
import geotrellis.raster.CompositeTile$;
import geotrellis.raster.DataType;
import geotrellis.raster.Grid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.IterableTile;
import geotrellis.raster.MappableTile;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.TileLayout;
import geotrellis.raster.package$;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t\rx!B\u0001\u0003\u0011\u00039\u0011!D\"p[B|7/\u001b;f)&dWM\u0003\u0002\u0004\t\u00051!/Y:uKJT\u0011!B\u0001\u000bO\u0016|GO]3mY&\u001c8\u0001\u0001\t\u0003\u0011%i\u0011A\u0001\u0004\u0006\u0015\tA\ta\u0003\u0002\u000e\u0007>l\u0007o\\:ji\u0016$\u0016\u000e\\3\u0014\u0007%a!\u0003\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001bMI!\u0001\u0006\b\u0003\u0019M+'/[1mSj\f'\r\\3\t\u000bYIA\u0011A\f\u0002\rqJg.\u001b;?)\u00059\u0001\"B\r\n\t\u0003Q\u0012!B1qa2LH#B\u000e\u0003\n\n5\u0005C\u0001\u0005\u001d\r\u0011Q!\u0001Q\u000f\u0014\u000bqaa$\t\n\u0011\u0005!y\u0012B\u0001\u0011\u0003\u0005\u0011!\u0016\u000e\\3\u0011\u00055\u0011\u0013BA\u0012\u000f\u0005\u001d\u0001&o\u001c3vGRD\u0001\"\n\u000f\u0003\u0016\u0004%\tAJ\u0001\u0006i&dWm]\u000b\u0002OA\u0019\u0001\u0006\r\u0010\u000f\u0005%rcB\u0001\u0016.\u001b\u0005Y#B\u0001\u0017\u0007\u0003\u0019a$o\\8u}%\tq\"\u0003\u00020\u001d\u00059\u0001/Y2lC\u001e,\u0017BA\u00193\u0005\r\u0019V-\u001d\u0006\u0003_9A\u0001\u0002\u000e\u000f\u0003\u0012\u0003\u0006IaJ\u0001\u0007i&dWm\u001d\u0011\t\u0011Yb\"Q3A\u0005\u0002]\n!\u0002^5mK2\u000b\u0017p\\;u+\u0005A\u0004C\u0001\u0005:\u0013\tQ$A\u0001\u0006US2,G*Y=pkRD\u0001\u0002\u0010\u000f\u0003\u0012\u0003\u0006I\u0001O\u0001\fi&dW\rT1z_V$\b\u0005C\u0003\u00179\u0011\u0005a\bF\u0002\u001c\u007f\u0001CQ!J\u001fA\u0002\u001dBQAN\u001fA\u0002aBqA\u0011\u000fC\u0002\u0013\u00051)\u0001\u0003d_2\u001cX#\u0001#\u0011\u00055)\u0015B\u0001$\u000f\u0005\rIe\u000e\u001e\u0005\u0007\u0011r\u0001\u000b\u0011\u0002#\u0002\u000b\r|Gn\u001d\u0011\t\u000f)c\"\u0019!C\u0001\u0007\u0006!!o\\<t\u0011\u0019aE\u0004)A\u0005\t\u0006)!o\\<tA!9a\n\bb\u0001\n\u0013y\u0015\u0001\u0003;jY\u0016d\u0015n\u001d;\u0016\u0003A\u00032!\u0015*\u001f\u001d\tia&\u0003\u0002Te\t!A*[:u\u0011\u0019)F\u0004)A\u0005!\u0006IA/\u001b7f\u0019&\u001cH\u000f\t\u0005\b/r\u0011\r\u0011\"\u0003D\u0003!!\u0018\u000e\\3D_2\u001c\bBB-\u001dA\u0003%A)A\u0005uS2,7i\u001c7tA!)1\f\bC\u00059\u00069q-\u001a;US2,Gc\u0001\u0010^?\")aL\u0017a\u0001\t\u0006!AoY8m\u0011\u0015\u0001'\f1\u0001E\u0003\u0011!(o\\<\t\u000f\td\"\u0019!C\u0001G\u0006A1-\u001a7m)f\u0004X-F\u0001e!\t)wM\u0004\u0002\tM&\u0011qFA\u0005\u0003Q&\u0014\u0001bQ3mYRK\b/\u001a\u0006\u0003_\tAaa\u001b\u000f!\u0002\u0013!\u0017!C2fY2$\u0016\u0010]3!\u0011\u0015iG\u0004\"\u0001o\u0003\u001d\u0019wN\u001c<feR$\"AH8\t\u000bAd\u0007\u0019\u00013\u0002\u001dQ\f'oZ3u\u0007\u0016dG\u000eV=qK\")!\u000f\bC\u0001g\u0006Qq/\u001b;i\u001d>$\u0015\r^1\u0015\u0005m!\b\"B;r\u0001\u00041\u0018a\u00038p\t\u0006$\u0018MV1mk\u0016\u00042!D<z\u0013\tAhB\u0001\u0004PaRLwN\u001c\t\u0003\u001biL!a\u001f\b\u0003\r\u0011{WO\u00197f\u0011\u0015iH\u0004\"\u0001\u007f\u0003-Ig\u000e^3saJ,G/Q:\u0015\u0005my\b\"\u00029}\u0001\u0004!\u0007bBA\u00029\u0011\u0005\u0011QA\u0001\fi>\f%O]1z)&dW\r\u0006\u0002\u0002\bA\u0019\u0001\"!\u0003\n\u0007\u0005-!AA\u0005BeJ\f\u0017\u0010V5mK\"9\u0011q\u0002\u000f\u0005\u0002\u0005E\u0011aB7vi\u0006\u0014G.\u001a\u000b\u0003\u0003'\u00012\u0001CA\u000b\u0013\r\t9B\u0001\u0002\u0011\u001bV$\u0018M\u00197f\u0003J\u0014\u0018-\u001f+jY\u0016Dq!a\u0004\u001d\t\u0003\tY\u0002\u0006\u0003\u0002\u0014\u0005u\u0001B\u00029\u0002\u001a\u0001\u0007A\rC\u0004\u0002\"q!\t!a\t\u0002\u000fQ|\u0017I\u001d:bsR\u0011\u0011Q\u0005\t\u0005\u001b\u0005\u001dB)C\u0002\u0002*9\u0011Q!\u0011:sCfDq!!\f\u001d\t\u0003\ty#A\u0007u_\u0006\u0013(/Y=E_V\u0014G.\u001a\u000b\u0003\u0003c\u0001B!DA\u0014s\"9\u0011Q\u0007\u000f\u0005\u0002\u0005]\u0012a\u0002;p\u0005f$Xm\u001d\u000b\u0003\u0003s\u0001R!DA\u0014\u0003w\u00012!DA\u001f\u0013\r\tyD\u0004\u0002\u0005\u0005f$X\rC\u0004\u0002Dq!\t!!\u0012\u0002\u0007\u001d,G\u000fF\u0003E\u0003\u000f\nY\u0005C\u0004\u0002J\u0005\u0005\u0003\u0019\u0001#\u0002\u0007\r|G\u000eC\u0004\u0002N\u0005\u0005\u0003\u0019\u0001#\u0002\u0007I|w\u000fC\u0004\u0002Rq!\t!a\u0015\u0002\u0013\u001d,G\u000fR8vE2,G#B=\u0002V\u0005]\u0003bBA%\u0003\u001f\u0002\r\u0001\u0012\u0005\b\u0003\u001b\ny\u00051\u0001E\u0011\u001d\tY\u0006\bC\u0001\u0003;\nqAZ8sK\u0006\u001c\u0007\u000e\u0006\u0003\u0002`\u0005\u0015\u0004cA\u0007\u0002b%\u0019\u00111\r\b\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003O\nI\u00061\u0001\u0002j\u0005\ta\r\u0005\u0004\u000e\u0003W\"\u0015qL\u0005\u0004\u0003[r!!\u0003$v]\u000e$\u0018n\u001c82\u0011\u001d\t\t\b\bC\u0001\u0003g\nQBZ8sK\u0006\u001c\u0007\u000eR8vE2,G\u0003BA0\u0003kB\u0001\"a\u001a\u0002p\u0001\u0007\u0011q\u000f\t\u0007\u001b\u0005-\u00140a\u0018\t\u000f\u0005mD\u0004\"\u0001\u0002~\u0005\tbm\u001c:fC\u000eD\u0017J\u001c;WSNLGo\u001c:\u0015\t\u0005}\u0013q\u0010\u0005\t\u0003\u0003\u000bI\b1\u0001\u0002\u0004\u00069a/[:ji>\u0014\bcA3\u0002\u0006&\u0019\u0011qQ5\u0003\u001d%sG\u000fV5mKZK7/\u001b;pe\"9\u00111\u0012\u000f\u0005\u0002\u00055\u0015\u0001\u00064pe\u0016\f7\r\u001b#pk\ndWMV5tSR|'\u000f\u0006\u0003\u0002`\u0005=\u0005\u0002CAA\u0003\u0013\u0003\r!!%\u0011\u0007\u0015\f\u0019*C\u0002\u0002\u0016&\u0014\u0011\u0003R8vE2,G+\u001b7f-&\u001c\u0018\u000e^8s\u0011\u001d\tI\n\bC\u0001\u00037\u000b1!\\1q)\rq\u0012Q\u0014\u0005\t\u0003O\n9\n1\u0001\u0002 B)Q\"a\u001bE\t\"9\u00111\u0015\u000f\u0005\u0002\u0005\u0015\u0016!C7ba\u0012{WO\u00197f)\rq\u0012q\u0015\u0005\t\u0003O\n\t\u000b1\u0001\u0002*B)Q\"a\u001bzs\"9\u0011Q\u0016\u000f\u0005\u0002\u0005=\u0016\u0001D7ba&sG/T1qa\u0016\u0014Hc\u0001\u0010\u00022\"A\u00111WAV\u0001\u0004\t),\u0001\u0004nCB\u0004XM\u001d\t\u0004K\u0006]\u0016bAA]S\ni\u0011J\u001c;US2,W*\u00199qKJDq!!0\u001d\t\u0003\ty,A\bnCB$u.\u001e2mK6\u000b\u0007\u000f]3s)\rq\u0012\u0011\u0019\u0005\t\u0003g\u000bY\f1\u0001\u0002DB\u0019Q-!2\n\u0007\u0005\u001d\u0017N\u0001\tE_V\u0014G.\u001a+jY\u0016l\u0015\r\u001d9fe\"9\u00111\u001a\u000f\u0005\u0002\u00055\u0017aB2p[\nLg.\u001a\u000b\u0005\u0003\u001f\fI\u000eF\u0002\u001f\u0003#D\u0001\"a\u001a\u0002J\u0002\u0007\u00111\u001b\t\u0007\u001b\u0005UG\t\u0012#\n\u0007\u0005]gBA\u0005Gk:\u001cG/[8oe!9\u00111\\Ae\u0001\u0004q\u0012!B8uQ\u0016\u0014\bbBAp9\u0011\u0005\u0011\u0011]\u0001\u000eG>l'-\u001b8f\t>,(\r\\3\u0015\t\u0005\r\u0018\u0011\u001e\u000b\u0004=\u0005\u0015\b\u0002CA4\u0003;\u0004\r!a:\u0011\r5\t)._=z\u0011\u001d\tY.!8A\u0002yAq!!<\u001d\t\u0003\ty/A\u0005bg\u000eL\u0017\u000e\u0012:boR\u0011\u0011\u0011\u001f\t\u0005\u0003g\fYP\u0004\u0003\u0002v\u0006]\bC\u0001\u0016\u000f\u0013\r\tIPD\u0001\u0007!J,G-\u001a4\n\t\u0005u\u0018q \u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005eh\u0002C\u0005\u0003\u0004q\t\t\u0011\"\u0001\u0003\u0006\u0005!1m\u001c9z)\u0015Y\"q\u0001B\u0005\u0011!)#\u0011\u0001I\u0001\u0002\u00049\u0003\u0002\u0003\u001c\u0003\u0002A\u0005\t\u0019\u0001\u001d\t\u0013\t5A$%A\u0005\u0002\t=\u0011AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0005#Q3a\nB\nW\t\u0011)\u0002\u0005\u0003\u0003\u0018\t\u0005RB\u0001B\r\u0015\u0011\u0011YB!\b\u0002\u0013Ut7\r[3dW\u0016$'b\u0001B\u0010\u001d\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\t\r\"\u0011\u0004\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"\u0003B\u00149E\u0005I\u0011\u0001B\u0015\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"Aa\u000b+\u0007a\u0012\u0019\u0002C\u0005\u00030q\t\t\u0011\"\u0011\u00032\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"Aa\r\u0011\t\tU\"qH\u0007\u0003\u0005oQAA!\u000f\u0003<\u0005!A.\u00198h\u0015\t\u0011i$\u0001\u0003kCZ\f\u0017\u0002BA\u007f\u0005oA\u0001Ba\u0011\u001d\u0003\u0003%\taQ\u0001\raJ|G-^2u\u0003JLG/\u001f\u0005\n\u0005\u000fb\u0012\u0011!C\u0001\u0005\u0013\na\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0003L\tE\u0003cA\u0007\u0003N%\u0019!q\n\b\u0003\u0007\u0005s\u0017\u0010C\u0005\u0003T\t\u0015\u0013\u0011!a\u0001\t\u0006\u0019\u0001\u0010J\u0019\t\u0013\t]C$!A\u0005B\te\u0013a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\tm\u0003C\u0002B/\u0005G\u0012Y%\u0004\u0002\u0003`)\u0019!\u0011\r\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003f\t}#\u0001C%uKJ\fGo\u001c:\t\u0013\t%D$!A\u0005\u0002\t-\u0014\u0001C2b]\u0016\u000bX/\u00197\u0015\t\t5$1\u000f\t\u0004\u001b\t=\u0014b\u0001B9\u001d\t9!i\\8mK\u0006t\u0007B\u0003B*\u0005O\n\t\u00111\u0001\u0003L!I!q\u000f\u000f\u0002\u0002\u0013\u0005#\u0011P\u0001\tQ\u0006\u001c\bnQ8eKR\tA\tC\u0005\u0003~q\t\t\u0011\"\u0011\u0003\u0000\u0005AAo\\*ue&tw\r\u0006\u0002\u00034!I!1\u0011\u000f\u0002\u0002\u0013\u0005#QQ\u0001\u0007KF,\u0018\r\\:\u0015\t\t5$q\u0011\u0005\u000b\u0005'\u0012\t)!AA\u0002\t-\u0003B\u0002BF1\u0001\u0007a$\u0001\u0003uS2,\u0007\"\u0002\u001c\u0019\u0001\u0004A\u0004b\u0002BI\u0013\u0011\u0005!1S\u0001\u0005oJ\f\u0007\u000fF\u0004\u001c\u0005+\u00139J!'\t\u000f\t-%q\u0012a\u0001=!1qKa$A\u0002\u0011CqAa'\u0003\u0010\u0002\u0007A)\u0001\u0005uS2,'k\\<t\u0011\u001d\u0011\t*\u0003C\u0001\u0005?#\u0012b\u0007BQ\u0005G\u0013)Ka*\t\u000f\t-%Q\u0014a\u0001=!1qK!(A\u0002\u0011CqAa'\u0003\u001e\u0002\u0007A\t\u0003\u0005\u0003*\nu\u0005\u0019\u0001B7\u0003\u001d\u0019'o\u001c9qK\u0012DqA!%\n\t\u0003\u0011i\u000bF\u0003\u001c\u0005_\u0013\t\fC\u0004\u0003\f\n-\u0006\u0019\u0001\u0010\t\rY\u0012Y\u000b1\u00019\u0011\u001d\u0011\t*\u0003C\u0001\u0005k#ra\u0007B\\\u0005s\u0013Y\fC\u0004\u0003\f\nM\u0006\u0019\u0001\u0010\t\rY\u0012\u0019\f1\u00019\u0011!\u0011IKa-A\u0002\t5\u0004\u0002C\r\n\u0003\u0003%\tIa0\u0015\u000bm\u0011\tMa1\t\r\u0015\u0012i\f1\u0001(\u0011\u00191$Q\u0018a\u0001q!I!qY\u0005\u0002\u0002\u0013\u0005%\u0011Z\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0011YMa5\u0011\t59(Q\u001a\t\u0006\u001b\t=w\u0005O\u0005\u0004\u0005#t!A\u0002+va2,'\u0007C\u0005\u0003V\n\u0015\u0017\u0011!a\u00017\u0005\u0019\u0001\u0010\n\u0019\t\u0013\te\u0017\"!A\u0005\n\tm\u0017a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!8\u0011\t\tU\"q\\\u0005\u0005\u0005C\u00149D\u0001\u0004PE*,7\r\u001e")
public class CompositeTile
implements Tile,
Product {
    private final Seq<Tile> tiles;
    private final TileLayout tileLayout;
    private final int cols;
    private final int rows;
    private final List<Tile> tileList;
    private final int tileCols;
    private final DataType cellType;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Seq<Tile>, TileLayout>> unapply(CompositeTile compositeTile) {
        return CompositeTile$.MODULE$.unapply(compositeTile);
    }

    public static CompositeTile apply(Seq<Tile> seq, TileLayout tileLayout) {
        return CompositeTile$.MODULE$.apply(seq, tileLayout);
    }

    public static CompositeTile wrap(Tile tile, TileLayout tileLayout, boolean bl) {
        return CompositeTile$.MODULE$.wrap(tile, tileLayout, bl);
    }

    public static CompositeTile wrap(Tile tile, TileLayout tileLayout) {
        return CompositeTile$.MODULE$.wrap(tile, tileLayout);
    }

    public static CompositeTile wrap(Tile tile, int n, int n2, boolean bl) {
        return CompositeTile$.MODULE$.wrap(tile, n, n2, bl);
    }

    public static CompositeTile wrap(Tile tile, int n, int n2) {
        return CompositeTile$.MODULE$.wrap(tile, n, n2);
    }

    public static CompositeTile apply(Tile tile, TileLayout tileLayout) {
        return CompositeTile$.MODULE$.apply(tile, tileLayout);
    }

    @Override
    public void dualForeach(Function1<Object, BoxedUnit> f, Function1<Object, BoxedUnit> g) {
        Tile.dualForeach$(this, f, g);
    }

    @Override
    public Tile mapIfSet(Function1<Object, Object> f) {
        return Tile.mapIfSet$(this, f);
    }

    @Override
    public Tile mapIfSetDouble(Function1<Object, Object> f) {
        return Tile.mapIfSetDouble$(this, f);
    }

    @Override
    public Tile dualMap(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile.dualMap$(this, f, g);
    }

    @Override
    public Tile dualMapIfSet(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile.dualMapIfSet$(this, f, g);
    }

    @Override
    public Tile dualCombine(Tile r2, Function2<Object, Object, Object> f, Function2<Object, Object, Object> g) {
        return Tile.dualCombine$(this, r2, f, g);
    }

    @Override
    public boolean isNoDataTile() {
        return Tile.isNoDataTile$(this);
    }

    @Override
    public Tile normalize(int oldMin, int oldMax, int newMin, int newMax) {
        return Tile.normalize$((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile normalize(double oldMin, double oldMax, double newMin, double newMax) {
        return Tile.normalize$((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile rescale(int newMin, int newMax) {
        return Tile.rescale$((Tile)this, newMin, newMax);
    }

    @Override
    public Tile rescale(double newMin, double newMax) {
        return Tile.rescale$((Tile)this, newMin, newMax);
    }

    @Override
    public Tile downsample(int newCols, int newRows, Function1<CellSet, Object> f) {
        return Tile.downsample$(this, newCols, newRows, f);
    }

    @Override
    public Tuple2<Object, Object> findMinMax() {
        return Tile.findMinMax$(this);
    }

    @Override
    public Tuple2<Object, Object> findMinMaxDouble() {
        return Tile.findMinMaxDouble$(this);
    }

    @Override
    public int size() {
        return Grid.size$(this);
    }

    @Override
    public Tuple2<Object, Object> dimensions() {
        return Grid.dimensions$(this);
    }

    @Override
    public GridBounds gridBounds() {
        return Grid.gridBounds$(this);
    }

    private Logger logger$lzycompute() {
        CompositeTile compositeTile = this;
        synchronized (compositeTile) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public Seq<Tile> tiles() {
        return this.tiles;
    }

    public TileLayout tileLayout() {
        return this.tileLayout;
    }

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    private List<Tile> tileList() {
        return this.tileList;
    }

    private int tileCols() {
        return this.tileCols;
    }

    private Tile getTile(int tcol, int trow) {
        return (Tile)this.tileList().apply(trow * this.tileCols() + tcol);
    }

    @Override
    public DataType cellType() {
        return this.cellType;
    }

    @Override
    public Tile convert(DataType targetCellType) {
        return this.mutable(targetCellType);
    }

    @Override
    public CompositeTile withNoData(Option<Object> noDataValue) {
        return new CompositeTile((Seq<Tile>)((Seq)this.tiles().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.withNoData(noDataValue), Seq$.MODULE$.canBuildFrom())), this.tileLayout());
    }

    @Override
    public CompositeTile interpretAs(DataType targetCellType) {
        return new CompositeTile((Seq<Tile>)((Seq)this.tiles().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.interpretAs(targetCellType), Seq$.MODULE$.canBuildFrom())), this.tileLayout());
    }

    @Override
    public ArrayTile toArrayTile() {
        return this.mutable();
    }

    @Override
    public MutableArrayTile mutable() {
        return this.mutable(this.cellType());
    }

    /*
     * WARNING - void declaration
     */
    public MutableArrayTile mutable(DataType targetCellType) {
        void var2_2;
        BoxedUnit boxedUnit;
        if ((long)this.cols() * (long)this.rows() > (long)Integer.MAX_VALUE) {
            throw scala.sys.package$.MODULE$.error("This tiled raster is too big to convert into an array.");
        }
        if (targetCellType.isFloatingPoint() != this.cellType().isFloatingPoint()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Conversion from {} to {} may lead to data loss.", (Object[])new DataType[]{this.cellType(), targetCellType});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(targetCellType, this.cols(), this.rows());
        int len = this.cols() * this.rows();
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        if (!this.cellType().isFloatingPoint()) {
            for (int index$macro$45 = 0; index$macro$45 < layoutRows; ++index$macro$45) {
                for (int index$macro$44 = 0; index$macro$44 < layoutCols; ++index$macro$44) {
                    Tile sourceTile = this.getTile(index$macro$44, index$macro$45);
                    for (int index$macro$43 = 0; index$macro$43 < tileRows; ++index$macro$43) {
                        for (int index$macro$42 = 0; index$macro$42 < tileCols; ++index$macro$42) {
                            int acol = tileCols * index$macro$44 + index$macro$42;
                            int arow = tileRows * index$macro$45 + index$macro$43;
                            tile.set(acol, arow, sourceTile.get(index$macro$42, index$macro$43));
                        }
                    }
                }
            }
        } else {
            for (int index$macro$49 = 0; index$macro$49 < layoutRows; ++index$macro$49) {
                for (int index$macro$48 = 0; index$macro$48 < layoutCols; ++index$macro$48) {
                    Tile sourceTile = this.getTile(index$macro$48, index$macro$49);
                    for (int index$macro$47 = 0; index$macro$47 < tileRows; ++index$macro$47) {
                        for (int index$macro$46 = 0; index$macro$46 < tileCols; ++index$macro$46) {
                            int acol = tileCols * index$macro$48 + index$macro$46;
                            int arow = tileRows * index$macro$49 + index$macro$47;
                            tile.setDouble(acol, arow, sourceTile.getDouble(index$macro$46, index$macro$47));
                        }
                    }
                }
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int[] toArray() {
        void var1_1;
        if ((long)this.cols() * (long)this.rows() > (long)Integer.MAX_VALUE) {
            throw scala.sys.package$.MODULE$.error("This tiled raster is too big to convert into an array.");
        }
        int[] arr = (int[])Array$.MODULE$.ofDim(this.cols() * this.rows(), ClassTag$.MODULE$.Int());
        int len = this.cols() * this.rows();
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        int totalCols = layoutCols * tileCols;
        for (int index$macro$53 = 0; index$macro$53 < layoutRows; ++index$macro$53) {
            for (int index$macro$52 = 0; index$macro$52 < layoutCols; ++index$macro$52) {
                Tile tile = this.getTile(index$macro$52, index$macro$53);
                for (int index$macro$51 = 0; index$macro$51 < tileRows; ++index$macro$51) {
                    for (int index$macro$50 = 0; index$macro$50 < tileCols; ++index$macro$50) {
                        int acol = tileCols * index$macro$52 + index$macro$50;
                        int arow = tileRows * index$macro$53 + index$macro$51;
                        arr[arow * totalCols + acol] = tile.get(index$macro$50, index$macro$51);
                    }
                }
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double[] toArrayDouble() {
        void var1_1;
        if ((long)this.cols() * (long)this.rows() > (long)Integer.MAX_VALUE) {
            throw scala.sys.package$.MODULE$.error("This tiled raster is too big to convert into an array.");
        }
        double[] arr = (double[])Array$.MODULE$.ofDim(this.cols() * this.rows(), ClassTag$.MODULE$.Double());
        int len = this.cols() * this.rows();
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        int totalCols = layoutCols * tileCols;
        for (int index$macro$57 = 0; index$macro$57 < layoutRows; ++index$macro$57) {
            for (int index$macro$56 = 0; index$macro$56 < layoutCols; ++index$macro$56) {
                Tile tile = this.getTile(index$macro$56, index$macro$57);
                for (int index$macro$55 = 0; index$macro$55 < tileRows; ++index$macro$55) {
                    for (int index$macro$54 = 0; index$macro$54 < tileCols; ++index$macro$54) {
                        int acol = tileCols * index$macro$56 + index$macro$54;
                        int arow = tileRows * index$macro$57 + index$macro$55;
                        arr[arow * totalCols + acol] = tile.getDouble(index$macro$54, index$macro$55);
                    }
                }
            }
        }
        return var1_1;
    }

    @Override
    public byte[] toBytes() {
        return this.toArrayTile().toBytes();
    }

    @Override
    public int get(int col, int row) {
        int tcol = col / this.tileLayout().tileCols();
        int trow = row / this.tileLayout().tileRows();
        int pcol = col % this.tileLayout().tileCols();
        int prow = row % this.tileLayout().tileRows();
        return this.getTile(tcol, trow).get(pcol, prow);
    }

    @Override
    public double getDouble(int col, int row) {
        int tcol = col / this.tileLayout().tileCols();
        int trow = row / this.tileLayout().tileRows();
        int pcol = col % this.tileLayout().tileCols();
        int prow = row % this.tileLayout().tileRows();
        return this.getTile(tcol, trow).getDouble(pcol, prow);
    }

    @Override
    public void foreach(Function1<Object, BoxedUnit> f) {
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        for (int index$macro$61 = 0; index$macro$61 < layoutRows; ++index$macro$61) {
            for (int index$macro$60 = 0; index$macro$60 < layoutCols; ++index$macro$60) {
                Tile tile = this.getTile(index$macro$60, index$macro$61);
                for (int index$macro$59 = 0; index$macro$59 < tileRows; ++index$macro$59) {
                    for (int index$macro$58 = 0; index$macro$58 < tileCols; ++index$macro$58) {
                        f.apply$mcVI$sp(tile.get(index$macro$58, index$macro$59));
                    }
                }
            }
        }
    }

    @Override
    public void foreachDouble(Function1<Object, BoxedUnit> f) {
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        for (int index$macro$65 = 0; index$macro$65 < layoutRows; ++index$macro$65) {
            for (int index$macro$64 = 0; index$macro$64 < layoutCols; ++index$macro$64) {
                Tile tile = this.getTile(index$macro$64, index$macro$65);
                for (int index$macro$63 = 0; index$macro$63 < tileRows; ++index$macro$63) {
                    for (int index$macro$62 = 0; index$macro$62 < tileCols; ++index$macro$62) {
                        f.apply$mcVD$sp(tile.getDouble(index$macro$62, index$macro$63));
                    }
                }
            }
        }
    }

    public void foreachIntVisitor(IntTileVisitor visitor) {
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        for (int index$macro$69 = 0; index$macro$69 < layoutRows; ++index$macro$69) {
            for (int index$macro$68 = 0; index$macro$68 < layoutCols; ++index$macro$68) {
                Tile tile = this.getTile(index$macro$68, index$macro$69);
                for (int index$macro$67 = 0; index$macro$67 < tileRows; ++index$macro$67) {
                    for (int index$macro$66 = 0; index$macro$66 < tileCols; ++index$macro$66) {
                        int acol = tileCols * index$macro$68 + index$macro$66;
                        int arow = tileRows * index$macro$69 + index$macro$67;
                        visitor.apply(acol, arow, tile.get(index$macro$66, index$macro$67));
                    }
                }
            }
        }
    }

    public void foreachDoubleVisitor(DoubleTileVisitor visitor) {
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        for (int index$macro$73 = 0; index$macro$73 < layoutRows; ++index$macro$73) {
            for (int index$macro$72 = 0; index$macro$72 < layoutCols; ++index$macro$72) {
                Tile tile = this.getTile(index$macro$72, index$macro$73);
                for (int index$macro$71 = 0; index$macro$71 < tileRows; ++index$macro$71) {
                    for (int index$macro$70 = 0; index$macro$70 < tileCols; ++index$macro$70) {
                        int acol = tileCols * index$macro$72 + index$macro$70;
                        int arow = tileRows * index$macro$73 + index$macro$71;
                        visitor.apply(acol, arow, tile.getDouble(index$macro$70, index$macro$71));
                    }
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile map(Function1<Object, Object> f) {
        void var2_2;
        MutableArrayTile result = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols(), this.rows());
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        for (int index$macro$77 = 0; index$macro$77 < layoutRows; ++index$macro$77) {
            for (int index$macro$76 = 0; index$macro$76 < layoutCols; ++index$macro$76) {
                Tile tile = this.getTile(index$macro$76, index$macro$77);
                for (int index$macro$75 = 0; index$macro$75 < tileRows; ++index$macro$75) {
                    for (int index$macro$74 = 0; index$macro$74 < tileCols; ++index$macro$74) {
                        int acol = tileCols * index$macro$76 + index$macro$74;
                        int arow = tileRows * index$macro$77 + index$macro$75;
                        result.set(acol, arow, f.apply$mcII$sp(tile.get(index$macro$74, index$macro$75)));
                    }
                }
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile mapDouble(Function1<Object, Object> f) {
        void var2_2;
        MutableArrayTile result = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols(), this.rows());
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        for (int index$macro$81 = 0; index$macro$81 < layoutRows; ++index$macro$81) {
            for (int index$macro$80 = 0; index$macro$80 < layoutCols; ++index$macro$80) {
                Tile tile = this.getTile(index$macro$80, index$macro$81);
                for (int index$macro$79 = 0; index$macro$79 < tileRows; ++index$macro$79) {
                    for (int index$macro$78 = 0; index$macro$78 < tileCols; ++index$macro$78) {
                        int acol = tileCols * index$macro$80 + index$macro$78;
                        int arow = tileRows * index$macro$81 + index$macro$79;
                        result.setDouble(acol, arow, f.apply$mcDD$sp(tile.getDouble(index$macro$78, index$macro$79)));
                    }
                }
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Tile mapIntMapper(IntTileMapper mapper) {
        void var2_2;
        MutableArrayTile result = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols(), this.rows());
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        for (int index$macro$85 = 0; index$macro$85 < layoutRows; ++index$macro$85) {
            for (int index$macro$84 = 0; index$macro$84 < layoutCols; ++index$macro$84) {
                Tile tile = this.getTile(index$macro$84, index$macro$85);
                for (int index$macro$83 = 0; index$macro$83 < tileRows; ++index$macro$83) {
                    for (int index$macro$82 = 0; index$macro$82 < tileCols; ++index$macro$82) {
                        int acol = tileCols * index$macro$84 + index$macro$82;
                        int arow = tileRows * index$macro$85 + index$macro$83;
                        result.set(acol, arow, mapper.apply(acol, arow, tile.get(index$macro$82, index$macro$83)));
                    }
                }
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Tile mapDoubleMapper(DoubleTileMapper mapper) {
        void var2_2;
        MutableArrayTile result = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols(), this.rows());
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        for (int index$macro$89 = 0; index$macro$89 < layoutRows; ++index$macro$89) {
            for (int index$macro$88 = 0; index$macro$88 < layoutCols; ++index$macro$88) {
                Tile tile = this.getTile(index$macro$88, index$macro$89);
                for (int index$macro$87 = 0; index$macro$87 < tileRows; ++index$macro$87) {
                    for (int index$macro$86 = 0; index$macro$86 < tileCols; ++index$macro$86) {
                        int acol = tileCols * index$macro$88 + index$macro$86;
                        int arow = tileRows * index$macro$89 + index$macro$87;
                        result.setDouble(acol, arow, mapper.apply(acol, arow, tile.getDouble(index$macro$86, index$macro$87)));
                    }
                }
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile combine(Tile other, Function2<Object, Object, Object> f) {
        void var3_3;
        package$.MODULE$.TileTupleExtensions((Tuple2<Tile, Tile>)new Tuple2((Object)this, (Object)other)).assertEqualDimensions();
        MutableArrayTile result = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols(), this.rows());
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        for (int index$macro$93 = 0; index$macro$93 < layoutRows; ++index$macro$93) {
            for (int index$macro$92 = 0; index$macro$92 < layoutCols; ++index$macro$92) {
                Tile tile = this.getTile(index$macro$92, index$macro$93);
                for (int index$macro$91 = 0; index$macro$91 < tileRows; ++index$macro$91) {
                    for (int index$macro$90 = 0; index$macro$90 < tileCols; ++index$macro$90) {
                        int acol = tileCols * index$macro$92 + index$macro$90;
                        int arow = tileRows * index$macro$93 + index$macro$91;
                        result.set(acol, arow, f.apply$mcIII$sp(tile.get(index$macro$90, index$macro$91), other.get(acol, arow)));
                    }
                }
            }
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile combineDouble(Tile other, Function2<Object, Object, Object> f) {
        void var3_3;
        package$.MODULE$.TileTupleExtensions((Tuple2<Tile, Tile>)new Tuple2((Object)this, (Object)other)).assertEqualDimensions();
        MutableArrayTile result = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols(), this.rows());
        int layoutCols = this.tileLayout().layoutCols();
        int layoutRows = this.tileLayout().layoutRows();
        int tileCols = this.tileLayout().tileCols();
        int tileRows = this.tileLayout().tileRows();
        for (int index$macro$97 = 0; index$macro$97 < layoutRows; ++index$macro$97) {
            for (int index$macro$96 = 0; index$macro$96 < layoutCols; ++index$macro$96) {
                Tile tile = this.getTile(index$macro$96, index$macro$97);
                for (int index$macro$95 = 0; index$macro$95 < tileRows; ++index$macro$95) {
                    for (int index$macro$94 = 0; index$macro$94 < tileCols; ++index$macro$94) {
                        int acol = tileCols * index$macro$96 + index$macro$94;
                        int arow = tileRows * index$macro$97 + index$macro$95;
                        result.setDouble(acol, arow, f.apply$mcDDD$sp(tile.getDouble(index$macro$94, index$macro$95), other.getDouble(acol, arow)));
                    }
                }
            }
        }
        return var3_3;
    }

    public String asciiDraw() {
        StringBuilder sb = new StringBuilder();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.tileLayout().layoutRows()).foreach((Function1 & Serializable & scala.Serializable)layoutRow -> CompositeTile.$anonfun$asciiDraw$1(this, sb, BoxesRunTime.unboxToInt((Object)layoutRow)));
        return sb.toString();
    }

    public CompositeTile copy(Seq<Tile> tiles, TileLayout tileLayout) {
        return new CompositeTile(tiles, tileLayout);
    }

    public Seq<Tile> copy$default$1() {
        return this.tiles();
    }

    public TileLayout copy$default$2() {
        return this.tileLayout();
    }

    public String productPrefix() {
        return "CompositeTile";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.tiles();
                break;
            }
            case 1: {
                object = this.tileLayout();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CompositeTile;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CompositeTile)) return false;
        boolean bl = true;
        if (!bl) return false;
        CompositeTile compositeTile = (CompositeTile)x$1;
        Seq<Tile> seq = this.tiles();
        Seq<Tile> seq2 = compositeTile.tiles();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        TileLayout tileLayout = this.tileLayout();
        TileLayout tileLayout2 = compositeTile.tileLayout();
        if (tileLayout == null) {
            if (tileLayout2 != null) {
                return false;
            }
        } else if (!((Object)tileLayout).equals(tileLayout2)) return false;
        if (!compositeTile.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ StringBuilder $anonfun$asciiDraw$4(StringBuilder sb$1, Tile tile$1, int row$1, int col) {
        int v = tile$1.get(col, row$1);
        String s = v == Integer.MIN_VALUE ? "ND" : String.valueOf(BoxesRunTime.boxToInteger((int)v));
        String pad = new StringOps(Predef$.MODULE$.augmentString(" ")).$times(scala.math.package$.MODULE$.max(6 - new StringOps(Predef$.MODULE$.augmentString(s)).size(), 0));
        return sb$1.append(new java.lang.StringBuilder(0).append(pad).append(s).toString());
    }

    public static final /* synthetic */ Object $anonfun$asciiDraw$3(CompositeTile $this, StringBuilder sb$1, int layoutRow$1, int row$1, int layoutCol) {
        BoxedUnit boxedUnit;
        Tile tile = $this.getTile(layoutCol, layoutRow$1);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), $this.tileLayout().tileCols()).foreach((Function1 & Serializable & scala.Serializable)col -> CompositeTile.$anonfun$asciiDraw$4(sb$1, tile, row$1, BoxesRunTime.unboxToInt((Object)col)));
        if (layoutCol != $this.tileLayout().layoutCols() - 1) {
            String pad = new StringOps(Predef$.MODULE$.augmentString(" ")).$times(5);
            boxedUnit = sb$1.append(new java.lang.StringBuilder(2).append(pad).append("| ").toString()).r();
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public static final /* synthetic */ StringBuilder $anonfun$asciiDraw$2(CompositeTile $this, StringBuilder sb$1, int layoutRow$1, int row) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), $this.tileLayout().layoutCols()).foreach((Function1 & Serializable & scala.Serializable)layoutCol -> CompositeTile.$anonfun$asciiDraw$3($this, sb$1, layoutRow$1, row, BoxesRunTime.unboxToInt((Object)layoutCol)));
        return sb$1.append("\n");
    }

    public static final /* synthetic */ Object $anonfun$asciiDraw$1(CompositeTile $this, StringBuilder sb$1, int layoutRow) {
        BoxedUnit boxedUnit;
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), $this.tileLayout().tileRows()).foreach((Function1 & Serializable & scala.Serializable)row -> CompositeTile.$anonfun$asciiDraw$2($this, sb$1, layoutRow, BoxesRunTime.unboxToInt((Object)row)));
        if (layoutRow != $this.tileLayout().layoutRows() - 1) {
            String rowDiv = new java.lang.StringBuilder(0).append(new StringOps(Predef$.MODULE$.augmentString("-")).$times(6 * $this.tileLayout().tileCols() * $this.tileLayout().layoutCols() - 2)).append(new StringOps(Predef$.MODULE$.augmentString("-")).$times(6 * $this.tileLayout().layoutCols())).toString();
            boxedUnit = sb$1.append(new java.lang.StringBuilder(3).append("  ").append(rowDiv).append("\n").toString());
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return boxedUnit;
    }

    public CompositeTile(Seq<Tile> tiles, TileLayout tileLayout) {
        this.tiles = tiles;
        this.tileLayout = tileLayout;
        Grid.$init$(this);
        IterableTile.$init$(this);
        MappableTile.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        Tile.$init$(this);
        Product.$init$((Product)this);
        Predef$.MODULE$.assert(RichLong$.MODULE$.isValidInt$extension(Predef$.MODULE$.longWrapper(tileLayout.totalCols())), (Function0 & Serializable & scala.Serializable)() -> "Total cols is not integer, cannot create such a large composite tile.");
        Predef$.MODULE$.assert(RichLong$.MODULE$.isValidInt$extension(Predef$.MODULE$.longWrapper(tileLayout.totalRows())), (Function0 & Serializable & scala.Serializable)() -> "Total rows is not integer, cannot create such a large composite tile.");
        this.cols = (int)tileLayout.totalCols();
        this.rows = (int)tileLayout.totalRows();
        this.tileList = tiles.toList();
        this.tileCols = tileLayout.layoutCols();
        this.cellType = ((CellGrid)tiles.apply(0)).cellType();
    }
}

