/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.BitCellType$;
import geotrellis.raster.BitConstantTile;
import geotrellis.raster.ByteCells;
import geotrellis.raster.ByteConstantTile;
import geotrellis.raster.ConstantTile$;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleCells;
import geotrellis.raster.DoubleConstantTile;
import geotrellis.raster.FloatCells;
import geotrellis.raster.FloatConstantTile;
import geotrellis.raster.IntCells;
import geotrellis.raster.IntConstantTile;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.NoDataHandling;
import geotrellis.raster.ShortCells;
import geotrellis.raster.ShortConstantTile;
import geotrellis.raster.Tile;
import geotrellis.raster.UByteCells;
import geotrellis.raster.UByteConstantTile;
import geotrellis.raster.UShortCells;
import geotrellis.raster.UShortConstantTile;
import geotrellis.raster.package$;
import geotrellis.raster.package$DoubleArrayFiller$;
import geotrellis.raster.package$IntArrayFiller$;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005=daB\u0001\u0003!\u0003\r\ta\u0002\u0002\r\u0007>t7\u000f^1oiRKG.\u001a\u0006\u0003\u0007\u0011\taA]1ti\u0016\u0014(\"A\u0003\u0002\u0015\u001d,w\u000e\u001e:fY2L7o\u0001\u0001\u0014\u0007\u0001Aa\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fAi\u0011AA\u0005\u0003#\t\u0011A\u0001V5mK\")1\u0003\u0001C\u0001)\u00051A%\u001b8ji\u0012\"\u0012!\u0006\t\u0003\u0013YI!a\u0006\u0006\u0003\tUs\u0017\u000e\u001e\u0005\b3\u0001\u0011\rQ\"\u0005\u001b\u0003\u0011Ig+\u00197\u0016\u0003m\u0001\"!\u0003\u000f\n\u0005uQ!aA%oi\"9q\u0004\u0001b\u0001\u000e#\u0001\u0013\u0001\u00023WC2,\u0012!\t\t\u0003\u0013\tJ!a\t\u0006\u0003\r\u0011{WO\u00197f\u0011\u0015)\u0003\u0001\"\u0001'\u0003\r9W\r\u001e\u000b\u00047\u001dJ\u0003\"\u0002\u0015%\u0001\u0004Y\u0012aA2pY\")!\u0006\na\u00017\u0005\u0019!o\\<\t\u000b1\u0002A\u0011A\u0017\u0002\u0013\u001d,G\u000fR8vE2,GcA\u0011/_!)\u0001f\u000ba\u00017!)!f\u000ba\u00017!)\u0011\u0007\u0001C\u0001e\u00059Ao\\!se\u0006LH#A\u001a\u0011\u0007%!4$\u0003\u00026\u0015\t)\u0011I\u001d:bs\")q\u0007\u0001C\u0001q\u0005iAo\\!se\u0006LHi\\;cY\u0016$\u0012!\u000f\t\u0004\u0013Q\n\u0003\"B\u001e\u0001\t\u0003a\u0014aB2p]Z,'\u000f\u001e\u000b\u0003\u001duBQA\u0010\u001eA\u0002}\nqA\\3x)f\u0004X\r\u0005\u0002A\u0007:\u0011q\"Q\u0005\u0003\u0005\n\tq\u0001]1dW\u0006<W-\u0003\u0002E\u000b\nA1)\u001a7m)f\u0004XM\u0003\u0002C\u0005!)q\t\u0001C\u0001\u0011\u0006Y\u0011N\u001c;feB\u0014X\r^!t)\tq\u0011\nC\u0003K\r\u0002\u0007q(A\u0006oK^\u001cU\r\u001c7UsB,\u0007\"\u0002'\u0001\t\u0003i\u0015a\u00024pe\u0016\f7\r\u001b\u000b\u0003+9CQaT&A\u0002A\u000b\u0011A\u001a\t\u0005\u0013E[R#\u0003\u0002S\u0015\tIa)\u001e8di&|g.\r\u0005\u0006)\u0002!\t!V\u0001\u000eM>\u0014X-Y2i\t>,(\r\\3\u0015\u0005U1\u0006\"B(T\u0001\u00049\u0006\u0003B\u0005RCUAQ!\u0017\u0001\u0005\u0002i\u000b\u0011CZ8sK\u0006\u001c\u0007.\u00138u-&\u001c\u0018\u000e^8s)\t)2\fC\u0003]1\u0002\u0007Q,A\u0004wSNLGo\u001c:\u0011\u0005\u0001s\u0016BA0F\u00059Ie\u000e\u001e+jY\u00164\u0016n]5u_JDQ!\u0019\u0001\u0005\u0002\t\fACZ8sK\u0006\u001c\u0007\u000eR8vE2,g+[:ji>\u0014HCA\u000bd\u0011\u0015a\u0006\r1\u0001e!\t\u0001U-\u0003\u0002g\u000b\n\tBi\\;cY\u0016$\u0016\u000e\\3WSNLGo\u001c:\t\u000b!\u0004a\u0011A5\u0002\u00075\f\u0007\u000f\u0006\u0002\u000fU\")qj\u001aa\u0001WB!\u0011\"U\u000e\u001c\u0011\u0015i\u0007\u0001\"\u0001o\u0003\u001d\u0019w.\u001c2j]\u0016$\"a\u001c;\u0015\u00059\u0001\b\"B(m\u0001\u0004\t\b#B\u0005s7mY\u0012BA:\u000b\u0005%1UO\\2uS>t'\u0007C\u0003vY\u0002\u0007a\"A\u0003pi\",'\u000fC\u0003x\u0001\u0019\u0005\u00010A\u0005nCB$u.\u001e2mKR\u0011a\"\u001f\u0005\u0006\u001fZ\u0004\rA\u001f\t\u0005\u0013E\u000b\u0013\u0005C\u0003}\u0001\u0011\u0005Q0A\u0007d_6\u0014\u0017N\\3E_V\u0014G.\u001a\u000b\u0004}\u0006\rAC\u0001\b\u0000\u0011\u0019y5\u00101\u0001\u0002\u0002A)\u0011B]\u0011\"C!)Qo\u001fa\u0001\u001d!9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0011\u0001D7ba&sG/T1qa\u0016\u0014Hc\u0001\b\u0002\f!A\u0011QBA\u0003\u0001\u0004\ty!\u0001\u0004nCB\u0004XM\u001d\t\u0004\u0001\u0006E\u0011bAA\n\u000b\ni\u0011J\u001c;US2,W*\u00199qKJDq!a\u0006\u0001\t\u0003\tI\"A\bnCB$u.\u001e2mK6\u000b\u0007\u000f]3s)\rq\u00111\u0004\u0005\t\u0003\u001b\t)\u00021\u0001\u0002\u001eA\u0019\u0001)a\b\n\u0007\u0005\u0005RI\u0001\tE_V\u0014G.\u001a+jY\u0016l\u0015\r\u001d9fe\u001e9\u0011Q\u0005\u0002\t\u0002\u0005\u001d\u0012\u0001D\"p]N$\u0018M\u001c;US2,\u0007cA\b\u0002*\u00191\u0011A\u0001E\u0001\u0003W\u0019R!!\u000b\t\u0003[\u00012!CA\u0018\u0013\r\t\tD\u0003\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t\u0003k\tI\u0003\"\u0001\u00028\u00051A(\u001b8jiz\"\"!a\n\t\u0011\u0005m\u0012\u0011\u0006C\u0001\u0003{\t\u0011B\u001a:p[\nKH/Z:\u0015\u0015\u0005}\u0012\u0011IA'\u0003#\n)\u0006\u0005\u0002\u0010\u0001!A\u00111IA\u001d\u0001\u0004\t)%A\u0003csR,7\u000f\u0005\u0003\ni\u0005\u001d\u0003cA\u0005\u0002J%\u0019\u00111\n\u0006\u0003\t\tKH/\u001a\u0005\b\u0003\u001f\nI\u00041\u0001@\u0003\u0005!\bbBA*\u0003s\u0001\raG\u0001\u0005G>d7\u000fC\u0004\u0002X\u0005e\u0002\u0019A\u000e\u0002\tI|wo\u001d\u0005\u000b\u00037\nI#!A\u0005\n\u0005u\u0013a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"!a\u0018\u0011\t\u0005\u0005\u00141N\u0007\u0003\u0003GRA!!\u001a\u0002h\u0005!A.\u00198h\u0015\t\tI'\u0001\u0003kCZ\f\u0017\u0002BA7\u0003G\u0012aa\u00142kK\u000e$\b")
public interface ConstantTile
extends Tile {
    public static ConstantTile fromBytes(byte[] byArray, DataType dataType, int n, int n2) {
        return ConstantTile$.MODULE$.fromBytes(byArray, dataType, n, n2);
    }

    public int iVal();

    public double dVal();

    public static /* synthetic */ int get$(ConstantTile $this, int col, int row) {
        return $this.get(col, row);
    }

    @Override
    default public int get(int col, int row) {
        return this.iVal();
    }

    public static /* synthetic */ double getDouble$(ConstantTile $this, int col, int row) {
        return $this.getDouble(col, row);
    }

    @Override
    default public double getDouble(int col, int row) {
        return this.dVal();
    }

    public static /* synthetic */ int[] toArray$(ConstantTile $this) {
        return $this.toArray();
    }

    @Override
    default public int[] toArray() {
        return package$IntArrayFiller$.MODULE$.fill$extension(package$.MODULE$.IntArrayFiller((int[])Array$.MODULE$.ofDim(this.cols() * this.rows(), ClassTag$.MODULE$.Int())), this.iVal());
    }

    public static /* synthetic */ double[] toArrayDouble$(ConstantTile $this) {
        return $this.toArrayDouble();
    }

    @Override
    default public double[] toArrayDouble() {
        return package$DoubleArrayFiller$.MODULE$.fill$extension(package$.MODULE$.DoubleArrayFiller((double[])Array$.MODULE$.ofDim(this.cols() * this.rows(), ClassTag$.MODULE$.Double())), this.dVal());
    }

    public static /* synthetic */ Tile convert$(ConstantTile $this, DataType newType) {
        return $this.convert(newType);
    }

    @Override
    default public Tile convert(DataType newType) {
        ConstantTile constantTile;
        BoxedUnit boxedUnit;
        if (newType.isFloatingPoint() != this.cellType().isFloatingPoint()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Conversion from {} to {} may lead to data loss.", (Object[])new DataType[]{this.cellType(), newType});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        DataType dataType = newType;
        if (BitCellType$.MODULE$.equals(dataType)) {
            constantTile = new BitConstantTile(this.iVal() != 0, this.cols(), this.rows());
        } else if (dataType instanceof ByteCells) {
            NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
            constantTile = new ByteConstantTile((byte)this.iVal(), this.cols(), this.rows(), (ByteCells)((Object)noDataHandling));
        } else if (dataType instanceof UByteCells) {
            NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
            constantTile = new UByteConstantTile((byte)this.iVal(), this.cols(), this.rows(), (UByteCells)((Object)noDataHandling));
        } else if (dataType instanceof ShortCells) {
            NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
            constantTile = new ShortConstantTile((short)this.iVal(), this.cols(), this.rows(), (ShortCells)((Object)noDataHandling));
        } else if (dataType instanceof UShortCells) {
            NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
            constantTile = new UShortConstantTile((short)this.iVal(), this.cols(), this.rows(), (UShortCells)((Object)noDataHandling));
        } else if (dataType instanceof IntCells) {
            NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
            constantTile = new IntConstantTile(this.iVal(), this.cols(), this.rows(), (IntCells)((Object)noDataHandling));
        } else if (dataType instanceof FloatCells) {
            NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
            constantTile = new FloatConstantTile((float)this.dVal(), this.cols(), this.rows(), (FloatCells)((Object)noDataHandling));
        } else if (dataType instanceof DoubleCells) {
            NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
            constantTile = new DoubleConstantTile(this.dVal(), this.cols(), this.rows(), (DoubleCells)((Object)noDataHandling));
        } else {
            throw new MatchError((Object)dataType);
        }
        return constantTile;
    }

    public static /* synthetic */ Tile interpretAs$(ConstantTile $this, DataType newCellType) {
        return $this.interpretAs(newCellType);
    }

    @Override
    default public Tile interpretAs(DataType newCellType) {
        return this.withNoData((Option<Object>)None$.MODULE$).convert(newCellType);
    }

    public static /* synthetic */ void foreach$(ConstantTile $this, Function1 f) {
        $this.foreach((Function1<Object, BoxedUnit>)f);
    }

    @Override
    default public void foreach(Function1<Object, BoxedUnit> f) {
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            f.apply$mcVI$sp(this.iVal());
        }
    }

    public static /* synthetic */ void foreachDouble$(ConstantTile $this, Function1 f) {
        $this.foreachDouble((Function1<Object, BoxedUnit>)f);
    }

    @Override
    default public void foreachDouble(Function1<Object, BoxedUnit> f) {
        int len = this.size();
        for (int i = 0; i < len; ++i) {
            f.apply$mcVD$sp(this.dVal());
        }
    }

    public static /* synthetic */ void foreachIntVisitor$(ConstantTile $this, IntTileVisitor visitor) {
        $this.foreachIntVisitor(visitor);
    }

    default public void foreachIntVisitor(IntTileVisitor visitor) {
        for (int index$macro$99 = 0; index$macro$99 < this.rows(); ++index$macro$99) {
            for (int index$macro$98 = 0; index$macro$98 < this.cols(); ++index$macro$98) {
                visitor.apply(index$macro$98, index$macro$99, this.iVal());
            }
        }
    }

    public static /* synthetic */ void foreachDoubleVisitor$(ConstantTile $this, DoubleTileVisitor visitor) {
        $this.foreachDoubleVisitor(visitor);
    }

    default public void foreachDoubleVisitor(DoubleTileVisitor visitor) {
        for (int index$macro$101 = 0; index$macro$101 < this.rows(); ++index$macro$101) {
            for (int index$macro$100 = 0; index$macro$100 < this.cols(); ++index$macro$100) {
                visitor.apply(index$macro$100, index$macro$101, this.dVal());
            }
        }
    }

    @Override
    public Tile map(Function1<Object, Object> var1);

    public static /* synthetic */ Tile combine$(ConstantTile $this, Tile other, Function2 f) {
        return $this.combine(other, (Function2<Object, Object, Object>)f);
    }

    @Override
    default public Tile combine(Tile other, Function2<Object, Object, Object> f) {
        return other.map((Function1<Object, Object>)(JFunction1.mcII.sp & Serializable & scala.Serializable)z -> f.apply$mcIII$sp(this.iVal(), z));
    }

    @Override
    public Tile mapDouble(Function1<Object, Object> var1);

    public static /* synthetic */ Tile combineDouble$(ConstantTile $this, Tile other, Function2 f) {
        return $this.combineDouble(other, (Function2<Object, Object, Object>)f);
    }

    @Override
    default public Tile combineDouble(Tile other, Function2<Object, Object, Object> f) {
        return other.mapDouble((Function1<Object, Object>)(JFunction1.mcDD.sp & Serializable & scala.Serializable)z -> f.apply$mcDDD$sp(this.dVal(), z));
    }

    public static /* synthetic */ Tile mapIntMapper$(ConstantTile $this, IntTileMapper mapper) {
        return $this.mapIntMapper(mapper);
    }

    /*
     * WARNING - void declaration
     */
    default public Tile mapIntMapper(IntTileMapper mapper) {
        void var2_2;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols(), this.rows());
        for (int index$macro$103 = 0; index$macro$103 < this.rows(); ++index$macro$103) {
            for (int index$macro$102 = 0; index$macro$102 < this.cols(); ++index$macro$102) {
                tile.set(index$macro$102, index$macro$103, mapper.apply(index$macro$102, index$macro$103, this.get(index$macro$102, index$macro$103)));
            }
        }
        return var2_2;
    }

    public static /* synthetic */ Tile mapDoubleMapper$(ConstantTile $this, DoubleTileMapper mapper) {
        return $this.mapDoubleMapper(mapper);
    }

    /*
     * WARNING - void declaration
     */
    default public Tile mapDoubleMapper(DoubleTileMapper mapper) {
        void var2_2;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols(), this.rows());
        for (int index$macro$105 = 0; index$macro$105 < this.rows(); ++index$macro$105) {
            for (int index$macro$104 = 0; index$macro$104 < this.cols(); ++index$macro$104) {
                tile.setDouble(index$macro$104, index$macro$105, mapper.apply(index$macro$104, index$macro$105, this.getDouble(index$macro$104, index$macro$105)));
            }
        }
        return var2_2;
    }

    public static void $init$(ConstantTile $this) {
    }
}

