/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.CellSet;
import geotrellis.raster.CroppedTile$;
import geotrellis.raster.DataType;
import geotrellis.raster.Grid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.IterableTile;
import geotrellis.raster.MappableTile;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.package$;
import geotrellis.vector.Extent;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\tUu!B\u0001\u0003\u0011\u00039\u0011aC\"s_B\u0004X\r\u001a+jY\u0016T!a\u0001\u0003\u0002\rI\f7\u000f^3s\u0015\u0005)\u0011AC4f_R\u0014X\r\u001c7jg\u000e\u0001\u0001C\u0001\u0005\n\u001b\u0005\u0011a!\u0002\u0006\u0003\u0011\u0003Y!aC\"s_B\u0004X\r\u001a+jY\u0016\u001c2!\u0003\u0007\u0013!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u0011QbE\u0005\u0003)9\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQAF\u0005\u0005\u0002]\ta\u0001P5oSRtD#A\u0004\t\u000beIA\u0011\u0001\u000e\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000fm\u0011IFa\u0017\u0003lA\u0011\u0001\u0002\b\u0004\u0005\u0015\t\u0001UdE\u0003\u001d\u0019y\t#\u0003\u0005\u0002\t?%\u0011\u0001E\u0001\u0002\u0005)&dW\r\u0005\u0002\u000eE%\u00111E\u0004\u0002\b!J|G-^2u\u0011!)CD!f\u0001\n\u00031\u0013AC:pkJ\u001cW\rV5mKV\ta\u0004\u0003\u0005)9\tE\t\u0015!\u0003\u001f\u0003-\u0019x.\u001e:dKRKG.\u001a\u0011\t\u0011)b\"Q3A\u0005B-\n!b\u001a:jI\n{WO\u001c3t+\u0005a\u0003C\u0001\u0005.\u0013\tq#A\u0001\u0006He&$'i\\;oIND\u0001\u0002\r\u000f\u0003\u0012\u0003\u0006I\u0001L\u0001\fOJLGMQ8v]\u0012\u001c\b\u0005C\u0003\u00179\u0011\u0005!\u0007F\u0002\u001cgQBQ!J\u0019A\u0002yAQAK\u0019A\u00021BqA\u000e\u000fC\u0002\u0013\u0005q'\u0001\u0003d_2\u001cX#\u0001\u001d\u0011\u00055I\u0014B\u0001\u001e\u000f\u0005\rIe\u000e\u001e\u0005\u0007yq\u0001\u000b\u0011\u0002\u001d\u0002\u000b\r|Gn\u001d\u0011\t\u000fyb\"\u0019!C\u0001o\u0005!!o\\<t\u0011\u0019\u0001E\u0004)A\u0005q\u0005)!o\\<tA!9!\t\bb\u0001\n\u0003\u0019\u0015\u0001C2fY2$\u0016\u0010]3\u0016\u0003\u0011\u0003\"!\u0012%\u000f\u0005!1\u0015BA$\u0003\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0013&\u0003\u0011\r+G\u000e\u001c+za\u0016T!a\u0012\u0002\t\r1c\u0002\u0015!\u0003E\u0003%\u0019W\r\u001c7UsB,\u0007\u0005C\u0004O9\t\u0007I\u0011B\u001c\u0002\r\r|G.T5o\u0011\u0019\u0001F\u0004)A\u0005q\u000591m\u001c7NS:\u0004\u0003b\u0002*\u001d\u0005\u0004%IaN\u0001\u0007e><X*\u001b8\t\rQc\u0002\u0015!\u00039\u0003\u001d\u0011xn^'j]\u0002BqA\u0016\u000fC\u0002\u0013%q'\u0001\u0006t_V\u00148-Z\"pYNDa\u0001\u0017\u000f!\u0002\u0013A\u0014aC:pkJ\u001cWmQ8mg\u0002BqA\u0017\u000fC\u0002\u0013%q'\u0001\u0006t_V\u00148-\u001a*poNDa\u0001\u0018\u000f!\u0002\u0013A\u0014aC:pkJ\u001cWMU8xg\u0002BQA\u0018\u000f\u0005\u0002}\u000bqaY8om\u0016\u0014H\u000f\u0006\u0002\u001fA\")\u0011-\u0018a\u0001\t\u0006qA/\u0019:hKR\u001cU\r\u001c7UsB,\u0007\"B2\u001d\t\u0003!\u0017AC<ji\"tu\u000eR1uCR\u00111$\u001a\u0005\u0006M\n\u0004\raZ\u0001\f]>$\u0015\r^1WC2,X\rE\u0002\u000eQ*L!!\u001b\b\u0003\r=\u0003H/[8o!\ti1.\u0003\u0002m\u001d\t1Ai\\;cY\u0016DQA\u001c\u000f\u0005\u0002=\f1\"\u001b8uKJ\u0004(/\u001a;BgR\u00111\u0004\u001d\u0005\u0006c6\u0004\r\u0001R\u0001\f]\u0016<8)\u001a7m)f\u0004X\rC\u0003t9\u0011\u0005A/A\u0002hKR$2\u0001O;x\u0011\u00151(\u000f1\u00019\u0003\r\u0019w\u000e\u001c\u0005\u0006qJ\u0004\r\u0001O\u0001\u0004e><\b\"\u0002>\u001d\t\u0003Y\u0018!C4fi\u0012{WO\u00197f)\rQG0 \u0005\u0006mf\u0004\r\u0001\u000f\u0005\u0006qf\u0004\r\u0001\u000f\u0005\u0007\u007fr!\t!!\u0001\u0002\u0017Q|\u0017I\u001d:bsRKG.\u001a\u000b\u0003\u0003\u0007\u00012\u0001CA\u0003\u0013\r\t9A\u0001\u0002\n\u0003J\u0014\u0018-\u001f+jY\u0016Dq!a\u0003\u001d\t\u0003\ti!A\u0004nkR\f'\r\\3\u0015\u0005\u0005=\u0001c\u0001\u0005\u0002\u0012%\u0019\u00111\u0003\u0002\u0003!5+H/\u00192mK\u0006\u0013(/Y=US2,\u0007bBA\u00069\u0011\u0005\u0011q\u0003\u000b\u0005\u0003\u001f\tI\u0002\u0003\u0004b\u0003+\u0001\r\u0001\u0012\u0005\b\u0003;aB\u0011AA\u0010\u0003\u001d!x.\u0011:sCf$\"!!\t\u0011\t5\t\u0019\u0003O\u0005\u0004\u0003Kq!!B!se\u0006L\bbBA\u00159\u0011\u0005\u00111F\u0001\u000ei>\f%O]1z\t>,(\r\\3\u0015\u0005\u00055\u0002\u0003B\u0007\u0002$)Dq!!\r\u001d\t\u0003\t\u0019$A\u0004u_\nKH/Z:\u0015\u0005\u0005U\u0002#B\u0007\u0002$\u0005]\u0002cA\u0007\u0002:%\u0019\u00111\b\b\u0003\t\tKH/\u001a\u0005\b\u0003\u007faB\u0011AA!\u0003\u001d1wN]3bG\"$B!a\u0011\u0002JA\u0019Q\"!\u0012\n\u0007\u0005\u001dcB\u0001\u0003V]&$\b\u0002CA&\u0003{\u0001\r!!\u0014\u0002\u0003\u0019\u0004b!DA(q\u0005\r\u0013bAA)\u001d\tIa)\u001e8di&|g.\r\u0005\b\u0003+bB\u0011AA,\u000351wN]3bG\"$u.\u001e2mKR!\u00111IA-\u0011!\tY%a\u0015A\u0002\u0005m\u0003CB\u0007\u0002P)\f\u0019\u0005C\u0004\u0002`q!\t!!\u0019\u0002#\u0019|'/Z1dQ&sGOV5tSR|'\u000f\u0006\u0003\u0002D\u0005\r\u0004\u0002CA3\u0003;\u0002\r!a\u001a\u0002\u000fYL7/\u001b;peB\u0019Q)!\u001b\n\u0007\u0005-$J\u0001\bJ]R$\u0016\u000e\\3WSNLGo\u001c:\t\u000f\u0005=D\u0004\"\u0001\u0002r\u0005!bm\u001c:fC\u000eDGi\\;cY\u00164\u0016n]5u_J$B!a\u0011\u0002t!A\u0011QMA7\u0001\u0004\t)\bE\u0002F\u0003oJ1!!\u001fK\u0005E!u.\u001e2mKRKG.\u001a,jg&$xN\u001d\u0005\b\u0003{bB\u0011AA@\u0003\ri\u0017\r\u001d\u000b\u0004=\u0005\u0005\u0005\u0002CA&\u0003w\u0002\r!a!\u0011\u000b5\ty\u0005\u000f\u001d\t\u000f\u0005\u001dE\u0004\"\u0001\u0002\n\u0006IQ.\u00199E_V\u0014G.\u001a\u000b\u0004=\u0005-\u0005\u0002CA&\u0003\u000b\u0003\r!!$\u0011\u000b5\tyE\u001b6\t\u000f\u0005EE\u0004\"\u0001\u0002\u0014\u0006aQ.\u00199J]Rl\u0015\r\u001d9feR\u0019a$!&\t\u0011\u0005]\u0015q\u0012a\u0001\u00033\u000ba!\\1qa\u0016\u0014\bcA#\u0002\u001c&\u0019\u0011Q\u0014&\u0003\u001b%sG\u000fV5mK6\u000b\u0007\u000f]3s\u0011\u001d\t\t\u000b\bC\u0001\u0003G\u000bq\"\\1q\t>,(\r\\3NCB\u0004XM\u001d\u000b\u0004=\u0005\u0015\u0006\u0002CAL\u0003?\u0003\r!a*\u0011\u0007\u0015\u000bI+C\u0002\u0002,*\u0013\u0001\u0003R8vE2,G+\u001b7f\u001b\u0006\u0004\b/\u001a:\t\u000f\u0005=F\u0004\"\u0001\u00022\u000691m\\7cS:,G\u0003BAZ\u0003{#2AHA[\u0011!\tY%!,A\u0002\u0005]\u0006CB\u0007\u0002:bB\u0004(C\u0002\u0002<:\u0011\u0011BR;oGRLwN\u001c\u001a\t\u000f\u0005}\u0016Q\u0016a\u0001=\u0005)q\u000e\u001e5fe\"9\u00111\u0019\u000f\u0005\u0002\u0005\u0015\u0017!D2p[\nLg.\u001a#pk\ndW\r\u0006\u0003\u0002H\u00065Gc\u0001\u0010\u0002J\"A\u00111JAa\u0001\u0004\tY\r\u0005\u0004\u000e\u0003sS'N\u001b\u0005\b\u0003\u007f\u000b\t\r1\u0001\u001f\u0011%\t\t\u000eHA\u0001\n\u0003\t\u0019.\u0001\u0003d_BLH#B\u000e\u0002V\u0006]\u0007\u0002C\u0013\u0002PB\u0005\t\u0019\u0001\u0010\t\u0011)\ny\r%AA\u00021B\u0011\"a7\u001d#\u0003%\t!!8\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u001c\u0016\u0004=\u0005\u00058FAAr!\u0011\t)/a<\u000e\u0005\u0005\u001d(\u0002BAu\u0003W\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u00055h\"\u0001\u0006b]:|G/\u0019;j_:LA!!=\u0002h\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005UH$%A\u0005\u0002\u0005]\u0018AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003sT3\u0001LAq\u0011%\ti\u0010HA\u0001\n\u0003\ny0A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0005\u0003\u0001BAa\u0001\u0003\u000e5\u0011!Q\u0001\u0006\u0005\u0005\u000f\u0011I!\u0001\u0003mC:<'B\u0001B\u0006\u0003\u0011Q\u0017M^1\n\t\t=!Q\u0001\u0002\u0007'R\u0014\u0018N\\4\t\u0011\tMA$!A\u0005\u0002]\nA\u0002\u001d:pIV\u001cG/\u0011:jifD\u0011Ba\u0006\u001d\u0003\u0003%\tA!\u0007\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!1\u0004B\u0011!\ri!QD\u0005\u0004\u0005?q!aA!os\"I!1\u0005B\u000b\u0003\u0003\u0005\r\u0001O\u0001\u0004q\u0012\n\u0004\"\u0003B\u00149\u0005\u0005I\u0011\tB\u0015\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XC\u0001B\u0016!\u0019\u0011iCa\r\u0003\u001c5\u0011!q\u0006\u0006\u0004\u0005cq\u0011AC2pY2,7\r^5p]&!!Q\u0007B\u0018\u0005!IE/\u001a:bi>\u0014\b\"\u0003B\u001d9\u0005\u0005I\u0011\u0001B\u001e\u0003!\u0019\u0017M\\#rk\u0006dG\u0003\u0002B\u001f\u0005\u0007\u00022!\u0004B \u0013\r\u0011\tE\u0004\u0002\b\u0005>|G.Z1o\u0011)\u0011\u0019Ca\u000e\u0002\u0002\u0003\u0007!1\u0004\u0005\n\u0005\u000fb\u0012\u0011!C!\u0005\u0013\n\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002q!I!Q\n\u000f\u0002\u0002\u0013\u0005#qJ\u0001\ti>\u001cFO]5oOR\u0011!\u0011\u0001\u0005\n\u0005'b\u0012\u0011!C!\u0005+\na!Z9vC2\u001cH\u0003\u0002B\u001f\u0005/B!Ba\t\u0003R\u0005\u0005\t\u0019\u0001B\u000e\u0011\u0015)\u0003\u00041\u0001\u001f\u0011\u001d\u0011i\u0006\u0007a\u0001\u0005?\nAb]8ve\u000e,W\t\u001f;f]R\u0004BA!\u0019\u0003h5\u0011!1\r\u0006\u0004\u0005K\"\u0011A\u0002<fGR|'/\u0003\u0003\u0003j\t\r$AB#yi\u0016tG\u000fC\u0004\u0003na\u0001\rAa\u0018\u0002\u0019Q\f'oZ3u\u000bb$XM\u001c;\t\u0011eI\u0011\u0011!CA\u0005c\"Ra\u0007B:\u0005kBa!\nB8\u0001\u0004q\u0002B\u0002\u0016\u0003p\u0001\u0007A\u0006C\u0005\u0003z%\t\t\u0011\"!\u0003|\u00059QO\\1qa2LH\u0003\u0002B?\u0005\u000b\u0003B!\u00045\u0003\u0000A)QB!!\u001fY%\u0019!1\u0011\b\u0003\rQ+\b\u000f\\33\u0011%\u00119Ia\u001e\u0002\u0002\u0003\u00071$A\u0002yIAB\u0011Ba#\n\u0003\u0003%IA!$\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005\u001f\u0003BAa\u0001\u0003\u0012&!!1\u0013B\u0003\u0005\u0019y%M[3di\u0002")
public class CroppedTile
implements Tile,
Product {
    private final Tile sourceTile;
    private final GridBounds gridBounds;
    private final int cols;
    private final int rows;
    private final DataType cellType;
    private final int colMin;
    private final int rowMin;
    private final int sourceCols;
    private final int sourceRows;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static Option<Tuple2<Tile, GridBounds>> unapply(CroppedTile croppedTile) {
        return CroppedTile$.MODULE$.unapply(croppedTile);
    }

    public static CroppedTile apply(Tile tile, GridBounds gridBounds) {
        return CroppedTile$.MODULE$.apply(tile, gridBounds);
    }

    public static CroppedTile apply(Tile tile, Extent extent, Extent extent2) {
        return CroppedTile$.MODULE$.apply(tile, extent, extent2);
    }

    @Override
    public void dualForeach(Function1<Object, BoxedUnit> f, Function1<Object, BoxedUnit> g) {
        Tile.dualForeach$(this, f, g);
    }

    @Override
    public Tile mapIfSet(Function1<Object, Object> f) {
        return Tile.mapIfSet$(this, f);
    }

    @Override
    public Tile mapIfSetDouble(Function1<Object, Object> f) {
        return Tile.mapIfSetDouble$(this, f);
    }

    @Override
    public Tile dualMap(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile.dualMap$(this, f, g);
    }

    @Override
    public Tile dualMapIfSet(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile.dualMapIfSet$(this, f, g);
    }

    @Override
    public Tile dualCombine(Tile r2, Function2<Object, Object, Object> f, Function2<Object, Object, Object> g) {
        return Tile.dualCombine$(this, r2, f, g);
    }

    @Override
    public boolean isNoDataTile() {
        return Tile.isNoDataTile$(this);
    }

    @Override
    public Tile normalize(int oldMin, int oldMax, int newMin, int newMax) {
        return Tile.normalize$((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile normalize(double oldMin, double oldMax, double newMin, double newMax) {
        return Tile.normalize$((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile rescale(int newMin, int newMax) {
        return Tile.rescale$((Tile)this, newMin, newMax);
    }

    @Override
    public Tile rescale(double newMin, double newMax) {
        return Tile.rescale$((Tile)this, newMin, newMax);
    }

    @Override
    public Tile downsample(int newCols, int newRows, Function1<CellSet, Object> f) {
        return Tile.downsample$(this, newCols, newRows, f);
    }

    @Override
    public Tuple2<Object, Object> findMinMax() {
        return Tile.findMinMax$(this);
    }

    @Override
    public Tuple2<Object, Object> findMinMaxDouble() {
        return Tile.findMinMaxDouble$(this);
    }

    @Override
    public int size() {
        return Grid.size$(this);
    }

    @Override
    public Tuple2<Object, Object> dimensions() {
        return Grid.dimensions$(this);
    }

    private Logger logger$lzycompute() {
        CroppedTile croppedTile = this;
        synchronized (croppedTile) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public Tile sourceTile() {
        return this.sourceTile;
    }

    @Override
    public GridBounds gridBounds() {
        return this.gridBounds;
    }

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public DataType cellType() {
        return this.cellType;
    }

    private int colMin() {
        return this.colMin;
    }

    private int rowMin() {
        return this.rowMin;
    }

    private int sourceCols() {
        return this.sourceCols;
    }

    private int sourceRows() {
        return this.sourceRows;
    }

    @Override
    public Tile convert(DataType targetCellType) {
        return this.mutable(targetCellType);
    }

    @Override
    public CroppedTile withNoData(Option<Object> noDataValue) {
        return new CroppedTile(this.sourceTile().withNoData(noDataValue), this.gridBounds());
    }

    @Override
    public CroppedTile interpretAs(DataType newCellType) {
        return new CroppedTile(this.sourceTile().interpretAs(newCellType), this.gridBounds());
    }

    @Override
    public int get(int col, int row) {
        int c = col + this.gridBounds().colMin();
        int r = row + this.gridBounds().rowMin();
        return c < 0 || r < 0 || c >= this.sourceCols() || r >= this.sourceRows() ? Integer.MIN_VALUE : this.sourceTile().get(c, r);
    }

    @Override
    public double getDouble(int col, int row) {
        int c = col + this.gridBounds().colMin();
        int r = row + this.gridBounds().rowMin();
        return c < 0 || r < 0 || c >= this.sourceCols() || r >= this.sourceRows() ? Double.NaN : this.sourceTile().getDouble(col + this.gridBounds().colMin(), row + this.gridBounds().rowMin());
    }

    @Override
    public ArrayTile toArrayTile() {
        return this.mutable();
    }

    @Override
    public MutableArrayTile mutable() {
        return this.mutable(this.cellType());
    }

    /*
     * WARNING - void declaration
     */
    public MutableArrayTile mutable(DataType targetCellType) {
        void var2_2;
        BoxedUnit boxedUnit;
        if (targetCellType.isFloatingPoint() != this.cellType().isFloatingPoint()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Conversion from {} to {} may lead to data loss.", (Object[])new DataType[]{this.cellType(), targetCellType});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(targetCellType, this.cols(), this.rows());
        if (!this.cellType().isFloatingPoint()) {
            for (int index$macro$107 = 0; index$macro$107 < this.rows(); ++index$macro$107) {
                for (int index$macro$106 = 0; index$macro$106 < this.cols(); ++index$macro$106) {
                    tile.set(index$macro$106, index$macro$107, this.get(index$macro$106, index$macro$107));
                }
            }
        } else {
            for (int index$macro$109 = 0; index$macro$109 < this.rows(); ++index$macro$109) {
                for (int index$macro$108 = 0; index$macro$108 < this.cols(); ++index$macro$108) {
                    tile.setDouble(index$macro$108, index$macro$109, this.getDouble(index$macro$108, index$macro$109));
                }
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int[] toArray() {
        void var1_1;
        int[] arr = (int[])Array$.MODULE$.ofDim(this.cols() * this.rows(), ClassTag$.MODULE$.Int());
        int i = 0;
        for (int index$macro$111 = 0; index$macro$111 < this.rows(); ++index$macro$111) {
            for (int index$macro$110 = 0; index$macro$110 < this.cols(); ++index$macro$110) {
                arr[i] = this.get(index$macro$110, index$macro$111);
                ++i;
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double[] toArrayDouble() {
        void var1_1;
        double[] arr = (double[])Array$.MODULE$.ofDim(this.cols() * this.rows(), ClassTag$.MODULE$.Double());
        int i = 0;
        for (int index$macro$113 = 0; index$macro$113 < this.rows(); ++index$macro$113) {
            for (int index$macro$112 = 0; index$macro$112 < this.cols(); ++index$macro$112) {
                arr[i] = this.getDouble(index$macro$112, index$macro$113);
                ++i;
            }
        }
        return var1_1;
    }

    @Override
    public byte[] toBytes() {
        return this.toArrayTile().toBytes();
    }

    @Override
    public void foreach(Function1<Object, BoxedUnit> f) {
        for (int index$macro$115 = 0; index$macro$115 < this.rows(); ++index$macro$115) {
            for (int index$macro$114 = 0; index$macro$114 < this.cols(); ++index$macro$114) {
                f.apply$mcVI$sp(this.get(index$macro$114, index$macro$115));
            }
        }
    }

    @Override
    public void foreachDouble(Function1<Object, BoxedUnit> f) {
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols(), this.rows());
        for (int index$macro$117 = 0; index$macro$117 < this.rows(); ++index$macro$117) {
            for (int index$macro$116 = 0; index$macro$116 < this.cols(); ++index$macro$116) {
                f.apply$mcVD$sp(this.getDouble(index$macro$116, index$macro$117));
            }
        }
    }

    public void foreachIntVisitor(IntTileVisitor visitor) {
        for (int index$macro$119 = 0; index$macro$119 < this.rows(); ++index$macro$119) {
            for (int index$macro$118 = 0; index$macro$118 < this.cols(); ++index$macro$118) {
                visitor.apply(index$macro$118, index$macro$119, this.get(index$macro$118, index$macro$119));
            }
        }
    }

    public void foreachDoubleVisitor(DoubleTileVisitor visitor) {
        for (int index$macro$121 = 0; index$macro$121 < this.rows(); ++index$macro$121) {
            for (int index$macro$120 = 0; index$macro$120 < this.cols(); ++index$macro$120) {
                visitor.apply(index$macro$120, index$macro$121, this.getDouble(index$macro$120, index$macro$121));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile map(Function1<Object, Object> f) {
        void var2_2;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols(), this.rows());
        for (int index$macro$123 = 0; index$macro$123 < this.rows(); ++index$macro$123) {
            for (int index$macro$122 = 0; index$macro$122 < this.cols(); ++index$macro$122) {
                tile.set(index$macro$122, index$macro$123, f.apply$mcII$sp(this.get(index$macro$122, index$macro$123)));
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile mapDouble(Function1<Object, Object> f) {
        void var2_2;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols(), this.rows());
        for (int index$macro$125 = 0; index$macro$125 < this.rows(); ++index$macro$125) {
            for (int index$macro$124 = 0; index$macro$124 < this.cols(); ++index$macro$124) {
                tile.setDouble(index$macro$124, index$macro$125, f.apply$mcDD$sp(this.getDouble(index$macro$124, index$macro$125)));
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Tile mapIntMapper(IntTileMapper mapper) {
        void var2_2;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols(), this.rows());
        for (int index$macro$127 = 0; index$macro$127 < this.rows(); ++index$macro$127) {
            for (int index$macro$126 = 0; index$macro$126 < this.cols(); ++index$macro$126) {
                tile.set(index$macro$126, index$macro$127, mapper.apply(index$macro$126, index$macro$127, this.get(index$macro$126, index$macro$127)));
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Tile mapDoubleMapper(DoubleTileMapper mapper) {
        void var2_2;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols(), this.rows());
        for (int index$macro$129 = 0; index$macro$129 < this.rows(); ++index$macro$129) {
            for (int index$macro$128 = 0; index$macro$128 < this.cols(); ++index$macro$128) {
                tile.setDouble(index$macro$128, index$macro$129, mapper.apply(index$macro$128, index$macro$129, this.getDouble(index$macro$128, index$macro$129)));
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile combine(Tile other, Function2<Object, Object, Object> f) {
        void var3_3;
        package$.MODULE$.TileTupleExtensions((Tuple2<Tile, Tile>)new Tuple2((Object)this, (Object)other)).assertEqualDimensions();
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols(), this.rows());
        for (int index$macro$131 = 0; index$macro$131 < this.rows(); ++index$macro$131) {
            for (int index$macro$130 = 0; index$macro$130 < this.cols(); ++index$macro$130) {
                tile.set(index$macro$130, index$macro$131, f.apply$mcIII$sp(this.get(index$macro$130, index$macro$131), other.get(index$macro$130, index$macro$131)));
            }
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile combineDouble(Tile other, Function2<Object, Object, Object> f) {
        void var3_3;
        package$.MODULE$.TileTupleExtensions((Tuple2<Tile, Tile>)new Tuple2((Object)this, (Object)other)).assertEqualDimensions();
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols(), this.rows());
        for (int index$macro$133 = 0; index$macro$133 < this.rows(); ++index$macro$133) {
            for (int index$macro$132 = 0; index$macro$132 < this.cols(); ++index$macro$132) {
                tile.setDouble(index$macro$132, index$macro$133, f.apply$mcDDD$sp(this.getDouble(index$macro$132, index$macro$133), other.getDouble(index$macro$132, index$macro$133)));
            }
        }
        return var3_3;
    }

    public CroppedTile copy(Tile sourceTile, GridBounds gridBounds) {
        return new CroppedTile(sourceTile, gridBounds);
    }

    public Tile copy$default$1() {
        return this.sourceTile();
    }

    public GridBounds copy$default$2() {
        return this.gridBounds();
    }

    public String productPrefix() {
        return "CroppedTile";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        Serializable serializable;
        int n = x$1;
        switch (n) {
            case 0: {
                serializable = this.sourceTile();
                break;
            }
            case 1: {
                serializable = this.gridBounds();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return serializable;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof CroppedTile;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof CroppedTile)) return false;
        boolean bl = true;
        if (!bl) return false;
        CroppedTile croppedTile = (CroppedTile)x$1;
        Tile tile = this.sourceTile();
        Tile tile2 = croppedTile.sourceTile();
        if (tile == null) {
            if (tile2 != null) {
                return false;
            }
        } else if (!tile.equals(tile2)) return false;
        GridBounds gridBounds = this.gridBounds();
        GridBounds gridBounds2 = croppedTile.gridBounds();
        if (gridBounds == null) {
            if (gridBounds2 != null) {
                return false;
            }
        } else if (!((Object)gridBounds).equals(gridBounds2)) return false;
        if (!croppedTile.canEqual(this)) return false;
        return true;
    }

    public CroppedTile(Tile sourceTile, GridBounds gridBounds) {
        this.sourceTile = sourceTile;
        this.gridBounds = gridBounds;
        Grid.$init$(this);
        IterableTile.$init$(this);
        MappableTile.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        Tile.$init$(this);
        Product.$init$((Product)this);
        this.cols = gridBounds.width();
        this.rows = gridBounds.height();
        this.cellType = sourceTile.cellType();
        this.colMin = gridBounds.colMin();
        this.rowMin = gridBounds.rowMin();
        this.sourceCols = sourceTile.cols();
        this.sourceRows = sourceTile.rows();
    }
}

