/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.CellSet;
import geotrellis.raster.DataType;
import geotrellis.raster.Grid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.IterableTile;
import geotrellis.raster.MappableTile;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.package$;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Ed\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003R3mCf,GmQ8om\u0016\u00148/[8o)&dWM\u0003\u0002\u0004\t\u00051!/Y:uKJT\u0011!B\u0001\u000bO\u0016|GO]3mY&\u001c8\u0001A\n\u0004\u0001!q\u0001CA\u0005\r\u001b\u0005Q!\"A\u0006\u0002\u000bM\u001c\u0017\r\\1\n\u00055Q!AB!osJ+g\r\u0005\u0002\u0010!5\t!!\u0003\u0002\u0012\u0005\t!A+\u001b7f\u0011!\u0019\u0002A!A!\u0002\u0013q\u0011!B5o]\u0016\u0014\b\u0002C\u000b\u0001\u0005\u0003\u0005\u000b\u0011\u0002\f\u0002\u001dQ\f'oZ3u\u0007\u0016dG\u000eV=qKB\u0011qC\u0007\b\u0003\u001faI!!\u0007\u0002\u0002\u000fA\f7m[1hK&\u00111\u0004\b\u0002\t\u0007\u0016dG\u000eV=qK*\u0011\u0011D\u0001\u0005\u0006=\u0001!\taH\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\u0001\n#\u0005\u0005\u0002\u0010\u0001!)1#\ba\u0001\u001d!)Q#\ba\u0001-!9A\u0005\u0001b\u0001\n\u0003)\u0013\u0001B2pYN,\u0012A\n\t\u0003\u0013\u001dJ!\u0001\u000b\u0006\u0003\u0007%sG\u000f\u0003\u0004+\u0001\u0001\u0006IAJ\u0001\u0006G>d7\u000f\t\u0005\bY\u0001\u0011\r\u0011\"\u0001&\u0003\u0011\u0011xn^:\t\r9\u0002\u0001\u0015!\u0003'\u0003\u0015\u0011xn^:!\u0011\u0015\u0001\u0004\u0001\"\u00012\u0003!\u0019W\r\u001c7UsB,W#\u0001\f\t\u000bM\u0002A\u0011\u0001\u001b\u0002\u0007\u001d,G\u000fF\u0002'k]BQA\u000e\u001aA\u0002\u0019\n1aY8m\u0011\u0015A$\u00071\u0001'\u0003\r\u0011xn\u001e\u0005\u0006u\u0001!\taO\u0001\nO\u0016$Hi\\;cY\u0016$2\u0001P A!\tIQ(\u0003\u0002?\u0015\t1Ai\\;cY\u0016DQAN\u001dA\u0002\u0019BQ\u0001O\u001dA\u0002\u0019BQA\u0011\u0001\u0005\u0002\r\u000bqaY8om\u0016\u0014H\u000f\u0006\u0002\u000f\t\")\u0001'\u0011a\u0001-!)a\t\u0001C\u0001\u000f\u0006Qq/\u001b;i\u001d>$\u0015\r^1\u0015\u00059A\u0005\"B%F\u0001\u0004Q\u0015a\u00038p\t\u0006$\u0018MV1mk\u0016\u00042!C&=\u0013\ta%B\u0001\u0004PaRLwN\u001c\u0005\u0006\u001d\u0002!\taT\u0001\fS:$XM\u001d9sKR\f5\u000f\u0006\u0002\u000f!\")\u0011+\u0014a\u0001-\u0005Ya.Z<DK2dG+\u001f9f\u0011\u0015\u0019\u0006\u0001\"\u0001U\u0003\u001d!x.\u0011:sCf$\u0012!\u0016\t\u0004\u0013Y3\u0013BA,\u000b\u0005\u0015\t%O]1z\u0011\u0015I\u0006\u0001\"\u0001[\u00035!x.\u0011:sCf$u.\u001e2mKR\t1\fE\u0002\n-rBQ!\u0018\u0001\u0005\u0002y\u000b1\u0002^8BeJ\f\u0017\u0010V5mKR\tq\f\u0005\u0002\u0010A&\u0011\u0011M\u0001\u0002\n\u0003J\u0014\u0018-\u001f+jY\u0016DQa\u0019\u0001\u0005\u0002\u0011\fq!\\;uC\ndW-F\u0001f!\tya-\u0003\u0002h\u0005\t\u0001R*\u001e;bE2,\u0017I\u001d:bsRKG.\u001a\u0005\u0006S\u0002!\tA[\u0001\bi>\u0014\u0015\u0010^3t)\u0005Y\u0007cA\u0005WYB\u0011\u0011\"\\\u0005\u0003]*\u0011AAQ=uK\")\u0001\u000f\u0001C\u0001c\u00069am\u001c:fC\u000eDGC\u0001:v!\tI1/\u0003\u0002u\u0015\t!QK\\5u\u0011\u00151x\u000e1\u0001x\u0003\u00051\u0007\u0003B\u0005yMIL!!\u001f\u0006\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\"B>\u0001\t\u0003a\u0018!\u00044pe\u0016\f7\r\u001b#pk\ndW\r\u0006\u0002s{\")aO\u001fa\u0001}B!\u0011\u0002\u001f\u001fs\u0011\u001d\t\t\u0001\u0001C\u0001\u0003\u0007\t\u0011CZ8sK\u0006\u001c\u0007.\u00138u-&\u001c\u0018\u000e^8s)\r\u0011\u0018Q\u0001\u0005\b\u0003\u000fy\b\u0019AA\u0005\u0003\u001d1\u0018n]5u_J\u00042aFA\u0006\u0013\r\ti\u0001\b\u0002\u000f\u0013:$H+\u001b7f-&\u001c\u0018\u000e^8s\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'\tACZ8sK\u0006\u001c\u0007\u000eR8vE2,g+[:ji>\u0014Hc\u0001:\u0002\u0016!A\u0011qAA\b\u0001\u0004\t9\u0002E\u0002\u0018\u00033I1!a\u0007\u001d\u0005E!u.\u001e2mKRKG.\u001a,jg&$xN\u001d\u0005\b\u0003?\u0001A\u0011AA\u0011\u0003\ri\u0017\r\u001d\u000b\u0004\u001d\u0005\r\u0002b\u0002<\u0002\u001e\u0001\u0007\u0011Q\u0005\t\u0005\u0013a4c\u0005C\u0004\u0002*\u0001!\t!a\u000b\u0002\u00135\f\u0007\u000fR8vE2,Gc\u0001\b\u0002.!9a/a\nA\u0002\u0005=\u0002\u0003B\u0005yyqBq!a\r\u0001\t\u0003\t)$\u0001\u0007nCBLe\u000e^'baB,'\u000fF\u0002\u000f\u0003oA\u0001\"!\u000f\u00022\u0001\u0007\u00111H\u0001\u0007[\u0006\u0004\b/\u001a:\u0011\u0007]\ti$C\u0002\u0002@q\u0011Q\"\u00138u)&dW-T1qa\u0016\u0014\bbBA\"\u0001\u0011\u0005\u0011QI\u0001\u0010[\u0006\u0004Hi\\;cY\u0016l\u0015\r\u001d9feR\u0019a\"a\u0012\t\u0011\u0005e\u0012\u0011\ta\u0001\u0003\u0013\u00022aFA&\u0013\r\ti\u0005\b\u0002\u0011\t>,(\r\\3US2,W*\u00199qKJDq!!\u0015\u0001\t\u0003\t\u0019&A\u0004d_6\u0014\u0017N\\3\u0015\t\u0005U\u0013q\f\u000b\u0004\u001d\u0005]\u0003b\u0002<\u0002P\u0001\u0007\u0011\u0011\f\t\u0007\u0013\u0005mcE\n\u0014\n\u0007\u0005u#BA\u0005Gk:\u001cG/[8oe!9\u0011\u0011MA(\u0001\u0004q\u0011!B8uQ\u0016\u0014\bbBA3\u0001\u0011\u0005\u0011qM\u0001\u000eG>l'-\u001b8f\t>,(\r\\3\u0015\t\u0005%\u0014q\u000e\u000b\u0004\u001d\u0005-\u0004b\u0002<\u0002d\u0001\u0007\u0011Q\u000e\t\u0007\u0013\u0005mC\b\u0010\u001f\t\u000f\u0005\u0005\u00141\ra\u0001\u001d\u0001")
public class DelayedConversionTile
implements Tile {
    private final Tile inner;
    private final DataType targetCellType;
    private final int cols;
    private final int rows;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public void dualForeach(Function1<Object, BoxedUnit> f, Function1<Object, BoxedUnit> g) {
        Tile.dualForeach$(this, f, g);
    }

    @Override
    public Tile mapIfSet(Function1<Object, Object> f) {
        return Tile.mapIfSet$(this, f);
    }

    @Override
    public Tile mapIfSetDouble(Function1<Object, Object> f) {
        return Tile.mapIfSetDouble$(this, f);
    }

    @Override
    public Tile dualMap(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile.dualMap$(this, f, g);
    }

    @Override
    public Tile dualMapIfSet(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile.dualMapIfSet$(this, f, g);
    }

    @Override
    public Tile dualCombine(Tile r2, Function2<Object, Object, Object> f, Function2<Object, Object, Object> g) {
        return Tile.dualCombine$(this, r2, f, g);
    }

    @Override
    public boolean isNoDataTile() {
        return Tile.isNoDataTile$(this);
    }

    @Override
    public Tile normalize(int oldMin, int oldMax, int newMin, int newMax) {
        return Tile.normalize$((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile normalize(double oldMin, double oldMax, double newMin, double newMax) {
        return Tile.normalize$((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile rescale(int newMin, int newMax) {
        return Tile.rescale$((Tile)this, newMin, newMax);
    }

    @Override
    public Tile rescale(double newMin, double newMax) {
        return Tile.rescale$((Tile)this, newMin, newMax);
    }

    @Override
    public Tile downsample(int newCols, int newRows, Function1<CellSet, Object> f) {
        return Tile.downsample$(this, newCols, newRows, f);
    }

    @Override
    public Tuple2<Object, Object> findMinMax() {
        return Tile.findMinMax$(this);
    }

    @Override
    public Tuple2<Object, Object> findMinMaxDouble() {
        return Tile.findMinMaxDouble$(this);
    }

    @Override
    public int size() {
        return Grid.size$(this);
    }

    @Override
    public Tuple2<Object, Object> dimensions() {
        return Grid.dimensions$(this);
    }

    @Override
    public GridBounds gridBounds() {
        return Grid.gridBounds$(this);
    }

    private Logger logger$lzycompute() {
        DelayedConversionTile delayedConversionTile = this;
        synchronized (delayedConversionTile) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    @Override
    public DataType cellType() {
        return this.inner.cellType();
    }

    @Override
    public int get(int col, int row) {
        return this.inner.get(col, row);
    }

    @Override
    public double getDouble(int col, int row) {
        return this.inner.getDouble(col, row);
    }

    @Override
    public Tile convert(DataType cellType) {
        return this.inner.convert(cellType);
    }

    @Override
    public Tile withNoData(Option<Object> noDataValue) {
        return this.inner.withNoData(noDataValue);
    }

    @Override
    public Tile interpretAs(DataType newCellType) {
        return this.withNoData((Option<Object>)None$.MODULE$).convert(newCellType);
    }

    @Override
    public int[] toArray() {
        return this.inner.toArray();
    }

    @Override
    public double[] toArrayDouble() {
        return this.inner.toArrayDouble();
    }

    @Override
    public ArrayTile toArrayTile() {
        return this.mutable();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MutableArrayTile mutable() {
        void var1_1;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.targetCellType, this.cols(), this.rows());
        if (!this.cellType().isFloatingPoint()) {
            this.inner.foreachIntVisitor(new IntTileVisitor(null, tile){
                private final MutableArrayTile tile$1;

                public void apply(int col, int row, int z) {
                    this.tile$1.set(col, row, z);
                }
                {
                    this.tile$1 = tile$1;
                }
            });
        } else {
            this.inner.foreachDoubleVisitor(new DoubleTileVisitor(null, tile){
                private final MutableArrayTile tile$1;

                public void apply(int col, int row, double z) {
                    this.tile$1.setDouble(col, row, z);
                }
                {
                    this.tile$1 = tile$1;
                }
            });
        }
        return var1_1;
    }

    @Override
    public byte[] toBytes() {
        return this.toArrayTile().toBytes();
    }

    @Override
    public void foreach(Function1<Object, BoxedUnit> f) {
        this.inner.foreach(f);
    }

    @Override
    public void foreachDouble(Function1<Object, BoxedUnit> f) {
        this.inner.foreachDouble(f);
    }

    public void foreachIntVisitor(IntTileVisitor visitor) {
        this.inner.foreachIntVisitor(visitor);
    }

    public void foreachDoubleVisitor(DoubleTileVisitor visitor) {
        this.inner.foreachDoubleVisitor(visitor);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile map(Function1<Object, Object> f) {
        void var2_2;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.targetCellType, this.cols(), this.rows());
        this.inner.foreachIntVisitor(new IntTileVisitor(null, f, tile){
            private final Function1 f$1;
            private final MutableArrayTile tile$2;

            public void apply(int col, int row, int z) {
                this.tile$2.set(col, row, this.f$1.apply$mcII$sp(z));
            }
            {
                this.f$1 = f$1;
                this.tile$2 = tile$2;
            }
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile mapDouble(Function1<Object, Object> f) {
        void var2_2;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.targetCellType, this.cols(), this.rows());
        this.inner.foreachDoubleVisitor(new DoubleTileVisitor(null, f, tile){
            private final Function1 f$2;
            private final MutableArrayTile tile$3;

            public void apply(int col, int row, double z) {
                this.tile$3.setDouble(col, row, this.f$2.apply$mcDD$sp(z));
            }
            {
                this.f$2 = f$2;
                this.tile$3 = tile$3;
            }
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Tile mapIntMapper(IntTileMapper mapper) {
        void var2_2;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.targetCellType, this.cols(), this.rows());
        this.inner.foreachIntVisitor(new IntTileVisitor(null, mapper, tile){
            private final IntTileMapper mapper$1;
            private final MutableArrayTile tile$4;

            public void apply(int col, int row, int z) {
                this.tile$4.set(col, row, this.mapper$1.apply(col, row, z));
            }
            {
                this.mapper$1 = mapper$1;
                this.tile$4 = tile$4;
            }
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Tile mapDoubleMapper(DoubleTileMapper mapper) {
        void var2_2;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.targetCellType, this.cols(), this.rows());
        this.inner.foreachDoubleVisitor(new DoubleTileVisitor(null, mapper, tile){
            private final DoubleTileMapper mapper$2;
            private final MutableArrayTile tile$5;

            public void apply(int col, int row, double z) {
                this.tile$5.setDouble(col, row, this.mapper$2.apply(col, row, z));
            }
            {
                this.mapper$2 = mapper$2;
                this.tile$5 = tile$5;
            }
        });
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile combine(Tile other, Function2<Object, Object, Object> f) {
        void var3_3;
        package$.MODULE$.TileTupleExtensions((Tuple2<Tile, Tile>)new Tuple2((Object)this, (Object)other)).assertEqualDimensions();
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.targetCellType, this.cols(), this.rows());
        this.inner.foreachIntVisitor(new IntTileVisitor(null, other, f, tile){
            private final Tile other$1;
            private final Function2 f$3;
            private final MutableArrayTile tile$6;

            public void apply(int col, int row, int z) {
                this.tile$6.set(col, row, this.f$3.apply$mcIII$sp(z, this.other$1.get(col, row)));
            }
            {
                this.other$1 = other$1;
                this.f$3 = f$3;
                this.tile$6 = tile$6;
            }
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Tile combineDouble(Tile other, Function2<Object, Object, Object> f) {
        void var3_3;
        package$.MODULE$.TileTupleExtensions((Tuple2<Tile, Tile>)new Tuple2((Object)this, (Object)other)).assertEqualDimensions();
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.targetCellType, this.cols(), this.rows());
        this.inner.foreachDoubleVisitor(new DoubleTileVisitor(null, other, f, tile){
            private final Tile other$2;
            private final Function2 f$4;
            private final MutableArrayTile tile$7;

            public void apply(int col, int row, double z) {
                this.tile$7.setDouble(col, row, this.f$4.apply$mcDDD$sp(z, this.other$2.getDouble(col, row)));
            }
            {
                this.other$2 = other$2;
                this.f$4 = f$4;
                this.tile$7 = tile$7;
            }
        });
        return var3_3;
    }

    public DelayedConversionTile(Tile inner, DataType targetCellType) {
        this.inner = inner;
        this.targetCellType = targetCellType;
        Grid.$init$(this);
        IterableTile.$init$(this);
        MappableTile.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        Tile.$init$(this);
        this.cols = inner.cols();
        this.rows = inner.rows();
    }
}

