/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import geotrellis.raster.DoubleArrayTile;
import geotrellis.raster.DoubleCellType$;
import geotrellis.raster.DoubleCells;
import geotrellis.raster.DoubleCells$;
import geotrellis.raster.DoubleConstantNoDataArrayTile;
import geotrellis.raster.DoubleConstantNoDataCellType$;
import geotrellis.raster.DoubleRawArrayTile;
import geotrellis.raster.DoubleUserDefinedNoDataArrayTile;
import geotrellis.raster.DoubleUserDefinedNoDataCellType;
import geotrellis.raster.package$;
import geotrellis.raster.package$DoubleArrayFiller$;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import scala.Array$;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class DoubleArrayTile$
implements Serializable {
    public static DoubleArrayTile$ MODULE$;

    static {
        new DoubleArrayTile$();
    }

    public DoubleArrayTile apply(double[] arr, int cols, int rows) {
        return this.apply(arr, cols, rows, DoubleConstantNoDataCellType$.MODULE$);
    }

    public DoubleArrayTile apply(double[] arr, int cols, int rows, DoubleCells cellType) {
        DoubleArrayTile doubleArrayTile;
        DoubleCells doubleCells = cellType;
        if (DoubleCellType$.MODULE$.equals(doubleCells)) {
            doubleArrayTile = new DoubleRawArrayTile(arr, cols, rows);
        } else if (DoubleConstantNoDataCellType$.MODULE$.equals(doubleCells)) {
            doubleArrayTile = new DoubleConstantNoDataArrayTile(arr, cols, rows);
        } else if (doubleCells instanceof DoubleUserDefinedNoDataCellType) {
            DoubleUserDefinedNoDataCellType doubleUserDefinedNoDataCellType = (DoubleUserDefinedNoDataCellType)doubleCells;
            doubleArrayTile = new DoubleUserDefinedNoDataArrayTile(arr, cols, rows, doubleUserDefinedNoDataCellType);
        } else {
            throw new MatchError((Object)doubleCells);
        }
        return doubleArrayTile;
    }

    public DoubleArrayTile apply(double[] arr, int cols, int rows, Option<Object> noDataValue) {
        return this.apply(arr, cols, rows, DoubleCells$.MODULE$.withNoData(noDataValue));
    }

    public DoubleArrayTile apply(double[] arr, int cols, int rows, double noDataValue) {
        return this.apply(arr, cols, rows, (Option<Object>)new Some((Object)BoxesRunTime.boxToDouble((double)noDataValue)));
    }

    public DoubleArrayTile ofDim(int cols, int rows) {
        return this.ofDim(cols, rows, DoubleConstantNoDataCellType$.MODULE$);
    }

    public DoubleArrayTile ofDim(int cols, int rows, DoubleCells cellType) {
        DoubleArrayTile doubleArrayTile;
        DoubleCells doubleCells = cellType;
        if (DoubleCellType$.MODULE$.equals(doubleCells)) {
            doubleArrayTile = new DoubleRawArrayTile((double[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Double()), cols, rows);
        } else if (DoubleConstantNoDataCellType$.MODULE$.equals(doubleCells)) {
            doubleArrayTile = new DoubleConstantNoDataArrayTile((double[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Double()), cols, rows);
        } else if (doubleCells instanceof DoubleUserDefinedNoDataCellType) {
            DoubleUserDefinedNoDataCellType doubleUserDefinedNoDataCellType = (DoubleUserDefinedNoDataCellType)doubleCells;
            doubleArrayTile = new DoubleUserDefinedNoDataArrayTile((double[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Double()), cols, rows, doubleUserDefinedNoDataCellType);
        } else {
            throw new MatchError((Object)doubleCells);
        }
        return doubleArrayTile;
    }

    public DoubleArrayTile empty(int cols, int rows) {
        return this.empty(cols, rows, DoubleConstantNoDataCellType$.MODULE$);
    }

    public DoubleArrayTile empty(int cols, int rows, DoubleCells cellType) {
        DoubleArrayTile doubleArrayTile;
        DoubleCells doubleCells = cellType;
        if (DoubleCellType$.MODULE$.equals(doubleCells)) {
            doubleArrayTile = this.ofDim(cols, rows, cellType);
        } else if (DoubleConstantNoDataCellType$.MODULE$.equals(doubleCells)) {
            doubleArrayTile = this.fill(Double.NaN, cols, rows, cellType);
        } else if (doubleCells instanceof DoubleUserDefinedNoDataCellType) {
            DoubleUserDefinedNoDataCellType doubleUserDefinedNoDataCellType = (DoubleUserDefinedNoDataCellType)doubleCells;
            double nd = doubleUserDefinedNoDataCellType.noDataValue();
            doubleArrayTile = this.fill(nd, cols, rows, cellType);
        } else {
            throw new MatchError((Object)doubleCells);
        }
        return doubleArrayTile;
    }

    public DoubleArrayTile fill(double v, int cols, int rows) {
        return this.fill(v, cols, rows, DoubleConstantNoDataCellType$.MODULE$);
    }

    public DoubleArrayTile fill(double v, int cols, int rows, DoubleCells cellType) {
        DoubleArrayTile doubleArrayTile;
        DoubleCells doubleCells = cellType;
        if (DoubleCellType$.MODULE$.equals(doubleCells)) {
            doubleArrayTile = new DoubleRawArrayTile(package$DoubleArrayFiller$.MODULE$.fill$extension(package$.MODULE$.DoubleArrayFiller((double[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Double())), v), cols, rows);
        } else if (DoubleConstantNoDataCellType$.MODULE$.equals(doubleCells)) {
            doubleArrayTile = new DoubleConstantNoDataArrayTile(package$DoubleArrayFiller$.MODULE$.fill$extension(package$.MODULE$.DoubleArrayFiller((double[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Double())), v), cols, rows);
        } else if (doubleCells instanceof DoubleUserDefinedNoDataCellType) {
            DoubleUserDefinedNoDataCellType doubleUserDefinedNoDataCellType = (DoubleUserDefinedNoDataCellType)doubleCells;
            doubleArrayTile = new DoubleUserDefinedNoDataArrayTile(package$DoubleArrayFiller$.MODULE$.fill$extension(package$.MODULE$.DoubleArrayFiller((double[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Double())), v), cols, rows, doubleUserDefinedNoDataCellType);
        } else {
            throw new MatchError((Object)doubleCells);
        }
        return doubleArrayTile;
    }

    private double[] constructDoubleArray(byte[] bytes) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes, 0, new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).size());
        DoubleBuffer doubleBuffer = byteBuffer.asDoubleBuffer();
        double[] doubleArray = new double[new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).size() / DoubleConstantNoDataCellType$.MODULE$.bytes()];
        doubleBuffer.get(doubleArray);
        return doubleArray;
    }

    public DoubleArrayTile fromBytes(byte[] bytes, int cols, int rows) {
        return this.fromBytes(bytes, cols, rows, DoubleConstantNoDataCellType$.MODULE$);
    }

    public DoubleArrayTile fromBytes(byte[] bytes, int cols, int rows, DoubleCells cellType) {
        DoubleArrayTile doubleArrayTile;
        DoubleCells doubleCells = cellType;
        if (DoubleCellType$.MODULE$.equals(doubleCells)) {
            doubleArrayTile = new DoubleRawArrayTile(this.constructDoubleArray(bytes), cols, rows);
        } else if (DoubleConstantNoDataCellType$.MODULE$.equals(doubleCells)) {
            doubleArrayTile = new DoubleConstantNoDataArrayTile(this.constructDoubleArray(bytes), cols, rows);
        } else if (doubleCells instanceof DoubleUserDefinedNoDataCellType) {
            DoubleUserDefinedNoDataCellType doubleUserDefinedNoDataCellType = (DoubleUserDefinedNoDataCellType)doubleCells;
            doubleArrayTile = new DoubleUserDefinedNoDataArrayTile(this.constructDoubleArray(bytes), cols, rows, doubleUserDefinedNoDataCellType);
        } else {
            throw new MatchError((Object)doubleCells);
        }
        return doubleArrayTile;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private DoubleArrayTile$() {
        MODULE$ = this;
    }
}

