/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.CellSet;
import geotrellis.raster.ConstantNoData;
import geotrellis.raster.ConstantTile;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleArrayTile$;
import geotrellis.raster.DoubleCells;
import geotrellis.raster.DoubleConstantTile$;
import geotrellis.raster.DoubleUserDefinedNoDataCellType;
import geotrellis.raster.Grid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.IterableTile;
import geotrellis.raster.MappableTile;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.NoNoData;
import geotrellis.raster.Tile;
import java.nio.ByteBuffer;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\t\u0015a\u0001B\u0001\u0003\u0001\u001e\u0011!\u0003R8vE2,7i\u001c8ti\u0006tG\u000fV5mK*\u00111\u0001B\u0001\u0007e\u0006\u001cH/\u001a:\u000b\u0003\u0015\t!bZ3piJ,G\u000e\\5t\u0007\u0001\u0019R\u0001\u0001\u0005\u000f%U\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0011\u001b\u0005\u0011\u0011BA\t\u0003\u00051\u0019uN\\:uC:$H+\u001b7f!\tI1#\u0003\u0002\u0015\u0015\t9\u0001K]8ek\u000e$\bCA\u0005\u0017\u0013\t9\"B\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u001a\u0001\tU\r\u0011\"\u0001\u001b\u0003\u00051X#A\u000e\u0011\u0005%a\u0012BA\u000f\u000b\u0005\u0019!u.\u001e2mK\"Aq\u0004\u0001B\tB\u0003%1$\u0001\u0002wA!A\u0011\u0005\u0001BK\u0002\u0013\u0005!%\u0001\u0003d_2\u001cX#A\u0012\u0011\u0005%!\u0013BA\u0013\u000b\u0005\rIe\u000e\u001e\u0005\tO\u0001\u0011\t\u0012)A\u0005G\u0005)1m\u001c7tA!A\u0011\u0006\u0001BK\u0002\u0013\u0005!%\u0001\u0003s_^\u001c\b\u0002C\u0016\u0001\u0005#\u0005\u000b\u0011B\u0012\u0002\u000bI|wo\u001d\u0011\t\u00115\u0002!Q3A\u0005\u00029\n\u0001bY3mYRK\b/Z\u000b\u0002_I\u0019\u0001GM\u001b\u0007\tE\u0002\u0001a\f\u0002\ryI,g-\u001b8f[\u0016tGO\u0010\t\u0003\u001fMJ!\u0001\u000e\u0002\u0003\u0017\u0011{WO\u00197f\u0007\u0016dGn\u001d\t\u0003\u001fYJ!a\u000e\u0002\u0003\u001d9{G)\u0019;b\u0011\u0006tG\r\\5oO\"A\u0011\b\u0001B\tB\u0003%q&A\u0005dK2dG+\u001f9fA!)1\b\u0001C\u0001y\u00051A(\u001b8jiz\"R!\u0010 @\u0001\u0006\u0003\"a\u0004\u0001\t\u000beQ\u0004\u0019A\u000e\t\u000b\u0005R\u0004\u0019A\u0012\t\u000b%R\u0004\u0019A\u0012\t\u000f5R\u0004\u0013!a\u0001\u0005J\u00191IM\u001b\u0007\tE\u0002\u0001A\u0011\u0005\u000b\u000b\u0002\u0001\n\u0011aA!\u0002\u00131\u0015\u0001\u0002=%eM\u0002B!C$$7%\u0011\u0001J\u0003\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f)\u0003!\u0019!C\tE\u0005!\u0011NV1m\u0011\u0019a\u0005\u0001)A\u0005G\u0005)\u0011NV1mA!9a\n\u0001b\u0001\n#Q\u0012\u0001\u00023WC2Da\u0001\u0015\u0001!\u0002\u0013Y\u0012!\u00023WC2\u0004\u0003\"\u0002*\u0001\t\u0003\u0019\u0016a\u0003;p\u0003J\u0014\u0018-\u001f+jY\u0016$\u0012\u0001\u0016\t\u0003\u001fUK!A\u0016\u0002\u0003\u0013\u0005\u0013(/Y=US2,\u0007\"\u0002-\u0001\t\u0003I\u0016aB7vi\u0006\u0014G.Z\u000b\u00025B\u0011qbW\u0005\u00039\n\u0011\u0001#T;uC\ndW-\u0011:sCf$\u0016\u000e\\3\t\u000by\u0003A\u0011A0\u0002\u000fQ|')\u001f;fgR\t\u0001\rE\u0002\nC\u000eL!A\u0019\u0006\u0003\u000b\u0005\u0013(/Y=\u0011\u0005%!\u0017BA3\u000b\u0005\u0011\u0011\u0015\u0010^3\t\u000b\u001d\u0004A\u0011\u00015\u0002\u0015]LG\u000f\u001b(p\t\u0006$\u0018\r\u0006\u0002\u000fS\")!N\u001aa\u0001W\u0006Yan\u001c#bi\u00064\u0016\r\\;f!\rIAnG\u0005\u0003[*\u0011aa\u00149uS>t\u0007\"B8\u0001\t\u0003\u0001\u0018aA7baR\u0011\u0011\u000f\u001e\t\u0003\u001fIL!a\u001d\u0002\u0003\tQKG.\u001a\u0005\u0006k:\u0004\rA^\u0001\u0002MB!\u0011b^\u0012$\u0013\tA(BA\u0005Gk:\u001cG/[8oc!)!\u0010\u0001C\u0001w\u0006IQ.\u00199E_V\u0014G.\u001a\u000b\u0003crDQ!^=A\u0002u\u0004B!C<\u001c7!Aq\u0010AA\u0001\n\u0003\t\t!\u0001\u0003d_BLH#C\u001f\u0002\u0004\u0005\u0015\u0011qAA\u0005\u0011\u001dIb\u0010%AA\u0002mAq!\t@\u0011\u0002\u0003\u00071\u0005C\u0004*}B\u0005\t\u0019A\u0012\t\u000f5r\b\u0013!a\u0001\u0005\"I\u0011Q\u0002\u0001\u0012\u0002\u0013\u0005\u0011qB\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\t\tBK\u0002\u001c\u0003'Y#!!\u0006\u0011\t\u0005]\u0011\u0011E\u0007\u0003\u00033QA!a\u0007\u0002\u001e\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003?Q\u0011AC1o]>$\u0018\r^5p]&!\u00111EA\r\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0005\n\u0003O\u0001\u0011\u0013!C\u0001\u0003S\tabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002,)\u001a1%a\u0005\t\u0013\u0005=\u0002!%A\u0005\u0002\u0005%\u0012AD2paf$C-\u001a4bk2$He\r\u0005\n\u0003g\u0001\u0011\u0013!C\u0001\u0003k\tabY8qs\u0012\"WMZ1vYR$C'\u0006\u0002\u00028)\u001aq&a\u0005\t\u0013\u0005m\u0002!!A\u0005B\u0005u\u0012!\u00049s_\u0012,8\r\u001e)sK\u001aL\u00070\u0006\u0002\u0002@A!\u0011\u0011IA&\u001b\t\t\u0019E\u0003\u0003\u0002F\u0005\u001d\u0013\u0001\u00027b]\u001eT!!!\u0013\u0002\t)\fg/Y\u0005\u0005\u0003\u001b\n\u0019E\u0001\u0004TiJLgn\u001a\u0005\t\u0003#\u0002\u0011\u0011!C\u0001E\u0005a\u0001O]8ek\u000e$\u0018I]5us\"I\u0011Q\u000b\u0001\u0002\u0002\u0013\u0005\u0011qK\u0001\u000faJ|G-^2u\u000b2,W.\u001a8u)\u0011\tI&a\u0018\u0011\u0007%\tY&C\u0002\u0002^)\u00111!\u00118z\u0011%\t\t'a\u0015\u0002\u0002\u0003\u00071%A\u0002yIEB\u0011\"!\u001a\u0001\u0003\u0003%\t%a\u001a\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!!\u001b\u0011\r\u0005-\u0014\u0011OA-\u001b\t\tiGC\u0002\u0002p)\t!bY8mY\u0016\u001cG/[8o\u0013\u0011\t\u0019(!\u001c\u0003\u0011%#XM]1u_JD\u0011\"a\u001e\u0001\u0003\u0003%\t!!\u001f\u0002\u0011\r\fg.R9vC2$B!a\u001f\u0002\u0002B\u0019\u0011\"! \n\u0007\u0005}$BA\u0004C_>dW-\u00198\t\u0015\u0005\u0005\u0014QOA\u0001\u0002\u0004\tI\u0006C\u0005\u0002\u0006\u0002\t\t\u0011\"\u0011\u0002\b\u0006A\u0001.Y:i\u0007>$W\rF\u0001$\u0011%\tY\tAA\u0001\n\u0003\ni)\u0001\u0005u_N#(/\u001b8h)\t\ty\u0004C\u0005\u0002\u0012\u0002\t\t\u0011\"\u0011\u0002\u0014\u00061Q-];bYN$B!a\u001f\u0002\u0016\"Q\u0011\u0011MAH\u0003\u0003\u0005\r!!\u0017\b\u000f\u0005e%\u0001#\u0001\u0002\u001c\u0006\u0011Bi\\;cY\u0016\u001cuN\\:uC:$H+\u001b7f!\ry\u0011Q\u0014\u0004\u0007\u0003\tA\t!a(\u0014\t\u0005u\u0005\"\u0006\u0005\bw\u0005uE\u0011AAR)\t\tY\n\u0003\u0005\u0002(\u0006uE\u0011AAU\u0003%1'o\\7CsR,7\u000fF\u0005>\u0003W\u000by+!-\u00024\"9\u0011QVAS\u0001\u0004\u0001\u0017!\u00022zi\u0016\u001c\bBB\u0011\u0002&\u0002\u00071\u0005\u0003\u0004*\u0003K\u0003\ra\t\u0005\b[\u0005\u0015\u0006\u0019AA[%\u0011\t9LM\u001b\u0007\rE\ni\nAA[\u0011)\tY,!(\u0002\u0002\u0013\u0005\u0015QX\u0001\u0006CB\u0004H.\u001f\u000b\n{\u0005}\u0016\u0011YAb\u0003\u000bDa!GA]\u0001\u0004Y\u0002BB\u0011\u0002:\u0002\u00071\u0005\u0003\u0004*\u0003s\u0003\ra\t\u0005\n[\u0005e\u0006\u0013!a\u0001\u0003\u000f\u0014B!!33k\u00191\u0011'!(\u0001\u0003\u000fD!\"!4\u0002\u001e\u0006\u0005I\u0011QAh\u0003\u001d)h.\u00199qYf$B!!5\u0002^B!\u0011\u0002\\Aj!!I\u0011Q[\u000e$G\u0005e\u0017bAAl\u0015\t1A+\u001e9mKR\u0012B!a73k\u00191\u0011'!(\u0001\u00033D\u0011\"a8\u0002L\u0006\u0005\t\u0019A\u001f\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002d\u0006u\u0015\u0013!C\u0001\u0003K\fq\"\u00199qYf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003OTC!!;\u0002\u0014I!\u00111\u001e\u001a6\r\u0019\t\u0014Q\u0014\u0001\u0002j\"Q\u0011q^AO#\u0003%\t!!=\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00135+\t\t\u0019P\u000b\u0003\u0002v\u0006M!\u0003BA|eU2a!MAO\u0001\u0005U\bBCA~\u0003;\u000b\t\u0011\"\u0003\u0002~\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\ty\u0010\u0005\u0003\u0002B\t\u0005\u0011\u0002\u0002B\u0002\u0003\u0007\u0012aa\u00142kK\u000e$\b")
public class DoubleConstantTile
implements ConstantTile,
Product {
    private final double v;
    private final int cols;
    private final int rows;
    private final DoubleCells cellType;
    private final /* synthetic */ Tuple2 x$23;
    private final int iVal;
    private final double dVal;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static DoubleCells $lessinit$greater$default$4() {
        return DoubleConstantTile$.MODULE$.$lessinit$greater$default$4();
    }

    public static DoubleCells apply$default$4() {
        return DoubleConstantTile$.MODULE$.apply$default$4();
    }

    public static Option<Tuple4<Object, Object, Object, DoubleCells>> unapply(DoubleConstantTile doubleConstantTile) {
        return DoubleConstantTile$.MODULE$.unapply(doubleConstantTile);
    }

    public static DoubleConstantTile apply(double d, int n, int n2, DoubleCells doubleCells) {
        return DoubleConstantTile$.MODULE$.apply(d, n, n2, doubleCells);
    }

    public static DoubleConstantTile fromBytes(byte[] byArray, int n, int n2, DoubleCells doubleCells) {
        return DoubleConstantTile$.MODULE$.fromBytes(byArray, n, n2, doubleCells);
    }

    @Override
    public int get(int col, int row) {
        return ConstantTile.get$(this, col, row);
    }

    @Override
    public double getDouble(int col, int row) {
        return ConstantTile.getDouble$(this, col, row);
    }

    @Override
    public int[] toArray() {
        return ConstantTile.toArray$(this);
    }

    @Override
    public double[] toArrayDouble() {
        return ConstantTile.toArrayDouble$(this);
    }

    @Override
    public Tile convert(DataType newType) {
        return ConstantTile.convert$(this, newType);
    }

    @Override
    public Tile interpretAs(DataType newCellType) {
        return ConstantTile.interpretAs$(this, newCellType);
    }

    @Override
    public void foreach(Function1<Object, BoxedUnit> f) {
        ConstantTile.foreach$(this, f);
    }

    @Override
    public void foreachDouble(Function1<Object, BoxedUnit> f) {
        ConstantTile.foreachDouble$(this, f);
    }

    @Override
    public void foreachIntVisitor(IntTileVisitor visitor) {
        ConstantTile.foreachIntVisitor$(this, visitor);
    }

    @Override
    public void foreachDoubleVisitor(DoubleTileVisitor visitor) {
        ConstantTile.foreachDoubleVisitor$(this, visitor);
    }

    @Override
    public Tile combine(Tile other, Function2<Object, Object, Object> f) {
        return ConstantTile.combine$(this, other, f);
    }

    @Override
    public Tile combineDouble(Tile other, Function2<Object, Object, Object> f) {
        return ConstantTile.combineDouble$(this, other, f);
    }

    @Override
    public Tile mapIntMapper(IntTileMapper mapper) {
        return ConstantTile.mapIntMapper$(this, mapper);
    }

    @Override
    public Tile mapDoubleMapper(DoubleTileMapper mapper) {
        return ConstantTile.mapDoubleMapper$(this, mapper);
    }

    @Override
    public void dualForeach(Function1<Object, BoxedUnit> f, Function1<Object, BoxedUnit> g) {
        Tile.dualForeach$(this, f, g);
    }

    @Override
    public Tile mapIfSet(Function1<Object, Object> f) {
        return Tile.mapIfSet$(this, f);
    }

    @Override
    public Tile mapIfSetDouble(Function1<Object, Object> f) {
        return Tile.mapIfSetDouble$(this, f);
    }

    @Override
    public Tile dualMap(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile.dualMap$(this, f, g);
    }

    @Override
    public Tile dualMapIfSet(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile.dualMapIfSet$(this, f, g);
    }

    @Override
    public Tile dualCombine(Tile r2, Function2<Object, Object, Object> f, Function2<Object, Object, Object> g) {
        return Tile.dualCombine$(this, r2, f, g);
    }

    @Override
    public boolean isNoDataTile() {
        return Tile.isNoDataTile$(this);
    }

    @Override
    public Tile normalize(int oldMin, int oldMax, int newMin, int newMax) {
        return Tile.normalize$((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile normalize(double oldMin, double oldMax, double newMin, double newMax) {
        return Tile.normalize$((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile rescale(int newMin, int newMax) {
        return Tile.rescale$((Tile)this, newMin, newMax);
    }

    @Override
    public Tile rescale(double newMin, double newMax) {
        return Tile.rescale$((Tile)this, newMin, newMax);
    }

    @Override
    public Tile downsample(int newCols, int newRows, Function1<CellSet, Object> f) {
        return Tile.downsample$(this, newCols, newRows, f);
    }

    @Override
    public Tuple2<Object, Object> findMinMax() {
        return Tile.findMinMax$(this);
    }

    @Override
    public Tuple2<Object, Object> findMinMaxDouble() {
        return Tile.findMinMaxDouble$(this);
    }

    @Override
    public int size() {
        return Grid.size$(this);
    }

    @Override
    public Tuple2<Object, Object> dimensions() {
        return Grid.dimensions$(this);
    }

    @Override
    public GridBounds gridBounds() {
        return Grid.gridBounds$(this);
    }

    private Logger logger$lzycompute() {
        DoubleConstantTile doubleConstantTile = this;
        synchronized (doubleConstantTile) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public double v() {
        return this.v;
    }

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    public DoubleCells cellType() {
        return this.cellType;
    }

    @Override
    public int iVal() {
        return this.iVal;
    }

    @Override
    public double dVal() {
        return this.dVal;
    }

    @Override
    public ArrayTile toArrayTile() {
        return this.mutable();
    }

    @Override
    public MutableArrayTile mutable() {
        return DoubleArrayTile$.MODULE$.fill(this.dVal(), this.cols(), this.rows(), this.cellType());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] toBytes() {
        void var1_1;
        byte[] arr = (byte[])Array$.MODULE$.ofDim(((DataType)((Object)this.cellType())).bytes(), ClassTag$.MODULE$.Byte());
        ByteBuffer.wrap(arr).asDoubleBuffer().put(this.v());
        return var1_1;
    }

    @Override
    public ConstantTile withNoData(Option<Object> noDataValue) {
        return new DoubleConstantTile(this.v(), this.cols(), this.rows(), this.cellType().withNoData(noDataValue));
    }

    @Override
    public Tile map(Function1<Object, Object> f) {
        int n = f.apply$mcII$sp(this.iVal());
        return new DoubleConstantTile(n == Integer.MIN_VALUE ? Double.NaN : (double)n, this.cols(), this.rows(), this.cellType());
    }

    @Override
    public Tile mapDouble(Function1<Object, Object> f) {
        return new DoubleConstantTile(f.apply$mcDD$sp(this.dVal()), this.cols(), this.rows(), DoubleConstantTile$.MODULE$.apply$default$4());
    }

    public DoubleConstantTile copy(double v, int cols, int rows, DoubleCells cellType) {
        return new DoubleConstantTile(v, cols, rows, cellType);
    }

    public double copy$default$1() {
        return this.v();
    }

    public int copy$default$2() {
        return this.cols();
    }

    public int copy$default$3() {
        return this.rows();
    }

    public DoubleCells copy$default$4() {
        return this.cellType();
    }

    public String productPrefix() {
        return "DoubleConstantTile";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = BoxesRunTime.boxToDouble((double)this.v());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this.cols());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this.rows());
                break;
            }
            case 3: {
                object = this.cellType();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof DoubleConstantTile;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.v()));
        n = Statics.mix((int)n, (int)this.cols());
        n = Statics.mix((int)n, (int)this.rows());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.cellType()));
        return Statics.finalizeHash((int)n, (int)4);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof DoubleConstantTile)) return false;
        boolean bl = true;
        if (!bl) return false;
        DoubleConstantTile doubleConstantTile = (DoubleConstantTile)x$1;
        if (this.v() != doubleConstantTile.v()) return false;
        if (this.cols() != doubleConstantTile.cols()) return false;
        if (this.rows() != doubleConstantTile.rows()) return false;
        DoubleCells doubleCells = this.cellType();
        DoubleCells doubleCells2 = doubleConstantTile.cellType();
        if (doubleCells == null) {
            if (doubleCells2 != null) {
                return false;
            }
        } else if (!doubleCells.equals(doubleCells2)) return false;
        if (!doubleConstantTile.canEqual(this)) return false;
        return true;
    }

    public DoubleConstantTile(double v, int cols, int rows, DoubleCells cellType) {
        Tuple2.mcID.sp sp2;
        this.v = v;
        this.cols = cols;
        this.rows = rows;
        this.cellType = cellType;
        Grid.$init$(this);
        IterableTile.$init$(this);
        MappableTile.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        Tile.$init$(this);
        ConstantTile.$init$(this);
        Product.$init$((Product)this);
        DoubleCells doubleCells = cellType;
        if (doubleCells instanceof ConstantNoData) {
            double n = v;
            sp2 = new Tuple2.mcID.sp(Double.isNaN(n) ? Integer.MIN_VALUE : (int)n, v);
        } else if (doubleCells instanceof NoNoData) {
            sp2 = new Tuple2.mcID.sp((int)v, v);
        } else if (doubleCells instanceof DoubleUserDefinedNoDataCellType) {
            DoubleUserDefinedNoDataCellType doubleUserDefinedNoDataCellType = (DoubleUserDefinedNoDataCellType)doubleCells;
            sp2 = doubleUserDefinedNoDataCellType.noDataValue() == v ? new Tuple2.mcID.sp(Integer.MIN_VALUE, Double.NaN) : new Tuple2.mcID.sp((int)v, v);
        } else {
            throw new MatchError((Object)doubleCells);
        }
        Tuple2.mcID.sp sp3 = sp2;
        if (sp3 == null) {
            throw new MatchError((Object)sp3);
        }
        int iVal = sp3._1$mcI$sp();
        double dVal = sp3._2$mcD$sp();
        int n = iVal;
        double d = dVal;
        Tuple2.mcID.sp sp4 = new Tuple2.mcID.sp(n, d);
        this.x$23 = sp4;
        this.iVal = this.x$23._1$mcI$sp();
        this.dVal = this.x$23._2$mcD$sp();
    }
}

