/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.CellSet;
import geotrellis.raster.DataType;
import geotrellis.raster.FloatArrayTile$;
import geotrellis.raster.FloatCells;
import geotrellis.raster.Grid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.IterableTile;
import geotrellis.raster.MappableTile;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import java.nio.ByteBuffer;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005Me!B\u0001\u0003\u0003\u00039!A\u0004$m_\u0006$\u0018I\u001d:bsRKG.\u001a\u0006\u0003\u0007\u0011\taA]1ti\u0016\u0014(\"A\u0003\u0002\u0015\u001d,w\u000e\u001e:fY2L7o\u0001\u0001\u0014\u0007\u0001Aa\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fAi\u0011AA\u0005\u0003#\t\u0011\u0001#T;uC\ndW-\u0011:sCf$\u0016\u000e\\3\t\u0011M\u0001!Q1A\u0005\u0002Q\tQ!\u0019:sCf,\u0012!\u0006\t\u0004\u0013YA\u0012BA\f\u000b\u0005\u0015\t%O]1z!\tI\u0011$\u0003\u0002\u001b\u0015\t)a\t\\8bi\"AA\u0004\u0001B\u0001B\u0003%Q#\u0001\u0004beJ\f\u0017\u0010\t\u0005\t=\u0001\u0011\t\u0011)A\u0005?\u0005!1m\u001c7t!\tI\u0001%\u0003\u0002\"\u0015\t\u0019\u0011J\u001c;\t\u0011\r\u0002!\u0011!Q\u0001\n}\tAA]8xg\")Q\u0005\u0001C\u0001M\u00051A(\u001b8jiz\"Ba\n\u0015*UA\u0011q\u0002\u0001\u0005\u0006'\u0011\u0002\r!\u0006\u0005\u0006=\u0011\u0002\ra\b\u0005\u0006G\u0011\u0002\ra\b\u0005\bY\u0001\u0011\rQ\"\u0001.\u0003!\u0019W\r\u001c7UsB,W#\u0001\u0018\u0013\u0007=\nDG\u0002\u00031\u0001\u0001q#\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004CA\b3\u0013\t\u0019$A\u0001\u0006GY>\fGoQ3mYN\u0004\"aD\u001b\n\u0005Y\u0012!A\u0004(p\t\u0006$\u0018\rS1oI2Lgn\u001a\u0005\u0006q\u0001!\t!O\u0001\bi>\u0014\u0015\u0010^3t)\u0005Q\u0004cA\u0005\u0017wA\u0011\u0011\u0002P\u0005\u0003{)\u0011AAQ=uK\")q\b\u0001C\u0001\u0001\u0006!1m\u001c9z+\u0005\t\u0005CA\bC\u0013\t\u0019%AA\u0005BeJ\f\u0017\u0010V5mK\")Q\t\u0001C\u0001\r\u0006Qq/\u001b;i\u001d>$\u0015\r^1\u0015\u0005\u001d:\u0005\"\u0002%E\u0001\u0004I\u0015a\u00038p\t\u0006$\u0018MV1mk\u0016\u00042!\u0003&M\u0013\tY%B\u0001\u0004PaRLwN\u001c\t\u0003\u00135K!A\u0014\u0006\u0003\r\u0011{WO\u00197f\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0003-Ig\u000e^3saJ,G/Q:\u0015\u0005I+\u0006CA\bT\u0013\t!&A\u0001\u0003US2,\u0007\"\u0002,P\u0001\u00049\u0016a\u00038fo\u000e+G\u000e\u001c+za\u0016\u0004\"\u0001W.\u000f\u0005=I\u0016B\u0001.\u0003\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001X/\u0003\u0011\r+G\u000e\u001c+za\u0016T!A\u0017\u0002\b\u000b}\u0013\u0001\u0012\u00011\u0002\u001d\u0019cw.\u0019;BeJ\f\u0017\u0010V5mKB\u0011q\"\u0019\u0004\u0006\u0003\tA\tAY\n\u0004C\"\u0019\u0007CA\u0005e\u0013\t)'B\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003&C\u0012\u0005q\rF\u0001a\u0011\u0015I\u0017\r\"\u0001k\u0003\u0015\t\u0007\u000f\u001d7z)\u001193.\u001c8\t\u000b1D\u0007\u0019A\u000b\u0002\u0007\u0005\u0014(\u000fC\u0003\u001fQ\u0002\u0007q\u0004C\u0003$Q\u0002\u0007q\u0004C\u0003jC\u0012\u0005\u0001\u000fF\u0003(cJ\u001cH\u000fC\u0003m_\u0002\u0007Q\u0003C\u0003\u001f_\u0002\u0007q\u0004C\u0003$_\u0002\u0007q\u0004C\u0003-_\u0002\u0007QOE\u0002wcQ2A\u0001M1\u0001k\")\u0011.\u0019C\u0001qR)q%\u001f>|y\")An\u001ea\u0001+!)ad\u001ea\u0001?!)1e\u001ea\u0001?!)\u0001j\u001ea\u0001{B\u0019\u0011B\u0013\r\t\u000b%\fG\u0011A@\u0015\u0013\u001d\n\t!a\u0001\u0002\u0006\u0005\u001d\u0001\"\u00027\u007f\u0001\u0004)\u0002\"\u0002\u0010\u007f\u0001\u0004y\u0002\"B\u0012\u007f\u0001\u0004y\u0002\"\u0002%\u007f\u0001\u0004A\u0002bBA\u0006C\u0012\u0005\u0011QB\u0001\u0006_\u001a$\u0015.\u001c\u000b\u0006O\u0005=\u0011\u0011\u0003\u0005\u0007=\u0005%\u0001\u0019A\u0010\t\r\r\nI\u00011\u0001 \u0011\u001d\tY!\u0019C\u0001\u0003+!raJA\f\u00033\tY\u0002\u0003\u0004\u001f\u0003'\u0001\ra\b\u0005\u0007G\u0005M\u0001\u0019A\u0010\t\u000f1\n\u0019\u00021\u0001\u0002\u001eI!\u0011qD\u00195\r\u0015\u0001\u0014\rAA\u000f\u0011\u001d\t\u0019#\u0019C\u0001\u0003K\tQ!Z7qif$RaJA\u0014\u0003SAaAHA\u0011\u0001\u0004y\u0002BB\u0012\u0002\"\u0001\u0007q\u0004C\u0004\u0002$\u0005$\t!!\f\u0015\u000f\u001d\ny#!\r\u00024!1a$a\u000bA\u0002}AaaIA\u0016\u0001\u0004y\u0002b\u0002\u0017\u0002,\u0001\u0007\u0011Q\u0007\n\u0005\u0003o\tDGB\u00031C\u0002\t)\u0004C\u0004\u0002<\u0005$\t!!\u0010\u0002\t\u0019LG\u000e\u001c\u000b\bO\u0005}\u00121IA#\u0011\u001d\t\t%!\u000fA\u0002a\t\u0011A\u001e\u0005\u0007=\u0005e\u0002\u0019A\u0010\t\r\r\nI\u00041\u0001 \u0011\u001d\tY$\u0019C\u0001\u0003\u0013\"\u0012bJA&\u0003\u001b\ny%!\u0015\t\u000f\u0005\u0005\u0013q\ta\u00011!1a$a\u0012A\u0002}AaaIA$\u0001\u0004y\u0002b\u0002\u0017\u0002H\u0001\u0007\u00111\u000b\n\u0005\u0003+\nDGB\u00031C\u0002\t\u0019\u0006C\u0004\u0002Z\u0005$I!a\u0017\u0002'\r|gn\u001d;sk\u000e$h\t\\8bi\u0006\u0013(/Y=\u0015\u0007U\ti\u0006C\u0004\u0002`\u0005]\u0003\u0019\u0001\u001e\u0002\u000b\tLH/Z:\t\u000f\u0005\r\u0014\r\"\u0001\u0002f\u0005IaM]8n\u0005f$Xm\u001d\u000b\bO\u0005\u001d\u0014\u0011NA6\u0011\u001d\ty&!\u0019A\u0002iBaAHA1\u0001\u0004y\u0002BB\u0012\u0002b\u0001\u0007q\u0004C\u0004\u0002d\u0005$\t!a\u001c\u0015\u0013\u001d\n\t(a\u001d\u0002v\u0005]\u0004bBA0\u0003[\u0002\rA\u000f\u0005\u0007=\u00055\u0004\u0019A\u0010\t\r\r\ni\u00071\u0001 \u0011\u001da\u0013Q\u000ea\u0001\u0003s\u0012B!a\u001f2i\u0019)\u0001'\u0019\u0001\u0002z!I\u0011qP1\u0002\u0002\u0013%\u0011\u0011Q\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002\u0004B!\u0011QQAH\u001b\t\t9I\u0003\u0003\u0002\n\u0006-\u0015\u0001\u00027b]\u001eT!!!$\u0002\t)\fg/Y\u0005\u0005\u0003#\u000b9I\u0001\u0004PE*,7\r\u001e")
public abstract class FloatArrayTile
implements MutableArrayTile {
    private final float[] array;
    private final int cols;
    private final int rows;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static FloatArrayTile fromBytes(byte[] byArray, int n, int n2, FloatCells floatCells) {
        return FloatArrayTile$.MODULE$.fromBytes(byArray, n, n2, floatCells);
    }

    public static FloatArrayTile fromBytes(byte[] byArray, int n, int n2) {
        return FloatArrayTile$.MODULE$.fromBytes(byArray, n, n2);
    }

    public static FloatArrayTile fill(float f, int n, int n2, FloatCells floatCells) {
        return FloatArrayTile$.MODULE$.fill(f, n, n2, floatCells);
    }

    public static FloatArrayTile fill(float f, int n, int n2) {
        return FloatArrayTile$.MODULE$.fill(f, n, n2);
    }

    public static FloatArrayTile empty(int n, int n2, FloatCells floatCells) {
        return FloatArrayTile$.MODULE$.empty(n, n2, floatCells);
    }

    public static FloatArrayTile empty(int n, int n2) {
        return FloatArrayTile$.MODULE$.empty(n, n2);
    }

    public static FloatArrayTile ofDim(int n, int n2, FloatCells floatCells) {
        return FloatArrayTile$.MODULE$.ofDim(n, n2, floatCells);
    }

    public static FloatArrayTile ofDim(int n, int n2) {
        return FloatArrayTile$.MODULE$.ofDim(n, n2);
    }

    @Override
    public MutableArrayTile mutable() {
        return MutableArrayTile.mutable$(this);
    }

    @Override
    public void set(int col, int row, int value) {
        MutableArrayTile.set$(this, col, row, value);
    }

    @Override
    public void setDouble(int col, int row, double value) {
        MutableArrayTile.setDouble$(this, col, row, value);
    }

    @Override
    public void update(int colOffset, int rowOffset, Tile update) {
        MutableArrayTile.update$(this, colOffset, rowOffset, update);
    }

    @Override
    public ArrayTile toArrayTile() {
        return ArrayTile.toArrayTile$(this);
    }

    @Override
    public ArrayTile convert(DataType targetCellType) {
        return ArrayTile.convert$(this, targetCellType);
    }

    @Override
    public void foreach(Function1<Object, BoxedUnit> f) {
        ArrayTile.foreach$(this, f);
    }

    @Override
    public void foreachDouble(Function1<Object, BoxedUnit> f) {
        ArrayTile.foreachDouble$(this, f);
    }

    @Override
    public void foreachIntVisitor(IntTileVisitor visitor) {
        ArrayTile.foreachIntVisitor$(this, visitor);
    }

    @Override
    public void foreachDoubleVisitor(DoubleTileVisitor visitor) {
        ArrayTile.foreachDoubleVisitor$(this, visitor);
    }

    @Override
    public Tile map(Function1<Object, Object> f) {
        return ArrayTile.map$(this, f);
    }

    @Override
    public Tile mapDouble(Function1<Object, Object> f) {
        return ArrayTile.mapDouble$(this, f);
    }

    @Override
    public Tile mapIntMapper(IntTileMapper mapper) {
        return ArrayTile.mapIntMapper$(this, mapper);
    }

    @Override
    public Tile mapDoubleMapper(DoubleTileMapper mapper) {
        return ArrayTile.mapDoubleMapper$(this, mapper);
    }

    @Override
    public ArrayTile combine(ArrayTile other, Function2<Object, Object, Object> f) {
        return ArrayTile.combine$((ArrayTile)this, other, f);
    }

    @Override
    public Tile combine(Tile other, Function2<Object, Object, Object> f) {
        return ArrayTile.combine$((ArrayTile)this, other, f);
    }

    @Override
    public ArrayTile combineDouble(ArrayTile other, Function2<Object, Object, Object> f) {
        return ArrayTile.combineDouble$((ArrayTile)this, other, f);
    }

    @Override
    public Tile combineDouble(Tile other, Function2<Object, Object, Object> f) {
        return ArrayTile.combineDouble$((ArrayTile)this, other, f);
    }

    @Override
    public boolean equals(Object other) {
        return ArrayTile.equals$(this, other);
    }

    @Override
    public int get(int col, int row) {
        return ArrayTile.get$(this, col, row);
    }

    @Override
    public double getDouble(int col, int row) {
        return ArrayTile.getDouble$(this, col, row);
    }

    @Override
    public List<Object> toList() {
        return ArrayTile.toList$(this);
    }

    @Override
    public List<Object> toListDouble() {
        return ArrayTile.toListDouble$(this);
    }

    @Override
    public int[] toArray() {
        return ArrayTile.toArray$(this);
    }

    @Override
    public double[] toArrayDouble() {
        return ArrayTile.toArrayDouble$(this);
    }

    @Override
    public void dualForeach(Function1<Object, BoxedUnit> f, Function1<Object, BoxedUnit> g) {
        Tile.dualForeach$(this, f, g);
    }

    @Override
    public Tile mapIfSet(Function1<Object, Object> f) {
        return Tile.mapIfSet$(this, f);
    }

    @Override
    public Tile mapIfSetDouble(Function1<Object, Object> f) {
        return Tile.mapIfSetDouble$(this, f);
    }

    @Override
    public Tile dualMap(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile.dualMap$(this, f, g);
    }

    @Override
    public Tile dualMapIfSet(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile.dualMapIfSet$(this, f, g);
    }

    @Override
    public Tile dualCombine(Tile r2, Function2<Object, Object, Object> f, Function2<Object, Object, Object> g) {
        return Tile.dualCombine$(this, r2, f, g);
    }

    @Override
    public boolean isNoDataTile() {
        return Tile.isNoDataTile$(this);
    }

    @Override
    public Tile normalize(int oldMin, int oldMax, int newMin, int newMax) {
        return Tile.normalize$((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile normalize(double oldMin, double oldMax, double newMin, double newMax) {
        return Tile.normalize$((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile rescale(int newMin, int newMax) {
        return Tile.rescale$((Tile)this, newMin, newMax);
    }

    @Override
    public Tile rescale(double newMin, double newMax) {
        return Tile.rescale$((Tile)this, newMin, newMax);
    }

    @Override
    public Tile downsample(int newCols, int newRows, Function1<CellSet, Object> f) {
        return Tile.downsample$(this, newCols, newRows, f);
    }

    @Override
    public Tuple2<Object, Object> findMinMax() {
        return Tile.findMinMax$(this);
    }

    @Override
    public Tuple2<Object, Object> findMinMaxDouble() {
        return Tile.findMinMaxDouble$(this);
    }

    @Override
    public int size() {
        return Grid.size$(this);
    }

    @Override
    public Tuple2<Object, Object> dimensions() {
        return Grid.dimensions$(this);
    }

    @Override
    public GridBounds gridBounds() {
        return Grid.gridBounds$(this);
    }

    private Logger logger$lzycompute() {
        FloatArrayTile floatArrayTile = this;
        synchronized (floatArrayTile) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public float[] array() {
        return this.array;
    }

    public abstract FloatCells cellType();

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] toBytes() {
        void var1_1;
        byte[] pixels = new byte[new ArrayOps.ofFloat(Predef$.MODULE$.floatArrayOps(this.array())).size() * ((DataType)((Object)this.cellType())).bytes()];
        ByteBuffer bytebuff = ByteBuffer.wrap(pixels);
        bytebuff.asFloatBuffer().put(this.array());
        return var1_1;
    }

    @Override
    public ArrayTile copy() {
        return ArrayTile$.MODULE$.apply((float[])this.array().clone(), this.cols, this.rows);
    }

    @Override
    public FloatArrayTile withNoData(Option<Object> noDataValue) {
        return FloatArrayTile$.MODULE$.apply(this.array(), this.cols, this.rows, this.cellType().withNoData(noDataValue));
    }

    @Override
    public Tile interpretAs(DataType newCellType) {
        ArrayTile arrayTile;
        DataType dataType = newCellType;
        if (dataType instanceof FloatCells) {
            FloatCells floatCells = (FloatCells)((Object)dataType);
            arrayTile = FloatArrayTile$.MODULE$.apply(this.array(), this.cols, this.rows, floatCells);
        } else {
            arrayTile = ((FloatArrayTile)this.withNoData((Option)None$.MODULE$)).convert(newCellType);
        }
        return arrayTile;
    }

    public FloatArrayTile(float[] array, int cols, int rows) {
        this.array = array;
        this.cols = cols;
        this.rows = rows;
        Grid.$init$(this);
        IterableTile.$init$(this);
        MappableTile.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        Tile.$init$(this);
        ArrayTile.$init$(this);
        MutableArrayTile.$init$(this);
    }
}

