/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import geotrellis.raster.CellSize;
import geotrellis.raster.GeoAttrsError;
import geotrellis.raster.GridBounds;
import geotrellis.raster.GridExtent$;
import geotrellis.raster.RasterExtent;
import geotrellis.vector.Extent;
import scala.Option;
import scala.Serializable;
import scala.Tuple3;
import scala.math.package$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001B\u0001\u0003\u0001\u001d\u0011!b\u0012:jI\u0016CH/\u001a8u\u0015\t\u0019A!\u0001\u0004sCN$XM\u001d\u0006\u0002\u000b\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\tIq\"\u0003\u0002\u0011\u0015\ta1+\u001a:jC2L'0\u00192mK\"A!\u0003\u0001BC\u0002\u0013\u00051#\u0001\u0004fqR,g\u000e^\u000b\u0002)A\u0011Q\u0003G\u0007\u0002-)\u0011q\u0003B\u0001\u0007m\u0016\u001cGo\u001c:\n\u0005e1\"AB#yi\u0016tG\u000f\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u0015\u0003\u001d)\u0007\u0010^3oi\u0002B\u0001\"\b\u0001\u0003\u0006\u0004%\tAH\u0001\nG\u0016dGn^5ei\",\u0012a\b\t\u0003\u0013\u0001J!!\t\u0006\u0003\r\u0011{WO\u00197f\u0011!\u0019\u0003A!A!\u0002\u0013y\u0012AC2fY2<\u0018\u000e\u001a;iA!AQ\u0005\u0001BC\u0002\u0013\u0005a$\u0001\u0006dK2d\u0007.Z5hQRD\u0001b\n\u0001\u0003\u0002\u0003\u0006IaH\u0001\fG\u0016dG\u000e[3jO\"$\b\u0005C\u0003*\u0001\u0011\u0005!&\u0001\u0004=S:LGO\u0010\u000b\u0005W5rs\u0006\u0005\u0002-\u00015\t!\u0001C\u0003\u0013Q\u0001\u0007A\u0003C\u0003\u001eQ\u0001\u0007q\u0004C\u0003&Q\u0001\u0007q\u0004C\u0003*\u0001\u0011\u0005\u0011\u0007F\u0002,eMBQA\u0005\u0019A\u0002QAQ\u0001\u000e\u0019A\u0002U\n\u0001bY3mYNK'0\u001a\t\u0003YYJ!a\u000e\u0002\u0003\u0011\r+G\u000e\\*ju\u0016DQ\u0001\u000e\u0001\u0005\u0002e*\u0012!\u000e\u0005\u0006w\u0001!\t\u0001P\u0001\u000fi>\u0014\u0016m\u001d;fe\u0016CH/\u001a8u)\u0005i\u0004C\u0001\u0017?\u0013\ty$A\u0001\u0007SCN$XM]#yi\u0016tG\u000fC\u0003B\u0001\u0011\u0005!)A\fde\u0016\fG/Z!mS\u001etW\rZ$sS\u0012,\u0005\u0010^3oiR\u00111f\u0011\u0005\u0006\t\u0002\u0003\r\u0001F\u0001\ri\u0006\u0014x-\u001a;FqR,g\u000e\u001e\u0005\u0006\r\u0002!\taR\u0001\u0015SN<%/\u001b3FqR,g\u000e^!mY&<g.\u001a3\u0015\u0003!\u0003\"!C%\n\u0005)S!a\u0002\"p_2,\u0017M\u001c\u0005\u0006\u0019\u0002!\t!T\u0001\u001aGJ,\u0017\r^3BY&<g.\u001a3SCN$XM]#yi\u0016tG\u000f\u0006\u0002>\u001d\")Ai\u0013a\u0001)!)\u0001\u000b\u0001C\u0001#\u0006IQ\r\u001f;f]R4uN\u001d\u000b\u0004)I;\u0006\"B*P\u0001\u0004!\u0016AC4sS\u0012\u0014u.\u001e8egB\u0011A&V\u0005\u0003-\n\u0011!b\u0012:jI\n{WO\u001c3t\u0011\u001dAv\n%AA\u0002!\u000bQa\u00197b[BDQA\u0017\u0001\u0005Bm\u000ba!Z9vC2\u001cHC\u0001%]\u0011\u0015i\u0016\f1\u0001_\u0003\u0005y\u0007CA\u0005`\u0013\t\u0001'BA\u0002B]fDQA\u0019\u0001\u0005B\r\f\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002IB\u0011\u0011\"Z\u0005\u0003M*\u00111!\u00138u\u0011\u0015A\u0007\u0001\"\u0011j\u0003!!xn\u0015;sS:<G#\u00016\u0011\u0005-\u0014hB\u00017q!\ti'\"D\u0001o\u0015\tyg!\u0001\u0004=e>|GOP\u0005\u0003c*\ta\u0001\u0015:fI\u00164\u0017BA:u\u0005\u0019\u0019FO]5oO*\u0011\u0011O\u0003\u0005\bm\u0002\t\n\u0011\"\u0001x\u0003M)\u0007\u0010^3oi\u001a{'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\u0005A(F\u0001%zW\u0005Q\bcA>\u0002\u00025\tAP\u0003\u0002~}\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003\u007f*\t!\"\u00198o_R\fG/[8o\u0013\r\t\u0019\u0001 \u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,waBA\u0004\u0005!\u0005\u0011\u0011B\u0001\u000b\u000fJLG-\u0012=uK:$\bc\u0001\u0017\u0002\f\u00191\u0011A\u0001E\u0001\u0003\u001b\u0019B!a\u0003\t\u001d!9\u0011&a\u0003\u0005\u0002\u0005EACAA\u0005\u0011!\t)\"a\u0003\u0005\u0002\u0005]\u0011!B1qa2LH#B\u0016\u0002\u001a\u0005m\u0001B\u0002\n\u0002\u0014\u0001\u0007A\u0003\u0003\u00045\u0003'\u0001\r!\u000e\u0005\t\u0003+\tY\u0001\"\u0001\u0002 Q91&!\t\u0002$\u0005\u0015\u0002B\u0002\n\u0002\u001e\u0001\u0007A\u0003\u0003\u0004\u001e\u0003;\u0001\ra\b\u0005\u0007K\u0005u\u0001\u0019A\u0010\t\u0011\u0005%\u00121\u0002C\u0001\u0003W\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002.\u0005e\u0002#B\u0005\u00020\u0005M\u0012bAA\u0019\u0015\t1q\n\u001d;j_:\u0004b!CA\u001b)}y\u0012bAA\u001c\u0015\t1A+\u001e9mKNBq!a\u000f\u0002(\u0001\u00071&\u0001\u0002hK\"Q\u0011qHA\u0006\u0003\u0003%I!!\u0011\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u0007\u0002B!!\u0012\u0002P5\u0011\u0011q\t\u0006\u0005\u0003\u0013\nY%\u0001\u0003mC:<'BAA'\u0003\u0011Q\u0017M^1\n\t\u0005E\u0013q\t\u0002\u0007\u001f\nTWm\u0019;")
public class GridExtent
implements Serializable {
    private final Extent extent;
    private final double cellwidth;
    private final double cellheight;

    public static Option<Tuple3<Extent, Object, Object>> unapply(GridExtent gridExtent) {
        return GridExtent$.MODULE$.unapply(gridExtent);
    }

    public static GridExtent apply(Extent extent, double d, double d2) {
        return GridExtent$.MODULE$.apply(extent, d, d2);
    }

    public static GridExtent apply(Extent extent, CellSize cellSize) {
        return GridExtent$.MODULE$.apply(extent, cellSize);
    }

    public Extent extent() {
        return this.extent;
    }

    public double cellwidth() {
        return this.cellwidth;
    }

    public double cellheight() {
        return this.cellheight;
    }

    public CellSize cellSize() {
        return new CellSize(this.cellwidth(), this.cellheight());
    }

    public RasterExtent toRasterExtent() {
        long targetCols = package$.MODULE$.max(1L, package$.MODULE$.round(this.extent().width() / this.cellwidth()));
        long targetRows = package$.MODULE$.max(1L, package$.MODULE$.round(this.extent().height() / this.cellheight()));
        if (targetCols > Integer.MAX_VALUE) {
            throw new GeoAttrsError(new StringBuilder(100).append("Cannot convert GridExtent into a RasterExtent: number of columns exceeds maximum integer value (").append(targetCols).append(" > ").append(Integer.MAX_VALUE).append(")").toString());
        }
        if (targetRows > Integer.MAX_VALUE) {
            throw new GeoAttrsError(new StringBuilder(97).append("Cannot convert GridExtent into a RasterExtent: number of rows exceeds maximum integer value (").append(targetRows).append(" > ").append(Integer.MAX_VALUE).append(")").toString());
        }
        return new RasterExtent(this.extent(), this.cellwidth(), this.cellheight(), (int)targetCols, (int)targetRows);
    }

    public GridExtent createAlignedGridExtent(Extent targetExtent) {
        double xmin = this.extent().xmin() + package$.MODULE$.floor((targetExtent.xmin() - this.extent().xmin()) / this.cellwidth()) * this.cellwidth();
        double xmax = this.extent().xmax() - package$.MODULE$.floor((this.extent().xmax() - targetExtent.xmax()) / this.cellwidth()) * this.cellwidth();
        double ymin = this.extent().ymin() + package$.MODULE$.floor((targetExtent.ymin() - this.extent().ymin()) / this.cellheight()) * this.cellheight();
        double ymax = this.extent().ymax() - package$.MODULE$.floor((this.extent().ymax() - targetExtent.ymax()) / this.cellheight()) * this.cellheight();
        return GridExtent$.MODULE$.apply(new Extent(xmin, ymin, xmax, ymax), this.cellwidth(), this.cellheight());
    }

    public boolean isGridExtentAlligned() {
        return GridExtent.isWhole$1((this.extent().xmax() - this.extent().xmin()) / this.cellwidth()) && GridExtent.isWhole$1((this.extent().ymax() - this.extent().ymin()) / this.cellheight());
    }

    public RasterExtent createAlignedRasterExtent(Extent targetExtent) {
        return this.createAlignedGridExtent(targetExtent).toRasterExtent();
    }

    public Extent extentFor(GridBounds gridBounds, boolean clamp) {
        double xmin = (double)gridBounds.colMin() * this.cellwidth() + this.extent().xmin();
        double ymax = this.extent().ymax() - (double)gridBounds.rowMin() * this.cellheight();
        double xmax = xmin + (double)gridBounds.width() * this.cellwidth();
        double ymin = ymax - (double)gridBounds.height() * this.cellheight();
        return clamp ? new Extent(package$.MODULE$.max(package$.MODULE$.min(xmin, this.extent().xmax()), this.extent().xmin()), package$.MODULE$.max(package$.MODULE$.min(ymin, this.extent().ymax()), this.extent().ymin()), package$.MODULE$.max(package$.MODULE$.min(xmax, this.extent().xmax()), this.extent().xmin()), package$.MODULE$.max(package$.MODULE$.min(ymax, this.extent().ymax()), this.extent().ymin())) : new Extent(xmin, ymin, xmax, ymax);
    }

    public boolean extentFor$default$2() {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        Object object = o;
        if (!(object instanceof GridExtent)) return false;
        GridExtent gridExtent = (GridExtent)object;
        Extent extent = gridExtent.extent();
        Extent extent2 = this.extent();
        if (extent == null) {
            if (extent2 != null) {
                return false;
            }
        } else if (!extent.equals(extent2)) return false;
        if (gridExtent.cellheight() != this.cellheight()) return false;
        if (gridExtent.cellwidth() != this.cellwidth()) return false;
        return true;
    }

    public int hashCode() {
        return ((31 + (this.extent() == null ? 0 : this.extent().hashCode())) * 31 + (int)this.cellheight()) * 31 + (int)this.cellwidth();
    }

    public String toString() {
        return new StringBuilder(14).append("GridExtent(").append(this.extent()).append(",").append(this.cellwidth()).append(",").append(this.cellheight()).append(")").toString();
    }

    private static final boolean isWhole$1(double x) {
        return package$.MODULE$.floor(x) == x;
    }

    public GridExtent(Extent extent, double cellwidth, double cellheight) {
        this.extent = extent;
        this.cellwidth = cellwidth;
        this.cellheight = cellheight;
    }

    public GridExtent(Extent extent, CellSize cellSize) {
        this(extent, cellSize.width(), cellSize.height());
    }
}

