/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.CellSet;
import geotrellis.raster.ConstantNoData;
import geotrellis.raster.ConstantTile;
import geotrellis.raster.DataType;
import geotrellis.raster.Grid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.IntArrayTile$;
import geotrellis.raster.IntCells;
import geotrellis.raster.IntConstantTile$;
import geotrellis.raster.IntUserDefinedNoDataCellType;
import geotrellis.raster.IterableTile;
import geotrellis.raster.MappableTile;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.NoNoData;
import geotrellis.raster.Tile;
import java.nio.ByteBuffer;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\t\u0005a\u0001B\u0001\u0003\u0001\u001e\u0011q\"\u00138u\u0007>t7\u000f^1oiRKG.\u001a\u0006\u0003\u0007\u0011\taA]1ti\u0016\u0014(\"A\u0003\u0002\u0015\u001d,w\u000e\u001e:fY2L7o\u0001\u0001\u0014\u000b\u0001AaBE\u000b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty\u0001#D\u0001\u0003\u0013\t\t\"A\u0001\u0007D_:\u001cH/\u00198u)&dW\r\u0005\u0002\n'%\u0011AC\u0003\u0002\b!J|G-^2u!\tIa#\u0003\u0002\u0018\u0015\ta1+\u001a:jC2L'0\u00192mK\"A\u0011\u0004\u0001BK\u0002\u0013\u0005!$A\u0001w+\u0005Y\u0002CA\u0005\u001d\u0013\ti\"BA\u0002J]RD\u0001b\b\u0001\u0003\u0012\u0003\u0006IaG\u0001\u0003m\u0002B\u0001\"\t\u0001\u0003\u0016\u0004%\tAG\u0001\u0005G>d7\u000f\u0003\u0005$\u0001\tE\t\u0015!\u0003\u001c\u0003\u0015\u0019w\u000e\\:!\u0011!)\u0003A!f\u0001\n\u0003Q\u0012\u0001\u0002:poND\u0001b\n\u0001\u0003\u0012\u0003\u0006IaG\u0001\u0006e><8\u000f\t\u0005\tS\u0001\u0011)\u001a!C\u0001U\u0005A1-\u001a7m)f\u0004X-F\u0001,%\rac&\r\u0004\u0005[\u0001\u00011F\u0001\u0007=e\u00164\u0017N\\3nK:$h\b\u0005\u0002\u0010_%\u0011\u0001G\u0001\u0002\t\u0013:$8)\u001a7mgB\u0011qBM\u0005\u0003g\t\u0011aBT8ECR\f\u0007*\u00198eY&tw\r\u0003\u00056\u0001\tE\t\u0015!\u0003,\u0003%\u0019W\r\u001c7UsB,\u0007\u0005C\u00038\u0001\u0011\u0005\u0001(\u0001\u0004=S:LGO\u0010\u000b\u0006siZD(\u0010\t\u0003\u001f\u0001AQ!\u0007\u001cA\u0002mAQ!\t\u001cA\u0002mAQ!\n\u001cA\u0002mAq!\u000b\u001c\u0011\u0002\u0003\u0007aHE\u0002@]E2A!\f\u0001\u0001}!Q\u0011\t\u0001I\u0001\u0002\u0007\u0005\u000b\u0011\u0002\"\u0002\ta$#'\r\t\u0005\u0013\r[R)\u0003\u0002E\u0015\t1A+\u001e9mKJ\u0002\"!\u0003$\n\u0005\u001dS!A\u0002#pk\ndW\rC\u0004J\u0001\t\u0007I\u0011\u0003\u000e\u0002\t%4\u0016\r\u001c\u0005\u0007\u0017\u0002\u0001\u000b\u0011B\u000e\u0002\u000b%4\u0016\r\u001c\u0011\t\u000f5\u0003!\u0019!C\t\u001d\u0006!AMV1m+\u0005)\u0005B\u0002)\u0001A\u0003%Q)A\u0003e-\u0006d\u0007\u0005C\u0003S\u0001\u0011\u00051+A\u0006u_\u0006\u0013(/Y=US2,G#\u0001+\u0011\u0005=)\u0016B\u0001,\u0003\u0005%\t%O]1z)&dW\rC\u0003Y\u0001\u0011\u0005\u0011,A\u0004nkR\f'\r\\3\u0016\u0003i\u0003\"aD.\n\u0005q\u0013!\u0001E'vi\u0006\u0014G.Z!se\u0006LH+\u001b7f\u0011\u0015q\u0006\u0001\"\u0001`\u0003\u001d!xNQ=uKN$\u0012\u0001\u0019\t\u0004\u0013\u0005\u001c\u0017B\u00012\u000b\u0005\u0015\t%O]1z!\tIA-\u0003\u0002f\u0015\t!!)\u001f;f\u0011\u00159\u0007\u0001\"\u0001i\u0003)9\u0018\u000e\u001e5O_\u0012\u000bG/\u0019\u000b\u0003s%DQA\u001b4A\u0002-\f1B\\8ECR\fg+\u00197vKB\u0019\u0011\u0002\\#\n\u00055T!AB(qi&|g\u000eC\u0003p\u0001\u0011\u0005\u0001/A\u0002nCB$\"!\u001d;\u0011\u0005=\u0011\u0018BA:\u0003\u0005\u0011!\u0016\u000e\\3\t\u000bUt\u0007\u0019\u0001<\u0002\u0003\u0019\u0004B!C<\u001c7%\u0011\u0001P\u0003\u0002\n\rVt7\r^5p]FBQA\u001f\u0001\u0005\u0002m\f\u0011\"\\1q\t>,(\r\\3\u0015\u0005Ed\b\"B;z\u0001\u0004i\b\u0003B\u0005x\u000b\u0016C\u0001b \u0001\u0002\u0002\u0013\u0005\u0011\u0011A\u0001\u0005G>\u0004\u0018\u0010F\u0005:\u0003\u0007\t)!a\u0002\u0002\n!9\u0011D I\u0001\u0002\u0004Y\u0002bB\u0011\u007f!\u0003\u0005\ra\u0007\u0005\bKy\u0004\n\u00111\u0001\u001c\u0011\u001dIc\u0010%AA\u0002yB\u0011\"!\u0004\u0001#\u0003%\t!a\u0004\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\u0003\u0016\u00047\u0005M1FAA\u000b!\u0011\t9\"!\t\u000e\u0005\u0005e!\u0002BA\u000e\u0003;\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005}!\"\u0001\u0006b]:|G/\u0019;j_:LA!a\t\u0002\u001a\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005\u001d\u0002!%A\u0005\u0002\u0005=\u0011AD2paf$C-\u001a4bk2$HE\r\u0005\n\u0003W\u0001\u0011\u0013!C\u0001\u0003\u001f\tabY8qs\u0012\"WMZ1vYR$3\u0007C\u0005\u00020\u0001\t\n\u0011\"\u0001\u00022\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\"TCAA\u001aU\rY\u00131\u0003\u0005\n\u0003o\u0001\u0011\u0011!C!\u0003s\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u001e!\u0011\ti$a\u0012\u000e\u0005\u0005}\"\u0002BA!\u0003\u0007\nA\u0001\\1oO*\u0011\u0011QI\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002J\u0005}\"AB*ue&tw\r\u0003\u0005\u0002N\u0001\t\t\u0011\"\u0001\u001b\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u0011%\t\t\u0006AA\u0001\n\u0003\t\u0019&\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005U\u00131\f\t\u0004\u0013\u0005]\u0013bAA-\u0015\t\u0019\u0011I\\=\t\u0013\u0005u\u0013qJA\u0001\u0002\u0004Y\u0012a\u0001=%c!I\u0011\u0011\r\u0001\u0002\u0002\u0013\u0005\u00131M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011Q\r\t\u0007\u0003O\ni'!\u0016\u000e\u0005\u0005%$bAA6\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005=\u0014\u0011\u000e\u0002\t\u0013R,'/\u0019;pe\"I\u00111\u000f\u0001\u0002\u0002\u0013\u0005\u0011QO\u0001\tG\u0006tW)];bYR!\u0011qOA?!\rI\u0011\u0011P\u0005\u0004\u0003wR!a\u0002\"p_2,\u0017M\u001c\u0005\u000b\u0003;\n\t(!AA\u0002\u0005U\u0003\"CAA\u0001\u0005\u0005I\u0011IAB\u0003!A\u0017m\u001d5D_\u0012,G#A\u000e\t\u0013\u0005\u001d\u0005!!A\u0005B\u0005%\u0015\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005m\u0002\"CAG\u0001\u0005\u0005I\u0011IAH\u0003\u0019)\u0017/^1mgR!\u0011qOAI\u0011)\ti&a#\u0002\u0002\u0003\u0007\u0011QK\u0004\b\u0003+\u0013\u0001\u0012AAL\u0003=Ie\u000e^\"p]N$\u0018M\u001c;US2,\u0007cA\b\u0002\u001a\u001a1\u0011A\u0001E\u0001\u00037\u001bB!!'\t+!9q'!'\u0005\u0002\u0005}ECAAL\u0011!\t\u0019+!'\u0005\u0002\u0005\u0015\u0016!\u00034s_6\u0014\u0015\u0010^3t)%I\u0014qUAV\u0003[\u000by\u000bC\u0004\u0002*\u0006\u0005\u0006\u0019\u00011\u0002\u000b\tLH/Z:\t\r\u0005\n\t\u000b1\u0001\u001c\u0011\u0019)\u0013\u0011\u0015a\u00017!9\u0011&!)A\u0002\u0005E&\u0003BAZ]E2a!LAM\u0001\u0005E\u0006BCA\\\u00033\u000b\t\u0011\"!\u0002:\u0006)\u0011\r\u001d9msRI\u0011(a/\u0002>\u0006}\u0016\u0011\u0019\u0005\u00073\u0005U\u0006\u0019A\u000e\t\r\u0005\n)\f1\u0001\u001c\u0011\u0019)\u0013Q\u0017a\u00017!I\u0011&!.\u0011\u0002\u0003\u0007\u00111\u0019\n\u0005\u0003\u000bt\u0013G\u0002\u0004.\u00033\u0003\u00111\u0019\u0005\u000b\u0003\u0013\fI*!A\u0005\u0002\u0006-\u0017aB;oCB\u0004H.\u001f\u000b\u0005\u0003\u001b\fI\u000e\u0005\u0003\nY\u0006=\u0007\u0003C\u0005\u0002RnY2$!6\n\u0007\u0005M'B\u0001\u0004UkBdW\r\u000e\n\u0005\u0003/t\u0013G\u0002\u0004.\u00033\u0003\u0011Q\u001b\u0005\n\u00037\f9-!AA\u0002e\n1\u0001\u001f\u00131\u0011)\ty.!'\u0012\u0002\u0013\u0005\u0011\u0011]\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u00111\u001d\u0016\u0005\u0003K\f\u0019B\u0005\u0003\u0002h:\ndAB\u0017\u0002\u001a\u0002\t)\u000f\u0003\u0006\u0002l\u0006e\u0015\u0013!C\u0001\u0003[\f1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"TCAAxU\u0011\t\t0a\u0005\u0013\t\u0005Mh&\r\u0004\u0007[\u0005e\u0005!!=\t\u0015\u0005]\u0018\u0011TA\u0001\n\u0013\tI0A\u0006sK\u0006$'+Z:pYZ,GCAA~!\u0011\ti$!@\n\t\u0005}\u0018q\b\u0002\u0007\u001f\nTWm\u0019;")
public class IntConstantTile
implements ConstantTile,
Product {
    private final int v;
    private final int cols;
    private final int rows;
    private final IntCells cellType;
    private final /* synthetic */ Tuple2 x$21;
    private final int iVal;
    private final double dVal;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static IntCells $lessinit$greater$default$4() {
        return IntConstantTile$.MODULE$.$lessinit$greater$default$4();
    }

    public static IntCells apply$default$4() {
        return IntConstantTile$.MODULE$.apply$default$4();
    }

    public static Option<Tuple4<Object, Object, Object, IntCells>> unapply(IntConstantTile intConstantTile) {
        return IntConstantTile$.MODULE$.unapply(intConstantTile);
    }

    public static IntConstantTile apply(int n, int n2, int n3, IntCells intCells) {
        return IntConstantTile$.MODULE$.apply(n, n2, n3, intCells);
    }

    public static IntConstantTile fromBytes(byte[] byArray, int n, int n2, IntCells intCells) {
        return IntConstantTile$.MODULE$.fromBytes(byArray, n, n2, intCells);
    }

    @Override
    public int get(int col, int row) {
        return ConstantTile.get$(this, col, row);
    }

    @Override
    public double getDouble(int col, int row) {
        return ConstantTile.getDouble$(this, col, row);
    }

    @Override
    public int[] toArray() {
        return ConstantTile.toArray$(this);
    }

    @Override
    public double[] toArrayDouble() {
        return ConstantTile.toArrayDouble$(this);
    }

    @Override
    public Tile convert(DataType newType) {
        return ConstantTile.convert$(this, newType);
    }

    @Override
    public Tile interpretAs(DataType newCellType) {
        return ConstantTile.interpretAs$(this, newCellType);
    }

    @Override
    public void foreach(Function1<Object, BoxedUnit> f) {
        ConstantTile.foreach$(this, f);
    }

    @Override
    public void foreachDouble(Function1<Object, BoxedUnit> f) {
        ConstantTile.foreachDouble$(this, f);
    }

    @Override
    public void foreachIntVisitor(IntTileVisitor visitor) {
        ConstantTile.foreachIntVisitor$(this, visitor);
    }

    @Override
    public void foreachDoubleVisitor(DoubleTileVisitor visitor) {
        ConstantTile.foreachDoubleVisitor$(this, visitor);
    }

    @Override
    public Tile combine(Tile other, Function2<Object, Object, Object> f) {
        return ConstantTile.combine$(this, other, f);
    }

    @Override
    public Tile combineDouble(Tile other, Function2<Object, Object, Object> f) {
        return ConstantTile.combineDouble$(this, other, f);
    }

    @Override
    public Tile mapIntMapper(IntTileMapper mapper) {
        return ConstantTile.mapIntMapper$(this, mapper);
    }

    @Override
    public Tile mapDoubleMapper(DoubleTileMapper mapper) {
        return ConstantTile.mapDoubleMapper$(this, mapper);
    }

    @Override
    public void dualForeach(Function1<Object, BoxedUnit> f, Function1<Object, BoxedUnit> g) {
        Tile.dualForeach$(this, f, g);
    }

    @Override
    public Tile mapIfSet(Function1<Object, Object> f) {
        return Tile.mapIfSet$(this, f);
    }

    @Override
    public Tile mapIfSetDouble(Function1<Object, Object> f) {
        return Tile.mapIfSetDouble$(this, f);
    }

    @Override
    public Tile dualMap(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile.dualMap$(this, f, g);
    }

    @Override
    public Tile dualMapIfSet(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile.dualMapIfSet$(this, f, g);
    }

    @Override
    public Tile dualCombine(Tile r2, Function2<Object, Object, Object> f, Function2<Object, Object, Object> g) {
        return Tile.dualCombine$(this, r2, f, g);
    }

    @Override
    public boolean isNoDataTile() {
        return Tile.isNoDataTile$(this);
    }

    @Override
    public Tile normalize(int oldMin, int oldMax, int newMin, int newMax) {
        return Tile.normalize$((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile normalize(double oldMin, double oldMax, double newMin, double newMax) {
        return Tile.normalize$((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile rescale(int newMin, int newMax) {
        return Tile.rescale$((Tile)this, newMin, newMax);
    }

    @Override
    public Tile rescale(double newMin, double newMax) {
        return Tile.rescale$((Tile)this, newMin, newMax);
    }

    @Override
    public Tile downsample(int newCols, int newRows, Function1<CellSet, Object> f) {
        return Tile.downsample$(this, newCols, newRows, f);
    }

    @Override
    public Tuple2<Object, Object> findMinMax() {
        return Tile.findMinMax$(this);
    }

    @Override
    public Tuple2<Object, Object> findMinMaxDouble() {
        return Tile.findMinMaxDouble$(this);
    }

    @Override
    public int size() {
        return Grid.size$(this);
    }

    @Override
    public Tuple2<Object, Object> dimensions() {
        return Grid.dimensions$(this);
    }

    @Override
    public GridBounds gridBounds() {
        return Grid.gridBounds$(this);
    }

    private Logger logger$lzycompute() {
        IntConstantTile intConstantTile = this;
        synchronized (intConstantTile) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public int v() {
        return this.v;
    }

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    public IntCells cellType() {
        return this.cellType;
    }

    @Override
    public int iVal() {
        return this.iVal;
    }

    @Override
    public double dVal() {
        return this.dVal;
    }

    @Override
    public ArrayTile toArrayTile() {
        return this.mutable();
    }

    @Override
    public MutableArrayTile mutable() {
        return IntArrayTile$.MODULE$.fill(this.v(), this.cols(), this.rows(), this.cellType());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] toBytes() {
        void var1_1;
        byte[] arr = (byte[])Array$.MODULE$.ofDim(((DataType)((Object)this.cellType())).bytes(), ClassTag$.MODULE$.Byte());
        ByteBuffer.wrap(arr).asIntBuffer().put(this.v());
        return var1_1;
    }

    @Override
    public IntConstantTile withNoData(Option<Object> noDataValue) {
        return new IntConstantTile(this.v(), this.cols(), this.rows(), this.cellType().withNoData(noDataValue));
    }

    @Override
    public Tile map(Function1<Object, Object> f) {
        return new IntConstantTile(f.apply$mcII$sp(this.iVal()), this.cols(), this.rows(), this.cellType());
    }

    @Override
    public Tile mapDouble(Function1<Object, Object> f) {
        double n = f.apply$mcDD$sp(this.dVal());
        return new IntConstantTile(Double.isNaN(n) ? Integer.MIN_VALUE : (int)n, this.cols(), this.rows(), IntConstantTile$.MODULE$.apply$default$4());
    }

    public IntConstantTile copy(int v, int cols, int rows, IntCells cellType) {
        return new IntConstantTile(v, cols, rows, cellType);
    }

    public int copy$default$1() {
        return this.v();
    }

    public int copy$default$2() {
        return this.cols();
    }

    public int copy$default$3() {
        return this.rows();
    }

    public IntCells copy$default$4() {
        return this.cellType();
    }

    public String productPrefix() {
        return "IntConstantTile";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = BoxesRunTime.boxToInteger((int)this.v());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this.cols());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this.rows());
                break;
            }
            case 3: {
                object = this.cellType();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof IntConstantTile;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.v());
        n = Statics.mix((int)n, (int)this.cols());
        n = Statics.mix((int)n, (int)this.rows());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.cellType()));
        return Statics.finalizeHash((int)n, (int)4);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof IntConstantTile)) return false;
        boolean bl = true;
        if (!bl) return false;
        IntConstantTile intConstantTile = (IntConstantTile)x$1;
        if (this.v() != intConstantTile.v()) return false;
        if (this.cols() != intConstantTile.cols()) return false;
        if (this.rows() != intConstantTile.rows()) return false;
        IntCells intCells = this.cellType();
        IntCells intCells2 = intConstantTile.cellType();
        if (intCells == null) {
            if (intCells2 != null) {
                return false;
            }
        } else if (!intCells.equals(intCells2)) return false;
        if (!intConstantTile.canEqual(this)) return false;
        return true;
    }

    public IntConstantTile(int v, int cols, int rows, IntCells cellType) {
        Tuple2.mcID.sp sp2;
        this.v = v;
        this.cols = cols;
        this.rows = rows;
        this.cellType = cellType;
        Grid.$init$(this);
        IterableTile.$init$(this);
        MappableTile.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        Tile.$init$(this);
        ConstantTile.$init$(this);
        Product.$init$((Product)this);
        IntCells intCells = cellType;
        if (intCells instanceof ConstantNoData) {
            int n = v;
            sp2 = new Tuple2.mcID.sp(v, n == Integer.MIN_VALUE ? Double.NaN : (double)n);
        } else if (intCells instanceof NoNoData) {
            sp2 = new Tuple2.mcID.sp(v, (double)v);
        } else if (intCells instanceof IntUserDefinedNoDataCellType) {
            IntUserDefinedNoDataCellType intUserDefinedNoDataCellType = (IntUserDefinedNoDataCellType)intCells;
            sp2 = intUserDefinedNoDataCellType.noDataValue() == v ? new Tuple2.mcID.sp(Integer.MIN_VALUE, Double.NaN) : new Tuple2.mcID.sp(v, (double)v);
        } else {
            throw new MatchError((Object)intCells);
        }
        Tuple2.mcID.sp sp3 = sp2;
        if (sp3 == null) {
            throw new MatchError((Object)sp3);
        }
        int iVal = sp3._1$mcI$sp();
        double dVal = sp3._2$mcD$sp();
        int n = iVal;
        double d = dVal;
        Tuple2.mcID.sp sp4 = new Tuple2.mcID.sp(n, d);
        this.x$21 = sp4;
        this.iVal = this.x$21._1$mcI$sp();
        this.dVal = this.x$21._2$mcD$sp();
    }
}

