/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.CellSet;
import geotrellis.raster.DataType;
import geotrellis.raster.Grid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.IterableTile;
import geotrellis.raster.MappableTile;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.PixelInterleaveBandArrayTile$;
import geotrellis.raster.Tile;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001Y<Q!\u0001\u0002\t\u0002\u001d\tA\u0004U5yK2Le\u000e^3sY\u0016\fg/\u001a\"b]\u0012\f%O]1z)&dWM\u0003\u0002\u0004\t\u00051!/Y:uKJT\u0011!B\u0001\u000bO\u0016|GO]3mY&\u001c8\u0001\u0001\t\u0003\u0011%i\u0011A\u0001\u0004\u0006\u0015\tA\ta\u0003\u0002\u001d!&DX\r\\%oi\u0016\u0014H.Z1wK\n\u000bg\u000eZ!se\u0006LH+\u001b7f'\rIAB\u0005\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u00055\u0019\u0012B\u0001\u000b\u000f\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u00151\u0012\u0002\"\u0001\u0018\u0003\u0019a\u0014N\\5u}Q\tq\u0001C\u0003\u001a\u0013\u0011\u0005!$A\u0003baBd\u0017\u0010\u0006\u0003\u001cQ&T\u0007C\u0001\u0005\u001d\r\u0011Q!\u0001A\u000f\u0014\u0007qaa\u0004\u0005\u0002\t?%\u0011\u0001E\u0001\u0002\n\u0003J\u0014\u0018-\u001f+jY\u0016D\u0001B\t\u000f\u0003\u0002\u0003\u0006IAH\u0001\u0006S:tWM\u001d\u0005\tIq\u0011\t\u0011)A\u0005K\u0005I!-\u00198e\u0007>,h\u000e\u001e\t\u0003\u001b\u0019J!a\n\b\u0003\u0007%sG\u000f\u0003\u0005*9\t\u0005\t\u0015!\u0003&\u0003%\u0011\u0017M\u001c3J]\u0012,\u0007\u0010C\u0003\u00179\u0011\u00051\u0006\u0006\u0003\u001cY5r\u0003\"\u0002\u0012+\u0001\u0004q\u0002\"\u0002\u0013+\u0001\u0004)\u0003\"B\u0015+\u0001\u0004)\u0003\"\u0002\u0019\u001d\t\u0003\t\u0014\u0001C2fY2$\u0016\u0010]3\u0016\u0003I\u0002\"a\r\u001c\u000f\u0005!!\u0014BA\u001b\u0003\u0003\u001d\u0001\u0018mY6bO\u0016L!a\u000e\u001d\u0003\u0011\r+G\u000e\u001c+za\u0016T!!\u000e\u0002\t\u000bibB\u0011A\u001e\u0002\t\r|Gn]\u000b\u0002K!)Q\b\bC\u0001w\u0005!!o\\<t\u0011\u0015IB\u0004\"\u0001@)\t)\u0003\tC\u0003B}\u0001\u0007Q%A\u0001j\u0011\u0015\u0019E\u0004\"\u0001E\u0003-\t\u0007\u000f\u001d7z\t>,(\r\\3\u0015\u0005\u0015C\u0005CA\u0007G\u0013\t9eB\u0001\u0004E_V\u0014G.\u001a\u0005\u0006\u0003\n\u0003\r!\n\u0005\u0006\u0015r!\taS\u0001\u0005G>\u0004\u00180F\u0001\u001f\u0011\u0015iE\u0004\"\u0001O\u0003\u001d!xNQ=uKN$\u0012a\u0014\t\u0004\u001bA\u0013\u0016BA)\u000f\u0005\u0015\t%O]1z!\ti1+\u0003\u0002U\u001d\t!!)\u001f;f\u0011\u00151F\u0004\"\u0001X\u0003\u001diW\u000f^1cY\u0016,\u0012\u0001\u0017\t\u0003\u0011eK!A\u0017\u0002\u0003!5+H/\u00192mK\u0006\u0013(/Y=US2,\u0007\"\u0002/\u001d\t\u0003i\u0016AC<ji\"tu\u000eR1uCR\u00111D\u0018\u0005\u0006?n\u0003\r\u0001Y\u0001\f]>$\u0015\r^1WC2,X\rE\u0002\u000eC\u0016K!A\u0019\b\u0003\r=\u0003H/[8o\u0011\u0015!G\u0004\"\u0001f\u0003-Ig\u000e^3saJ,G/Q:\u0015\u0005m1\u0007\"B4d\u0001\u0004\u0011\u0014a\u00038fo\u000e+G\u000e\u001c+za\u0016DQA\t\rA\u0002yAQ\u0001\n\rA\u0002\u0015BQ!\u000b\rA\u0002\u0015Bq\u0001\\\u0005\u0002\u0002\u0013%Q.A\u0006sK\u0006$'+Z:pYZ,G#\u00018\u0011\u0005=$X\"\u00019\u000b\u0005E\u0014\u0018\u0001\u00027b]\u001eT\u0011a]\u0001\u0005U\u00064\u0018-\u0003\u0002va\n1qJ\u00196fGR\u0004")
public class PixelInterleaveBandArrayTile
implements ArrayTile {
    private final ArrayTile inner;
    private final int bandCount;
    private final int bandIndex;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    @Override
    public ArrayTile toArrayTile() {
        return ArrayTile.toArrayTile$(this);
    }

    @Override
    public ArrayTile convert(DataType targetCellType) {
        return ArrayTile.convert$(this, targetCellType);
    }

    @Override
    public void foreach(Function1<Object, BoxedUnit> f) {
        ArrayTile.foreach$(this, f);
    }

    @Override
    public void foreachDouble(Function1<Object, BoxedUnit> f) {
        ArrayTile.foreachDouble$(this, f);
    }

    @Override
    public void foreachIntVisitor(IntTileVisitor visitor) {
        ArrayTile.foreachIntVisitor$(this, visitor);
    }

    @Override
    public void foreachDoubleVisitor(DoubleTileVisitor visitor) {
        ArrayTile.foreachDoubleVisitor$(this, visitor);
    }

    @Override
    public Tile map(Function1<Object, Object> f) {
        return ArrayTile.map$(this, f);
    }

    @Override
    public Tile mapDouble(Function1<Object, Object> f) {
        return ArrayTile.mapDouble$(this, f);
    }

    @Override
    public Tile mapIntMapper(IntTileMapper mapper) {
        return ArrayTile.mapIntMapper$(this, mapper);
    }

    @Override
    public Tile mapDoubleMapper(DoubleTileMapper mapper) {
        return ArrayTile.mapDoubleMapper$(this, mapper);
    }

    @Override
    public ArrayTile combine(ArrayTile other, Function2<Object, Object, Object> f) {
        return ArrayTile.combine$((ArrayTile)this, other, f);
    }

    @Override
    public Tile combine(Tile other, Function2<Object, Object, Object> f) {
        return ArrayTile.combine$((ArrayTile)this, other, f);
    }

    @Override
    public ArrayTile combineDouble(ArrayTile other, Function2<Object, Object, Object> f) {
        return ArrayTile.combineDouble$((ArrayTile)this, other, f);
    }

    @Override
    public Tile combineDouble(Tile other, Function2<Object, Object, Object> f) {
        return ArrayTile.combineDouble$((ArrayTile)this, other, f);
    }

    @Override
    public boolean equals(Object other) {
        return ArrayTile.equals$(this, other);
    }

    @Override
    public int get(int col, int row) {
        return ArrayTile.get$(this, col, row);
    }

    @Override
    public double getDouble(int col, int row) {
        return ArrayTile.getDouble$(this, col, row);
    }

    @Override
    public List<Object> toList() {
        return ArrayTile.toList$(this);
    }

    @Override
    public List<Object> toListDouble() {
        return ArrayTile.toListDouble$(this);
    }

    @Override
    public int[] toArray() {
        return ArrayTile.toArray$(this);
    }

    @Override
    public double[] toArrayDouble() {
        return ArrayTile.toArrayDouble$(this);
    }

    @Override
    public void dualForeach(Function1<Object, BoxedUnit> f, Function1<Object, BoxedUnit> g) {
        Tile.dualForeach$(this, f, g);
    }

    @Override
    public Tile mapIfSet(Function1<Object, Object> f) {
        return Tile.mapIfSet$(this, f);
    }

    @Override
    public Tile mapIfSetDouble(Function1<Object, Object> f) {
        return Tile.mapIfSetDouble$(this, f);
    }

    @Override
    public Tile dualMap(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile.dualMap$(this, f, g);
    }

    @Override
    public Tile dualMapIfSet(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile.dualMapIfSet$(this, f, g);
    }

    @Override
    public Tile dualCombine(Tile r2, Function2<Object, Object, Object> f, Function2<Object, Object, Object> g) {
        return Tile.dualCombine$(this, r2, f, g);
    }

    @Override
    public boolean isNoDataTile() {
        return Tile.isNoDataTile$(this);
    }

    @Override
    public Tile normalize(int oldMin, int oldMax, int newMin, int newMax) {
        return Tile.normalize$((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile normalize(double oldMin, double oldMax, double newMin, double newMax) {
        return Tile.normalize$((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile rescale(int newMin, int newMax) {
        return Tile.rescale$((Tile)this, newMin, newMax);
    }

    @Override
    public Tile rescale(double newMin, double newMax) {
        return Tile.rescale$((Tile)this, newMin, newMax);
    }

    @Override
    public Tile downsample(int newCols, int newRows, Function1<CellSet, Object> f) {
        return Tile.downsample$(this, newCols, newRows, f);
    }

    @Override
    public Tuple2<Object, Object> findMinMax() {
        return Tile.findMinMax$(this);
    }

    @Override
    public Tuple2<Object, Object> findMinMaxDouble() {
        return Tile.findMinMaxDouble$(this);
    }

    @Override
    public int size() {
        return Grid.size$(this);
    }

    @Override
    public Tuple2<Object, Object> dimensions() {
        return Grid.dimensions$(this);
    }

    @Override
    public GridBounds gridBounds() {
        return Grid.gridBounds$(this);
    }

    private Logger logger$lzycompute() {
        PixelInterleaveBandArrayTile pixelInterleaveBandArrayTile = this;
        synchronized (pixelInterleaveBandArrayTile) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public DataType cellType() {
        return this.inner.cellType();
    }

    @Override
    public int cols() {
        return this.inner.cols() / this.bandCount;
    }

    @Override
    public int rows() {
        return this.inner.rows();
    }

    @Override
    public int apply(int i) {
        return this.inner.apply(i * this.bandCount + this.bandIndex);
    }

    @Override
    public double applyDouble(int i) {
        return this.inner.applyDouble(i * this.bandCount + this.bandIndex);
    }

    @Override
    public ArrayTile copy() {
        return this.mutable();
    }

    @Override
    public byte[] toBytes() {
        return this.mutable().toBytes();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MutableArrayTile mutable() {
        void var1_1;
        MutableArrayTile tile = ArrayTile$.MODULE$.alloc(this.cellType(), this.cols(), this.rows());
        if (this.cellType().isFloatingPoint()) {
            for (int index$macro$160 = 0; index$macro$160 < this.cols(); ++index$macro$160) {
                for (int index$macro$159 = 0; index$macro$159 < this.rows(); ++index$macro$159) {
                    tile.setDouble(index$macro$160, index$macro$159, this.getDouble(index$macro$160, index$macro$159));
                }
            }
        } else {
            for (int index$macro$162 = 0; index$macro$162 < this.cols(); ++index$macro$162) {
                for (int index$macro$161 = 0; index$macro$161 < this.rows(); ++index$macro$161) {
                    tile.set(index$macro$162, index$macro$161, this.get(index$macro$162, index$macro$161));
                }
            }
        }
        return var1_1;
    }

    @Override
    public PixelInterleaveBandArrayTile withNoData(Option<Object> noDataValue) {
        return PixelInterleaveBandArrayTile$.MODULE$.apply(this.inner.withNoData(noDataValue).toArrayTile(), this.bandCount, this.bandIndex);
    }

    @Override
    public PixelInterleaveBandArrayTile interpretAs(DataType newCellType) {
        return PixelInterleaveBandArrayTile$.MODULE$.apply(this.inner.interpretAs(newCellType).toArrayTile(), this.bandCount, this.bandIndex);
    }

    public PixelInterleaveBandArrayTile(ArrayTile inner, int bandCount, int bandIndex) {
        this.inner = inner;
        this.bandCount = bandCount;
        this.bandIndex = bandIndex;
        Grid.$init$(this);
        IterableTile.$init$(this);
        MappableTile.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        Tile.$init$(this);
        ArrayTile.$init$(this);
    }
}

