/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import geotrellis.raster.CellGrid;
import geotrellis.raster.CellSize;
import geotrellis.raster.GeoAttrsError;
import geotrellis.raster.Grid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.GridExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.TileLayout;
import geotrellis.vector.Extent;
import geotrellis.vector.Point;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\t5d\u0001B\u0001\u0003\u0001\u001e\u0011ABU1ti\u0016\u0014X\t\u001f;f]RT!a\u0001\u0003\u0002\rI\f7\u000f^3s\u0015\u0005)\u0011AC4f_R\u0014X\r\u001c7jg\u000e\u00011#\u0002\u0001\t\u0019=)\u0002CA\u0005\u000b\u001b\u0005\u0011\u0011BA\u0006\u0003\u0005)9%/\u001b3FqR,g\u000e\u001e\t\u0003\u00135I!A\u0004\u0002\u0003\t\u001d\u0013\u0018\u000e\u001a\t\u0003!Mi\u0011!\u0005\u0006\u0002%\u0005)1oY1mC&\u0011A#\u0005\u0002\b!J|G-^2u!\t\u0001b#\u0003\u0002\u0018#\ta1+\u001a:jC2L'0\u00192mK\"A\u0011\u0004\u0001BK\u0002\u0013\u0005#$\u0001\u0004fqR,g\u000e^\u000b\u00027A\u0011AdH\u0007\u0002;)\u0011a\u0004B\u0001\u0007m\u0016\u001cGo\u001c:\n\u0005\u0001j\"AB#yi\u0016tG\u000fC\u0005#\u0001\tE\t\u0015!\u0003\u001cG\u00059Q\r\u001f;f]R\u0004\u0013BA\r\u000b\u0011!)\u0003A!f\u0001\n\u00032\u0013!C2fY2<\u0018\u000e\u001a;i+\u00059\u0003C\u0001\t)\u0013\tI\u0013C\u0001\u0004E_V\u0014G.\u001a\u0005\nW\u0001\u0011\t\u0012)A\u0005O1\n!bY3mY^LG\r\u001e5!\u0013\t)#\u0002\u0003\u0005/\u0001\tU\r\u0011\"\u0011'\u0003)\u0019W\r\u001c7iK&<\u0007\u000e\u001e\u0005\na\u0001\u0011\t\u0012)A\u0005OE\n1bY3mY\",\u0017n\u001a5uA%\u0011aF\u0003\u0005\tg\u0001\u0011)\u001a!C\u0001i\u0005!1m\u001c7t+\u0005)\u0004C\u0001\t7\u0013\t9\u0014CA\u0002J]RD\u0001\"\u000f\u0001\u0003\u0012\u0003\u0006I!N\u0001\u0006G>d7\u000f\t\u0005\tw\u0001\u0011)\u001a!C\u0001i\u0005!!o\\<t\u0011!i\u0004A!E!\u0002\u0013)\u0014!\u0002:poN\u0004\u0003\"B \u0001\t\u0003\u0001\u0015A\u0002\u001fj]&$h\b\u0006\u0004B\u0005\u000e#UI\u0012\t\u0003\u0013\u0001AQ!\u0007 A\u0002mAQ!\n A\u0002\u001dBQA\f A\u0002\u001dBQa\r A\u0002UBQa\u000f A\u0002UBQ\u0001\u0013\u0001\u0005\u0006%\u000b\u0011\"\\1q)><%/\u001b3\u0015\u0007)ku\n\u0005\u0003\u0011\u0017V*\u0014B\u0001'\u0012\u0005\u0019!V\u000f\u001d7fe!)aj\u0012a\u0001O\u0005\t\u0001\u0010C\u0003Q\u000f\u0002\u0007q%A\u0001z\u0011\u0015\u0011\u0006\u0001\"\u0002T\u0003)i\u0017\r\u001d-U_\u001e\u0013\u0018\u000e\u001a\u000b\u0003kQCQAT)A\u0002\u001dBQA\u0016\u0001\u0005\u0006]\u000b\u0001#\\1q1R{wI]5e\t>,(\r\\3\u0015\u0005\u001dB\u0006\"\u0002(V\u0001\u00049\u0003\"\u0002.\u0001\t\u000bY\u0016AC7baf#vn\u0012:jIR\u0011Q\u0007\u0018\u0005\u0006!f\u0003\ra\n\u0005\u0006=\u0002!)aX\u0001\u0011[\u0006\u0004\u0018\fV8He&$Gi\\;cY\u0016$\"a\n1\t\u000bAk\u0006\u0019A\u0014\t\u000b!\u0003AQ\u00012\u0015\u0005)\u001b\u0007\"\u00023b\u0001\u0004)\u0017\u0001C7ba\u000e{wN\u001d3\u0011\tAYue\n\u0005\u0006\u0011\u0002!)a\u001a\u000b\u0003\u0015\"DQ!\u001b4A\u0002)\f\u0011\u0001\u001d\t\u00039-L!\u0001\\\u000f\u0003\u000bA{\u0017N\u001c;\t\u000b9\u0004AQA8\u0002\u0013\u001d\u0014\u0018\u000e\u001a+p\u001b\u0006\u0004HcA3qe\")\u0011/\u001ca\u0001k\u0005\u00191m\u001c7\t\u000bMl\u0007\u0019A\u001b\u0002\u0007I|w\u000fC\u0003v\u0001\u0011\u0015a/\u0001\u0007he&$7i\u001c7U_6\u000b\u0007\u000f\u0006\u0002(o\")\u0011\u000f\u001ea\u0001k!)\u0011\u0010\u0001C\u0003u\u0006aqM]5e%><Hk\\'baR\u0011qe\u001f\u0005\u0006gb\u0004\r!\u000e\u0005\u0006{\u0002!\tA`\u0001\u000eOJLGMQ8v]\u0012\u001chi\u001c:\u0015\u000b}\f)!!\u0003\u0011\u0007%\t\t!C\u0002\u0002\u0004\t\u0011!b\u0012:jI\n{WO\u001c3t\u0011\u0019\t9\u0001 a\u00017\u0005I1/\u001e2FqR,g\u000e\u001e\u0005\n\u0003\u0017a\b\u0013!a\u0001\u0003\u001b\tQa\u00197b[B\u00042\u0001EA\b\u0013\r\t\t\"\u0005\u0002\b\u0005>|G.Z1o\u0011\u001d\t)\u0002\u0001C\u0001\u0003/\tqaY8nE&tW\rF\u0002B\u00033Aq!a\u0007\u0002\u0014\u0001\u0007\u0011)\u0001\u0003uQ\u0006$\bbBA\u0010\u0001\u0011\u0005\u0011\u0011E\u0001\u000fo&$\bNU3t_2,H/[8o)\u0015\t\u00151EA\u0014\u0011\u001d\t)#!\bA\u0002\u001d\nq\u0002^1sO\u0016$8)\u001a7m/&$G\u000f\u001b\u0005\b\u0003S\ti\u00021\u0001(\u0003A!\u0018M]4fi\u000e+G\u000e\u001c%fS\u001eDG\u000fC\u0004\u0002 \u0001!\t!!\f\u0015\u0007\u0005\u000by\u0003\u0003\u0005\u00022\u0005-\u0002\u0019AA\u001a\u0003!\u0019W\r\u001c7TSj,\u0007cA\u0005\u00026%\u0019\u0011q\u0007\u0002\u0003\u0011\r+G\u000e\\*ju\u0016Dq!a\u000f\u0001\t\u0003\ti$\u0001\bxSRDG)[7f]NLwN\\:\u0015\u000b\u0005\u000by$a\u0011\t\u000f\u0005\u0005\u0013\u0011\ba\u0001k\u0005QA/\u0019:hKR\u001cu\u000e\\:\t\u000f\u0005\u0015\u0013\u0011\ba\u0001k\u0005QA/\u0019:hKR\u0014vn^:\t\u000f\u0005%\u0003\u0001\"\u0001\u0002L\u0005A\u0011\r\u001a6vgR$v\u000eF\u0002B\u0003\u001bB\u0001\"a\u0014\u0002H\u0001\u0007\u0011\u0011K\u0001\u000bi&dW\rT1z_V$\bcA\u0005\u0002T%\u0019\u0011Q\u000b\u0002\u0003\u0015QKG.\u001a'bs>,H\u000fC\u0004\u0002Z\u0001!\t!a\u0017\u0002\u001fI\f7\u000f^3s\u000bb$XM\u001c;G_J$2!QA/\u0011\u001d\ty&a\u0016A\u0002}\f!b\u001a:jI\n{WO\u001c3t\u0011%\t\u0019\u0007AA\u0001\n\u0003\t)'\u0001\u0003d_BLHcC!\u0002h\u0005%\u00141NA7\u0003_B\u0001\"GA1!\u0003\u0005\ra\u0007\u0005\tK\u0005\u0005\u0004\u0013!a\u0001O!Aa&!\u0019\u0011\u0002\u0003\u0007q\u0005\u0003\u00054\u0003C\u0002\n\u00111\u00016\u0011!Y\u0014\u0011\rI\u0001\u0002\u0004)\u0004\"CA:\u0001E\u0005I\u0011AA;\u0003]9'/\u001b3C_VtGm\u001d$pe\u0012\"WMZ1vYR$#'\u0006\u0002\u0002x)\"\u0011QBA=W\t\tY\b\u0005\u0003\u0002~\u0005\u001dUBAA@\u0015\u0011\t\t)a!\u0002\u0013Ut7\r[3dW\u0016$'bAAC#\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005%\u0015q\u0010\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CAG\u0001E\u0005I\u0011AAH\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!%+\u0007m\tI\bC\u0005\u0002\u0016\u0002\t\n\u0011\"\u0001\u0002\u0018\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAAMU\r9\u0013\u0011\u0010\u0005\n\u0003;\u0003\u0011\u0013!C\u0001\u0003/\u000babY8qs\u0012\"WMZ1vYR$3\u0007C\u0005\u0002\"\u0002\t\n\u0011\"\u0001\u0002$\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\"TCAASU\r)\u0014\u0011\u0010\u0005\n\u0003S\u0003\u0011\u0013!C\u0001\u0003G\u000babY8qs\u0012\"WMZ1vYR$S\u0007C\u0005\u0002.\u0002\t\t\u0011\"\u0011\u00020\u0006i\u0001O]8ek\u000e$\bK]3gSb,\"!!-\u0011\t\u0005M\u0016QX\u0007\u0003\u0003kSA!a.\u0002:\u0006!A.\u00198h\u0015\t\tY,\u0001\u0003kCZ\f\u0017\u0002BA`\u0003k\u0013aa\u0015;sS:<\u0007\u0002CAb\u0001\u0005\u0005I\u0011\u0001\u001b\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u0013\u0005\u001d\u0007!!A\u0005\u0002\u0005%\u0017A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003\u0017\f\t\u000eE\u0002\u0011\u0003\u001bL1!a4\u0012\u0005\r\te.\u001f\u0005\n\u0003'\f)-!AA\u0002U\n1\u0001\u001f\u00132\u0011%\t9\u000eAA\u0001\n\u0003\nI.A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\tY\u000e\u0005\u0004\u0002^\u0006\r\u00181Z\u0007\u0003\u0003?T1!!9\u0012\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003K\fyN\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\tI\u000fAA\u0001\n\u0003\tY/\u0001\u0005dC:,\u0015/^1m)\u0011\ti!!<\t\u0015\u0005M\u0017q]A\u0001\u0002\u0004\tYmB\u0004\u0002r\nA\t!a=\u0002\u0019I\u000b7\u000f^3s\u000bb$XM\u001c;\u0011\u0007%\t)P\u0002\u0004\u0002\u0005!\u0005\u0011q_\n\u0006\u0003k\fI0\u0006\t\u0004!\u0005m\u0018bAA\u007f#\t1\u0011I\\=SK\u001aDqaPA{\t\u0003\u0011\t\u0001\u0006\u0002\u0002t\"Q!QAA{\u0005\u0004%)Aa\u0002\u0002\u000f\u0015\u00048/\u001b7p]V\u0011!\u0011B\b\u0003\u0005\u0017\u0001\u0003B\u0010>Xfle|\u0016\u0013\u0005\n\u0005\u001f\t)\u0010)A\u0007\u0005\u0013\t\u0001\"\u001a9tS2|g\u000e\t\u0005\t\u0005'\t)\u0010\"\u0001\u0003\u0016\u0005)\u0011\r\u001d9msR9\u0011Ia\u0006\u0003\u001a\tm\u0001BB\r\u0003\u0012\u0001\u00071\u0004\u0003\u00044\u0005#\u0001\r!\u000e\u0005\u0007w\tE\u0001\u0019A\u001b\t\u0011\tM\u0011Q\u001fC\u0001\u0005?!R!\u0011B\u0011\u0005GAa!\u0007B\u000f\u0001\u0004Y\u0002\u0002CA\u0019\u0005;\u0001\r!a\r\t\u0011\tM\u0011Q\u001fC\u0001\u0005O!R!\u0011B\u0015\u0005gA\u0001Ba\u000b\u0003&\u0001\u0007!QF\u0001\u0005i&dW\rE\u0002\n\u0005_I1A!\r\u0003\u0005!\u0019U\r\u001c7He&$\u0007BB\r\u0003&\u0001\u00071\u0004\u0003\u0005\u0003\u0014\u0005UH\u0011\u0001B\u001c)\u0015\t%\u0011\bB\u001e\u0011\u0019I\"Q\u0007a\u00017!A!1\u0006B\u001b\u0001\u0004\u0011i\u0003\u0003\u0006\u0003\u0014\u0005U\u0018\u0011!CA\u0005\u007f!2\"\u0011B!\u0005\u0007\u0012)Ea\u0012\u0003J!1\u0011D!\u0010A\u0002mAa!\nB\u001f\u0001\u00049\u0003B\u0002\u0018\u0003>\u0001\u0007q\u0005\u0003\u00044\u0005{\u0001\r!\u000e\u0005\u0007w\tu\u0002\u0019A\u001b\t\u0015\t5\u0013Q_A\u0001\n\u0003\u0013y%A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tE#Q\f\t\u0006!\tM#qK\u0005\u0004\u0005+\n\"AB(qi&|g\u000e\u0005\u0005\u0011\u00053ZreJ\u001b6\u0013\r\u0011Y&\u0005\u0002\u0007)V\u0004H.Z\u001b\t\u0013\t}#1JA\u0001\u0002\u0004\t\u0015a\u0001=%a!Q!1MA{\u0003\u0003%IA!\u001a\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0005O\u0002B!a-\u0003j%!!1NA[\u0005\u0019y%M[3di\u0002")
public class RasterExtent
extends GridExtent
implements Grid,
Product {
    private final int cols;
    private final int rows;

    public static Option<Tuple5<Extent, Object, Object, Object, Object>> unapply(RasterExtent rasterExtent) {
        return RasterExtent$.MODULE$.unapply(rasterExtent);
    }

    public static RasterExtent apply(Extent extent, double d, double d2, int n, int n2) {
        return RasterExtent$.MODULE$.apply(extent, d, d2, n, n2);
    }

    public static RasterExtent apply(Extent extent, CellGrid cellGrid) {
        return RasterExtent$.MODULE$.apply(extent, cellGrid);
    }

    public static RasterExtent apply(CellGrid cellGrid, Extent extent) {
        return RasterExtent$.MODULE$.apply(cellGrid, extent);
    }

    public static RasterExtent apply(Extent extent, CellSize cellSize) {
        return RasterExtent$.MODULE$.apply(extent, cellSize);
    }

    public static RasterExtent apply(Extent extent, int n, int n2) {
        return RasterExtent$.MODULE$.apply(extent, n, n2);
    }

    public static double epsilon() {
        return RasterExtent$.MODULE$.epsilon();
    }

    @Override
    public int size() {
        return Grid.size$(this);
    }

    @Override
    public Tuple2<Object, Object> dimensions() {
        return Grid.dimensions$(this);
    }

    @Override
    public GridBounds gridBounds() {
        return Grid.gridBounds$(this);
    }

    @Override
    public Extent extent() {
        return super.extent();
    }

    @Override
    public double cellwidth() {
        return super.cellwidth();
    }

    @Override
    public double cellheight() {
        return super.cellheight();
    }

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    public final Tuple2<Object, Object> mapToGrid(double x, double y) {
        int col = (int)package$.MODULE$.floor((x - this.extent().xmin()) / this.cellwidth());
        int row = (int)package$.MODULE$.floor((this.extent().ymax() - y) / this.cellheight());
        return new Tuple2.mcII.sp(col, row);
    }

    public final int mapXToGrid(double x) {
        return (int)package$.MODULE$.floor(this.mapXToGridDouble(x));
    }

    public final double mapXToGridDouble(double x) {
        return (x - this.extent().xmin()) / this.cellwidth();
    }

    public final int mapYToGrid(double y) {
        return (int)package$.MODULE$.floor(this.mapYToGridDouble(y));
    }

    public final double mapYToGridDouble(double y) {
        return (this.extent().ymax() - y) / this.cellheight();
    }

    public final Tuple2<Object, Object> mapToGrid(Tuple2<Object, Object> mapCoord) {
        Tuple2<Object, Object> tuple2 = mapCoord;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double x = tuple2._1$mcD$sp();
        double y = tuple2._2$mcD$sp();
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(x, y);
        Tuple2.mcDD.sp sp3 = sp2;
        double x2 = sp3._1$mcD$sp();
        double y2 = sp3._2$mcD$sp();
        return this.mapToGrid(x2, y2);
    }

    public final Tuple2<Object, Object> mapToGrid(Point p) {
        return this.mapToGrid(p.x(), p.y());
    }

    public final Tuple2<Object, Object> gridToMap(int col, int row) {
        double x = (double)col * this.cellwidth() + this.extent().xmin() + this.cellwidth() / (double)2;
        double y = this.extent().ymax() - (double)row * this.cellheight() - this.cellheight() / (double)2;
        return new Tuple2.mcDD.sp(x, y);
    }

    public final double gridColToMap(int col) {
        return (double)col * this.cellwidth() + this.extent().xmin() + this.cellwidth() / (double)2;
    }

    public final double gridRowToMap(int row) {
        return this.extent().ymax() - (double)row * this.cellheight() - this.cellheight() / (double)2;
    }

    public GridBounds gridBoundsFor(Extent subExtent, boolean clamp) {
        Tuple2<Object, Object> tuple2 = this.mapToGrid(subExtent.xmin(), subExtent.ymax());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int colMin = tuple2._1$mcI$sp();
        int rowMin = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(colMin, rowMin);
        Tuple2.mcII.sp sp3 = sp2;
        int colMin2 = sp3._1$mcI$sp();
        int rowMin2 = sp3._2$mcI$sp();
        double colMaxDouble = this.mapXToGridDouble(subExtent.xmax());
        int colMax = package$.MODULE$.abs(colMaxDouble - package$.MODULE$.floor(colMaxDouble)) < 1.0E-7 ? (int)colMaxDouble - 1 : (int)colMaxDouble;
        double rowMaxDouble = this.mapYToGridDouble(subExtent.ymin());
        int rowMax = package$.MODULE$.abs(rowMaxDouble - package$.MODULE$.floor(rowMaxDouble)) < 1.0E-7 ? (int)rowMaxDouble - 1 : (int)rowMaxDouble;
        return clamp ? new GridBounds(package$.MODULE$.min(package$.MODULE$.max(colMin2, 0), this.cols() - 1), package$.MODULE$.min(package$.MODULE$.max(rowMin2, 0), this.rows() - 1), package$.MODULE$.min(package$.MODULE$.max(colMax, 0), this.cols() - 1), package$.MODULE$.min(package$.MODULE$.max(rowMax, 0), this.rows() - 1)) : new GridBounds(colMin2, rowMin2, colMax, rowMax);
    }

    public boolean gridBoundsFor$default$2() {
        return true;
    }

    public RasterExtent combine(RasterExtent that) {
        if (this.cellwidth() != that.cellwidth()) {
            throw new GeoAttrsError(new StringBuilder(25).append("illegal cellwidths: ").append(this.cellwidth()).append(" and ").append(that.cellwidth()).toString());
        }
        if (this.cellheight() != that.cellheight()) {
            throw new GeoAttrsError(new StringBuilder(26).append("illegal cellheights: ").append(this.cellheight()).append(" and ").append(that.cellheight()).toString());
        }
        Extent newExtent = this.extent().combine(that.extent());
        int newRows = (int)package$.MODULE$.ceil(newExtent.height() / this.cellheight());
        int newCols = (int)package$.MODULE$.ceil(newExtent.width() / this.cellwidth());
        return new RasterExtent(newExtent, this.cellwidth(), this.cellheight(), newCols, newRows);
    }

    public RasterExtent withResolution(double targetCellWidth, double targetCellHeight) {
        int newCols = (int)package$.MODULE$.ceil((this.extent().xmax() - this.extent().xmin()) / targetCellWidth);
        int newRows = (int)package$.MODULE$.ceil((this.extent().ymax() - this.extent().ymin()) / targetCellHeight);
        return new RasterExtent(this.extent(), targetCellWidth, targetCellHeight, newCols, newRows);
    }

    public RasterExtent withResolution(CellSize cellSize) {
        return this.withResolution(cellSize.width(), cellSize.height());
    }

    public RasterExtent withDimensions(int targetCols, int targetRows) {
        return RasterExtent$.MODULE$.apply(this.extent(), targetCols, targetRows);
    }

    public RasterExtent adjustTo(TileLayout tileLayout) {
        int totalCols = tileLayout.tileCols() * tileLayout.layoutCols();
        int totalRows = tileLayout.tileRows() * tileLayout.layoutRows();
        Extent resampledExtent = new Extent(this.extent().xmin(), this.extent().ymax() - this.cellheight() * (double)totalRows, this.extent().xmin() + this.cellwidth() * (double)totalCols, this.extent().ymax());
        return new RasterExtent(resampledExtent, this.cellwidth(), this.cellheight(), totalCols, totalRows);
    }

    public RasterExtent rasterExtentFor(GridBounds gridBounds) {
        Tuple2<Object, Object> tuple2 = this.gridToMap(gridBounds.colMin(), gridBounds.rowMin());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double xminCenter = tuple2._1$mcD$sp();
        double ymaxCenter = tuple2._2$mcD$sp();
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(xminCenter, ymaxCenter);
        Tuple2.mcDD.sp sp3 = sp2;
        double xminCenter2 = sp3._1$mcD$sp();
        double ymaxCenter2 = sp3._2$mcD$sp();
        Tuple2<Object, Object> tuple22 = this.gridToMap(gridBounds.colMax(), gridBounds.rowMax());
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        double xmaxCenter = tuple22._1$mcD$sp();
        double yminCenter = tuple22._2$mcD$sp();
        Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(xmaxCenter, yminCenter);
        Tuple2.mcDD.sp sp5 = sp4;
        double xmaxCenter2 = sp5._1$mcD$sp();
        double yminCenter2 = sp5._2$mcD$sp();
        Tuple2.mcDD.sp sp6 = new Tuple2.mcDD.sp(this.cellwidth() / (double)2, this.cellheight() / (double)2);
        if (sp6 == null) {
            throw new MatchError((Object)sp6);
        }
        double hcw = sp6._1$mcD$sp();
        double hch = sp6._2$mcD$sp();
        Tuple2.mcDD.sp sp7 = new Tuple2.mcDD.sp(hcw, hch);
        Tuple2.mcDD.sp sp8 = sp7;
        double hcw2 = sp8._1$mcD$sp();
        double hch2 = sp8._2$mcD$sp();
        Extent e = new Extent(xminCenter2 - hcw2, yminCenter2 - hch2, xmaxCenter2 + hcw2, ymaxCenter2 + hch2);
        return new RasterExtent(e, this.cellwidth(), this.cellheight(), gridBounds.width(), gridBounds.height());
    }

    public RasterExtent copy(Extent extent, double cellwidth, double cellheight, int cols, int rows) {
        return new RasterExtent(extent, cellwidth, cellheight, cols, rows);
    }

    public Extent copy$default$1() {
        return this.extent();
    }

    public double copy$default$2() {
        return this.cellwidth();
    }

    public double copy$default$3() {
        return this.cellheight();
    }

    public int copy$default$4() {
        return this.cols();
    }

    public int copy$default$5() {
        return this.rows();
    }

    public String productPrefix() {
        return "RasterExtent";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = this.extent();
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToDouble((double)this.cellwidth());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToDouble((double)this.cellheight());
                break;
            }
            case 3: {
                object = BoxesRunTime.boxToInteger((int)this.cols());
                break;
            }
            case 4: {
                object = BoxesRunTime.boxToInteger((int)this.rows());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RasterExtent;
    }

    public RasterExtent(Extent extent, double cellwidth, double cellheight, int cols, int rows) {
        this.cols = cols;
        this.rows = rows;
        super(extent, cellwidth, cellheight);
        Grid.$init$(this);
        Product.$init$((Product)this);
        if (cols <= 0) {
            throw new GeoAttrsError(new StringBuilder(14).append("invalid cols: ").append(cols).toString());
        }
        if (rows <= 0) {
            throw new GeoAttrsError(new StringBuilder(14).append("invalid rows: ").append(rows).toString());
        }
    }
}

