/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.CellSet;
import geotrellis.raster.ConstantNoData;
import geotrellis.raster.ConstantTile;
import geotrellis.raster.DataType;
import geotrellis.raster.Grid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.IterableTile;
import geotrellis.raster.MappableTile;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.NoNoData;
import geotrellis.raster.ShortArrayTile$;
import geotrellis.raster.ShortCells;
import geotrellis.raster.ShortConstantTile$;
import geotrellis.raster.ShortUserDefinedNoDataCellType;
import geotrellis.raster.Tile;
import java.nio.ByteBuffer;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\t5a\u0001B\u0001\u0003\u0001\u001e\u0011\u0011c\u00155peR\u001cuN\\:uC:$H+\u001b7f\u0015\t\u0019A!\u0001\u0004sCN$XM\u001d\u0006\u0002\u000b\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001M)\u0001\u0001\u0003\b\u0013+A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\t\u000e\u0003\tI!!\u0005\u0002\u0003\u0019\r{gn\u001d;b]R$\u0016\u000e\\3\u0011\u0005%\u0019\u0012B\u0001\u000b\u000b\u0005\u001d\u0001&o\u001c3vGR\u0004\"!\u0003\f\n\u0005]Q!\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002C\r\u0001\u0005+\u0007I\u0011\u0001\u000e\u0002\u0003Y,\u0012a\u0007\t\u0003\u0013qI!!\b\u0006\u0003\u000bMCwN\u001d;\t\u0011}\u0001!\u0011#Q\u0001\nm\t!A\u001e\u0011\t\u0011\u0005\u0002!Q3A\u0005\u0002\t\nAaY8mgV\t1\u0005\u0005\u0002\nI%\u0011QE\u0003\u0002\u0004\u0013:$\b\u0002C\u0014\u0001\u0005#\u0005\u000b\u0011B\u0012\u0002\u000b\r|Gn\u001d\u0011\t\u0011%\u0002!Q3A\u0005\u0002\t\nAA]8xg\"A1\u0006\u0001B\tB\u0003%1%A\u0003s_^\u001c\b\u0005\u0003\u0005.\u0001\tU\r\u0011\"\u0001/\u0003!\u0019W\r\u001c7UsB,W#A\u0018\u0013\u0007A\u0012TG\u0002\u00032\u0001\u0001y#\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004CA\b4\u0013\t!$A\u0001\u0006TQ>\u0014HoQ3mYN\u0004\"a\u0004\u001c\n\u0005]\u0012!A\u0004(p\t\u0006$\u0018\rS1oI2Lgn\u001a\u0005\ts\u0001\u0011\t\u0012)A\u0005_\u0005I1-\u001a7m)f\u0004X\r\t\u0005\u0006w\u0001!\t\u0001P\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000burt\bQ!\u0011\u0005=\u0001\u0001\"B\r;\u0001\u0004Y\u0002\"B\u0011;\u0001\u0004\u0019\u0003\"B\u0015;\u0001\u0004\u0019\u0003bB\u0017;!\u0003\u0005\rA\u0011\n\u0004\u0007J*d\u0001B\u0019\u0001\u0001\tC!\"\u0012\u0001\u0011\u0002\u0003\r\t\u0015!\u0003G\u0003\u0011AH%M\u001d\u0011\t%95%S\u0005\u0003\u0011*\u0011a\u0001V;qY\u0016\u0014\u0004CA\u0005K\u0013\tY%B\u0001\u0004E_V\u0014G.\u001a\u0005\b\u001b\u0002\u0011\r\u0011\"\u0005#\u0003\u0011Ig+\u00197\t\r=\u0003\u0001\u0015!\u0003$\u0003\u0015Ig+\u00197!\u0011\u001d\t\u0006A1A\u0005\u0012I\u000bA\u0001\u001a,bYV\t\u0011\n\u0003\u0004U\u0001\u0001\u0006I!S\u0001\u0006IZ\u000bG\u000e\t\u0005\u0006-\u0002!\taV\u0001\fi>\f%O]1z)&dW\rF\u0001Y!\ty\u0011,\u0003\u0002[\u0005\tI\u0011I\u001d:bsRKG.\u001a\u0005\u00069\u0002!\t!X\u0001\b[V$\u0018M\u00197f+\u0005q\u0006CA\b`\u0013\t\u0001'A\u0001\tNkR\f'\r\\3BeJ\f\u0017\u0010V5mK\")!\r\u0001C\u0001G\u00069Ao\u001c\"zi\u0016\u001cH#\u00013\u0011\u0007%)w-\u0003\u0002g\u0015\t)\u0011I\u001d:bsB\u0011\u0011\u0002[\u0005\u0003S*\u0011AAQ=uK\")1\u000e\u0001C\u0001Y\u0006Qq/\u001b;i\u001d>$\u0015\r^1\u0015\u0005uj\u0007\"\u00028k\u0001\u0004y\u0017a\u00038p\t\u0006$\u0018MV1mk\u0016\u00042!\u00039J\u0013\t\t(B\u0001\u0004PaRLwN\u001c\u0005\u0006g\u0002!\t\u0001^\u0001\u0004[\u0006\u0004HCA;y!\tya/\u0003\u0002x\u0005\t!A+\u001b7f\u0011\u0015I(\u000f1\u0001{\u0003\u00051\u0007\u0003B\u0005|G\rJ!\u0001 \u0006\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\"\u0002@\u0001\t\u0003y\u0018!C7ba\u0012{WO\u00197f)\r)\u0018\u0011\u0001\u0005\u0007sv\u0004\r!a\u0001\u0011\t%Y\u0018*\u0013\u0005\n\u0003\u000f\u0001\u0011\u0011!C\u0001\u0003\u0013\tAaY8qsRIQ(a\u0003\u0002\u000e\u0005=\u0011\u0011\u0003\u0005\t3\u0005\u0015\u0001\u0013!a\u00017!A\u0011%!\u0002\u0011\u0002\u0003\u00071\u0005\u0003\u0005*\u0003\u000b\u0001\n\u00111\u0001$\u0011!i\u0013Q\u0001I\u0001\u0002\u0004\u0011\u0005\"CA\u000b\u0001E\u0005I\u0011AA\f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"!!\u0007+\u0007m\tYb\u000b\u0002\u0002\u001eA!\u0011qDA\u0015\u001b\t\t\tC\u0003\u0003\u0002$\u0005\u0015\u0012!C;oG\",7m[3e\u0015\r\t9CC\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BA\u0016\u0003C\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011%\ty\u0003AI\u0001\n\u0003\t\t$\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005M\"fA\u0012\u0002\u001c!I\u0011q\u0007\u0001\u0012\u0002\u0013\u0005\u0011\u0011G\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0011%\tY\u0004AI\u0001\n\u0003\ti$\u0001\bd_BLH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005}\"fA\u0018\u0002\u001c!I\u00111\t\u0001\u0002\u0002\u0013\u0005\u0013QI\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\u0005\u001d\u0003\u0003BA%\u0003'j!!a\u0013\u000b\t\u00055\u0013qJ\u0001\u0005Y\u0006twM\u0003\u0002\u0002R\u0005!!.\u0019<b\u0013\u0011\t)&a\u0013\u0003\rM#(/\u001b8h\u0011!\tI\u0006AA\u0001\n\u0003\u0011\u0013\u0001\u00049s_\u0012,8\r^!sSRL\b\"CA/\u0001\u0005\u0005I\u0011AA0\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\u0019\u0002hA\u0019\u0011\"a\u0019\n\u0007\u0005\u0015$BA\u0002B]fD\u0011\"!\u001b\u0002\\\u0005\u0005\t\u0019A\u0012\u0002\u0007a$\u0013\u0007C\u0005\u0002n\u0001\t\t\u0011\"\u0011\u0002p\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002rA1\u00111OA=\u0003Cj!!!\u001e\u000b\u0007\u0005]$\"\u0001\u0006d_2dWm\u0019;j_:LA!a\u001f\u0002v\tA\u0011\n^3sCR|'\u000fC\u0005\u0002\u0000\u0001\t\t\u0011\"\u0001\u0002\u0002\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0002\u0004\u0006%\u0005cA\u0005\u0002\u0006&\u0019\u0011q\u0011\u0006\u0003\u000f\t{w\u000e\\3b]\"Q\u0011\u0011NA?\u0003\u0003\u0005\r!!\u0019\t\u0013\u00055\u0005!!A\u0005B\u0005=\u0015\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003\rB\u0011\"a%\u0001\u0003\u0003%\t%!&\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0012\t\u0013\u0005e\u0005!!A\u0005B\u0005m\u0015AB3rk\u0006d7\u000f\u0006\u0003\u0002\u0004\u0006u\u0005BCA5\u0003/\u000b\t\u00111\u0001\u0002b\u001d9\u0011\u0011\u0015\u0002\t\u0002\u0005\r\u0016!E*i_J$8i\u001c8ti\u0006tG\u000fV5mKB\u0019q\"!*\u0007\r\u0005\u0011\u0001\u0012AAT'\u0011\t)\u000bC\u000b\t\u000fm\n)\u000b\"\u0001\u0002,R\u0011\u00111\u0015\u0005\t\u0003_\u000b)\u000b\"\u0001\u00022\u0006IaM]8n\u0005f$Xm\u001d\u000b\n{\u0005M\u0016qWA]\u0003wCq!!.\u0002.\u0002\u0007A-A\u0003csR,7\u000f\u0003\u0004\"\u0003[\u0003\ra\t\u0005\u0007S\u00055\u0006\u0019A\u0012\t\u000f5\ni\u000b1\u0001\u0002>J!\u0011q\u0018\u001a6\r\u0019\t\u0014Q\u0015\u0001\u0002>\"Q\u00111YAS\u0003\u0003%\t)!2\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013u\n9-!3\u0002L\u00065\u0007BB\r\u0002B\u0002\u00071\u0004\u0003\u0004\"\u0003\u0003\u0004\ra\t\u0005\u0007S\u0005\u0005\u0007\u0019A\u0012\t\u00135\n\t\r%AA\u0002\u0005='\u0003BAieU2a!MAS\u0001\u0005=\u0007BCAk\u0003K\u000b\t\u0011\"!\u0002X\u00069QO\\1qa2LH\u0003BAm\u0003K\u0004B!\u00039\u0002\\BA\u0011\"!8\u001cG\r\n\t/C\u0002\u0002`*\u0011a\u0001V;qY\u0016$$\u0003BAreU2a!MAS\u0001\u0005\u0005\b\"CAt\u0003'\f\t\u00111\u0001>\u0003\rAH\u0005\r\u0005\u000b\u0003W\f)+%A\u0005\u0002\u00055\u0018aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\u0005=(\u0006BAy\u00037\u0011B!a=3k\u00191\u0011'!*\u0001\u0003cD!\"a>\u0002&F\u0005I\u0011AA}\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u00111 \u0016\u0005\u0003{\fYB\u0005\u0003\u0002\u0000J*dAB\u0019\u0002&\u0002\ti\u0010\u0003\u0006\u0003\u0004\u0005\u0015\u0016\u0011!C\u0005\u0005\u000b\t1B]3bIJ+7o\u001c7wKR\u0011!q\u0001\t\u0005\u0003\u0013\u0012I!\u0003\u0003\u0003\f\u0005-#AB(cU\u0016\u001cG\u000f")
public class ShortConstantTile
implements ConstantTile,
Product {
    private final short v;
    private final int cols;
    private final int rows;
    private final ShortCells cellType;
    private final /* synthetic */ Tuple2 x$19;
    private final int iVal;
    private final double dVal;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static ShortCells $lessinit$greater$default$4() {
        return ShortConstantTile$.MODULE$.$lessinit$greater$default$4();
    }

    public static ShortCells apply$default$4() {
        return ShortConstantTile$.MODULE$.apply$default$4();
    }

    public static Option<Tuple4<Object, Object, Object, ShortCells>> unapply(ShortConstantTile shortConstantTile) {
        return ShortConstantTile$.MODULE$.unapply(shortConstantTile);
    }

    public static ShortConstantTile apply(short s, int n, int n2, ShortCells shortCells) {
        return ShortConstantTile$.MODULE$.apply(s, n, n2, shortCells);
    }

    public static ShortConstantTile fromBytes(byte[] byArray, int n, int n2, ShortCells shortCells) {
        return ShortConstantTile$.MODULE$.fromBytes(byArray, n, n2, shortCells);
    }

    @Override
    public int get(int col, int row) {
        return ConstantTile.get$(this, col, row);
    }

    @Override
    public double getDouble(int col, int row) {
        return ConstantTile.getDouble$(this, col, row);
    }

    @Override
    public int[] toArray() {
        return ConstantTile.toArray$(this);
    }

    @Override
    public double[] toArrayDouble() {
        return ConstantTile.toArrayDouble$(this);
    }

    @Override
    public Tile convert(DataType newType) {
        return ConstantTile.convert$(this, newType);
    }

    @Override
    public Tile interpretAs(DataType newCellType) {
        return ConstantTile.interpretAs$(this, newCellType);
    }

    @Override
    public void foreach(Function1<Object, BoxedUnit> f) {
        ConstantTile.foreach$(this, f);
    }

    @Override
    public void foreachDouble(Function1<Object, BoxedUnit> f) {
        ConstantTile.foreachDouble$(this, f);
    }

    @Override
    public void foreachIntVisitor(IntTileVisitor visitor) {
        ConstantTile.foreachIntVisitor$(this, visitor);
    }

    @Override
    public void foreachDoubleVisitor(DoubleTileVisitor visitor) {
        ConstantTile.foreachDoubleVisitor$(this, visitor);
    }

    @Override
    public Tile combine(Tile other, Function2<Object, Object, Object> f) {
        return ConstantTile.combine$(this, other, f);
    }

    @Override
    public Tile combineDouble(Tile other, Function2<Object, Object, Object> f) {
        return ConstantTile.combineDouble$(this, other, f);
    }

    @Override
    public Tile mapIntMapper(IntTileMapper mapper) {
        return ConstantTile.mapIntMapper$(this, mapper);
    }

    @Override
    public Tile mapDoubleMapper(DoubleTileMapper mapper) {
        return ConstantTile.mapDoubleMapper$(this, mapper);
    }

    @Override
    public void dualForeach(Function1<Object, BoxedUnit> f, Function1<Object, BoxedUnit> g) {
        Tile.dualForeach$(this, f, g);
    }

    @Override
    public Tile mapIfSet(Function1<Object, Object> f) {
        return Tile.mapIfSet$(this, f);
    }

    @Override
    public Tile mapIfSetDouble(Function1<Object, Object> f) {
        return Tile.mapIfSetDouble$(this, f);
    }

    @Override
    public Tile dualMap(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile.dualMap$(this, f, g);
    }

    @Override
    public Tile dualMapIfSet(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile.dualMapIfSet$(this, f, g);
    }

    @Override
    public Tile dualCombine(Tile r2, Function2<Object, Object, Object> f, Function2<Object, Object, Object> g) {
        return Tile.dualCombine$(this, r2, f, g);
    }

    @Override
    public boolean isNoDataTile() {
        return Tile.isNoDataTile$(this);
    }

    @Override
    public Tile normalize(int oldMin, int oldMax, int newMin, int newMax) {
        return Tile.normalize$((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile normalize(double oldMin, double oldMax, double newMin, double newMax) {
        return Tile.normalize$((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile rescale(int newMin, int newMax) {
        return Tile.rescale$((Tile)this, newMin, newMax);
    }

    @Override
    public Tile rescale(double newMin, double newMax) {
        return Tile.rescale$((Tile)this, newMin, newMax);
    }

    @Override
    public Tile downsample(int newCols, int newRows, Function1<CellSet, Object> f) {
        return Tile.downsample$(this, newCols, newRows, f);
    }

    @Override
    public Tuple2<Object, Object> findMinMax() {
        return Tile.findMinMax$(this);
    }

    @Override
    public Tuple2<Object, Object> findMinMaxDouble() {
        return Tile.findMinMaxDouble$(this);
    }

    @Override
    public int size() {
        return Grid.size$(this);
    }

    @Override
    public Tuple2<Object, Object> dimensions() {
        return Grid.dimensions$(this);
    }

    @Override
    public GridBounds gridBounds() {
        return Grid.gridBounds$(this);
    }

    private Logger logger$lzycompute() {
        ShortConstantTile shortConstantTile = this;
        synchronized (shortConstantTile) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public short v() {
        return this.v;
    }

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    public ShortCells cellType() {
        return this.cellType;
    }

    @Override
    public int iVal() {
        return this.iVal;
    }

    @Override
    public double dVal() {
        return this.dVal;
    }

    @Override
    public ArrayTile toArrayTile() {
        return this.mutable();
    }

    @Override
    public MutableArrayTile mutable() {
        return ShortArrayTile$.MODULE$.fill(this.v(), this.cols(), this.rows(), this.cellType());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] toBytes() {
        void var1_1;
        byte[] arr = (byte[])Array$.MODULE$.ofDim(((DataType)((Object)this.cellType())).bytes(), ClassTag$.MODULE$.Byte());
        ByteBuffer.wrap(arr).asShortBuffer().put(this.v());
        return var1_1;
    }

    @Override
    public ShortConstantTile withNoData(Option<Object> noDataValue) {
        return new ShortConstantTile(this.v(), this.cols(), this.rows(), this.cellType().withNoData(noDataValue));
    }

    @Override
    public Tile map(Function1<Object, Object> f) {
        int n = f.apply$mcII$sp(this.iVal());
        return new ShortConstantTile((short)(n == Integer.MIN_VALUE ? Short.MIN_VALUE : (short)n), this.cols(), this.rows(), this.cellType());
    }

    @Override
    public Tile mapDouble(Function1<Object, Object> f) {
        double n = f.apply$mcDD$sp(this.dVal());
        return new ShortConstantTile((short)(Double.isNaN(n) ? Short.MIN_VALUE : (short)n), this.cols(), this.rows(), ShortConstantTile$.MODULE$.apply$default$4());
    }

    public ShortConstantTile copy(short v, int cols, int rows, ShortCells cellType) {
        return new ShortConstantTile(v, cols, rows, cellType);
    }

    public short copy$default$1() {
        return this.v();
    }

    public int copy$default$2() {
        return this.cols();
    }

    public int copy$default$3() {
        return this.rows();
    }

    public ShortCells copy$default$4() {
        return this.cellType();
    }

    public String productPrefix() {
        return "ShortConstantTile";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = BoxesRunTime.boxToShort((short)this.v());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this.cols());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this.rows());
                break;
            }
            case 3: {
                object = this.cellType();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ShortConstantTile;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.v());
        n = Statics.mix((int)n, (int)this.cols());
        n = Statics.mix((int)n, (int)this.rows());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.cellType()));
        return Statics.finalizeHash((int)n, (int)4);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ShortConstantTile)) return false;
        boolean bl = true;
        if (!bl) return false;
        ShortConstantTile shortConstantTile = (ShortConstantTile)x$1;
        if (this.v() != shortConstantTile.v()) return false;
        if (this.cols() != shortConstantTile.cols()) return false;
        if (this.rows() != shortConstantTile.rows()) return false;
        ShortCells shortCells = this.cellType();
        ShortCells shortCells2 = shortConstantTile.cellType();
        if (shortCells == null) {
            if (shortCells2 != null) {
                return false;
            }
        } else if (!shortCells.equals(shortCells2)) return false;
        if (!shortConstantTile.canEqual(this)) return false;
        return true;
    }

    public ShortConstantTile(short v, int cols, int rows, ShortCells cellType) {
        Tuple2.mcID.sp sp2;
        this.v = v;
        this.cols = cols;
        this.rows = rows;
        this.cellType = cellType;
        Grid.$init$(this);
        IterableTile.$init$(this);
        MappableTile.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        Tile.$init$(this);
        ConstantTile.$init$(this);
        Product.$init$((Product)this);
        ShortCells shortCells = cellType;
        if (shortCells instanceof ConstantNoData) {
            short n = v;
            int n2 = n == Short.MIN_VALUE ? Integer.MIN_VALUE : (int)n;
            short n3 = v;
            sp2 = new Tuple2.mcID.sp(n2, n3 == Short.MIN_VALUE ? Double.NaN : (double)n3);
        } else if (shortCells instanceof NoNoData) {
            sp2 = new Tuple2.mcID.sp((int)v, (double)v);
        } else if (shortCells instanceof ShortUserDefinedNoDataCellType) {
            ShortUserDefinedNoDataCellType shortUserDefinedNoDataCellType = (ShortUserDefinedNoDataCellType)shortCells;
            sp2 = shortUserDefinedNoDataCellType.noDataValue() == v ? new Tuple2.mcID.sp(Integer.MIN_VALUE, Double.NaN) : new Tuple2.mcID.sp((int)v, (double)v);
        } else {
            throw new MatchError((Object)shortCells);
        }
        Tuple2.mcID.sp sp3 = sp2;
        if (sp3 == null) {
            throw new MatchError((Object)sp3);
        }
        int iVal = sp3._1$mcI$sp();
        double dVal = sp3._2$mcD$sp();
        int n = iVal;
        double d = dVal;
        Tuple2.mcID.sp sp4 = new Tuple2.mcID.sp(n, d);
        this.x$19 = sp4;
        this.iVal = this.x$19._1$mcI$sp();
        this.dVal = this.x$19._2$mcD$sp();
    }
}

