/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import geotrellis.raster.CellSize;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.TileLayout$;
import geotrellis.vector.Extent;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\u0005}u!B\u0001\u0003\u0011\u00039\u0011A\u0003+jY\u0016d\u0015-_8vi*\u00111\u0001B\u0001\u0007e\u0006\u001cH/\u001a:\u000b\u0003\u0015\t!bZ3piJ,G\u000e\\5t\u0007\u0001\u0001\"\u0001C\u0005\u000e\u0003\t1QA\u0003\u0002\t\u0002-\u0011!\u0002V5mK2\u000b\u0017p\\;u'\rIAB\u0005\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u00055\u0019\u0012B\u0001\u000b\u000f\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u00151\u0012\u0002\"\u0001\u0018\u0003\u0019a\u0014N\\5u}Q\tq\u0001C\u0003\u001a\u0013\u0011\u0005!$\u0001\u0006tS:<G.\u001a+jY\u0016$RaGA-\u0003;\u0002\"\u0001\u0003\u000f\u0007\t)\u0011\u0001)H\n\u000591q\"\u0003\u0005\u0002\u000e?%\u0011\u0001E\u0004\u0002\b!J|G-^2u\u0011!\u0011CD!f\u0001\n\u0003\u0019\u0013A\u00037bs>,HoQ8mgV\tA\u0005\u0005\u0002\u000eK%\u0011aE\u0004\u0002\u0004\u0013:$\b\u0002\u0003\u0015\u001d\u0005#\u0005\u000b\u0011\u0002\u0013\u0002\u00171\f\u0017p\\;u\u0007>d7\u000f\t\u0005\tUq\u0011)\u001a!C\u0001G\u0005QA.Y=pkR\u0014vn^:\t\u00111b\"\u0011#Q\u0001\n\u0011\n1\u0002\\1z_V$(k\\<tA!Aa\u0006\bBK\u0002\u0013\u00051%\u0001\u0005uS2,7i\u001c7t\u0011!\u0001DD!E!\u0002\u0013!\u0013!\u0003;jY\u0016\u001cu\u000e\\:!\u0011!\u0011DD!f\u0001\n\u0003\u0019\u0013\u0001\u0003;jY\u0016\u0014vn^:\t\u0011Qb\"\u0011#Q\u0001\n\u0011\n\u0011\u0002^5mKJ{wo\u001d\u0011\t\u000bYaB\u0011\u0001\u001c\u0015\u000bm9\u0004(\u000f\u001e\t\u000b\t*\u0004\u0019\u0001\u0013\t\u000b)*\u0004\u0019\u0001\u0013\t\u000b9*\u0004\u0019\u0001\u0013\t\u000bI*\u0004\u0019\u0001\u0013\t\u000bqbB\u0011A\u001f\u0002\u000f%\u001cH+\u001b7fIV\ta\b\u0005\u0002\u000e\u007f%\u0011\u0001I\u0004\u0002\b\u0005>|G.Z1o\u0011\u0015\u0011E\u0004\"\u0001D\u0003%!x\u000e^1m\u0007>d7/F\u0001E!\tiQ)\u0003\u0002G\u001d\t!Aj\u001c8h\u0011\u0015AE\u0004\"\u0001D\u0003%!x\u000e^1m%><8\u000fC\u0003K9\u0011\u00051*\u0001\tmCf|W\u000f\u001e#j[\u0016t7/[8ogV\tA\n\u0005\u0003\u000e\u001b\u0012\"\u0013B\u0001(\u000f\u0005\u0019!V\u000f\u001d7fe!)\u0001\u000b\bC\u0001\u0017\u0006qA/\u001b7f\t&lWM\\:j_:\u001c\b\"\u0002*\u001d\t\u0003\u0019\u0013\u0001\u0003;jY\u0016\u001c\u0016N_3\t\u000bQcB\u0011A+\u0002\u0011\r,G\u000e\\*ju\u0016$\"AV-\u0011\u0005!9\u0016B\u0001-\u0003\u0005!\u0019U\r\u001c7TSj,\u0007\"\u0002.T\u0001\u0004Y\u0016AB3yi\u0016tG\u000f\u0005\u0002]?6\tQL\u0003\u0002_\t\u00051a/Z2u_JL!\u0001Y/\u0003\r\u0015CH/\u001a8u\u0011\u0015\u0011G\u0004\"\u0001d\u0003\u001d\u0019w.\u001c2j]\u0016$\"a\u00073\t\u000b\u0015\f\u0007\u0019A\u000e\u0002\u000b=$\b.\u001a:\t\u000f\u001dd\u0012\u0011!C\u0001Q\u0006!1m\u001c9z)\u0015Y\u0012N[6m\u0011\u001d\u0011c\r%AA\u0002\u0011BqA\u000b4\u0011\u0002\u0003\u0007A\u0005C\u0004/MB\u0005\t\u0019\u0001\u0013\t\u000fI2\u0007\u0013!a\u0001I!9a\u000eHI\u0001\n\u0003y\u0017AD2paf$C-\u001a4bk2$H%M\u000b\u0002a*\u0012A%]\u0016\u0002eB\u00111\u000f_\u0007\u0002i*\u0011QO^\u0001\nk:\u001c\u0007.Z2lK\u0012T!a\u001e\b\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002zi\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u000fmd\u0012\u0013!C\u0001_\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012\u0004bB?\u001d#\u0003%\ta\\\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134\u0011\u001dyH$%A\u0005\u0002=\fabY8qs\u0012\"WMZ1vYR$C\u0007C\u0005\u0002\u0004q\t\t\u0011\"\u0011\u0002\u0006\u0005i\u0001O]8ek\u000e$\bK]3gSb,\"!a\u0002\u0011\t\u0005%\u00111C\u0007\u0003\u0003\u0017QA!!\u0004\u0002\u0010\u0005!A.\u00198h\u0015\t\t\t\"\u0001\u0003kCZ\f\u0017\u0002BA\u000b\u0003\u0017\u0011aa\u0015;sS:<\u0007\u0002CA\r9\u0005\u0005I\u0011A\u0012\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\t\u0013\u0005uA$!A\u0005\u0002\u0005}\u0011A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0005\u0003C\t9\u0003E\u0002\u000e\u0003GI1!!\n\u000f\u0005\r\te.\u001f\u0005\n\u0003S\tY\"!AA\u0002\u0011\n1\u0001\u001f\u00132\u0011%\ti\u0003HA\u0001\n\u0003\ny#A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\t\t\u0004\u0005\u0004\u00024\u0005e\u0012\u0011E\u0007\u0003\u0003kQ1!a\u000e\u000f\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0003w\t)D\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0011%\ty\u0004HA\u0001\n\u0003\t\t%\u0001\u0005dC:,\u0015/^1m)\rq\u00141\t\u0005\u000b\u0003S\ti$!AA\u0002\u0005\u0005\u0002\"CA$9\u0005\u0005I\u0011IA%\u0003!A\u0017m\u001d5D_\u0012,G#\u0001\u0013\t\u0013\u00055C$!A\u0005B\u0005=\u0013\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\u0005\u001d\u0001\"CA*9\u0005\u0005I\u0011IA+\u0003\u0019)\u0017/^1mgR\u0019a(a\u0016\t\u0015\u0005%\u0012\u0011KA\u0001\u0002\u0004\t\t\u0003\u0003\u0004\u0002\\a\u0001\r\u0001J\u0001\u0005G>d7\u000f\u0003\u0004\u0002`a\u0001\r\u0001J\u0001\u0005e><8\u000f\u0003\u0004\u001a\u0013\u0011\u0005\u00111\r\u000b\u00047\u0005\u0015\u0004\u0002CA4\u0003C\u0002\r!!\u001b\u0002\u0005I,\u0007c\u0001\u0005\u0002l%\u0019\u0011Q\u000e\u0002\u0003\u0019I\u000b7\u000f^3s\u000bb$XM\u001c;\t\u0013\u0005E\u0014\"!A\u0005\u0002\u0006M\u0014!B1qa2LH#C\u000e\u0002v\u0005]\u0014\u0011PA>\u0011\u0019\u0011\u0013q\u000ea\u0001I!1!&a\u001cA\u0002\u0011BaALA8\u0001\u0004!\u0003B\u0002\u001a\u0002p\u0001\u0007A\u0005C\u0005\u0002\u0000%\t\t\u0011\"!\u0002\u0002\u00069QO\\1qa2LH\u0003BAB\u0003\u001f\u0003R!DAC\u0003\u0013K1!a\"\u000f\u0005\u0019y\u0005\u000f^5p]B9Q\"a#%I\u0011\"\u0013bAAG\u001d\t1A+\u001e9mKRB\u0011\"!%\u0002~\u0005\u0005\t\u0019A\u000e\u0002\u0007a$\u0003\u0007C\u0005\u0002\u0016&\t\t\u0011\"\u0003\u0002\u0018\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\tI\n\u0005\u0003\u0002\n\u0005m\u0015\u0002BAO\u0003\u0017\u0011aa\u00142kK\u000e$\b")
public class TileLayout
implements Product,
Serializable {
    private final int layoutCols;
    private final int layoutRows;
    private final int tileCols;
    private final int tileRows;

    public static Option<Tuple4<Object, Object, Object, Object>> unapply(TileLayout tileLayout) {
        return TileLayout$.MODULE$.unapply(tileLayout);
    }

    public static TileLayout apply(int n, int n2, int n3, int n4) {
        return TileLayout$.MODULE$.apply(n, n2, n3, n4);
    }

    public static TileLayout singleTile(RasterExtent rasterExtent) {
        return TileLayout$.MODULE$.singleTile(rasterExtent);
    }

    public static TileLayout singleTile(int n, int n2) {
        return TileLayout$.MODULE$.singleTile(n, n2);
    }

    public int layoutCols() {
        return this.layoutCols;
    }

    public int layoutRows() {
        return this.layoutRows;
    }

    public int tileCols() {
        return this.tileCols;
    }

    public int tileRows() {
        return this.tileRows;
    }

    public boolean isTiled() {
        return this.layoutCols() > 1 || this.layoutRows() > 1;
    }

    public long totalCols() {
        return (long)this.layoutCols() * (long)this.tileCols();
    }

    public long totalRows() {
        return (long)this.layoutRows() * (long)this.tileRows();
    }

    public Tuple2<Object, Object> layoutDimensions() {
        return new Tuple2.mcII.sp(this.layoutCols(), this.layoutRows());
    }

    public Tuple2<Object, Object> tileDimensions() {
        return new Tuple2.mcII.sp(this.tileCols(), this.tileRows());
    }

    public int tileSize() {
        return this.tileCols() * this.tileRows();
    }

    public CellSize cellSize(Extent extent) {
        return new CellSize(extent.width() / (double)this.totalCols(), extent.height() / (double)this.totalRows());
    }

    public TileLayout combine(TileLayout other) {
        int maxLayoutCols = this.layoutCols() > other.layoutCols() ? this.layoutCols() : other.layoutCols();
        int maxLayoutRows = this.layoutRows() > other.layoutRows() ? this.layoutRows() : other.layoutRows();
        int maxTileCols = this.tileCols() > other.tileCols() ? this.tileCols() : other.tileCols();
        int maxTileRows = this.tileRows() > other.tileRows() ? this.tileRows() : other.tileRows();
        return new TileLayout(maxLayoutCols, maxLayoutRows, maxTileCols, maxTileRows);
    }

    public TileLayout copy(int layoutCols, int layoutRows, int tileCols, int tileRows) {
        return new TileLayout(layoutCols, layoutRows, tileCols, tileRows);
    }

    public int copy$default$1() {
        return this.layoutCols();
    }

    public int copy$default$2() {
        return this.layoutRows();
    }

    public int copy$default$3() {
        return this.tileCols();
    }

    public int copy$default$4() {
        return this.tileRows();
    }

    public String productPrefix() {
        return "TileLayout";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Integer n;
        int n2 = x$1;
        switch (n2) {
            case 0: {
                n = BoxesRunTime.boxToInteger((int)this.layoutCols());
                break;
            }
            case 1: {
                n = BoxesRunTime.boxToInteger((int)this.layoutRows());
                break;
            }
            case 2: {
                n = BoxesRunTime.boxToInteger((int)this.tileCols());
                break;
            }
            case 3: {
                n = BoxesRunTime.boxToInteger((int)this.tileRows());
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return n;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TileLayout;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.layoutCols());
        n = Statics.mix((int)n, (int)this.layoutRows());
        n = Statics.mix((int)n, (int)this.tileCols());
        n = Statics.mix((int)n, (int)this.tileRows());
        return Statics.finalizeHash((int)n, (int)4);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TileLayout)) return false;
        boolean bl = true;
        if (!bl) return false;
        TileLayout tileLayout = (TileLayout)x$1;
        if (this.layoutCols() != tileLayout.layoutCols()) return false;
        if (this.layoutRows() != tileLayout.layoutRows()) return false;
        if (this.tileCols() != tileLayout.tileCols()) return false;
        if (this.tileRows() != tileLayout.tileRows()) return false;
        if (!tileLayout.canEqual(this)) return false;
        return true;
    }

    public TileLayout(int layoutCols, int layoutRows, int tileCols, int tileRows) {
        this.layoutCols = layoutCols;
        this.layoutRows = layoutRows;
        this.tileCols = tileCols;
        this.tileRows = tileRows;
        Product.$init$((Product)this);
        Predef$.MODULE$.require(layoutCols > 0 && layoutRows > 0 && tileCols > 0 && tileRows > 0, (Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(57).append("TileLayout should contain only cols and rows number > 0: ").append(this.toString()).toString());
    }
}

