/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.ByteArrayTile$;
import geotrellis.raster.ByteCells;
import geotrellis.raster.CellSet;
import geotrellis.raster.DataType;
import geotrellis.raster.Grid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.IterableTile;
import geotrellis.raster.MappableTile;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.UByteArrayTile$;
import geotrellis.raster.UByteCells;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005ud!B\u0001\u0003\u0003\u00039!AD+CsR,\u0017I\u001d:bsRKG.\u001a\u0006\u0003\u0007\u0011\taA]1ti\u0016\u0014(\"A\u0003\u0002\u0015\u001d,w\u000e\u001e:fY2L7o\u0001\u0001\u0014\u0007\u0001Aa\u0002\u0005\u0002\n\u00195\t!BC\u0001\f\u0003\u0015\u00198-\u00197b\u0013\ti!B\u0001\u0004B]f\u0014VM\u001a\t\u0003\u001fAi\u0011AA\u0005\u0003#\t\u0011\u0001#T;uC\ndW-\u0011:sCf$\u0016\u000e\\3\t\u0011M\u0001!Q1A\u0005\u0002Q\tQ!\u0019:sCf,\u0012!\u0006\t\u0004\u0013YA\u0012BA\f\u000b\u0005\u0015\t%O]1z!\tI\u0011$\u0003\u0002\u001b\u0015\t!!)\u001f;f\u0011!a\u0002A!A!\u0002\u0013)\u0012AB1se\u0006L\b\u0005\u0003\u0005\u001f\u0001\t\u0005\t\u0015!\u0003 \u0003\u0011\u0019w\u000e\\:\u0011\u0005%\u0001\u0013BA\u0011\u000b\u0005\rIe\u000e\u001e\u0005\tG\u0001\u0011\t\u0011)A\u0005?\u0005!!o\\<t\u0011\u0015)\u0003\u0001\"\u0001'\u0003\u0019a\u0014N\\5u}Q!q\u0005K\u0015+!\ty\u0001\u0001C\u0003\u0014I\u0001\u0007Q\u0003C\u0003\u001fI\u0001\u0007q\u0004C\u0003$I\u0001\u0007q\u0004C\u0004-\u0001\t\u0007i\u0011A\u0017\u0002\u0011\r,G\u000e\u001c+za\u0016,\u0012A\f\n\u0004_E\"d\u0001\u0002\u0019\u0001\u00019\u0012A\u0002\u0010:fM&tW-\\3oiz\u0002\"a\u0004\u001a\n\u0005M\u0012!AC+CsR,7)\u001a7mgB\u0011q\"N\u0005\u0003m\t\u0011aBT8ECR\f\u0007*\u00198eY&tw\rC\u00039\u0001\u0011\u0005\u0011(A\u0004u_\nKH/Z:\u0015\u0003UAQa\u000f\u0001\u0005\u0002q\nAaY8qsV\tq\u0005C\u0003?\u0001\u0011\u0005q(\u0001\u0006xSRDgj\u001c#bi\u0006$\"\u0001Q\"\u0011\u0005=\t\u0015B\u0001\"\u0003\u0005\u0011!\u0016\u000e\\3\t\u000b\u0011k\u0004\u0019A#\u0002\u00179|G)\u0019;b-\u0006dW/\u001a\t\u0004\u0013\u0019C\u0015BA$\u000b\u0005\u0019y\u0005\u000f^5p]B\u0011\u0011\"S\u0005\u0003\u0015*\u0011a\u0001R8vE2,\u0007\"\u0002'\u0001\t\u0003i\u0015aC5oi\u0016\u0014\bO]3u\u0003N$\"\u0001\u0011(\t\u000b=[\u0005\u0019\u0001)\u0002\u00179,woQ3mYRK\b/\u001a\t\u0003#Rs!a\u0004*\n\u0005M\u0013\u0011a\u00029bG.\fw-Z\u0005\u0003+Z\u0013\u0001bQ3mYRK\b/\u001a\u0006\u0003'\n9Q\u0001\u0017\u0002\t\u0002e\u000ba\"\u0016\"zi\u0016\f%O]1z)&dW\r\u0005\u0002\u00105\u001a)\u0011A\u0001E\u00017N\u0019!\f\u0003/\u0011\u0005%i\u0016B\u00010\u000b\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011\u0015)#\f\"\u0001a)\u0005I\u0006\"\u00022[\t\u0003\u0019\u0017!B1qa2LH\u0003B\u0014eM\u001eDQ!Z1A\u0002U\t1!\u0019:s\u0011\u0015q\u0012\r1\u0001 \u0011\u0015\u0019\u0013\r1\u0001 \u0011\u0015\u0011'\f\"\u0001j)\u00159#n\u001b7n\u0011\u0015)\u0007\u000e1\u0001\u0016\u0011\u0015q\u0002\u000e1\u0001 \u0011\u0015\u0019\u0003\u000e1\u0001 \u0011\u0015a\u0003\u000e1\u0001o%\ry\u0017\u0007\u000e\u0004\u0005ai\u0003a\u000eC\u0003c5\u0012\u0005\u0011\u000fF\u0003(eN$X\u000fC\u0003fa\u0002\u0007Q\u0003C\u0003\u001fa\u0002\u0007q\u0004C\u0003$a\u0002\u0007q\u0004C\u0003Ea\u0002\u0007a\u000fE\u0002\n\rbAQA\u0019.\u0005\u0002a$RaJ={wrDQ!Z<A\u0002UAQAH<A\u0002}AQaI<A\u0002}AQ\u0001R<A\u0002aAQA .\u0005\u0002}\fQa\u001c4ES6$RaJA\u0001\u0003\u0007AQAH?A\u0002}AQaI?A\u0002}AaA .\u0005\u0002\u0005\u001dAcB\u0014\u0002\n\u0005-\u0011Q\u0002\u0005\u0007=\u0005\u0015\u0001\u0019A\u0010\t\r\r\n)\u00011\u0001 \u0011\u001da\u0013Q\u0001a\u0001\u0003\u001f\u0011B!!\u00052i\u0019)\u0001G\u0017\u0001\u0002\u0010!9\u0011Q\u0003.\u0005\u0002\u0005]\u0011!B3naRLH#B\u0014\u0002\u001a\u0005m\u0001B\u0002\u0010\u0002\u0014\u0001\u0007q\u0004\u0003\u0004$\u0003'\u0001\ra\b\u0005\b\u0003+QF\u0011AA\u0010)\u001d9\u0013\u0011EA\u0012\u0003KAaAHA\u000f\u0001\u0004y\u0002BB\u0012\u0002\u001e\u0001\u0007q\u0004C\u0004-\u0003;\u0001\r!a\n\u0013\t\u0005%\u0012\u0007\u000e\u0004\u0006ai\u0003\u0011q\u0005\u0005\b\u0003[QF\u0011AA\u0018\u0003\u00111\u0017\u000e\u001c7\u0015\u000f\u001d\n\t$!\u000e\u00028!9\u00111GA\u0016\u0001\u0004A\u0012!\u0001<\t\ry\tY\u00031\u0001 \u0011\u0019\u0019\u00131\u0006a\u0001?!9\u0011Q\u0006.\u0005\u0002\u0005mB#C\u0014\u0002>\u0005}\u0012\u0011IA\"\u0011\u001d\t\u0019$!\u000fA\u0002aAaAHA\u001d\u0001\u0004y\u0002BB\u0012\u0002:\u0001\u0007q\u0004C\u0004-\u0003s\u0001\r!!\u0012\u0013\t\u0005\u001d\u0013\u0007\u000e\u0004\u0006ai\u0003\u0011Q\t\u0005\b\u0003\u0017RF\u0011AA'\u0003%1'o\\7CsR,7\u000fF\u0004(\u0003\u001f\n\u0019&!\u0016\t\u000f\u0005E\u0013\u0011\na\u0001+\u0005)!-\u001f;fg\"1a$!\u0013A\u0002}AaaIA%\u0001\u0004y\u0002bBA&5\u0012\u0005\u0011\u0011\f\u000b\nO\u0005m\u0013QLA0\u0003CBq!!\u0015\u0002X\u0001\u0007Q\u0003\u0003\u0004\u001f\u0003/\u0002\ra\b\u0005\u0007G\u0005]\u0003\u0019A\u0010\t\u000f1\n9\u00061\u0001\u0002dI!\u0011QM\u00195\r\u0015\u0001$\fAA2\u0011%\tIGWA\u0001\n\u0013\tY'A\u0006sK\u0006$'+Z:pYZ,GCAA7!\u0011\ty'!\u001f\u000e\u0005\u0005E$\u0002BA:\u0003k\nA\u0001\\1oO*\u0011\u0011qO\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002|\u0005E$AB(cU\u0016\u001cG\u000f")
public abstract class UByteArrayTile
implements MutableArrayTile {
    private final byte[] array;
    private final int cols;
    private final int rows;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static UByteArrayTile fromBytes(byte[] byArray, int n, int n2, UByteCells uByteCells) {
        return UByteArrayTile$.MODULE$.fromBytes(byArray, n, n2, uByteCells);
    }

    public static UByteArrayTile fromBytes(byte[] byArray, int n, int n2) {
        return UByteArrayTile$.MODULE$.fromBytes(byArray, n, n2);
    }

    public static UByteArrayTile fill(byte by, int n, int n2, UByteCells uByteCells) {
        return UByteArrayTile$.MODULE$.fill(by, n, n2, uByteCells);
    }

    public static UByteArrayTile fill(byte by, int n, int n2) {
        return UByteArrayTile$.MODULE$.fill(by, n, n2);
    }

    public static UByteArrayTile empty(int n, int n2, UByteCells uByteCells) {
        return UByteArrayTile$.MODULE$.empty(n, n2, uByteCells);
    }

    public static UByteArrayTile empty(int n, int n2) {
        return UByteArrayTile$.MODULE$.empty(n, n2);
    }

    public static UByteArrayTile ofDim(int n, int n2, UByteCells uByteCells) {
        return UByteArrayTile$.MODULE$.ofDim(n, n2, uByteCells);
    }

    public static UByteArrayTile ofDim(int n, int n2) {
        return UByteArrayTile$.MODULE$.ofDim(n, n2);
    }

    @Override
    public MutableArrayTile mutable() {
        return MutableArrayTile.mutable$(this);
    }

    @Override
    public void set(int col, int row, int value) {
        MutableArrayTile.set$(this, col, row, value);
    }

    @Override
    public void setDouble(int col, int row, double value) {
        MutableArrayTile.setDouble$(this, col, row, value);
    }

    @Override
    public void update(int colOffset, int rowOffset, Tile update) {
        MutableArrayTile.update$(this, colOffset, rowOffset, update);
    }

    @Override
    public ArrayTile toArrayTile() {
        return ArrayTile.toArrayTile$(this);
    }

    @Override
    public ArrayTile convert(DataType targetCellType) {
        return ArrayTile.convert$(this, targetCellType);
    }

    @Override
    public void foreach(Function1<Object, BoxedUnit> f) {
        ArrayTile.foreach$(this, f);
    }

    @Override
    public void foreachDouble(Function1<Object, BoxedUnit> f) {
        ArrayTile.foreachDouble$(this, f);
    }

    @Override
    public void foreachIntVisitor(IntTileVisitor visitor) {
        ArrayTile.foreachIntVisitor$(this, visitor);
    }

    @Override
    public void foreachDoubleVisitor(DoubleTileVisitor visitor) {
        ArrayTile.foreachDoubleVisitor$(this, visitor);
    }

    @Override
    public Tile map(Function1<Object, Object> f) {
        return ArrayTile.map$(this, f);
    }

    @Override
    public Tile mapDouble(Function1<Object, Object> f) {
        return ArrayTile.mapDouble$(this, f);
    }

    @Override
    public Tile mapIntMapper(IntTileMapper mapper) {
        return ArrayTile.mapIntMapper$(this, mapper);
    }

    @Override
    public Tile mapDoubleMapper(DoubleTileMapper mapper) {
        return ArrayTile.mapDoubleMapper$(this, mapper);
    }

    @Override
    public ArrayTile combine(ArrayTile other, Function2<Object, Object, Object> f) {
        return ArrayTile.combine$((ArrayTile)this, other, f);
    }

    @Override
    public Tile combine(Tile other, Function2<Object, Object, Object> f) {
        return ArrayTile.combine$((ArrayTile)this, other, f);
    }

    @Override
    public ArrayTile combineDouble(ArrayTile other, Function2<Object, Object, Object> f) {
        return ArrayTile.combineDouble$((ArrayTile)this, other, f);
    }

    @Override
    public Tile combineDouble(Tile other, Function2<Object, Object, Object> f) {
        return ArrayTile.combineDouble$((ArrayTile)this, other, f);
    }

    @Override
    public boolean equals(Object other) {
        return ArrayTile.equals$(this, other);
    }

    @Override
    public int get(int col, int row) {
        return ArrayTile.get$(this, col, row);
    }

    @Override
    public double getDouble(int col, int row) {
        return ArrayTile.getDouble$(this, col, row);
    }

    @Override
    public List<Object> toList() {
        return ArrayTile.toList$(this);
    }

    @Override
    public List<Object> toListDouble() {
        return ArrayTile.toListDouble$(this);
    }

    @Override
    public int[] toArray() {
        return ArrayTile.toArray$(this);
    }

    @Override
    public double[] toArrayDouble() {
        return ArrayTile.toArrayDouble$(this);
    }

    @Override
    public void dualForeach(Function1<Object, BoxedUnit> f, Function1<Object, BoxedUnit> g) {
        Tile.dualForeach$(this, f, g);
    }

    @Override
    public Tile mapIfSet(Function1<Object, Object> f) {
        return Tile.mapIfSet$(this, f);
    }

    @Override
    public Tile mapIfSetDouble(Function1<Object, Object> f) {
        return Tile.mapIfSetDouble$(this, f);
    }

    @Override
    public Tile dualMap(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile.dualMap$(this, f, g);
    }

    @Override
    public Tile dualMapIfSet(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile.dualMapIfSet$(this, f, g);
    }

    @Override
    public Tile dualCombine(Tile r2, Function2<Object, Object, Object> f, Function2<Object, Object, Object> g) {
        return Tile.dualCombine$(this, r2, f, g);
    }

    @Override
    public boolean isNoDataTile() {
        return Tile.isNoDataTile$(this);
    }

    @Override
    public Tile normalize(int oldMin, int oldMax, int newMin, int newMax) {
        return Tile.normalize$((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile normalize(double oldMin, double oldMax, double newMin, double newMax) {
        return Tile.normalize$((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile rescale(int newMin, int newMax) {
        return Tile.rescale$((Tile)this, newMin, newMax);
    }

    @Override
    public Tile rescale(double newMin, double newMax) {
        return Tile.rescale$((Tile)this, newMin, newMax);
    }

    @Override
    public Tile downsample(int newCols, int newRows, Function1<CellSet, Object> f) {
        return Tile.downsample$(this, newCols, newRows, f);
    }

    @Override
    public Tuple2<Object, Object> findMinMax() {
        return Tile.findMinMax$(this);
    }

    @Override
    public Tuple2<Object, Object> findMinMaxDouble() {
        return Tile.findMinMaxDouble$(this);
    }

    @Override
    public int size() {
        return Grid.size$(this);
    }

    @Override
    public Tuple2<Object, Object> dimensions() {
        return Grid.dimensions$(this);
    }

    @Override
    public GridBounds gridBounds() {
        return Grid.gridBounds$(this);
    }

    private Logger logger$lzycompute() {
        UByteArrayTile uByteArrayTile = this;
        synchronized (uByteArrayTile) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public byte[] array() {
        return this.array;
    }

    public abstract UByteCells cellType();

    @Override
    public byte[] toBytes() {
        return (byte[])this.array().clone();
    }

    @Override
    public UByteArrayTile copy() {
        return UByteArrayTile$.MODULE$.apply((byte[])this.array().clone(), this.cols, this.rows, this.cellType());
    }

    @Override
    public Tile withNoData(Option<Object> noDataValue) {
        return UByteArrayTile$.MODULE$.apply(this.array(), this.cols, this.rows, this.cellType().withNoData(noDataValue));
    }

    @Override
    public Tile interpretAs(DataType newCellType) {
        Tile tile;
        DataType dataType = newCellType;
        if (dataType instanceof ByteCells) {
            ByteCells byteCells = (ByteCells)((Object)dataType);
            tile = ByteArrayTile$.MODULE$.apply(this.array(), this.cols, this.rows, byteCells);
        } else if (dataType instanceof UByteCells) {
            UByteCells uByteCells = (UByteCells)((Object)dataType);
            tile = UByteArrayTile$.MODULE$.apply(this.array(), this.cols, this.rows, uByteCells);
        } else {
            tile = this.withNoData((Option<Object>)None$.MODULE$).convert(newCellType);
        }
        return tile;
    }

    public UByteArrayTile(byte[] array, int cols, int rows) {
        this.array = array;
        this.cols = cols;
        this.rows = rows;
        Grid.$init$(this);
        IterableTile.$init$(this);
        MappableTile.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        Tile.$init$(this);
        ArrayTile.$init$(this);
        MutableArrayTile.$init$(this);
    }
}

