/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.ByteConstantTile;
import geotrellis.raster.ByteConstantTile$;
import geotrellis.raster.CellSet;
import geotrellis.raster.ConstantNoData;
import geotrellis.raster.ConstantTile;
import geotrellis.raster.DataType;
import geotrellis.raster.Grid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.IterableTile;
import geotrellis.raster.MappableTile;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.NoNoData;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.Tile;
import geotrellis.raster.UByteArrayTile$;
import geotrellis.raster.UByteCells;
import geotrellis.raster.UByteConstantTile$;
import geotrellis.raster.UByteUserDefinedNoDataCellType;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.vector.Extent;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\tUb\u0001B\u0001\u0003\u0001\u001e\u0011\u0011#\u0016\"zi\u0016\u001cuN\\:uC:$H+\u001b7f\u0015\t\u0019A!\u0001\u0004sCN$XM\u001d\u0006\u0002\u000b\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001M)\u0001\u0001\u0003\b\u0013+A\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\t\u000e\u0003\tI!!\u0005\u0002\u0003\u0019\r{gn\u001d;b]R$\u0016\u000e\\3\u0011\u0005%\u0019\u0012B\u0001\u000b\u000b\u0005\u001d\u0001&o\u001c3vGR\u0004\"!\u0003\f\n\u0005]Q!\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002C\r\u0001\u0005+\u0007I\u0011\u0001\u000e\u0002\u0003Y,\u0012a\u0007\t\u0003\u0013qI!!\b\u0006\u0003\t\tKH/\u001a\u0005\t?\u0001\u0011\t\u0012)A\u00057\u0005\u0011a\u000f\t\u0005\tC\u0001\u0011)\u001a!C\u0001E\u0005!1m\u001c7t+\u0005\u0019\u0003CA\u0005%\u0013\t)#BA\u0002J]RD\u0001b\n\u0001\u0003\u0012\u0003\u0006IaI\u0001\u0006G>d7\u000f\t\u0005\tS\u0001\u0011)\u001a!C\u0001E\u0005!!o\\<t\u0011!Y\u0003A!E!\u0002\u0013\u0019\u0013!\u0002:poN\u0004\u0003\u0002C\u0017\u0001\u0005+\u0007I\u0011\u0001\u0018\u0002\u0011\r,G\u000e\u001c+za\u0016,\u0012a\f\n\u0004aI*d\u0001B\u0019\u0001\u0001=\u0012A\u0002\u0010:fM&tW-\\3oiz\u0002\"aD\u001a\n\u0005Q\u0012!AC+CsR,7)\u001a7mgB\u0011qBN\u0005\u0003o\t\u0011aBT8ECR\f\u0007*\u00198eY&tw\r\u0003\u0005:\u0001\tE\t\u0015!\u00030\u0003%\u0019W\r\u001c7UsB,\u0007\u0005C\u0003<\u0001\u0011\u0005A(\u0001\u0004=S:LGO\u0010\u000b\u0006{yz\u0004)\u0011\t\u0003\u001f\u0001AQ!\u0007\u001eA\u0002mAQ!\t\u001eA\u0002\rBQ!\u000b\u001eA\u0002\rBq!\f\u001e\u0011\u0002\u0003\u0007!IE\u0002DeU2A!\r\u0001\u0001\u0005\"QQ\t\u0001I\u0001\u0002\u0007\u0005\u000b\u0011\u0002$\u0002\ta$\u0013\u0007\u000f\t\u0005\u0013\u001d\u001b\u0013*\u0003\u0002I\u0015\t1A+\u001e9mKJ\u0002\"!\u0003&\n\u0005-S!A\u0002#pk\ndW\rC\u0004N\u0001\t\u0007I\u0011\u0003\u0012\u0002\t%4\u0016\r\u001c\u0005\u0007\u001f\u0002\u0001\u000b\u0011B\u0012\u0002\u000b%4\u0016\r\u001c\u0011\t\u000fE\u0003!\u0019!C\t%\u0006!AMV1m+\u0005I\u0005B\u0002+\u0001A\u0003%\u0011*A\u0003e-\u0006d\u0007\u0005C\u0003W\u0001\u0011\u0005q+A\u0006u_\u0006\u0013(/Y=US2,G#\u0001-\u0011\u0005=I\u0016B\u0001.\u0003\u0005%\t%O]1z)&dW\rC\u0003]\u0001\u0011\u0005Q,A\u0004nkR\f'\r\\3\u0016\u0003y\u0003\"aD0\n\u0005\u0001\u0014!\u0001E'vi\u0006\u0014G.Z!se\u0006LH+\u001b7f\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0003\u001d!xNQ=uKN$\u0012\u0001\u001a\t\u0004\u0013\u0015\\\u0012B\u00014\u000b\u0005\u0015\t%O]1z\u0011\u0015A\u0007\u0001\"\u0001j\u0003!\u0011Xm]1na2,G\u0003\u00026nkj\u0004\"aD6\n\u00051\u0014!\u0001\u0002+jY\u0016DQA\\4A\u0002=\fqaY;se\u0016tG\u000f\u0005\u0002qg6\t\u0011O\u0003\u0002s\t\u00051a/Z2u_JL!\u0001^9\u0003\r\u0015CH/\u001a8u\u0011\u00151x\r1\u0001x\u0003\u0019!\u0018M]4fiB\u0011q\u0002_\u0005\u0003s\n\u0011ABU1ti\u0016\u0014X\t\u001f;f]RDQa_4A\u0002q\fa!\\3uQ>$\u0007CA?\u0000\u001b\u0005q(B\u00015\u0003\u0013\r\t\tA \u0002\u000f%\u0016\u001c\u0018-\u001c9mK6+G\u000f[8e\u0011\u001d\t)\u0001\u0001C\u0001\u0003\u000f\t!b^5uQ:{G)\u0019;b)\ri\u0014\u0011\u0002\u0005\t\u0003\u0017\t\u0019\u00011\u0001\u0002\u000e\u0005Yan\u001c#bi\u00064\u0016\r\\;f!\u0011I\u0011qB%\n\u0007\u0005E!B\u0001\u0004PaRLwN\u001c\u0005\b\u0003+\u0001A\u0011AA\f\u0003\ri\u0017\r\u001d\u000b\u0004U\u0006e\u0001\u0002CA\u000e\u0003'\u0001\r!!\b\u0002\u0003\u0019\u0004R!CA\u0010G\rJ1!!\t\u000b\u0005%1UO\\2uS>t\u0017\u0007C\u0004\u0002&\u0001!\t!a\n\u0002\u00135\f\u0007\u000fR8vE2,Gc\u00016\u0002*!A\u00111DA\u0012\u0001\u0004\tY\u0003E\u0003\n\u0003?I\u0015\nC\u0005\u00020\u0001\t\t\u0011\"\u0001\u00022\u0005!1m\u001c9z)%i\u00141GA\u001b\u0003o\tI\u0004\u0003\u0005\u001a\u0003[\u0001\n\u00111\u0001\u001c\u0011!\t\u0013Q\u0006I\u0001\u0002\u0004\u0019\u0003\u0002C\u0015\u0002.A\u0005\t\u0019A\u0012\t\u00115\ni\u0003%AA\u0002\tC\u0011\"!\u0010\u0001#\u0003%\t!a\u0010\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011\u0011\t\u0016\u00047\u0005\r3FAA#!\u0011\t9%!\u0015\u000e\u0005\u0005%#\u0002BA&\u0003\u001b\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005=#\"\u0001\u0006b]:|G/\u0019;j_:LA!a\u0015\u0002J\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005]\u0003!%A\u0005\u0002\u0005e\u0013AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u00037R3aIA\"\u0011%\ty\u0006AI\u0001\n\u0003\tI&\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\t\u0013\u0005\r\u0004!%A\u0005\u0002\u0005\u0015\u0014AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003OR3aLA\"\u0011%\tY\u0007AA\u0001\n\u0003\ni'A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003_\u0002B!!\u001d\u0002|5\u0011\u00111\u000f\u0006\u0005\u0003k\n9(\u0001\u0003mC:<'BAA=\u0003\u0011Q\u0017M^1\n\t\u0005u\u00141\u000f\u0002\u0007'R\u0014\u0018N\\4\t\u0011\u0005\u0005\u0005!!A\u0005\u0002\t\nA\u0002\u001d:pIV\u001cG/\u0011:jifD\u0011\"!\"\u0001\u0003\u0003%\t!a\"\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011\u0011RAH!\rI\u00111R\u0005\u0004\u0003\u001bS!aA!os\"I\u0011\u0011SAB\u0003\u0003\u0005\raI\u0001\u0004q\u0012\n\u0004\"CAK\u0001\u0005\u0005I\u0011IAL\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAM!\u0019\tY*!)\u0002\n6\u0011\u0011Q\u0014\u0006\u0004\u0003?S\u0011AC2pY2,7\r^5p]&!\u00111UAO\u0005!IE/\u001a:bi>\u0014\b\"CAT\u0001\u0005\u0005I\u0011AAU\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAV\u0003c\u00032!CAW\u0013\r\tyK\u0003\u0002\b\u0005>|G.Z1o\u0011)\t\t*!*\u0002\u0002\u0003\u0007\u0011\u0011\u0012\u0005\n\u0003k\u0003\u0011\u0011!C!\u0003o\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002G!I\u00111\u0018\u0001\u0002\u0002\u0013\u0005\u0013QX\u0001\ti>\u001cFO]5oOR\u0011\u0011q\u000e\u0005\n\u0003\u0003\u0004\u0011\u0011!C!\u0003\u0007\fa!Z9vC2\u001cH\u0003BAV\u0003\u000bD!\"!%\u0002@\u0006\u0005\t\u0019AAE\u000f\u001d\tIM\u0001E\u0001\u0003\u0017\f\u0011#\u0016\"zi\u0016\u001cuN\\:uC:$H+\u001b7f!\ry\u0011Q\u001a\u0004\u0007\u0003\tA\t!a4\u0014\t\u00055\u0007\"\u0006\u0005\bw\u00055G\u0011AAj)\t\tY\r\u0003\u0005\u0002X\u00065G\u0011AAm\u0003%1'o\\7CsR,7\u000fF\u0005>\u00037\fy.!9\u0002d\"9\u0011Q\\Ak\u0001\u0004!\u0017!\u00022zi\u0016\u001c\bBB\u0011\u0002V\u0002\u00071\u0005\u0003\u0004*\u0003+\u0004\ra\t\u0005\b[\u0005U\u0007\u0019AAs%\u0011\t9OM\u001b\u0007\rE\ni\rAAs\u0011)\tY/!4\u0002\u0002\u0013\u0005\u0015Q^\u0001\u0006CB\u0004H.\u001f\u000b\n{\u0005=\u0018\u0011_Az\u0003kDa!GAu\u0001\u0004Y\u0002BB\u0011\u0002j\u0002\u00071\u0005\u0003\u0004*\u0003S\u0004\ra\t\u0005\n[\u0005%\b\u0013!a\u0001\u0003o\u0014B!!?3k\u00191\u0011'!4\u0001\u0003oD!\"!@\u0002N\u0006\u0005I\u0011QA\u0000\u0003\u001d)h.\u00199qYf$BA!\u0001\u0003\u000eA)\u0011\"a\u0004\u0003\u0004AA\u0011B!\u0002\u001cG\r\u0012I!C\u0002\u0003\b)\u0011a\u0001V;qY\u0016$$\u0003\u0002B\u0006eU2a!MAg\u0001\t%\u0001\"\u0003B\b\u0003w\f\t\u00111\u0001>\u0003\rAH\u0005\r\u0005\u000b\u0005'\ti-%A\u0005\u0002\tU\u0011aD1qa2LH\u0005Z3gCVdG\u000f\n\u001b\u0016\u0005\t]!\u0006\u0002B\r\u0003\u0007\u0012BAa\u00073k\u00191\u0011'!4\u0001\u00053A!Ba\b\u0002NF\u0005I\u0011\u0001B\u0011\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011!1\u0005\u0016\u0005\u0005K\t\u0019E\u0005\u0003\u0003(I*dAB\u0019\u0002N\u0002\u0011)\u0003\u0003\u0006\u0003,\u00055\u0017\u0011!C\u0005\u0005[\t1B]3bIJ+7o\u001c7wKR\u0011!q\u0006\t\u0005\u0003c\u0012\t$\u0003\u0003\u00034\u0005M$AB(cU\u0016\u001cG\u000f")
public class UByteConstantTile
implements ConstantTile,
Product {
    private final byte v;
    private final int cols;
    private final int rows;
    private final UByteCells cellType;
    private final /* synthetic */ Tuple2 x$18;
    private final int iVal;
    private final double dVal;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static UByteCells $lessinit$greater$default$4() {
        return UByteConstantTile$.MODULE$.$lessinit$greater$default$4();
    }

    public static UByteCells apply$default$4() {
        return UByteConstantTile$.MODULE$.apply$default$4();
    }

    public static Option<Tuple4<Object, Object, Object, UByteCells>> unapply(UByteConstantTile uByteConstantTile) {
        return UByteConstantTile$.MODULE$.unapply(uByteConstantTile);
    }

    public static UByteConstantTile apply(byte by, int n, int n2, UByteCells uByteCells) {
        return UByteConstantTile$.MODULE$.apply(by, n, n2, uByteCells);
    }

    public static UByteConstantTile fromBytes(byte[] byArray, int n, int n2, UByteCells uByteCells) {
        return UByteConstantTile$.MODULE$.fromBytes(byArray, n, n2, uByteCells);
    }

    @Override
    public int get(int col, int row) {
        return ConstantTile.get$(this, col, row);
    }

    @Override
    public double getDouble(int col, int row) {
        return ConstantTile.getDouble$(this, col, row);
    }

    @Override
    public int[] toArray() {
        return ConstantTile.toArray$(this);
    }

    @Override
    public double[] toArrayDouble() {
        return ConstantTile.toArrayDouble$(this);
    }

    @Override
    public Tile convert(DataType newType) {
        return ConstantTile.convert$(this, newType);
    }

    @Override
    public Tile interpretAs(DataType newCellType) {
        return ConstantTile.interpretAs$(this, newCellType);
    }

    @Override
    public void foreach(Function1<Object, BoxedUnit> f) {
        ConstantTile.foreach$(this, f);
    }

    @Override
    public void foreachDouble(Function1<Object, BoxedUnit> f) {
        ConstantTile.foreachDouble$(this, f);
    }

    @Override
    public void foreachIntVisitor(IntTileVisitor visitor) {
        ConstantTile.foreachIntVisitor$(this, visitor);
    }

    @Override
    public void foreachDoubleVisitor(DoubleTileVisitor visitor) {
        ConstantTile.foreachDoubleVisitor$(this, visitor);
    }

    @Override
    public Tile combine(Tile other, Function2<Object, Object, Object> f) {
        return ConstantTile.combine$(this, other, f);
    }

    @Override
    public Tile combineDouble(Tile other, Function2<Object, Object, Object> f) {
        return ConstantTile.combineDouble$(this, other, f);
    }

    @Override
    public Tile mapIntMapper(IntTileMapper mapper) {
        return ConstantTile.mapIntMapper$(this, mapper);
    }

    @Override
    public Tile mapDoubleMapper(DoubleTileMapper mapper) {
        return ConstantTile.mapDoubleMapper$(this, mapper);
    }

    @Override
    public void dualForeach(Function1<Object, BoxedUnit> f, Function1<Object, BoxedUnit> g) {
        Tile.dualForeach$(this, f, g);
    }

    @Override
    public Tile mapIfSet(Function1<Object, Object> f) {
        return Tile.mapIfSet$(this, f);
    }

    @Override
    public Tile mapIfSetDouble(Function1<Object, Object> f) {
        return Tile.mapIfSetDouble$(this, f);
    }

    @Override
    public Tile dualMap(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile.dualMap$(this, f, g);
    }

    @Override
    public Tile dualMapIfSet(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile.dualMapIfSet$(this, f, g);
    }

    @Override
    public Tile dualCombine(Tile r2, Function2<Object, Object, Object> f, Function2<Object, Object, Object> g) {
        return Tile.dualCombine$(this, r2, f, g);
    }

    @Override
    public boolean isNoDataTile() {
        return Tile.isNoDataTile$(this);
    }

    @Override
    public Tile normalize(int oldMin, int oldMax, int newMin, int newMax) {
        return Tile.normalize$((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile normalize(double oldMin, double oldMax, double newMin, double newMax) {
        return Tile.normalize$((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile rescale(int newMin, int newMax) {
        return Tile.rescale$((Tile)this, newMin, newMax);
    }

    @Override
    public Tile rescale(double newMin, double newMax) {
        return Tile.rescale$((Tile)this, newMin, newMax);
    }

    @Override
    public Tile downsample(int newCols, int newRows, Function1<CellSet, Object> f) {
        return Tile.downsample$(this, newCols, newRows, f);
    }

    @Override
    public Tuple2<Object, Object> findMinMax() {
        return Tile.findMinMax$(this);
    }

    @Override
    public Tuple2<Object, Object> findMinMaxDouble() {
        return Tile.findMinMaxDouble$(this);
    }

    @Override
    public int size() {
        return Grid.size$(this);
    }

    @Override
    public Tuple2<Object, Object> dimensions() {
        return Grid.dimensions$(this);
    }

    @Override
    public GridBounds gridBounds() {
        return Grid.gridBounds$(this);
    }

    private Logger logger$lzycompute() {
        UByteConstantTile uByteConstantTile = this;
        synchronized (uByteConstantTile) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public byte v() {
        return this.v;
    }

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    public UByteCells cellType() {
        return this.cellType;
    }

    @Override
    public int iVal() {
        return this.iVal;
    }

    @Override
    public double dVal() {
        return this.dVal;
    }

    @Override
    public ArrayTile toArrayTile() {
        return this.mutable();
    }

    @Override
    public MutableArrayTile mutable() {
        return UByteArrayTile$.MODULE$.fill(this.v(), this.cols(), this.rows(), this.cellType());
    }

    @Override
    public byte[] toBytes() {
        return new byte[]{this.v()};
    }

    public Tile resample(Extent current, RasterExtent target, ResampleMethod method) {
        return new ByteConstantTile(this.v(), target.cols(), target.rows(), ByteConstantTile$.MODULE$.apply$default$4());
    }

    @Override
    public UByteConstantTile withNoData(Option<Object> noDataValue) {
        return new UByteConstantTile(this.v(), this.cols(), this.rows(), this.cellType().withNoData(noDataValue));
    }

    @Override
    public Tile map(Function1<Object, Object> f) {
        int n = f.apply$mcII$sp(this.iVal());
        return new UByteConstantTile(n == Integer.MIN_VALUE ? (byte)0 : (byte)n, this.cols(), this.rows(), this.cellType());
    }

    @Override
    public Tile mapDouble(Function1<Object, Object> f) {
        double n = f.apply$mcDD$sp(this.dVal());
        return new UByteConstantTile(Double.isNaN(n) ? (byte)0 : (byte)n, this.cols(), this.rows(), UByteConstantTile$.MODULE$.apply$default$4());
    }

    public UByteConstantTile copy(byte v, int cols, int rows, UByteCells cellType) {
        return new UByteConstantTile(v, cols, rows, cellType);
    }

    public byte copy$default$1() {
        return this.v();
    }

    public int copy$default$2() {
        return this.cols();
    }

    public int copy$default$3() {
        return this.rows();
    }

    public UByteCells copy$default$4() {
        return this.cellType();
    }

    public String productPrefix() {
        return "UByteConstantTile";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = BoxesRunTime.boxToByte((byte)this.v());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this.cols());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this.rows());
                break;
            }
            case 3: {
                object = this.cellType();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof UByteConstantTile;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.v());
        n = Statics.mix((int)n, (int)this.cols());
        n = Statics.mix((int)n, (int)this.rows());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.cellType()));
        return Statics.finalizeHash((int)n, (int)4);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof UByteConstantTile)) return false;
        boolean bl = true;
        if (!bl) return false;
        UByteConstantTile uByteConstantTile = (UByteConstantTile)x$1;
        if (this.v() != uByteConstantTile.v()) return false;
        if (this.cols() != uByteConstantTile.cols()) return false;
        if (this.rows() != uByteConstantTile.rows()) return false;
        UByteCells uByteCells = this.cellType();
        UByteCells uByteCells2 = uByteConstantTile.cellType();
        if (uByteCells == null) {
            if (uByteCells2 != null) {
                return false;
            }
        } else if (!uByteCells.equals(uByteCells2)) return false;
        if (!uByteConstantTile.canEqual(this)) return false;
        return true;
    }

    public UByteConstantTile(byte v, int cols, int rows, UByteCells cellType) {
        Tuple2.mcID.sp sp2;
        this.v = v;
        this.cols = cols;
        this.rows = rows;
        this.cellType = cellType;
        Grid.$init$(this);
        IterableTile.$init$(this);
        MappableTile.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        Tile.$init$(this);
        ConstantTile.$init$(this);
        Product.$init$((Product)this);
        UByteCells uByteCells = cellType;
        if (uByteCells instanceof ConstantNoData) {
            byte n = v;
            int n2 = n == (byte)0 ? Integer.MIN_VALUE : n & 0xFF;
            byte n3 = v;
            sp2 = new Tuple2.mcID.sp(n2, n3 == (byte)0 ? Double.NaN : (double)(n3 & 0xFF));
        } else if (uByteCells instanceof NoNoData) {
            sp2 = new Tuple2.mcID.sp((int)v, (double)v);
        } else if (uByteCells instanceof UByteUserDefinedNoDataCellType) {
            UByteUserDefinedNoDataCellType uByteUserDefinedNoDataCellType = (UByteUserDefinedNoDataCellType)uByteCells;
            sp2 = uByteUserDefinedNoDataCellType.noDataValue() == v ? new Tuple2.mcID.sp(Integer.MIN_VALUE, Double.NaN) : new Tuple2.mcID.sp((int)v, (double)v);
        } else {
            throw new MatchError((Object)uByteCells);
        }
        Tuple2.mcID.sp sp3 = sp2;
        if (sp3 == null) {
            throw new MatchError((Object)sp3);
        }
        int iVal = sp3._1$mcI$sp();
        double dVal = sp3._2$mcD$sp();
        int n = iVal;
        double d = dVal;
        Tuple2.mcID.sp sp4 = new Tuple2.mcID.sp(n, d);
        this.x$18 = sp4;
        this.iVal = this.x$18._1$mcI$sp();
        this.dVal = this.x$18._2$mcD$sp();
    }
}

