/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.CellSet;
import geotrellis.raster.ConstantNoData;
import geotrellis.raster.ConstantTile;
import geotrellis.raster.DataType;
import geotrellis.raster.Grid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.IterableTile;
import geotrellis.raster.MappableTile;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.NoNoData;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.ShortConstantTile;
import geotrellis.raster.ShortConstantTile$;
import geotrellis.raster.Tile;
import geotrellis.raster.UShortArrayTile$;
import geotrellis.raster.UShortCells;
import geotrellis.raster.UShortConstantTile$;
import geotrellis.raster.UShortUserDefinedNoDataCellType;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.vector.Extent;
import java.nio.ByteBuffer;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterator;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0001\tmb\u0001B\u0001\u0003\u0001\u001e\u0011!#V*i_J$8i\u001c8ti\u0006tG\u000fV5mK*\u00111\u0001B\u0001\u0007e\u0006\u001cH/\u001a:\u000b\u0003\u0015\t!bZ3piJ,G\u000e\\5t\u0007\u0001\u0019R\u0001\u0001\u0005\u000f%U\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0011\u001b\u0005\u0011\u0011BA\t\u0003\u00051\u0019uN\\:uC:$H+\u001b7f!\tI1#\u0003\u0002\u0015\u0015\t9\u0001K]8ek\u000e$\bCA\u0005\u0017\u0013\t9\"B\u0001\u0007TKJL\u0017\r\\5{C\ndW\r\u0003\u0005\u001a\u0001\tU\r\u0011\"\u0001\u001b\u0003\u00051X#A\u000e\u0011\u0005%a\u0012BA\u000f\u000b\u0005\u0015\u0019\u0006n\u001c:u\u0011!y\u0002A!E!\u0002\u0013Y\u0012A\u0001<!\u0011!\t\u0003A!f\u0001\n\u0003\u0011\u0013\u0001B2pYN,\u0012a\t\t\u0003\u0013\u0011J!!\n\u0006\u0003\u0007%sG\u000f\u0003\u0005(\u0001\tE\t\u0015!\u0003$\u0003\u0015\u0019w\u000e\\:!\u0011!I\u0003A!f\u0001\n\u0003\u0011\u0013\u0001\u0002:poND\u0001b\u000b\u0001\u0003\u0012\u0003\u0006IaI\u0001\u0006e><8\u000f\t\u0005\t[\u0001\u0011)\u001a!C\u0001]\u0005A1-\u001a7m)f\u0004X-F\u00010%\r\u0001$'\u000e\u0004\u0005c\u0001\u0001qF\u0001\u0007=e\u00164\u0017N\\3nK:$h\b\u0005\u0002\u0010g%\u0011AG\u0001\u0002\f+NCwN\u001d;DK2d7\u000f\u0005\u0002\u0010m%\u0011qG\u0001\u0002\u000f\u001d>$\u0015\r^1IC:$G.\u001b8h\u0011!I\u0004A!E!\u0002\u0013y\u0013!C2fY2$\u0016\u0010]3!\u0011\u0015Y\u0004\u0001\"\u0001=\u0003\u0019a\u0014N\\5u}Q)QHP A\u0003B\u0011q\u0002\u0001\u0005\u00063i\u0002\ra\u0007\u0005\u0006Ci\u0002\ra\t\u0005\u0006Si\u0002\ra\t\u0005\b[i\u0002\n\u00111\u0001C%\r\u0019%'\u000e\u0004\u0005c\u0001\u0001!\t\u0003\u0006F\u0001A\u0005\t1!Q\u0001\n\u0019\u000bA\u0001\u001f\u00133aA!\u0011bR\u0012J\u0013\tA%B\u0001\u0004UkBdWM\r\t\u0003\u0013)K!a\u0013\u0006\u0003\r\u0011{WO\u00197f\u0011\u001di\u0005A1A\u0005\u0012\t\nA!\u001b,bY\"1q\n\u0001Q\u0001\n\r\nQ!\u001b,bY\u0002Bq!\u0015\u0001C\u0002\u0013E!+\u0001\u0003e-\u0006dW#A%\t\rQ\u0003\u0001\u0015!\u0003J\u0003\u0015!g+\u00197!\u0011\u00151\u0006\u0001\"\u0001X\u0003-!x.\u0011:sCf$\u0016\u000e\\3\u0015\u0003a\u0003\"aD-\n\u0005i\u0013!!C!se\u0006LH+\u001b7f\u0011\u0015a\u0006\u0001\"\u0001^\u0003\u001diW\u000f^1cY\u0016,\u0012A\u0018\t\u0003\u001f}K!\u0001\u0019\u0002\u0003!5+H/\u00192mK\u0006\u0013(/Y=US2,\u0007\"\u00022\u0001\t\u0003\u0019\u0017a\u0002;p\u0005f$Xm\u001d\u000b\u0002IB\u0019\u0011\"Z4\n\u0005\u0019T!!B!se\u0006L\bCA\u0005i\u0013\tI'B\u0001\u0003CsR,\u0007\"B6\u0001\t\u0003a\u0017\u0001\u0003:fg\u0006l\u0007\u000f\\3\u0015\t5\u0004\b0 \t\u0003\u001f9L!a\u001c\u0002\u0003\tQKG.\u001a\u0005\u0006c*\u0004\rA]\u0001\bGV\u0014(/\u001a8u!\t\u0019h/D\u0001u\u0015\t)H!\u0001\u0004wK\u000e$xN]\u0005\u0003oR\u0014a!\u0012=uK:$\b\"B=k\u0001\u0004Q\u0018A\u0002;be\u001e,G\u000f\u0005\u0002\u0010w&\u0011AP\u0001\u0002\r%\u0006\u001cH/\u001a:FqR,g\u000e\u001e\u0005\u0006}*\u0004\ra`\u0001\u0007[\u0016$\bn\u001c3\u0011\t\u0005\u0005\u0011QA\u0007\u0003\u0003\u0007Q!a\u001b\u0002\n\t\u0005\u001d\u00111\u0001\u0002\u000f%\u0016\u001c\u0018-\u001c9mK6+G\u000f[8e\u0011\u001d\tY\u0001\u0001C\u0001\u0003\u001b\t!b^5uQ:{G)\u0019;b)\ri\u0014q\u0002\u0005\t\u0003#\tI\u00011\u0001\u0002\u0014\u0005Yan\u001c#bi\u00064\u0016\r\\;f!\u0011I\u0011QC%\n\u0007\u0005]!B\u0001\u0004PaRLwN\u001c\u0005\b\u00037\u0001A\u0011AA\u000f\u0003\ri\u0017\r\u001d\u000b\u0004[\u0006}\u0001\u0002CA\u0011\u00033\u0001\r!a\t\u0002\u0003\u0019\u0004R!CA\u0013G\rJ1!a\n\u000b\u0005%1UO\\2uS>t\u0017\u0007C\u0004\u0002,\u0001!\t!!\f\u0002\u00135\f\u0007\u000fR8vE2,GcA7\u00020!A\u0011\u0011EA\u0015\u0001\u0004\t\t\u0004E\u0003\n\u0003KI\u0015\nC\u0005\u00026\u0001\t\t\u0011\"\u0001\u00028\u0005!1m\u001c9z)%i\u0014\u0011HA\u001e\u0003{\ty\u0004\u0003\u0005\u001a\u0003g\u0001\n\u00111\u0001\u001c\u0011!\t\u00131\u0007I\u0001\u0002\u0004\u0019\u0003\u0002C\u0015\u00024A\u0005\t\u0019A\u0012\t\u00115\n\u0019\u0004%AA\u0002\tC\u0011\"a\u0011\u0001#\u0003%\t!!\u0012\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\t\u0016\u00047\u0005%3FAA&!\u0011\ti%a\u0016\u000e\u0005\u0005=#\u0002BA)\u0003'\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005U#\"\u0001\u0006b]:|G/\u0019;j_:LA!!\u0017\u0002P\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\u0005u\u0003!%A\u0005\u0002\u0005}\u0013AD2paf$C-\u001a4bk2$HEM\u000b\u0003\u0003CR3aIA%\u0011%\t)\u0007AI\u0001\n\u0003\ty&\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001a\t\u0013\u0005%\u0004!%A\u0005\u0002\u0005-\u0014AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003[R3aLA%\u0011%\t\t\bAA\u0001\n\u0003\n\u0019(A\u0007qe>$Wo\u0019;Qe\u00164\u0017\u000e_\u000b\u0003\u0003k\u0002B!a\u001e\u0002\u00026\u0011\u0011\u0011\u0010\u0006\u0005\u0003w\ni(\u0001\u0003mC:<'BAA@\u0003\u0011Q\u0017M^1\n\t\u0005\r\u0015\u0011\u0010\u0002\u0007'R\u0014\u0018N\\4\t\u0011\u0005\u001d\u0005!!A\u0005\u0002\t\nA\u0002\u001d:pIV\u001cG/\u0011:jifD\u0011\"a#\u0001\u0003\u0003%\t!!$\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!\u0011qRAK!\rI\u0011\u0011S\u0005\u0004\u0003'S!aA!os\"I\u0011qSAE\u0003\u0003\u0005\raI\u0001\u0004q\u0012\n\u0004\"CAN\u0001\u0005\u0005I\u0011IAO\u0003=\u0001(o\u001c3vGRLE/\u001a:bi>\u0014XCAAP!\u0019\t\t+a*\u0002\u00106\u0011\u00111\u0015\u0006\u0004\u0003KS\u0011AC2pY2,7\r^5p]&!\u0011\u0011VAR\u0005!IE/\u001a:bi>\u0014\b\"CAW\u0001\u0005\u0005I\u0011AAX\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BAY\u0003o\u00032!CAZ\u0013\r\t)L\u0003\u0002\b\u0005>|G.Z1o\u0011)\t9*a+\u0002\u0002\u0003\u0007\u0011q\u0012\u0005\n\u0003w\u0003\u0011\u0011!C!\u0003{\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002G!I\u0011\u0011\u0019\u0001\u0002\u0002\u0013\u0005\u00131Y\u0001\ti>\u001cFO]5oOR\u0011\u0011Q\u000f\u0005\n\u0003\u000f\u0004\u0011\u0011!C!\u0003\u0013\fa!Z9vC2\u001cH\u0003BAY\u0003\u0017D!\"a&\u0002F\u0006\u0005\t\u0019AAH\u000f\u001d\tyM\u0001E\u0001\u0003#\f!#V*i_J$8i\u001c8ti\u0006tG\u000fV5mKB\u0019q\"a5\u0007\r\u0005\u0011\u0001\u0012AAk'\u0011\t\u0019\u000eC\u000b\t\u000fm\n\u0019\u000e\"\u0001\u0002ZR\u0011\u0011\u0011\u001b\u0005\t\u0003;\f\u0019\u000e\"\u0001\u0002`\u0006IaM]8n\u0005f$Xm\u001d\u000b\n{\u0005\u0005\u0018Q]At\u0003SDq!a9\u0002\\\u0002\u0007A-A\u0003csR,7\u000f\u0003\u0004\"\u00037\u0004\ra\t\u0005\u0007S\u0005m\u0007\u0019A\u0012\t\u000f5\nY\u000e1\u0001\u0002lJ!\u0011Q\u001e\u001a6\r\u0019\t\u00141\u001b\u0001\u0002l\"Q\u0011\u0011_Aj\u0003\u0003%\t)a=\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0013u\n)0a>\u0002z\u0006m\bBB\r\u0002p\u0002\u00071\u0004\u0003\u0004\"\u0003_\u0004\ra\t\u0005\u0007S\u0005=\b\u0019A\u0012\t\u00135\ny\u000f%AA\u0002\u0005u(\u0003BA\u0000eU2a!MAj\u0001\u0005u\bB\u0003B\u0002\u0003'\f\t\u0011\"!\u0003\u0006\u00059QO\\1qa2LH\u0003\u0002B\u0004\u0005'\u0001R!CA\u000b\u0005\u0013\u0001\u0002\"\u0003B\u00067\r\u001a#qB\u0005\u0004\u0005\u001bQ!A\u0002+va2,GG\u0005\u0003\u0003\u0012I*dAB\u0019\u0002T\u0002\u0011y\u0001C\u0005\u0003\u0016\t\u0005\u0011\u0011!a\u0001{\u0005\u0019\u0001\u0010\n\u0019\t\u0015\te\u00111[I\u0001\n\u0003\u0011Y\"A\bbaBd\u0017\u0010\n3fM\u0006,H\u000e\u001e\u00135+\t\u0011iB\u000b\u0003\u0003 \u0005%#\u0003\u0002B\u0011eU2a!MAj\u0001\t}\u0001B\u0003B\u0013\u0003'\f\n\u0011\"\u0001\u0003(\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIQ*\"A!\u000b+\t\t-\u0012\u0011\n\n\u0005\u0005[\u0011TG\u0002\u00042\u0003'\u0004!1\u0006\u0005\u000b\u0005c\t\u0019.!A\u0005\n\tM\u0012a\u0003:fC\u0012\u0014Vm]8mm\u0016$\"A!\u000e\u0011\t\u0005]$qG\u0005\u0005\u0005s\tIH\u0001\u0004PE*,7\r\u001e")
public class UShortConstantTile
implements ConstantTile,
Product {
    private final short v;
    private final int cols;
    private final int rows;
    private final UShortCells cellType;
    private final /* synthetic */ Tuple2 x$20;
    private final int iVal;
    private final double dVal;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static UShortCells $lessinit$greater$default$4() {
        return UShortConstantTile$.MODULE$.$lessinit$greater$default$4();
    }

    public static UShortCells apply$default$4() {
        return UShortConstantTile$.MODULE$.apply$default$4();
    }

    public static Option<Tuple4<Object, Object, Object, UShortCells>> unapply(UShortConstantTile uShortConstantTile) {
        return UShortConstantTile$.MODULE$.unapply(uShortConstantTile);
    }

    public static UShortConstantTile apply(short s, int n, int n2, UShortCells uShortCells) {
        return UShortConstantTile$.MODULE$.apply(s, n, n2, uShortCells);
    }

    public static UShortConstantTile fromBytes(byte[] byArray, int n, int n2, UShortCells uShortCells) {
        return UShortConstantTile$.MODULE$.fromBytes(byArray, n, n2, uShortCells);
    }

    @Override
    public int get(int col, int row) {
        return ConstantTile.get$(this, col, row);
    }

    @Override
    public double getDouble(int col, int row) {
        return ConstantTile.getDouble$(this, col, row);
    }

    @Override
    public int[] toArray() {
        return ConstantTile.toArray$(this);
    }

    @Override
    public double[] toArrayDouble() {
        return ConstantTile.toArrayDouble$(this);
    }

    @Override
    public Tile convert(DataType newType) {
        return ConstantTile.convert$(this, newType);
    }

    @Override
    public Tile interpretAs(DataType newCellType) {
        return ConstantTile.interpretAs$(this, newCellType);
    }

    @Override
    public void foreach(Function1<Object, BoxedUnit> f) {
        ConstantTile.foreach$(this, f);
    }

    @Override
    public void foreachDouble(Function1<Object, BoxedUnit> f) {
        ConstantTile.foreachDouble$(this, f);
    }

    @Override
    public void foreachIntVisitor(IntTileVisitor visitor) {
        ConstantTile.foreachIntVisitor$(this, visitor);
    }

    @Override
    public void foreachDoubleVisitor(DoubleTileVisitor visitor) {
        ConstantTile.foreachDoubleVisitor$(this, visitor);
    }

    @Override
    public Tile combine(Tile other, Function2<Object, Object, Object> f) {
        return ConstantTile.combine$(this, other, f);
    }

    @Override
    public Tile combineDouble(Tile other, Function2<Object, Object, Object> f) {
        return ConstantTile.combineDouble$(this, other, f);
    }

    @Override
    public Tile mapIntMapper(IntTileMapper mapper) {
        return ConstantTile.mapIntMapper$(this, mapper);
    }

    @Override
    public Tile mapDoubleMapper(DoubleTileMapper mapper) {
        return ConstantTile.mapDoubleMapper$(this, mapper);
    }

    @Override
    public void dualForeach(Function1<Object, BoxedUnit> f, Function1<Object, BoxedUnit> g) {
        Tile.dualForeach$(this, f, g);
    }

    @Override
    public Tile mapIfSet(Function1<Object, Object> f) {
        return Tile.mapIfSet$(this, f);
    }

    @Override
    public Tile mapIfSetDouble(Function1<Object, Object> f) {
        return Tile.mapIfSetDouble$(this, f);
    }

    @Override
    public Tile dualMap(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile.dualMap$(this, f, g);
    }

    @Override
    public Tile dualMapIfSet(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile.dualMapIfSet$(this, f, g);
    }

    @Override
    public Tile dualCombine(Tile r2, Function2<Object, Object, Object> f, Function2<Object, Object, Object> g) {
        return Tile.dualCombine$(this, r2, f, g);
    }

    @Override
    public boolean isNoDataTile() {
        return Tile.isNoDataTile$(this);
    }

    @Override
    public Tile normalize(int oldMin, int oldMax, int newMin, int newMax) {
        return Tile.normalize$((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile normalize(double oldMin, double oldMax, double newMin, double newMax) {
        return Tile.normalize$((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile rescale(int newMin, int newMax) {
        return Tile.rescale$((Tile)this, newMin, newMax);
    }

    @Override
    public Tile rescale(double newMin, double newMax) {
        return Tile.rescale$((Tile)this, newMin, newMax);
    }

    @Override
    public Tile downsample(int newCols, int newRows, Function1<CellSet, Object> f) {
        return Tile.downsample$(this, newCols, newRows, f);
    }

    @Override
    public Tuple2<Object, Object> findMinMax() {
        return Tile.findMinMax$(this);
    }

    @Override
    public Tuple2<Object, Object> findMinMaxDouble() {
        return Tile.findMinMaxDouble$(this);
    }

    @Override
    public int size() {
        return Grid.size$(this);
    }

    @Override
    public Tuple2<Object, Object> dimensions() {
        return Grid.dimensions$(this);
    }

    @Override
    public GridBounds gridBounds() {
        return Grid.gridBounds$(this);
    }

    private Logger logger$lzycompute() {
        UShortConstantTile uShortConstantTile = this;
        synchronized (uShortConstantTile) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public short v() {
        return this.v;
    }

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    public UShortCells cellType() {
        return this.cellType;
    }

    @Override
    public int iVal() {
        return this.iVal;
    }

    @Override
    public double dVal() {
        return this.dVal;
    }

    @Override
    public ArrayTile toArrayTile() {
        return this.mutable();
    }

    @Override
    public MutableArrayTile mutable() {
        return UShortArrayTile$.MODULE$.fill(this.v(), this.cols(), this.rows(), this.cellType());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] toBytes() {
        void var1_1;
        byte[] arr = (byte[])Array$.MODULE$.ofDim(((DataType)((Object)this.cellType())).bytes(), ClassTag$.MODULE$.Byte());
        ByteBuffer.wrap(arr).asShortBuffer().put(this.v());
        return var1_1;
    }

    public Tile resample(Extent current, RasterExtent target, ResampleMethod method) {
        return new ShortConstantTile(this.v(), target.cols(), target.rows(), ShortConstantTile$.MODULE$.apply$default$4());
    }

    @Override
    public UShortConstantTile withNoData(Option<Object> noDataValue) {
        return new UShortConstantTile(this.v(), this.cols(), this.rows(), this.cellType().withNoData(noDataValue));
    }

    @Override
    public Tile map(Function1<Object, Object> f) {
        int n = f.apply$mcII$sp(this.iVal());
        return new UShortConstantTile(n == Integer.MIN_VALUE ? (short)0 : (short)n, this.cols(), this.rows(), this.cellType());
    }

    @Override
    public Tile mapDouble(Function1<Object, Object> f) {
        double n = f.apply$mcDD$sp(this.dVal());
        return new UShortConstantTile(Double.isNaN(n) ? (short)0 : (short)n, this.cols(), this.rows(), UShortConstantTile$.MODULE$.apply$default$4());
    }

    public UShortConstantTile copy(short v, int cols, int rows, UShortCells cellType) {
        return new UShortConstantTile(v, cols, rows, cellType);
    }

    public short copy$default$1() {
        return this.v();
    }

    public int copy$default$2() {
        return this.cols();
    }

    public int copy$default$3() {
        return this.rows();
    }

    public UShortCells copy$default$4() {
        return this.cellType();
    }

    public String productPrefix() {
        return "UShortConstantTile";
    }

    public int productArity() {
        return 4;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = BoxesRunTime.boxToShort((short)this.v());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this.cols());
                break;
            }
            case 2: {
                object = BoxesRunTime.boxToInteger((int)this.rows());
                break;
            }
            case 3: {
                object = this.cellType();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof UShortConstantTile;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.v());
        n = Statics.mix((int)n, (int)this.cols());
        n = Statics.mix((int)n, (int)this.rows());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.cellType()));
        return Statics.finalizeHash((int)n, (int)4);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof UShortConstantTile)) return false;
        boolean bl = true;
        if (!bl) return false;
        UShortConstantTile uShortConstantTile = (UShortConstantTile)x$1;
        if (this.v() != uShortConstantTile.v()) return false;
        if (this.cols() != uShortConstantTile.cols()) return false;
        if (this.rows() != uShortConstantTile.rows()) return false;
        UShortCells uShortCells = this.cellType();
        UShortCells uShortCells2 = uShortConstantTile.cellType();
        if (uShortCells == null) {
            if (uShortCells2 != null) {
                return false;
            }
        } else if (!uShortCells.equals(uShortCells2)) return false;
        if (!uShortConstantTile.canEqual(this)) return false;
        return true;
    }

    public UShortConstantTile(short v, int cols, int rows, UShortCells cellType) {
        Tuple2.mcID.sp sp2;
        this.v = v;
        this.cols = cols;
        this.rows = rows;
        this.cellType = cellType;
        Grid.$init$(this);
        IterableTile.$init$(this);
        MappableTile.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        Tile.$init$(this);
        ConstantTile.$init$(this);
        Product.$init$((Product)this);
        UShortCells uShortCells = cellType;
        if (uShortCells instanceof ConstantNoData) {
            short n = v;
            int n2 = n == (short)0 ? Integer.MIN_VALUE : n & 0xFFFF;
            short n3 = v;
            sp2 = new Tuple2.mcID.sp(n2, n3 == (short)0 ? Double.NaN : (double)(n3 & 0xFFFF));
        } else if (uShortCells instanceof NoNoData) {
            sp2 = new Tuple2.mcID.sp((int)v, (double)v);
        } else if (uShortCells instanceof UShortUserDefinedNoDataCellType) {
            UShortUserDefinedNoDataCellType uShortUserDefinedNoDataCellType = (UShortUserDefinedNoDataCellType)uShortCells;
            sp2 = uShortUserDefinedNoDataCellType.noDataValue() == v ? new Tuple2.mcID.sp(Integer.MIN_VALUE, Double.NaN) : new Tuple2.mcID.sp((int)v, (double)v);
        } else {
            throw new MatchError((Object)uShortCells);
        }
        Tuple2.mcID.sp sp3 = sp2;
        if (sp3 == null) {
            throw new MatchError((Object)sp3);
        }
        int iVal = sp3._1$mcI$sp();
        double dVal = sp3._2$mcD$sp();
        int n = iVal;
        double d = dVal;
        Tuple2.mcID.sp sp4 = new Tuple2.mcID.sp(n, d);
        this.x$20 = sp4;
        this.iVal = this.x$20._1$mcI$sp();
        this.dVal = this.x$20._2$mcD$sp();
    }
}

