/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.costdistance;

import geotrellis.raster.DoubleArrayTile;
import geotrellis.raster.DoubleArrayTile$;
import geotrellis.raster.Tile;
import geotrellis.raster.costdistance.CostDistance;
import geotrellis.raster.costdistance.DOption$;
import geotrellis.raster.costdistance.IOption$;
import java.io.Serializable;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class CostDistance$ {
    public static CostDistance$ MODULE$;
    private final CostDistance.Dir[] dirs;

    static {
        new CostDistance$();
    }

    public Tile apply(Tile cost, Seq<Tuple2<Object, Object>> points) {
        Tuple2<Object, Object> tuple2 = cost.dimensions();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int cols = tuple2._1$mcI$sp();
        int rows = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(cols, rows);
        Tuple2.mcII.sp sp3 = sp2;
        int cols2 = sp3._1$mcI$sp();
        int rows2 = sp3._2$mcI$sp();
        DoubleArrayTile output = DoubleArrayTile$.MODULE$.empty(cols2, rows2);
        points.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)CostDistance$.$anonfun$apply$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            CostDistance$.$anonfun$apply$2(output, x$2);
            return BoxedUnit.UNIT;
        });
        PriorityQueue<Tuple3<Object, Object, Object>> pqueue = new PriorityQueue<Tuple3<Object, Object, Object>>(1000, new Comparator<Tuple3<Object, Object, Object>>(){

            public Comparator<Tuple3<Object, Object, Object>> reversed() {
                return Comparator.super.reversed();
            }

            public Comparator<Tuple3<Object, Object, Object>> thenComparing(Comparator<? super Tuple3<Object, Object, Object>> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public <U> Comparator<Tuple3<Object, Object, Object>> thenComparing(Function<? super Tuple3<Object, Object, Object>, ? extends U> x$1, Comparator<? super U> x$2) {
                return Comparator.super.thenComparing(x$1, x$2);
            }

            public <U extends Comparable<? super U>> Comparator<Tuple3<Object, Object, Object>> thenComparing(Function<? super Tuple3<Object, Object, Object>, ? extends U> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public Comparator<Tuple3<Object, Object, Object>> thenComparingInt(ToIntFunction<? super Tuple3<Object, Object, Object>> x$1) {
                return Comparator.super.thenComparingInt(x$1);
            }

            public Comparator<Tuple3<Object, Object, Object>> thenComparingLong(ToLongFunction<? super Tuple3<Object, Object, Object>> x$1) {
                return Comparator.super.thenComparingLong(x$1);
            }

            public Comparator<Tuple3<Object, Object, Object>> thenComparingDouble(ToDoubleFunction<? super Tuple3<Object, Object, Object>> x$1) {
                return Comparator.super.thenComparingDouble(x$1);
            }

            public boolean equals(Object a) {
                return a.equals(this);
            }

            public int compare(Tuple3<Object, Object, Object> a, Tuple3<Object, Object, Object> b) {
                return Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble((Object)a._3())).compareTo(Predef$.MODULE$.double2Double(BoxesRunTime.unboxToDouble((Object)b._3())));
            }
        });
        points.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)CostDistance$.$anonfun$apply$3(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$3 -> {
            CostDistance$.$anonfun$apply$4(cost, output, pqueue, x$3);
            return BoxedUnit.UNIT;
        });
        while (!pqueue.isEmpty()) {
            Tuple3<Object, Object, Object> tuple3 = pqueue.poll();
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            int c = BoxesRunTime.unboxToInt((Object)tuple3._1());
            int r = BoxesRunTime.unboxToInt((Object)tuple3._2());
            double v = BoxesRunTime.unboxToDouble((Object)tuple3._3());
            Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)c), (Object)BoxesRunTime.boxToInteger((int)r), (Object)BoxesRunTime.boxToDouble((double)v));
            Tuple3 tuple33 = tuple32;
            int c2 = BoxesRunTime.unboxToInt((Object)tuple33._1());
            int r2 = BoxesRunTime.unboxToInt((Object)tuple33._2());
            double v2 = BoxesRunTime.unboxToDouble((Object)tuple33._3());
            if (v2 != output.getDouble(c2, r2)) continue;
            this.calcNeighbors(c2, r2, cost, output, pqueue);
        }
        return output;
    }

    private boolean isValid(int c, int r, Tile cost) {
        return c >= 0 && r >= 0 && c < cost.cols() && r < cost.rows();
    }

    public CostDistance.Dir[] dirs() {
        return this.dirs;
    }

    private Option<Tuple3<Object, Object, Object>> calcCostCell(int c, int r, CostDistance.Dir dir, Tile cost, DoubleArrayTile d) {
        None$ none$;
        Tuple2<Object, Object> cr = dir.apply(c, r);
        if (this.isValid(cr._1$mcI$sp(), cr._2$mcI$sp(), cost)) {
            double prev = d.getDouble(cr._1$mcI$sp(), cr._2$mcI$sp());
            if (prev == 0.0) {
                none$ = None$.MODULE$;
            } else {
                double source = d.getDouble(c, r);
                double prevCost = Double.isNaN(prev) ? Double.MAX_VALUE : prev;
                double curMinCost = Double.MAX_VALUE;
                double baseCostOpt = this.calcCost(c, r, dir, cost);
                if (DOption$.MODULE$.isDefined$extension(baseCostOpt)) {
                    curMinCost = source + DOption$.MODULE$.get$extension(baseCostOpt);
                }
                for (Tuple2<Object, Object> p : dir.cornerOffsets()) {
                    double cost2;
                    int r1;
                    int c1 = p._1$mcI$sp() + c;
                    double cost1 = this.calcCost(c, r, c1, r1 = p._2$mcI$sp() + r, cost);
                    if (!DOption$.MODULE$.isDefined$extension(cost1) || !DOption$.MODULE$.isDefined$extension(cost2 = this.calcCost(c1, r1, dir.apply(c, r), cost))) continue;
                    curMinCost = package$.MODULE$.min(curMinCost, source + DOption$.MODULE$.get$extension(cost1) + DOption$.MODULE$.get$extension(cost2));
                }
                if (curMinCost == Double.MAX_VALUE) {
                    none$ = None$.MODULE$;
                } else if (curMinCost < prevCost) {
                    d.setDouble(cr._1$mcI$sp(), cr._2$mcI$sp(), curMinCost);
                    none$ = new Some((Object)new Tuple3((Object)BoxesRunTime.boxToInteger((int)cr._1$mcI$sp()), (Object)BoxesRunTime.boxToInteger((int)cr._2$mcI$sp()), (Object)BoxesRunTime.boxToDouble((double)curMinCost)));
                } else {
                    none$ = None$.MODULE$;
                }
            }
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private void calcNeighbors(int c, int r, Tile cost, DoubleArrayTile d, PriorityQueue<Tuple3<Object, Object, Object>> p) {
        int l = this.dirs().length;
        for (int z = 0; z < l; ++z) {
            Option<Tuple3<Object, Object, Object>> opt = this.calcCostCell(c, r, this.dirs()[z], cost, d);
            Object object = opt.isDefined() ? BoxesRunTime.boxToBoolean((boolean)p.add((Tuple3<Object, Object, Object>)opt.get())) : BoxedUnit.UNIT;
        }
    }

    private double factor(int c, int r, int c1, int r1) {
        return c == c1 || r == r1 ? 1.0 : 1.41421356237;
    }

    private int safeGet(int c, int r, Tile cost) {
        return IOption$.MODULE$.apply(cost.get(c, r));
    }

    private double calcCost(int c, int r, int c2, int r2, Tile cost) {
        int cost1 = this.safeGet(c, r, cost);
        int cost2 = this.safeGet(c2, r2, cost);
        return IOption$.MODULE$.isDefined$extension(cost1) && IOption$.MODULE$.isDefined$extension(cost2) ? DOption$.MODULE$.apply(this.factor(c, r, c2, r2) * (double)(IOption$.MODULE$.get$extension(cost1) + IOption$.MODULE$.get$extension(cost2)) / 2.0) : DOption$.MODULE$.None();
    }

    private double calcCost(int c, int r, Tuple2<Object, Object> cr2, Tile cost) {
        return this.calcCost(c, r, cr2._1$mcI$sp(), cr2._2$mcI$sp(), cost);
    }

    private double calcCost(int c, int r, CostDistance.Dir dir, Tile cost) {
        return this.calcCost(c, r, dir.apply(c, r), cost);
    }

    public static final /* synthetic */ boolean $anonfun$apply$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$apply$2(DoubleArrayTile output$1, Tuple2 x$2) {
        Tuple2 tuple2 = x$2;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int c = tuple2._1$mcI$sp();
        int r = tuple2._2$mcI$sp();
        output$1.setDouble(c, r, 0.0);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ boolean $anonfun$apply$3(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$apply$4(Tile cost$1, DoubleArrayTile output$1, PriorityQueue pqueue$1, Tuple2 x$3) {
        Tuple2 tuple2 = x$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int c = tuple2._1$mcI$sp();
        int r = tuple2._2$mcI$sp();
        MODULE$.calcNeighbors(c, r, cost$1, output$1, pqueue$1);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private CostDistance$() {
        MODULE$ = this;
        this.dirs = (CostDistance.Dir[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new Tuple2[]{new Tuple2.mcII.sp(-1, -1), new Tuple2.mcII.sp(0, -1), new Tuple2.mcII.sp(1, -1), new Tuple2.mcII.sp(-1, 0), new Tuple2.mcII.sp(1, 0), new Tuple2.mcII.sp(-1, 1), new Tuple2.mcII.sp(0, 1), new Tuple2.mcII.sp(1, 1)})).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int c = tuple2._1$mcI$sp();
            int r = tuple2._2$mcI$sp();
            CostDistance.Dir dir = new CostDistance.Dir(c, r);
            return dir;
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(CostDistance.Dir.class)));
    }
}

