/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.costdistance;

import geotrellis.raster.ArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.costdistance.CostDistanceWithPaths$;
import geotrellis.raster.costdistance.CostDistanceWithPathsResult;
import geotrellis.raster.package$;
import geotrellis.raster.package$DoubleArrayFiller$;
import java.util.BitSet;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import scala.Array$;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005Uq!B\u0001\u0003\u0011\u0003I\u0011!F\"pgR$\u0015n\u001d;b]\u000e,w+\u001b;i!\u0006$\bn\u001d\u0006\u0003\u0007\u0011\tAbY8ti\u0012L7\u000f^1oG\u0016T!!\u0002\u0004\u0002\rI\f7\u000f^3s\u0015\u00059\u0011AC4f_R\u0014X\r\u001c7jg\u000e\u0001\u0001C\u0001\u0006\f\u001b\u0005\u0011a!\u0002\u0007\u0003\u0011\u0003i!!F\"pgR$\u0015n\u001d;b]\u000e,w+\u001b;i!\u0006$\bn]\n\u0003\u00179\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007\"B\u000b\f\t\u00031\u0012A\u0002\u001fj]&$h\bF\u0001\n\u0011\u0015A2\u0002\"\u0001\u001a\u0003\u0015\t\u0007\u000f\u001d7z)\rQRd\t\t\u0003\u0015mI!\u0001\b\u0002\u00037\r{7\u000f\u001e#jgR\fgnY3XSRD\u0007+\u0019;igJ+7/\u001e7u\u0011\u0015qr\u00031\u0001 \u0003\u0011\u0019wn\u001d;\u0011\u0005\u0001\nS\"\u0001\u0003\n\u0005\t\"!\u0001\u0002+jY\u0016DQ\u0001J\fA\u0002\u0015\naa]8ve\u000e,\u0007\u0003B\b'Q!J!a\n\t\u0003\rQ+\b\u000f\\33!\ty\u0011&\u0003\u0002+!\t\u0019\u0011J\u001c;\u0007\t1\u0011A\u0001L\n\u0003W9AABL\u0016\u0005\u0002\u0003\u0015)\u0011!Q\u0001\n=\n!hZ3piJ,G\u000e\\5tII\f7\u000f^3sI\r|7\u000f\u001e3jgR\fgnY3%\u0007>\u001cH\u000fR5ti\u0006t7-Z,ji\"\u0004\u0016\r\u001e5tI\u0011\u001awn\u001d;\u0011\u0005\u0001\u0002\u0014BA\u0019\u0005\u0005%\t%O]1z)&dW\r\u0003\u0005%W\t\u0005\t\u0015!\u0003&\u0011\u0015)2\u0006\"\u00015)\r)dg\u000e\t\u0003\u0015-BQAH\u001aA\u0002=BQ\u0001J\u001aA\u0002\u0015Bq!O\u0016C\u0002\u0013\u0005!(A\u0005uS2,\u0017I\u001d:bsV\tq\u0006\u0003\u0004=W\u0001\u0006IaL\u0001\u000bi&dW-\u0011:sCf\u0004\u0003b\u0002 ,\u0005\u0004%\taP\u0001\u0006'F\u0014HOM\u000b\u0002\u0001B\u0011q\"Q\u0005\u0003\u0005B\u0011a\u0001R8vE2,\u0007B\u0002#,A\u0003%\u0001)\u0001\u0004TcJ$(\u0007\t\u0005\u000b\r.\u0002\n\u0011aA!\u0002\u0013)\u0013a\u0001=%q!9\u0001j\u000bb\u0001\n\u0003I\u0015\u0001B2pYN,\u0012\u0001\u000b\u0005\u0007\u0017.\u0002\u000b\u0011\u0002\u0015\u0002\u000b\r|Gn\u001d\u0011\t\u000f5[#\u0019!C\u0001\u0013\u0006!!o\\<t\u0011\u0019y5\u0006)A\u0005Q\u0005)!o\\<tA!)\u0011k\u000bC\u0003%\u0006\u0011\u0012N\u001c3fqR{7i\\8sI&t\u0017\r^3t)\t)3\u000bC\u0003U!\u0002\u0007\u0001&A\u0002jIbD#\u0001\u0015,\u0011\u0005=9\u0016B\u0001-\u0011\u0005\u0019Ig\u000e\\5oK\")!l\u000bC\u00037\u0006\u00112m\\8sI&t\u0017\r^3t)>Le\u000eZ3y)\rACL\u0018\u0005\u0006;f\u0003\r\u0001K\u0001\u0002G\")q,\u0017a\u0001Q\u0005\t!\u000f\u000b\u0002Z-\")!m\u000bC\u0003G\u0006Yq-\u001a;US2,7i\\:u)\r\u0001EM\u001a\u0005\u0006K\u0006\u0004\r\u0001K\u0001\u0005g&#\u0007\u0010C\u0003hC\u0002\u0007\u0001&\u0001\u0003f\u0013\u0012D\bFA1W\u0011\u0015Q7\u0006\"\u0002l\u000319W\r\u001e(fS\u001eD'm\u001c:t)\taw\u000eE\u0002\u0010[\"J!A\u001c\t\u0003\u000b\u0005\u0013(/Y=\t\u000bQK\u0007\u0019\u0001\u0015)\u0005%4f\u0001\u0002:,\u0001M\u0014Qa\u0012:ba\"\u001c\"!\u001d\b\t\u000bU\tH\u0011A;\u0015\u0003Y\u0004\"a^9\u000e\u0003-Bq!_9C\u0002\u0013\u0005!0A\u0005oK&<\u0007NY8sgV\t1\u0010E\u0002\u0010[r\u00042aD7~!\u0011ya\u0005\u000b!\t\r}\f\b\u0015!\u0003|\u0003)qW-[4iE>\u00148\u000f\t\u0005\b\u0003\u0007\tH\u0011AA\u0003\u0003\u001d9W\r^\"pgR$R\u0001QA\u0004\u0003\u0017Aq!!\u0003\u0002\u0002\u0001\u0007\u0001&A\u0001t\u0011\u001d\ti!!\u0001A\u0002!\n\u0011!\u001a\u0005\b\u0003#YC\u0011AA\n\u0003\u001d\u0019w.\u001c9vi\u0016,\u0012A\u0007")
public class CostDistanceWithPaths {
    public final ArrayTile geotrellis$raster$costdistance$CostDistanceWithPaths$$cost;
    private final Tuple2<Object, Object> source;
    private final ArrayTile tileArray;
    private final double Sqrt2;
    private final /* synthetic */ Tuple2 x$8;
    private final int cols;
    private final int rows;

    public static CostDistanceWithPathsResult apply(Tile tile, Tuple2<Object, Object> tuple2) {
        return CostDistanceWithPaths$.MODULE$.apply(tile, tuple2);
    }

    public ArrayTile tileArray() {
        return this.tileArray;
    }

    public double Sqrt2() {
        return this.Sqrt2;
    }

    public int cols() {
        return this.cols;
    }

    public int rows() {
        return this.rows;
    }

    public final Tuple2<Object, Object> indexToCoordinates(int idx) {
        return new Tuple2.mcII.sp(idx % this.cols(), idx / this.cols());
    }

    public final int coordinatesToIndex(int c, int r) {
        return r * this.cols() + c;
    }

    public final double getTileCost(int sIdx, int eIdx) {
        int v1 = this.geotrellis$raster$costdistance$CostDistanceWithPaths$$cost.apply(sIdx);
        int v2 = this.geotrellis$raster$costdistance$CostDistanceWithPaths$$cost.apply(eIdx);
        int r = v1 + v2;
        int absDifference = scala.math.package$.MODULE$.abs(sIdx - eIdx);
        return absDifference > 1 && absDifference != this.cols() ? (double)r / this.Sqrt2() : (double)r / 2.0;
    }

    public final int[] getNeighbors(int idx) {
        Tuple2<Object, Object> tuple2 = this.indexToCoordinates(idx);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int col = tuple2._1$mcI$sp();
        int row = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(col, row);
        Tuple2.mcII.sp sp3 = sp2;
        int col2 = sp3._1$mcI$sp();
        int row2 = sp3._2$mcI$sp();
        ArrayBuffer buff = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        boolean isRight = col2 == this.cols() - 1;
        boolean isLeft = col2 == 0;
        boolean isTop = row2 == 0;
        boolean isBottom = row2 == this.rows() - 1;
        Object object = !isLeft ? buff.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(idx - 1))) : BoxedUnit.UNIT;
        Object object2 = !isRight ? buff.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(idx + 1))) : BoxedUnit.UNIT;
        Object object3 = !isTop ? buff.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(idx - this.cols()))) : BoxedUnit.UNIT;
        Object object4 = !isBottom ? buff.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(idx + this.cols()))) : BoxedUnit.UNIT;
        Object object5 = !isLeft && !isTop ? buff.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(idx - this.cols() - 1))) : BoxedUnit.UNIT;
        Object object6 = !isLeft && !isBottom ? buff.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(idx + this.cols() - 1))) : BoxedUnit.UNIT;
        Object object7 = !isRight && !isTop ? buff.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(idx - this.cols() + 1))) : BoxedUnit.UNIT;
        Object object8 = !isRight && !isBottom ? buff.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(idx + this.cols() + 1))) : BoxedUnit.UNIT;
        return (int[])buff.toArray(ClassTag$.MODULE$.Int());
    }

    public CostDistanceWithPathsResult compute() {
        Tuple2<Object, Object> tuple2 = this.source;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int sourceCol = tuple2._1$mcI$sp();
        int sourceRow = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(sourceCol, sourceRow);
        Tuple2.mcII.sp sp3 = sp2;
        int sourceCol2 = sp3._1$mcI$sp();
        int sourceRow2 = sp3._2$mcI$sp();
        int sourceIdx = this.coordinatesToIndex(sourceCol2, sourceRow2);
        BitSet marked = new BitSet(this.cols() * this.rows());
        double[] pathCosts = package$DoubleArrayFiller$.MODULE$.fill$extension(package$.MODULE$.DoubleArrayFiller((double[])Array$.MODULE$.ofDim(this.cols() * this.rows(), ClassTag$.MODULE$.Double())), Double.MAX_VALUE);
        pathCosts[sourceIdx] = 0.0;
        Seq[] rememberParents = (Seq[])Array$.MODULE$.ofDim(this.cols() * this.rows(), ClassTag$.MODULE$.apply(Seq.class));
        PriorityQueue<Object> priorityQueue = new PriorityQueue<Object>(this.cols() * this.rows(), new Comparator<Object>(null, pathCosts){
            private final double[] pathCosts$1;

            public Comparator<Object> reversed() {
                return Comparator.super.reversed();
            }

            public Comparator<Object> thenComparing(Comparator<? super Object> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public <U> Comparator<Object> thenComparing(Function<? super Object, ? extends U> x$1, Comparator<? super U> x$2) {
                return Comparator.super.thenComparing(x$1, x$2);
            }

            public <U extends Comparable<? super U>> Comparator<Object> thenComparing(Function<? super Object, ? extends U> x$1) {
                return Comparator.super.thenComparing(x$1);
            }

            public Comparator<Object> thenComparingInt(ToIntFunction<? super Object> x$1) {
                return Comparator.super.thenComparingInt(x$1);
            }

            public Comparator<Object> thenComparingLong(ToLongFunction<? super Object> x$1) {
                return Comparator.super.thenComparingLong(x$1);
            }

            public Comparator<Object> thenComparingDouble(ToDoubleFunction<? super Object> x$1) {
                return Comparator.super.thenComparingDouble(x$1);
            }

            public boolean equals(Object a) {
                return a.equals(this);
            }

            public int compare(int a, int b) {
                return Predef$.MODULE$.double2Double(this.pathCosts$1[a]).compareTo(Predef$.MODULE$.double2Double(this.pathCosts$1[b]));
            }
            {
                this.pathCosts$1 = pathCosts$1;
            }
        });
        Graph graph = new Graph();
        for (int index$macro$168 = 0; index$macro$168 < this.cols() * this.rows(); ++index$macro$168) {
            rememberParents[index$macro$168] = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        }
        priorityQueue.add(BoxesRunTime.boxToInteger((int)sourceIdx));
        while (!priorityQueue.isEmpty()) {
            int current = BoxesRunTime.unboxToInt((Object)priorityQueue.poll());
            marked.flip(current);
            int[] neighbors = this.getNeighbors(current);
            for (int index$macro$169 = 0; index$macro$169 < new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(neighbors)).size(); ++index$macro$169) {
                double oldCost;
                int neighbor = neighbors[index$macro$169];
                if (marked.get(neighbor)) continue;
                double alt = pathCosts[current] + graph.getCost(current, neighbor);
                if (alt < (oldCost = pathCosts[neighbor])) {
                    pathCosts[neighbor] = alt;
                    rememberParents[neighbor] = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{current}));
                    priorityQueue.add(BoxesRunTime.boxToInteger((int)neighbor));
                    continue;
                }
                if (alt != oldCost) continue;
                rememberParents[neighbor] = (Seq)rememberParents[neighbor].$colon$plus((Object)BoxesRunTime.boxToInteger((int)current), Seq$.MODULE$.canBuildFrom());
            }
        }
        return new CostDistanceWithPathsResult(rememberParents, pathCosts, this.geotrellis$raster$costdistance$CostDistanceWithPaths$$cost.dimensions());
    }

    public CostDistanceWithPaths(ArrayTile cost, Tuple2<Object, Object> source) {
        this.geotrellis$raster$costdistance$CostDistanceWithPaths$$cost = cost;
        this.source = source;
        this.tileArray = cost;
        this.Sqrt2 = scala.math.package$.MODULE$.sqrt(2.0);
        Tuple2<Object, Object> tuple2 = cost.dimensions();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int cols = tuple2._1$mcI$sp();
        int rows = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(cols, rows);
        this.x$8 = sp2;
        this.cols = this.x$8._1$mcI$sp();
        this.rows = this.x$8._2$mcI$sp();
    }

    public class Graph {
        private final Tuple2<Object, Object>[][] neighbors;

        public Tuple2<Object, Object>[][] neighbors() {
            return this.neighbors;
        }

        public double getCost(int s, int e) {
            Tuple2<Object, Object>[] sNeighbors = this.neighbors()[s];
            double res = Double.MAX_VALUE;
            for (int index$macro$167 = 0; index$macro$167 < new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sNeighbors)).size(); ++index$macro$167) {
                Tuple2<Object, Object> tuple2 = sNeighbors[index$macro$167];
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                int other = tuple2._1$mcI$sp();
                double c = tuple2._2$mcD$sp();
                Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(other, c);
                Tuple2.mcID.sp sp3 = sp2;
                int other2 = sp3._1$mcI$sp();
                double c2 = sp3._2$mcD$sp();
                if (other2 != e) continue;
                res = c2;
            }
            return res;
        }

        public /* synthetic */ CostDistanceWithPaths geotrellis$raster$costdistance$CostDistanceWithPaths$Graph$$$outer() {
            return CostDistanceWithPaths.this;
        }

        /*
         * WARNING - void declaration
         */
        public Graph() {
            void var3_3;
            if (CostDistanceWithPaths.this == null) {
                throw null;
            }
            int vertices = CostDistanceWithPaths.this.cols() * CostDistanceWithPaths.this.rows();
            Tuple2[][] res = (Tuple2[][])Array$.MODULE$.ofDim(vertices, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Tuple2.class)));
            for (int index$macro$166 = 0; index$macro$166 < vertices; ++index$macro$166) {
                int[] neighborIndices = CostDistanceWithPaths.this.getNeighbors(index$macro$166);
                Tuple2[] neighbors = (Tuple2[])Array$.MODULE$.ofDim(new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(neighborIndices)).size(), ClassTag$.MODULE$.apply(Tuple2.class));
                for (int index$macro$165 = 0; index$macro$165 < new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(neighborIndices)).size(); ++index$macro$165) {
                    int other = neighborIndices[index$macro$165];
                    double cost = CostDistanceWithPaths.this.getTileCost(index$macro$166, other);
                    neighbors[index$macro$165] = new Tuple2.mcID.sp(other, cost);
                }
                res[index$macro$166] = neighbors;
            }
            this.neighbors = var3_3;
        }
    }
}

