/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.crop;

import geotrellis.raster.CellGrid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.Raster;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.crop.Crop;
import geotrellis.raster.crop.Crop$Options$;
import geotrellis.raster.crop.CropMethods;
import geotrellis.vector.Extent;
import scala.Function1;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Q3A!\u0001\u0002\u0001\u0013\t\t\"+Y:uKJ\u001c%o\u001c9NKRDw\u000eZ:\u000b\u0005\r!\u0011\u0001B2s_BT!!\u0002\u0004\u0002\rI\f7\u000f^3s\u0015\u00059\u0011AC4f_R\u0014X\r\u001c7jg\u000e\u0001QC\u0001\u0006\u001c'\r\u00011\"\u0005\t\u0003\u0019=i\u0011!\u0004\u0006\u0002\u001d\u0005)1oY1mC&\u0011\u0001#\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0007I\u0019R#D\u0001\u0003\u0013\t!\"AA\u0006De>\u0004X*\u001a;i_\u0012\u001c\bc\u0001\f\u001835\tA!\u0003\u0002\u0019\t\t1!+Y:uKJ\u0004\"AG\u000e\r\u0001\u0011)A\u0004\u0001b\u0001;\t\tA+\u0005\u0002\u001fCA\u0011AbH\u0005\u0003A5\u0011qAT8uQ&tw\r\u0005\u0002\u0017E%\u00111\u0005\u0002\u0002\t\u0007\u0016dGn\u0012:jI\"AQ\u0005\u0001BC\u0002\u0013\u0005a%\u0001\u0003tK24W#A\u000b\t\u0011!\u0002!\u0011!Q\u0001\nU\tQa]3mM\u0002B\u0001B\u000b\u0001\u0003\u0004\u0003\u0006YaK\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004\u0003\u0002\u0007-39J!!L\u0007\u0003\u0013\u0019+hn\u0019;j_:\f\u0004c\u0001\n\u00143!)\u0001\u0007\u0001C\u0001c\u00051A(\u001b8jiz\"\"AM\u001b\u0015\u0005M\"\u0004c\u0001\n\u00013!)!f\fa\u0002W!)Qe\fa\u0001+!)1\u0001\u0001C\u0001oQ\u0019Q\u0003\u000f!\t\u000be2\u0004\u0019\u0001\u001e\u0002\r\u0015DH/\u001a8u!\tYd(D\u0001=\u0015\tid!\u0001\u0004wK\u000e$xN]\u0005\u0003\u007fq\u0012a!\u0012=uK:$\b\"B!7\u0001\u0004\u0011\u0015aB8qi&|gn\u001d\t\u0003\u0007\u001as!A\u0005#\n\u0005\u0015\u0013\u0011\u0001B\"s_BL!a\u0012%\u0003\u000f=\u0003H/[8og*\u0011QI\u0001\u0005\u0006\u0007\u0001!\tA\u0013\u000b\u0003+-CQ!O%A\u0002iBQa\u0001\u0001\u0005\u00025#2!\u0006(T\u0011\u0015yE\n1\u0001Q\u0003\t9'\r\u0005\u0002\u0017#&\u0011!\u000b\u0002\u0002\u000b\u000fJLGMQ8v]\u0012\u001c\b\"B!M\u0001\u0004\u0011\u0005")
public class RasterCropMethods<T extends CellGrid>
implements CropMethods<Raster<T>> {
    private final Raster<T> self;
    private final Function1<T, CropMethods<T>> evidence$1;

    @Override
    public Object crop(GridBounds gb) {
        return CropMethods.crop$((CropMethods)this, gb);
    }

    @Override
    public Iterator<Tuple2<GridBounds, Raster<T>>> crop(Seq<GridBounds> windows) {
        return CropMethods.crop$((CropMethods)this, windows);
    }

    @Override
    public Object crop(int cols, int rows, Crop.Options options) {
        return CropMethods.crop$(this, cols, rows, options);
    }

    @Override
    public Object crop(int cols, int rows) {
        return CropMethods.crop$(this, cols, rows);
    }

    @Override
    public Object crop(int colMin, int rowMin, int colMax, int rowMax, Crop.Options options) {
        return CropMethods.crop$(this, colMin, rowMin, colMax, rowMax, options);
    }

    @Override
    public Object crop(int colMin, int rowMin, int colMax, int rowMax) {
        return CropMethods.crop$(this, colMin, rowMin, colMax, rowMax);
    }

    public Raster<T> self() {
        return this.self;
    }

    public Raster<T> crop(Extent extent, Crop.Options options) {
        RasterExtent re = RasterExtent$.MODULE$.apply((CellGrid)((Raster)this.self()).tile(), ((Raster)this.self()).extent());
        GridBounds gridBounds = re.gridBoundsFor(extent, options.clamp());
        Extent croppedExtent = re.extentFor(gridBounds, options.clamp());
        CellGrid croppedTile = (CellGrid)((CropMethods)this.evidence$1.apply(((Raster)this.self())._1())).crop(gridBounds, options);
        return new Raster<CellGrid>(croppedTile, croppedExtent);
    }

    public Raster<T> crop(Extent extent) {
        return this.crop(extent, Crop$Options$.MODULE$.DEFAULT());
    }

    @Override
    public Raster<T> crop(GridBounds gb, Crop.Options options) {
        RasterExtent re = RasterExtent$.MODULE$.apply(((Raster)this.self())._2(), (CellGrid)((Raster)this.self())._1());
        Extent croppedExtent = re.extentFor(gb, options.clamp());
        return new Raster<CellGrid>((CellGrid)((CropMethods)this.evidence$1.apply(((Raster)this.self())._1())).crop(gb, options), croppedExtent);
    }

    public RasterCropMethods(Raster<T> self, Function1<T, CropMethods<T>> evidence$1) {
        this.self = self;
        this.evidence$1 = evidence$1;
        CropMethods.$init$(this);
    }
}

