/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.histogram;

import geotrellis.raster.histogram.FastMapHistogram;
import geotrellis.raster.histogram.Histogram$mcI$sp;
import geotrellis.raster.histogram.IntHistogram$;
import geotrellis.raster.summary.Statistics;
import geotrellis.raster.summary.Statistics$mcI$sp;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005<Q!\u0001\u0002\t\u0002%\tA\"\u00138u\u0011&\u001cHo\\4sC6T!a\u0001\u0003\u0002\u0013!L7\u000f^8he\u0006l'BA\u0003\u0007\u0003\u0019\u0011\u0018m\u001d;fe*\tq!\u0001\u0006hK>$(/\u001a7mSN\u001c\u0001\u0001\u0005\u0002\u000b\u00175\t!AB\u0003\r\u0005!\u0005QB\u0001\u0007J]RD\u0015n\u001d;pOJ\fWnE\u0002\f\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\b\u0016\u0013\t1\u0002C\u0001\u0007TKJL\u0017\r\\5{C\ndW\rC\u0003\u0019\u0017\u0011\u0005\u0011$\u0001\u0004=S:LGO\u0010\u000b\u0002\u0013!)1d\u0003C\u00019\u0005)\u0011\r\u001d9msR\tQ\u0004\u0005\u0002\u000b=%\u0011qD\u0001\u0002\u0011\r\u0006\u001cH/T1q\u0011&\u001cHo\\4sC6DQaG\u0006\u0005\u0002\u0005\"\"!\b\u0012\t\u000b\r\u0002\u0003\u0019\u0001\u0013\u0002\tML'0\u001a\t\u0003\u001f\u0015J!A\n\t\u0003\u0007%sG\u000fC\u0004)\u0017\u0005\u0005I\u0011B\u0015\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0002UA\u00111\u0006M\u0007\u0002Y)\u0011QFL\u0001\u0005Y\u0006twMC\u00010\u0003\u0011Q\u0017M^1\n\u0005Eb#AB(cU\u0016\u001cGOB\u0004\r\u0005A\u0005\u0019\u0011A\u001a\u0014\u0007IrA\u0007E\u0002\u000bk\u0011J!A\u000e\u0002\u0003\u0013!K7\u000f^8he\u0006l\u0007\"\u0002\u001d3\t\u0003I\u0014A\u0002\u0013j]&$H\u0005F\u0001;!\ty1(\u0003\u0002=!\t!QK\\5u\u0011\u0015q$\u0007\"\u0001@\u0003\u001d1wN]3bG\"$\"A\u000f!\t\u000b\u0005k\u0004\u0019\u0001\"\u0002\u0003\u0019\u0004RaD\"%\u000bjJ!\u0001\u0012\t\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004CA\bG\u0013\t9\u0005C\u0001\u0003M_:<\u0007\"B%3\t\u0003Q\u0015\u0001B7pI\u0016$\u0012a\u0013\t\u0004\u001f1#\u0013BA'\u0011\u0005\u0019y\u0005\u000f^5p]\")qJ\rC\u0001\u0015\u00061Q.\u001a3jC:DQ!\u0015\u001a\u0005\u0002I\u000bA!\\3b]R\t1\u000bE\u0002\u0010\u0019R\u0003\"aD+\n\u0005Y\u0003\"A\u0002#pk\ndW\rC\u0003Ye\u0011\u0005\u0011,\u0001\u0006ti\u0006$\u0018n\u001d;jGN$\u0012A\u0017\t\u0004\u001f1[\u0006c\u0001/`I5\tQL\u0003\u0002_\t\u000591/^7nCJL\u0018B\u00011^\u0005)\u0019F/\u0019;jgRL7m\u001d")
public interface IntHistogram
extends Histogram$mcI$sp {
    public static FastMapHistogram apply(int n) {
        return IntHistogram$.MODULE$.apply(n);
    }

    public static FastMapHistogram apply() {
        return IntHistogram$.MODULE$.apply();
    }

    public static /* synthetic */ void foreach$(IntHistogram $this, Function2 f) {
        $this.foreach((Function2<Object, Object, BoxedUnit>)f);
    }

    @Override
    default public void foreach(Function2<Object, Object, BoxedUnit> f) {
        this.foreach$mcI$sp(f);
    }

    public static /* synthetic */ Option mode$(IntHistogram $this) {
        return $this.mode();
    }

    @Override
    default public Option<Object> mode() {
        if (this.totalCount() == 0L) {
            return None$.MODULE$;
        }
        int[] localValues = this.values$mcI$sp();
        int mode = localValues[0];
        long count = this.itemCount$mcI$sp(mode);
        int len = localValues.length;
        for (int index$macro$170 = 1; index$macro$170 < len; ++index$macro$170) {
            int z = localValues[index$macro$170];
            long c = this.itemCount$mcI$sp(z);
            if (c <= count) continue;
            count = c;
            mode = z;
        }
        return new Some((Object)BoxesRunTime.boxToInteger((int)mode));
    }

    public static /* synthetic */ Option median$(IntHistogram $this) {
        return $this.median();
    }

    @Override
    default public Option<Object> median() {
        None$ none$;
        if (this.totalCount() == 0L) {
            none$ = None$.MODULE$;
        } else {
            int[] localValues = this.values$mcI$sp();
            long middle = this.totalCount() / 2L;
            long total = 0L;
            int i = 0;
            while (total <= middle) {
                total += this.itemCount$mcI$sp(localValues[i]);
                ++i;
            }
            none$ = new Some((Object)BoxesRunTime.boxToInteger((int)localValues[i - 1]));
        }
        return none$;
    }

    public static /* synthetic */ Option mean$(IntHistogram $this) {
        return $this.mean();
    }

    @Override
    default public Option<Object> mean() {
        if (this.totalCount() == 0L) {
            return None$.MODULE$;
        }
        int[] localValues = this.rawValues$mcI$sp();
        double mean = 0.0;
        double total = 0.0;
        for (int value : localValues) {
            long count = this.itemCount$mcI$sp(value);
            double delta = (double)value - mean;
            mean += (double)count * delta / (total += (double)count);
        }
        return new Some((Object)BoxesRunTime.boxToDouble((double)mean));
    }

    public static /* synthetic */ Option statistics$(IntHistogram $this) {
        return $this.statistics();
    }

    @Override
    default public Option<Statistics<Object>> statistics() {
        None$ none$;
        int[] localValues = this.values$mcI$sp();
        if (localValues.length == 0) {
            none$ = None$.MODULE$;
        } else {
            long dataCount = 0L;
            int mode = 0;
            long modeCount = 0L;
            double mean = 0.0;
            long total = 0L;
            int median = 0;
            boolean needMedian = true;
            long limit = this.totalCount() / 2L;
            int len = localValues.length;
            for (int index$macro$172 = 0; index$macro$172 < len; ++index$macro$172) {
                int value = localValues[index$macro$172];
                long count = this.itemCount$mcI$sp(value);
                dataCount += count;
                if (count == 0L) continue;
                if (count > modeCount) {
                    mode = value;
                    modeCount = count;
                }
                double delta = (double)value - mean;
                mean += (double)count * delta / (double)(total += count);
                if (!needMedian || total <= limit) continue;
                median = localValues[index$macro$172];
                needMedian = false;
            }
            int zmin = localValues[0];
            int zmax = localValues[len - 1];
            total = 0L;
            double mean2 = 0.0;
            for (int index$macro$173 = 0; index$macro$173 < len; ++index$macro$173) {
                int value = localValues[index$macro$173];
                long count = this.itemCount$mcI$sp(value);
                if (count <= 0L) continue;
                double x = (double)value - mean;
                double y = x * x;
                double delta = y - mean2;
                mean2 += (double)count * delta / (double)(total += count);
            }
            double stddev = package$.MODULE$.sqrt(mean2);
            none$ = new Some((Object)new Statistics$mcI$sp(dataCount, mean, median, mode, stddev, zmin, zmax));
        }
        return none$;
    }

    public static /* synthetic */ void foreach$mcI$sp$(IntHistogram $this, Function2 f) {
        $this.foreach$mcI$sp((Function2<Object, Object, BoxedUnit>)f);
    }

    @Override
    default public void foreach$mcI$sp(Function2<Object, Object, BoxedUnit> f) {
        new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(this.values$mcI$sp())).foreach((Function1)(JFunction1.mcVI.sp & java.io.Serializable & Serializable)z -> f.apply$mcVIJ$sp(z, this.itemCount$mcI$sp(z)));
    }

    public static void $init$(IntHistogram $this) {
    }
}

