/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.hydrology;

import geotrellis.raster.IntArrayTile;
import geotrellis.raster.IntArrayTile$;
import geotrellis.raster.Tile;
import geotrellis.raster.package$;
import geotrellis.raster.package$IntArrayFiller$;
import scala.Array$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayStack;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class Accumulation$ {
    public static Accumulation$ MODULE$;

    static {
        new Accumulation$();
    }

    public boolean doesFlow(int value, int dir) {
        return value < dir ? false : (value >> (int)scala.math.package$.MODULE$.floor(scala.math.package$.MODULE$.log((double)dir) / scala.math.package$.MODULE$.log(2.0))) % 2 == 1;
    }

    public void calcAcc(int column, int row, IntArrayTile data, Tile flowDirrection) {
        int c = column;
        int r = row;
        int sum = data.get(c, r);
        int cols = data.cols();
        int rows = data.rows();
        boolean flag = false;
        Map map = (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)16)), (Object)new Tuple2.mcII.sp(c + 1, r)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)32)), (Object)new Tuple2.mcII.sp(c + 1, r + 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)64)), (Object)new Tuple2.mcII.sp(c, r + 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)128)), (Object)new Tuple2.mcII.sp(c - 1, r + 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)new Tuple2.mcII.sp(c - 1, r)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)2)), (Object)new Tuple2.mcII.sp(c - 1, r - 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)4)), (Object)new Tuple2.mcII.sp(c, r - 1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)8)), (Object)new Tuple2.mcII.sp(c + 1, r - 1))}));
        if (sum == -1) {
            sum = 0;
            ArrayStack stack = new ArrayStack();
            stack.push((Object)new Tuple2.mcII.sp(c, r));
            stack.push((Object)new Tuple2.mcII.sp(c, r));
            while (!stack.isEmpty() || data.get(c, r) == -1) {
                sum = 0;
                flag = false;
                Tuple2 n = (Tuple2)map.apply((Object)BoxesRunTime.boxToInteger((int)16));
                if (c + 1 < cols && this.doesFlow(flowDirrection.get(n._1$mcI$sp(), n._2$mcI$sp()), 16)) {
                    if (data.get(n._1$mcI$sp(), n._2$mcI$sp()) == -1) {
                        stack.push((Object)n);
                        flag = true;
                    } else {
                        sum += data.get(n._1$mcI$sp(), n._2$mcI$sp());
                    }
                }
                n = (Tuple2)map.apply((Object)BoxesRunTime.boxToInteger((int)32));
                if (c + 1 < cols && r + 1 < rows && this.doesFlow(flowDirrection.get(n._1$mcI$sp(), n._2$mcI$sp()), 32)) {
                    if (data.get(n._1$mcI$sp(), n._2$mcI$sp()) == -1) {
                        stack.push((Object)n);
                        flag = true;
                    } else {
                        sum += data.get(n._1$mcI$sp(), n._2$mcI$sp()) + 1;
                    }
                }
                n = (Tuple2)map.apply((Object)BoxesRunTime.boxToInteger((int)64));
                if (r + 1 < rows && this.doesFlow(flowDirrection.get(c, r + 1), 64)) {
                    if (data.get(n._1$mcI$sp(), n._2$mcI$sp()) == -1) {
                        stack.push((Object)n);
                        flag = true;
                    } else {
                        sum += data.get(n._1$mcI$sp(), n._2$mcI$sp()) + 1;
                    }
                }
                n = (Tuple2)map.apply((Object)BoxesRunTime.boxToInteger((int)128));
                if (c - 1 >= 0 && r + 1 < rows && this.doesFlow(flowDirrection.get(c - 1, r + 1), 128)) {
                    if (data.get(c - 1, r + 1) == -1) {
                        stack.push((Object)new Tuple2.mcII.sp(c - 1, r + 1));
                        flag = true;
                    } else {
                        sum += data.get(c - 1, r + 1) + 1;
                    }
                }
                n = (Tuple2)map.apply((Object)BoxesRunTime.boxToInteger((int)1));
                if (c - 1 >= 0 && this.doesFlow(flowDirrection.get(c - 1, r), 1)) {
                    if (data.get(c - 1, r) == -1) {
                        stack.push((Object)new Tuple2.mcII.sp(c - 1, r));
                        flag = true;
                    } else {
                        sum += data.get(c - 1, r) + 1;
                    }
                }
                n = (Tuple2)map.apply((Object)BoxesRunTime.boxToInteger((int)2));
                if (c - 1 >= 0 && r - 1 >= 0 && this.doesFlow(flowDirrection.get(c - 1, r - 1), 2)) {
                    if (data.get(c - 1, r - 1) == -1) {
                        stack.push((Object)new Tuple2.mcII.sp(c - 1, r - 1));
                        flag = true;
                    } else {
                        sum += data.get(c - 1, r - 1) + 1;
                    }
                }
                n = (Tuple2)map.apply((Object)BoxesRunTime.boxToInteger((int)4));
                if (r - 1 >= 0 && this.doesFlow(flowDirrection.get(c, r - 1), 4)) {
                    if (data.get(c, r - 1) == -1) {
                        stack.push((Object)new Tuple2.mcII.sp(c, r - 1));
                        flag = true;
                    } else {
                        sum += data.get(c, r - 1) + 1;
                    }
                }
                n = (Tuple2)map.apply((Object)BoxesRunTime.boxToInteger((int)8));
                if (c + 1 < cols && r - 1 >= 0 && this.doesFlow(flowDirrection.get(c + 1, r - 1), 8)) {
                    if (data.get(c + 1, r - 1) == -1) {
                        stack.push((Object)new Tuple2.mcII.sp(c + 1, r - 1));
                        flag = true;
                    } else {
                        sum += data.get(c + 1, r - 1) + 1;
                    }
                }
                if (!flag) {
                    data.set(c, r, sum);
                }
                if (stack.isEmpty()) continue;
                Tuple2 t = (Tuple2)stack.pop();
                c = t._1$mcI$sp();
                r = t._2$mcI$sp();
            }
        }
    }

    public Tile apply(Tile flowDirrection) {
        int cols = flowDirrection.cols();
        int rows = flowDirrection.rows();
        IntArrayTile tile = IntArrayTile$.MODULE$.apply(package$IntArrayFiller$.MODULE$.fill$extension(package$.MODULE$.IntArrayFiller((int[])Array$.MODULE$.ofDim(cols * rows, ClassTag$.MODULE$.Int())), -1), cols, rows);
        for (int index$macro$175 = 0; index$macro$175 < rows; ++index$macro$175) {
            for (int index$macro$174 = 0; index$macro$174 < cols; ++index$macro$174) {
                this.calcAcc(index$macro$174, index$macro$175, tile, flowDirrection);
            }
        }
        return tile;
    }

    private Accumulation$() {
        MODULE$ = this;
    }
}

