/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.hydrology;

import geotrellis.raster.IntArrayTile;
import geotrellis.raster.IntArrayTile$;
import geotrellis.raster.Tile;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

public final class FlowDirection$ {
    public static FlowDirection$ MODULE$;

    static {
        new FlowDirection$();
    }

    public int flow(int c, int r, Tile raster, Map<Object, Object> neighbors) {
        double max = BoxesRunTime.unboxToDouble((Object)neighbors.values().max((Ordering)Ordering.Double$.MODULE$));
        return BoxesRunTime.unboxToInt((Object)((MapLike)neighbors.filter((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)FlowDirection$.$anonfun$flow$1(max, x0$1)))).keys().sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public Map<Object, Object> getNeighbors(int c, int r, Tile raster) {
        int center = raster.get(c, r);
        int ncols = raster.cols();
        int nrows = raster.rows();
        Map distances = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2.mcID.sp(1, 1.0), new Tuple2.mcID.sp(2, package$.MODULE$.sqrt(2.0)), new Tuple2.mcID.sp(4, 1.0), new Tuple2.mcID.sp(8, package$.MODULE$.sqrt(2.0)), new Tuple2.mcID.sp(16, 1.0), new Tuple2.mcID.sp(32, package$.MODULE$.sqrt(2.0)), new Tuple2.mcID.sp(64, 1.0), new Tuple2.mcID.sp(128, package$.MODULE$.sqrt(2.0))}));
        Map map = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)BoxesRunTime.boxToInteger((int)1), (Object)new Tuple2.mcII.sp(c + 1, r)), new Tuple2((Object)BoxesRunTime.boxToInteger((int)2), (Object)new Tuple2.mcII.sp(c + 1, r + 1)), new Tuple2((Object)BoxesRunTime.boxToInteger((int)4), (Object)new Tuple2.mcII.sp(c, r + 1)), new Tuple2((Object)BoxesRunTime.boxToInteger((int)8), (Object)new Tuple2.mcII.sp(c - 1, r + 1)), new Tuple2((Object)BoxesRunTime.boxToInteger((int)16), (Object)new Tuple2.mcII.sp(c - 1, r)), new Tuple2((Object)BoxesRunTime.boxToInteger((int)32), (Object)new Tuple2.mcII.sp(c - 1, r - 1)), new Tuple2((Object)BoxesRunTime.boxToInteger((int)64), (Object)new Tuple2.mcII.sp(c, r - 1)), new Tuple2((Object)BoxesRunTime.boxToInteger((int)128), (Object)new Tuple2.mcII.sp(c + 1, r - 1))}));
        return (Map)((TraversableLike)map.filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)FlowDirection$.$anonfun$getNeighbors$1(raster, ncols, nrows, x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int k = tuple2._1$mcI$sp();
            Tuple2 v = (Tuple2)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)k)), (Object)BoxesRunTime.boxToDouble((double)((double)(center - raster.get(v._1$mcI$sp(), v._2$mcI$sp())) / BoxesRunTime.unboxToDouble((Object)distances.apply((Object)BoxesRunTime.boxToInteger((int)k))))));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
    }

    public boolean isSink(int c, int r, Tile raster) {
        return this.isSink(c, r, raster, this.getNeighbors(c, r, raster));
    }

    public boolean isSink(int c, int r, Tile raster, Map<Object, Object> neighbors) {
        Iterable values = neighbors.values();
        return ((TraversableOnce)values.takeWhile((Function1)(JFunction1.mcZD.sp & Serializable & scala.Serializable)x$1 -> x$1 < 0.0)).size() == values.size();
    }

    public Tile apply(Tile raster) {
        Tuple2<Object, Object> tuple2 = raster.dimensions();
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int cols = tuple2._1$mcI$sp();
        int rows = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(cols, rows);
        Tuple2.mcII.sp sp3 = sp2;
        int cols2 = sp3._1$mcI$sp();
        int rows2 = sp3._2$mcI$sp();
        IntArrayTile tile = IntArrayTile$.MODULE$.apply((int[])Array$.MODULE$.ofDim(rows2 * cols2, ClassTag$.MODULE$.Int()), cols2, rows2);
        for (int r = 0; r < rows2; ++r) {
            for (int c = 0; c < cols2; ++c) {
                Map<Object, Object> neighbors = this.getNeighbors(c, r, raster);
                if (raster.get(c, r) == Integer.MIN_VALUE || this.isSink(c, r, raster, neighbors)) {
                    tile.set(c, r, Integer.MIN_VALUE);
                    continue;
                }
                tile.set(c, r, this.flow(c, r, raster, neighbors));
            }
        }
        return tile;
    }

    public static final /* synthetic */ boolean $anonfun$flow$1(double max$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        double v = tuple2._2$mcD$sp();
        boolean bl = v == max$1;
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getNeighbors$1(Tile raster$1, int ncols$1, int nrows$1, Tuple2 x0$2) {
        Tuple2 tuple2;
        Tuple2 tuple22 = x0$2;
        if (tuple22 == null || (tuple2 = (Tuple2)tuple22._2()) == null) {
            throw new MatchError((Object)tuple22);
        }
        int col = tuple2._1$mcI$sp();
        int row = tuple2._2$mcI$sp();
        boolean bl = 0 <= col && col < ncols$1 && 0 <= row && row < nrows$1 && raster$1.get(col, row) != Integer.MIN_VALUE;
        return bl;
    }

    private FlowDirection$() {
        MODULE$ = this;
    }
}

