/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io;

import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.Tile;
import geotrellis.vector.Extent;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Locale;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.runtime.BoxesRunTime;

public final class AsciiWriter$ {
    public static AsciiWriter$ MODULE$;

    static {
        new AsciiWriter$();
    }

    public String cellType() {
        return "ascii";
    }

    public String dataType() {
        return "";
    }

    public void write(String path, Tile raster, Extent extent, String name) {
        this.write(path, raster, extent, name, Integer.MIN_VALUE);
    }

    public void write(String path, Tile raster, Extent extent, String name, int noData) {
        RasterExtent g = RasterExtent$.MODULE$.apply(extent, raster.cols(), raster.rows());
        Extent e = extent;
        if (g.cellwidth() != g.cellheight()) {
            throw new Exception("raster cannot be written as ASCII");
        }
        PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(path)));
        pw.write(new StringBuilder(7).append("nrows ").append(g.rows()).append("\n").toString());
        pw.write(new StringBuilder(7).append("ncols ").append(g.cols()).append("\n").toString());
        pw.write(new StringOps(Predef$.MODULE$.augmentString("xllcorner %.12f\n")).formatLocal(Locale.ENGLISH, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)e.xmin())})));
        pw.write(new StringOps(Predef$.MODULE$.augmentString("yllcorner %.12f\n")).formatLocal(Locale.ENGLISH, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)e.ymin())})));
        pw.write(new StringOps(Predef$.MODULE$.augmentString("cellsize %.12f\n")).formatLocal(Locale.ENGLISH, (Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)g.cellwidth())})));
        pw.write(new StringBuilder(14).append("nodata_value ").append(noData).append("\n").toString());
        int[] data = raster.toArray();
        for (int y = 0; y < g.rows(); ++y) {
            int span = y * g.cols();
            for (int x = 0; x < g.cols(); ++x) {
                pw.print(" ");
                pw.print(data[span + x]);
            }
            pw.print("\n");
        }
        pw.close();
    }

    private AsciiWriter$() {
        MODULE$ = this;
    }
}

