/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.arg;

import geotrellis.raster.ConstantTile;
import geotrellis.raster.DataType;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.Tile;
import geotrellis.raster.io.arg.ArgWriter$;
import geotrellis.raster.io.arg.CellWriter$;
import geotrellis.vector.Extent;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005=f\u0001B\u0001\u0003\u0001.\u0011\u0011\"\u0011:h/JLG/\u001a:\u000b\u0005\r!\u0011aA1sO*\u0011QAB\u0001\u0003S>T!a\u0002\u0005\u0002\rI\f7\u000f^3s\u0015\u0005I\u0011AC4f_R\u0014X\r\u001c7jg\u000e\u00011\u0003\u0002\u0001\r%U\u0001\"!\u0004\t\u000e\u00039Q\u0011aD\u0001\u0006g\u000e\fG.Y\u0005\u0003#9\u0011a!\u00118z%\u00164\u0007CA\u0007\u0014\u0013\t!bBA\u0004Qe>$Wo\u0019;\u0011\u000551\u0012BA\f\u000f\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!I\u0002A!f\u0001\n\u0003Q\u0012\u0001C2fY2$\u0016\u0010]3\u0016\u0003m\u0001\"\u0001\b\u0014\u000f\u0005u!cB\u0001\u0010$\u001d\ty\"%D\u0001!\u0015\t\t#\"\u0001\u0004=e>|GOP\u0005\u0002\u0013%\u0011q\u0001C\u0005\u0003K\u0019\tq\u0001]1dW\u0006<W-\u0003\u0002(Q\tA1)\u001a7m)f\u0004XM\u0003\u0002&\r!A!\u0006\u0001B\tB\u0003%1$A\u0005dK2dG+\u001f9fA!)A\u0006\u0001C\u0001[\u00051A(\u001b8jiz\"\"A\f\u0019\u0011\u0005=\u0002Q\"\u0001\u0002\t\u000beY\u0003\u0019A\u000e\t\u000bI\u0002A\u0011A\u001a\u0002\u000b]LG\r\u001e5\u0016\u0003Q\u0002\"!D\u001b\n\u0005Yr!aA%oi\")\u0001\b\u0001C\u0001s\u0005a1-\u001a7m)f\u0004XMT1nKV\t!\b\u0005\u0002<\u007f9\u0011A(\u0010\t\u0003?9I!A\u0010\b\u0002\rA\u0013X\rZ3g\u0013\t\u0001\u0015I\u0001\u0004TiJLgn\u001a\u0006\u0003}9AQa\u0011\u0001\u0005\u0002\u0011\u000b\u0001\u0002Z1uCRK\b/Z\u000b\u0002\u000bB\u0011aiS\u0007\u0002\u000f*\u0011\u0001*S\u0001\u0005Y\u0006twMC\u0001K\u0003\u0011Q\u0017M^1\n\u0005\u0001;\u0005\"B'\u0001\t\u0003q\u0015!E<sSR,W*\u001a;bI\u0006$\u0018MS*P\u001dR!qJ\u0015+W!\ti\u0001+\u0003\u0002R\u001d\t!QK\\5u\u0011\u0015\u0019F\n1\u0001;\u0003\u0011\u0001\u0018\r\u001e5\t\u000bUc\u0005\u0019\u0001\u001e\u0002\t9\fW.\u001a\u0005\u0006/2\u0003\r\u0001W\u0001\u0003e\u0016\u0004\"!\u0017.\u000e\u0003\u0019I!a\u0017\u0004\u0003\u0019I\u000b7\u000f^3s\u000bb$XM\u001c;\t\u000bu\u0003A\u0011\u00010\u0002\u000b]\u0014\u0018\u000e^3\u0015\u000b={\u0016M\u001a8\t\u000b\u0001d\u0006\u0019\u0001\u001e\u0002\u001d=,H\u000f];u\r&dW\rU1uQ\")!\r\u0018a\u0001G\u0006!A/\u001b7f!\tIF-\u0003\u0002f\r\t!A+\u001b7f\u0011\u00159G\f1\u0001i\u0003\u0019)\u0007\u0010^3oiB\u0011\u0011\u000e\\\u0007\u0002U*\u00111\u000eC\u0001\u0007m\u0016\u001cGo\u001c:\n\u00055T'AB#yi\u0016tG\u000fC\u0003p9\u0002\u0007!(\u0001\u0007nKR\fG-\u0019;b\u001d\u0006lW\rC\u0003r\u0001\u0011\u0005!/A\u0005xe&$X\rR1uCR\u0019qj\u001d;\t\u000bM\u0003\b\u0019\u0001\u001e\t\u000b\t\u0004\b\u0019A2\t\u000bY\u0004A\u0011A<\u0002#]\u0014\u0018\u000e^3D_:\u001cH/\u00198u)&dW\rF\u0003Pqftx\u0010C\u0003Tk\u0002\u0007!\bC\u0003{k\u0002\u000710\u0001\u0002diB\u0011\u0011\f`\u0005\u0003{\u001a\u0011AbQ8ogR\fg\u000e\u001e+jY\u0016DQ!V;A\u0002iBQaV;A\u0002aC\u0011\"a\u0001\u0001\u0003\u0003%\t!!\u0002\u0002\t\r|\u0007/\u001f\u000b\u0004]\u0005\u001d\u0001\u0002C\r\u0002\u0002A\u0005\t\u0019A\u000e\t\u0013\u0005-\u0001!%A\u0005\u0002\u00055\u0011AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003\u001fQ3aGA\tW\t\t\u0019\u0002\u0005\u0003\u0002\u0016\u0005}QBAA\f\u0015\u0011\tI\"a\u0007\u0002\u0013Ut7\r[3dW\u0016$'bAA\u000f\u001d\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\u0005\u0012q\u0003\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\u0002CA\u0013\u0001\u0005\u0005I\u0011\t#\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u0011!\tI\u0003AA\u0001\n\u0003\u0019\u0014\u0001\u00049s_\u0012,8\r^!sSRL\b\"CA\u0017\u0001\u0005\u0005I\u0011AA\u0018\u00039\u0001(o\u001c3vGR,E.Z7f]R$B!!\r\u00028A\u0019Q\"a\r\n\u0007\u0005UbBA\u0002B]fD\u0011\"!\u000f\u0002,\u0005\u0005\t\u0019\u0001\u001b\u0002\u0007a$\u0013\u0007C\u0005\u0002>\u0001\t\t\u0011\"\u0011\u0002@\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002BA1\u00111IA%\u0003ci!!!\u0012\u000b\u0007\u0005\u001dc\"\u0001\u0006d_2dWm\u0019;j_:LA!a\u0013\u0002F\tA\u0011\n^3sCR|'\u000fC\u0005\u0002P\u0001\t\t\u0011\"\u0001\u0002R\u0005A1-\u00198FcV\fG\u000e\u0006\u0003\u0002T\u0005e\u0003cA\u0007\u0002V%\u0019\u0011q\u000b\b\u0003\u000f\t{w\u000e\\3b]\"Q\u0011\u0011HA'\u0003\u0003\u0005\r!!\r\t\u0013\u0005u\u0003!!A\u0005B\u0005}\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003QB\u0011\"a\u0019\u0001\u0003\u0003%\t%!\u001a\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012!\u0012\u0005\n\u0003S\u0002\u0011\u0011!C!\u0003W\na!Z9vC2\u001cH\u0003BA*\u0003[B!\"!\u000f\u0002h\u0005\u0005\t\u0019AA\u0019\u000f%\t\tHAA\u0001\u0012\u0003\t\u0019(A\u0005Be\u001e<&/\u001b;feB\u0019q&!\u001e\u0007\u0011\u0005\u0011\u0011\u0011!E\u0001\u0003o\u001aR!!\u001e\u0002zU\u0001b!a\u001f\u0002\u0002nqSBAA?\u0015\r\tyHD\u0001\beVtG/[7f\u0013\u0011\t\u0019)! \u0003#\u0005\u00137\u000f\u001e:bGR4UO\\2uS>t\u0017\u0007C\u0004-\u0003k\"\t!a\"\u0015\u0005\u0005M\u0004BCA2\u0003k\n\t\u0011\"\u0012\u0002f!Q\u0011QRA;\u0003\u0003%\t)a$\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u00079\n\t\n\u0003\u0004\u001a\u0003\u0017\u0003\ra\u0007\u0005\u000b\u0003+\u000b)(!A\u0005\u0002\u0006]\u0015aB;oCB\u0004H.\u001f\u000b\u0005\u00033\u000by\n\u0005\u0003\u000e\u00037[\u0012bAAO\u001d\t1q\n\u001d;j_:D\u0011\"!)\u0002\u0014\u0006\u0005\t\u0019\u0001\u0018\u0002\u0007a$\u0003\u0007\u0003\u0006\u0002&\u0006U\u0014\u0011!C\u0005\u0003O\u000b1B]3bIJ+7o\u001c7wKR\u0011\u0011\u0011\u0016\t\u0004\r\u0006-\u0016bAAW\u000f\n1qJ\u00196fGR\u0004")
public class ArgWriter
implements Product,
Serializable {
    private final DataType cellType;

    public static /* bridge */ Object apply(Object object) {
        return ArgWriter$.MODULE$.apply(object);
    }

    public static Option<DataType> unapply(ArgWriter argWriter) {
        return ArgWriter$.MODULE$.unapply(argWriter);
    }

    public static ArgWriter apply(DataType dataType) {
        return ArgWriter$.MODULE$.apply(dataType);
    }

    public static <A> Function1<DataType, A> andThen(Function1<ArgWriter, A> function1) {
        return ArgWriter$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, ArgWriter> compose(Function1<A, DataType> function1) {
        return ArgWriter$.MODULE$.compose(function1);
    }

    public DataType cellType() {
        return this.cellType;
    }

    public int width() {
        return this.cellType().bits() / 8;
    }

    public String cellTypeName() {
        return this.cellType().name();
    }

    public String dataType() {
        return "arg";
    }

    public void writeMetadataJSON(String path, String name, RasterExtent re) {
        String metadata = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(339).append("{\n        |  \"layer\": \"").append(name).append("\",\n        |  \"datatype\": \"").append(this.cellTypeName()).append("\",\n        |  \"type\": \"").append(this.dataType()).append("\",\n        |  \"xmin\": ").append(re.extent().xmin()).append(",\n        |  \"xmax\": ").append(re.extent().xmax()).append(",\n        |  \"ymin\": ").append(re.extent().ymin()).append(",\n        |  \"ymax\": ").append(re.extent().ymax()).append(",\n        |  \"cols\": ").append(re.cols()).append(",\n        |  \"rows\": ").append(re.rows()).append(",\n        |  \"cellwidth\": ").append(re.cellwidth()).append(",\n        |  \"cellheight\": ").append(re.cellheight()).append(",\n        |  \"epsg\": 3785,\n        |  \"yskew\": 0.0,\n        |  \"xskew\": 0.0\n        |}").toString())).stripMargin();
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(path));
        bos.write(metadata.getBytes());
        bos.close();
    }

    public void write(String outputFilePath, Tile tile, Extent extent, String metadataName) {
        String path = outputFilePath;
        String base = path.endsWith(".arg") || path.endsWith(".json") || path.endsWith(".") ? path.substring(0, path.lastIndexOf(".")) : path;
        Tile tile2 = tile;
        if (tile2 instanceof ConstantTile) {
            ConstantTile constantTile = (ConstantTile)tile2;
            this.writeConstantTile(new StringBuilder(5).append(base).append(".json").toString(), constantTile, metadataName, RasterExtent$.MODULE$.apply(extent, tile.cols(), tile.rows()));
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.writeMetadataJSON(new StringBuilder(5).append(base).append(".json").toString(), metadataName, RasterExtent$.MODULE$.apply(extent, tile.cols(), tile.rows()));
            this.writeData(new StringBuilder(4).append(base).append(".arg").toString(), tile);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void writeData(String path, Tile tile) {
        DataOutputStream dos = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(path)));
        CellWriter$.MODULE$.byType(this.cellType()).writeCells(tile, dos);
        dos.close();
    }

    public void writeConstantTile(String path, ConstantTile ct, String name, RasterExtent re) {
        String metadata = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(391).append("{\n        |  \"layer\": \"").append(name).append("\",\n        |  \"datatype\": \"").append(this.cellTypeName()).append("\",\n        |  \"type\": \"constant\",\n        |  \"xmin\": ").append(re.extent().xmin()).append(",\n        |  \"xmax\": ").append(re.extent().xmax()).append(",\n        |  \"ymin\": ").append(re.extent().ymin()).append(",\n        |  \"ymax\": ").append(re.extent().ymax()).append(",\n        |  \"cols\": ").append(re.cols()).append(",\n        |  \"rows\": ").append(re.rows()).append(",\n        |  \"cellwidth\": ").append(re.cellwidth()).append(",\n        |  \"cellheight\": ").append(re.cellheight()).append(",\n        |  \"epsg\": 3785,\n        |  \"yskew\": 0.0,\n        |  \"xskew\": 0.0,\n        |  \"constant\": {ct.getDouble(0,0)}\n        |}").toString())).stripMargin();
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(path));
        bos.write(metadata.getBytes());
        bos.close();
    }

    public ArgWriter copy(DataType cellType) {
        return new ArgWriter(cellType);
    }

    public DataType copy$default$1() {
        return this.cellType();
    }

    public String productPrefix() {
        return "ArgWriter";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.cellType();
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof ArgWriter;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof ArgWriter)) return false;
        boolean bl = true;
        if (!bl) return false;
        ArgWriter argWriter = (ArgWriter)x$1;
        DataType dataType = this.cellType();
        DataType dataType2 = argWriter.cellType();
        if (dataType == null) {
            if (dataType2 != null) {
                return false;
            }
        } else if (!dataType.equals(dataType2)) return false;
        if (!argWriter.canEqual(this)) return false;
        return true;
    }

    public ArgWriter(DataType cellType) {
        this.cellType = cellType;
        Product.$init$((Product)this);
    }
}

