/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.ascii;

import geotrellis.raster.ArrayTile$;
import geotrellis.raster.DataType;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.Tile;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001q3q!\u0001\u0002\u0011\u0002\u0007\u00051BA\u0005SK\u0006$7\u000b^1uK*\u00111\u0001B\u0001\u0006CN\u001c\u0017.\u001b\u0006\u0003\u000b\u0019\t!![8\u000b\u0005\u001dA\u0011A\u0002:bgR,'OC\u0001\n\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\u0005\u0006'\u0001!\t\u0001F\u0001\u0007I%t\u0017\u000e\u001e\u0013\u0015\u0003U\u0001\"!\u0004\f\n\u0005]q!\u0001B+oSRDq!\u0007\u0001C\u0002\u001b\u0005!$\u0001\u0007sCN$XM]#yi\u0016tG/F\u0001\u001c!\taR$D\u0001\u0007\u0013\tqbA\u0001\u0007SCN$XM]#yi\u0016tG\u000fC\u0004!\u0001\t\u0007i\u0011\u0001\u000e\u0002\rQ\f'oZ3u\u0011\u0015\u0011\u0003A\"\u0001$\u0003\u001d9W\r\u001e+za\u0016,\u0012\u0001\n\t\u0003K=r!AJ\u0017\u000f\u0005\u001dbcB\u0001\u0015,\u001b\u0005I#B\u0001\u0016\u000b\u0003\u0019a$o\\8u}%\t\u0011\"\u0003\u0002\b\u0011%\u0011aFB\u0001\ba\u0006\u001c7.Y4f\u0013\t\u0001\u0014G\u0001\u0005DK2dG+\u001f9f\u0015\tqc\u0001C\u00034\u0001\u0011\u0005A'\u0001\u0006de\u0016\fG/\u001a+jY\u0016$2!\u000e\u001d>!\tab'\u0003\u00028\r\t\u0001R*\u001e;bE2,\u0017I\u001d:bsRKG.\u001a\u0005\u0006sI\u0002\rAO\u0001\u0005G>d7\u000f\u0005\u0002\u000ew%\u0011AH\u0004\u0002\u0004\u0013:$\b\"\u0002 3\u0001\u0004Q\u0014\u0001\u0002:poNDa\u0001\u0011\u0001!\u000e#\t\u0015AC5oSR\u001cv.\u001e:dKR\u0019QC\u0011#\t\u000b\r{\u0004\u0019\u0001\u001e\u0002\u0011A|7/\u001b;j_:DQ!R A\u0002i\nAa]5{K\"1q\t\u0001Q\u0007\u0012!\u000b\u0001#Y:tS\u001etgI]8n'>,(oY3\u0015\tUI5*\u0014\u0005\u0006\u0015\u001a\u0003\rAO\u0001\fg>,(oY3J]\u0012,\u0007\u0010C\u0003M\r\u0002\u0007Q'\u0001\u0003eKN$\b\"\u0002(G\u0001\u0004Q\u0014!\u00033fgRLe\u000eZ3y\u0011\u0015\u0001\u0006\u0001\"\u0001\u0015\u0003\u001d!Wm\u001d;s_fDaA\u0015\u0001!\n#\u0019\u0016!\u0003;sC:\u001cH.\u0019;f)\t)B\u000bC\u0003V#\u0002\u0007Q'\u0001\u0003eCR\f\u0007\"B,\u0001\t\u0003A\u0016A\u00037pC\u0012\u0014\u0016m\u001d;feR\t\u0011\f\u0005\u0002\u001d5&\u00111L\u0002\u0002\u0005)&dW\r")
public interface ReadState {
    public RasterExtent rasterExtent();

    public RasterExtent target();

    public DataType getType();

    public static /* synthetic */ MutableArrayTile createTile$(ReadState $this, int cols, int rows) {
        return $this.createTile(cols, rows);
    }

    default public MutableArrayTile createTile(int cols, int rows) {
        return ArrayTile$.MODULE$.empty(this.getType(), cols, rows);
    }

    public void initSource(int var1, int var2);

    public void assignFromSource(int var1, MutableArrayTile var2, int var3);

    public static /* synthetic */ void destroy$(ReadState $this) {
        $this.destroy();
    }

    default public void destroy() {
    }

    public static /* synthetic */ void translate$(ReadState $this, MutableArrayTile data) {
        $this.translate(data);
    }

    default public void translate(MutableArrayTile data) {
    }

    public static /* synthetic */ Tile loadRaster$(ReadState $this) {
        return $this.loadRaster();
    }

    default public Tile loadRaster() {
        RasterExtent re = this.rasterExtent();
        double src_cellwidth = re.cellwidth();
        double src_cellheight = re.cellheight();
        int src_cols = re.cols();
        int src_rows = re.rows();
        double src_xmin = re.extent().xmin();
        double src_ymin = re.extent().ymin();
        double src_xmax = re.extent().xmax();
        double src_ymax = re.extent().ymax();
        int dst_cols = this.target().cols();
        int dst_rows = this.target().rows();
        double dst_cellwidth = (this.target().extent().xmax() - this.target().extent().xmin()) / (double)dst_cols;
        double dst_cellheight = (this.target().extent().ymax() - this.target().extent().ymin()) / (double)dst_rows;
        double xbase = this.target().extent().xmin() - src_xmin + dst_cellwidth / (double)2;
        double ybase = this.target().extent().ymax() - src_ymin - dst_cellheight / (double)2;
        double src_map_width = src_xmax - src_xmin;
        double src_map_height = src_ymax - src_ymin;
        int src_size = src_rows * src_cols;
        this.initSource(0, src_size);
        int dst_size = dst_cols * dst_rows;
        MutableArrayTile resampled = this.createTile(dst_cols, dst_rows);
        int min_col = (int)(xbase / src_cellwidth);
        int max_col = (int)((xbase + (double)dst_cols * dst_cellwidth) / src_cellwidth);
        double y = ybase;
        for (int index$macro$183 = 0; index$macro$183 < dst_rows; ++index$macro$183) {
            int src_row = src_rows - (int)(y / src_cellheight) - 1;
            int src_span = src_row * src_cols;
            int dst_span = index$macro$183 * dst_cols;
            if (src_span + min_col < src_size && src_span + max_col >= 0) {
                double x = xbase;
                for (int index$macro$182 = 0; index$macro$182 < dst_cols; ++index$macro$182) {
                    int src_col = (int)(x / src_cellwidth);
                    int src_i = src_span + src_col;
                    if (src_col >= 0 && src_col < src_cols && src_i < src_size && src_i >= 0) {
                        int dst_i = dst_span + index$macro$182;
                        this.assignFromSource(src_i, resampled, dst_i);
                    }
                    x += dst_cellwidth;
                }
            }
            y -= dst_cellheight;
        }
        this.translate(resampled);
        return resampled;
    }

    public static void $init$(ReadState $this) {
    }
}

