/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.raster.BitArrayTile$;
import geotrellis.raster.DataType;
import geotrellis.raster.io.geotiff.GeoTiffSegment;
import geotrellis.raster.io.geotiff.util.package$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Serializable;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001I4A!\u0001\u0002\u0001\u0017\t\t\")\u001b;HK>$\u0016N\u001a4TK\u001elWM\u001c;\u000b\u0005\r!\u0011aB4f_RLgM\u001a\u0006\u0003\u000b\u0019\t!![8\u000b\u0005\u001dA\u0011A\u0002:bgR,'OC\u0001\n\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001'\r\u0001AB\u0005\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005M!R\"\u0001\u0002\n\u0005U\u0011!AD$f_RKgMZ*fO6,g\u000e\u001e\u0005\t/\u0001\u0011)\u0019!C\u00011\u0005)!-\u001f;fgV\t\u0011\u0004E\u0002\u000e5qI!a\u0007\b\u0003\u000b\u0005\u0013(/Y=\u0011\u00055i\u0012B\u0001\u0010\u000f\u0005\u0011\u0011\u0015\u0010^3\t\u0011\u0001\u0002!\u0011!Q\u0001\ne\taAY=uKN\u0004\u0003\u0002\u0003\u0012\u0001\u0005\u0003\u0005\u000b\u0011B\u0012\u0002\t\r|Gn\u001d\t\u0003\u001b\u0011J!!\n\b\u0003\u0007%sG\u000f\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003$\u0003\u0011\u0011xn^:\t\u000b%\u0002A\u0011\u0001\u0016\u0002\rqJg.\u001b;?)\u0011YC&\f\u0018\u0011\u0005M\u0001\u0001\"B\f)\u0001\u0004I\u0002\"\u0002\u0012)\u0001\u0004\u0019\u0003\"B\u0014)\u0001\u0004\u0019\u0003b\u0002\u0019\u0001\u0005\u0004%\t!M\u0001\u0005g&TX-F\u0001$\u0011\u0019\u0019\u0004\u0001)A\u0005G\u0005)1/\u001b>fA!9Q\u0007\u0001b\u0001\n\u0013\t\u0014A\u00039bI\u0012,GmQ8mg\"1q\u0007\u0001Q\u0001\n\r\n1\u0002]1eI\u0016$7i\u001c7tA!)\u0011\b\u0001C\u0001u\u00051q-\u001a;J]R$\"aI\u001e\t\u000bqB\u0004\u0019A\u0012\u0002\u0003%DQA\u0010\u0001\u0005\u0002}\n\u0011bZ3u\t>,(\r\\3\u0015\u0005\u0001\u001b\u0005CA\u0007B\u0013\t\u0011eB\u0001\u0004E_V\u0014G.\u001a\u0005\u0006yu\u0002\ra\t\u0005\u0006\u000b\u0002!IAR\u0001\u0006S:$W\r\u001f\u000b\u0003G\u001dCQ\u0001\u0010#A\u0002\rBQ!\u0013\u0001\u0005\u0002)\u000b1aZ3u)\ta2\nC\u0003=\u0011\u0002\u00071\u0005C\u0003N\u0001\u0011\u0005a*A\u0002nCB$\"!G(\t\u000bAc\u0005\u0019A)\u0002\u0003\u0019\u0004B!\u0004*$G%\u00111K\u0004\u0002\n\rVt7\r^5p]FBQ!\u0016\u0001\u0005\u0002Y\u000b\u0011\"\\1q\t>,(\r\\3\u0015\u0005e9\u0006\"\u0002)U\u0001\u0004A\u0006\u0003B\u0007S\u0001\u0002CQA\u0017\u0001\u0005\u0002m\u000b!CY=uKR{')\u001b8bef\u001cFO]5oOR\u0011A\f\u001a\t\u0003;\nl\u0011A\u0018\u0006\u0003?\u0002\fA\u0001\\1oO*\t\u0011-\u0001\u0003kCZ\f\u0017BA2_\u0005\u0019\u0019FO]5oO\")Q-\u0017a\u00019\u0005\t!\rC\u0003h\u0001\u0011\u0005\u0001.\u0001\u0007nCB<\u0016\u000e\u001e5J]\u0012,\u0007\u0010\u0006\u0002\u001aS\")\u0001K\u001aa\u0001UB)Qb[\u0012$G%\u0011AN\u0004\u0002\n\rVt7\r^5p]JBQA\u001c\u0001\u0005\u0002=\f!#\\1q\t>,(\r\\3XSRD\u0017J\u001c3fqR\u0011\u0011\u0004\u001d\u0005\u0006!6\u0004\r!\u001d\t\u0006\u001b-\u001c\u0003\t\u0011")
public class BitGeoTiffSegment
implements GeoTiffSegment {
    private final byte[] bytes;
    private final int cols;
    private final int rows;
    private final int size;
    private final int paddedCols;

    @Override
    public byte[] convert(DataType cellType) {
        return GeoTiffSegment.convert$(this, cellType);
    }

    @Override
    public byte[] bytes() {
        return this.bytes;
    }

    @Override
    public int size() {
        return this.size;
    }

    private int paddedCols() {
        return this.paddedCols;
    }

    @Override
    public int getInt(int i) {
        return this.get(i);
    }

    @Override
    public double getDouble(int i) {
        return this.get(i);
    }

    private int index(int i) {
        int col = i % this.cols;
        int row = i / this.cols;
        return row * this.paddedCols() + col;
    }

    public byte get(int i) {
        int i2 = this.index(i);
        return (byte)(package$.MODULE$.invertByte(this.bytes()[i2 >> 3]) >> (i2 & 7) & 1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] map(Function1<Object, Object> f) {
        void var2_2;
        block4: {
            int f1;
            int f0;
            byte[] arr;
            block5: {
                block3: {
                    arr = (byte[])this.bytes().clone();
                    f0 = f.apply$mcII$sp(0) & 1;
                    f1 = f.apply$mcII$sp(1) & 1;
                    if (f0 != 0 || f1 != 0) break block3;
                    for (int index$macro$184 = 0; index$macro$184 < this.size(); ++index$macro$184) {
                        arr[index$macro$184] = (byte)0;
                    }
                    break block4;
                }
                if (f0 != 1 || f1 != 1) break block5;
                for (int index$macro$185 = 0; index$macro$185 < this.size(); ++index$macro$185) {
                    arr[index$macro$185] = (byte)-1;
                }
                break block4;
            }
            if (f0 == 0 && f1 == 1) break block4;
            int len = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(arr)).size();
            for (int i = 0; i < len; ++i) {
                arr[i] = ~this.bytes()[i];
            }
        }
        return var2_2;
    }

    @Override
    public byte[] mapDouble(Function1<Object, Object> f) {
        return this.map((Function1<Object, Object>)(JFunction1.mcII.sp & java.io.Serializable & Serializable)z -> {
            int n = z;
            double n2 = f.apply$mcDD$sp(n == Integer.MIN_VALUE ? Double.NaN : (double)n);
            return Double.isNaN(n2) ? Integer.MIN_VALUE : (int)n2;
        });
    }

    public String byteToBinaryString(byte b) {
        StringBuilder binaryStringBuilder = new StringBuilder();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 8).foreach((Function1 & java.io.Serializable & Serializable)i -> binaryStringBuilder.append((128 >>> BoxesRunTime.unboxToInt((Object)i) & b) == 0 ? (char)'0' : '1'));
        return binaryStringBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] mapWithIndex(Function2<Object, Object, Object> f) {
        void var2_2;
        byte[] arr = (byte[])this.bytes().clone();
        for (int index$macro$187 = 0; index$macro$187 < this.rows; ++index$macro$187) {
            for (int index$macro$186 = 0; index$macro$186 < this.cols; ++index$macro$186) {
                int i = index$macro$187 * this.cols + index$macro$186;
                BitArrayTile$.MODULE$.update(arr, this.index(i), f.apply$mcIII$sp(i, this.getInt(i)));
            }
        }
        for (int index$macro$188 = 0; index$macro$188 < new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(arr)).size(); ++index$macro$188) {
            arr[index$macro$188] = package$.MODULE$.invertByte(arr[index$macro$188]);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] mapDoubleWithIndex(Function2<Object, Object, Object> f) {
        void var2_2;
        byte[] arr = (byte[])this.bytes().clone();
        for (int index$macro$190 = 0; index$macro$190 < this.rows; ++index$macro$190) {
            for (int index$macro$189 = 0; index$macro$189 < this.cols; ++index$macro$189) {
                int i = index$macro$190 * this.cols + index$macro$189;
                BitArrayTile$.MODULE$.updateDouble(arr, this.index(i), f.apply$mcDID$sp(i, this.getDouble(i)));
            }
        }
        for (int index$macro$191 = 0; index$macro$191 < new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(arr)).size(); ++index$macro$191) {
            arr[index$macro$191] = package$.MODULE$.invertByte(arr[index$macro$191]);
        }
        return var2_2;
    }

    public BitGeoTiffSegment(byte[] bytes, int cols, int rows) {
        this.bytes = bytes;
        this.cols = cols;
        this.rows = rows;
        GeoTiffSegment.$init$(this);
        this.size = cols * rows;
        int bytesWidth = (cols + 7) / 8;
        this.paddedCols = bytesWidth * 8;
    }
}

