/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.raster.DataType;
import geotrellis.raster.DoubleConstantNoDataCellType$;
import geotrellis.raster.io.geotiff.GeoTiffSegment;
import java.nio.ByteBuffer;
import java.nio.DoubleBuffer;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000154Q!\u0001\u0002\u0002\u0002-\u0011QC\u00127pCR4DgR3p)&4gmU3h[\u0016tGO\u0003\u0002\u0004\t\u00059q-Z8uS\u001a4'BA\u0003\u0007\u0003\tIwN\u0003\u0002\b\u0011\u00051!/Y:uKJT\u0011!C\u0001\u000bO\u0016|GO]3mY&\u001c8\u0001A\n\u0004\u00011\u0011\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\tqq)Z8US\u001a47+Z4nK:$\b\u0002C\f\u0001\u0005\u000b\u0007I\u0011\u0001\r\u0002\u000b\tLH/Z:\u0016\u0003e\u00012!\u0004\u000e\u001d\u0013\tYbBA\u0003BeJ\f\u0017\u0010\u0005\u0002\u000e;%\u0011aD\u0004\u0002\u0005\u0005f$X\r\u0003\u0005!\u0001\t\u0005\t\u0015!\u0003\u001a\u0003\u0019\u0011\u0017\u0010^3tA!)!\u0005\u0001C\u0001G\u00051A(\u001b8jiz\"\"\u0001J\u0013\u0011\u0005M\u0001\u0001\"B\f\"\u0001\u0004I\u0002bB\u0014\u0001\u0005\u0004%\t\u0002K\u0001\u0007EV4g-\u001a:\u0016\u0003%\u0002\"AK\u0018\u000e\u0003-R!\u0001L\u0017\u0002\u00079LwNC\u0001/\u0003\u0011Q\u0017M^1\n\u0005AZ#\u0001\u0004#pk\ndWMQ;gM\u0016\u0014\bB\u0002\u001a\u0001A\u0003%\u0011&A\u0004ck\u001a4WM\u001d\u0011\t\u000fQ\u0002!\u0019!C\u0001k\u0005!1/\u001b>f+\u00051\u0004CA\u00078\u0013\tAdBA\u0002J]RDaA\u000f\u0001!\u0002\u00131\u0014!B:ju\u0016\u0004\u0003\"\u0002\u001f\u0001\t\u0003i\u0014aA4fiR\u0011a(\u0011\t\u0003\u001b}J!\u0001\u0011\b\u0003\r\u0011{WO\u00197f\u0011\u0015\u00115\b1\u00017\u0003\u0005I\u0007\"\u0002#\u0001\r\u0003)\u0015AB4fi&sG\u000f\u0006\u00027\r\")!i\u0011a\u0001m!)\u0001\n\u0001D\u0001\u0013\u0006Iq-\u001a;E_V\u0014G.\u001a\u000b\u0003})CQAQ$A\u0002YBQ\u0001\u0014\u0001\u0007\u00125\u000ba\"\u001b8u)>$u.\u001e2mK>+H\u000f\u0006\u0002?\u001d\")qj\u0013a\u0001m\u0005\ta\u000fC\u0003R\u0001\u0019E!+A\te_V\u0014G.\u001a+p\t>,(\r\\3PkR$\"AP*\t\u000b=\u0003\u0006\u0019\u0001 \t\u000bU\u0003A\u0011\u0001,\u0002\u00075\f\u0007\u000f\u0006\u0002\u001a/\")\u0001\f\u0016a\u00013\u0006\ta\r\u0005\u0003\u000e5Z2\u0014BA.\u000f\u0005%1UO\\2uS>t\u0017\u0007C\u0003^\u0001\u0011\u0005a,A\u0005nCB$u.\u001e2mKR\u0011\u0011d\u0018\u0005\u00061r\u0003\r\u0001\u0019\t\u0005\u001bisd\bC\u0003c\u0001\u0011\u00051-\u0001\u0007nCB<\u0016\u000e\u001e5J]\u0012,\u0007\u0010\u0006\u0002\u001aI\")\u0001,\u0019a\u0001KB)QB\u001a\u001c7m%\u0011qM\u0004\u0002\n\rVt7\r^5p]JBQ!\u001b\u0001\u0005\u0002)\f!#\\1q\t>,(\r\\3XSRD\u0017J\u001c3fqR\u0011\u0011d\u001b\u0005\u00061\"\u0004\r\u0001\u001c\t\u0006\u001b\u00194dH\u0010")
public abstract class Float64GeoTiffSegment
implements GeoTiffSegment {
    private final byte[] bytes;
    private final DoubleBuffer buffer;
    private final int size;

    @Override
    public byte[] convert(DataType cellType) {
        return GeoTiffSegment.convert$(this, cellType);
    }

    @Override
    public byte[] bytes() {
        return this.bytes;
    }

    public DoubleBuffer buffer() {
        return this.buffer;
    }

    @Override
    public int size() {
        return this.size;
    }

    public double get(int i) {
        return this.buffer().get(i);
    }

    @Override
    public abstract int getInt(int var1);

    @Override
    public abstract double getDouble(int var1);

    public abstract double intToDoubleOut(int var1);

    public abstract double doubleToDoubleOut(double var1);

    @Override
    public byte[] map(Function1<Object, Object> f) {
        double[] arr = (double[])Array$.MODULE$.ofDim(this.size(), ClassTag$.MODULE$.Double());
        for (int index$macro$199 = 0; index$macro$199 < this.size(); ++index$macro$199) {
            int n = f.apply$mcII$sp(this.getInt(index$macro$199));
            arr[index$macro$199] = n == Integer.MIN_VALUE ? Double.NaN : (double)n;
        }
        byte[] result = new byte[this.size() * DoubleConstantNoDataCellType$.MODULE$.bytes()];
        ByteBuffer bytebuff = ByteBuffer.wrap(result);
        bytebuff.asDoubleBuffer().put(arr);
        return result;
    }

    @Override
    public byte[] mapDouble(Function1<Object, Object> f) {
        double[] arr = (double[])Array$.MODULE$.ofDim(this.size(), ClassTag$.MODULE$.Double());
        for (int index$macro$200 = 0; index$macro$200 < this.size(); ++index$macro$200) {
            arr[index$macro$200] = f.apply$mcDD$sp(this.getDouble(index$macro$200));
        }
        byte[] result = new byte[this.size() * DoubleConstantNoDataCellType$.MODULE$.bytes()];
        ByteBuffer bytebuff = ByteBuffer.wrap(result);
        bytebuff.asDoubleBuffer().put(arr);
        return result;
    }

    @Override
    public byte[] mapWithIndex(Function2<Object, Object, Object> f) {
        double[] arr = (double[])Array$.MODULE$.ofDim(this.size(), ClassTag$.MODULE$.Double());
        for (int index$macro$201 = 0; index$macro$201 < this.size(); ++index$macro$201) {
            int n = f.apply$mcIII$sp(index$macro$201, this.getInt(index$macro$201));
            arr[index$macro$201] = n == Integer.MIN_VALUE ? Double.NaN : (double)n;
        }
        byte[] result = new byte[this.size() * DoubleConstantNoDataCellType$.MODULE$.bytes()];
        ByteBuffer bytebuff = ByteBuffer.wrap(result);
        bytebuff.asDoubleBuffer().put(arr);
        return result;
    }

    @Override
    public byte[] mapDoubleWithIndex(Function2<Object, Object, Object> f) {
        double[] arr = (double[])Array$.MODULE$.ofDim(this.size(), ClassTag$.MODULE$.Double());
        for (int index$macro$202 = 0; index$macro$202 < this.size(); ++index$macro$202) {
            arr[index$macro$202] = f.apply$mcDID$sp(index$macro$202, this.getDouble(index$macro$202));
        }
        byte[] result = new byte[this.size() * DoubleConstantNoDataCellType$.MODULE$.bytes()];
        ByteBuffer bytebuff = ByteBuffer.wrap(result);
        bytebuff.asDoubleBuffer().put(arr);
        return result;
    }

    public Float64GeoTiffSegment(byte[] bytes) {
        this.bytes = bytes;
        GeoTiffSegment.$init$(this);
        this.buffer = ByteBuffer.wrap(bytes).asDoubleBuffer();
        this.size = new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).size() / 8;
    }
}

