/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.proj4.CRS;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.CellGrid;
import geotrellis.raster.DataType;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.MultibandTile$;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.TileLayout;
import geotrellis.raster.io.geotiff.ArraySegmentBytes;
import geotrellis.raster.io.geotiff.BandInterleave$;
import geotrellis.raster.io.geotiff.GeoTiff;
import geotrellis.raster.io.geotiff.GeoTiffBuilder;
import geotrellis.raster.io.geotiff.GeoTiffBuilder$;
import geotrellis.raster.io.geotiff.GeoTiffMultibandTile;
import geotrellis.raster.io.geotiff.GeoTiffMultibandTile$;
import geotrellis.raster.io.geotiff.GeoTiffOptions;
import geotrellis.raster.io.geotiff.GeoTiffSegment$;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout;
import geotrellis.raster.io.geotiff.GeoTiffTile;
import geotrellis.raster.io.geotiff.GeoTiffTile$;
import geotrellis.raster.io.geotiff.InterleaveMethod;
import geotrellis.raster.io.geotiff.MultibandGeoTiff;
import geotrellis.raster.io.geotiff.MultibandGeoTiff$;
import geotrellis.raster.io.geotiff.PixelInterleave$;
import geotrellis.raster.io.geotiff.SinglebandGeoTiff;
import geotrellis.raster.io.geotiff.SinglebandGeoTiff$;
import geotrellis.raster.io.geotiff.StorageMethod;
import geotrellis.raster.io.geotiff.Tags;
import geotrellis.raster.io.geotiff.compression.Compression;
import geotrellis.raster.io.geotiff.compression.Compressor;
import geotrellis.vector.Extent;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Product2;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.Iterator;
import scala.collection.Traversable;
import scala.collection.immutable.Map;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.ScalaRunTime$;

public final class GeoTiffBuilder$
implements scala.Serializable {
    public static GeoTiffBuilder$ MODULE$;
    private final GeoTiffBuilder<Tile> singlebandGeoTiffBuilder;
    private final GeoTiffBuilder<MultibandTile> multibandGeoTiffBuilder;

    static {
        new GeoTiffBuilder$();
    }

    public <T extends CellGrid> GeoTiffBuilder<T> apply(GeoTiffBuilder<T> evidence$1) {
        return (GeoTiffBuilder)Predef$.MODULE$.implicitly(evidence$1);
    }

    public GeoTiffBuilder<Tile> singlebandGeoTiffBuilder() {
        return this.singlebandGeoTiffBuilder;
    }

    public GeoTiffBuilder<MultibandTile> multibandGeoTiffBuilder() {
        return this.multibandGeoTiffBuilder;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private GeoTiffBuilder$() {
        MODULE$ = this;
        this.singlebandGeoTiffBuilder = new GeoTiffBuilder<Tile>(){

            public CellGrid makeTile(Iterator segments, TileLayout tileLayout, DataType cellType, StorageMethod storageMethod, Compression compression) {
                return GeoTiffBuilder.makeTile$(this, segments, tileLayout, cellType, storageMethod, compression);
            }

            public GeoTiff<Tile> fromSegments(Map<? extends Product2<Object, Object>, Tile> segments, Function2<Object, Object, Extent> tileExtent, CRS crs, GeoTiffOptions options, Tags tags) {
                return GeoTiffBuilder.fromSegments$(this, segments, tileExtent, crs, options, tags);
            }

            public Tags fromSegments$default$5() {
                return GeoTiffBuilder.fromSegments$default$5$(this);
            }

            public GeoTiffTile makeTile(Iterator<Tuple2<Product2<Object, Object>, Tile>> segments, GeoTiffSegmentLayout segmentLayout, DataType cellType, Compression compression) {
                LazyRef emptySegment$lzy = new LazyRef();
                TileLayout tileLayout = segmentLayout.tileLayout();
                int segmentCount = tileLayout.layoutCols() * tileLayout.layoutRows();
                Compressor compressor = compression.createCompressor(segmentCount);
                byte[][] segmentBytes = (byte[][])Array$.MODULE$.ofDim(segmentCount, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
                segments.foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    anon.1.$anonfun$makeTile$1(cellType, tileLayout, compressor, segmentBytes, x0$2);
                    return BoxedUnit.UNIT;
                });
                for (int index$macro$203 = 0; index$macro$203 < segmentBytes.length; ++index$macro$203) {
                    if (segmentBytes[index$macro$203] != null) continue;
                    segmentBytes[index$macro$203] = compressor.compress(anon.1.emptySegment$1(cellType, tileLayout, emptySegment$lzy), index$macro$203);
                }
                return GeoTiffTile$.MODULE$.apply(new ArraySegmentBytes(segmentBytes), compressor.createDecompressor(), segmentLayout, compression, cellType, GeoTiffTile$.MODULE$.apply$default$6(), GeoTiffTile$.MODULE$.apply$default$7());
            }

            public SinglebandGeoTiff makeGeoTiff(Tile tile, Extent extent, CRS crs, Tags tags, GeoTiffOptions options) {
                return new SinglebandGeoTiff(tile, extent, crs, tags, options, SinglebandGeoTiff$.MODULE$.apply$default$6());
            }

            public static final /* synthetic */ void $anonfun$makeTile$1(DataType cellType$1, TileLayout tileLayout$1, Compressor compressor$1, byte[][] segmentBytes$1, Tuple2 x0$2) {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Product2 key = (Product2)tuple2._1();
                Tile tile = (Tile)tuple2._2();
                int layoutCol = key._1$mcI$sp();
                int layoutRow = key._2$mcI$sp();
                Predef$.MODULE$.require(layoutCol < tileLayout$1.layoutCols(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(7).append("col ").append(layoutCol).append(" < ").append(tileLayout$1.layoutCols()).toString());
                Predef$.MODULE$.require(layoutRow < tileLayout$1.layoutRows(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(7).append("row ").append(layoutRow).append(" < ").append(tileLayout$1.layoutRows()).toString());
                int index = tileLayout$1.layoutCols() * layoutRow + layoutCol;
                byte[] bytes = tile.interpretAs(cellType$1).toBytes();
                segmentBytes$1[index] = compressor$1.compress(bytes, index);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }

            private static final /* synthetic */ byte[] emptySegment$lzycompute$1(DataType cellType$1, TileLayout tileLayout$1, LazyRef emptySegment$lzy$1) {
                byte[] byArray;
                LazyRef lazyRef = emptySegment$lzy$1;
                synchronized (lazyRef) {
                    byArray = emptySegment$lzy$1.initialized() ? (byte[])emptySegment$lzy$1.value() : (byte[])emptySegment$lzy$1.initialize((Object)ArrayTile$.MODULE$.empty(cellType$1, tileLayout$1.tileCols(), tileLayout$1.tileRows()).toBytes());
                }
                return byArray;
            }

            private static final byte[] emptySegment$1(DataType cellType$1, TileLayout tileLayout$1, LazyRef emptySegment$lzy$1) {
                return emptySegment$lzy$1.initialized() ? (byte[])emptySegment$lzy$1.value() : anon.1.emptySegment$lzycompute$1(cellType$1, tileLayout$1, emptySegment$lzy$1);
            }
            {
                GeoTiffBuilder.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$makeTile$1$adapted(geotrellis.raster.DataType geotrellis.raster.TileLayout geotrellis.raster.io.geotiff.compression.Compressor byte[][] scala.Tuple2 ), $anonfun$makeTile$2(geotrellis.raster.TileLayout int ), $anonfun$makeTile$3(geotrellis.raster.TileLayout int )}, serializedLambda);
            }
        };
        this.multibandGeoTiffBuilder = new GeoTiffBuilder<MultibandTile>(){

            public CellGrid makeTile(Iterator segments, TileLayout tileLayout, DataType cellType, StorageMethod storageMethod, Compression compression) {
                return GeoTiffBuilder.makeTile$(this, segments, tileLayout, cellType, storageMethod, compression);
            }

            public GeoTiff<MultibandTile> fromSegments(Map<? extends Product2<Object, Object>, MultibandTile> segments, Function2<Object, Object, Extent> tileExtent, CRS crs, GeoTiffOptions options, Tags tags) {
                return GeoTiffBuilder.fromSegments$(this, segments, tileExtent, crs, options, tags);
            }

            public Tags fromSegments$default$5() {
                return GeoTiffBuilder.fromSegments$default$5$(this);
            }

            public GeoTiffMultibandTile makeTile(Iterator<Tuple2<Product2<Object, Object>, MultibandTile>> segments, GeoTiffSegmentLayout segmentLayout, DataType cellType, Compression compression) {
                Tuple2 tuple2;
                BufferedIterator buffered = segments.buffered();
                int bandCount = ((MultibandTile)((Tuple2)buffered.head())._2()).bandCount();
                TileLayout tileLayout = segmentLayout.tileLayout();
                int cols = tileLayout.tileCols();
                int rows = tileLayout.tileRows();
                InterleaveMethod interleaveMethod = segmentLayout.interleaveMethod();
                if (PixelInterleave$.MODULE$.equals(interleaveMethod)) {
                    LazyRef emptySegment$lzy = new LazyRef();
                    int segmentCount = tileLayout.layoutCols() * tileLayout.layoutRows();
                    Compressor compressor = compression.createCompressor(segmentCount);
                    byte[][] segmentBytes = (byte[][])Array$.MODULE$.ofDim(segmentCount, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
                    buffered.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                        anon.2.$anonfun$makeTile$4(cellType, tileLayout, compressor, segmentBytes, x0$3);
                        return BoxedUnit.UNIT;
                    });
                    for (int index$macro$204 = 0; index$macro$204 < segmentBytes.length; ++index$macro$204) {
                        if (segmentBytes[index$macro$204] != null) continue;
                        segmentBytes[index$macro$204] = compressor.compress(anon.2.emptySegment$2(cellType, bandCount, cols, rows, emptySegment$lzy), index$macro$204);
                    }
                    tuple2 = new Tuple2((Object)segmentBytes, (Object)compressor);
                } else if (BandInterleave$.MODULE$.equals(interleaveMethod)) {
                    int bandSegmentCount = tileLayout.layoutCols() * tileLayout.layoutRows();
                    int segmentCount = bandSegmentCount * bandCount;
                    Compressor compressor = compression.createCompressor(segmentCount);
                    byte[][] segmentBytes = (byte[][])Array$.MODULE$.ofDim(segmentCount, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
                    buffered.foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                        anon.2.$anonfun$makeTile$6(cellType, tileLayout, bandSegmentCount, compressor, segmentBytes, x0$4);
                        return BoxedUnit.UNIT;
                    });
                    tuple2 = new Tuple2((Object)segmentBytes, (Object)compressor);
                } else {
                    throw new MatchError((Object)interleaveMethod);
                }
                Tuple2 tuple22 = tuple2;
                if (tuple22 == null) {
                    throw new MatchError((Object)tuple22);
                }
                byte[][] segmentBytes = (byte[][])tuple22._1();
                Compressor compressor = (Compressor)tuple22._2();
                Tuple2 tuple23 = new Tuple2((Object)segmentBytes, (Object)compressor);
                Tuple2 tuple24 = tuple23;
                byte[][] segmentBytes2 = (byte[][])tuple24._1();
                Compressor compressor2 = (Compressor)tuple24._2();
                return GeoTiffMultibandTile$.MODULE$.apply(new ArraySegmentBytes(segmentBytes2), compressor2.createDecompressor(), segmentLayout, compression, bandCount, cellType, GeoTiffMultibandTile$.MODULE$.apply$default$7(), GeoTiffMultibandTile$.MODULE$.apply$default$8());
            }

            public MultibandGeoTiff makeGeoTiff(MultibandTile tile, Extent extent, CRS crs, Tags tags, GeoTiffOptions options) {
                return new MultibandGeoTiff(tile, extent, crs, tags, options, MultibandGeoTiff$.MODULE$.apply$default$6());
            }

            public static final /* synthetic */ void $anonfun$makeTile$4(DataType cellType$2, TileLayout tileLayout$2, Compressor compressor$2, byte[][] segmentBytes$2, Tuple2 x0$3) {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Product2 key = (Product2)tuple2._1();
                MultibandTile tile = (MultibandTile)tuple2._2();
                int layoutCol = key._1$mcI$sp();
                int layoutRow = key._2$mcI$sp();
                int index = tileLayout$2.layoutCols() * layoutRow + layoutCol;
                byte[] bytes = GeoTiffSegment$.MODULE$.pixelInterleave(tile.interpretAs(cellType$2));
                segmentBytes$2[index] = compressor$2.compress(bytes, index);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }

            private static final /* synthetic */ byte[] emptySegment$lzycompute$2(DataType cellType$2, int bandCount$1, int cols$1, int rows$1, LazyRef emptySegment$lzy$2) {
                byte[] byArray;
                LazyRef lazyRef = emptySegment$lzy$2;
                synchronized (lazyRef) {
                    byArray = emptySegment$lzy$2.initialized() ? (byte[])emptySegment$lzy$2.value() : (byte[])emptySegment$lzy$2.initialize((Object)GeoTiffSegment$.MODULE$.pixelInterleave(MultibandTile$.MODULE$.apply((Traversable<Tile>)Predef$.MODULE$.wrapRefArray((Object[])Array$.MODULE$.fill(bandCount$1, (Function0 & Serializable & scala.Serializable)() -> ArrayTile$.MODULE$.empty(cellType$2, cols$1, rows$1), ClassTag$.MODULE$.apply(MutableArrayTile.class))))));
                }
                return byArray;
            }

            private static final byte[] emptySegment$2(DataType cellType$2, int bandCount$1, int cols$1, int rows$1, LazyRef emptySegment$lzy$2) {
                return emptySegment$lzy$2.initialized() ? (byte[])emptySegment$lzy$2.value() : anon.2.emptySegment$lzycompute$2(cellType$2, bandCount$1, cols$1, rows$1, emptySegment$lzy$2);
            }

            public static final /* synthetic */ void $anonfun$makeTile$6(DataType cellType$2, TileLayout tileLayout$2, int bandSegmentCount$1, Compressor compressor$3, byte[][] segmentBytes$3, Tuple2 x0$4) {
                Tuple2 tuple2 = x0$4;
                if (tuple2 != null) {
                    Product2 key = (Product2)tuple2._1();
                    MultibandTile tile = (MultibandTile)tuple2._2();
                    for (int index$macro$205 = 0; index$macro$205 < tile.bandCount(); ++index$macro$205) {
                        int layoutCol = key._1$mcI$sp();
                        int layoutRow = key._2$mcI$sp();
                        int bandSegmentOffset = bandSegmentCount$1 * index$macro$205;
                        int index = tileLayout$2.layoutCols() * layoutRow + layoutCol + bandSegmentOffset;
                        byte[] bytes = tile.band(index$macro$205).interpretAs(cellType$2).toBytes();
                        segmentBytes$3[index] = compressor$3.compress(bytes, index);
                    }
                } else {
                    throw new MatchError((Object)tuple2);
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            {
                GeoTiffBuilder.$init$(this);
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$makeTile$4$adapted(geotrellis.raster.DataType geotrellis.raster.TileLayout geotrellis.raster.io.geotiff.compression.Compressor byte[][] scala.Tuple2 ), $anonfun$makeTile$6$adapted(geotrellis.raster.DataType geotrellis.raster.TileLayout int geotrellis.raster.io.geotiff.compression.Compressor byte[][] scala.Tuple2 ), $anonfun$makeTile$5(geotrellis.raster.DataType int int )}, serializedLambda);
            }
        };
    }
}

