/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.raster.BitArrayTile$;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.io.geotiff.GeoTiffSegment;
import geotrellis.raster.io.geotiff.util.package$;
import java.io.Serializable;
import java.nio.ByteBuffer;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class GeoTiffSegment$ {
    public static GeoTiffSegment$ MODULE$;

    static {
        new GeoTiffSegment$();
    }

    public byte[][] deinterleave(byte[] bytes, int bandCount, int bytesPerSample) {
        byte[][] bands = new byte[bandCount][];
        int segmentSize = bytes.length / bandCount;
        for (int index$macro$263 = 0; index$macro$263 < bandCount; ++index$macro$263) {
            bands[index$macro$263] = new byte[segmentSize];
        }
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        for (int index$macro$265 = 0; index$macro$265 < segmentSize; index$macro$265 += bytesPerSample) {
            for (int index$macro$264 = 0; index$macro$264 < bandCount; ++index$macro$264) {
                bb.get(bands[index$macro$264], index$macro$265, bytesPerSample);
            }
        }
        return bands;
    }

    public byte[] deinterleave(byte[] bytes, int bandCount, int bytesPerSample, int index) {
        int n = index;
        return (byte[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.deinterleave(bytes, bandCount, bytesPerSample, (Traversable<Object>)Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToInteger((int)n))))).head();
    }

    public byte[][] deinterleave(byte[] bytes, int bandCount, int bytesPerSample, Traversable<Object> indices) {
        List indicesList = indices.toList();
        Map bandToIndex = ((TraversableOnce)indicesList.zipWithIndex(List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        int actualBandCount = indicesList.length();
        byte[][] bands = new byte[actualBandCount][];
        int segmentSize = bytes.length / bandCount;
        for (int index$macro$266 = 0; index$macro$266 < actualBandCount; ++index$macro$266) {
            bands[index$macro$266] = new byte[segmentSize];
        }
        ByteBuffer bb = ByteBuffer.wrap(bytes);
        for (int index$macro$268 = 0; index$macro$268 < segmentSize; index$macro$268 += bytesPerSample) {
            for (int index$macro$267 = 0; index$macro$267 < bandCount; ++index$macro$267) {
                if (indicesList.contains((Object)BoxesRunTime.boxToInteger((int)index$macro$267))) {
                    bb.get(bands[BoxesRunTime.unboxToInt((Object)bandToIndex.apply((Object)BoxesRunTime.boxToInteger((int)index$macro$267)))], index$macro$268, bytesPerSample);
                    continue;
                }
                bb.position(bb.position() + bytesPerSample);
            }
        }
        return bands;
    }

    public byte[][] deinterleaveBitSegment(GeoTiffSegment segment, int cols, int rows, int bandCount) {
        int bytesWidth = (cols + 7) / 8;
        int paddedCols = bytesWidth * 8;
        int resultByteCount = paddedCols / 8 * rows;
        byte[][] bands = (byte[][])Array$.MODULE$.fill(bandCount, (Function0 & Serializable & scala.Serializable)() -> (byte[])Array$.MODULE$.ofDim(resultByteCount, ClassTag$.MODULE$.Byte()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        for (int index$macro$269 = 0; index$macro$269 < segment.size(); ++index$macro$269) {
            int bandIndex = index$macro$269 % bandCount;
            int j = index$macro$269 / bandCount;
            int col = j % cols;
            int row = j / cols;
            int i2 = row * paddedCols + col;
            BitArrayTile$.MODULE$.update(bands[bandIndex], i2, segment.getInt(index$macro$269));
        }
        for (int index$macro$271 = 0; index$macro$271 < bandCount; ++index$macro$271) {
            byte[] bytes = bands[index$macro$271];
            for (int index$macro$270 = 0; index$macro$270 < bytes.length; ++index$macro$270) {
                bytes[index$macro$270] = package$.MODULE$.invertByte(bytes[index$macro$270]);
            }
        }
        return bands;
    }

    public byte[] deinterleaveBitSegment(GeoTiffSegment segment, int cols, int rows, int bandCount, int index) {
        int n = index;
        return (byte[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.deinterleaveBitSegment(segment, cols, rows, bandCount, (Traversable<Object>)Nil$.MODULE$.$colon$colon((Object)BoxesRunTime.boxToInteger((int)n))))).head();
    }

    public byte[][] deinterleaveBitSegment(GeoTiffSegment segment, int cols, int rows, int bandCount, Traversable<Object> indices) {
        int bytesWidth = (cols + 7) / 8;
        int paddedCols = bytesWidth * 8;
        int resultByteCount = paddedCols / 8 * rows;
        List indicesList = indices.toList();
        Map bandToIndex = ((TraversableOnce)indicesList.zipWithIndex(List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        int actualBandCount = indicesList.length();
        byte[][] bands = (byte[][])Array$.MODULE$.fill(actualBandCount, (Function0 & Serializable & scala.Serializable)() -> (byte[])Array$.MODULE$.ofDim(resultByteCount, ClassTag$.MODULE$.Byte()), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        for (int index$macro$272 = 0; index$macro$272 < segment.size(); ++index$macro$272) {
            int bandIndex = index$macro$272 % bandCount;
            if (!indicesList.contains((Object)BoxesRunTime.boxToInteger((int)bandIndex))) continue;
            int j = index$macro$272 / bandCount;
            int col = j % cols;
            int row = j / cols;
            int i2 = row * paddedCols + col;
            BitArrayTile$.MODULE$.update(bands[BoxesRunTime.unboxToInt((Object)bandToIndex.apply((Object)BoxesRunTime.boxToInteger((int)bandIndex)))], i2, segment.getInt(index$macro$272));
        }
        for (int index$macro$274 = 0; index$macro$274 < actualBandCount; ++index$macro$274) {
            byte[] bytes = bands[index$macro$274];
            for (int index$macro$273 = 0; index$macro$273 < bytes.length; ++index$macro$273) {
                bytes[index$macro$273] = package$.MODULE$.invertByte(bytes[index$macro$273]);
            }
        }
        return bands;
    }

    public byte[] pixelInterleave(MultibandTile tile) {
        int bandCount = tile.bandCount();
        int byteCount = tile.cellType().bytes();
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(byteCount * bandCount * tile.cols() * tile.rows(), ClassTag$.MODULE$.Byte());
        Vector bandBytes = (Vector)tile.bands().map((Function1 & Serializable & scala.Serializable)x$71 -> x$71.toBytes(), Vector$.MODULE$.canBuildFrom());
        int segIndex = 0;
        for (int index$macro$277 = 0; index$macro$277 < tile.cols() * tile.rows(); ++index$macro$277) {
            for (int index$macro$276 = 0; index$macro$276 < bandCount; ++index$macro$276) {
                byte[] bandByteArr = (byte[])bandBytes.apply(index$macro$276);
                for (int index$macro$275 = 0; index$macro$275 < byteCount; ++index$macro$275) {
                    int bandByteIndex = index$macro$277 * byteCount + index$macro$275;
                    bytes[segIndex] = bandByteArr[index$macro$277 * byteCount + index$macro$275];
                    ++segIndex;
                }
            }
        }
        return bytes;
    }

    private GeoTiffSegment$() {
        MODULE$ = this;
    }
}

