/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.raster.TileLayout;
import geotrellis.raster.io.geotiff.BandType;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout;
import geotrellis.raster.io.geotiff.InterleaveMethod;
import geotrellis.raster.io.geotiff.StorageMethod;
import geotrellis.raster.io.geotiff.Striped;
import geotrellis.raster.io.geotiff.Tiled;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple5;
import scala.math.package$;
import scala.runtime.BoxesRunTime;

public final class GeoTiffSegmentLayout$
implements Serializable {
    public static GeoTiffSegmentLayout$ MODULE$;

    static {
        new GeoTiffSegmentLayout$();
    }

    public GeoTiffSegmentLayout apply(int totalCols, int totalRows, StorageMethod storageMethod, InterleaveMethod interleaveMethod, BandType bandType) {
        TileLayout tileLayout;
        StorageMethod storageMethod2 = storageMethod;
        if (storageMethod2 instanceof Tiled) {
            Tiled tiled = (Tiled)storageMethod2;
            int blockCols = tiled.blockCols();
            int blockRows = tiled.blockRows();
            int layoutCols = (int)package$.MODULE$.ceil((double)totalCols / (double)blockCols);
            int layoutRows = (int)package$.MODULE$.ceil((double)totalRows / (double)blockRows);
            tileLayout = new TileLayout(layoutCols, layoutRows, blockCols, blockRows);
        } else if (storageMethod2 instanceof Striped) {
            Striped striped = (Striped)storageMethod2;
            int rowsPerStrip = package$.MODULE$.min(striped.rowsPerStrip(totalRows, bandType), totalRows);
            int layoutRows = (int)package$.MODULE$.ceil((double)totalRows / (double)rowsPerStrip);
            tileLayout = new TileLayout(1, layoutRows, totalCols, rowsPerStrip);
        } else {
            throw new MatchError((Object)storageMethod2);
        }
        TileLayout tileLayout2 = tileLayout;
        return new GeoTiffSegmentLayout(totalCols, totalRows, tileLayout2, storageMethod, interleaveMethod);
    }

    public GeoTiffSegmentLayout apply(int totalCols, int totalRows, TileLayout tileLayout, StorageMethod storageMethod, InterleaveMethod interleaveMethod) {
        return new GeoTiffSegmentLayout(totalCols, totalRows, tileLayout, storageMethod, interleaveMethod);
    }

    public Option<Tuple5<Object, Object, TileLayout, StorageMethod, InterleaveMethod>> unapply(GeoTiffSegmentLayout x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple5((Object)BoxesRunTime.boxToInteger((int)x$0.totalCols()), (Object)BoxesRunTime.boxToInteger((int)x$0.totalRows()), (Object)x$0.tileLayout(), (Object)x$0.storageMethod(), (Object)x$0.interleaveMethod()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private GeoTiffSegmentLayout$() {
        MODULE$ = this;
    }
}

