/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.raster.GridBounds;
import geotrellis.raster.PixelIsArea$;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.TileLayout;
import geotrellis.raster.io.geotiff.BandType;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout$;
import geotrellis.raster.io.geotiff.InterleaveMethod;
import geotrellis.raster.io.geotiff.PixelInterleave$;
import geotrellis.raster.io.geotiff.StorageMethod;
import geotrellis.raster.io.geotiff.Tiled;
import geotrellis.raster.rasterize.Rasterizer;
import geotrellis.raster.rasterize.Rasterizer$;
import geotrellis.vector.Extent;
import geotrellis.vector.Geometry;
import java.io.Serializable;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\t\u0015c\u0001B\u0001\u0003\u0001.\u0011AcR3p)&4gmU3h[\u0016tG\u000fT1z_V$(BA\u0002\u0005\u0003\u001d9Wm\u001c;jM\u001aT!!\u0002\u0004\u0002\u0005%|'BA\u0004\t\u0003\u0019\u0011\u0018m\u001d;fe*\t\u0011\"\u0001\u0006hK>$(/\u001a7mSN\u001c\u0001a\u0005\u0003\u0001\u0019I)\u0002CA\u0007\u0011\u001b\u0005q!\"A\b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Eq!AB!osJ+g\r\u0005\u0002\u000e'%\u0011AC\u0004\u0002\b!J|G-^2u!\tia#\u0003\u0002\u0018\u001d\ta1+\u001a:jC2L'0\u00192mK\"A\u0011\u0004\u0001BK\u0002\u0013\u0005!$A\u0005u_R\fGnQ8mgV\t1\u0004\u0005\u0002\u000e9%\u0011QD\u0004\u0002\u0004\u0013:$\b\u0002C\u0010\u0001\u0005#\u0005\u000b\u0011B\u000e\u0002\u0015Q|G/\u00197D_2\u001c\b\u0005\u0003\u0005\"\u0001\tU\r\u0011\"\u0001\u001b\u0003%!x\u000e^1m%><8\u000f\u0003\u0005$\u0001\tE\t\u0015!\u0003\u001c\u0003)!x\u000e^1m%><8\u000f\t\u0005\tK\u0001\u0011)\u001a!C\u0001M\u0005QA/\u001b7f\u0019\u0006Lx.\u001e;\u0016\u0003\u001d\u0002\"\u0001K\u0015\u000e\u0003\u0019I!A\u000b\u0004\u0003\u0015QKG.\u001a'bs>,H\u000f\u0003\u0005-\u0001\tE\t\u0015!\u0003(\u0003-!\u0018\u000e\\3MCf|W\u000f\u001e\u0011\t\u00119\u0002!Q3A\u0005\u0002=\nQb\u001d;pe\u0006<W-T3uQ>$W#\u0001\u0019\u0011\u0005E\u0012T\"\u0001\u0002\n\u0005M\u0012!!D*u_J\fw-Z'fi\"|G\r\u0003\u00056\u0001\tE\t\u0015!\u00031\u00039\u0019Ho\u001c:bO\u0016lU\r\u001e5pI\u0002B\u0001b\u000e\u0001\u0003\u0016\u0004%\t\u0001O\u0001\u0011S:$XM\u001d7fCZ,W*\u001a;i_\u0012,\u0012!\u000f\t\u0003ciJ!a\u000f\u0002\u0003!%sG/\u001a:mK\u00064X-T3uQ>$\u0007\u0002C\u001f\u0001\u0005#\u0005\u000b\u0011B\u001d\u0002#%tG/\u001a:mK\u00064X-T3uQ>$\u0007\u0005C\u0003@\u0001\u0011\u0005\u0001)\u0001\u0004=S:LGO\u0010\u000b\u0007\u0003\n\u001bE)\u0012$\u0011\u0005E\u0002\u0001\"B\r?\u0001\u0004Y\u0002\"B\u0011?\u0001\u0004Y\u0002\"B\u0013?\u0001\u00049\u0003\"\u0002\u0018?\u0001\u0004\u0001\u0004\"B\u001c?\u0001\u0004I\u0004\"\u0002%\u0001\t\u0003I\u0015aB5t)&dW\rZ\u000b\u0002\u0015B\u0011QbS\u0005\u0003\u0019:\u0011qAQ8pY\u0016\fg\u000eC\u0003O\u0001\u0011\u0005\u0011*A\u0005jgN#(/\u001b9fI\")\u0001\u000b\u0001C\u0001\u0013\u0006\u0011\u0002.Y:QSb,G.\u00138uKJdW-\u0019<f\u0011\u0019\u0011\u0006\u0001\"\u0001\u0003'\u0006yq-\u001a;TK\u001elWM\u001c;J]\u0012,\u0007\u0010F\u0002\u001c)ZCQ!V)A\u0002m\t1aY8m\u0011\u00159\u0016\u000b1\u0001\u001c\u0003\r\u0011xn\u001e\u0005\u00063\u0002!\tAW\u0001\u001ba\u0006\u0014H/\u001b;j_:<\u0016N\u001c3poN\u0014\u0015pU3h[\u0016tGo\u001d\u000b\u00047\n\u0004\bcA\u0007]=&\u0011QL\u0004\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004\u001bq{\u0006C\u0001\u0015a\u0013\t\tgA\u0001\u0006He&$'i\\;oINDQa\u0019-A\u0002\u0011\fqa^5oI><8\u000fE\u0002f[~s!AZ6\u000f\u0005\u001dTW\"\u00015\u000b\u0005%T\u0011A\u0002\u001fs_>$h(C\u0001\u0010\u0013\tag\"A\u0004qC\u000e\\\u0017mZ3\n\u00059|'aA*fc*\u0011AN\u0004\u0005\u0006cb\u0003\rA]\u0001\u0011[\u0006D\b+\u0019:uSRLwN\\*ju\u0016\u0004\"!D:\n\u0005Qt!\u0001\u0002'p]\u001eDQA\u001e\u0001\u0005\n]\faBY3ti^Kg\u000eZ8x'&TX\rF\u0002\u001cqjDQ!_;A\u0002m\tq!\\1y'&TX\rC\u0003|k\u0002\u00071$A\u0004tK\u001elWM\u001c;\t\u000bu\u0004A\u0011\u0001@\u0002\u00171L7\u000f^,j]\u0012|wo\u001d\u000b\u0003=~DQ!\u001f?A\u0002mAa! \u0001\u0005\u0002\u0005\rAc\u00020\u0002\u0006\u0005\u001d\u0011q\u0003\u0005\u0007s\u0006\u0005\u0001\u0019A\u000e\t\u0011\u0005%\u0011\u0011\u0001a\u0001\u0003\u0017\ta!\u001a=uK:$\b\u0003BA\u0007\u0003'i!!a\u0004\u000b\u0007\u0005E\u0001\"\u0001\u0004wK\u000e$xN]\u0005\u0005\u0003+\tyA\u0001\u0004FqR,g\u000e\u001e\u0005\t\u00033\t\t\u00011\u0001\u0002\u001c\u0005Aq-Z8nKR\u0014\u0018\u0010\u0005\u0003\u0002\u000e\u0005u\u0011\u0002BA\u0010\u0003\u001f\u0011\u0001bR3p[\u0016$(/\u001f\u0005\u0007{\u0002!\t!a\t\u0015\u000by\u000b)#!\u000b\t\u000f\u0005\u001d\u0012\u0011\u0005a\u00017\u0005!1m\u001c7t\u0011\u001d\tY#!\tA\u0002m\tAA]8xg\"1\u0011q\u0006\u0001\u0005\u0002i\t\u0001CY1oIN+w-\\3oi\u000e{WO\u001c;\t\u000f\u0005M\u0002\u0001\"\u0001\u00026\u0005!r-\u001a;TK\u001elWM\u001c;D_>\u0014H-\u001b8bi\u0016$B!a\u000e\u0002>A)Q\"!\u000f\u001c7%\u0019\u00111\b\b\u0003\rQ+\b\u000f\\33\u0011\u001d\ty$!\rA\u0002m\tAb]3h[\u0016tG/\u00138eKbDq!a\u0011\u0001\t\u0003\t)%\u0001\u000bhKR\u001cVmZ7f]R$\u0015.\\3og&|gn\u001d\u000b\u0005\u0003o\t9\u0005C\u0004\u0002@\u0005\u0005\u0003\u0019A\u000e\t\u0011\u0005-\u0003\u0001\"\u0001\t\u0003\u001b\nQbZ3u\u000fJLGMQ8v]\u0012\u001cHcA0\u0002P!9\u0011qHA%\u0001\u0004Y\u0002\"CA*\u0001\u0005\u0005I\u0011AA+\u0003\u0011\u0019w\u000e]=\u0015\u0017\u0005\u000b9&!\u0017\u0002\\\u0005u\u0013q\f\u0005\t3\u0005E\u0003\u0013!a\u00017!A\u0011%!\u0015\u0011\u0002\u0003\u00071\u0004\u0003\u0005&\u0003#\u0002\n\u00111\u0001(\u0011!q\u0013\u0011\u000bI\u0001\u0002\u0004\u0001\u0004\u0002C\u001c\u0002RA\u0005\t\u0019A\u001d\t\u0013\u0005\r\u0004!%A\u0005\u0002\u0005\u0015\u0014AD2paf$C-\u001a4bk2$H%M\u000b\u0003\u0003OR3aGA5W\t\tY\u0007\u0005\u0003\u0002n\u0005]TBAA8\u0015\u0011\t\t(a\u001d\u0002\u0013Ut7\r[3dW\u0016$'bAA;\u001d\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005e\u0014q\u000e\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\"CA?\u0001E\u0005I\u0011AA3\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIIB\u0011\"!!\u0001#\u0003%\t!a!\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%gU\u0011\u0011Q\u0011\u0016\u0004O\u0005%\u0004\"CAE\u0001E\u0005I\u0011AAF\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"!!$+\u0007A\nI\u0007C\u0005\u0002\u0012\u0002\t\n\u0011\"\u0001\u0002\u0014\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012*TCAAKU\rI\u0014\u0011\u000e\u0005\n\u00033\u0003\u0011\u0011!C!\u00037\u000bQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAAO!\u0011\ty*!+\u000e\u0005\u0005\u0005&\u0002BAR\u0003K\u000bA\u0001\\1oO*\u0011\u0011qU\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002,\u0006\u0005&AB*ue&tw\r\u0003\u0005\u00020\u0002\t\t\u0011\"\u0001\u001b\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u0011%\t\u0019\fAA\u0001\n\u0003\t),\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005]\u0016Q\u0018\t\u0004\u001b\u0005e\u0016bAA^\u001d\t\u0019\u0011I\\=\t\u0013\u0005}\u0016\u0011WA\u0001\u0002\u0004Y\u0012a\u0001=%c!I\u00111\u0019\u0001\u0002\u0002\u0013\u0005\u0013QY\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\u0019\t\u0007\u0003\u0013\fy-a.\u000e\u0005\u0005-'bAAg\u001d\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005E\u00171\u001a\u0002\t\u0013R,'/\u0019;pe\"I\u0011Q\u001b\u0001\u0002\u0002\u0013\u0005\u0011q[\u0001\tG\u0006tW)];bYR\u0019!*!7\t\u0015\u0005}\u00161[A\u0001\u0002\u0004\t9\fC\u0005\u0002^\u0002\t\t\u0011\"\u0011\u0002`\u0006A\u0001.Y:i\u0007>$W\rF\u0001\u001c\u0011%\t\u0019\u000fAA\u0001\n\u0003\n)/\u0001\u0005u_N#(/\u001b8h)\t\ti\nC\u0005\u0002j\u0002\t\t\u0011\"\u0011\u0002l\u00061Q-];bYN$2ASAw\u0011)\ty,a:\u0002\u0002\u0003\u0007\u0011qW\u0004\b\u0003c\u0014\u0001\u0012AAz\u0003Q9Um\u001c+jM\u001a\u001cVmZ7f]Rd\u0015-_8viB\u0019\u0011'!>\u0007\r\u0005\u0011\u0001\u0012AA|'\u0011\t)\u0010D\u000b\t\u000f}\n)\u0010\"\u0001\u0002|R\u0011\u00111\u001f\u0005\t\u0003\u007f\f)\u0010\"\u0001\u0003\u0002\u0005)\u0011\r\u001d9msRY\u0011Ia\u0001\u0003\u0006\t\u001d!\u0011\u0002B\u0006\u0011\u0019I\u0012Q a\u00017!1\u0011%!@A\u0002mAaALA\u007f\u0001\u0004\u0001\u0004BB\u001c\u0002~\u0002\u0007\u0011\b\u0003\u0005\u0003\u000e\u0005u\b\u0019\u0001B\b\u0003!\u0011\u0017M\u001c3UsB,\u0007cA\u0019\u0003\u0012%\u0019!1\u0003\u0002\u0003\u0011\t\u000bg\u000e\u001a+za\u0016D!\"a@\u0002v\u0006\u0005I\u0011\u0011B\f)-\t%\u0011\u0004B\u000e\u0005;\u0011yB!\t\t\re\u0011)\u00021\u0001\u001c\u0011\u0019\t#Q\u0003a\u00017!1QE!\u0006A\u0002\u001dBaA\fB\u000b\u0001\u0004\u0001\u0004BB\u001c\u0003\u0016\u0001\u0007\u0011\b\u0003\u0006\u0003&\u0005U\u0018\u0011!CA\u0005O\tq!\u001e8baBd\u0017\u0010\u0006\u0003\u0003*\tU\u0002#B\u0007\u0003,\t=\u0012b\u0001B\u0017\u001d\t1q\n\u001d;j_:\u0004\u0002\"\u0004B\u00197m9\u0003'O\u0005\u0004\u0005gq!A\u0002+va2,W\u0007C\u0005\u00038\t\r\u0012\u0011!a\u0001\u0003\u0006\u0019\u0001\u0010\n\u0019\t\u0015\tm\u0012Q_A\u0001\n\u0013\u0011i$A\u0006sK\u0006$'+Z:pYZ,GC\u0001B !\u0011\tyJ!\u0011\n\t\t\r\u0013\u0011\u0015\u0002\u0007\u001f\nTWm\u0019;")
public class GeoTiffSegmentLayout
implements Product,
scala.Serializable {
    private final int totalCols;
    private final int totalRows;
    private final TileLayout tileLayout;
    private final StorageMethod storageMethod;
    private final InterleaveMethod interleaveMethod;

    public static Option<Tuple5<Object, Object, TileLayout, StorageMethod, InterleaveMethod>> unapply(GeoTiffSegmentLayout geoTiffSegmentLayout) {
        return GeoTiffSegmentLayout$.MODULE$.unapply(geoTiffSegmentLayout);
    }

    public static GeoTiffSegmentLayout apply(int n, int n2, TileLayout tileLayout, StorageMethod storageMethod, InterleaveMethod interleaveMethod) {
        return GeoTiffSegmentLayout$.MODULE$.apply(n, n2, tileLayout, storageMethod, interleaveMethod);
    }

    public static GeoTiffSegmentLayout apply(int n, int n2, StorageMethod storageMethod, InterleaveMethod interleaveMethod, BandType bandType) {
        return GeoTiffSegmentLayout$.MODULE$.apply(n, n2, storageMethod, interleaveMethod, bandType);
    }

    public int totalCols() {
        return this.totalCols;
    }

    public int totalRows() {
        return this.totalRows;
    }

    public TileLayout tileLayout() {
        return this.tileLayout;
    }

    public StorageMethod storageMethod() {
        return this.storageMethod;
    }

    public InterleaveMethod interleaveMethod() {
        return this.interleaveMethod;
    }

    public boolean isTiled() {
        StorageMethod storageMethod = this.storageMethod();
        boolean bl = storageMethod instanceof Tiled;
        return bl;
    }

    public boolean isStriped() {
        return !this.isTiled();
    }

    public boolean hasPixelInterleave() {
        InterleaveMethod interleaveMethod = this.interleaveMethod();
        PixelInterleave$ pixelInterleave$ = PixelInterleave$.MODULE$;
        return !(interleaveMethod != null ? !interleaveMethod.equals(pixelInterleave$) : pixelInterleave$ != null);
    }

    public int getSegmentIndex(int col, int row) {
        int layoutCol = col / this.tileLayout().tileCols();
        int layoutRow = row / this.tileLayout().tileRows();
        return layoutRow * this.tileLayout().layoutCols() + layoutCol;
    }

    public GridBounds[][] partitionWindowsBySegments(Seq<GridBounds> windows, long maxPartitionSize) {
        ArrayBuilder partition = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(GridBounds.class));
        partition.sizeHintBounded(128, windows);
        LongRef partitionSize = LongRef.create((long)0L);
        LongRef partitionCount = LongRef.create((long)0L);
        ArrayBuilder partitions = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(GridBounds.class)));
        GridBounds sourceBounds = new GridBounds(0, 0, this.totalCols() - 1, this.totalRows() - 1);
        Seq sorted = (Seq)((SeqLike)((TraversableLike)windows.filter((Function1 & Serializable & scala.Serializable)other -> BoxesRunTime.boxToBoolean((boolean)sourceBounds.intersects(other)))).map((Function1 & Serializable & scala.Serializable)window -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(window), (Object)BoxesRunTime.boxToInteger((int)this.getSegmentIndex(window.colMin(), window.rowMin()))), Seq$.MODULE$.canBuildFrom())).sortBy((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1._2$mcI$sp()), (Ordering)Ordering.Int$.MODULE$);
        sorted.withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)GeoTiffSegmentLayout.$anonfun$partitionWindowsBySegments$4(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            GeoTiffSegmentLayout.$anonfun$partitionWindowsBySegments$5(maxPartitionSize, partition, partitionSize, partitionCount, partitions, x$2);
            return BoxedUnit.UNIT;
        });
        GeoTiffSegmentLayout.finalizePartition$1(partition, partitionSize, partitionCount, partitions);
        return (GridBounds[][])partitions.result();
    }

    private int bestWindowSize(int maxSize, int segment) {
        int i = 1;
        int result = -1;
        while ((double)i < package$.MODULE$.sqrt((double)segment) && result == -1) {
            if (segment % i == 0 && segment / i <= maxSize) {
                result = segment / i;
            }
            ++i;
        }
        return result == -1 ? maxSize : result;
    }

    public GridBounds[] listWindows(int maxSize) {
        int colSize;
        int segCols = this.tileLayout().tileCols();
        int segRows = this.tileLayout().tileRows();
        int n = maxSize >= segCols * 2 ? (int)package$.MODULE$.floor((double)maxSize / (double)segCols) * segCols : (colSize = maxSize >= segCols ? segCols : this.bestWindowSize(maxSize, segCols));
        int rowSize = maxSize >= segRows * 2 ? (int)package$.MODULE$.floor((double)maxSize / (double)segRows) * segRows : (maxSize >= segRows ? segRows : this.bestWindowSize(maxSize, segRows));
        GridBounds[] windows = this.listWindows(colSize, rowSize);
        return windows;
    }

    public GridBounds[] listWindows(int maxSize, Extent extent, Geometry geometry) {
        int maxColSize;
        int segCols = this.tileLayout().tileCols();
        int segRows = this.tileLayout().tileRows();
        int n = maxSize >= segCols * 2 ? (int)package$.MODULE$.floor((double)maxSize / (double)segCols) * segCols : (maxColSize = maxSize >= segCols ? segCols : this.bestWindowSize(maxSize, segCols));
        int maxRowSize = maxSize >= segRows ? (int)package$.MODULE$.floor((double)maxSize / (double)segRows) * segRows : (maxSize >= segRows ? segRows : this.bestWindowSize(maxSize, segRows));
        Set result = Set$.MODULE$.empty();
        RasterExtent re = RasterExtent$.MODULE$.apply(extent, package$.MODULE$.max(this.totalCols() / maxColSize, 1), package$.MODULE$.max(this.totalRows() / maxRowSize, 1));
        Rasterizer.Options options = new Rasterizer.Options(true, PixelIsArea$.MODULE$);
        Rasterizer$.MODULE$.foreachCellByGeometry(geometry, re, options, (Function2<Object, Object, BoxedUnit>)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(col, row) -> result.$plus$eq((Object)new GridBounds(col * maxColSize, row * maxRowSize, package$.MODULE$.min((col + 1) * maxColSize - 1, this.totalCols() - 1), package$.MODULE$.min((row + 1) * maxRowSize - 1, this.totalRows() - 1))));
        return (GridBounds[])result.toArray(ClassTag$.MODULE$.apply(GridBounds.class));
    }

    public GridBounds[] listWindows(int cols, int rows) {
        ArrayBuilder result = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(GridBounds.class));
        result.sizeHint(this.totalCols() / cols * (this.totalRows() / rows));
        for (int index$macro$279 = 0; index$macro$279 < this.totalCols(); index$macro$279 += cols) {
            for (int index$macro$278 = 0; index$macro$278 < this.totalRows(); index$macro$278 += rows) {
                result.$plus$eq((Object)new GridBounds(index$macro$279, index$macro$278, package$.MODULE$.min(index$macro$279 + cols - 1, this.totalCols() - 1), package$.MODULE$.min(index$macro$278 + rows - 1, this.totalRows() - 1)));
            }
        }
        return (GridBounds[])result.result();
    }

    public int bandSegmentCount() {
        return this.tileLayout().layoutCols() * this.tileLayout().layoutRows();
    }

    public Tuple2<Object, Object> getSegmentCoordinate(int segmentIndex) {
        return new Tuple2.mcII.sp(segmentIndex % this.tileLayout().layoutCols(), segmentIndex / this.tileLayout().layoutCols());
    }

    public Tuple2<Object, Object> getSegmentDimensions(int segmentIndex) {
        int normalizedSegmentIndex = segmentIndex % this.bandSegmentCount();
        int layoutCol = normalizedSegmentIndex % this.tileLayout().layoutCols();
        int layoutRow = normalizedSegmentIndex / this.tileLayout().layoutCols();
        int cols = layoutCol == this.tileLayout().layoutCols() - 1 ? this.totalCols() - (this.tileLayout().layoutCols() - 1) * this.tileLayout().tileCols() : this.tileLayout().tileCols();
        int rows = layoutRow == this.tileLayout().layoutRows() - 1 ? this.totalRows() - (this.tileLayout().layoutRows() - 1) * this.tileLayout().tileRows() : this.tileLayout().tileRows();
        return new Tuple2.mcII.sp(cols, rows);
    }

    public GridBounds getGridBounds(int segmentIndex) {
        int normalizedSegmentIndex = segmentIndex % this.bandSegmentCount();
        Tuple2<Object, Object> tuple2 = this.getSegmentDimensions(segmentIndex);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int segmentCols = tuple2._1$mcI$sp();
        int segmentRows = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(segmentCols, segmentRows);
        Tuple2.mcII.sp sp3 = sp2;
        int segmentCols2 = sp3._1$mcI$sp();
        int segmentRows2 = sp3._2$mcI$sp();
        Tuple2<Object, Object> tuple22 = this.getSegmentCoordinate(normalizedSegmentIndex);
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        int layoutCol = tuple22._1$mcI$sp();
        int layoutRow = tuple22._2$mcI$sp();
        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(layoutCol, layoutRow);
        Tuple2.mcII.sp sp5 = sp4;
        int layoutCol2 = sp5._1$mcI$sp();
        int layoutRow2 = sp5._2$mcI$sp();
        Tuple2.mcII.sp sp6 = new Tuple2.mcII.sp(layoutCol2 * this.tileLayout().tileCols(), layoutRow2 * this.tileLayout().tileRows());
        if (sp6 == null) {
            throw new MatchError((Object)sp6);
        }
        int startCol = sp6._1$mcI$sp();
        int startRow = sp6._2$mcI$sp();
        Tuple2.mcII.sp sp7 = new Tuple2.mcII.sp(startCol, startRow);
        Tuple2.mcII.sp sp8 = sp7;
        int startCol2 = sp8._1$mcI$sp();
        int startRow2 = sp8._2$mcI$sp();
        int endCol = startCol2 + segmentCols2 - 1;
        int endRow = startRow2 + segmentRows2 - 1;
        return new GridBounds(startCol2, startRow2, endCol, endRow);
    }

    public GeoTiffSegmentLayout copy(int totalCols, int totalRows, TileLayout tileLayout, StorageMethod storageMethod, InterleaveMethod interleaveMethod) {
        return new GeoTiffSegmentLayout(totalCols, totalRows, tileLayout, storageMethod, interleaveMethod);
    }

    public int copy$default$1() {
        return this.totalCols();
    }

    public int copy$default$2() {
        return this.totalRows();
    }

    public TileLayout copy$default$3() {
        return this.tileLayout();
    }

    public StorageMethod copy$default$4() {
        return this.storageMethod();
    }

    public InterleaveMethod copy$default$5() {
        return this.interleaveMethod();
    }

    public String productPrefix() {
        return "GeoTiffSegmentLayout";
    }

    public int productArity() {
        return 5;
    }

    public Object productElement(int x$1) {
        Object object;
        int n = x$1;
        switch (n) {
            case 0: {
                object = BoxesRunTime.boxToInteger((int)this.totalCols());
                break;
            }
            case 1: {
                object = BoxesRunTime.boxToInteger((int)this.totalRows());
                break;
            }
            case 2: {
                object = this.tileLayout();
                break;
            }
            case 3: {
                object = this.storageMethod();
                break;
            }
            case 4: {
                object = this.interleaveMethod();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return object;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof GeoTiffSegmentLayout;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.totalCols());
        n = Statics.mix((int)n, (int)this.totalRows());
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.tileLayout()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.storageMethod()));
        n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.interleaveMethod()));
        return Statics.finalizeHash((int)n, (int)5);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof GeoTiffSegmentLayout)) return false;
        boolean bl = true;
        if (!bl) return false;
        GeoTiffSegmentLayout geoTiffSegmentLayout = (GeoTiffSegmentLayout)x$1;
        if (this.totalCols() != geoTiffSegmentLayout.totalCols()) return false;
        if (this.totalRows() != geoTiffSegmentLayout.totalRows()) return false;
        TileLayout tileLayout = this.tileLayout();
        TileLayout tileLayout2 = geoTiffSegmentLayout.tileLayout();
        if (tileLayout == null) {
            if (tileLayout2 != null) {
                return false;
            }
        } else if (!((Object)tileLayout).equals(tileLayout2)) return false;
        StorageMethod storageMethod = this.storageMethod();
        StorageMethod storageMethod2 = geoTiffSegmentLayout.storageMethod();
        if (storageMethod == null) {
            if (storageMethod2 != null) {
                return false;
            }
        } else if (!storageMethod.equals(storageMethod2)) return false;
        InterleaveMethod interleaveMethod = this.interleaveMethod();
        InterleaveMethod interleaveMethod2 = geoTiffSegmentLayout.interleaveMethod();
        if (interleaveMethod == null) {
            if (interleaveMethod2 != null) {
                return false;
            }
        } else if (!interleaveMethod.equals(interleaveMethod2)) return false;
        if (!geoTiffSegmentLayout.canEqual(this)) return false;
        return true;
    }

    private static final void finalizePartition$1(ArrayBuilder partition$1, LongRef partitionSize$1, LongRef partitionCount$1, ArrayBuilder partitions$1) {
        GridBounds[] res = (GridBounds[])partition$1.result();
        Object object = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])res)).nonEmpty() ? partitions$1.$plus$eq((Object)res) : BoxedUnit.UNIT;
        partition$1.clear();
        partitionSize$1.elem = 0L;
        partitionCount$1.elem = 0L;
    }

    private static final void addToPartition$1(GridBounds window, ArrayBuilder partition$1, LongRef partitionSize$1, LongRef partitionCount$1) {
        partition$1.$plus$eq((Object)window);
        partitionSize$1.elem += window.size();
        ++partitionCount$1.elem;
    }

    public static final /* synthetic */ boolean $anonfun$partitionWindowsBySegments$4(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$partitionWindowsBySegments$5(long maxPartitionSize$1, ArrayBuilder partition$1, LongRef partitionSize$1, LongRef partitionCount$1, ArrayBuilder partitions$1, Tuple2 x$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x$2;
        if (tuple2 != null) {
            GridBounds window = (GridBounds)tuple2._1();
            if (partitionCount$1.elem == 0L || partitionSize$1.elem + window.size() < maxPartitionSize$1) {
                GeoTiffSegmentLayout.addToPartition$1(window, partition$1, partitionSize$1, partitionCount$1);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                GeoTiffSegmentLayout.finalizePartition$1(partition$1, partitionSize$1, partitionCount$1, partitions$1);
                GeoTiffSegmentLayout.addToPartition$1(window, partition$1, partitionSize$1, partitionCount$1);
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public GeoTiffSegmentLayout(int totalCols, int totalRows, TileLayout tileLayout, StorageMethod storageMethod, InterleaveMethod interleaveMethod) {
        this.totalCols = totalCols;
        this.totalRows = totalRows;
        this.tileLayout = tileLayout;
        this.storageMethod = storageMethod;
        this.interleaveMethod = interleaveMethod;
        Product.$init$((Product)this);
    }
}

