/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.raster.GridBounds;
import geotrellis.raster.TileLayout;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayoutTransform$;
import geotrellis.raster.io.geotiff.InterleaveMethod;
import geotrellis.raster.io.geotiff.SegmentTransform;
import geotrellis.raster.io.geotiff.StorageMethod;
import geotrellis.raster.io.geotiff.StripedSegmentTransform;
import geotrellis.raster.io.geotiff.TiledSegmentTransform;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005}baB\u0001\u0003!\u0003\r\ta\u0003\u0002\u001e\u000f\u0016|G+\u001b4g'\u0016<W.\u001a8u\u0019\u0006Lx.\u001e;Ue\u0006t7OZ8s[*\u00111\u0001B\u0001\bO\u0016|G/\u001b4g\u0015\t)a!\u0001\u0002j_*\u0011q\u0001C\u0001\u0007e\u0006\u001cH/\u001a:\u000b\u0003%\t!bZ3piJ,G\u000e\\5t\u0007\u0001\u0019\"\u0001\u0001\u0007\u0011\u00055\u0001R\"\u0001\b\u000b\u0003=\tQa]2bY\u0006L!!\u0005\b\u0003\r\u0005s\u0017PU3g\u0011\u0015\u0019\u0002\u0001\"\u0001\u0015\u0003\u0019!\u0013N\\5uIQ\tQ\u0003\u0005\u0002\u000e-%\u0011qC\u0004\u0002\u0005+:LG\u000f\u0003\u0004\u001a\u0001\u0019\u0005\u0001BG\u0001\u000eg\u0016<W.\u001a8u\u0019\u0006Lx.\u001e;\u0016\u0003m\u0001\"\u0001H\u000f\u000e\u0003\tI!A\b\u0002\u0003)\u001d+w\u000eV5gMN+w-\\3oi2\u000b\u0017p\\;u\u0011)\u0001\u0003\u0001%A\t\b\u0004&I!I\u0001\u0005q\u0012\n\u0004'F\u0001#!\u001di1%J\u0013)Y=J!\u0001\n\b\u0003\rQ+\b\u000f\\36!\tia%\u0003\u0002(\u001d\t\u0019\u0011J\u001c;\u0011\u0005%RS\"\u0001\u0004\n\u0005-2!A\u0003+jY\u0016d\u0015-_8viB\u0011A$L\u0005\u0003]\t\u0011Qb\u0015;pe\u0006<W-T3uQ>$\u0007C\u0001\u000f1\u0013\t\t$A\u0001\tJ]R,'\u000f\\3bm\u0016lU\r\u001e5pI\"A1\u0007\u0001EC\u0002\u0013%A'A\u0005u_R\fGnQ8mgV\tQ\u0005\u0003\u00057\u0001!\u0015\r\u0011\"\u00035\u0003%!x\u000e^1m%><8\u000f\u0003\u00059\u0001!\u0015\r\u0011\"\u0003:\u0003)!\u0018\u000e\\3MCf|W\u000f^\u000b\u0002Q!A1\b\u0001EC\u0002\u0013%A(A\u0004jgRKG.\u001a3\u0016\u00031B\u0001B\u0010\u0001\t\u0006\u0004%IaP\u0001\u0011S:$XM\u001d7fCZ,W*\u001a;i_\u0012,\u0012a\f\u0005\u0006\u0003\u00021\t\u0001N\u0001\nE\u0006tGmQ8v]RDQa\u0011\u0001\u0005\nQ\n\u0001CY1oIN+w-\\3oi\u000e{WO\u001c;\t\u000b\u0015\u0003A\u0011\u0001$\u0002)\u001d,GoU3h[\u0016tG\u000fR5nK:\u001c\u0018n\u001c8t)\t9%\n\u0005\u0003\u000e\u0011\u0016*\u0013BA%\u000f\u0005\u0019!V\u000f\u001d7fe!)1\n\u0012a\u0001K\u0005a1/Z4nK:$\u0018J\u001c3fq\")Q\n\u0001C\u0001\u001d\u0006qq-\u001a;TK\u001elWM\u001c;TSj,GCA\u0013P\u0011\u0015YE\n1\u0001&\u0011\u0019\t\u0006\u0001\"\u0001\u0003%\u0006yq-\u001a;TK\u001elWM\u001c;J]\u0012,\u0007\u0010F\u0002&'VCQ\u0001\u0016)A\u0002\u0015\n1aY8m\u0011\u00151\u0006\u000b1\u0001&\u0003\r\u0011xn\u001e\u0005\u00071\u0002!\tAA-\u0002'\u001d,GoU3h[\u0016tG\u000f\u0016:b]N4wN]7\u0015\u0005ik\u0006C\u0001\u000f\\\u0013\ta&A\u0001\tTK\u001elWM\u001c;Ue\u0006t7OZ8s[\")1j\u0016a\u0001K!)q\f\u0001C\u0001A\u0006!r-\u001a;TK\u001elWM\u001c;D_>\u0014H-\u001b8bi\u0016$\"aR1\t\u000b-s\u0006\u0019A\u0013\t\r\r\u0004A\u0011\u0001\u0005e\u000359W\r^$sS\u0012\u0014u.\u001e8egR\u0011Q\r\u001b\t\u0003S\u0019L!a\u001a\u0004\u0003\u0015\u001d\u0013\u0018\u000e\u001a\"pk:$7\u000fC\u0003LE\u0002\u0007Q\u0005\u0003\u0004k\u0001\u0011\u0005\u0001b[\u0001\u0018O\u0016$\u0018J\u001c;feN,7\r^5oON+w-\\3oiN$\"\u0001\\8\u0011\u00075iW%\u0003\u0002o\u001d\t)\u0011I\u001d:bs\")\u0001/\u001ba\u0001K\u00061!m\\;oINDQA\u001d\u0001\u0005\u0002M\f!\u0004]1si&$\u0018n\u001c8XS:$wn^:CsN+w-\\3oiN$B\u0001\u001e<\u0002\nA\u0019Q\"\\;\u0011\u00075iW\rC\u0003xc\u0002\u0007\u00010A\u0004xS:$wn^:\u0011\te\f\u0019!\u001a\b\u0003u~t!a\u001f@\u000e\u0003qT!! \u0006\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0011bAA\u0001\u001d\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u0003\u0003\u000f\u00111aU3r\u0015\r\t\tA\u0004\u0005\b\u0003\u0017\t\b\u0019AA\u0007\u0003Ai\u0017\r\u001f)beRLG/[8o'&TX\rE\u0002\u000e\u0003\u001fI1!!\u0005\u000f\u0005\u0011auN\\4\t\u000f)\u0004A\u0011\u0001\u0002\u0002\u0016Q1\u0011qCA\r\u00037\u00012!D7H\u0011\u0019\u0001\u00181\u0003a\u0001K\"9\u0011QDA\n\u0001\u0004a\u0017!\u00022b]\u0012\u001cxaBA\u0011\u0005!\u0005\u00111E\u0001\u001e\u000f\u0016|G+\u001b4g'\u0016<W.\u001a8u\u0019\u0006Lx.\u001e;Ue\u0006t7OZ8s[B\u0019A$!\n\u0007\r\u0005\u0011\u0001\u0012AA\u0014'\r\t)\u0003\u0004\u0005\t\u0003W\t)\u0003\"\u0001\u0002.\u00051A(\u001b8jiz\"\"!a\t\t\u0011\u0005E\u0012Q\u0005C\u0001\u0003g\tQ!\u00199qYf$b!!\u000e\u00028\u0005m\u0002C\u0001\u000f\u0001\u0011\u001d\tI$a\fA\u0002m\tabX:fO6,g\u000e\u001e'bs>,H\u000fC\u0004\u0002>\u0005=\u0002\u0019A\u0013\u0002\u0015}\u0013\u0017M\u001c3D_VtG\u000f")
public interface GeoTiffSegmentLayoutTransform {
    public static GeoTiffSegmentLayoutTransform apply(GeoTiffSegmentLayout geoTiffSegmentLayout, int n) {
        return GeoTiffSegmentLayoutTransform$.MODULE$.apply(geoTiffSegmentLayout, n);
    }

    public GeoTiffSegmentLayout segmentLayout();

    public static /* synthetic */ Tuple5 geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$x$10$(GeoTiffSegmentLayoutTransform $this) {
        return $this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$x$10();
    }

    default public /* synthetic */ Tuple5 geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$x$10() {
        GeoTiffSegmentLayout geoTiffSegmentLayout = this.segmentLayout();
        if (geoTiffSegmentLayout == null) {
            throw new MatchError((Object)geoTiffSegmentLayout);
        }
        int totalCols = geoTiffSegmentLayout.totalCols();
        int totalRows = geoTiffSegmentLayout.totalRows();
        TileLayout tileLayout = geoTiffSegmentLayout.tileLayout();
        StorageMethod isTiled = geoTiffSegmentLayout.storageMethod();
        InterleaveMethod interleaveMethod = geoTiffSegmentLayout.interleaveMethod();
        Tuple5 tuple5 = new Tuple5((Object)BoxesRunTime.boxToInteger((int)totalCols), (Object)BoxesRunTime.boxToInteger((int)totalRows), (Object)tileLayout, (Object)isTiled, (Object)interleaveMethod);
        return tuple5;
    }

    public static /* synthetic */ int geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalCols$(GeoTiffSegmentLayoutTransform $this) {
        return $this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalCols();
    }

    default public int geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalCols() {
        return BoxesRunTime.unboxToInt((Object)this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$x$10()._1());
    }

    public static /* synthetic */ int geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalRows$(GeoTiffSegmentLayoutTransform $this) {
        return $this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalRows();
    }

    default public int geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalRows() {
        return BoxesRunTime.unboxToInt((Object)this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$x$10()._2());
    }

    public static /* synthetic */ TileLayout geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout$(GeoTiffSegmentLayoutTransform $this) {
        return $this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout();
    }

    default public TileLayout geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout() {
        return (TileLayout)this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$x$10()._3();
    }

    public static /* synthetic */ StorageMethod geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$isTiled$(GeoTiffSegmentLayoutTransform $this) {
        return $this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$isTiled();
    }

    default public StorageMethod geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$isTiled() {
        return (StorageMethod)this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$x$10()._4();
    }

    public static /* synthetic */ InterleaveMethod geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$interleaveMethod$(GeoTiffSegmentLayoutTransform $this) {
        return $this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$interleaveMethod();
    }

    default public InterleaveMethod geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$interleaveMethod() {
        return (InterleaveMethod)this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$x$10()._5();
    }

    public int bandCount();

    private int bandSegmentCount() {
        return this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().layoutCols() * this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().layoutRows();
    }

    public static /* synthetic */ Tuple2 getSegmentDimensions$(GeoTiffSegmentLayoutTransform $this, int segmentIndex) {
        return $this.getSegmentDimensions(segmentIndex);
    }

    default public Tuple2<Object, Object> getSegmentDimensions(int segmentIndex) {
        int normalizedSegmentIndex = segmentIndex % this.bandSegmentCount();
        int layoutCol = normalizedSegmentIndex % this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().layoutCols();
        int layoutRow = normalizedSegmentIndex / this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().layoutCols();
        int cols = layoutCol == this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().layoutCols() - 1 ? this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalCols() - (this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().layoutCols() - 1) * this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().tileCols() : this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().tileCols();
        int rows = layoutRow == this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().layoutRows() - 1 ? this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalRows() - (this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().layoutRows() - 1) * this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().tileRows() : this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().tileRows();
        return new Tuple2.mcII.sp(cols, rows);
    }

    public static /* synthetic */ int getSegmentSize$(GeoTiffSegmentLayoutTransform $this, int segmentIndex) {
        return $this.getSegmentSize(segmentIndex);
    }

    default public int getSegmentSize(int segmentIndex) {
        Tuple2<Object, Object> tuple2 = this.getSegmentDimensions(segmentIndex);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int cols = tuple2._1$mcI$sp();
        int rows = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(cols, rows);
        Tuple2.mcII.sp sp3 = sp2;
        int cols2 = sp3._1$mcI$sp();
        int rows2 = sp3._2$mcI$sp();
        return cols2 * rows2;
    }

    public static /* synthetic */ int getSegmentIndex$(GeoTiffSegmentLayoutTransform $this, int col, int row) {
        return $this.getSegmentIndex(col, row);
    }

    default public int getSegmentIndex(int col, int row) {
        return this.segmentLayout().getSegmentIndex(col, row);
    }

    public static /* synthetic */ SegmentTransform getSegmentTransform$(GeoTiffSegmentLayoutTransform $this, int segmentIndex) {
        return $this.getSegmentTransform(segmentIndex);
    }

    default public SegmentTransform getSegmentTransform(int segmentIndex) {
        int id = segmentIndex % this.bandSegmentCount();
        return this.segmentLayout().isStriped() ? new StripedSegmentTransform(id, GeoTiffSegmentLayoutTransform$.MODULE$.apply(this.segmentLayout(), this.bandCount())) : new TiledSegmentTransform(id, GeoTiffSegmentLayoutTransform$.MODULE$.apply(this.segmentLayout(), this.bandCount()));
    }

    public static /* synthetic */ Tuple2 getSegmentCoordinate$(GeoTiffSegmentLayoutTransform $this, int segmentIndex) {
        return $this.getSegmentCoordinate(segmentIndex);
    }

    default public Tuple2<Object, Object> getSegmentCoordinate(int segmentIndex) {
        return new Tuple2.mcII.sp(segmentIndex % this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().layoutCols(), segmentIndex / this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().layoutCols());
    }

    public static /* synthetic */ GridBounds getGridBounds$(GeoTiffSegmentLayoutTransform $this, int segmentIndex) {
        return $this.getGridBounds(segmentIndex);
    }

    default public GridBounds getGridBounds(int segmentIndex) {
        int normalizedSegmentIndex = segmentIndex % this.bandSegmentCount();
        Tuple2<Object, Object> tuple2 = this.getSegmentDimensions(segmentIndex);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int segmentCols = tuple2._1$mcI$sp();
        int segmentRows = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(segmentCols, segmentRows);
        Tuple2.mcII.sp sp3 = sp2;
        int segmentCols2 = sp3._1$mcI$sp();
        int segmentRows2 = sp3._2$mcI$sp();
        Tuple2<Object, Object> tuple22 = this.getSegmentCoordinate(normalizedSegmentIndex);
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        int layoutCol = tuple22._1$mcI$sp();
        int layoutRow = tuple22._2$mcI$sp();
        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(layoutCol, layoutRow);
        Tuple2.mcII.sp sp5 = sp4;
        int layoutCol2 = sp5._1$mcI$sp();
        int layoutRow2 = sp5._2$mcI$sp();
        Tuple2.mcII.sp sp6 = new Tuple2.mcII.sp(layoutCol2 * this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().tileCols(), layoutRow2 * this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().tileRows());
        if (sp6 == null) {
            throw new MatchError((Object)sp6);
        }
        int startCol = sp6._1$mcI$sp();
        int startRow = sp6._2$mcI$sp();
        Tuple2.mcII.sp sp7 = new Tuple2.mcII.sp(startCol, startRow);
        Tuple2.mcII.sp sp8 = sp7;
        int startCol2 = sp8._1$mcI$sp();
        int startRow2 = sp8._2$mcI$sp();
        int endCol = startCol2 + segmentCols2 - 1;
        int endRow = startRow2 + segmentRows2 - 1;
        return new GridBounds(startCol2, startRow2, endCol, endRow);
    }

    public static /* synthetic */ int[] getIntersectingSegments$(GeoTiffSegmentLayoutTransform $this, GridBounds bounds) {
        return $this.getIntersectingSegments(bounds);
    }

    default public int[] getIntersectingSegments(GridBounds bounds) {
        int[] nArray;
        boolean intersects;
        int colMax = this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalCols() - 1;
        int rowMax = this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalRows() - 1;
        boolean bl = intersects = colMax >= bounds.colMin() && bounds.colMax() >= 0 && rowMax >= bounds.rowMin() && bounds.rowMax() >= 0;
        if (intersects) {
            int tc = this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().tileCols();
            int tr = this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().tileRows();
            int colMin = package$.MODULE$.max(0, bounds.colMin());
            int rowMin = package$.MODULE$.max(0, bounds.rowMin());
            int colMax2 = package$.MODULE$.min(this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalCols() - 1, bounds.colMax());
            int rowMax2 = package$.MODULE$.min(this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalRows() - 1, bounds.rowMax());
            ArrayBuilder ab = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Int());
            for (int index$macro$281 = colMin / tc; index$macro$281 <= colMax2 / tc; ++index$macro$281) {
                for (int index$macro$280 = rowMin / tr; index$macro$280 <= rowMax2 / tr; ++index$macro$280) {
                    ab.$plus$eq((Object)BoxesRunTime.boxToInteger((int)(index$macro$280 * this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout().layoutCols() + index$macro$281)));
                }
            }
            nArray = (int[])ab.result();
        } else {
            nArray = (int[])Array$.MODULE$.empty(ClassTag$.MODULE$.Int());
        }
        return nArray;
    }

    public static /* synthetic */ GridBounds[][] partitionWindowsBySegments$(GeoTiffSegmentLayoutTransform $this, Seq windows, long maxPartitionSize) {
        return $this.partitionWindowsBySegments((Seq<GridBounds>)windows, maxPartitionSize);
    }

    default public GridBounds[][] partitionWindowsBySegments(Seq<GridBounds> windows, long maxPartitionSize) {
        return this.segmentLayout().partitionWindowsBySegments(windows, maxPartitionSize);
    }

    public static /* synthetic */ Tuple2[] getIntersectingSegments$(GeoTiffSegmentLayoutTransform $this, GridBounds bounds, int[] bands) {
        return $this.getIntersectingSegments(bounds, bands);
    }

    default public Tuple2<Object, Object>[] getIntersectingSegments(GridBounds bounds, int[] bands) {
        int[] firstBandSegments = this.getIntersectingSegments(bounds);
        return (Tuple2[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(bands)).flatMap((Function1 & Serializable & scala.Serializable)band -> new ArrayOps.ofRef(GeoTiffSegmentLayoutTransform.$anonfun$getIntersectingSegments$1(this, firstBandSegments, BoxesRunTime.unboxToInt((Object)band))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class)));
    }

    public static /* synthetic */ Tuple2 $anonfun$getIntersectingSegments$2(int segmentOffset$1, int band$1, int i) {
        return new Tuple2.mcII.sp(band$1, i + segmentOffset$1);
    }

    public static /* synthetic */ Object[] $anonfun$getIntersectingSegments$1(GeoTiffSegmentLayoutTransform $this, int[] firstBandSegments$1, int band) {
        int segmentOffset = $this.bandSegmentCount() * band;
        return Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(firstBandSegments$1)).map((Function1 & Serializable & scala.Serializable)i -> GeoTiffSegmentLayoutTransform.$anonfun$getIntersectingSegments$2(segmentOffset, band, BoxesRunTime.unboxToInt((Object)i)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))));
    }

    public static void $init$(GeoTiffSegmentLayoutTransform $this) {
    }
}

