/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.raster.BitCellType$;
import geotrellis.raster.BitCells;
import geotrellis.raster.ByteCells;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleCells;
import geotrellis.raster.FloatCells;
import geotrellis.raster.IntCells;
import geotrellis.raster.NoDataHandling;
import geotrellis.raster.ShortCells;
import geotrellis.raster.Tile;
import geotrellis.raster.UByteCells;
import geotrellis.raster.UShortCells;
import geotrellis.raster.io.geotiff.ArraySegmentBytes;
import geotrellis.raster.io.geotiff.BandInterleave$;
import geotrellis.raster.io.geotiff.BandType;
import geotrellis.raster.io.geotiff.BandType$;
import geotrellis.raster.io.geotiff.BitGeoTiffTile;
import geotrellis.raster.io.geotiff.ByteGeoTiffTile;
import geotrellis.raster.io.geotiff.Float32GeoTiffTile;
import geotrellis.raster.io.geotiff.Float64GeoTiffTile;
import geotrellis.raster.io.geotiff.GeoTiffOptions;
import geotrellis.raster.io.geotiff.GeoTiffOptions$;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout$;
import geotrellis.raster.io.geotiff.GeoTiffTile;
import geotrellis.raster.io.geotiff.Int16GeoTiffTile;
import geotrellis.raster.io.geotiff.Int32GeoTiffTile;
import geotrellis.raster.io.geotiff.SegmentBytes;
import geotrellis.raster.io.geotiff.StorageMethod;
import geotrellis.raster.io.geotiff.Striped;
import geotrellis.raster.io.geotiff.Tiled;
import geotrellis.raster.io.geotiff.UByteGeoTiffTile;
import geotrellis.raster.io.geotiff.UInt16GeoTiffTile;
import geotrellis.raster.io.geotiff.UInt32BandType$;
import geotrellis.raster.io.geotiff.UInt32GeoTiffTile;
import geotrellis.raster.io.geotiff.compression.Compression;
import geotrellis.raster.io.geotiff.compression.Compressor;
import geotrellis.raster.io.geotiff.compression.Decompressor;
import geotrellis.raster.package$;
import geotrellis.raster.split.Split;
import geotrellis.raster.split.Split$Options$;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Some;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.ScalaRunTime$;

public final class GeoTiffTile$
implements scala.Serializable {
    public static GeoTiffTile$ MODULE$;

    static {
        new GeoTiffTile$();
    }

    public List<GeoTiffTile> $lessinit$greater$default$3() {
        return Nil$.MODULE$;
    }

    public GeoTiffTile apply(SegmentBytes segmentBytes, Decompressor decompressor, GeoTiffSegmentLayout segmentLayout, Compression compression, DataType cellType, Option<BandType> bandType, List<GeoTiffTile> overviews) {
        GeoTiffTile geoTiffTile;
        Some some;
        BandType bandType2;
        Option<BandType> option = bandType;
        if (option instanceof Some && UInt32BandType$.MODULE$.equals(bandType2 = (BandType)(some = (Some)option).value())) {
            DataType dataType = cellType;
            if (!(dataType instanceof FloatCells)) {
                throw new IllegalArgumentException("UInt32BandType should always resolve to Float celltype");
            }
            NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
            UInt32GeoTiffTile uInt32GeoTiffTile = new UInt32GeoTiffTile(segmentBytes, decompressor, segmentLayout, compression, (FloatCells)((Object)noDataHandling), (List<UInt32GeoTiffTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$1 -> MODULE$.applyOverview((GeoTiffTile)x$1, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends GeoTiffTile, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x1;
                    if (A1 instanceof UInt32GeoTiffTile) {
                        UInt32GeoTiffTile uInt32GeoTiffTile = (UInt32GeoTiffTile)A1;
                        object = uInt32GeoTiffTile;
                    } else {
                        object = function1.apply(x1);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(GeoTiffTile x1) {
                    GeoTiffTile geoTiffTile = x1;
                    boolean bl = geoTiffTile instanceof UInt32GeoTiffTile;
                    return bl;
                }
            }, List$.MODULE$.canBuildFrom())));
            geoTiffTile = uInt32GeoTiffTile;
        } else {
            GeoTiffTile geoTiffTile2;
            DataType dataType = cellType;
            if (dataType instanceof BitCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffTile2 = new BitGeoTiffTile(segmentBytes, decompressor, segmentLayout, compression, (BitCells)((Object)noDataHandling), (List<BitGeoTiffTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$2 -> MODULE$.applyOverview((GeoTiffTile)x$2, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffTile, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x2;
                        if (A1 instanceof BitGeoTiffTile) {
                            BitGeoTiffTile bitGeoTiffTile = (BitGeoTiffTile)A1;
                            object = bitGeoTiffTile;
                        } else {
                            object = function1.apply(x2);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffTile x2) {
                        GeoTiffTile geoTiffTile = x2;
                        boolean bl = geoTiffTile instanceof BitGeoTiffTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else if (dataType instanceof ByteCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffTile2 = new ByteGeoTiffTile(segmentBytes, decompressor, segmentLayout, compression, (ByteCells)((Object)noDataHandling), (List<ByteGeoTiffTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$3 -> MODULE$.applyOverview((GeoTiffTile)x$3, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffTile, B1> B1 applyOrElse(A1 x3, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x3;
                        if (A1 instanceof ByteGeoTiffTile) {
                            ByteGeoTiffTile byteGeoTiffTile = (ByteGeoTiffTile)A1;
                            object = byteGeoTiffTile;
                        } else {
                            object = function1.apply(x3);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffTile x3) {
                        GeoTiffTile geoTiffTile = x3;
                        boolean bl = geoTiffTile instanceof ByteGeoTiffTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else if (dataType instanceof UByteCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffTile2 = new UByteGeoTiffTile(segmentBytes, decompressor, segmentLayout, compression, (UByteCells)((Object)noDataHandling), (List<UByteGeoTiffTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$4 -> MODULE$.applyOverview((GeoTiffTile)x$4, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffTile, B1> B1 applyOrElse(A1 x4, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x4;
                        if (A1 instanceof UByteGeoTiffTile) {
                            UByteGeoTiffTile uByteGeoTiffTile = (UByteGeoTiffTile)A1;
                            object = uByteGeoTiffTile;
                        } else {
                            object = function1.apply(x4);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffTile x4) {
                        GeoTiffTile geoTiffTile = x4;
                        boolean bl = geoTiffTile instanceof UByteGeoTiffTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else if (dataType instanceof ShortCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffTile2 = new Int16GeoTiffTile(segmentBytes, decompressor, segmentLayout, compression, (ShortCells)((Object)noDataHandling), (List<Int16GeoTiffTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$5 -> MODULE$.applyOverview((GeoTiffTile)x$5, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffTile, B1> B1 applyOrElse(A1 x5, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x5;
                        if (A1 instanceof Int16GeoTiffTile) {
                            Int16GeoTiffTile int16GeoTiffTile = (Int16GeoTiffTile)A1;
                            object = int16GeoTiffTile;
                        } else {
                            object = function1.apply(x5);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffTile x5) {
                        GeoTiffTile geoTiffTile = x5;
                        boolean bl = geoTiffTile instanceof Int16GeoTiffTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else if (dataType instanceof UShortCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffTile2 = new UInt16GeoTiffTile(segmentBytes, decompressor, segmentLayout, compression, (UShortCells)((Object)noDataHandling), (List<UInt16GeoTiffTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$6 -> MODULE$.applyOverview((GeoTiffTile)x$6, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffTile, B1> B1 applyOrElse(A1 x6, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x6;
                        if (A1 instanceof UInt16GeoTiffTile) {
                            UInt16GeoTiffTile uInt16GeoTiffTile = (UInt16GeoTiffTile)A1;
                            object = uInt16GeoTiffTile;
                        } else {
                            object = function1.apply(x6);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffTile x6) {
                        GeoTiffTile geoTiffTile = x6;
                        boolean bl = geoTiffTile instanceof UInt16GeoTiffTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else if (dataType instanceof IntCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffTile2 = new Int32GeoTiffTile(segmentBytes, decompressor, segmentLayout, compression, (IntCells)((Object)noDataHandling), (List<Int32GeoTiffTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$7 -> MODULE$.applyOverview((GeoTiffTile)x$7, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffTile, B1> B1 applyOrElse(A1 x7, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x7;
                        if (A1 instanceof Int32GeoTiffTile) {
                            Int32GeoTiffTile int32GeoTiffTile = (Int32GeoTiffTile)A1;
                            object = int32GeoTiffTile;
                        } else {
                            object = function1.apply(x7);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffTile x7) {
                        GeoTiffTile geoTiffTile = x7;
                        boolean bl = geoTiffTile instanceof Int32GeoTiffTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else if (dataType instanceof FloatCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffTile2 = new Float32GeoTiffTile(segmentBytes, decompressor, segmentLayout, compression, (FloatCells)((Object)noDataHandling), (List<Float32GeoTiffTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$8 -> MODULE$.applyOverview((GeoTiffTile)x$8, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffTile, B1> B1 applyOrElse(A1 x8, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x8;
                        if (A1 instanceof Float32GeoTiffTile) {
                            Float32GeoTiffTile float32GeoTiffTile = (Float32GeoTiffTile)A1;
                            object = float32GeoTiffTile;
                        } else {
                            object = function1.apply(x8);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffTile x8) {
                        GeoTiffTile geoTiffTile = x8;
                        boolean bl = geoTiffTile instanceof Float32GeoTiffTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else if (dataType instanceof DoubleCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffTile2 = new Float64GeoTiffTile(segmentBytes, decompressor, segmentLayout, compression, (DoubleCells)((Object)noDataHandling), (List<Float64GeoTiffTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$9 -> MODULE$.applyOverview((GeoTiffTile)x$9, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffTile, B1> B1 applyOrElse(A1 x9, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x9;
                        if (A1 instanceof Float64GeoTiffTile) {
                            Float64GeoTiffTile float64GeoTiffTile = (Float64GeoTiffTile)A1;
                            object = float64GeoTiffTile;
                        } else {
                            object = function1.apply(x9);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffTile x9) {
                        GeoTiffTile geoTiffTile = x9;
                        boolean bl = geoTiffTile instanceof Float64GeoTiffTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else {
                throw new MatchError((Object)dataType);
            }
            geoTiffTile = geoTiffTile2;
        }
        return geoTiffTile;
    }

    public GeoTiffTile applyOverview(GeoTiffTile geoTiffTile, Compression compression, DataType cellType, Option<BandType> bandType) {
        GeoTiffTile geoTiffTile2;
        Some some;
        BandType bandType2;
        int segmentCount = geoTiffTile.segmentCount();
        SegmentBytes segmentBytes = geoTiffTile.segmentBytes();
        GeoTiffSegmentLayout segmentLayout = geoTiffTile.segmentLayout();
        Compressor compressor = compression.createCompressor(segmentCount);
        Decompressor decompressor = compressor.createDecompressor();
        List overviews = (List)geoTiffTile.overviews().map((Function1 & Serializable & scala.Serializable)x$10 -> MODULE$.applyOverview((GeoTiffTile)x$10, compression, cellType, bandType), List$.MODULE$.canBuildFrom());
        Option<BandType> option = bandType;
        if (option instanceof Some && UInt32BandType$.MODULE$.equals(bandType2 = (BandType)(some = (Some)option).value())) {
            DataType dataType = cellType;
            if (!(dataType instanceof FloatCells)) {
                throw new IllegalArgumentException("UInt32BandType should always resolve to Float celltype");
            }
            NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
            UInt32GeoTiffTile uInt32GeoTiffTile = new UInt32GeoTiffTile(segmentBytes, decompressor, segmentLayout, compression, (FloatCells)((Object)noDataHandling), (List<UInt32GeoTiffTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$11 -> MODULE$.applyOverview((GeoTiffTile)x$11, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                public static final long serialVersionUID = 0L;

                public final <A1 extends GeoTiffTile, B1> B1 applyOrElse(A1 x10, Function1<A1, B1> function1) {
                    Object object;
                    A1 A1 = x10;
                    if (A1 instanceof UInt32GeoTiffTile) {
                        UInt32GeoTiffTile uInt32GeoTiffTile = (UInt32GeoTiffTile)A1;
                        object = uInt32GeoTiffTile;
                    } else {
                        object = function1.apply(x10);
                    }
                    return (B1)object;
                }

                public final boolean isDefinedAt(GeoTiffTile x10) {
                    GeoTiffTile geoTiffTile = x10;
                    boolean bl = geoTiffTile instanceof UInt32GeoTiffTile;
                    return bl;
                }
            }, List$.MODULE$.canBuildFrom())));
            geoTiffTile2 = uInt32GeoTiffTile;
        } else {
            GeoTiffTile geoTiffTile3;
            DataType dataType = cellType;
            if (dataType instanceof BitCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffTile3 = new BitGeoTiffTile(segmentBytes, decompressor, segmentLayout, compression, (BitCells)((Object)noDataHandling), (List<BitGeoTiffTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$12 -> MODULE$.applyOverview((GeoTiffTile)x$12, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffTile, B1> B1 applyOrElse(A1 x11, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x11;
                        if (A1 instanceof BitGeoTiffTile) {
                            BitGeoTiffTile bitGeoTiffTile = (BitGeoTiffTile)A1;
                            object = bitGeoTiffTile;
                        } else {
                            object = function1.apply(x11);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffTile x11) {
                        GeoTiffTile geoTiffTile = x11;
                        boolean bl = geoTiffTile instanceof BitGeoTiffTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else if (dataType instanceof ByteCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffTile3 = new ByteGeoTiffTile(segmentBytes, decompressor, segmentLayout, compression, (ByteCells)((Object)noDataHandling), (List<ByteGeoTiffTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$13 -> MODULE$.applyOverview((GeoTiffTile)x$13, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffTile, B1> B1 applyOrElse(A1 x12, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x12;
                        if (A1 instanceof ByteGeoTiffTile) {
                            ByteGeoTiffTile byteGeoTiffTile = (ByteGeoTiffTile)A1;
                            object = byteGeoTiffTile;
                        } else {
                            object = function1.apply(x12);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffTile x12) {
                        GeoTiffTile geoTiffTile = x12;
                        boolean bl = geoTiffTile instanceof ByteGeoTiffTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else if (dataType instanceof UByteCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffTile3 = new UByteGeoTiffTile(segmentBytes, decompressor, segmentLayout, compression, (UByteCells)((Object)noDataHandling), (List<UByteGeoTiffTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$14 -> MODULE$.applyOverview((GeoTiffTile)x$14, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffTile, B1> B1 applyOrElse(A1 x13, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x13;
                        if (A1 instanceof UByteGeoTiffTile) {
                            UByteGeoTiffTile uByteGeoTiffTile = (UByteGeoTiffTile)A1;
                            object = uByteGeoTiffTile;
                        } else {
                            object = function1.apply(x13);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffTile x13) {
                        GeoTiffTile geoTiffTile = x13;
                        boolean bl = geoTiffTile instanceof UByteGeoTiffTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else if (dataType instanceof ShortCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffTile3 = new Int16GeoTiffTile(segmentBytes, decompressor, segmentLayout, compression, (ShortCells)((Object)noDataHandling), (List<Int16GeoTiffTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$15 -> MODULE$.applyOverview((GeoTiffTile)x$15, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffTile, B1> B1 applyOrElse(A1 x14, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x14;
                        if (A1 instanceof Int16GeoTiffTile) {
                            Int16GeoTiffTile int16GeoTiffTile = (Int16GeoTiffTile)A1;
                            object = int16GeoTiffTile;
                        } else {
                            object = function1.apply(x14);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffTile x14) {
                        GeoTiffTile geoTiffTile = x14;
                        boolean bl = geoTiffTile instanceof Int16GeoTiffTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else if (dataType instanceof UShortCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffTile3 = new UInt16GeoTiffTile(segmentBytes, decompressor, segmentLayout, compression, (UShortCells)((Object)noDataHandling), (List<UInt16GeoTiffTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$16 -> MODULE$.applyOverview((GeoTiffTile)x$16, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffTile, B1> B1 applyOrElse(A1 x15, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x15;
                        if (A1 instanceof UInt16GeoTiffTile) {
                            UInt16GeoTiffTile uInt16GeoTiffTile = (UInt16GeoTiffTile)A1;
                            object = uInt16GeoTiffTile;
                        } else {
                            object = function1.apply(x15);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffTile x15) {
                        GeoTiffTile geoTiffTile = x15;
                        boolean bl = geoTiffTile instanceof UInt16GeoTiffTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else if (dataType instanceof IntCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffTile3 = new Int32GeoTiffTile(segmentBytes, decompressor, segmentLayout, compression, (IntCells)((Object)noDataHandling), (List<Int32GeoTiffTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$17 -> MODULE$.applyOverview((GeoTiffTile)x$17, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffTile, B1> B1 applyOrElse(A1 x16, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x16;
                        if (A1 instanceof Int32GeoTiffTile) {
                            Int32GeoTiffTile int32GeoTiffTile = (Int32GeoTiffTile)A1;
                            object = int32GeoTiffTile;
                        } else {
                            object = function1.apply(x16);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffTile x16) {
                        GeoTiffTile geoTiffTile = x16;
                        boolean bl = geoTiffTile instanceof Int32GeoTiffTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else if (dataType instanceof FloatCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffTile3 = new Float32GeoTiffTile(segmentBytes, decompressor, segmentLayout, compression, (FloatCells)((Object)noDataHandling), (List<Float32GeoTiffTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$18 -> MODULE$.applyOverview((GeoTiffTile)x$18, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffTile, B1> B1 applyOrElse(A1 x17, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x17;
                        if (A1 instanceof Float32GeoTiffTile) {
                            Float32GeoTiffTile float32GeoTiffTile = (Float32GeoTiffTile)A1;
                            object = float32GeoTiffTile;
                        } else {
                            object = function1.apply(x17);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffTile x17) {
                        GeoTiffTile geoTiffTile = x17;
                        boolean bl = geoTiffTile instanceof Float32GeoTiffTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else if (dataType instanceof DoubleCells) {
                NoDataHandling noDataHandling = (NoDataHandling)((Object)dataType);
                geoTiffTile3 = new Float64GeoTiffTile(segmentBytes, decompressor, segmentLayout, compression, (DoubleCells)((Object)noDataHandling), (List<Float64GeoTiffTile>)((List)((List)overviews.map((Function1 & Serializable & scala.Serializable)x$19 -> MODULE$.applyOverview((GeoTiffTile)x$19, compression, cellType, bandType), List$.MODULE$.canBuildFrom())).collect((PartialFunction)new scala.Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends GeoTiffTile, B1> B1 applyOrElse(A1 x18, Function1<A1, B1> function1) {
                        Object object;
                        A1 A1 = x18;
                        if (A1 instanceof Float64GeoTiffTile) {
                            Float64GeoTiffTile float64GeoTiffTile = (Float64GeoTiffTile)A1;
                            object = float64GeoTiffTile;
                        } else {
                            object = function1.apply(x18);
                        }
                        return (B1)object;
                    }

                    public final boolean isDefinedAt(GeoTiffTile x18) {
                        GeoTiffTile geoTiffTile = x18;
                        boolean bl = geoTiffTile instanceof Float64GeoTiffTile;
                        return bl;
                    }
                }, List$.MODULE$.canBuildFrom())));
            } else {
                throw new MatchError((Object)dataType);
            }
            geoTiffTile2 = geoTiffTile3;
        }
        return geoTiffTile2;
    }

    public GeoTiffTile apply(Tile tile) {
        return this.apply(tile, GeoTiffOptions$.MODULE$.DEFAULT());
    }

    public GeoTiffTile apply(Tile tile, GeoTiffOptions options) {
        Tile[] tileArray;
        BandType bandType = BandType$.MODULE$.forCellType(tile.cellType());
        GeoTiffSegmentLayout segmentLayout = GeoTiffSegmentLayout$.MODULE$.apply(tile.cols(), tile.rows(), options.storageMethod(), BandInterleave$.MODULE$, bandType);
        int segmentCount = segmentLayout.tileLayout().layoutCols() * segmentLayout.tileLayout().layoutRows();
        Compressor compressor = options.compression().createCompressor(segmentCount);
        byte[][] segmentBytes = (byte[][])Array$.MODULE$.ofDim(segmentCount, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        StorageMethod storageMethod = options.storageMethod();
        if (storageMethod instanceof Tiled) {
            tileArray = (Tile[])package$.MODULE$.withTileMethods(tile).split(segmentLayout.tileLayout());
        } else if (storageMethod instanceof Striped) {
            boolean x$54 = false;
            boolean x$55 = Split$Options$.MODULE$.apply$default$1();
            tileArray = package$.MODULE$.withTileMethods(tile).split(segmentLayout.tileLayout(), new Split.Options(x$55, x$54));
        } else {
            throw new MatchError((Object)storageMethod);
        }
        Tile[] segmentTiles = tileArray;
        for (int index$macro$282 = 0; index$macro$282 < segmentCount; ++index$macro$282) {
            byte[] bytes = segmentTiles[index$macro$282].toBytes();
            segmentBytes[index$macro$282] = compressor.compress(bytes, index$macro$282);
        }
        DataType dataType = tile.cellType();
        BitCellType$ bitCellType$ = BitCellType$.MODULE$;
        if (!(dataType != null ? !dataType.equals(bitCellType$) : bitCellType$ != null)) {
            for (int index$macro$284 = 0; index$macro$284 < segmentCount; ++index$macro$284) {
                for (int index$macro$283 = 0; index$macro$283 < segmentBytes[index$macro$284].length; ++index$macro$283) {
                    segmentBytes[index$macro$284][index$macro$283] = (byte)(Integer.reverse(segmentBytes[index$macro$284][index$macro$283]) >>> 24 & 0xFF);
                }
            }
        }
        return this.apply(new ArraySegmentBytes(segmentBytes), compressor.createDecompressor(), segmentLayout, options.compression(), tile.cellType(), this.apply$default$6(), this.apply$default$7());
    }

    public Option<BandType> apply$default$6() {
        return None$.MODULE$;
    }

    public List<GeoTiffTile> apply$default$7() {
        return Nil$.MODULE$;
    }

    public Option<BandType> applyOverview$default$4() {
        return None$.MODULE$;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private GeoTiffTile$() {
        MODULE$ = this;
    }
}

