/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import geotrellis.macros.DoubleTileMapper;
import geotrellis.macros.DoubleTileVisitor;
import geotrellis.macros.IntTileMapper;
import geotrellis.macros.IntTileVisitor;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.CellSet;
import geotrellis.raster.DataType;
import geotrellis.raster.GeoAttrsError;
import geotrellis.raster.Grid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.IterableTile;
import geotrellis.raster.MappableTile;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.Tile;
import geotrellis.raster.TileLayout;
import geotrellis.raster.io.geotiff.ArraySegmentBytes;
import geotrellis.raster.io.geotiff.BandType;
import geotrellis.raster.io.geotiff.GeoTiffImageData;
import geotrellis.raster.io.geotiff.GeoTiffOptions;
import geotrellis.raster.io.geotiff.GeoTiffSegment;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayoutTransform;
import geotrellis.raster.io.geotiff.GeoTiffTile;
import geotrellis.raster.io.geotiff.GeoTiffTile$;
import geotrellis.raster.io.geotiff.GeoTiffTile$Chip$4$;
import geotrellis.raster.io.geotiff.InterleaveMethod;
import geotrellis.raster.io.geotiff.SegmentBytes;
import geotrellis.raster.io.geotiff.SegmentTransform;
import geotrellis.raster.io.geotiff.StorageMethod;
import geotrellis.raster.io.geotiff.compression.Compression;
import geotrellis.raster.io.geotiff.compression.Compressor;
import geotrellis.raster.io.geotiff.compression.Decompressor;
import java.io.Serializable;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple5;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.SortedSet;
import scala.collection.mutable.SortedSet$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001\tew!B\u0001\u0003\u0011\u0003Y\u0011aC$f_RKgM\u001a+jY\u0016T!a\u0001\u0003\u0002\u000f\u001d,w\u000e^5gM*\u0011QAB\u0001\u0003S>T!a\u0002\u0005\u0002\rI\f7\u000f^3s\u0015\u0005I\u0011AC4f_R\u0014X\r\u001c7jg\u000e\u0001\u0001C\u0001\u0007\u000e\u001b\u0005\u0011a!\u0002\b\u0003\u0011\u0003y!aC$f_RKgM\u001a+jY\u0016\u001c2!\u0004\t\u0017!\t\tB#D\u0001\u0013\u0015\u0005\u0019\u0012!B:dC2\f\u0017BA\u000b\u0013\u0005\u0019\te.\u001f*fMB\u0011\u0011cF\u0005\u00031I\u0011AbU3sS\u0006d\u0017N_1cY\u0016DQAG\u0007\u0005\u0002m\ta\u0001P5oSRtD#A\u0006\t\u000buiA\u0011\u0001\u0010\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u001f}\u0011)Ea\u0014\u0003Z\tm#Q\fB0\u0005_\u0002\"\u0001\u0004\u0011\u0007\u000b9\u0011\u0011\u0011A\u0011\u0014\u000b\u0001\u0002\"EJ\u0015\u0011\u0005\r\"S\"\u0001\u0004\n\u0005\u00152!\u0001\u0002+jY\u0016\u0004\"\u0001D\u0014\n\u0005!\u0012!\u0001E$f_RKgMZ%nC\u001e,G)\u0019;b!\ta!&\u0003\u0002,\u0005\tir)Z8US\u001a47+Z4nK:$H*Y=pkR$&/\u00198tM>\u0014X\u000e\u0003\u0005.A\t\u0015\r\u0011\"\u0001/\u00035\u0019XmZ7f]Rd\u0015-_8viV\tq\u0006\u0005\u0002\ra%\u0011\u0011G\u0001\u0002\u0015\u000f\u0016|G+\u001b4g'\u0016<W.\u001a8u\u0019\u0006Lx.\u001e;\t\u0011M\u0002#\u0011!Q\u0001\n=\nab]3h[\u0016tG\u000fT1z_V$\b\u0005\u0003\u00056A\t\u0005\t\u0015!\u00037\u0003-\u0019w.\u001c9sKN\u001c\u0018n\u001c8\u0011\u0005]JT\"\u0001\u001d\u000b\u0005U\u0012\u0011B\u0001\u001e9\u0005-\u0019u.\u001c9sKN\u001c\u0018n\u001c8\t\u0011q\u0002#Q1A\u0005\u0002u\n\u0011b\u001c<feZLWm^:\u0016\u0003y\u00022aP$ \u001d\t\u0001UI\u0004\u0002B\t6\t!I\u0003\u0002D\u0015\u00051AH]8pizJ\u0011aE\u0005\u0003\rJ\tq\u0001]1dW\u0006<W-\u0003\u0002I\u0013\n!A*[:u\u0015\t1%\u0003\u0003\u0005LA\t\u0005\t\u0015!\u0003?\u0003)yg/\u001a:wS\u0016<8\u000f\t\u0005\u00065\u0001\"\t!\u0014\u000b\u0005?9{\u0005\u000bC\u0003.\u0019\u0002\u0007q\u0006C\u00036\u0019\u0002\u0007a\u0007C\u0004=\u0019B\u0005\t\u0019\u0001 \t\u000fI\u0003#\u0019!D\u0001'\u0006A1-\u001a7m)f\u0004X-F\u0001U!\t)6L\u0004\u0002W5:\u0011q+\u0017\b\u0003\u0003bK\u0011!C\u0005\u0003\u000f!I!A\u0012\u0004\n\u0005qk&\u0001C\"fY2$\u0016\u0010]3\u000b\u0005\u00193\u0001bB0!\u0005\u0004%\t\u0001Y\u0001\nE\u0006tGmQ8v]R,\u0012!\u0019\t\u0003#\tL!a\u0019\n\u0003\u0007%sG\u000f\u0003\u0004fA\u0001\u0006I!Y\u0001\u000bE\u0006tGmQ8v]R\u0004\u0003bB4!\u0005\u0004%\t\u0001Y\u0001\u0005G>d7\u000f\u0003\u0004jA\u0001\u0006I!Y\u0001\u0006G>d7\u000f\t\u0005\bW\u0002\u0012\r\u0011\"\u0001a\u0003\u0011\u0011xn^:\t\r5\u0004\u0003\u0015!\u0003b\u0003\u0015\u0011xn^:!\u0011\u001dy\u0007E1A\u0005\nA\fq![:US2,G-F\u0001r!\t\t\"/\u0003\u0002t%\t9!i\\8mK\u0006t\u0007BB;!A\u0003%\u0011/\u0001\u0005jgRKG.\u001a3!\u0011\u00159\b\u0005\"\u0001a\u0003E9W\r^(wKJ4\u0018.Z<t\u0007>,h\u000e\u001e\u0005\u0006s\u0002\"\tA_\u0001\fO\u0016$xJ^3sm&,w\u000f\u0006\u0002 w\")A\u0010\u001fa\u0001C\u0006\u0019\u0011\u000e\u001a=\t\u000by\u0004C\u0011A@\u0002\u000f\r|gN^3siR\u0019q$!\u0001\t\r\u0005\rQ\u00101\u0001U\u0003-qWm^\"fY2$\u0016\u0010]3\t\u0011\u0005\u001d\u0001E1A\u0005\u0002\u0001\fAb]3h[\u0016tGoQ8v]RDq!a\u0003!A\u0003%\u0011-A\u0007tK\u001elWM\u001c;D_VtG\u000f\t\u0005\b\u0003\u001f\u0001c\u0011AA\t\u0003)9W\r^*fO6,g\u000e\u001e\u000b\u0005\u0003'\tI\u0002E\u0002\r\u0003+I1!a\u0006\u0003\u000599Um\u001c+jM\u001a\u001cVmZ7f]RDq!a\u0007\u0002\u000e\u0001\u0007\u0011-A\u0001j\u0011\u001d\ty\u0002\tD\u0001\u0003C\t1bZ3u'\u0016<W.\u001a8ugR!\u00111EA\u0018!\u0015y\u0014QEA\u0015\u0013\r\t9#\u0013\u0002\t\u0013R,'/\u0019;peB1\u0011#a\u000bb\u0003'I1!!\f\u0013\u0005\u0019!V\u000f\u001d7fe!A\u0011\u0011GA\u000f\u0001\u0004\t\u0019$A\u0002jIN\u0004BaPA\u001bC&\u0019\u0011qG%\u0003\u0017Q\u0013\u0018M^3sg\u0006\u0014G.\u001a\u0005\b\u0003w\u0001C\u0011AA\u001f\u0003\r9W\r\u001e\u000b\u0006C\u0006}\u00121\t\u0005\b\u0003\u0003\nI\u00041\u0001b\u0003\r\u0019w\u000e\u001c\u0005\b\u0003\u000b\nI\u00041\u0001b\u0003\r\u0011xn\u001e\u0005\b\u0003\u0013\u0002C\u0011AA&\u0003%9W\r\u001e#pk\ndW\r\u0006\u0004\u0002N\u0005M\u0013Q\u000b\t\u0004#\u0005=\u0013bAA)%\t1Ai\\;cY\u0016Dq!!\u0011\u0002H\u0001\u0007\u0011\rC\u0004\u0002F\u0005\u001d\u0003\u0019A1\t\u000f\u0005e\u0003\u0005\"\u0001\u0002\\\u00059am\u001c:fC\u000eDG\u0003BA/\u0003G\u00022!EA0\u0013\r\t\tG\u0005\u0002\u0005+:LG\u000f\u0003\u0005\u0002f\u0005]\u0003\u0019AA4\u0003\u00051\u0007CB\t\u0002j\u0005\fi&C\u0002\u0002lI\u0011\u0011BR;oGRLwN\\\u0019\t\u000f\u0005=\u0004\u0005\"\u0001\u0002r\u0005iam\u001c:fC\u000eDGi\\;cY\u0016$B!!\u0018\u0002t!A\u0011QMA7\u0001\u0004\t)\bE\u0004\u0012\u0003S\ni%!\u0018\t\u000f\u0005e\u0004\u0005\"\u0001\u0002|\u0005\u0019Q.\u00199\u0015\u0007}\ti\b\u0003\u0005\u0002f\u0005]\u0004\u0019AA@!\u0015\t\u0012\u0011N1b\u0011\u001d\t\u0019\t\tC\u0001\u0003\u000b\u000b\u0011\"\\1q\t>,(\r\\3\u0015\u0007}\t9\t\u0003\u0005\u0002f\u0005\u0005\u0005\u0019AAE!\u001d\t\u0012\u0011NA'\u0003\u001bBq!!$!\t\u0003\ty)A\tg_J,\u0017m\u00195J]R4\u0016n]5u_J$B!!\u0018\u0002\u0012\"A\u00111SAF\u0001\u0004\t)*A\u0004wSNLGo\u001c:\u0011\u0007U\u000b9*C\u0002\u0002\u001av\u0013a\"\u00138u)&dWMV5tSR|'\u000fC\u0004\u0002\u001e\u0002\"\t!a(\u0002)\u0019|'/Z1dQ\u0012{WO\u00197f-&\u001c\u0018\u000e^8s)\u0011\ti&!)\t\u0011\u0005M\u00151\u0014a\u0001\u0003G\u00032!VAS\u0013\r\t9+\u0018\u0002\u0012\t>,(\r\\3US2,g+[:ji>\u0014\bbBAVA\u0011\u0005\u0011QV\u0001\r[\u0006\u0004\u0018J\u001c;NCB\u0004XM\u001d\u000b\u0004E\u0005=\u0006\u0002CAY\u0003S\u0003\r!a-\u0002\r5\f\u0007\u000f]3s!\r)\u0016QW\u0005\u0004\u0003ok&!D%oiRKG.Z'baB,'\u000fC\u0004\u0002<\u0002\"\t!!0\u0002\u001f5\f\u0007\u000fR8vE2,W*\u00199qKJ$2AIA`\u0011!\t\t,!/A\u0002\u0005\u0005\u0007cA+\u0002D&\u0019\u0011QY/\u0003!\u0011{WO\u00197f)&dW-T1qa\u0016\u0014\bbBAeA\u0011\u0005\u00111Z\u0001\bG>l'-\u001b8f)\u0011\ti-a6\u0015\u0007\t\ny\r\u0003\u0005\u0002f\u0005\u001d\u0007\u0019AAi!\u0019\t\u00121[1bC&\u0019\u0011Q\u001b\n\u0003\u0013\u0019+hn\u0019;j_:\u0014\u0004bBAm\u0003\u000f\u0004\rAI\u0001\u0006_RDWM\u001d\u0005\b\u0003;\u0004C\u0011AAp\u00035\u0019w.\u001c2j]\u0016$u.\u001e2mKR!\u0011\u0011]At)\r\u0011\u00131\u001d\u0005\t\u0003K\nY\u000e1\u0001\u0002fBI\u0011#a5\u0002N\u00055\u0013Q\n\u0005\b\u00033\fY\u000e1\u0001#\u0011\u001d\tY\u000f\tC\u0001\u0003[\fq\u0001^8BeJ\f\u0017\u0010\u0006\u0002\u0002pB!\u0011#!=b\u0013\r\t\u0019P\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\u0005\b\u0003o\u0004C\u0011AA}\u00035!x.\u0011:sCf$u.\u001e2mKR\u0011\u00111 \t\u0006#\u0005E\u0018Q\n\u0005\b\u0003\u007f\u0004C\u0011\u0001B\u0001\u0003-!x.\u0011:sCf$\u0016\u000e\\3\u0015\u0005\t\r\u0001cA\u0012\u0003\u0006%\u0019!q\u0001\u0004\u0003\u0013\u0005\u0013(/Y=US2,\u0007b\u0002B\u0006A\u0011\u0005!QB\u0001\b[V$\u0018M\u00197f+\t\u0011y\u0001E\u0002$\u0005#I1Aa\u0005\u0007\u0005AiU\u000f^1cY\u0016\f%O]1z)&dW\rC\u0004\u0003\u0018\u0001\"\tA!\u0007\u0002\t\r\u0014x\u000e\u001d\u000b\u0005\u0005\u001f\u0011Y\u0002\u0003\u0005\u0003\u001e\tU\u0001\u0019\u0001B\u0010\u0003\u0019\u0011w.\u001e8egB\u00191E!\t\n\u0007\t\rbA\u0001\u0006He&$'i\\;oINDqAa\u0006!\t\u0003\u00119\u0003\u0006\u0003\u0003*\t5\u0002#B \u0002&\t-\u0002cB\t\u0002,\t}!q\u0002\u0005\t\u0005_\u0011)\u00031\u0001\u00032\u00059q/\u001b8e_^\u001c\b#B \u00034\t}\u0011b\u0001B\u001b\u0013\n\u00191+Z9\t\u000f\te\u0002\u0005\"\u0001\u0003<\u00059Ao\u001c\"zi\u0016\u001cHC\u0001B\u001f!\u0015\t\u0012\u0011\u001fB !\r\t\"\u0011I\u0005\u0004\u0005\u0007\u0012\"\u0001\u0002\"zi\u0016DqAa\u0012\u001d\u0001\u0004\u0011I%\u0001\u0007tK\u001elWM\u001c;CsR,7\u000fE\u0002\r\u0005\u0017J1A!\u0014\u0003\u00051\u0019VmZ7f]R\u0014\u0015\u0010^3t\u0011\u001d\u0011\t\u0006\ba\u0001\u0005'\nA\u0002Z3d_6\u0004(/Z:t_J\u00042a\u000eB+\u0013\r\u00119\u0006\u000f\u0002\r\t\u0016\u001cw.\u001c9sKN\u001cxN\u001d\u0005\u0006[q\u0001\ra\f\u0005\u0006kq\u0001\rA\u000e\u0005\u0006%r\u0001\r\u0001\u0016\u0005\n\u0005Cb\u0002\u0013!a\u0001\u0005G\n\u0001BY1oIRK\b/\u001a\t\u0006#\t\u0015$\u0011N\u0005\u0004\u0005O\u0012\"AB(qi&|g\u000eE\u0002\r\u0005WJ1A!\u001c\u0003\u0005!\u0011\u0015M\u001c3UsB,\u0007b\u0002\u001f\u001d!\u0003\u0005\rA\u0010\u0005\b\u0005gjA\u0011\u0001B;\u00035\t\u0007\u000f\u001d7z\u001fZ,'O^5foRIqDa\u001e\u0003|\tu$q\u0010\u0005\b\u0005s\u0012\t\b1\u0001 \u0003-9Wm\u001c+jM\u001a$\u0016\u000e\\3\t\rU\u0012\t\b1\u00017\u0011\u0019\u0011&\u0011\u000fa\u0001)\"Q!\u0011\rB9!\u0003\u0005\rAa\u0019\t\ruiA\u0011\u0001BB)\ry\"Q\u0011\u0005\b\u0005\u000f\u0013\t\t1\u0001#\u0003\u0011!\u0018\u000e\\3\t\ruiA\u0011\u0001BF)\u0015y\"Q\u0012BH\u0011\u001d\u00119I!#A\u0002\tB\u0001B!%\u0003\n\u0002\u0007!1S\u0001\b_B$\u0018n\u001c8t!\ra!QS\u0005\u0004\u0005/\u0013!AD$f_RKgMZ(qi&|gn\u001d\u0005\n\u00057k\u0011\u0013!C\u0001\u0005;\u000b1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u001aTC\u0001BPU\rq$\u0011U\u0016\u0003\u0005G\u0003BA!*\u000306\u0011!q\u0015\u0006\u0005\u0005S\u0013Y+A\u0005v]\u000eDWmY6fI*\u0019!Q\u0016\n\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00032\n\u001d&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I!QW\u0007\u0012\u0002\u0013\u0005!qW\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%mU\u0011!\u0011\u0018\u0016\u0005\u0005G\u0012\t\u000bC\u0005\u0003>6\t\n\u0011\"\u0001\u0003\u001e\u0006y\u0011\r\u001d9ms\u0012\"WMZ1vYR$s\u0007C\u0005\u0003B6\t\n\u0011\"\u0001\u00038\u00069\u0012\r\u001d9ms>3XM\u001d<jK^$C-\u001a4bk2$H\u0005\u000e\u0005\n\u0005\u000bl\u0011\u0011!C\u0005\u0005\u000f\f1B]3bIJ+7o\u001c7wKR\u0011!\u0011\u001a\t\u0005\u0005\u0017\u0014).\u0004\u0002\u0003N*!!q\u001aBi\u0003\u0011a\u0017M\\4\u000b\u0005\tM\u0017\u0001\u00026bm\u0006LAAa6\u0003N\n1qJ\u00196fGR\u0004")
public abstract class GeoTiffTile
implements Tile,
GeoTiffImageData,
GeoTiffSegmentLayoutTransform {
    private final GeoTiffSegmentLayout segmentLayout;
    private final Compression compression;
    private final List<GeoTiffTile> overviews;
    private final int bandCount;
    private final int cols;
    private final int rows;
    private final boolean isTiled;
    private final int segmentCount;
    private Tuple5<Object, Object, TileLayout, StorageMethod, InterleaveMethod> geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$x$10;
    private int geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalCols;
    private int geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalRows;
    private TileLayout geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout;
    private StorageMethod geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$isTiled;
    private InterleaveMethod geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$interleaveMethod;
    private transient Logger logger;
    private volatile byte bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static Option<BandType> applyOverview$default$4() {
        return GeoTiffTile$.MODULE$.applyOverview$default$4();
    }

    public static List<GeoTiffTile> apply$default$7() {
        return GeoTiffTile$.MODULE$.apply$default$7();
    }

    public static Option<BandType> apply$default$6() {
        return GeoTiffTile$.MODULE$.apply$default$6();
    }

    public static List<GeoTiffTile> $lessinit$greater$default$3() {
        return GeoTiffTile$.MODULE$.$lessinit$greater$default$3();
    }

    public static GeoTiffTile apply(Tile tile, GeoTiffOptions geoTiffOptions) {
        return GeoTiffTile$.MODULE$.apply(tile, geoTiffOptions);
    }

    public static GeoTiffTile apply(Tile tile) {
        return GeoTiffTile$.MODULE$.apply(tile);
    }

    public static GeoTiffTile applyOverview(GeoTiffTile geoTiffTile, Compression compression, DataType dataType, Option<BandType> option) {
        return GeoTiffTile$.MODULE$.applyOverview(geoTiffTile, compression, dataType, option);
    }

    public static GeoTiffTile apply(SegmentBytes segmentBytes, Decompressor decompressor, GeoTiffSegmentLayout geoTiffSegmentLayout, Compression compression, DataType dataType, Option<BandType> option, List<GeoTiffTile> list) {
        return GeoTiffTile$.MODULE$.apply(segmentBytes, decompressor, geoTiffSegmentLayout, compression, dataType, option, list);
    }

    @Override
    public Tuple2<Object, Object> getSegmentDimensions(int segmentIndex) {
        return GeoTiffSegmentLayoutTransform.getSegmentDimensions$(this, segmentIndex);
    }

    @Override
    public int getSegmentSize(int segmentIndex) {
        return GeoTiffSegmentLayoutTransform.getSegmentSize$(this, segmentIndex);
    }

    @Override
    public int getSegmentIndex(int col, int row) {
        return GeoTiffSegmentLayoutTransform.getSegmentIndex$(this, col, row);
    }

    @Override
    public SegmentTransform getSegmentTransform(int segmentIndex) {
        return GeoTiffSegmentLayoutTransform.getSegmentTransform$(this, segmentIndex);
    }

    @Override
    public Tuple2<Object, Object> getSegmentCoordinate(int segmentIndex) {
        return GeoTiffSegmentLayoutTransform.getSegmentCoordinate$(this, segmentIndex);
    }

    @Override
    public GridBounds getGridBounds(int segmentIndex) {
        return GeoTiffSegmentLayoutTransform.getGridBounds$(this, segmentIndex);
    }

    @Override
    public int[] getIntersectingSegments(GridBounds bounds) {
        return GeoTiffSegmentLayoutTransform.getIntersectingSegments$(this, bounds);
    }

    @Override
    public GridBounds[][] partitionWindowsBySegments(Seq<GridBounds> windows, long maxPartitionSize) {
        return GeoTiffSegmentLayoutTransform.partitionWindowsBySegments$(this, windows, maxPartitionSize);
    }

    @Override
    public Tuple2<Object, Object>[] getIntersectingSegments(GridBounds bounds, int[] bands) {
        return GeoTiffSegmentLayoutTransform.getIntersectingSegments$(this, bounds, bands);
    }

    @Override
    public void dualForeach(Function1<Object, BoxedUnit> f, Function1<Object, BoxedUnit> g) {
        Tile.dualForeach$(this, f, g);
    }

    @Override
    public Tile mapIfSet(Function1<Object, Object> f) {
        return Tile.mapIfSet$(this, f);
    }

    @Override
    public Tile mapIfSetDouble(Function1<Object, Object> f) {
        return Tile.mapIfSetDouble$(this, f);
    }

    @Override
    public Tile dualMap(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile.dualMap$(this, f, g);
    }

    @Override
    public Tile dualMapIfSet(Function1<Object, Object> f, Function1<Object, Object> g) {
        return Tile.dualMapIfSet$(this, f, g);
    }

    @Override
    public Tile dualCombine(Tile r2, Function2<Object, Object, Object> f, Function2<Object, Object, Object> g) {
        return Tile.dualCombine$(this, r2, f, g);
    }

    @Override
    public boolean isNoDataTile() {
        return Tile.isNoDataTile$(this);
    }

    @Override
    public Tile normalize(int oldMin, int oldMax, int newMin, int newMax) {
        return Tile.normalize$((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile normalize(double oldMin, double oldMax, double newMin, double newMax) {
        return Tile.normalize$((Tile)this, oldMin, oldMax, newMin, newMax);
    }

    @Override
    public Tile rescale(int newMin, int newMax) {
        return Tile.rescale$((Tile)this, newMin, newMax);
    }

    @Override
    public Tile rescale(double newMin, double newMax) {
        return Tile.rescale$((Tile)this, newMin, newMax);
    }

    @Override
    public Tile downsample(int newCols, int newRows, Function1<CellSet, Object> f) {
        return Tile.downsample$(this, newCols, newRows, f);
    }

    @Override
    public Tuple2<Object, Object> findMinMax() {
        return Tile.findMinMax$(this);
    }

    @Override
    public Tuple2<Object, Object> findMinMaxDouble() {
        return Tile.findMinMaxDouble$(this);
    }

    @Override
    public int size() {
        return Grid.size$(this);
    }

    @Override
    public Tuple2<Object, Object> dimensions() {
        return Grid.dimensions$(this);
    }

    @Override
    public GridBounds gridBounds() {
        return Grid.gridBounds$(this);
    }

    private Tuple5<Object, Object, TileLayout, StorageMethod, InterleaveMethod> geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$x$10$lzycompute() {
        GeoTiffTile geoTiffTile = this;
        synchronized (geoTiffTile) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$x$10 = GeoTiffSegmentLayoutTransform.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$x$10$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$x$10;
    }

    @Override
    public /* synthetic */ Tuple5 geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$x$10() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$x$10$lzycompute() : this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$x$10;
    }

    private int geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalCols$lzycompute() {
        GeoTiffTile geoTiffTile = this;
        synchronized (geoTiffTile) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalCols = GeoTiffSegmentLayoutTransform.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalCols$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalCols;
    }

    @Override
    public int geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalCols() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalCols$lzycompute() : this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalCols;
    }

    private int geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalRows$lzycompute() {
        GeoTiffTile geoTiffTile = this;
        synchronized (geoTiffTile) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalRows = GeoTiffSegmentLayoutTransform.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalRows$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalRows;
    }

    @Override
    public int geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalRows() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalRows$lzycompute() : this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$totalRows;
    }

    private TileLayout geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout$lzycompute() {
        GeoTiffTile geoTiffTile = this;
        synchronized (geoTiffTile) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout = GeoTiffSegmentLayoutTransform.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout;
    }

    @Override
    public TileLayout geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout$lzycompute() : this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$tileLayout;
    }

    private StorageMethod geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$isTiled$lzycompute() {
        GeoTiffTile geoTiffTile = this;
        synchronized (geoTiffTile) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$isTiled = GeoTiffSegmentLayoutTransform.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$isTiled$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$isTiled;
    }

    @Override
    public StorageMethod geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$isTiled() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$isTiled$lzycompute() : this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$isTiled;
    }

    private InterleaveMethod geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$interleaveMethod$lzycompute() {
        GeoTiffTile geoTiffTile = this;
        synchronized (geoTiffTile) {
            if ((byte)(this.bitmap$0 & 0x20) == 0) {
                this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$interleaveMethod = GeoTiffSegmentLayoutTransform.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$interleaveMethod$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x20);
            }
        }
        return this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$interleaveMethod;
    }

    @Override
    public InterleaveMethod geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$interleaveMethod() {
        return (byte)(this.bitmap$0 & 0x20) == 0 ? this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$interleaveMethod$lzycompute() : this.geotrellis$raster$io$geotiff$GeoTiffSegmentLayoutTransform$$interleaveMethod;
    }

    private Logger logger$lzycompute() {
        GeoTiffTile geoTiffTile = this;
        synchronized (geoTiffTile) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public GeoTiffSegmentLayout segmentLayout() {
        return this.segmentLayout;
    }

    public List<GeoTiffTile> overviews() {
        return this.overviews;
    }

    @Override
    public abstract DataType cellType();

    @Override
    public int bandCount() {
        return this.bandCount;
    }

    @Override
    public int cols() {
        return this.cols;
    }

    @Override
    public int rows() {
        return this.rows;
    }

    private boolean isTiled() {
        return this.isTiled;
    }

    public int getOverviewsCount() {
        return this.overviews().length();
    }

    public GeoTiffTile getOverview(int idx) {
        return (GeoTiffTile)this.overviews().apply(idx);
    }

    @Override
    public GeoTiffTile convert(DataType newCellType) {
        BoxedUnit boxedUnit;
        if (newCellType.isFloatingPoint() != this.cellType().isFloatingPoint()) {
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Conversion from {} to {} may lead to data loss.", (Object[])new DataType[]{this.cellType(), newCellType});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        byte[][] arr = (byte[][])Array$.MODULE$.ofDim(this.segmentCount(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        Compressor compressor = this.compression.createCompressor(this.segmentCount());
        this.getSegments((Traversable<Object>)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.segmentCount())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            GeoTiffTile.$anonfun$convert$1(newCellType, arr, compressor, x0$1);
            return BoxedUnit.UNIT;
        });
        ArraySegmentBytes x$56 = new ArraySegmentBytes(arr);
        Decompressor x$57 = compressor.createDecompressor();
        GeoTiffSegmentLayout x$58 = this.segmentLayout();
        Compression x$59 = this.compression;
        DataType x$60 = newCellType;
        List x$61 = (List)this.overviews().map((Function1 & Serializable & scala.Serializable)x$26 -> x$26.convert(newCellType), List$.MODULE$.canBuildFrom());
        Option<BandType> x$62 = GeoTiffTile$.MODULE$.apply$default$6();
        return GeoTiffTile$.MODULE$.apply(x$56, x$57, x$58, x$59, x$60, x$62, (List<GeoTiffTile>)x$61);
    }

    public int segmentCount() {
        return this.segmentCount;
    }

    public abstract GeoTiffSegment getSegment(int var1);

    public abstract Iterator<Tuple2<Object, GeoTiffSegment>> getSegments(Traversable<Object> var1);

    @Override
    public int get(int col, int row) {
        int segmentIndex = this.getSegmentIndex(col, row);
        int i = this.getSegmentTransform(segmentIndex).gridToIndex(col, row);
        return this.getSegment(segmentIndex).getInt(i);
    }

    @Override
    public double getDouble(int col, int row) {
        int segmentIndex = this.getSegmentIndex(col, row);
        int i = this.getSegmentTransform(segmentIndex).gridToIndex(col, row);
        return this.getSegment(segmentIndex).getDouble(i);
    }

    @Override
    public void foreach(Function1<Object, BoxedUnit> f) {
        this.getSegments((Traversable<Object>)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.segmentCount())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            GeoTiffTile.$anonfun$foreach$1(this, f, x0$2);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void foreachDouble(Function1<Object, BoxedUnit> f) {
        this.getSegments((Traversable<Object>)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.segmentCount())).foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
            GeoTiffTile.$anonfun$foreachDouble$1(this, f, x0$3);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public GeoTiffTile map(Function1<Object, Object> f) {
        byte[][] arr = (byte[][])Array$.MODULE$.ofDim(this.segmentCount(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        Compressor compressor = this.compression.createCompressor(this.segmentCount());
        this.getSegments((Traversable<Object>)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.segmentCount())).foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
            GeoTiffTile.$anonfun$map$1(f, arr, compressor, x0$4);
            return BoxedUnit.UNIT;
        });
        ArraySegmentBytes x$63 = new ArraySegmentBytes(arr);
        Decompressor x$64 = compressor.createDecompressor();
        GeoTiffSegmentLayout x$65 = this.segmentLayout();
        Compression x$66 = this.compression;
        DataType x$67 = this.cellType();
        List<GeoTiffTile> x$68 = this.overviews();
        Option<BandType> x$69 = GeoTiffTile$.MODULE$.apply$default$6();
        return GeoTiffTile$.MODULE$.apply(x$63, x$64, x$65, x$66, x$67, x$69, x$68);
    }

    @Override
    public GeoTiffTile mapDouble(Function1<Object, Object> f) {
        byte[][] arr = (byte[][])Array$.MODULE$.ofDim(this.segmentCount(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        Compressor compressor = this.compression.createCompressor(this.segmentCount());
        this.getSegments((Traversable<Object>)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.segmentCount())).foreach((Function1 & Serializable & scala.Serializable)x0$5 -> {
            GeoTiffTile.$anonfun$mapDouble$1(f, arr, compressor, x0$5);
            return BoxedUnit.UNIT;
        });
        ArraySegmentBytes x$70 = new ArraySegmentBytes(arr);
        Decompressor x$71 = compressor.createDecompressor();
        GeoTiffSegmentLayout x$72 = this.segmentLayout();
        Compression x$73 = this.compression;
        DataType x$74 = this.cellType();
        List<GeoTiffTile> x$75 = this.overviews();
        Option<BandType> x$76 = GeoTiffTile$.MODULE$.apply$default$6();
        return GeoTiffTile$.MODULE$.apply(x$70, x$71, x$72, x$73, x$74, x$76, x$75);
    }

    public void foreachIntVisitor(IntTileVisitor visitor) {
        this.getSegments((Traversable<Object>)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.segmentCount())).foreach((Function1 & Serializable & scala.Serializable)x0$6 -> {
            GeoTiffTile.$anonfun$foreachIntVisitor$1(this, visitor, x0$6);
            return BoxedUnit.UNIT;
        });
    }

    public void foreachDoubleVisitor(DoubleTileVisitor visitor) {
        this.getSegments((Traversable<Object>)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.segmentCount())).foreach((Function1 & Serializable & scala.Serializable)x0$7 -> {
            GeoTiffTile.$anonfun$foreachDoubleVisitor$1(this, visitor, x0$7);
            return BoxedUnit.UNIT;
        });
    }

    public Tile mapIntMapper(IntTileMapper mapper) {
        byte[][] arr = (byte[][])Array$.MODULE$.ofDim(this.segmentCount(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        Compressor compressor = this.compression.createCompressor(this.segmentCount());
        this.getSegments((Traversable<Object>)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.segmentCount())).foreach((Function1 & Serializable & scala.Serializable)x0$8 -> {
            GeoTiffTile.$anonfun$mapIntMapper$1(this, mapper, arr, compressor, x0$8);
            return BoxedUnit.UNIT;
        });
        ArraySegmentBytes x$77 = new ArraySegmentBytes(arr);
        Decompressor x$78 = compressor.createDecompressor();
        GeoTiffSegmentLayout x$79 = this.segmentLayout();
        Compression x$80 = this.compression;
        DataType x$81 = this.cellType();
        List<GeoTiffTile> x$82 = this.overviews();
        Option<BandType> x$83 = GeoTiffTile$.MODULE$.apply$default$6();
        return GeoTiffTile$.MODULE$.apply(x$77, x$78, x$79, x$80, x$81, x$83, x$82);
    }

    public Tile mapDoubleMapper(DoubleTileMapper mapper) {
        byte[][] arr = (byte[][])Array$.MODULE$.ofDim(this.segmentCount(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        Compressor compressor = this.compression.createCompressor(this.segmentCount());
        this.getSegments((Traversable<Object>)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.segmentCount())).foreach((Function1 & Serializable & scala.Serializable)x0$9 -> {
            GeoTiffTile.$anonfun$mapDoubleMapper$1(this, mapper, arr, compressor, x0$9);
            return BoxedUnit.UNIT;
        });
        ArraySegmentBytes x$84 = new ArraySegmentBytes(arr);
        Decompressor x$85 = compressor.createDecompressor();
        GeoTiffSegmentLayout x$86 = this.segmentLayout();
        Compression x$87 = this.compression;
        DataType x$88 = this.cellType();
        List<GeoTiffTile> x$89 = this.overviews();
        Option<BandType> x$90 = GeoTiffTile$.MODULE$.apply$default$6();
        return GeoTiffTile$.MODULE$.apply(x$84, x$85, x$86, x$87, x$88, x$90, x$89);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Tile combine(Tile other, Function2<Object, Object, Object> f) {
        Tile tile = other;
        if (!(tile instanceof GeoTiffTile)) return this.mapIntMapper(new IntTileMapper(null, other, f){
            private final Tile other$1;
            private final Function2 f$5;

            public int apply(int col, int row, int z) {
                return this.f$5.apply$mcIII$sp(z, this.other$1.get(col, row));
            }
            {
                this.other$1 = other$1;
                this.f$5 = f$5;
            }
        });
        GeoTiffTile geoTiffTile = (GeoTiffTile)tile;
        TileLayout tileLayout = this.segmentLayout().tileLayout();
        TileLayout tileLayout2 = geoTiffTile.segmentLayout().tileLayout();
        if (tileLayout == null) {
            if (tileLayout2 != null) {
                return this.mapIntMapper(new /* invalid duplicate definition of identical inner class */);
            }
        } else if (!((Object)tileLayout).equals(tileLayout2)) return this.mapIntMapper(new /* invalid duplicate definition of identical inner class */);
        byte[][] arr = (byte[][])Array$.MODULE$.ofDim(this.segmentCount(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        Compressor compressor = this.compression.createCompressor(this.segmentCount());
        this.getSegments((Traversable<Object>)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.segmentCount())).zip(geoTiffTile.getSegments((Traversable<Object>)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.segmentCount()))).foreach((Function1 & Serializable & scala.Serializable)x0$10 -> {
            GeoTiffTile.$anonfun$combine$1(f, arr, compressor, x0$10);
            return BoxedUnit.UNIT;
        });
        ArraySegmentBytes x$91 = new ArraySegmentBytes(arr);
        Decompressor x$92 = compressor.createDecompressor();
        GeoTiffSegmentLayout x$93 = this.segmentLayout();
        Compression x$94 = this.compression;
        DataType x$95 = this.cellType();
        List<GeoTiffTile> x$96 = this.overviews();
        Option<BandType> x$97 = GeoTiffTile$.MODULE$.apply$default$6();
        return GeoTiffTile$.MODULE$.apply(x$91, x$92, x$93, x$94, x$95, x$97, x$96);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Tile combineDouble(Tile other, Function2<Object, Object, Object> f) {
        Tile tile = other;
        if (!(tile instanceof GeoTiffTile)) return this.mapDoubleMapper(new DoubleTileMapper(null, other, f){
            private final Tile other$2;
            private final Function2 f$6;

            public double apply(int col, int row, double z) {
                return this.f$6.apply$mcDDD$sp(z, (double)this.other$2.get(col, row));
            }
            {
                this.other$2 = other$2;
                this.f$6 = f$6;
            }
        });
        GeoTiffTile geoTiffTile = (GeoTiffTile)tile;
        TileLayout tileLayout = this.segmentLayout().tileLayout();
        TileLayout tileLayout2 = geoTiffTile.segmentLayout().tileLayout();
        if (tileLayout == null) {
            if (tileLayout2 != null) {
                return this.mapDoubleMapper(new /* invalid duplicate definition of identical inner class */);
            }
        } else if (!((Object)tileLayout).equals(tileLayout2)) return this.mapDoubleMapper(new /* invalid duplicate definition of identical inner class */);
        byte[][] arr = (byte[][])Array$.MODULE$.ofDim(this.segmentCount(), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
        Compressor compressor = this.compression.createCompressor(this.segmentCount());
        this.getSegments((Traversable<Object>)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.segmentCount())).zip(geoTiffTile.getSegments((Traversable<Object>)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.segmentCount()))).foreach((Function1 & Serializable & scala.Serializable)x0$11 -> {
            GeoTiffTile.$anonfun$combineDouble$1(f, arr, compressor, x0$11);
            return BoxedUnit.UNIT;
        });
        ArraySegmentBytes x$98 = new ArraySegmentBytes(arr);
        Decompressor x$99 = compressor.createDecompressor();
        GeoTiffSegmentLayout x$100 = this.segmentLayout();
        Compression x$101 = this.compression;
        DataType x$102 = this.cellType();
        List<GeoTiffTile> x$103 = this.overviews();
        Option<BandType> x$104 = GeoTiffTile$.MODULE$.apply$default$6();
        return GeoTiffTile$.MODULE$.apply(x$98, x$99, x$100, x$101, x$102, x$104, x$103);
    }

    @Override
    public int[] toArray() {
        return this.toArrayTile().toArray();
    }

    @Override
    public double[] toArrayDouble() {
        return this.toArrayTile().toArrayDouble();
    }

    @Override
    public ArrayTile toArrayTile() {
        return this.mutable();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MutableArrayTile mutable() {
        void var1_1;
        MutableArrayTile tile = ArrayTile$.MODULE$.empty(this.cellType(), this.cols(), this.rows());
        this.getSegments((Traversable<Object>)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.segmentCount())).foreach((Function1 & Serializable & scala.Serializable)x0$12 -> {
            GeoTiffTile.$anonfun$mutable$1(this, tile, x0$12);
            return BoxedUnit.UNIT;
        });
        return var1_1;
    }

    public MutableArrayTile crop(GridBounds bounds) {
        Iterator<Tuple2<GridBounds, MutableArrayTile>> iter = this.crop((Seq<GridBounds>)new .colon.colon((Object)bounds, (List)Nil$.MODULE$));
        if (iter.isEmpty()) {
            throw new GeoAttrsError(new StringBuilder(24).append("No intersections of ").append(bounds).append(" vs ").append(this.gridBounds()).toString());
        }
        return (MutableArrayTile)((Tuple2)iter.next())._2();
    }

    public Iterator<Tuple2<GridBounds, MutableArrayTile>> crop(Seq<GridBounds> windows) {
        LazyRef Chip$module = new LazyRef();
        Map chipsBySegment = Map$.MODULE$.empty();
        SortedSet intersectingSegments = SortedSet$.MODULE$.empty((Ordering)Ordering.Int$.MODULE$);
        windows.foreach((Function1 & Serializable & scala.Serializable)window -> {
            int[] segments = this.getIntersectingSegments((GridBounds)window);
            MutableArrayTile tile = ArrayTile$.MODULE$.empty(this.cellType(), window.width(), window.height());
            public class Geotrellis_raster_io_geotiff_GeoTiffTile$Chip$3
            implements Product,
            scala.Serializable {
                private final GridBounds window;
                private final MutableArrayTile tile;
                private final int intersectingSegments;
                private int segmentsBurned;
                private final /* synthetic */ GeoTiffTile $outer;

                public GridBounds window() {
                    return this.window;
                }

                public MutableArrayTile tile() {
                    return this.tile;
                }

                public int intersectingSegments() {
                    return this.intersectingSegments;
                }

                public int segmentsBurned() {
                    return this.segmentsBurned;
                }

                public void segmentsBurned_$eq(int x$1) {
                    this.segmentsBurned = x$1;
                }

                public Geotrellis_raster_io_geotiff_GeoTiffTile$Chip$3 copy(GridBounds window, MutableArrayTile tile, int intersectingSegments, int segmentsBurned) {
                    return new Geotrellis_raster_io_geotiff_GeoTiffTile$Chip$3(this.$outer, window, tile, intersectingSegments, segmentsBurned);
                }

                public GridBounds copy$default$1() {
                    return this.window();
                }

                public MutableArrayTile copy$default$2() {
                    return this.tile();
                }

                public int copy$default$3() {
                    return this.intersectingSegments();
                }

                public int copy$default$4() {
                    return this.segmentsBurned();
                }

                public String productPrefix() {
                    return "Chip";
                }

                public int productArity() {
                    return 4;
                }

                public Object productElement(int x$1) {
                    Object object;
                    int n = x$1;
                    switch (n) {
                        case 0: {
                            object = this.window();
                            break;
                        }
                        case 1: {
                            object = this.tile();
                            break;
                        }
                        case 2: {
                            object = BoxesRunTime.boxToInteger((int)this.intersectingSegments());
                            break;
                        }
                        case 3: {
                            object = BoxesRunTime.boxToInteger((int)this.segmentsBurned());
                            break;
                        }
                        default: {
                            throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                        }
                    }
                    return object;
                }

                public Iterator<Object> productIterator() {
                    return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
                }

                public boolean canEqual(Object x$1) {
                    return x$1 instanceof Geotrellis_raster_io_geotiff_GeoTiffTile$Chip$3;
                }

                public int hashCode() {
                    int n = -889275714;
                    n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.window()));
                    n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.tile()));
                    n = Statics.mix((int)n, (int)this.intersectingSegments());
                    n = Statics.mix((int)n, (int)this.segmentsBurned());
                    return Statics.finalizeHash((int)n, (int)4);
                }

                public String toString() {
                    return ScalaRunTime$.MODULE$._toString((Product)this);
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean equals(Object x$1) {
                    if (this == x$1) return true;
                    Object object = x$1;
                    if (!(object instanceof Geotrellis_raster_io_geotiff_GeoTiffTile$Chip$3)) return false;
                    boolean bl = true;
                    if (!bl) return false;
                    Geotrellis_raster_io_geotiff_GeoTiffTile$Chip$3 var4_4 = (Geotrellis_raster_io_geotiff_GeoTiffTile$Chip$3)x$1;
                    GridBounds gridBounds = this.window();
                    GridBounds gridBounds2 = var4_4.window();
                    if (gridBounds == null) {
                        if (gridBounds2 != null) {
                            return false;
                        }
                    } else if (!((Object)gridBounds).equals(gridBounds2)) return false;
                    MutableArrayTile mutableArrayTile = this.tile();
                    MutableArrayTile mutableArrayTile2 = var4_4.tile();
                    if (mutableArrayTile == null) {
                        if (mutableArrayTile2 != null) {
                            return false;
                        }
                    } else if (!mutableArrayTile.equals(mutableArrayTile2)) return false;
                    if (this.intersectingSegments() != var4_4.intersectingSegments()) return false;
                    if (this.segmentsBurned() != var4_4.segmentsBurned()) return false;
                    if (!var4_4.canEqual(this)) return false;
                    return true;
                }

                public Geotrellis_raster_io_geotiff_GeoTiffTile$Chip$3(GeoTiffTile $outer, GridBounds window, MutableArrayTile tile, int intersectingSegments, int segmentsBurned) {
                    this.window = window;
                    this.tile = tile;
                    this.intersectingSegments = intersectingSegments;
                    this.segmentsBurned = segmentsBurned;
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    Product.$init$((Product)this);
                }
            }
            Geotrellis_raster_io_geotiff_GeoTiffTile$Chip$3 chip = this.Chip$2(Chip$module).apply((GridBounds)window, tile, segments.length, this.Chip$2(Chip$module).apply$default$4());
            new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(segments)).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)segment -> {
                List tail = (List)chipsBySegment.getOrElse((Object)BoxesRunTime.boxToInteger((int)segment), (Function0 & Serializable & scala.Serializable)() -> Nil$.MODULE$);
                Geotrellis_raster_io_geotiff_GeoTiffTile$Chip$3 var4_4 = chip;
                chipsBySegment.update((Object)BoxesRunTime.boxToInteger((int)segment), (Object)tail.$colon$colon((Object)var4_4));
            });
            return (SortedSet)intersectingSegments.$plus$plus$eq((TraversableOnce)new ArrayOps.ofInt(Predef$.MODULE$.intArrayOps(segments)));
        });
        return this.getSegments((Traversable<Object>)intersectingSegments).flatMap((Function1 & Serializable & scala.Serializable)x0$13 -> {
            Tuple2 tuple2 = x0$13;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int segmentId = tuple2._1$mcI$sp();
            GeoTiffSegment segment = (GeoTiffSegment)tuple2._2();
            List list = this.burnSegments$1(segmentId, segment, chipsBySegment);
            return list;
        }).map((Function1 & Serializable & scala.Serializable)chip -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)chip.window()), (Object)chip.tile()));
    }

    @Override
    public byte[] toBytes() {
        return this.toArrayTile().toBytes();
    }

    public static final /* synthetic */ void $anonfun$convert$1(DataType newCellType$1, byte[][] arr$1, Compressor compressor$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int segmentIndex = tuple2._1$mcI$sp();
        GeoTiffSegment segment = (GeoTiffSegment)tuple2._2();
        byte[] newBytes = segment.convert(newCellType$1);
        arr$1[segmentIndex] = compressor$1.compress(newBytes, segmentIndex);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$foreach$1(GeoTiffTile $this, Function1 f$1, Tuple2 x0$2) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$2;
        if (tuple2 != null) {
            int segmentIndex = tuple2._1$mcI$sp();
            GeoTiffSegment segment = (GeoTiffSegment)tuple2._2();
            int segmentSize = segment.size();
            if ($this.isTiled()) {
                SegmentTransform segmentTransform = $this.getSegmentTransform(segmentIndex);
                for (int index$macro$285 = 0; index$macro$285 < segmentSize; ++index$macro$285) {
                    int col = segmentTransform.indexToCol(index$macro$285);
                    int row = segmentTransform.indexToRow(index$macro$285);
                    if (col >= $this.cols() || row >= $this.rows()) continue;
                    f$1.apply$mcVI$sp(segment.getInt(index$macro$285));
                }
                boxedUnit = BoxedUnit.UNIT;
            } else {
                for (int index$macro$286 = 0; index$macro$286 < segmentSize; ++index$macro$286) {
                    f$1.apply$mcVI$sp(segment.getInt(index$macro$286));
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$foreachDouble$1(GeoTiffTile $this, Function1 f$2, Tuple2 x0$3) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$3;
        if (tuple2 != null) {
            int segmentIndex = tuple2._1$mcI$sp();
            GeoTiffSegment segment = (GeoTiffSegment)tuple2._2();
            int segmentSize = segment.size();
            if ($this.isTiled()) {
                SegmentTransform segmentTransform = $this.getSegmentTransform(segmentIndex);
                for (int index$macro$287 = 0; index$macro$287 < segmentSize; ++index$macro$287) {
                    int col = segmentTransform.indexToCol(index$macro$287);
                    int row = segmentTransform.indexToRow(index$macro$287);
                    if (col >= $this.cols() || row >= $this.rows()) continue;
                    f$2.apply$mcVD$sp(segment.getDouble(index$macro$287));
                }
                boxedUnit = BoxedUnit.UNIT;
            } else {
                for (int index$macro$288 = 0; index$macro$288 < segmentSize; ++index$macro$288) {
                    f$2.apply$mcVD$sp(segment.getDouble(index$macro$288));
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    public static final /* synthetic */ void $anonfun$map$1(Function1 f$3, byte[][] arr$2, Compressor compressor$2, Tuple2 x0$4) {
        Tuple2 tuple2 = x0$4;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int segmentIndex = tuple2._1$mcI$sp();
        GeoTiffSegment segment = (GeoTiffSegment)tuple2._2();
        byte[] newBytes = segment.map((Function1<Object, Object>)(JFunction1.mcII.sp & Serializable & scala.Serializable)x$35 -> f$3.apply$mcII$sp(x$35));
        arr$2[segmentIndex] = compressor$2.compress(newBytes, segmentIndex);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$mapDouble$1(Function1 f$4, byte[][] arr$3, Compressor compressor$3, Tuple2 x0$5) {
        Tuple2 tuple2 = x0$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int segmentIndex = tuple2._1$mcI$sp();
        GeoTiffSegment segment = (GeoTiffSegment)tuple2._2();
        byte[] newBytes = segment.mapDouble((Function1<Object, Object>)f$4);
        arr$3[segmentIndex] = compressor$3.compress(newBytes, segmentIndex);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$foreachIntVisitor$1(GeoTiffTile $this, IntTileVisitor visitor$1, Tuple2 x0$6) {
        Tuple2 tuple2 = x0$6;
        if (tuple2 != null) {
            int segmentIndex = tuple2._1$mcI$sp();
            GeoTiffSegment segment = (GeoTiffSegment)tuple2._2();
            int segmentSize = segment.size();
            SegmentTransform segmentTransform = $this.getSegmentTransform(segmentIndex);
            for (int index$macro$289 = 0; index$macro$289 < segmentSize; ++index$macro$289) {
                int col = segmentTransform.indexToCol(index$macro$289);
                int row = segmentTransform.indexToRow(index$macro$289);
                if (col >= $this.cols() || row >= $this.rows()) continue;
                visitor$1.apply(col, row, segment.getInt(index$macro$289));
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$foreachDoubleVisitor$1(GeoTiffTile $this, DoubleTileVisitor visitor$2, Tuple2 x0$7) {
        Tuple2 tuple2 = x0$7;
        if (tuple2 != null) {
            int segmentIndex = tuple2._1$mcI$sp();
            GeoTiffSegment segment = (GeoTiffSegment)tuple2._2();
            int segmentSize = segment.size();
            SegmentTransform segmentTransform = $this.getSegmentTransform(segmentIndex);
            for (int index$macro$290 = 0; index$macro$290 < segmentSize; ++index$macro$290) {
                int col = segmentTransform.indexToCol(index$macro$290);
                int row = segmentTransform.indexToRow(index$macro$290);
                if (col >= $this.cols() || row >= $this.rows()) continue;
                visitor$2.apply(col, row, segment.getDouble(index$macro$290));
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$mapIntMapper$1(GeoTiffTile $this, IntTileMapper mapper$1, byte[][] arr$4, Compressor compressor$4, Tuple2 x0$8) {
        Tuple2 tuple2 = x0$8;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int segmentIndex = tuple2._1$mcI$sp();
        GeoTiffSegment segment = (GeoTiffSegment)tuple2._2();
        SegmentTransform segmentTransform = $this.getSegmentTransform(segmentIndex);
        byte[] newBytes = segment.mapWithIndex((Function2<Object, Object, Object>)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(i, z) -> {
            int col = segmentTransform.indexToCol(i);
            int row = segmentTransform.indexToRow(i);
            return col < $this.cols() && row < $this.rows() ? mapper$1.apply(col, row, z) : 0;
        });
        arr$4[segmentIndex] = compressor$4.compress(newBytes, segmentIndex);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$mapDoubleMapper$1(GeoTiffTile $this, DoubleTileMapper mapper$2, byte[][] arr$5, Compressor compressor$5, Tuple2 x0$9) {
        Tuple2 tuple2 = x0$9;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int segmentIndex = tuple2._1$mcI$sp();
        GeoTiffSegment segment = (GeoTiffSegment)tuple2._2();
        SegmentTransform segmentTransform = $this.getSegmentTransform(segmentIndex);
        byte[] newBytes = segment.mapDoubleWithIndex((Function2<Object, Object, Object>)(JFunction2.mcDID.sp & Serializable & scala.Serializable)(i, z) -> {
            int col = segmentTransform.indexToCol(i);
            int row = segmentTransform.indexToRow(i);
            return col < $this.cols() && row < $this.rows() ? mapper$2.apply(col, row, z) : 0.0;
        });
        arr$5[segmentIndex] = compressor$5.compress(newBytes, segmentIndex);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$combine$1(Function2 f$5, byte[][] arr$6, Compressor compressor$6, Tuple2 x0$10) {
        GeoTiffSegment segment;
        int segmentIndex;
        Tuple2 tuple2;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = x0$10;
                if (tuple22 == null) break block2;
                Tuple2 tuple23 = (Tuple2)tuple22._1();
                tuple2 = (Tuple2)tuple22._2();
                if (tuple23 == null) break block2;
                segmentIndex = tuple23._1$mcI$sp();
                segment = (GeoTiffSegment)tuple23._2();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        int otherIndex = tuple2._1$mcI$sp();
        GeoTiffSegment otherSegment = (GeoTiffSegment)tuple2._2();
        Predef$.MODULE$.require(segmentIndex == otherIndex, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Segment index mismatch: ").append(segmentIndex).append(" != ").append(otherIndex).toString());
        byte[] newBytes = segment.mapWithIndex((Function2<Object, Object, Object>)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(i, z) -> f$5.apply$mcIII$sp(z, otherSegment.getInt(i)));
        arr$6[segmentIndex] = compressor$6.compress(newBytes, segmentIndex);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$combineDouble$1(Function2 f$6, byte[][] arr$7, Compressor compressor$7, Tuple2 x0$11) {
        GeoTiffSegment segment;
        int segmentIndex;
        Tuple2 tuple2;
        block3: {
            Tuple2 tuple22;
            block2: {
                tuple22 = x0$11;
                if (tuple22 == null) break block2;
                Tuple2 tuple23 = (Tuple2)tuple22._1();
                tuple2 = (Tuple2)tuple22._2();
                if (tuple23 == null) break block2;
                segmentIndex = tuple23._1$mcI$sp();
                segment = (GeoTiffSegment)tuple23._2();
                if (tuple2 != null) break block3;
            }
            throw new MatchError((Object)tuple22);
        }
        int otherIndex = tuple2._1$mcI$sp();
        GeoTiffSegment otherSegment = (GeoTiffSegment)tuple2._2();
        Predef$.MODULE$.require(segmentIndex == otherIndex, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Segment index mismatch: ").append(segmentIndex).append(" != ").append(otherIndex).toString());
        byte[] newBytes = segment.mapDoubleWithIndex((Function2<Object, Object, Object>)(JFunction2.mcDID.sp & Serializable & scala.Serializable)(i, z) -> f$6.apply$mcDDD$sp(z, otherSegment.getDouble(i)));
        arr$7[segmentIndex] = compressor$7.compress(newBytes, segmentIndex);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$mutable$1(GeoTiffTile $this, MutableArrayTile tile$1, Tuple2 x0$12) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$12;
        if (tuple2 != null) {
            int segmentId = tuple2._1$mcI$sp();
            GeoTiffSegment segment = (GeoTiffSegment)tuple2._2();
            SegmentTransform segmentTransform = $this.getSegmentTransform(segmentId);
            if ($this.cellType().isFloatingPoint()) {
                for (int index$macro$291 = 0; index$macro$291 < segment.size(); ++index$macro$291) {
                    int col = segmentTransform.indexToCol(index$macro$291);
                    int row = segmentTransform.indexToRow(index$macro$291);
                    if (col >= $this.cols() || row >= $this.rows()) continue;
                    double v = segment.getDouble(index$macro$291);
                    tile$1.setDouble(col, row, v);
                }
                boxedUnit = BoxedUnit.UNIT;
            } else {
                for (int index$macro$292 = 0; index$macro$292 < segment.size(); ++index$macro$292) {
                    int col = segmentTransform.indexToCol(index$macro$292);
                    int row = segmentTransform.indexToRow(index$macro$292);
                    if (col >= $this.cols() || row >= $this.rows()) continue;
                    int v = segment.getInt(index$macro$292);
                    tile$1.set(col, row, v);
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private final /* synthetic */ GeoTiffTile$Chip$4$ Chip$lzycompute$1(LazyRef Chip$module$1) {
        GeoTiffTile$Chip$4$ geoTiffTile$Chip$4$;
        LazyRef lazyRef = Chip$module$1;
        synchronized (lazyRef) {
            geoTiffTile$Chip$4$ = Chip$module$1.initialized() ? (GeoTiffTile$Chip$4$)((Object)Chip$module$1.value()) : (GeoTiffTile$Chip$4$)((Object)Chip$module$1.initialize((Object)new GeoTiffTile$Chip$4$(this)));
        }
        return geoTiffTile$Chip$4$;
    }

    private final GeoTiffTile$Chip$4$ Chip$2(LazyRef Chip$module$1) {
        return Chip$module$1.initialized() ? (GeoTiffTile$Chip$4$)((Object)Chip$module$1.value()) : this.Chip$lzycompute$1(Chip$module$1);
    }

    public static final /* synthetic */ void $anonfun$crop$4(GeoTiffTile $this, GeoTiffSegment segment$1, ObjectRef finished$1, GridBounds segmentBounds$1, SegmentTransform segmentTransform$3, Chip.3 chip) {
        block6: {
            GridBounds gridBounds = chip.window();
            GridBounds overlap = (GridBounds)gridBounds.intersection(segmentBounds$1).get();
            if ($this.cellType().isFloatingPoint()) {
                for (int index$macro$294 = overlap.colMin(); index$macro$294 <= overlap.colMax(); ++index$macro$294) {
                    for (int index$macro$293 = overlap.rowMin(); index$macro$293 <= overlap.rowMax(); ++index$macro$293) {
                        int i = segmentTransform$3.gridToIndex(index$macro$294, index$macro$293);
                        double v = segment$1.getDouble(i);
                        chip.tile().setDouble(index$macro$294 - gridBounds.colMin(), index$macro$293 - gridBounds.rowMin(), v);
                    }
                }
            } else {
                for (int index$macro$296 = overlap.colMin(); index$macro$296 <= overlap.colMax(); ++index$macro$296) {
                    for (int index$macro$295 = overlap.rowMin(); index$macro$295 <= overlap.rowMax(); ++index$macro$295) {
                        int i = segmentTransform$3.gridToIndex(index$macro$296, index$macro$295);
                        int v = segment$1.getInt(i);
                        chip.tile().set(index$macro$296 - gridBounds.colMin(), index$macro$295 - gridBounds.rowMin(), v);
                    }
                }
            }
            chip.segmentsBurned_$eq(chip.segmentsBurned() + 1);
            if (chip.segmentsBurned() != chip.intersectingSegments()) break block6;
            Geotrellis_raster_io_geotiff_GeoTiffTile$Chip$3 var17_16 = chip;
            finished$1.elem = ((List)finished$1.elem).$colon$colon((Object)var17_16);
        }
    }

    private final List burnSegments$1(int segmentId, GeoTiffSegment segment, Map chipsBySegment$1) {
        ObjectRef finished = ObjectRef.create((Object)Nil$.MODULE$);
        GridBounds segmentBounds = this.getGridBounds(segmentId);
        SegmentTransform segmentTransform = this.getSegmentTransform(segmentId);
        ((List)chipsBySegment$1.apply((Object)BoxesRunTime.boxToInteger((int)segmentId))).foreach((Function1 & Serializable & scala.Serializable)chip -> {
            GeoTiffTile.$anonfun$crop$4(this, segment, finished, segmentBounds, segmentTransform, chip);
            return BoxedUnit.UNIT;
        });
        chipsBySegment$1.remove((Object)BoxesRunTime.boxToInteger((int)segmentId));
        return (List)finished.elem;
    }

    public GeoTiffTile(GeoTiffSegmentLayout segmentLayout, Compression compression, List<GeoTiffTile> overviews) {
        this.segmentLayout = segmentLayout;
        this.compression = compression;
        this.overviews = overviews;
        Grid.$init$(this);
        IterableTile.$init$(this);
        MappableTile.$init$(this);
        LazyLogging.$init$((LazyLogging)this);
        Tile.$init$(this);
        GeoTiffSegmentLayoutTransform.$init$(this);
        this.bandCount = 1;
        this.cols = segmentLayout.totalCols();
        this.rows = segmentLayout.totalRows();
        this.isTiled = segmentLayout.isTiled();
        this.segmentCount = this.segmentBytes().size();
    }
}

