/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.proj4.CRS;
import geotrellis.raster.ArrayMultibandTile;
import geotrellis.raster.CellSize;
import geotrellis.raster.DataType;
import geotrellis.raster.GeoAttrsError;
import geotrellis.raster.GridBounds;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.MultibandTile$;
import geotrellis.raster.PixelSampleType;
import geotrellis.raster.ProjectedRaster;
import geotrellis.raster.Raster;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.Tile;
import geotrellis.raster.crop.Crop;
import geotrellis.raster.crop.Crop$Options$;
import geotrellis.raster.io.geotiff.BandType$;
import geotrellis.raster.io.geotiff.GeoTiff;
import geotrellis.raster.io.geotiff.GeoTiff$;
import geotrellis.raster.io.geotiff.GeoTiffBuilder$;
import geotrellis.raster.io.geotiff.GeoTiffData;
import geotrellis.raster.io.geotiff.GeoTiffImageData;
import geotrellis.raster.io.geotiff.GeoTiffMultibandTile;
import geotrellis.raster.io.geotiff.GeoTiffOptions;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout$;
import geotrellis.raster.io.geotiff.InterleaveMethod;
import geotrellis.raster.io.geotiff.MultibandGeoTiff$;
import geotrellis.raster.io.geotiff.NewSubfileType;
import geotrellis.raster.io.geotiff.OverviewStrategy;
import geotrellis.raster.io.geotiff.PixelInterleave$;
import geotrellis.raster.io.geotiff.ReducedImage$;
import geotrellis.raster.io.geotiff.StorageMethod;
import geotrellis.raster.io.geotiff.Tags;
import geotrellis.raster.io.geotiff.Tags$;
import geotrellis.raster.io.geotiff.TiffType;
import geotrellis.raster.io.geotiff.Tiled;
import geotrellis.raster.io.geotiff.compression.Compression;
import geotrellis.raster.package$;
import geotrellis.raster.render.IndexedColorMap;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.util.ByteReader;
import geotrellis.vector.Extent;
import geotrellis.vector.ProjectedExtent;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Product2;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r\u0005g\u0001B\u0001\u0003\u0001.\u0011\u0001#T;mi&\u0014\u0017M\u001c3HK>$\u0016N\u001a4\u000b\u0005\r!\u0011aB4f_RLgM\u001a\u0006\u0003\u000b\u0019\t!![8\u000b\u0005\u001dA\u0011A\u0002:bgR,'OC\u0001\n\u0003)9Wm\u001c;sK2d\u0017n]\u0002\u0001'\u0015\u0001AB\u0005\u000e\u001e!\ti\u0001#D\u0001\u000f\u0015\u0005y\u0011!B:dC2\f\u0017BA\t\u000f\u0005\u0019\te.\u001f*fMB\u00191\u0003\u0006\f\u000e\u0003\tI!!\u0006\u0002\u0003\u000f\u001d+w\u000eV5gMB\u0011q\u0003G\u0007\u0002\r%\u0011\u0011D\u0002\u0002\u000e\u001bVdG/\u001b2b]\u0012$\u0016\u000e\\3\u0011\u00055Y\u0012B\u0001\u000f\u000f\u0005\u001d\u0001&o\u001c3vGR\u0004\"!\u0004\u0010\n\u0005}q!\u0001D*fe&\fG.\u001b>bE2,\u0007\u0002C\u0011\u0001\u0005+\u0007I\u0011\u0001\u0012\u0002\tQLG.Z\u000b\u0002-!AA\u0005\u0001B\tB\u0003%a#A\u0003uS2,\u0007\u0005\u0003\u0005'\u0001\tU\r\u0011\"\u0001(\u0003\u0019)\u0007\u0010^3oiV\t\u0001\u0006\u0005\u0002*Y5\t!F\u0003\u0002,\u0011\u00051a/Z2u_JL!!\f\u0016\u0003\r\u0015CH/\u001a8u\u0011!y\u0003A!E!\u0002\u0013A\u0013aB3yi\u0016tG\u000f\t\u0005\tc\u0001\u0011)\u001a!C\u0001e\u0005\u00191M]:\u0016\u0003M\u0002\"\u0001N\u001c\u000e\u0003UR!A\u000e\u0005\u0002\u000bA\u0014xN\u001b\u001b\n\u0005a*$aA\"S'\"A!\b\u0001B\tB\u0003%1'\u0001\u0003deN\u0004\u0003\u0002\u0003\u001f\u0001\u0005+\u0007I\u0011A\u001f\u0002\tQ\fwm]\u000b\u0002}A\u00111cP\u0005\u0003\u0001\n\u0011A\u0001V1hg\"A!\t\u0001B\tB\u0003%a(A\u0003uC\u001e\u001c\b\u0005\u0003\u0005E\u0001\tU\r\u0011\"\u0001F\u0003\u001dy\u0007\u000f^5p]N,\u0012A\u0012\t\u0003'\u001dK!\u0001\u0013\u0002\u0003\u001d\u001d+w\u000eV5gM>\u0003H/[8og\"A!\n\u0001B\tB\u0003%a)\u0001\u0005paRLwN\\:!\u0011!a\u0005A!f\u0001\n\u0003i\u0015!C8wKJ4\u0018.Z<t+\u0005q\u0005cA(X%9\u0011\u0001+\u0016\b\u0003#Rk\u0011A\u0015\u0006\u0003'*\ta\u0001\u0010:p_Rt\u0014\"A\b\n\u0005Ys\u0011a\u00029bG.\fw-Z\u0005\u00031f\u0013A\u0001T5ti*\u0011aK\u0004\u0005\t7\u0002\u0011\t\u0012)A\u0005\u001d\u0006QqN^3sm&,wo\u001d\u0011\t\u000bu\u0003A\u0011\u00010\u0002\rqJg.\u001b;?)\u001dy\u0006-\u00192dI\u0016\u0004\"a\u0005\u0001\t\u000b\u0005b\u0006\u0019\u0001\f\t\u000b\u0019b\u0006\u0019\u0001\u0015\t\u000bEb\u0006\u0019A\u001a\t\u000bqb\u0006\u0019\u0001 \t\u000b\u0011c\u0006\u0019\u0001$\t\u000f1c\u0006\u0013!a\u0001\u001d\"9q\r\u0001b\u0001\n\u0003A\u0017\u0001C2fY2$\u0016\u0010]3\u0016\u0003%\u0004\"A\u001b7\u000f\u0005]Y\u0017B\u0001,\u0007\u0013\tigN\u0001\u0005DK2dG+\u001f9f\u0015\t1f\u0001\u0003\u0004q\u0001\u0001\u0006I![\u0001\nG\u0016dG\u000eV=qK\u0002BQA\u001d\u0001\u0005\u0002M\fq!\\1q)&dW\r\u0006\u0002`i\")Q/\u001da\u0001m\u0006\ta\r\u0005\u0003\u000eoZ1\u0012B\u0001=\u000f\u0005%1UO\\2uS>t\u0017\u0007C\u0003{\u0001\u0011\u000510A\txSRD7\u000b^8sC\u001e,W*\u001a;i_\u0012$\"a\u0018?\t\u000buL\b\u0019\u0001@\u0002\u001bM$xN]1hK6+G\u000f[8e!\t\u0019r0C\u0002\u0002\u0002\t\u0011Qb\u0015;pe\u0006<W-T3uQ>$\u0007bBA\u0003\u0001\u0011\u0005\u0011qA\u0001\nS6\fw-\u001a#bi\u0006,\"!!\u0003\u0011\u0007M\tY!C\u0002\u0002\u000e\t\u0011\u0001cR3p)&4g-S7bO\u0016$\u0015\r^1\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014\u0005!1M]8q)\ry\u0016Q\u0003\u0005\b\u0003/\ty\u00011\u0001)\u0003%\u0019XOY#yi\u0016tG\u000fC\u0004\u0002\u0012\u0001!\t!a\u0007\u0015\u000b}\u000bi\"a\b\t\u000f\u0005]\u0011\u0011\u0004a\u0001Q!9A)!\u0007A\u0002\u0005\u0005\u0002\u0003BA\u0012\u0003[qA!!\n\u0002*5\u0011\u0011q\u0005\u0006\u0004\u0003#1\u0011\u0002BA\u0016\u0003O\tAa\u0011:pa&!\u0011qFA\u0019\u0005\u001dy\u0005\u000f^5p]NTA!a\u000b\u0002(!9\u0011\u0011\u0003\u0001\u0005\u0002\u0005UB#B0\u00028\u0005\u0005\u0003\u0002CA\u001d\u0003g\u0001\r!a\u000f\u0002\r\r|G.T1y!\ri\u0011QH\u0005\u0004\u0003\u007fq!aA%oi\"A\u00111IA\u001a\u0001\u0004\tY$\u0001\u0004s_^l\u0015\r\u001f\u0005\b\u0003#\u0001A\u0011AA$)%y\u0016\u0011JA'\u0003#\n\u0019\u0006\u0003\u0005\u0002L\u0005\u0015\u0003\u0019AA\u001e\u0003\u0019\u0019w\u000e\\'j]\"A\u0011qJA#\u0001\u0004\tY$\u0001\u0004s_^l\u0015N\u001c\u0005\t\u0003s\t)\u00051\u0001\u0002<!A\u00111IA#\u0001\u0004\tY\u0004C\u0004\u0002\u0012\u0001!\t!a\u0016\u0015\u0007}\u000bI\u0006\u0003\u0005\u0002\\\u0005U\u0003\u0019AA/\u0003)9'/\u001b3C_VtGm\u001d\t\u0004/\u0005}\u0013bAA1\r\tQqI]5e\u0005>,h\u000eZ:\t\u000f\u0005E\u0001\u0001\"\u0001\u0002fQQ\u0011qMA<\u0003s\n\u0019)a%\u0011\t\u0005%\u00141\u000f\b\u0004\u0003WZg\u0002BA7\u0003cr1!UA8\u0013\u0005I\u0011BA\u0004\t\u0013\r\t)H\u001c\u0002\u0010\u001bVdG/\u001b2b]\u0012\u0014\u0016m\u001d;fe\"9\u0011qCA2\u0001\u0004A\u0003\u0002CA>\u0003G\u0002\r!! \u0002\u0011\r,G\u000e\\*ju\u0016\u00042aFA@\u0013\r\t\tI\u0002\u0002\t\u0007\u0016dGnU5{K\"A\u0011QQA2\u0001\u0004\t9)\u0001\bsKN\fW\u000e\u001d7f\u001b\u0016$\bn\u001c3\u0011\t\u0005%\u0015qR\u0007\u0003\u0003\u0017S1!!$\u0007\u0003!\u0011Xm]1na2,\u0017\u0002BAI\u0003\u0017\u0013aBU3tC6\u0004H.Z'fi\"|G\r\u0003\u0005\u0002\u0016\u0006\r\u0004\u0019AAL\u0003!\u0019HO]1uK\u001eL\bcA\n\u0002\u001a&\u0019\u00111\u0014\u0002\u0003!=3XM\u001d<jK^\u001cFO]1uK\u001eL\bbBA\t\u0001\u0011\u0005\u0011q\u0014\u000b\u0005\u0003C\u000bi\u000bE\u0003P\u0003G\u000b9+C\u0002\u0002&f\u0013\u0001\"\u0013;fe\u0006$xN\u001d\t\u0007\u001b\u0005%\u0016Q\f\f\n\u0007\u0005-fB\u0001\u0004UkBdWM\r\u0005\t\u0003_\u000bi\n1\u0001\u00022\u00069q/\u001b8e_^\u001c\b#B(\u00024\u0006u\u0013bAA[3\n\u00191+Z9\t\u000f\u00055\u0005\u0001\"\u0001\u0002:RA\u0011qMA^\u0003\u000b\f9\r\u0003\u0005\u0002>\u0006]\u0006\u0019AA`\u00031\u0011\u0018m\u001d;fe\u0016CH/\u001a8u!\r9\u0012\u0011Y\u0005\u0004\u0003\u00074!\u0001\u0004*bgR,'/\u0012=uK:$\b\u0002CAC\u0003o\u0003\r!a\"\t\u0011\u0005U\u0015q\u0017a\u0001\u0003/Cq!a3\u0001\t\u0003\ti-A\u0007ck&dGm\u0014<feZLWm\u001e\u000b\b?\u0006=\u0017\u0011[Ak\u0011!\t))!3A\u0002\u0005\u001d\u0005\u0002CAj\u0003\u0013\u0004\r!a\u000f\u0002!\u0011,7-[7bi&|gNR1di>\u0014\bBCAl\u0003\u0013\u0004\n\u00111\u0001\u0002<\u0005I!\r\\8dWNK'0\u001a\u0005\b\u00037\u0004A\u0011AAo\u000359\u0018\u000e\u001e5Pm\u0016\u0014h/[3xgR9q,a8\u0002b\u0006\u001d\b\u0002CAC\u00033\u0004\r!a\"\t\u0015\u0005\r\u0018\u0011\u001cI\u0001\u0002\u0004\t)/A\u0006eK\u000eLW.\u0019;j_:\u001c\b\u0003B(X\u0003wA!\"a6\u0002ZB\u0005\t\u0019AA\u001e\u0011\u001d\tY\u000f\u0001C\u0001\u0003[\fAaY8qsRiq,a<\u0002r\u0006M\u0018Q_A|\u0003sD\u0001\"IAu!\u0003\u0005\rA\u0006\u0005\tM\u0005%\b\u0013!a\u0001Q!A\u0011'!;\u0011\u0002\u0003\u00071\u0007\u0003\u0005=\u0003S\u0004\n\u00111\u0001?\u0011!!\u0015\u0011\u001eI\u0001\u0002\u00041\u0005\u0002\u0003'\u0002jB\u0005\t\u0019\u0001(\t\u0013\u0005u\b!%A\u0005B\u0005}\u0018aF<ji\"|e/\u001a:wS\u0016<8\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011\tA\u000b\u0003\u0002f\n\r1F\u0001B\u0003!\u0011\u00119A!\u0005\u000e\u0005\t%!\u0002\u0002B\u0006\u0005\u001b\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t=a\"\u0001\u0006b]:|G/\u0019;j_:LAAa\u0005\u0003\n\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\t]\u0001!%A\u0005B\te\u0011aF<ji\"|e/\u001a:wS\u0016<8\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011YB\u000b\u0003\u0002<\t\r\u0001\"\u0003B\u0010\u0001E\u0005I\u0011\tB\u0011\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa\t+\u0007Y\u0011\u0019\u0001C\u0005\u0003(\u0001\t\n\u0011\"\u0011\u0003*\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001B\u0016U\rA#1\u0001\u0005\n\u0005_\u0001\u0011\u0013!C!\u0005c\tabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u00034)\u001a1Ga\u0001\t\u0013\t]\u0002!%A\u0005B\te\u0012AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005wQ3A\u0010B\u0002\u0011%\u0011y\u0004AI\u0001\n\u0003\u0012\t%\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t\r#f\u0001$\u0003\u0004!I!q\t\u0001\u0012\u0002\u0013\u0005#\u0011J\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011YEK\u0002O\u0005\u0007A\u0011Ba\u0014\u0001\u0003\u0003%\tE!\u0015\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011\u0019\u0006\u0005\u0003\u0003V\t}SB\u0001B,\u0015\u0011\u0011IFa\u0017\u0002\t1\fgn\u001a\u0006\u0003\u0005;\nAA[1wC&!!\u0011\rB,\u0005\u0019\u0019FO]5oO\"I!Q\r\u0001\u0002\u0002\u0013\u0005!qM\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003wA\u0011Ba\u001b\u0001\u0003\u0003%\tA!\u001c\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!q\u000eB;!\ri!\u0011O\u0005\u0004\u0005gr!aA!os\"Q!q\u000fB5\u0003\u0003\u0005\r!a\u000f\u0002\u0007a$\u0013\u0007C\u0005\u0003|\u0001\t\t\u0011\"\u0011\u0003~\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\u0000A1!\u0011\u0011BD\u0005_j!Aa!\u000b\u0007\t\u0015e\"\u0001\u0006d_2dWm\u0019;j_:LA!!*\u0003\u0004\"I!1\u0012\u0001\u0002\u0002\u0013\u0005!QR\u0001\tG\u0006tW)];bYR!!q\u0012BK!\ri!\u0011S\u0005\u0004\u0005's!a\u0002\"p_2,\u0017M\u001c\u0005\u000b\u0005o\u0012I)!AA\u0002\t=\u0004\"\u0003BM\u0001\u0005\u0005I\u0011\tBN\u0003!A\u0017m\u001d5D_\u0012,GCAA\u001e\u0011%\u0011y\nAA\u0001\n\u0003\u0012\t+\u0001\u0005u_N#(/\u001b8h)\t\u0011\u0019\u0006C\u0005\u0003&\u0002\t\t\u0011\"\u0011\u0003(\u00061Q-];bYN$BAa$\u0003*\"Q!q\u000fBR\u0003\u0003\u0005\rAa\u001c\b\u000f\t5&\u0001#\u0001\u00030\u0006\u0001R*\u001e7uS\n\fg\u000eZ$f_RKgM\u001a\t\u0004'\tEfAB\u0001\u0003\u0011\u0003\u0011\u0019l\u0005\u0003\u000322i\u0002bB/\u00032\u0012\u0005!q\u0017\u000b\u0003\u0005_C\u0001Ba/\u00032\u0012\u0005!QX\u0001\u0006CB\u0004H.\u001f\u000b\u0004?\n}\u0006\u0002\u0003Ba\u0005s\u0003\rAa1\u0002\u000b\tLH/Z:\u0011\u000b5\u0011)M!3\n\u0007\t\u001dgBA\u0003BeJ\f\u0017\u0010E\u0002\u000e\u0005\u0017L1A!4\u000f\u0005\u0011\u0011\u0015\u0010^3\t\u0011\tm&\u0011\u0017C\u0001\u0005#$Ra\u0018Bj\u0005+D\u0001B!1\u0003P\u0002\u0007!1\u0019\u0005\t\u0005/\u0014y\r1\u0001\u0003\u0010\u0006I1\u000f\u001e:fC6Lgn\u001a\u0005\t\u0005w\u0013\t\f\"\u0001\u0003\\R\u0019qL!8\t\u0011\t}'\u0011\u001ca\u0001\u0005C\fA\u0001]1uQB!!1\u001dBv\u001d\u0011\u0011)Oa:\u0011\u0005Es\u0011b\u0001Bu\u001d\u00051\u0001K]3eK\u001aLAA!\u0019\u0003n*\u0019!\u0011\u001e\b\t\u0011\tm&\u0011\u0017C\u0001\u0005c$Ra\u0018Bz\u0005kD\u0001Ba8\u0003p\u0002\u0007!\u0011\u001d\u0005\b\u0005o\u0014y\u000f1\u0001)\u0003\u0005)\u0007\u0002\u0003B^\u0005c#\tAa?\u0015\u000b}\u0013iPa@\t\u0011\t}'\u0011 a\u0001\u0005CD\u0001Ba>\u0003z\u0002\u00071\u0011\u0001\t\u0005\u001b\r\r\u0001&C\u0002\u0004\u00069\u0011aa\u00149uS>t\u0007\u0002\u0003B^\u0005c#\ta!\u0003\u0015\u000b}\u001bYa!\u0004\t\u0011\t}7q\u0001a\u0001\u0005CD\u0001Ba6\u0004\b\u0001\u0007!q\u0012\u0005\t\u0005w\u0013\t\f\"\u0001\u0004\u0012Q\u0019qla\u0005\t\u0011\rU1q\u0002a\u0001\u0007/\t!BY=uKJ+\u0017\rZ3s!\u0011\u0019Iba\b\u000e\u0005\rm!bAB\u000f\u0011\u0005!Q\u000f^5m\u0013\u0011\u0019\tca\u0007\u0003\u0015\tKH/\u001a*fC\u0012,'\u000f\u0003\u0005\u0003<\nEF\u0011AB\u0013)\u0015y6qEB\u0015\u0011!\u0019)ba\tA\u0002\r]\u0001b\u0002B|\u0007G\u0001\r\u0001\u000b\u0005\t\u0005w\u0013\t\f\"\u0001\u0004.Q)qla\f\u00042!A1QCB\u0016\u0001\u0004\u00199\u0002\u0003\u0005\u0003x\u000e-\u0002\u0019AB\u0001\u0011!\u0011YL!-\u0005\u0002\rUB#B0\u00048\re\u0002\u0002CB\u000b\u0007g\u0001\raa\u0006\t\u0011\t]71\u0007a\u0001\u0005\u001fC\u0001Ba6\u00032\u0012\u00051Q\b\u000b\u0004?\u000e}\u0002\u0002\u0003Bp\u0007w\u0001\rA!9\t\u0011\t]'\u0011\u0017C\u0001\u0007\u0007\"2aXB#\u0011!\u0019)b!\u0011A\u0002\r]\u0001\u0002\u0003B^\u0005c#\ta!\u0013\u0015\u000f}\u001bYe!\u0014\u0004P!1\u0011ea\u0012A\u0002YAaAJB$\u0001\u0004A\u0003BB\u0019\u0004H\u0001\u00071\u0007\u0003\u0005\u0003<\nEF\u0011AB*)%y6QKB,\u00073\u001aY\u0006\u0003\u0004\"\u0007#\u0002\rA\u0006\u0005\u0007M\rE\u0003\u0019\u0001\u0015\t\rE\u001a\t\u00061\u00014\u0011\u0019a4\u0011\u000ba\u0001}!A!1\u0018BY\t\u0003\u0019y\u0006F\u0005`\u0007C\u001a\u0019g!\u001a\u0004h!1\u0011e!\u0018A\u0002YAaAJB/\u0001\u0004A\u0003BB\u0019\u0004^\u0001\u00071\u0007\u0003\u0004E\u0007;\u0002\rA\u0012\u0005\t\u0005w\u0013\t\f\"\u0001\u0004lQ)ql!\u001c\u0004v!9qa!\u001bA\u0002\r=\u0004\u0003B\f\u0004rYI1aa\u001d\u0007\u0005\u0019\u0011\u0016m\u001d;fe\"1\u0011g!\u001bA\u0002MB\u0001Ba/\u00032\u0012\u00051\u0011\u0010\u000b\b?\u000em4QPB@\u0011\u001d91q\u000fa\u0001\u0007_Ba!MB<\u0001\u0004\u0019\u0004B\u0002\u001f\u0004x\u0001\u0007a\b\u0003\u0005\u0003<\nEF\u0011ABB)\u001dy6QQBD\u0007\u0013CqaBBA\u0001\u0004\u0019y\u0007\u0003\u00042\u0007\u0003\u0003\ra\r\u0005\u0007\t\u000e\u0005\u0005\u0019\u0001$\t\u0015\tm&\u0011WA\u0001\n\u0003\u001bi\tF\u0007`\u0007\u001f\u001b\tja%\u0004\u0016\u000e]5\u0011\u0014\u0005\u0007C\r-\u0005\u0019\u0001\f\t\r\u0019\u001aY\t1\u0001)\u0011\u0019\t41\u0012a\u0001g!1Aha#A\u0002yBa\u0001RBF\u0001\u00041\u0005\u0002\u0003'\u0004\fB\u0005\t\u0019\u0001(\t\u0015\ru%\u0011WA\u0001\n\u0003\u001by*A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\r\u00056\u0011\u0016\t\u0006\u001b\r\r11\u0015\t\n\u001b\r\u0015f\u0003K\u001a?\r:K1aa*\u000f\u0005\u0019!V\u000f\u001d7fm!I11VBN\u0003\u0003\u0005\raX\u0001\u0004q\u0012\u0002\u0004BCBX\u0005c\u000b\n\u0011\"\u0001\u0003J\u0005y\u0011\r\u001d9ms\u0012\"WMZ1vYR$c\u0007\u0003\u0006\u00044\nE\u0016\u0013!C\u0001\u0005\u0013\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u00122\u0004BCB\\\u0005c\u000b\t\u0011\"\u0003\u0004:\u0006Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0019Y\f\u0005\u0003\u0003V\ru\u0016\u0002BB`\u0005/\u0012aa\u00142kK\u000e$\b")
public class MultibandGeoTiff
implements GeoTiff<MultibandTile>,
Product,
scala.Serializable {
    private final MultibandTile tile;
    private final Extent extent;
    private final CRS crs;
    private final Tags tags;
    private final GeoTiffOptions options;
    private final List<GeoTiff<MultibandTile>> overviews;
    private final DataType cellType;

    public static List<GeoTiff<MultibandTile>> $lessinit$greater$default$6() {
        return MultibandGeoTiff$.MODULE$.$lessinit$greater$default$6();
    }

    public static List<GeoTiff<MultibandTile>> apply$default$6() {
        return MultibandGeoTiff$.MODULE$.apply$default$6();
    }

    public static Option<Tuple6<MultibandTile, Extent, CRS, Tags, GeoTiffOptions, List<GeoTiff<MultibandTile>>>> unapply(MultibandGeoTiff multibandGeoTiff) {
        return MultibandGeoTiff$.MODULE$.unapply(multibandGeoTiff);
    }

    public static MultibandGeoTiff apply(MultibandTile multibandTile, Extent extent, CRS cRS, Tags tags, GeoTiffOptions geoTiffOptions, List<GeoTiff<MultibandTile>> list) {
        return MultibandGeoTiff$.MODULE$.apply(multibandTile, extent, cRS, tags, geoTiffOptions, list);
    }

    public static MultibandGeoTiff apply(Raster<MultibandTile> raster, CRS cRS, GeoTiffOptions geoTiffOptions) {
        return MultibandGeoTiff$.MODULE$.apply(raster, cRS, geoTiffOptions);
    }

    public static MultibandGeoTiff apply(Raster<MultibandTile> raster, CRS cRS, Tags tags) {
        return MultibandGeoTiff$.MODULE$.apply(raster, cRS, tags);
    }

    public static MultibandGeoTiff apply(Raster<MultibandTile> raster, CRS cRS) {
        return MultibandGeoTiff$.MODULE$.apply(raster, cRS);
    }

    public static MultibandGeoTiff apply(MultibandTile multibandTile, Extent extent, CRS cRS, GeoTiffOptions geoTiffOptions) {
        return MultibandGeoTiff$.MODULE$.apply(multibandTile, extent, cRS, geoTiffOptions);
    }

    public static MultibandGeoTiff apply(MultibandTile multibandTile, Extent extent, CRS cRS, Tags tags) {
        return MultibandGeoTiff$.MODULE$.apply(multibandTile, extent, cRS, tags);
    }

    public static MultibandGeoTiff apply(MultibandTile multibandTile, Extent extent, CRS cRS) {
        return MultibandGeoTiff$.MODULE$.apply(multibandTile, extent, cRS);
    }

    public static MultibandGeoTiff streaming(ByteReader byteReader) {
        return MultibandGeoTiff$.MODULE$.streaming(byteReader);
    }

    public static MultibandGeoTiff streaming(String string) {
        return MultibandGeoTiff$.MODULE$.streaming(string);
    }

    public static MultibandGeoTiff apply(ByteReader byteReader, boolean bl) {
        return MultibandGeoTiff$.MODULE$.apply(byteReader, bl);
    }

    public static MultibandGeoTiff apply(ByteReader byteReader, Option<Extent> option) {
        return MultibandGeoTiff$.MODULE$.apply(byteReader, option);
    }

    public static MultibandGeoTiff apply(ByteReader byteReader, Extent extent) {
        return MultibandGeoTiff$.MODULE$.apply(byteReader, extent);
    }

    public static MultibandGeoTiff apply(ByteReader byteReader) {
        return MultibandGeoTiff$.MODULE$.apply(byteReader);
    }

    public static MultibandGeoTiff apply(String string, boolean bl) {
        return MultibandGeoTiff$.MODULE$.apply(string, bl);
    }

    public static MultibandGeoTiff apply(String string, Option<Extent> option) {
        return MultibandGeoTiff$.MODULE$.apply(string, option);
    }

    public static MultibandGeoTiff apply(String string, Extent extent) {
        return MultibandGeoTiff$.MODULE$.apply(string, extent);
    }

    public static MultibandGeoTiff apply(String string) {
        return MultibandGeoTiff$.MODULE$.apply(string);
    }

    public static MultibandGeoTiff apply(byte[] byArray, boolean bl) {
        return MultibandGeoTiff$.MODULE$.apply(byArray, bl);
    }

    public static MultibandGeoTiff apply(byte[] byArray) {
        return MultibandGeoTiff$.MODULE$.apply(byArray);
    }

    @Override
    public int cols() {
        return GeoTiff.cols$(this);
    }

    @Override
    public int rows() {
        return GeoTiff.rows$(this);
    }

    @Override
    public ProjectedExtent projectedExtent() {
        return GeoTiff.projectedExtent$(this);
    }

    @Override
    public ProjectedRaster<MultibandTile> projectedRaster() {
        return GeoTiff.projectedRaster$(this);
    }

    @Override
    public Raster<MultibandTile> raster() {
        return GeoTiff.raster$(this);
    }

    @Override
    public RasterExtent rasterExtent() {
        return GeoTiff.rasterExtent$(this);
    }

    @Override
    public CellSize cellSize() {
        return GeoTiff.cellSize$(this);
    }

    @Override
    public int bandCount() {
        return GeoTiff.bandCount$(this);
    }

    @Override
    public void write(String path, boolean optimizedOrder) {
        GeoTiff.write$(this, path, optimizedOrder);
    }

    @Override
    public byte[] toByteArray() {
        return GeoTiff.toByteArray$(this);
    }

    @Override
    public byte[] toCloudOptimizedByteArray() {
        return GeoTiff.toCloudOptimizedByteArray$(this);
    }

    @Override
    public int getOverviewsCount() {
        return GeoTiff.getOverviewsCount$(this);
    }

    @Override
    public GeoTiff<MultibandTile> getOverview(int idx) {
        return GeoTiff.getOverview$(this, idx);
    }

    @Override
    public GeoTiff<MultibandTile> withOverviews(Seq<GeoTiff<MultibandTile>> overviews) {
        return GeoTiff.withOverviews$(this, overviews);
    }

    @Override
    public Raster<MultibandTile> crop(Extent subExtent, CellSize cellSize) {
        return GeoTiff.crop$(this, subExtent, cellSize);
    }

    @Override
    public Raster<MultibandTile> crop(RasterExtent rasterExtent) {
        return GeoTiff.crop$(this, rasterExtent);
    }

    @Override
    public GeoTiff<MultibandTile> getClosestOverview(CellSize cellSize, OverviewStrategy strategy) {
        return GeoTiff.getClosestOverview$(this, cellSize, strategy);
    }

    @Override
    public boolean write$default$2() {
        return GeoTiff.write$default$2$(this);
    }

    @Override
    public int buildOverview$default$3() {
        return GeoTiff.buildOverview$default$3$(this);
    }

    @Override
    public OverviewStrategy getClosestOverview$default$2() {
        return GeoTiff.getClosestOverview$default$2$(this);
    }

    @Override
    public Option<PixelSampleType> pixelSampleType() {
        return GeoTiffData.pixelSampleType$(this);
    }

    @Override
    public MultibandTile tile() {
        return this.tile;
    }

    @Override
    public Extent extent() {
        return this.extent;
    }

    @Override
    public CRS crs() {
        return this.crs;
    }

    @Override
    public Tags tags() {
        return this.tags;
    }

    @Override
    public GeoTiffOptions options() {
        return this.options;
    }

    @Override
    public List<GeoTiff<MultibandTile>> overviews() {
        return this.overviews;
    }

    @Override
    public DataType cellType() {
        return this.cellType;
    }

    public MultibandGeoTiff mapTile(Function1<MultibandTile, MultibandTile> f) {
        return new MultibandGeoTiff((MultibandTile)f.apply((Object)this.tile()), this.extent(), this.crs(), this.tags(), this.options(), this.overviews());
    }

    public MultibandGeoTiff withStorageMethod(StorageMethod storageMethod) {
        return new MultibandGeoTiff(this.tile().toArrayTile(), this.extent(), this.crs(), this.tags(), this.options().copy(storageMethod, this.options().copy$default$2(), this.options().copy$default$3(), this.options().copy$default$4(), this.options().copy$default$5(), this.options().copy$default$6(), this.options().copy$default$7()), (List<GeoTiff<MultibandTile>>)((List)this.overviews().map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.withStorageMethod(storageMethod), List$.MODULE$.canBuildFrom())));
    }

    @Override
    public GeoTiffImageData imageData() {
        GeoTiffMultibandTile geoTiffMultibandTile;
        MultibandTile multibandTile = this.tile();
        GeoTiffMultibandTile geoTiffMultibandTile2 = multibandTile instanceof GeoTiffMultibandTile ? (geoTiffMultibandTile = (GeoTiffMultibandTile)multibandTile) : geotrellis.raster.io.geotiff.package$.MODULE$.GeoTiffMultibandTileMethods(this.tile()).toGeoTiffTile(this.options());
        return geoTiffMultibandTile2;
    }

    public MultibandGeoTiff crop(Extent subExtent) {
        return this.crop(subExtent, Crop$Options$.MODULE$.DEFAULT());
    }

    public MultibandGeoTiff crop(Extent subExtent, Crop.Options options) {
        Option option = this.extent().intersection(subExtent);
        if (!(option instanceof Some)) {
            throw new GeoAttrsError(new StringBuilder(60).append("Extent to crop by (").append(subExtent).append(") should intersect the imagery extent (").append(this.extent()).append(").").toString());
        }
        Some some = (Some)option;
        Extent ext = (Extent)some.value();
        Raster raster = package$.MODULE$.withExtentCropMethods(this.raster(), (Function1 & Serializable & scala.Serializable)self -> package$.MODULE$.withMultibandTileMethods((MultibandTile)self)).crop(ext, options);
        MultibandGeoTiff multibandGeoTiff = new MultibandGeoTiff((MultibandTile)raster.tile(), raster.extent(), this.crs(), this.tags(), this.options(), this.overviews());
        return multibandGeoTiff;
    }

    public MultibandGeoTiff crop(int colMax, int rowMax) {
        return this.crop(0, 0, colMax, rowMax);
    }

    public MultibandGeoTiff crop(int colMin, int rowMin, int colMax, int rowMax) {
        Raster raster = (Raster)package$.MODULE$.withExtentCropMethods(this.raster(), (Function1 & Serializable & scala.Serializable)self -> package$.MODULE$.withMultibandTileMethods((MultibandTile)self)).crop(colMin, rowMin, colMax, rowMax);
        return new MultibandGeoTiff((MultibandTile)raster.tile(), raster.extent(), this.crs(), this.tags(), this.options(), this.overviews());
    }

    public MultibandGeoTiff crop(GridBounds gridBounds) {
        return this.crop(gridBounds.colMin(), gridBounds.rowMin(), gridBounds.colMax(), gridBounds.rowMax());
    }

    @Override
    public Raster<MultibandTile> crop(Extent subExtent, CellSize cellSize, ResampleMethod resampleMethod, OverviewStrategy strategy) {
        return this.getClosestOverview(cellSize, strategy).crop(subExtent, new Crop.Options(false, Crop$Options$.MODULE$.apply$default$2())).resample(RasterExtent$.MODULE$.apply(subExtent, cellSize), resampleMethod, strategy);
    }

    @Override
    public Iterator<Tuple2<GridBounds, MultibandTile>> crop(Seq<GridBounds> windows) {
        Object object;
        MultibandTile multibandTile = this.tile();
        if (multibandTile instanceof GeoTiffMultibandTile) {
            GeoTiffMultibandTile geoTiffMultibandTile = (GeoTiffMultibandTile)multibandTile;
            object = geoTiffMultibandTile.crop(windows);
        } else if (multibandTile != null) {
            MultibandTile multibandTile2 = multibandTile;
            object = package$.MODULE$.withMultibandTileMethods(multibandTile2).crop(windows);
        } else {
            throw new MatchError((Object)multibandTile);
        }
        return object;
    }

    @Override
    public Raster<MultibandTile> resample(RasterExtent rasterExtent, ResampleMethod resampleMethod, OverviewStrategy strategy) {
        return package$.MODULE$.withMultibandRasterMethods(this.getClosestOverview(this.cellSize(), strategy).raster()).resample(rasterExtent, resampleMethod);
    }

    public MultibandGeoTiff buildOverview(ResampleMethod resampleMethod, int decimationFactor, int blockSize) {
        MultibandTile multibandTile;
        RasterExtent overviewRasterExtent = RasterExtent$.MODULE$.apply(this.extent(), (int)scala.math.package$.MODULE$.ceil((double)this.tile().cols() / (double)decimationFactor), (int)scala.math.package$.MODULE$.ceil((double)this.tile().rows() / (double)decimationFactor));
        GeoTiffSegmentLayout segmentLayout = GeoTiffSegmentLayout$.MODULE$.apply(overviewRasterExtent.cols(), overviewRasterExtent.rows(), new Tiled(blockSize, blockSize), PixelInterleave$.MODULE$, BandType$.MODULE$.forCellType(this.tile().cellType()));
        MultibandTile multibandTile2 = this.tile();
        if (multibandTile2 instanceof GeoTiffMultibandTile) {
            GeoTiffMultibandTile geoTiffMultibandTile = (GeoTiffMultibandTile)multibandTile2;
            multibandTile = geoTiffMultibandTile.toArrayTile();
        } else {
            multibandTile = MultibandTile$.MODULE$.apply((Traversable<Tile>)((Traversable)this.tile().bands().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.toArrayTile(), Vector$.MODULE$.canBuildFrom())));
        }
        ArrayMultibandTile arrayTile = multibandTile;
        Seq segments = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.withMultibandTileMethods(package$.MODULE$.withMultibandRasterMethods(new Raster<MultibandTile>(arrayTile, this.extent())).resample(overviewRasterExtent, resampleMethod).tile()).split(segmentLayout.tileLayout()))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            MultibandTile tile = (MultibandTile)tuple2._1();
            int index = tuple2._2$mcI$sp();
            int col = index % segmentLayout.tileLayout().layoutCols();
            int row = index / segmentLayout.tileLayout().layoutCols();
            Tuple2 tuple22 = new Tuple2((Object)new Tuple2.mcII.sp(col, row), (Object)tile);
            return tuple22;
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        Tiled storageMethod = new Tiled(blockSize, blockSize);
        Some x$4 = new Some((Object)ReducedImage$.MODULE$);
        Tiled x$5 = storageMethod;
        Compression x$6 = this.options().copy$default$2();
        int x$7 = this.options().copy$default$3();
        Option<IndexedColorMap> x$8 = this.options().copy$default$4();
        InterleaveMethod x$9 = this.options().copy$default$5();
        TiffType x$10 = this.options().copy$default$7();
        GeoTiffOptions overviewOptions = this.options().copy(x$5, x$6, x$7, x$8, x$9, (Option<NewSubfileType>)x$4, x$10);
        MultibandTile overviewTile = GeoTiffBuilder$.MODULE$.apply(GeoTiffBuilder$.MODULE$.multibandGeoTiffBuilder()).makeTile((Iterator<Tuple2<Product2<Object, Object>, MultibandTile>>)segments.toIterator(), segmentLayout, this.cellType(), this.options().compression());
        return new MultibandGeoTiff(overviewTile, this.extent(), this.crs(), Tags$.MODULE$.empty(), overviewOptions, MultibandGeoTiff$.MODULE$.apply$default$6());
    }

    public MultibandGeoTiff withOverviews(ResampleMethod resampleMethod, List<Object> decimations, int blockSize) {
        MultibandGeoTiff multibandGeoTiff;
        List<Object> overviewDecimations;
        List<Object> list = overviewDecimations = decimations.isEmpty() ? GeoTiff$.MODULE$.defaultOverviewDecimations(this.tile().cols(), this.tile().rows(), blockSize) : decimations;
        if (overviewDecimations.isEmpty()) {
            multibandGeoTiff = this;
        } else {
            MultibandTile multibandTile;
            MultibandTile multibandTile2 = this.tile();
            if (multibandTile2 instanceof GeoTiffMultibandTile) {
                GeoTiffMultibandTile geoTiffMultibandTile = (GeoTiffMultibandTile)multibandTile2;
                multibandTile = geoTiffMultibandTile.toArrayTile();
            } else {
                multibandTile = MultibandTile$.MODULE$.apply((Traversable<Tile>)((Traversable)this.tile().bands().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.toArrayTile(), Vector$.MODULE$.canBuildFrom())));
            }
            ArrayMultibandTile arrayTile = multibandTile;
            MultibandGeoTiff staged = new MultibandGeoTiff(arrayTile, this.extent(), this.crs(), this.tags(), this.options(), (List<GeoTiff<MultibandTile>>)Nil$.MODULE$);
            List overviews = (List)overviewDecimations.map((Function1 & Serializable & scala.Serializable)decimationFactor -> staged.buildOverview(resampleMethod, BoxesRunTime.unboxToInt((Object)decimationFactor), blockSize), List$.MODULE$.canBuildFrom());
            multibandGeoTiff = new MultibandGeoTiff(this.tile(), this.extent(), this.crs(), this.tags(), this.options(), (List<GeoTiff<MultibandTile>>)overviews);
        }
        return multibandGeoTiff;
    }

    @Override
    public List<Object> withOverviews$default$2() {
        return Nil$.MODULE$;
    }

    @Override
    public int withOverviews$default$3() {
        return GeoTiff$.MODULE$.DefaultBlockSize();
    }

    public MultibandGeoTiff copy(MultibandTile tile, Extent extent, CRS crs, Tags tags, GeoTiffOptions options, List<GeoTiff<MultibandTile>> overviews) {
        return new MultibandGeoTiff(tile, extent, crs, tags, options, overviews);
    }

    @Override
    public MultibandTile copy$default$1() {
        return this.tile();
    }

    @Override
    public Extent copy$default$2() {
        return this.extent();
    }

    @Override
    public CRS copy$default$3() {
        return this.crs();
    }

    @Override
    public Tags copy$default$4() {
        return this.tags();
    }

    @Override
    public GeoTiffOptions copy$default$5() {
        return this.options();
    }

    @Override
    public List<GeoTiff<MultibandTile>> copy$default$6() {
        return this.overviews();
    }

    public String productPrefix() {
        return "MultibandGeoTiff";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        scala.Serializable serializable;
        int n = x$1;
        switch (n) {
            case 0: {
                serializable = this.tile();
                break;
            }
            case 1: {
                serializable = this.extent();
                break;
            }
            case 2: {
                serializable = this.crs();
                break;
            }
            case 3: {
                serializable = this.tags();
                break;
            }
            case 4: {
                serializable = this.options();
                break;
            }
            case 5: {
                serializable = this.overviews();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return serializable;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof MultibandGeoTiff;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof MultibandGeoTiff)) return false;
        boolean bl = true;
        if (!bl) return false;
        MultibandGeoTiff multibandGeoTiff = (MultibandGeoTiff)x$1;
        MultibandTile multibandTile = this.tile();
        MultibandTile multibandTile2 = multibandGeoTiff.tile();
        if (multibandTile == null) {
            if (multibandTile2 != null) {
                return false;
            }
        } else if (!multibandTile.equals(multibandTile2)) return false;
        Extent extent = this.extent();
        Extent extent2 = multibandGeoTiff.extent();
        if (extent == null) {
            if (extent2 != null) {
                return false;
            }
        } else if (!extent.equals(extent2)) return false;
        CRS cRS = this.crs();
        CRS cRS2 = multibandGeoTiff.crs();
        if (cRS == null) {
            if (cRS2 != null) {
                return false;
            }
        } else if (!cRS.equals(cRS2)) return false;
        Tags tags = this.tags();
        Tags tags2 = multibandGeoTiff.tags();
        if (tags == null) {
            if (tags2 != null) {
                return false;
            }
        } else if (!((Object)tags).equals(tags2)) return false;
        GeoTiffOptions geoTiffOptions = this.options();
        GeoTiffOptions geoTiffOptions2 = multibandGeoTiff.options();
        if (geoTiffOptions == null) {
            if (geoTiffOptions2 != null) {
                return false;
            }
        } else if (!((Object)geoTiffOptions).equals(geoTiffOptions2)) return false;
        List<GeoTiff<MultibandTile>> list = this.overviews();
        List<GeoTiff<MultibandTile>> list2 = multibandGeoTiff.overviews();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        if (!multibandGeoTiff.canEqual(this)) return false;
        return true;
    }

    public MultibandGeoTiff(MultibandTile tile, Extent extent, CRS crs, Tags tags, GeoTiffOptions options, List<GeoTiff<MultibandTile>> overviews) {
        this.tile = tile;
        this.extent = extent;
        this.crs = crs;
        this.tags = tags;
        this.options = options;
        this.overviews = overviews;
        GeoTiffData.$init$(this);
        GeoTiff.$init$(this);
        Product.$init$((Product)this);
        this.cellType = tile.cellType();
    }
}

