/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff;

import geotrellis.proj4.CRS;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.CellSize;
import geotrellis.raster.DataType;
import geotrellis.raster.GeoAttrsError;
import geotrellis.raster.GridBounds;
import geotrellis.raster.PixelSampleType;
import geotrellis.raster.ProjectedRaster;
import geotrellis.raster.Raster;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.Tile;
import geotrellis.raster.crop.Crop;
import geotrellis.raster.crop.Crop$Options$;
import geotrellis.raster.io.geotiff.BandType$;
import geotrellis.raster.io.geotiff.GeoTiff;
import geotrellis.raster.io.geotiff.GeoTiff$;
import geotrellis.raster.io.geotiff.GeoTiffBuilder$;
import geotrellis.raster.io.geotiff.GeoTiffData;
import geotrellis.raster.io.geotiff.GeoTiffImageData;
import geotrellis.raster.io.geotiff.GeoTiffOptions;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayout$;
import geotrellis.raster.io.geotiff.GeoTiffTile;
import geotrellis.raster.io.geotiff.InterleaveMethod;
import geotrellis.raster.io.geotiff.NewSubfileType;
import geotrellis.raster.io.geotiff.OverviewStrategy;
import geotrellis.raster.io.geotiff.PixelInterleave$;
import geotrellis.raster.io.geotiff.ReducedImage$;
import geotrellis.raster.io.geotiff.SinglebandGeoTiff$;
import geotrellis.raster.io.geotiff.StorageMethod;
import geotrellis.raster.io.geotiff.Tags;
import geotrellis.raster.io.geotiff.Tags$;
import geotrellis.raster.io.geotiff.TiffType;
import geotrellis.raster.io.geotiff.Tiled;
import geotrellis.raster.io.geotiff.compression.Compression;
import geotrellis.raster.package$;
import geotrellis.raster.render.IndexedColorMap;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.util.ByteReader;
import geotrellis.vector.Extent;
import geotrellis.vector.ProjectedExtent;
import java.io.Serializable;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Product2;
import scala.Some;
import scala.Tuple2;
import scala.Tuple6;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r}d\u0001B\u0001\u0003\u0001.\u0011\u0011cU5oO2,'-\u00198e\u000f\u0016|G+\u001b4g\u0015\t\u0019A!A\u0004hK>$\u0018N\u001a4\u000b\u0005\u00151\u0011AA5p\u0015\t9\u0001\"\u0001\u0004sCN$XM\u001d\u0006\u0002\u0013\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001M)\u0001\u0001\u0004\n\u001b;A\u0011Q\u0002E\u0007\u0002\u001d)\tq\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0012\u001d\t1\u0011I\\=SK\u001a\u00042a\u0005\u000b\u0017\u001b\u0005\u0011\u0011BA\u000b\u0003\u0005\u001d9Um\u001c+jM\u001a\u0004\"a\u0006\r\u000e\u0003\u0019I!!\u0007\u0004\u0003\tQKG.\u001a\t\u0003\u001bmI!\u0001\b\b\u0003\u000fA\u0013x\u000eZ;diB\u0011QBH\u0005\u0003?9\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\"\t\u0001\u0003\u0016\u0004%\tAI\u0001\u0005i&dW-F\u0001\u0017\u0011!!\u0003A!E!\u0002\u00131\u0012!\u0002;jY\u0016\u0004\u0003\u0002\u0003\u0014\u0001\u0005+\u0007I\u0011A\u0014\u0002\r\u0015DH/\u001a8u+\u0005A\u0003CA\u0015-\u001b\u0005Q#BA\u0016\t\u0003\u00191Xm\u0019;pe&\u0011QF\u000b\u0002\u0007\u000bb$XM\u001c;\t\u0011=\u0002!\u0011#Q\u0001\n!\nq!\u001a=uK:$\b\u0005\u0003\u00052\u0001\tU\r\u0011\"\u00013\u0003\r\u0019'o]\u000b\u0002gA\u0011AgN\u0007\u0002k)\u0011a\u0007C\u0001\u0006aJ|'\u000eN\u0005\u0003qU\u00121a\u0011*T\u0011!Q\u0004A!E!\u0002\u0013\u0019\u0014\u0001B2sg\u0002B\u0001\u0002\u0010\u0001\u0003\u0016\u0004%\t!P\u0001\u0005i\u0006<7/F\u0001?!\t\u0019r(\u0003\u0002A\u0005\t!A+Y4t\u0011!\u0011\u0005A!E!\u0002\u0013q\u0014!\u0002;bON\u0004\u0003\u0002\u0003#\u0001\u0005+\u0007I\u0011A#\u0002\u000f=\u0004H/[8ogV\ta\t\u0005\u0002\u0014\u000f&\u0011\u0001J\u0001\u0002\u000f\u000f\u0016|G+\u001b4g\u001fB$\u0018n\u001c8t\u0011!Q\u0005A!E!\u0002\u00131\u0015\u0001C8qi&|gn\u001d\u0011\t\u00111\u0003!Q3A\u0005\u00025\u000b\u0011b\u001c<feZLWm^:\u0016\u00039\u00032aT,\u0013\u001d\t\u0001VK\u0004\u0002R)6\t!K\u0003\u0002T\u0015\u00051AH]8pizJ\u0011aD\u0005\u0003-:\tq\u0001]1dW\u0006<W-\u0003\u0002Y3\n!A*[:u\u0015\t1f\u0002\u0003\u0005\\\u0001\tE\t\u0015!\u0003O\u0003)yg/\u001a:wS\u0016<8\u000f\t\u0005\u0006;\u0002!\tAX\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000f}\u0003\u0017MY2eKB\u00111\u0003\u0001\u0005\u0006Cq\u0003\rA\u0006\u0005\u0006Mq\u0003\r\u0001\u000b\u0005\u0006cq\u0003\ra\r\u0005\u0006yq\u0003\rA\u0010\u0005\u0006\tr\u0003\rA\u0012\u0005\b\u0019r\u0003\n\u00111\u0001O\u0011\u001d9\u0007A1A\u0005\u0002!\f\u0001bY3mYRK\b/Z\u000b\u0002SB\u0011!\u000e\u001c\b\u0003/-L!A\u0016\u0004\n\u00055t'\u0001C\"fY2$\u0016\u0010]3\u000b\u0005Y3\u0001B\u00029\u0001A\u0003%\u0011.A\u0005dK2dG+\u001f9fA!)!\u000f\u0001C\u0001g\u00069Q.\u00199US2,GCA0u\u0011\u0015)\u0018\u000f1\u0001w\u0003\u00051\u0007\u0003B\u0007x-YI!\u0001\u001f\b\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\"\u0002>\u0001\t\u0003Y\u0018!E<ji\"\u001cFo\u001c:bO\u0016lU\r\u001e5pIR\u0011q\f \u0005\u0006{f\u0004\rA`\u0001\u000egR|'/Y4f\u001b\u0016$\bn\u001c3\u0011\u0005My\u0018bAA\u0001\u0005\ti1\u000b^8sC\u001e,W*\u001a;i_\u0012Dq!!\u0002\u0001\t\u0003\t9!A\u0005j[\u0006<W\rR1uCV\u0011\u0011\u0011\u0002\t\u0004'\u0005-\u0011bAA\u0007\u0005\t\u0001r)Z8US\u001a4\u0017*\\1hK\u0012\u000bG/\u0019\u0005\b\u0003#\u0001A\u0011AA\n\u0003\u0011\u0019'o\u001c9\u0015\u000b}\u000b)\"!\u0007\t\u000f\u0005]\u0011q\u0002a\u0001Q\u0005I1/\u001e2FqR,g\u000e\u001e\u0005\b\t\u0006=\u0001\u0019AA\u000e!\u0011\ti\"a\n\u000f\t\u0005}\u00111E\u0007\u0003\u0003CQ1!!\u0005\u0007\u0013\u0011\t)#!\t\u0002\t\r\u0013x\u000e]\u0005\u0005\u0003S\tYCA\u0004PaRLwN\\:\u000b\t\u0005\u0015\u0012\u0011\u0005\u0005\b\u0003#\u0001A\u0011AA\u0018)\u0015y\u0016\u0011GA\u001e\u0011!\t\u0019$!\fA\u0002\u0005U\u0012AB2pY6\u000b\u0007\u0010E\u0002\u000e\u0003oI1!!\u000f\u000f\u0005\rIe\u000e\u001e\u0005\t\u0003{\ti\u00031\u0001\u00026\u00051!o\\<NCbDq!!\u0005\u0001\t\u0003\t\t\u0005F\u0005`\u0003\u0007\n9%a\u0013\u0002N!A\u0011QIA \u0001\u0004\t)$\u0001\u0004d_2l\u0015N\u001c\u0005\t\u0003\u0013\ny\u00041\u0001\u00026\u00051!o\\<NS:D\u0001\"a\r\u0002@\u0001\u0007\u0011Q\u0007\u0005\t\u0003{\ty\u00041\u0001\u00026!9\u0011\u0011\u0003\u0001\u0005\u0002\u0005ECcA0\u0002T!A\u0011QKA(\u0001\u0004\t9&\u0001\u0006he&$'i\\;oIN\u00042aFA-\u0013\r\tYF\u0002\u0002\u000b\u000fJLGMQ8v]\u0012\u001c\bbBA\t\u0001\u0011\u0005\u0011q\f\u000b\u0004?\u0006\u0005\u0004bBA\f\u0003;\u0002\r\u0001\u000b\u0005\b\u0003#\u0001A\u0011AA3))\t9'a\u001e\u0002z\u0005\r\u00151\u0013\t\u0005\u0003S\n\u0019HD\u0002\u0002l-tA!!\u001c\u0002r9\u0019\u0011+a\u001c\n\u0003%I!a\u0002\u0005\n\u0007\u0005UdN\u0001\tTS:<G.\u001a2b]\u0012\u0014\u0016m\u001d;fe\"9\u0011qCA2\u0001\u0004A\u0003\u0002CA>\u0003G\u0002\r!! \u0002\u0011\r,G\u000e\\*ju\u0016\u00042aFA@\u0013\r\t\tI\u0002\u0002\t\u0007\u0016dGnU5{K\"A\u0011QQA2\u0001\u0004\t9)\u0001\bsKN\fW\u000e\u001d7f\u001b\u0016$\bn\u001c3\u0011\t\u0005%\u0015qR\u0007\u0003\u0003\u0017S1!!$\u0007\u0003!\u0011Xm]1na2,\u0017\u0002BAI\u0003\u0017\u0013aBU3tC6\u0004H.Z'fi\"|G\r\u0003\u0005\u0002\u0016\u0006\r\u0004\u0019AAL\u0003!\u0019HO]1uK\u001eL\bcA\n\u0002\u001a&\u0019\u00111\u0014\u0002\u0003!=3XM\u001d<jK^\u001cFO]1uK\u001eL\bbBA\t\u0001\u0011\u0005\u0011q\u0014\u000b\u0005\u0003C\u000bi\u000bE\u0003P\u0003G\u000b9+C\u0002\u0002&f\u0013\u0001\"\u0013;fe\u0006$xN\u001d\t\u0007\u001b\u0005%\u0016q\u000b\f\n\u0007\u0005-fB\u0001\u0004UkBdWM\r\u0005\t\u0003_\u000bi\n1\u0001\u00022\u00069q/\u001b8e_^\u001c\b#B(\u00024\u0006]\u0013bAA[3\n\u00191+Z9\t\u000f\u00055\u0005\u0001\"\u0001\u0002:RA\u0011qMA^\u0003\u000b\f9\r\u0003\u0005\u0002>\u0006]\u0006\u0019AA`\u00031\u0011\u0018m\u001d;fe\u0016CH/\u001a8u!\r9\u0012\u0011Y\u0005\u0004\u0003\u00074!\u0001\u0004*bgR,'/\u0012=uK:$\b\u0002CAC\u0003o\u0003\r!a\"\t\u0011\u0005U\u0015q\u0017a\u0001\u0003/Cq!a3\u0001\t\u0003\ti-A\u0007ck&dGm\u0014<feZLWm\u001e\u000b\b?\u0006=\u0017\u0011[Ak\u0011!\t))!3A\u0002\u0005\u001d\u0005\u0002CAj\u0003\u0013\u0004\r!!\u000e\u0002!\u0011,7-[7bi&|gNR1di>\u0014\bBCAl\u0003\u0013\u0004\n\u00111\u0001\u00026\u0005I!\r\\8dWNK'0\u001a\u0005\b\u00037\u0004A\u0011AAo\u000359\u0018\u000e\u001e5Pm\u0016\u0014h/[3xgR9q,a8\u0002b\u0006\u001d\b\u0002CAC\u00033\u0004\r!a\"\t\u0015\u0005\r\u0018\u0011\u001cI\u0001\u0002\u0004\t)/A\u0006eK\u000eLW.\u0019;j_:\u001c\b\u0003B(X\u0003kA!\"a6\u0002ZB\u0005\t\u0019AA\u001b\u0011\u001d\tY\u000f\u0001C\u0001\u0003[\fAaY8qsRiq,a<\u0002r\u0006M\u0018Q_A|\u0003sD\u0001\"IAu!\u0003\u0005\rA\u0006\u0005\tM\u0005%\b\u0013!a\u0001Q!A\u0011'!;\u0011\u0002\u0003\u00071\u0007\u0003\u0005=\u0003S\u0004\n\u00111\u0001?\u0011!!\u0015\u0011\u001eI\u0001\u0002\u00041\u0005\u0002\u0003'\u0002jB\u0005\t\u0019\u0001(\t\u0013\u0005u\b!%A\u0005B\u0005}\u0018aF<ji\"|e/\u001a:wS\u0016<8\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011\tA\u000b\u0003\u0002f\n\r1F\u0001B\u0003!\u0011\u00119A!\u0005\u000e\u0005\t%!\u0002\u0002B\u0006\u0005\u001b\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t=a\"\u0001\u0006b]:|G/\u0019;j_:LAAa\u0005\u0003\n\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\t]\u0001!%A\u0005B\te\u0011aF<ji\"|e/\u001a:wS\u0016<8\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011YB\u000b\u0003\u00026\t\r\u0001\"\u0003B\u0010\u0001E\u0005I\u0011\tB\u0011\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\"Aa\t+\u0007Y\u0011\u0019\u0001C\u0005\u0003(\u0001\t\n\u0011\"\u0011\u0003*\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TC\u0001B\u0016U\rA#1\u0001\u0005\n\u0005_\u0001\u0011\u0013!C!\u0005c\tabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u00034)\u001a1Ga\u0001\t\u0013\t]\u0002!%A\u0005B\te\u0012AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0005wQ3A\u0010B\u0002\u0011%\u0011y\u0004AI\u0001\n\u0003\u0012\t%\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u001b\u0016\u0005\t\r#f\u0001$\u0003\u0004!I!q\t\u0001\u0012\u0002\u0013\u0005#\u0011J\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00137+\t\u0011YEK\u0002O\u0005\u0007A\u0011Ba\u0014\u0001\u0003\u0003%\tE!\u0015\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011\u0019\u0006\u0005\u0003\u0003V\t}SB\u0001B,\u0015\u0011\u0011IFa\u0017\u0002\t1\fgn\u001a\u0006\u0003\u0005;\nAA[1wC&!!\u0011\rB,\u0005\u0019\u0019FO]5oO\"I!Q\r\u0001\u0002\u0002\u0013\u0005!qM\u0001\raJ|G-^2u\u0003JLG/_\u000b\u0003\u0003kA\u0011Ba\u001b\u0001\u0003\u0003%\tA!\u001c\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!q\u000eB;!\ri!\u0011O\u0005\u0004\u0005gr!aA!os\"Q!q\u000fB5\u0003\u0003\u0005\r!!\u000e\u0002\u0007a$\u0013\u0007C\u0005\u0003|\u0001\t\t\u0011\"\u0011\u0003~\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0003\u0000A1!\u0011\u0011BD\u0005_j!Aa!\u000b\u0007\t\u0015e\"\u0001\u0006d_2dWm\u0019;j_:LA!!*\u0003\u0004\"I!1\u0012\u0001\u0002\u0002\u0013\u0005!QR\u0001\tG\u0006tW)];bYR!!q\u0012BK!\ri!\u0011S\u0005\u0004\u0005's!a\u0002\"p_2,\u0017M\u001c\u0005\u000b\u0005o\u0012I)!AA\u0002\t=\u0004\"\u0003BM\u0001\u0005\u0005I\u0011\tBN\u0003!A\u0017m\u001d5D_\u0012,GCAA\u001b\u0011%\u0011y\nAA\u0001\n\u0003\u0012\t+\u0001\u0005u_N#(/\u001b8h)\t\u0011\u0019\u0006C\u0005\u0003&\u0002\t\t\u0011\"\u0011\u0003(\u00061Q-];bYN$BAa$\u0003*\"Q!q\u000fBR\u0003\u0003\u0005\rAa\u001c\b\u000f\t5&\u0001#\u0001\u00030\u0006\t2+\u001b8hY\u0016\u0014\u0017M\u001c3HK>$\u0016N\u001a4\u0011\u0007M\u0011\tL\u0002\u0004\u0002\u0005!\u0005!1W\n\u0005\u0005ccQ\u0004C\u0004^\u0005c#\tAa.\u0015\u0005\t=\u0006\u0002\u0003B^\u0005c#\tA!0\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u000f}\u0013yL!1\u0003D\"1\u0011E!/A\u0002YAaA\nB]\u0001\u0004A\u0003BB\u0019\u0003:\u0002\u00071\u0007\u0003\u0005\u0003<\nEF\u0011\u0001Bd)\ry&\u0011\u001a\u0005\t\u0005\u0017\u0014)\r1\u0001\u0003N\u0006)!-\u001f;fgB)QBa4\u0003T&\u0019!\u0011\u001b\b\u0003\u000b\u0005\u0013(/Y=\u0011\u00075\u0011).C\u0002\u0003X:\u0011AAQ=uK\"A!1\u0018BY\t\u0003\u0011Y\u000eF\u0003`\u0005;\u0014y\u000e\u0003\u0005\u0003L\ne\u0007\u0019\u0001Bg\u0011!\u0011\tO!7A\u0002\t=\u0015!C:ue\u0016\fW.\u001b8h\u0011!\u0011YL!-\u0005\u0002\t\u0015HcA0\u0003h\"A!\u0011\u001eBr\u0001\u0004\u0011Y/\u0001\u0003qCRD\u0007\u0003\u0002Bw\u0005ktAAa<\u0003rB\u0011\u0011KD\u0005\u0004\u0005gt\u0011A\u0002)sK\u0012,g-\u0003\u0003\u0003b\t](b\u0001Bz\u001d!A!1\u0018BY\t\u0003\u0011Y\u0010F\u0003`\u0005{\u0014y\u0010\u0003\u0005\u0003j\ne\b\u0019\u0001Bv\u0011\u001d\u0019\tA!?A\u0002!\n\u0011!\u001a\u0005\t\u0005w\u0013\t\f\"\u0001\u0004\u0006Q)qla\u0002\u0004\n!A!\u0011^B\u0002\u0001\u0004\u0011Y\u000f\u0003\u0005\u0004\u0002\r\r\u0001\u0019AB\u0006!\u0011i1Q\u0002\u0015\n\u0007\r=aB\u0001\u0004PaRLwN\u001c\u0005\t\u0005w\u0013\t\f\"\u0001\u0004\u0014Q)ql!\u0006\u0004\u0018!A!\u0011^B\t\u0001\u0004\u0011Y\u000f\u0003\u0005\u0003b\u000eE\u0001\u0019\u0001BH\u0011!\u0011YL!-\u0005\u0002\rmAcA0\u0004\u001e!A1qDB\r\u0001\u0004\u0019\t#\u0001\u0006csR,'+Z1eKJ\u0004Baa\t\u0004*5\u00111Q\u0005\u0006\u0004\u0007OA\u0011\u0001B;uS2LAaa\u000b\u0004&\tQ!)\u001f;f%\u0016\fG-\u001a:\t\u0011\tm&\u0011\u0017C\u0001\u0007_!RaXB\u0019\u0007gA\u0001ba\b\u0004.\u0001\u00071\u0011\u0005\u0005\b\u0007\u0003\u0019i\u00031\u0001)\u0011!\u0011YL!-\u0005\u0002\r]B#B0\u0004:\rm\u0002\u0002CB\u0010\u0007k\u0001\ra!\t\t\u0011\r\u00051Q\u0007a\u0001\u0007\u0017A\u0001B!9\u00032\u0012\u00051q\b\u000b\u0004?\u000e\u0005\u0003\u0002\u0003Bu\u0007{\u0001\rAa;\t\u0011\t\u0005(\u0011\u0017C\u0001\u0007\u000b\"2aXB$\u0011!\u0019yba\u0011A\u0002\r\u0005\u0002B\u0003B^\u0005c\u000b\t\u0011\"!\u0004LQiql!\u0014\u0004P\rE31KB+\u0007/Ba!IB%\u0001\u00041\u0002B\u0002\u0014\u0004J\u0001\u0007\u0001\u0006\u0003\u00042\u0007\u0013\u0002\ra\r\u0005\u0007y\r%\u0003\u0019\u0001 \t\r\u0011\u001bI\u00051\u0001G\u0011!a5\u0011\nI\u0001\u0002\u0004q\u0005BCB.\u0005c\u000b\t\u0011\"!\u0004^\u00059QO\\1qa2LH\u0003BB0\u0007O\u0002R!DB\u0007\u0007C\u0002\u0012\"DB2-!\u001adH\u0012(\n\u0007\r\u0015dB\u0001\u0004UkBdWM\u000e\u0005\n\u0007S\u001aI&!AA\u0002}\u000b1\u0001\u001f\u00131\u0011)\u0019iG!-\u0012\u0002\u0013\u0005!\u0011J\u0001\u0010CB\u0004H.\u001f\u0013eK\u001a\fW\u000f\u001c;%m!Q1\u0011\u000fBY#\u0003%\tA!\u0013\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00137\u0011)\u0019)H!-\u0002\u0002\u0013%1qO\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0004zA!!QKB>\u0013\u0011\u0019iHa\u0016\u0003\r=\u0013'.Z2u\u0001")
public class SinglebandGeoTiff
implements GeoTiff<Tile>,
Product,
scala.Serializable {
    private final Tile tile;
    private final Extent extent;
    private final CRS crs;
    private final Tags tags;
    private final GeoTiffOptions options;
    private final List<GeoTiff<Tile>> overviews;
    private final DataType cellType;

    public static List<GeoTiff<Tile>> $lessinit$greater$default$6() {
        return SinglebandGeoTiff$.MODULE$.$lessinit$greater$default$6();
    }

    public static List<GeoTiff<Tile>> apply$default$6() {
        return SinglebandGeoTiff$.MODULE$.apply$default$6();
    }

    public static Option<Tuple6<Tile, Extent, CRS, Tags, GeoTiffOptions, List<GeoTiff<Tile>>>> unapply(SinglebandGeoTiff singlebandGeoTiff) {
        return SinglebandGeoTiff$.MODULE$.unapply(singlebandGeoTiff);
    }

    public static SinglebandGeoTiff apply(Tile tile, Extent extent, CRS cRS, Tags tags, GeoTiffOptions geoTiffOptions, List<GeoTiff<Tile>> list) {
        return SinglebandGeoTiff$.MODULE$.apply(tile, extent, cRS, tags, geoTiffOptions, list);
    }

    public static SinglebandGeoTiff streaming(ByteReader byteReader) {
        return SinglebandGeoTiff$.MODULE$.streaming(byteReader);
    }

    public static SinglebandGeoTiff streaming(String string) {
        return SinglebandGeoTiff$.MODULE$.streaming(string);
    }

    public static SinglebandGeoTiff apply(ByteReader byteReader, Option<Extent> option) {
        return SinglebandGeoTiff$.MODULE$.apply(byteReader, option);
    }

    public static SinglebandGeoTiff apply(ByteReader byteReader, Extent extent) {
        return SinglebandGeoTiff$.MODULE$.apply(byteReader, extent);
    }

    public static SinglebandGeoTiff apply(ByteReader byteReader) {
        return SinglebandGeoTiff$.MODULE$.apply(byteReader);
    }

    public static SinglebandGeoTiff apply(String string, boolean bl) {
        return SinglebandGeoTiff$.MODULE$.apply(string, bl);
    }

    public static SinglebandGeoTiff apply(String string, Option<Extent> option) {
        return SinglebandGeoTiff$.MODULE$.apply(string, option);
    }

    public static SinglebandGeoTiff apply(String string, Extent extent) {
        return SinglebandGeoTiff$.MODULE$.apply(string, extent);
    }

    public static SinglebandGeoTiff apply(String string) {
        return SinglebandGeoTiff$.MODULE$.apply(string);
    }

    public static SinglebandGeoTiff apply(byte[] byArray, boolean bl) {
        return SinglebandGeoTiff$.MODULE$.apply(byArray, bl);
    }

    public static SinglebandGeoTiff apply(byte[] byArray) {
        return SinglebandGeoTiff$.MODULE$.apply(byArray);
    }

    public static SinglebandGeoTiff apply(Tile tile, Extent extent, CRS cRS) {
        return SinglebandGeoTiff$.MODULE$.apply(tile, extent, cRS);
    }

    @Override
    public int cols() {
        return GeoTiff.cols$(this);
    }

    @Override
    public int rows() {
        return GeoTiff.rows$(this);
    }

    @Override
    public ProjectedExtent projectedExtent() {
        return GeoTiff.projectedExtent$(this);
    }

    @Override
    public ProjectedRaster<Tile> projectedRaster() {
        return GeoTiff.projectedRaster$(this);
    }

    @Override
    public Raster<Tile> raster() {
        return GeoTiff.raster$(this);
    }

    @Override
    public RasterExtent rasterExtent() {
        return GeoTiff.rasterExtent$(this);
    }

    @Override
    public CellSize cellSize() {
        return GeoTiff.cellSize$(this);
    }

    @Override
    public int bandCount() {
        return GeoTiff.bandCount$(this);
    }

    @Override
    public void write(String path, boolean optimizedOrder) {
        GeoTiff.write$(this, path, optimizedOrder);
    }

    @Override
    public byte[] toByteArray() {
        return GeoTiff.toByteArray$(this);
    }

    @Override
    public byte[] toCloudOptimizedByteArray() {
        return GeoTiff.toCloudOptimizedByteArray$(this);
    }

    @Override
    public int getOverviewsCount() {
        return GeoTiff.getOverviewsCount$(this);
    }

    @Override
    public GeoTiff<Tile> getOverview(int idx) {
        return GeoTiff.getOverview$(this, idx);
    }

    @Override
    public GeoTiff<Tile> withOverviews(Seq<GeoTiff<Tile>> overviews) {
        return GeoTiff.withOverviews$(this, overviews);
    }

    @Override
    public Raster<Tile> crop(Extent subExtent, CellSize cellSize) {
        return GeoTiff.crop$(this, subExtent, cellSize);
    }

    @Override
    public Raster<Tile> crop(RasterExtent rasterExtent) {
        return GeoTiff.crop$(this, rasterExtent);
    }

    @Override
    public GeoTiff<Tile> getClosestOverview(CellSize cellSize, OverviewStrategy strategy) {
        return GeoTiff.getClosestOverview$(this, cellSize, strategy);
    }

    @Override
    public boolean write$default$2() {
        return GeoTiff.write$default$2$(this);
    }

    @Override
    public int buildOverview$default$3() {
        return GeoTiff.buildOverview$default$3$(this);
    }

    @Override
    public OverviewStrategy getClosestOverview$default$2() {
        return GeoTiff.getClosestOverview$default$2$(this);
    }

    @Override
    public Option<PixelSampleType> pixelSampleType() {
        return GeoTiffData.pixelSampleType$(this);
    }

    @Override
    public Tile tile() {
        return this.tile;
    }

    @Override
    public Extent extent() {
        return this.extent;
    }

    @Override
    public CRS crs() {
        return this.crs;
    }

    @Override
    public Tags tags() {
        return this.tags;
    }

    @Override
    public GeoTiffOptions options() {
        return this.options;
    }

    @Override
    public List<GeoTiff<Tile>> overviews() {
        return this.overviews;
    }

    @Override
    public DataType cellType() {
        return this.cellType;
    }

    public SinglebandGeoTiff mapTile(Function1<Tile, Tile> f) {
        return new SinglebandGeoTiff((Tile)f.apply((Object)this.tile()), this.extent(), this.crs(), this.tags(), this.options(), this.overviews());
    }

    public SinglebandGeoTiff withStorageMethod(StorageMethod storageMethod) {
        return new SinglebandGeoTiff(this.tile().toArrayTile(), this.extent(), this.crs(), this.tags(), this.options().copy(storageMethod, this.options().copy$default$2(), this.options().copy$default$3(), this.options().copy$default$4(), this.options().copy$default$5(), this.options().copy$default$6(), this.options().copy$default$7()), this.overviews());
    }

    @Override
    public GeoTiffImageData imageData() {
        GeoTiffTile geoTiffTile;
        Tile tile = this.tile();
        GeoTiffTile geoTiffTile2 = tile instanceof GeoTiffTile ? (geoTiffTile = (GeoTiffTile)tile) : geotrellis.raster.io.geotiff.package$.MODULE$.GeoTiffTileMethods(this.tile()).toGeoTiffTile(this.options());
        return geoTiffTile2;
    }

    public SinglebandGeoTiff crop(Extent subExtent, Crop.Options options) {
        Option option = this.extent().intersection(subExtent);
        if (!(option instanceof Some)) {
            throw new GeoAttrsError(new StringBuilder(60).append("Extent to crop by (").append(subExtent).append(") should intersect the imagery extent (").append(this.extent()).append(").").toString());
        }
        Some some = (Some)option;
        Extent ext = (Extent)some.value();
        Raster raster = package$.MODULE$.withExtentCropMethods(this.raster(), (Function1 & Serializable & scala.Serializable)self -> package$.MODULE$.withTileMethods((Tile)self)).crop(ext, options);
        SinglebandGeoTiff singlebandGeoTiff = new SinglebandGeoTiff((Tile)raster.tile(), raster.extent(), this.crs(), this.tags(), this.options(), this.overviews());
        return singlebandGeoTiff;
    }

    public SinglebandGeoTiff crop(int colMax, int rowMax) {
        return this.crop(0, 0, colMax, rowMax);
    }

    public SinglebandGeoTiff crop(int colMin, int rowMin, int colMax, int rowMax) {
        Raster raster = (Raster)package$.MODULE$.withExtentCropMethods(this.raster(), (Function1 & Serializable & scala.Serializable)self -> package$.MODULE$.withTileMethods((Tile)self)).crop(colMin, rowMin, colMax, rowMax);
        return new SinglebandGeoTiff((Tile)raster.tile(), raster.extent(), this.crs(), this.tags(), this.options(), this.overviews());
    }

    public SinglebandGeoTiff crop(GridBounds gridBounds) {
        return this.crop(gridBounds.colMin(), gridBounds.rowMin(), gridBounds.colMax(), gridBounds.rowMax());
    }

    public SinglebandGeoTiff crop(Extent subExtent) {
        return this.crop(subExtent, Crop$Options$.MODULE$.DEFAULT());
    }

    @Override
    public Raster<Tile> crop(Extent subExtent, CellSize cellSize, ResampleMethod resampleMethod, OverviewStrategy strategy) {
        return this.getClosestOverview(cellSize, strategy).crop(subExtent, new Crop.Options(false, Crop$Options$.MODULE$.apply$default$2())).resample(RasterExtent$.MODULE$.apply(subExtent, cellSize), resampleMethod, strategy);
    }

    @Override
    public Iterator<Tuple2<GridBounds, Tile>> crop(Seq<GridBounds> windows) {
        Object object;
        Tile tile = this.tile();
        if (tile instanceof GeoTiffTile) {
            GeoTiffTile geoTiffTile = (GeoTiffTile)tile;
            object = geoTiffTile.crop(windows);
        } else if (tile != null) {
            Tile tile2 = tile;
            object = package$.MODULE$.withTileMethods(tile2).crop(windows);
        } else {
            throw new MatchError((Object)tile);
        }
        return object;
    }

    @Override
    public Raster<Tile> resample(RasterExtent rasterExtent, ResampleMethod resampleMethod, OverviewStrategy strategy) {
        return package$.MODULE$.withSinglebandRasterMethods(this.getClosestOverview(this.cellSize(), strategy).raster()).resample(rasterExtent, resampleMethod);
    }

    public SinglebandGeoTiff buildOverview(ResampleMethod resampleMethod, int decimationFactor, int blockSize) {
        RasterExtent overviewRasterExtent = RasterExtent$.MODULE$.apply(this.extent(), (int)scala.math.package$.MODULE$.ceil((double)this.tile().cols() / (double)decimationFactor), (int)scala.math.package$.MODULE$.ceil((double)this.tile().rows() / (double)decimationFactor));
        GeoTiffSegmentLayout segmentLayout = GeoTiffSegmentLayout$.MODULE$.apply(overviewRasterExtent.cols(), overviewRasterExtent.rows(), new Tiled(blockSize, blockSize), PixelInterleave$.MODULE$, BandType$.MODULE$.forCellType(this.tile().cellType()));
        Seq segments = (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])package$.MODULE$.withTileMethods(package$.MODULE$.withSinglebandRasterMethods(new Raster<Tile>(this.tile().toArrayTile(), this.extent())).resample(overviewRasterExtent, resampleMethod).tile()).split(segmentLayout.tileLayout()))).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Tile tile = (Tile)tuple2._1();
            int index = tuple2._2$mcI$sp();
            int col = index % segmentLayout.tileLayout().layoutCols();
            int row = index / segmentLayout.tileLayout().layoutCols();
            Tuple2 tuple22 = new Tuple2((Object)new Tuple2.mcII.sp(col, row), (Object)tile);
            return tuple22;
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        Tiled storageMethod = new Tiled(blockSize, blockSize);
        Some x$1 = new Some((Object)ReducedImage$.MODULE$);
        Tiled x$2 = storageMethod;
        Compression x$3 = this.options().copy$default$2();
        int x$4 = this.options().copy$default$3();
        Option<IndexedColorMap> x$5 = this.options().copy$default$4();
        InterleaveMethod x$6 = this.options().copy$default$5();
        TiffType x$7 = this.options().copy$default$7();
        GeoTiffOptions overviewOptions = this.options().copy(x$2, x$3, x$4, x$5, x$6, (Option<NewSubfileType>)x$1, x$7);
        Tile overviewTile = GeoTiffBuilder$.MODULE$.apply(GeoTiffBuilder$.MODULE$.singlebandGeoTiffBuilder()).makeTile((Iterator<Tuple2<Product2<Object, Object>, Tile>>)segments.toIterator(), segmentLayout, this.cellType(), this.options().compression());
        return new SinglebandGeoTiff(overviewTile, this.extent(), this.crs(), Tags$.MODULE$.empty(), overviewOptions, SinglebandGeoTiff$.MODULE$.apply$default$6());
    }

    public SinglebandGeoTiff withOverviews(ResampleMethod resampleMethod, List<Object> decimations, int blockSize) {
        SinglebandGeoTiff singlebandGeoTiff;
        List<Object> overviewDecimations;
        List<Object> list = overviewDecimations = decimations.isEmpty() ? GeoTiff$.MODULE$.defaultOverviewDecimations(this.tile().cols(), this.tile().rows(), blockSize) : decimations;
        if (overviewDecimations.isEmpty()) {
            singlebandGeoTiff = this;
        } else {
            ArrayTile arrayTile = this.tile().toArrayTile();
            SinglebandGeoTiff staged = new SinglebandGeoTiff(arrayTile, this.extent(), this.crs(), this.tags(), this.options(), (List<GeoTiff<Tile>>)Nil$.MODULE$);
            List overviews = (List)overviewDecimations.map((Function1 & Serializable & scala.Serializable)decimationFactor -> staged.buildOverview(resampleMethod, BoxesRunTime.unboxToInt((Object)decimationFactor), blockSize), List$.MODULE$.canBuildFrom());
            singlebandGeoTiff = new SinglebandGeoTiff(this.tile(), this.extent(), this.crs(), this.tags(), this.options(), (List<GeoTiff<Tile>>)overviews);
        }
        return singlebandGeoTiff;
    }

    @Override
    public List<Object> withOverviews$default$2() {
        return Nil$.MODULE$;
    }

    @Override
    public int withOverviews$default$3() {
        return GeoTiff$.MODULE$.DefaultBlockSize();
    }

    public SinglebandGeoTiff copy(Tile tile, Extent extent, CRS crs, Tags tags, GeoTiffOptions options, List<GeoTiff<Tile>> overviews) {
        return new SinglebandGeoTiff(tile, extent, crs, tags, options, overviews);
    }

    @Override
    public Tile copy$default$1() {
        return this.tile();
    }

    @Override
    public Extent copy$default$2() {
        return this.extent();
    }

    @Override
    public CRS copy$default$3() {
        return this.crs();
    }

    @Override
    public Tags copy$default$4() {
        return this.tags();
    }

    @Override
    public GeoTiffOptions copy$default$5() {
        return this.options();
    }

    @Override
    public List<GeoTiff<Tile>> copy$default$6() {
        return this.overviews();
    }

    public String productPrefix() {
        return "SinglebandGeoTiff";
    }

    public int productArity() {
        return 6;
    }

    public Object productElement(int x$1) {
        scala.Serializable serializable;
        int n = x$1;
        switch (n) {
            case 0: {
                serializable = this.tile();
                break;
            }
            case 1: {
                serializable = this.extent();
                break;
            }
            case 2: {
                serializable = this.crs();
                break;
            }
            case 3: {
                serializable = this.tags();
                break;
            }
            case 4: {
                serializable = this.options();
                break;
            }
            case 5: {
                serializable = this.overviews();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return serializable;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof SinglebandGeoTiff;
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof SinglebandGeoTiff)) return false;
        boolean bl = true;
        if (!bl) return false;
        SinglebandGeoTiff singlebandGeoTiff = (SinglebandGeoTiff)x$1;
        Tile tile = this.tile();
        Tile tile2 = singlebandGeoTiff.tile();
        if (tile == null) {
            if (tile2 != null) {
                return false;
            }
        } else if (!tile.equals(tile2)) return false;
        Extent extent = this.extent();
        Extent extent2 = singlebandGeoTiff.extent();
        if (extent == null) {
            if (extent2 != null) {
                return false;
            }
        } else if (!extent.equals(extent2)) return false;
        CRS cRS = this.crs();
        CRS cRS2 = singlebandGeoTiff.crs();
        if (cRS == null) {
            if (cRS2 != null) {
                return false;
            }
        } else if (!cRS.equals(cRS2)) return false;
        Tags tags = this.tags();
        Tags tags2 = singlebandGeoTiff.tags();
        if (tags == null) {
            if (tags2 != null) {
                return false;
            }
        } else if (!((Object)tags).equals(tags2)) return false;
        GeoTiffOptions geoTiffOptions = this.options();
        GeoTiffOptions geoTiffOptions2 = singlebandGeoTiff.options();
        if (geoTiffOptions == null) {
            if (geoTiffOptions2 != null) {
                return false;
            }
        } else if (!((Object)geoTiffOptions).equals(geoTiffOptions2)) return false;
        List<GeoTiff<Tile>> list = this.overviews();
        List<GeoTiff<Tile>> list2 = singlebandGeoTiff.overviews();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!list.equals(list2)) return false;
        if (!singlebandGeoTiff.canEqual(this)) return false;
        return true;
    }

    public SinglebandGeoTiff(Tile tile, Extent extent, CRS crs, Tags tags, GeoTiffOptions options, List<GeoTiff<Tile>> overviews) {
        this.tile = tile;
        this.extent = extent;
        this.crs = crs;
        this.tags = tags;
        this.options = options;
        this.overviews = overviews;
        GeoTiffData.$init$(this);
        GeoTiff.$init$(this);
        Product.$init$((Product)this);
        this.cellType = tile.cellType();
    }
}

