/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff.compression;

import geotrellis.raster.io.geotiff.compression.Decompressor;
import geotrellis.raster.io.geotiff.compression.DeflateCompression$;
import geotrellis.raster.io.geotiff.compression.JpegDecompressor$;
import geotrellis.raster.io.geotiff.compression.LZWDecompressor$;
import geotrellis.raster.io.geotiff.compression.NoCompression$;
import geotrellis.raster.io.geotiff.compression.PackBitsDecompressor$;
import geotrellis.raster.io.geotiff.compression.Predictor;
import geotrellis.raster.io.geotiff.compression.Predictor$;
import geotrellis.raster.io.geotiff.reader.GeoTiffReaderLimitationException;
import geotrellis.raster.io.geotiff.reader.MalformedGeoTiffException;
import geotrellis.raster.io.geotiff.tags.TiffTags;
import geotrellis.raster.io.geotiff.tags.codes.CompressionType$;
import java.nio.ByteOrder;
import scala.Array$;
import scala.Serializable;
import scala.reflect.ClassTag$;

public final class Decompressor$
implements Serializable {
    public static Decompressor$ MODULE$;

    static {
        new Decompressor$();
    }

    public Decompressor apply(TiffTags tiffTags, ByteOrder byteOrder) {
        Decompressor decompressor;
        int segmentCount = tiffTags.segmentCount();
        int[] segmentSizes = (int[])Array$.MODULE$.ofDim(segmentCount, ClassTag$.MODULE$.Int());
        int bandCount = tiffTags.bandCount();
        if (!tiffTags.hasPixelInterleave() || bandCount == 1) {
            for (int index$macro$320 = 0; index$macro$320 < segmentCount; ++index$macro$320) {
                segmentSizes[index$macro$320] = (int)tiffTags.imageSegmentByteSize(index$macro$320);
            }
        } else {
            for (int index$macro$321 = 0; index$macro$321 < segmentCount; ++index$macro$321) {
                segmentSizes[index$macro$321] = (int)tiffTags.imageSegmentByteSize(index$macro$321) * tiffTags.bandCount();
            }
        }
        int n = tiffTags.compression();
        if (CompressionType$.MODULE$.Uncompressed() == n) {
            decompressor = Decompressor$.checkEndian$1(NoCompression$.MODULE$, tiffTags, byteOrder);
        } else if (CompressionType$.MODULE$.LZWCoded() == n) {
            decompressor = Decompressor$.checkPredictor$1(LZWDecompressor$.MODULE$.apply(segmentSizes), tiffTags, byteOrder);
        } else {
            boolean bl = CompressionType$.MODULE$.ZLibCoded() == n ? true : CompressionType$.MODULE$.PkZipCoded() == n;
            if (bl) {
                decompressor = Decompressor$.checkPredictor$1(DeflateCompression$.MODULE$.createDecompressor(segmentSizes), tiffTags, byteOrder);
            } else if (CompressionType$.MODULE$.PackBitsCoded() == n) {
                decompressor = Decompressor$.checkEndian$1(PackBitsDecompressor$.MODULE$.apply(segmentSizes), tiffTags, byteOrder);
            } else if (CompressionType$.MODULE$.JpegCoded() == n) {
                decompressor = Decompressor$.checkEndian$1(JpegDecompressor$.MODULE$.apply(tiffTags), tiffTags, byteOrder);
            } else {
                if (CompressionType$.MODULE$.HuffmanCoded() == n) {
                    String msg = "compression type CCITTRLE is not supported by this reader.";
                    throw new GeoTiffReaderLimitationException(msg);
                }
                if (CompressionType$.MODULE$.GroupThreeCoded() == n) {
                    String msg = "compression type CCITTFAX3 is not supported by this reader.";
                    throw new GeoTiffReaderLimitationException(msg);
                }
                if (CompressionType$.MODULE$.GroupFourCoded() == n) {
                    String msg = "compression type CCITTFAX4 is not supported by this reader.";
                    throw new GeoTiffReaderLimitationException(msg);
                }
                if (CompressionType$.MODULE$.JpegOldCoded() == n) {
                    String msg = "old jpeg (compression = 6) is deprecated.";
                    throw new MalformedGeoTiffException(msg);
                }
                String msg = new StringBuilder(50).append("compression type ").append(n).append(" is not supported by this reader.").toString();
                throw new GeoTiffReaderLimitationException(msg);
            }
        }
        return decompressor;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final Decompressor checkEndian$1(Decompressor d, TiffTags tiffTags$1, ByteOrder byteOrder$1) {
        ByteOrder byteOrder = byteOrder$1;
        ByteOrder byteOrder2 = ByteOrder.BIG_ENDIAN;
        return (byteOrder == null ? byteOrder2 != null : !byteOrder.equals(byteOrder2)) && tiffTags$1.bitsPerPixel() > 8 ? d.flipEndian(tiffTags$1.bytesPerPixel() / tiffTags$1.bandCount()) : d;
    }

    private static final Decompressor checkPredictor$1(Decompressor d, TiffTags tiffTags$1, ByteOrder byteOrder$1) {
        Predictor predictor = Predictor$.MODULE$.apply(tiffTags$1);
        return predictor.checkEndian() ? Decompressor$.checkEndian$1(d, tiffTags$1, byteOrder$1).withPredictor(predictor) : d.withPredictor(predictor);
    }

    private Decompressor$() {
        MODULE$ = this;
    }
}

