/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff.compression;

import geotrellis.raster.io.geotiff.BandType;
import geotrellis.raster.io.geotiff.compression.FloatingPointPredictor$;
import geotrellis.raster.io.geotiff.compression.Predictor;
import geotrellis.raster.io.geotiff.compression.Predictor$;
import geotrellis.raster.io.geotiff.tags.TiffTags;
import scala.Array$;
import scala.Function1;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001y;Q!\u0001\u0002\t\u00025\taC\u00127pCRLgn\u001a)pS:$\bK]3eS\u000e$xN\u001d\u0006\u0003\u0007\u0011\t1bY8naJ,7o]5p]*\u0011QAB\u0001\bO\u0016|G/\u001b4g\u0015\t9\u0001\"\u0001\u0002j_*\u0011\u0011BC\u0001\u0007e\u0006\u001cH/\u001a:\u000b\u0003-\t!bZ3piJ,G\u000e\\5t\u0007\u0001\u0001\"AD\b\u000e\u0003\t1Q\u0001\u0005\u0002\t\u0002E\u0011aC\u00127pCRLgn\u001a)pS:$\bK]3eS\u000e$xN]\n\u0003\u001fI\u0001\"a\u0005\f\u000e\u0003QQ\u0011!F\u0001\u0006g\u000e\fG.Y\u0005\u0003/Q\u0011a!\u00118z%\u00164\u0007\"B\r\u0010\t\u0003Q\u0012A\u0002\u001fj]&$h\bF\u0001\u000e\u0011\u0015ar\u0002\"\u0001\u001e\u0003\u0015\t\u0007\u000f\u001d7z)\tq\u0012\u0005\u0005\u0002\u000f?%\u0011\u0001E\u0001\u0002\n!J,G-[2u_JDQAI\u000eA\u0002\r\n\u0001\u0002^5gMR\u000bwm\u001d\t\u0003I\u001dj\u0011!\n\u0006\u0003M\u0011\tA\u0001^1hg&\u0011\u0001&\n\u0002\t)&4g\rV1hg\u001a!\u0001c\u0004\u0003+'\rI#C\b\u0005\tY%\u0012\t\u0011)A\u0005[\u0005Q1m\u001c7t!\u0016\u0014(k\\<\u0011\u0005Mq\u0013BA\u0018\u0015\u0005\rIe\u000e\u001e\u0005\tc%\u0012\t\u0011)A\u0005e\u0005i!o\\<t\u0013:\u001cVmZ7f]R\u0004BaE\u001a.[%\u0011A\u0007\u0006\u0002\n\rVt7\r^5p]FB\u0001BN\u0015\u0003\u0002\u0003\u0006IaN\u0001\tE\u0006tG\rV=qKB\u0011\u0001(O\u0007\u0002\t%\u0011!\b\u0002\u0002\t\u0005\u0006tG\rV=qK\"AA(\u000bB\u0001B\u0003%Q&A\u0005cC:$7i\\;oi\")\u0011$\u000bC\u0001}Q)q(\u0011\"D\tB\u0011\u0001)K\u0007\u0002\u001f!)A&\u0010a\u0001[!)\u0011'\u0010a\u0001e!)a'\u0010a\u0001o!)A(\u0010a\u0001[!9a)\u000bb\u0001\n\u00039\u0015\u0001B2pI\u0016,\u0012!\f\u0005\u0007\u0013&\u0002\u000b\u0011B\u0017\u0002\u000b\r|G-\u001a\u0011\t\u000f-K#\u0019!C\u0001\u0019\u0006Y1\r[3dW\u0016sG-[1o+\u0005i\u0005CA\nO\u0013\tyECA\u0004C_>dW-\u00198\t\rEK\u0003\u0015!\u0003N\u00031\u0019\u0007.Z2l\u000b:$\u0017.\u00198!\u0011\u0015a\u0012\u0006\"\u0001T)\r!&\f\u0018\t\u0004'U;\u0016B\u0001,\u0015\u0005\u0015\t%O]1z!\t\u0019\u0002,\u0003\u0002Z)\t!!)\u001f;f\u0011\u0015Y&\u000b1\u0001U\u0003\u0015\u0011\u0017\u0010^3t\u0011\u0015i&\u000b1\u0001.\u00031\u0019XmZ7f]RLe\u000eZ3y\u0001")
public final class FloatingPointPredictor {
    public static Predictor apply(TiffTags tiffTags) {
        return FloatingPointPredictor$.MODULE$.apply(tiffTags);
    }

    public static class FloatingPointPredictor
    implements Predictor {
        private final int colsPerRow;
        private final Function1<Object, Object> rowsInSegment;
        private final BandType bandType;
        private final int bandCount;
        private final int code;
        private final boolean checkEndian;

        @Override
        public int code() {
            return this.code;
        }

        @Override
        public boolean checkEndian() {
            return this.checkEndian;
        }

        @Override
        public byte[] apply(byte[] bytes, int segmentIndex) {
            int rows = this.rowsInSegment.apply$mcII$sp(segmentIndex);
            int stride = this.bandCount;
            int bytesPerSample = this.bandType.bytesPerSample();
            int colValuesPerRow = this.colsPerRow * this.bandCount;
            int bytesPerRow = colValuesPerRow * bytesPerSample;
            for (int index$macro$326 = 0; index$macro$326 < rows; ++index$macro$326) {
                int rowByteIndex = index$macro$326 * bytesPerRow;
                int limit = (index$macro$326 + 1) * bytesPerRow;
                for (int index$macro$323 = rowByteIndex + this.bandCount; index$macro$323 < limit; ++index$macro$323) {
                    bytes[index$macro$323] = (byte)(bytes[index$macro$323] + bytes[index$macro$323 - this.bandCount]);
                }
                byte[] tmp = (byte[])Array$.MODULE$.ofDim(bytesPerRow, ClassTag$.MODULE$.Byte());
                System.arraycopy(bytes, rowByteIndex, tmp, 0, bytesPerRow);
                for (int index$macro$325 = 0; index$macro$325 < this.colsPerRow * this.bandCount; ++index$macro$325) {
                    for (int index$macro$324 = 0; index$macro$324 < bytesPerSample; ++index$macro$324) {
                        bytes[rowByteIndex + (bytesPerSample * index$macro$325 + index$macro$324)] = tmp[index$macro$324 * this.colsPerRow + index$macro$325];
                    }
                }
            }
            return bytes;
        }

        public FloatingPointPredictor(int colsPerRow, Function1<Object, Object> rowsInSegment, BandType bandType, int bandCount) {
            this.colsPerRow = colsPerRow;
            this.rowsInSegment = rowsInSegment;
            this.bandType = bandType;
            this.bandCount = bandCount;
            this.code = Predictor$.MODULE$.PREDICTOR_FLOATINGPOINT();
            this.checkEndian = false;
        }
    }
}

