/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff.compression;

import geotrellis.raster.io.geotiff.BandType;
import geotrellis.raster.io.geotiff.compression.HorizontalPredictor$;
import geotrellis.raster.io.geotiff.compression.Predictor;
import geotrellis.raster.io.geotiff.compression.Predictor$;
import geotrellis.raster.io.geotiff.reader.MalformedGeoTiffException;
import geotrellis.raster.io.geotiff.tags.TiffTags;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import scala.Function1;
import scala.Function2;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001y;Q!\u0001\u0002\t\u00025\t1\u0003S8sSj|g\u000e^1m!J,G-[2u_JT!a\u0001\u0003\u0002\u0017\r|W\u000e\u001d:fgNLwN\u001c\u0006\u0003\u000b\u0019\tqaZ3pi&4gM\u0003\u0002\b\u0011\u0005\u0011\u0011n\u001c\u0006\u0003\u0013)\taA]1ti\u0016\u0014(\"A\u0006\u0002\u0015\u001d,w\u000e\u001e:fY2L7o\u0001\u0001\u0011\u00059yQ\"\u0001\u0002\u0007\u000bA\u0011\u0001\u0012A\t\u0003'!{'/\u001b>p]R\fG\u000e\u0015:fI&\u001cGo\u001c:\u0014\u0005=\u0011\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g\rC\u0003\u001a\u001f\u0011\u0005!$\u0001\u0004=S:LGO\u0010\u000b\u0002\u001b!)Ad\u0004C\u0001;\u0005)\u0011\r\u001d9msR\u0011a$\t\t\u0003\u001d}I!\u0001\t\u0002\u0003\u0013A\u0013X\rZ5di>\u0014\b\"\u0002\u0012\u001c\u0001\u0004\u0019\u0013\u0001\u0003;jM\u001a$\u0016mZ:\u0011\u0005\u0011:S\"A\u0013\u000b\u0005\u0019\"\u0011\u0001\u0002;bONL!\u0001K\u0013\u0003\u0011QKgM\u001a+bON4A\u0001E\b\u0005UM\u0011\u0011F\u0005\u0005\tY%\u0012\t\u0011)A\u0005[\u0005!1m\u001c7t!\t\u0019b&\u0003\u00020)\t\u0019\u0011J\u001c;\t\u0011EJ#\u0011!Q\u0001\nI\nQB]8xg&s7+Z4nK:$\b\u0003B\n4[5J!\u0001\u000e\u000b\u0003\u0013\u0019+hn\u0019;j_:\f\u0004\u0002\u0003\u001c*\u0005\u0003\u0005\u000b\u0011B\u0017\u0002\u0013\t\fg\u000eZ\"pk:$\b\"B\r*\t\u0003AD\u0003B\u001d<yu\u0002\"AO\u0015\u000e\u0003=AQ\u0001L\u001cA\u00025BQ!M\u001cA\u0002IBQAN\u001cA\u00025BQaP\u0015\u0005\u0002\u0001\u000b1BZ8s\u0005\u0006tG\rV=qKR\u0011a$\u0011\u0005\u0006\u0005z\u0002\raQ\u0001\tE\u0006tG\rV=qKB\u0011A)R\u0007\u0002\t%\u0011a\t\u0002\u0002\t\u0005\u0006tG\rV=qK\")\u0001*\u000bC\u0001\u0013\u00061\u0011\r\u001d9msb\"2A\u0013)S!\r\u00192*T\u0005\u0003\u0019R\u0011Q!\u0011:sCf\u0004\"a\u0005(\n\u0005=#\"\u0001\u0002\"zi\u0016DQ!U$A\u0002)\u000bQAY=uKNDQaU$A\u00025\nAb]3h[\u0016tG/\u00138eKbDQ!V\u0015\u0005\u0002Y\u000bq!\u00199qYf\fd\u0007F\u0002K/bCQ!\u0015+A\u0002)CQa\u0015+A\u00025BQAW\u0015\u0005\u0002m\u000bq!\u00199qYf\u001c$\u0007F\u0002K9vCQ!U-A\u0002)CQaU-A\u00025\u0002")
public final class HorizontalPredictor {
    public static Predictor apply(TiffTags tiffTags) {
        return HorizontalPredictor$.MODULE$.apply(tiffTags);
    }

    public static class HorizontalPredictor {
        private final int cols;
        private final Function1<Object, Object> rowsInSegment;
        private final int bandCount;

        public Predictor forBandType(BandType bandType) {
            Function2 & java.io.Serializable & Serializable intersect;
            int n = bandType.bitsPerSample();
            switch (n) {
                case 8: {
                    intersect = (Function2 & java.io.Serializable & Serializable)(bytes, segmentIndex) -> this.apply8(bytes, BoxesRunTime.unboxToInt((Object)segmentIndex));
                    break;
                }
                case 16: {
                    intersect = (Function2 & java.io.Serializable & Serializable)(bytes, segmentIndex) -> this.apply16(bytes, BoxesRunTime.unboxToInt((Object)segmentIndex));
                    break;
                }
                case 32: {
                    intersect = (Function2 & java.io.Serializable & Serializable)(bytes, segmentIndex) -> this.apply32(bytes, BoxesRunTime.unboxToInt((Object)segmentIndex));
                    break;
                }
                default: {
                    throw new MalformedGeoTiffException(new StringBuilder(71).append("Horizontal differencing \"Predictor\" not supported with ").append(bandType.bitsPerSample()).append(" bits per sample").toString());
                }
            }
            Function2 & java.io.Serializable & Serializable applyFunc = intersect;
            return new Predictor(null, applyFunc){
                private final int code;
                private final boolean checkEndian;
                private final Function2 applyFunc$1;

                public int code() {
                    return this.code;
                }

                public boolean checkEndian() {
                    return this.checkEndian;
                }

                public byte[] apply(byte[] bytes, int segmentIndex) {
                    return (byte[])this.applyFunc$1.apply((Object)bytes, (Object)BoxesRunTime.boxToInteger((int)segmentIndex));
                }
                {
                    this.applyFunc$1 = applyFunc$1;
                    this.code = Predictor$.MODULE$.PREDICTOR_HORIZONTAL();
                    this.checkEndian = true;
                }
            };
        }

        public byte[] apply8(byte[] bytes, int segmentIndex) {
            int rows = this.rowsInSegment.apply$mcII$sp(segmentIndex);
            for (int index$macro$328 = 0; index$macro$328 < rows; ++index$macro$328) {
                int count = this.bandCount * (index$macro$328 * this.cols + 1);
                for (int index$macro$327 = this.bandCount; index$macro$327 < this.cols * this.bandCount && index$macro$327 < bytes.length; ++index$macro$327) {
                    bytes[count] = (byte)(bytes[count] + bytes[count - this.bandCount]);
                    ++count;
                }
            }
            return bytes;
        }

        public byte[] apply16(byte[] bytes, int segmentIndex) {
            ShortBuffer buffer = ByteBuffer.wrap(bytes).asShortBuffer();
            int rows = this.rowsInSegment.apply$mcII$sp(segmentIndex);
            for (int index$macro$330 = 0; index$macro$330 < rows; ++index$macro$330) {
                int count = this.bandCount * (index$macro$330 * this.cols + 1);
                for (int index$macro$329 = this.bandCount; index$macro$329 < this.cols * this.bandCount; ++index$macro$329) {
                    buffer.put(count, (short)(buffer.get(count) + buffer.get(count - this.bandCount)));
                    ++count;
                }
            }
            return bytes;
        }

        public byte[] apply32(byte[] bytes, int segmentIndex) {
            IntBuffer buffer = ByteBuffer.wrap(bytes).asIntBuffer();
            int rows = this.rowsInSegment.apply$mcII$sp(segmentIndex);
            for (int index$macro$332 = 0; index$macro$332 < rows; ++index$macro$332) {
                int count = this.bandCount * (index$macro$332 * this.cols + 1);
                for (int index$macro$331 = this.bandCount; index$macro$331 < this.cols * this.bandCount; ++index$macro$331) {
                    buffer.put(count, buffer.get(count) + buffer.get(count - this.bandCount));
                    ++count;
                }
            }
            return bytes;
        }

        public HorizontalPredictor(int cols, Function1<Object, Object> rowsInSegment, int bandCount) {
            this.cols = cols;
            this.rowsInSegment = rowsInSegment;
            this.bandCount = bandCount;
        }
    }
}

