/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.raster.io.geotiff.compression;

import geotrellis.raster.io.geotiff.compression.Decompressor;
import geotrellis.raster.io.geotiff.compression.JpegDecompressor$;
import geotrellis.raster.io.geotiff.compression.Predictor;
import geotrellis.raster.io.geotiff.compression.YCbCrConverter$;
import geotrellis.raster.io.geotiff.reader.GeoTiffReaderLimitationException;
import geotrellis.raster.io.geotiff.tags.ColimetryTags;
import geotrellis.raster.io.geotiff.tags.JpegTags;
import geotrellis.raster.io.geotiff.tags.TiffTags;
import geotrellis.raster.io.geotiff.tags.YCbCrTags;
import geotrellis.raster.io.geotiff.tags.codes.ColorSpace$;
import geotrellis.raster.io.geotiff.tags.codes.CompressionType$;
import java.awt.image.DataBufferByte;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.nio.ByteOrder;
import java.util.Iterator;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.plugins.jpeg.JPEGImageReadParam;
import javax.imageio.stream.ImageInputStream;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ms!B\u0001\u0003\u0011\u0003i\u0011\u0001\u0005&qK\u001e$UmY8naJ,7o]8s\u0015\t\u0019A!A\u0006d_6\u0004(/Z:tS>t'BA\u0003\u0007\u0003\u001d9Wm\u001c;jM\u001aT!a\u0002\u0005\u0002\u0005%|'BA\u0005\u000b\u0003\u0019\u0011\u0018m\u001d;fe*\t1\"\u0001\u0006hK>$(/\u001a7mSN\u001c\u0001\u0001\u0005\u0002\u000f\u001f5\t!AB\u0003\u0011\u0005!\u0005\u0011C\u0001\tKa\u0016<G)Z2p[B\u0014Xm]:peN\u0019qB\u0005\r\u0011\u0005M1R\"\u0001\u000b\u000b\u0003U\tQa]2bY\u0006L!a\u0006\u000b\u0003\r\u0005s\u0017PU3g!\t\u0019\u0012$\u0003\u0002\u001b)\ta1+\u001a:jC2L'0\u00192mK\")Ad\u0004C\u0001;\u00051A(\u001b8jiz\"\u0012!\u0004\u0005\u0006?=!\t\u0001I\u0001\u0006CB\u0004H.\u001f\u000b\u0004C\u0005m\u0002C\u0001\b#\r\u0011\u0001\"\u0001A\u0012\u0014\u0007\t\u0012B\u0005\u0005\u0002\u000fK%\u0011aE\u0001\u0002\r\t\u0016\u001cw.\u001c9sKN\u001cxN\u001d\u0005\tQ\t\u0012\t\u0011)A\u0005S\u0005AA/\u001b4g)\u0006<7\u000f\u0005\u0002+[5\t1F\u0003\u0002-\t\u0005!A/Y4t\u0013\tq3F\u0001\u0005US\u001a4G+Y4t\u0011\u0015a\"\u0005\"\u00011)\t\t\u0013\u0007C\u0003)_\u0001\u0007\u0011\u0006C\u00044E\t\u0007I\u0011\u0001\u001b\u0002\u0011)\u0004Xm\u001a+bON,\u0012!\u000e\t\u0003UYJ!aN\u0016\u0003\u0011)\u0003Xm\u001a+bONDa!\u000f\u0012!\u0002\u0013)\u0014!\u00036qK\u001e$\u0016mZ:!\u0011\u001dY$E1A\u0005\u0002q\n\u0011\"_\"c\u0007J$\u0016mZ:\u0016\u0003u\u0002\"A\u000b \n\u0005}Z#!C-DE\u000e\u0013H+Y4t\u0011\u0019\t%\u0005)A\u0005{\u0005Q\u0011p\u00112DeR\u000bwm\u001d\u0011\t\u000f\r\u0013#\u0019!C\u0001\t\u0006i1m\u001c7j[\u0016$(/\u001f+bON,\u0012!\u0012\t\u0003U\u0019K!aR\u0016\u0003\u001b\r{G.[7fiJLH+Y4t\u0011\u0019I%\u0005)A\u0005\u000b\u0006q1m\u001c7j[\u0016$(/\u001f+bON\u0004\u0003bB&#\u0005\u0004%\t\u0001T\u0001\u0012a\"|Go\\7fiJL7-\u00138uKJ\u0004X#A'\u0011\u0005Mq\u0015BA(\u0015\u0005\rIe\u000e\u001e\u0005\u0007#\n\u0002\u000b\u0011B'\u0002%ADw\u000e^8nKR\u0014\u0018nY%oi\u0016\u0014\b\u000f\t\u0005\b'\n\u0012\r\u0011\"\u0002U\u0003]\u00195)\u0013*`mA\nt,M0D\u001f\u00163e)S\"J\u000b:#6+F\u0001V!\r\u0019b\u000bW\u0005\u0003/R\u0011Q!\u0011:sCf\u0004\"aE-\n\u0005i#\"A\u0002#pk\ndW\r\u0003\u0004]E\u0001\u0006i!V\u0001\u0019\u0007\u000eK%k\u0018\u001c1c}\u000btlQ(F\r\u001aK5)S#O)N\u0003\u0003b\u00020#\u0005\u0004%)\u0001V\u0001\"%\u00163UIU#O\u0007\u0016{&\tT!D\u0017~;\u0006*\u0013+F?f\u001b5i\u0018#F\r\u0006+F\n\u0016\u0005\u0007A\n\u0002\u000bQB+\u0002EI+e)\u0012*F\u001d\u000e+uL\u0011'B\u0007.{v\u000bS%U\u000b~K6iQ0E\u000b\u001a\u000bU\u000b\u0014+!\u0011\u001d\u0011'E1A\u0005\u0002\r\f!B\u001b9fOR\u000b'\r\\3t+\u0005!\u0007cA\nWKB\u00111CZ\u0005\u0003OR\u0011AAQ=uK\"1\u0011N\tQ\u0001\n\u0011\f1B\u001b9fOR\u000b'\r\\3tA!91N\tb\u0001\n\u0003a\u0017A\u00036qK\u001e\u0014V-\u00193feV\tQ\u000e\u0005\u0002og6\tqN\u0003\u0002qc\u00069\u0011.\\1hK&|'\"\u0001:\u0002\u000b)\fg/\u0019=\n\u0005Q|'aC%nC\u001e,'+Z1eKJDaA\u001e\u0012!\u0002\u0013i\u0017a\u00036qK\u001e\u0014V-\u00193fe\u0002Bq\u0001\u001f\u0012C\u0002\u0013\u0005\u00110A\u0005ka\u0016<\u0007+\u0019:b[V\t!\u0010E\u0002|\u0003\u0003i\u0011\u0001 \u0006\u0003{z\fAA\u001b9fO*\u0011qp\\\u0001\ba2,x-\u001b8t\u0013\r\t\u0019\u0001 \u0002\u0013\u0015B+u)S7bO\u0016\u0014V-\u00193QCJ\fW\u000eC\u0004\u0002\b\t\u0002\u000b\u0011\u0002>\u0002\u0015)\u0004Xm\u001a)be\u0006l\u0007\u0005C\u0004\u0002\f\t\"\t!!\u0004\u0002)%l\u0017mZ3T_V\u00148-\u001a$s_6\u0014\u0015\u0010^3t)\u0011\ty!a\u0007\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'Q1!!\u0006p\u0003\u0019\u0019HO]3b[&!\u0011\u0011DA\n\u0005AIU.Y4f\u0013:\u0004X\u000f^*ue\u0016\fW\u000eC\u0004\u0002\u001e\u0005%\u0001\u0019\u00013\u0002\u000b\tLH/Z:\t\u000f\u0005\u0005\"\u0005\"\u0001\u0002$\u0005qan\u001c:nC2L'0Z-DE\u000e\u0013Hc\u00013\u0002&!9\u0011qEA\u0010\u0001\u0004!\u0017!B1se\u0006L\bBBA\u0016E\u0011\u0005A*\u0001\u0003d_\u0012,\u0007bBA\u0018E\u0011\u0005\u0011\u0011G\u0001\u000bI\u0016\u001cw.\u001c9sKN\u001cH#\u00023\u00024\u0005]\u0002bBA\u001b\u0003[\u0001\r\u0001Z\u0001\bg\u0016<W.\u001a8u\u0011\u001d\tI$!\fA\u00025\u000bAb]3h[\u0016tG/\u00138eKbDQ\u0001\u000b\u0010A\u0002%B\u0011\"a\u0010\u0010\u0003\u0003%I!!\u0011\u0002\u0017I,\u0017\r\u001a*fg>dg/\u001a\u000b\u0003\u0003\u0007\u0002B!!\u0012\u0002P5\u0011\u0011q\t\u0006\u0005\u0003\u0013\nY%\u0001\u0003mC:<'BAA'\u0003\u0011Q\u0017M^1\n\t\u0005E\u0013q\t\u0002\u0007\u001f\nTWm\u0019;")
public class JpegDecompressor
implements Decompressor {
    private final JpegTags jpegTags;
    private final YCbCrTags yCbCrTags;
    private final ColimetryTags colimetryTags;
    private final int photometricInterp;
    private final double[] CCIR_601_1_COEFFICIENTS;
    private final double[] REFERENCE_BLACK_WHITE_YCC_DEFAULT;
    private final byte[] jpegTables;
    private final ImageReader jpegReader;
    private final JPEGImageReadParam jpegParam;

    public static JpegDecompressor apply(TiffTags tiffTags) {
        return JpegDecompressor$.MODULE$.apply(tiffTags);
    }

    @Override
    public int predictorCode() {
        return Decompressor.predictorCode$(this);
    }

    @Override
    public ByteOrder byteOrder() {
        return Decompressor.byteOrder$(this);
    }

    @Override
    public Decompressor flipEndian(int bytesPerFlip) {
        return Decompressor.flipEndian$(this, bytesPerFlip);
    }

    @Override
    public Decompressor withPredictor(Predictor predictor) {
        return Decompressor.withPredictor$(this, predictor);
    }

    public JpegTags jpegTags() {
        return this.jpegTags;
    }

    public YCbCrTags yCbCrTags() {
        return this.yCbCrTags;
    }

    public ColimetryTags colimetryTags() {
        return this.colimetryTags;
    }

    public int photometricInterp() {
        return this.photometricInterp;
    }

    public final double[] CCIR_601_1_COEFFICIENTS() {
        return this.CCIR_601_1_COEFFICIENTS;
    }

    public final double[] REFERENCE_BLACK_WHITE_YCC_DEFAULT() {
        return this.REFERENCE_BLACK_WHITE_YCC_DEFAULT;
    }

    public byte[] jpegTables() {
        return this.jpegTables;
    }

    public ImageReader jpegReader() {
        return this.jpegReader;
    }

    public JPEGImageReadParam jpegParam() {
        return this.jpegParam;
    }

    public ImageInputStream imageSourceFromBytes(byte[] bytes) {
        return ImageIO.createImageInputStream(new ByteArrayInputStream(bytes));
    }

    public byte[] normalizeYCbCr(byte[] array) {
        double[] coefficients = (double[])this.yCbCrTags().yCbCrCoefficients().map((Function1 & Serializable & scala.Serializable)rationals -> (double[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rationals)).map((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToDouble((double)JpegDecompressor.$anonfun$normalizeYCbCr$2(x0$1)), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.CCIR_601_1_COEFFICIENTS());
        double[] referenceBW = (double[])this.colimetryTags().referenceBlackWhite().map((Function1 & Serializable & scala.Serializable)v -> (double[])new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(v)).map((Function1)(JFunction1.mcDJ.sp & Serializable & scala.Serializable)x$1 -> x$1, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Double()))).getOrElse((Function0 & Serializable & scala.Serializable)() -> this.REFERENCE_BLACK_WHITE_YCC_DEFAULT());
        for (int index$macro$333 = 0; index$macro$333 < array.length; index$macro$333 += 3) {
            YCbCrConverter$.MODULE$.convertYCbCr2RGB(array, array, coefficients, referenceBW, index$macro$333);
        }
        return array;
    }

    @Override
    public int code() {
        return CompressionType$.MODULE$.JpegCoded();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] decompress(byte[] segment, int segmentIndex) {
        void var3_3;
        this.jpegReader().setInput(this.imageSourceFromBytes(segment));
        byte[] result = ((DataBufferByte)this.jpegReader().readRaster(0, this.jpegParam()).getDataBuffer()).getData();
        return (byte[])(this.photometricInterp() == ColorSpace$.MODULE$.YCbCr() ? this.normalizeYCbCr(result) : var3_3);
    }

    public static final /* synthetic */ double $anonfun$normalizeYCbCr$2(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long a = tuple2._1$mcJ$sp();
        long b = tuple2._2$mcJ$sp();
        double d = (double)a / (double)b;
        return d;
    }

    public JpegDecompressor(TiffTags tiffTags) {
        Decompressor.$init$(this);
        this.jpegTags = tiffTags.jpegTags();
        this.yCbCrTags = tiffTags.yCbCrTags();
        this.colimetryTags = tiffTags.colimetryTags();
        this.photometricInterp = tiffTags.basicTags().photometricInterp();
        this.CCIR_601_1_COEFFICIENTS = new double[]{0.299, 0.587, 0.114};
        this.REFERENCE_BLACK_WHITE_YCC_DEFAULT = (double[])Array$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 255.0, 128.0, 255.0, 128.0, 255.0}), ClassTag$.MODULE$.Double());
        this.jpegTables = (byte[])this.jpegTags().jpegTables().getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            String msg = "compression type JPEG is not supported by this reader if JPEG Tables tag is not set.";
            throw new GeoTiffReaderLimitationException(msg);
        });
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("JPEG");
        if (!readers.hasNext()) {
            throw new IIOException("Could not instantiate JPEGImageReader");
        }
        this.jpegReader = readers.next();
        this.jpegReader().setInput(this.imageSourceFromBytes(this.jpegTables()));
        this.jpegReader().getStreamMetadata();
        this.jpegParam = (JPEGImageReadParam)this.jpegReader().getDefaultReadParam();
        this.jpegParam().setSourceSubsampling(1, 1, 0, 0);
    }
}

